# DFT_Python_1.4.0.py
# Barry Walker, G0LCU.
#
# Simple RADIX 2, DFT, (Discrete Fourier Transform), for Python Versions 1.4.0 to 3.10.4 on _ALL_ platforms.
#
# Requirements:
# 1) Standard A1200(HD), AMIGA OS3.0.x, (HDD).
# 2) Python 1.4.0, absolute minimum, full install on AMINET.
# https://aminet.net/package/dev/lang/Python_14
#
# Checked on:
# A stock or expanded AMIGA A1200(HD), OS3.0x using Python 1.4.0 and 2.0.1.
# FS-UAE using AMIGA OS3.1x, using Python 1.4.0 to 2.0.1.
# A Macbook Pro, OSX 10.15.7, Python, 2.7.x, 3.5.x, 3.8.x, 3.9.x and 3.10.4.
# A Linux Mint 21.2 machine with Python 2.7.x or 3.8.x.
# NOT tested on Windows or WinUAE but will more than likely work.

import sys
import math

def Discrete_Fourier_Transform(REAL_IN, IMAG_IN):
	N=len(REAL_IN)
	if N<=1: return REAL_IN
	if N&(N-1)!=0:
		print("")
		print("Power of 2 ERROR!")
		print("Padding or cropping is required to the nearest power of 2 elements.")
		print("Exiting with a return code of 1...")
		print("")
		sys.exit(1)
	REAL_OUT=[]
	IMAG_OUT=[]
	RESULT=[]
	for K in range(0,N,1):
		REAL=0.0
		IMAG=0.0
		for ELEMENT in range(0,N,1):
			RADIAN=((2*math.pi*K*ELEMENT)/(int(N)))
			REAL=REAL+REAL_IN[ELEMENT]*math.cos(RADIAN)+IMAG_IN[ELEMENT]*math.sin(RADIAN)
			IMAG=IMAG-REAL_IN[ELEMENT]*math.sin(RADIAN)+IMAG_IN[ELEMENT]*math.cos(RADIAN)
		REAL_OUT.append(REAL)
		IMAG_OUT.append(IMAG)
		RESULT.append(complex((REAL_OUT[K])+(IMAG_OUT[K]*1j)))
	return RESULT

# ************************************************
# ********* For Python 1.4.0 to 3.10.4. **********
# ***** Access a file and convert to a list. *****
# ************************************************
# Uncomment the code in this section for file creation and access.
# Comment out any other 'REAL_LIST' variable line.
#
#VER=int(eval(sys.version[0]))
#if VER<=2: import string
#
# Variable "WAVEFORM" is an actual REAL piece of data, 64 samples, padded with 128 for the last 5 places.
# The 128 values represent the centreline of an audio recording at unsigned 8 bit depth.
#
#WAVEFORM="195,152,25,0,49,199,241,182,192,84,0,19,91,234,227,195,171,32,11,37,140,255,217,206,121,6,32,54,166,255,225,198,53,12,54,83,222,249,221,155,21,29,54,110,242,241,213,103,0,47,52,144,254,233,190,51,8,57,65,128,128,128,128,128"
#
#My_DATA_File=open("DFT_data.txt","w")
#My_DATA_File.write(WAVEFORM)
#My_DATA_File.close()
#
# Get data from a file and put into a _variable_.
#
#DFT_data_str=open('DFT_data.txt','r').read()
#open('DFT_data.txt','r').close()
#
# Convert to string representations of floats in a list.
#
#if VER<=2: Str_List=string.split(DFT_data_str,",")
#if VER>=3: Str_List=DFT_data_str.split(",")
#
# Convert strings to floats, from 0.0 to 255.0.
#
# Comment out any other 'REAL_LIST' variable line and uncomment this one.
#REAL_LIST=[]
#for number in range(0,len(Str_List),1):
#	if VER<=2: floatlist=string.atof(Str_List[number])
#	if VER>=3: floatlist=float(Str_List[number])
#	REAL_LIST.append(floatlist)
#
# Put all values from 0.0 to 255.0 between 0.0 to 1.0, IF REQUIRED!
#
#for number in range(0,len(REAL_LIST),1): REAL_LIST[number]=REAL_LIST[number]/255.0
#
# ************** END of file access **************
# ************************************************


# ************************************************
# ************* Just extras for fun. *************
# ************************************************
# These listings are other DEMO ones for testing.
#
# Padded with trailing 0.0(s) to make up a power of 2 DATA size, (16 samples).
#REAL_LIST=[1.0, 1.0, 1.0, 1.0, 1.0, 1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 1.0, 0.0, 0.0, 0.0]
#
# A perfect frequency to power of 2 sample size, (16 samples).
#REAL_LIST=[1.0, 1.0, 1.0, 1.0, -1.0, -1.0, -1.0, -1.0, 1.0, 1.0, 1.0, 1.0, -1.0, -1.0, -1.0, -1.0]
#
# ************** END of other DEMOs. *************
# ************************************************


# Comment out this REAL_LIST to try out the file access version...
# DEFAULT, positive going only, 0.5 used as centre padding.
REAL_LIST=[1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.5, 0.5, 0.5]
#
# [(8.5+0j), (3.6378211867292967-1.9307144055427479j), (-1.7071067811865481-0.4999999999999997j),
# (0.05142521051216836-0.24146800830128096j), (1.4999999999999982-0.9999999999999996j),
# (-0.1727455540718155+0.4656387728852641j), (-0.2928932188134558+0.49999999999999634j),
# (0.4834991568303488-1.223607624356201j), (0.5+2.449293598294707e-16j),
# (0.4834991568303442+1.2236076243561986j), (-0.292893218813455-0.5000000000000071j),
# (-0.17274555407180975-0.4656387728852707j), (1.5000000000000067+1.000000000000003j),
# (0.05142521051217111+0.2414680083012838j), (-1.7071067811865417+0.5000000000000074j),
# (3.637821186729289+1.93071440554275j)]
#
# 8.50000 4.11842 1.77882 0.24688 1.80278 0.49665 0.57947 1.31567
# 0.50000 1.31567 0.57947 0.49665 1.80278 0.24688 1.77882 4.11842
#
# |*************************************************************
# |**************************
# |***
# |***************************
# |*******
# |********
# |*******************
# |*******
# |*******************
# |********
# |*******
# |***************************
# |***
# |**************************
# |*************************************************************
#
# End of DEFAULT positive going, using 0.5 as centre padding

# Call the Discrete_Fourier_Transform function.
print("")
print("Doing the Fourier Transform now, please wait...")
N=len(REAL_LIST)
IMAG_LIST=[0.0]*N
DFT=Discrete_Fourier_Transform(REAL_LIST, IMAG_LIST)

print("")
print("Complex pair listing...")
print("Number of DATA elements = "+str(len(DFT))+"...")
print(DFT)
print("")

print("Absolute floating point values...")
for REAL_LISTING in range(0,len(DFT),1):
	ABSOLUTE=abs(DFT[REAL_LISTING])
	sys.stdout.write("%.5f" %(ABSOLUTE)+" ")
print("")
print("")

print("Quick text mode uncalibrated spectrum display...")
for REAL_LISTING in range(1,len(DFT),1):
	# Change the MULTIPLIER to suit each REAL_LIST...
	# MULTIPLIER - 6.0 for the file access mode...
	MULTIPLIER=15.0
	CHAR='# |'
	HORIZ=(int(MULTIPLIER*(abs(DFT[REAL_LISTING]))))
	for DISPLAY in range(1,(HORIZ+1),1):
		CHAR=CHAR+'*'
	print(CHAR)
print("")

sys.exit(0)

# *************** Display for the file access method only... ***************
# Complex pair listing for the file access mode...
# [(31.427450980392145+0j), (-1.0466369566984035-0.23974893280574677j),
# (-0.3910554351016603-0.5218357559574675j), (-0.07905636739868765-0.40593199318308915j),
# (0.23010513414549355-0.502649830764147j), (0.4343245242302084+0.029210374820244356j),
# (0.688025460414166+0.6011028898294962j), (0.25953410212988476+2.229434414619388j),
# (-4.112165348347279+10.964476409546872j), (4.374451880796121-5.56302203429518j),
# (2.297533014115146-1.73970489262411j), (1.738194602986175-0.8057164909986745j),
# (1.136114944722283-0.12430004172195802j), (0.9377538544609682-0.1642569748525563j),
# (0.3903147807595408-0.03828910849917816j), (0.5055441369170821-0.3253783679451609j),
# (0.3843137254901849-1.6470588235294232j), (0.1822723493095936-1.2525559334934901j),
# (-0.46450166794149156+0.16484749968442164j), (0.008464643464172167+0.11578309960329236j),
# (-0.06078885530381084-0.050761576314136636j), (0.14106363109857092+0.12460130428741223j),
# (0.12805142852210194+0.09530969780686621j), (0.07597081417615581+0.2101404109755447j),
# (-0.0525405340056348+0.2272215075860629j), (1.440789268250162-2.480676321941337j),
# (-0.10888365125189226+0.18675325093235362j), (0.0009343901916665787+0.12610145372584408j),
# (-0.09758808630902388+0.16696706601623404j), (-0.013434363231339508-0.023841745476959497j),
# (-0.12379765500618722+0.06723074054503093j), (-0.05036658911372738+0.014688974150986453j),
# (0.007843137254901711+4.0824608210442183e-14j), (-0.050366589113743976-0.014688974151007929j),
# (-0.12379765500617779-0.06723074054502602j), (-0.013434363231334678+0.023841745477029525j),
# (-0.09758808630910842-0.16696706601621622j), (0.0009343901916367692-0.1261014537258909j),
# (-0.10888365125184613-0.18675325093231826j), (1.4407892682501653+2.4806763219414556j),
# (-0.05254053400574599-0.22722150758609483j), (0.07597081417615581-0.21014041097556352j),
# (0.12805142852208024-0.09530969780684484j), (0.14106363109857653-0.12460130428747379j),
# (-0.060788855303731015+0.05076157631411782j), (0.008464643464201893-0.11578309960322292j),
# (-0.46450166794152864-0.1648474996843693j), (0.18227234930962372+1.2525559334935623j),
# (0.38431372549020837+1.6470588235293877j), (0.5055441369170344+0.32537836794511743j),
# (0.3903147807595577+0.03828910849920042j), (0.9377538544609196+0.16425697485261287j),
# (1.136114944722259+0.12430004172189751j), (1.7381946029861723+0.8057164909985954j),
# (2.2975330141151353+1.7397048926241179j), (4.374451880795995+5.563022034295141j),
# (-4.112165348347144-10.96447640954687j), (0.25953410212992994-2.229434414619423j),
# (0.688025460414143-0.6011028898295919j), (0.4343245242302307-0.029210374820219542j),
# (0.23010513414552103+0.5026498307641095j), (-0.07905636739860444+0.4059319931831249j),
# (-0.39105543510166707+0.5218357559574677j), (-1.046636956698289+0.23974893280570675j)]
#
# Absolute floating point values for the file access mode...
# 31.42745 1.07375 0.65210 0.41356 0.55282 0.43531 0.91362 2.24449 11.71024 7.07694
# 2.88188 1.91585 1.14289 0.95203 0.39219 0.60120 1.69130 1.26575 0.49289 0.11609
# 0.07920 0.18821 0.15963 0.22345 0.23322 2.86873 0.21618 0.12610 0.19339 0.02737
# 0.14088 0.05246 0.00784 0.05246 0.14088 0.02737 0.19339 0.12610 0.21618 2.86873
# 0.23322 0.22345 0.15963 0.18821 0.07920 0.11609 0.49289 1.26575 1.69130 0.60120
# 0.39219 0.95203 1.14289 1.91585 2.88188 7.07694 11.71024 2.24449 0.91362 0.43531
# 0.55282 0.41356 0.65210 1.07375 
#
# Quick text mode uncalibrated spectrum display for the file access mode...
#
# |******
# |***
# |**
# |***
# |**
# |*****
# |*************
# |**********************************************************************
# |******************************************
# |*****************
# |***********
# |******
# |*****
# |**
# |***
# |**********
# |*******
# |**
# |
# |
# |*
# |
# |*
# |*
# |*****************
# |*
# |
# |*
# |
# |
# |
# |
# |
# |
# |
# |*
# |
# |*
# |*****************
# |*
# |*
# |
# |*
# |
# |
# |**
# |*******
# |**********
# |***
# |**
# |*****
# |******
# |***********
# |*****************
# |******************************************
# |**********************************************************************
# |*************
# |*****
# |**
# |***
# |**
# |***
# |******
#
# ************* Display for the file access method only END... *************

