# FFT_Perl.pl
#
# Source:-
# http://www.rosettacode.org/wiki/Fast_Fourier_transform#Perl
# Author[s] unknown, date of creation unknown.
# Copyright assumed to be CC0, Public Domain.
# Current known _owner_, <http://www.rosettacode.org>.
#
# ***********************************************************
# (AMIGA environmemt, stock A1200(HD) with 4MB FastRAM.)
# Highly expanded AMIGA, 68030, HDD and lots of RAM recommended.
# FS-UAE Running AMIGA OS 3.0.x.
# Perl 5.7.1 installation available from:-
# http://aminet.net/package/dev/gg/perl571
# This is perl, v5.7.1 built for m68k-amigaos
#
# Copyright 1987-2001, Larry Wall
#
# Perl may be copied only under the terms of either the Artistic License or the
# GNU General Public License, which may be found in the Perl 5 source kit.
#
# Complete documentation for Perl, including FAQ lists, should be found on
# this system using `man perl' or `perldoc perl'.  If you have access to the
# Internet, point your browser at http://www.perl.com/, the Perl Home Page.
# ***********************************************************
# ***********************************************************
# Linux Mint 20.3.
# This is perl 5, version 30, subversion 0 (v5.30.0) built for x86_64-linux-gnu-thread-multi
# (with 50 registered patches, see perl -V for more detail)
#
# Copyright 1987-2019, Larry Wall
#
# Perl may be copied only under the terms of either the Artistic License or the
# GNU General Public License, which may be found in the Perl 5 source kit.
#
# Complete documentation for Perl, including FAQ lists, should be found on
# this system using "man perl" or "perldoc perl".  If you have access to the
# Internet, point your browser at http://www.perl.org/, the Perl Home Page.
# ***********************************************************
# ***********************************************************
# Apple OSX 10.15.7.
# This is perl 5, version 18, subversion 4 (v5.18.4) built for
# darwin-thread-multi-2level
# (with 2 registered patches, see perl -V for more detail)
#
# Copyright 1987-2013, Larry Wall
#
# Perl may be copied only under the terms of either the Artistic License or the
# GNU General Public License, which may be found in the Perl 5 source kit.
#
# Complete documentation for Perl, including FAQ lists, should be found on
# this system using "man perl" or "perldoc perl".  If you have access to the
# Internet, point your browser at http://www.perl.org/, the Perl Home Page.
# ***********************************************************

use strict;
use warnings;
use Math::Complex;
 
sub fft
{
    return @_ if @_ == 1;
    my @evn = fft(@_[grep { not $_ % 2 } 0 .. $#_ ]);
    my @odd = fft(@_[grep { $_ % 2 } 1 .. $#_ ]);
    my $twd = 2*i* pi / @_;
    $odd[$_] *= exp( $_ * -$twd ) for 0 .. $#odd;
    return
    (map { $evn[$_] + $odd[$_] } 0 .. $#evn ),
    (map { $evn[$_] - $odd[$_] } 0 .. $#evn );
}
 
print "($_)\n" for fft qw(1 1 1 1 1 1 0 0 0 0 0 0 1 0.5 0.5 0.5);

# Reaults:-
# (8.5)
# (3.6378211867293-1.93071440554275i)
# (-1.70710678118655-0.5i)
# (0.05142521051217-0.241468008301283i)
# (1.5-i)
# (-0.172745554071813+0.465638772885265i)
# (-0.292893218813453+0.5i)
# (0.483499156830347-1.2236076243562i)
# (0.5)
# (0.483499156830346+1.2236076243562i)
# (-0.292893218813453-0.5i)
# (-0.172745554071812-0.465638772885265i)
# (1.5+i)
# (0.0514252105121699+0.241468008301282i)
# (-1.70710678118655+0.5i)
# (3.6378211867293+1.93071440554275i)

