# DFT_MATH.pl
#
# Author: B.Walker (G0LCU).
# Issue date: 25-05-2022.
# Issued as Creative Commons CC0; Public Domain. Distribution AMINET.

# Discrete Fourier Transform in Perl.
# **************************************************************************
# (AMIGA environmemt, stock A1200(HD) with 4MB FastRAM.)
# Highly expanded AMIGA, 68030, HDD and lots of RAM recommended.
# FS-UAE Running AMIGA OS 3.0.x.
# Perl 5.7.1 installation available from:-
# http://aminet.net/package/dev/gg/perl571
# This is perl, v5.7.1 built for m68k-amigaos
#
# Copyright 1987-2001, Larry Wall
#
# Perl may be copied only under the terms of either the Artistic License or the
# GNU General Public License, which may be found in the Perl 5 source kit.
#
# Complete documentation for Perl, including FAQ lists, should be found on
# this system using `man perl' or `perldoc perl'.  If you have access to the
# Internet, point your browser at http://www.perl.com/, the Perl Home Page.
# **************************************************************************
# **************************************************************************
# Linux Mint 20.3.
# This is perl 5, version 30, subversion 0 (v5.30.0) built for x86_64-linux-gnu-thread-multi
# (with 50 registered patches, see perl -V for more detail)
#
# Copyright 1987-2019, Larry Wall
#
# Perl may be copied only under the terms of either the Artistic License or the
# GNU General Public License, which may be found in the Perl 5 source kit.
#
# Complete documentation for Perl, including FAQ lists, should be found on
# this system using "man perl" or "perldoc perl".  If you have access to the
# Internet, point your browser at http://www.perl.org/, the Perl Home Page.
# **************************************************************************
# **************************************************************************
# Apple OSX 10.15.7.
# This is perl 5, version 18, subversion 4 (v5.18.4) built for
# darwin-thread-multi-2level
# (with 2 registered patches, see perl -V for more detail)
#
# Copyright 1987-2013, Larry Wall
#
# Perl may be copied only under the terms of either the Artistic License or the
# GNU General Public License, which may be found in the Perl 5 source kit.
#
# Complete documentation for Perl, including FAQ lists, should be found on
# this system using "man perl" or "perldoc perl".  If you have access to the
# Internet, point your browser at http://www.perl.org/, the Perl Home Page.
# **************************************************************************

use warnings;
use strict;

my @IN_REAL=(1.0,1.0,1.0,1.0,1.0,1.0,0.0,0.0,0.0,0.0,0.0,0.0,1.0,0.5,0.5,0.5);
my @IN_IMAG=(0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0);
my @OUT_REAL=();
my @OUT_IMAG=();
my @COMPLEX=();
my @ABSOLUTE=();
my $N=0;
my $K=0;
my $REAL=0.0;
my $IMAG=0.0;
my $RADIAN=0.0;
my $ELEMENT=0;
# Set PI to 10 decimal places...
my $PI=3.1415926535;

# ********************** Discrete Fourier Transform. ***********************
sub Discrete_Fourier_Transform
{
	$N=@IN_REAL;
	if($N <= 1)
	{
		return @IN_REAL;
	}
	for $K(0..($N-1))
	{
		$REAL=0.0;
		$IMAG=0.0;
		for $ELEMENT(0..($N-1))
		{
			$RADIAN=((2*$PI*$K*$ELEMENT)/($N));
			$REAL=$REAL+$IN_REAL[$ELEMENT]*cos($RADIAN)+$IN_IMAG[$ELEMENT]*sin($RADIAN);
			$IMAG=$IMAG-$IN_REAL[$ELEMENT]*sin($RADIAN)+$IN_IMAG[$ELEMENT]*cos($RADIAN);
		}
		$OUT_REAL[$K]=$REAL;
		$OUT_IMAG[$K]=$IMAG;
		$ABSOLUTE[$K]=sqrt(abs(($REAL**2)+($IMAG**2)));
		$COMPLEX[$K]="($OUT_REAL[$K])+($OUT_IMAG[$K]i)\n";
	}
	return @COMPLEX, @ABSOLUTE;
}
# ******************** Discrete Fourier Transform end. *********************

# ****************** Print the results to the screen... ********************
print "Discrete Fourier Transform absolute values:\n";
print "-------------------------------------------\n";
Discrete_Fourier_Transform(@IN_REAL+@IN_IMAG);
for $K(0..($N-1))
{
	# Round to 5 decimal places.
	printf " %.5f", $ABSOLUTE[$K];
}
print "\n\nDiscrete Fourier Transform:\n---------------------------\n";
print " @COMPLEX";
# ******************************** END! ************************************

# What to expect...
# **************************************************************************
#
#Discrete Fourier Transform absolute values:
#-------------------------------------------
# 8.50000 4.11842 1.77882 0.24688 1.80278 0.49665 0.57947 1.31567 0.50000
# 1.31567 0.57947 0.49665 1.80278 0.24688 1.77882 4.11842
#
#Discrete Fourier Transform:
#---------------------------
# (8.5)+(0i)
# (3.63782118658746)+(-1.93071440536385i)
# (-1.70710678153689)+(-0.500000000454413i)
# (0.0514252104409618)+(-0.241468008546034i)
# (1.50000000008979)+(-0.999999999685723i)
# (-0.172745554691592)+(0.465638772578884i)
# (-0.292893219191028)+(0.4999999992082i)
# (0.483499157650128)+(-1.22360762460849i)
# (0.5)+(1.79584592322207e-10i)
# (0.483499155776338)+(1.22360762403182i)
# (-0.29289321818416)+(-0.500000001319661i)
# (-0.172745552708294)+(-0.465638773559299i)
# (1.49999999973062)+(1.00000000094283i)
# (0.0514252108207409)+(0.241468007240688i)
# (-1.70710677873416)+(0.499999996819122i)
# (3.63782118885691)+(1.93071440822627i)#
# **************************************************************************

