10 REM DFT_BWBasic.bas
20 REM Author:- B.Walker, G0LCU, issued as CC0, Public Domain.
30 REM https://aminet.net/package/dev/lang/bwbasic111
40 REM This is AMIGA Bywater Basic specific.
50 REM *******************************************
60 REM N are the array sizes, in powers of 2; e$ is the escape character.
70 N=8
80 e$=CHR$(27)
90 REM *******************************************
100 REM Clear the screen.
110 PRINT e$;"c";
120 REM ******************************************
130 REM Discrete Fourier Transform in BWBasic.
140 REM Set up the arrays.
150 DIM R(N)
160 DIM I(N)
170 REM Input REAL array.
180 R(0)=1.0
190 R(1)=1.0
200 R(2)=1.0
210 R(3)=1.0
220 R(4)=0.0
230 R(5)=0.0
240 R(6)=0.0
250 R(7)=0.0
260 REM Input IMAGINARY array.
270 I(0)=0.0
280 I(1)=0.0
290 I(2)=0.0
300 I(3)=0.0
310 I(4)=0.0
320 I(5)=0.0
330 I(6)=0.0
340 I(7)=0.0
350 REM Output REAL array.
360 DIM r(N)
370 REM Output IMAGINARY array.
380 DIM i(N)
390 REM ******************************************
400 REM Display the input arrays.
410 PRINT ""
420 PRINT "     Display REAL  and  IMAGINARY input pairs:-"
430 FOR n=0 TO (N-1) STEP 1
440 	PRINT "",R(n),"	";I(n)
450 NEXT n
460 REM ******************************************
470 PRINT ""
480 PRINT "     Calculating COMPLEX REAL and IMAGINARY pairs..."
490 REM Call the DFT routine.
500 GOSUB 790
510 REM ******************************************
520 REM Finally print out the ABSOLUTE values.
530 PRINT ""
540 PRINT "     And finally the absolute values of the COMPLEX pairs:-"
550 PRINT ""
560 FOR n=0 TO (N-1) STEP 1
570	a=(r(n)*r(n))+(i(n)*i(n))
580	PRINT USING "##.#####";SQR(a);
590 NEXT n
600 PRINT ""
610 REM ******************************************
620 REM Exit the program.
630 SYSTEM
640 REM ******************************************
650 REM
660 REM ****** Discrete Fourier Transform. *******
670 REM K is an integer _pointer_ to each r() and i() arrays.
680 REM E is an integer _pointer_ to each ELEMENT in the R() snd I() arrays.
690 REM N is the length of the arrays.
700 REM P is the constant pi.
710 REM R() is the REAL input array.
720 REM I() is the IMAGINARY input array.
730 REM S is SUMREAL.
740 REM s is SUMIMAG.
750 REM A is the ANGLE in radians.
760 REM r() is the REAl output array.
770 REM i() is the IMAGINARY output array.
780 REM *************** DFT start. ***************
790 P=3.1415927
800 FOR K=0 TO (N-1) STEP 1
810	S=0.0
820	s=0.0
830		FOR E=0 TO (N-1) STEP 1
840			A=(2.0*P*E*K)/(N)
850			S=S+(R(E)*COS(A))+(I(E)*SIN(A))
860			s=s-(R(E)*SIN(A))+(I(E)*COS(A))
870		NEXT E
880	r(K)=S
890	i(K)=s
900 NEXT K
910 RETURN
920 REM **************** DFT end. ****************
930 REM
940 REM Compare with these values...
950 REM 4.00000 2.61313 0.00000 1.08239 0.00000 1.08239 0.00000 2.61313
960 REM
970 REM ******************************************

