MODULE m2l;
(*$ LargeVars:=FALSE StackParms:=FALSE Volatile:=FALSE StackChk:=FALSE *)
(*
 * 8.5.90/bp
 * 306 Zeilen, fast alles fertig, bis auf den Rest, haha!
 * geht davon aus, da das Obj-File ganz ok ist!
 *
 * festgelegte Linker-Symbole fr Resident-Progs:
 * _BSSBAS: abs Label fr LEA
 * _BSSLEN: abs value in Langworten
 * _LinkerDB: abs Label fr LEA entweder an Anf oder 32K spter!
 * _RESBASE: 0 oder 32K
 * _RESLEN: Gesamtlnge des __Mergedhunks in Byte
 * _NEWDATAL: Lnge der DATA darin (also ohne BSS) in Langworten
 *
 * 13.5.90/bp 1085 Zeilen
 * Er luft! Fehlt noch:
 *  Startup sollte Arts.obj heien! fr reentrant RArts.obj
 *  r heit reentrant, x heit ohne Debug??
 * DataRelocs bei NEWDATAL fr reentrant!
 *   Nach den Daten mu kommen:
 *   Anzahl Langworte, also mindestens eine 0.L !!
 *   x Langworte wie Reloc auf EIGENEN Hunk
 *   Ich schreibe momentan immer eine 0
 * ALVs !!! Noch nicht unbedingt so wichtig! Nur fr den Compiler und
 *          den knnen wir mit Blink linken!
 *
 * Das ist nun doch etwas komplizierter geworden, als ich zuerst dachte!
 *
 * 16.6.90/bp 1493 Zeilen
 * Alles(?) klar
 * ALVs werden richtig erzeugt. Es wird aber NICHT berprft, ob das auch
 * in Ordnung ist! Ein LEA d16(PC) kann z.B. MEIST NICHT ber ein ALV gehen!
 *
 * 11.7.92/bp
 * Wenn er in einem Assembler-Modul kein Symbol fand, geriet er in
 * eine Endlosschleife.
 * 9.8.92/bp
 * Neue Option p: +: generiere MapFile (unsortiert, kann mirt sort...)
 * 7.9.92/bp
 * map noch mal schoener gemacht
 *)

FROM SYSTEM	IMPORT	ASSEMBLE, CAST, ADR, ADDRESS, LONGSET, SETREG;
FROM Arts	IMPORT	ModName, BreakPoint,Assert, returnVal,programName,
			thisTask,dosCmdBuf,wbStarted;
FROM Call	IMPORT	Call,Return;
FROM Break	IMPORT	TestBreak;
FROM FullArgHandler IMPORT interActive,verbose,myCD,InitHandler,GotoDir,FetchName,
			fName,fNameLen,SetReply,defaultSize;
FROM ReplyVals	IMPORT	rcActionErr,rcMainNotFound,rcImportantNotFound,rcIllOpt;
FROM M2File	IMPORT	FileType, GetFileName,GetInputFile,ReadPathTable,
			ForgetPathTable,pathFileName,GetObj,FreeObj;
FROM String	IMPORT	Length,Compare,Copy,Concat,FirstPos;
FROM Terminal	IMPORT	WriteString, WriteLn, FormatS, FormatNr, Write, Read,
			waitCloseGadget,Format,ReadLn,Flush;
IMPORT InOut;
FROM DebugDef	IMPORT	ModuleInfo,ModuleInfo2,DebugInfoPtr, DebugInfo2Ptr, CPUType;
FROM MLinkBase	IMPORT	SymName, NameRecPtr, ALLOCATE, ForgetMem, Diff,
			InitSer, GetLong, SkipBlock, eof, MemPtr,
			FileErrors, GetFile, ExtractModuleName,
			OpenSeqOut, CloseSeqOut, OutL, OutCount, SeqOutOk;
FROM ExecSupport IMPORT NewList;
FROM Heap	IMPORT	Allocate,Deallocate;
FROM ExecL	IMPORT	Remove,AddTail;
IMPORT DosD,DosL,ASCII;
FROM AMScan	IMPORT	ScanString;
FROM M2Amiga	IMPORT	MakeIcon,ObjFilePtr,ObjExists,Exists,ExistsResult;
FROM Cio	IMPORT	sprintf;

CONST

  version="4";
  revision="4";
  date=COMPILEDATE;

  verDollar="$VER: m2l "+version+"."+revision+" "+date;
  JumpConst=0100111011111001L; (* JMP absL *)
  NopConst=4E71H;

  maxALVs=256; (* hchstens 256 ALVs pro Hunk! *)
  maxLwLen=(8000H-maxALVs*6) DIV 4;
  Empty='';
  rexxStr="LINK ";
  portName="M2L";
  inMsg="(%s) m2l> ";
  title1="m2l";
  title2="Amiga Modula-2 Linker";
  vers=", "+version+"."+revision+"d, "+date+"\n";
  usage="Aufruf:\n %s {+-012348acdimpqrx -lLibFile -sStack -tTargetFile ? ?? ObjectFile}\n";
  noSuchFile=": nicht gefunden\n";
  exit=" --- ende\n";

  (* Fr Object-Files: *)
  hunkUnit=999;
  hunkName=1000;
  hunkCode=1001;     hunkData=1002;     hunkBSS=1003;

  hunkReloc32=1004;  hunkReloc16=1005;  hunkReloc8=1006;
  (* blink neu fr datareloc: *)
  hunkDReloc32=1015; hunkDReloc16=1016; hunkDReloc8=1017;

  hunkExt=1007;
    (* SHORTCARDs, je SHL 24! *)
    extSymb=0; extDef=1; extAbs=2; extRes=3;
    extCommon=130;
    extRef32=129;   extRef16=131;   extRef8=132;
    (* blink neu fr datareloc-refs: *)
    extDRel32=133;  extDRel16=134;  extDRel8=135;

  hunkSymbol=1008; hunkDebug=1009;
  hunkEnd=1010;

  (* Fr Load-Files: *)
  hunkHeader=1011;
  hunkOverlay=1013; hunkBreak=1014; (* Will ich nicht! *)

  (* blink neu fr Link-Libraries: *)
  libHunk=1018; libIndex=1019;

  (* spezielle Konstanten: *)

  chipMemBit = 30;
  fastMemBit = 31;

TYPE
  LoadTypes=(gf,gi,none);
  BytePtr = POINTER TO SHORTINT;
  WordPtr = POINTER TO INTEGER;
  LongPtr = POINTER TO LONGINT;
  TrickPtr = POINTER TO RECORD
    CASE :INTEGER OF
    |0: barr: SHORTINT;
    |1: warr: INTEGER;
    |2: larr: LONGINT;
    END
  END;

  RelocEntryPtr=POINTER TO RelocEntry;
  RelocEntry=RECORD
    next: RelocEntryPtr; (* wg. Trick genau an Offset 0 lassen! *)
    hunk:LONGINT;
    offset: LONGINT;
  END;

  WidType=(byte,word,long);
  SymTypes = (rel, abs, datarel);

  SymbolPtr = POINTER TO Symbol;
  ModulePtr = POINTER TO Module;
  HunkDescPtr = POINTER TO HunkDesc;
  WriteHunkPtr = POINTER TO WriteHunk;
  Module= RECORD
    succ,pred: ModulePtr;
    name: ModName;
    addr: ADDRESS; (* wohin geladen? *)
    len:  LONGINT; (* wieviel Speicher = FileLnge? *)
    firstCode,
    bss,
    ini: HunkDescPtr;
    csize:LONGINT;
    mCpu:SHORTCARD; (* merken, welches Objektfile *)
  END;

  RefRecPtr = POINTER TO
    RECORD
      cnt:LONGINT;
      addrs: ARRAY[0..5000] OF LONGINT
    END;
  ReferencesPtr = POINTER TO References;
  References = RECORD
    next: ReferencesPtr;
    refs: RefRecPtr;
    symbol: SymbolPtr;
    type: WidType;
    symType: SymTypes;
  END;

  HunkTypes =
    (code,chipcode,fastcode,data,chipdata,fastdata,bss,chipbss,fastbss,
    mergeddata,mergedbss);
  HunkTypeSet = SET OF HunkTypes;

(* Aufbau Hunkliste: (wh=WriteHunk hd=HunkDesc)
 * Jeder verschiedene Typ und/oder Hunkname ergibt einen WriteHunk
 * NIEMALS trennen zwischen Codehunks gleichen Namens EINES Moduls!
 *  wh -> wh -> wh -> NIL
 *  |     |     |
 *  V     V     V
 *  hd    hd    hd
 *  |     |     |
 *  V     V     V
 *  hd
 *  |
 *  V
 *)

  ALVPtr = POINTER TO ALV;
  ALV = RECORD
    next: ALVPtr;
    sym: SymbolPtr; (* wohin! *)
    reladr:LONGINT; (* relativ im WriteHunk, am Ende angehngt *)
    value: LONGINT; (* der Wert von JMP *)
  END;

  WriteHunk = RECORD
    succ,
    pred: WriteHunkPtr;
    first: HunkDescPtr;
    typ:HunkTypes;
    name:NameRecPtr;
    nr: LONGINT;
    len:LONGINT;
    rel32: RelocEntryPtr;
    alvs: ALVPtr;
  END;

  RelocPtr = POINTER TO LONGINT;
  HunkDesc = RECORD
    next:HunkDescPtr;
    mem: ADDRESS; (* adr of hunk-data in memory *)
    used:BOOLEAN; (* any reference to it? *)
    checked:BOOLEAN; (* Referenzen hieraus schon berprft? *)
    type: HunkTypes; (* code,data,bss *)
    absnr:LONGINT; (* Nr des 1. Hunks der Unit+relnr *)
    loadnr:LONGINT; (* hunknr im Loadfile/ spter im WriteFile! *)
    startAdr:LONGINT; (* rel fr Merging *)
    name: NameRecPtr;
    lwSize: LONGINT;
    reloc8,
    reloc16,
    reloc32,
    dreloc8,
    dreloc16,
    dreloc32: RelocPtr;
    refs: ReferencesPtr;
  END;


  Symbol = RECORD
    next,
    left,
    right: SymbolPtr;
    name: NameRecPtr;
    defined:BOOLEAN;
    symType:SymTypes; (* rel, abs, datarel? *)
    hunk:HunkDescPtr; (* wo definiert, nur fr rel und datarel? *)
    			(* hunk=NIL: spezielles Linkersymbol! *)
    value:LONGINT;
    useCount:LONGINT; (* Zhler nur wichtig fr bestimmte Symbole! *)
  END;

  ExtraFilePtr = POINTER TO ExtraFile;
  ExtraFile = RECORD
    next: ExtraFilePtr;
    name: ARRAY[0..79] OF CHAR;
  END;

CONST
  MaxStrLen=127;

VAR
  plusMinus:ARRAY BOOLEAN OF CHAR;
  alvBuffer: ARRAY[0..1] OF RECORD (* Weil ich keine WORDs schreiben darf! *)
    code:INTEGER;
    adr:LONGINT;
  END;
  alvPos:INTEGER;
  AuxFiles: ExtraFilePtr;

  binName: ARRAY[0..255] OF CHAR;
  startupName:ARRAY[0..31] OF CHAR;
  SymbolList,
  SymbolQueue: SymbolPtr;
  ModuleList: RECORD head,tail,tailPred:ModulePtr END;
  MainMod: ModulePtr;
  HunkList: HunkDescPtr;
  CurrentHunk: WriteHunkPtr;
  WriteList: RECORD
    head,tail,tailPred: WriteHunkPtr;
  END;
  HunkLen: ARRAY HunkTypes OF LONGINT;

  MergedHunkNr:LONGINT;
  ALVCount:LONGINT;
  MERGEDName, NOMERGEName, LinkerDBName, BSSBasName, BSSLenName, NEWDATALName,
    RESBASEName, RESLENName, STACKName, DEBUGName: NameRecPtr;

  LinkerDBSym, (* Start oder Start+32K im MixHunk (LEA) *)
  BSSBasSym,   (* Start BSS im MixHunk (LEA) *)
  BSSLenSym,   (* Anz LWs BSS im MixHunk *)
  NEWDATALSym, (* Anz LWs DATA im MixHunk *)
  RESBASESym,  (* 0 oder 32K *)
  STACKSym,    (* bei Resident vom Benutzer anzugeben MindestStack *)
  RESLENSym,   (* Anz LWs des MixHunks *)
  DEBUGSym: SymbolPtr; (* Zeiger auf Debug-Hunk *)
  BSSLen,
  NEWDATAL,
  RESBASE,
  RESLEN,
  CurrentNr,HunkCount,ModuleCount,NextAlvOff: LONGINT;
(*  HunkLen: ARRAY HunkTypes OF LONGINT;*)
  HunkName: ARRAY HunkTypes OF POINTER TO ARRAY[0..10] OF CHAR;
  UsedBSSLen,
  UsedNewDataL,
  smallCode,
  smallData: BOOLEAN;

  NormalStack: LONGINT;

  ActHunkNr: LONGINT;

  FileLen: LONGINT;

  debug,iconOn,reentrant,mini,askModule,tempAskModule, doStat,
  isreentrant,isresident,loadErr,dejaVue,ignoreBin,crash: BOOLEAN;
  cpu:CPUType;
  MinCpu:FileType;
  ActArg,Args:INTEGER;
  relocsToMerged:LONGINT;


PROCEDURE Err(s1,s2:ARRAY OF CHAR); (*$ CopyDyn:=FALSE *)
BEGIN
  FormatS(s1,s2); WriteLn;
(* BreakPoint(ADR('error'));*)
  loadErr:=TRUE;
(*BreakPoint(ADR('xit Err to Terminate'));*)
  Return;
END Err;

PROCEDURE CopyName(VAR s:ARRAY OF CHAR; nam:NameRecPtr);
BEGIN
  Copy(s,nam^.name);
  IF nam^.lws*4<=HIGH(s) THEN
    s[nam^.lws*4]:=0C; (* auf jeden Fall 0C am Ende! *)
  ELSE
    s[HIGH(s)]:=0C
  END;
END CopyName;

PROCEDURE NamErr(s:ARRAY OF CHAR; nam:NameRecPtr);
VAR str:ARRAY[0..79] OF CHAR;
BEGIN
  CopyName(str,nam);
  Err(s,str);
END NamErr;

PROCEDURE W(l:LONGINT);
BEGIN
  OutL(l);
  INC(FileLen,4);
END W;

PROCEDURE GenJmp(i:LONGINT); (* nur fr alvs; i<0: Abschlu *)
BEGIN
  IF alvPos=0 THEN
    IF i>=0 THEN
      alvBuffer[0].code:=JumpConst;
      alvBuffer[0].adr:=i;
      INC(alvPos);
    END;
  ELSE
    IF i<0 THEN
      alvBuffer[1].code:=NopConst;
      OutCount(ADR(alvBuffer),2);
      INC(FileLen,8);
    ELSE
      alvBuffer[1].code:=JumpConst;
      alvBuffer[1].adr:=i;
      OutCount(ADR(alvBuffer),3);
      INC(FileLen,12);
    END;
    alvPos:=0;
  END;
END GenJmp;

PROCEDURE OpenBinFile;
BEGIN
  IF ~ignoreBin THEN
    GetFileName(binName,binFile,MainMod^.name,TRUE);
  END;
  IF verbose THEN FormatS(' + %s ',binName); Flush END;
  IF OpenSeqOut(binName) THEN
    FileLen:=0;
    IF iconOn THEN MakeIcon(binName,"bin") END;
  ELSE
    Err(': kann nicht angelegt werden!',Empty);
  END;
END OpenBinFile;



PROCEDURE m(s:ARRAY OF CHAR);
(*$ CopyDyn:=FALSE *)
BEGIN
  InOut.WriteString(s);
END m;

PROCEDURE mi(l:LONGINT);
VAR str:ARRAY[0..15] OF CHAR;
BEGIN
  sprintf(str,"$%08lx",ADR(l));
  m(str);
END mi;

PROCEDURE md(l:LONGINT);
VAR str:ARRAY[0..15] OF CHAR;
BEGIN
  sprintf(str,"%3ld",ADR(l));
  m(str);
END md;

PROCEDURE mn(s:NameRecPtr);
VAR str:ARRAY[0..79] OF CHAR;
BEGIN
  CopyName(str,s);
  m(str);
END mn;

PROCEDURE ShowSym(ss:SymbolPtr);
VAR
  s{11}:SymbolPtr;
BEGIN
  s:=ss;
  IF s^.hunk#NIL THEN
    m("Hunk:"); md(s^.hunk^.loadnr);
    m("  Offset: "); mi(s^.hunk^.startAdr+s^.value);
  ELSE
    m("Hunk:---  Wert:   "); mi(s^.value);
  END;
  CASE s^.symType OF
  | rel:     m("  (rel)   ");
  | abs:     m("  (abs)   ");
  | datarel: m("  (drel)  ");
  | ELSE     m("  (????)  ");
  END;
  mn(s^.name);
  m("\n");
END ShowSym;

PROCEDURE ShowSyms;
VAR
  s{11}:SymbolPtr;
BEGIN
  s:=SymbolQueue;
  WHILE s#NIL DO
    IF (s^.hunk#NIL)&(s^.hunk^.used) OR (s^.useCount>0) THEN ShowSym(s) END;
    s:=s^.next;
  END;
END ShowSyms;

PROCEDURE Stat;
VAR
  w:WriteHunkPtr;
  s:SymbolPtr;
BEGIN
  Concat(binName, ".map");
  InOut.SetOutput(binName);
  IF InOut.done THEN
    IF verbose THEN FormatS(' + %s ',binName); Flush END;
    IF iconOn THEN MakeIcon(binName,"txt") END;
  ELSE
    WriteString(': kann nicht angelegt werden!\n');
    RETURN;
  END;
  w:=WriteList.head;
  WHILE w^.succ#NIL DO
    m("  Hunk"); md(w^.nr); m(":  "); mi(w^.len*4);
    m(" Byte,  Typ: ");
    IF w^.first#NIL THEN
      m(HunkName[w^.first^.type]^);
    ELSE
      m("????????");
    END;
    m("\n");
    w:=w^.succ;
  END;

  ShowSyms;
  InOut.CloseOutput;
  WriteLn;
END Stat;


PROCEDURE HunkReloc32(root: RelocEntryPtr);
VAR
 p: RelocEntryPtr;
 count: INTEGER; h:LONGINT;
BEGIN
 IF root=NIL THEN RETURN END;
(* BreakPoint(ADR('rel32'));*)
 W(hunkReloc32);
 WHILE root#NIL DO
  p:=root; count:=0;
  (* count entries for ONE hunk.
   * end at end of list or if new hunk number starts *)
  REPEAT
   h:=p^.hunk; p:=p^.next; INC(count);
  UNTIL (p=NIL) OR (p^.hunk#h);
  IF count>0 THEN
   (* write count, hunknumber and all locations; deallocate entries *)
   W(count); W(h);
   (* 12.4.91/bp Abfrage ob mehr als ein REl32 auf Merged! *)
   IF h=MergedHunkNr THEN INC(relocsToMerged,count) END;
   FOR h:=1 TO count DO
    W(root^.offset); p:=root; root:=root^.next;(* DEALLOCATE(p);*)
   END
  END
 END;
 (* end of list *)
 W(0);
END HunkReloc32;

PROCEDURE Put(lp:LongPtr; cnt:LONGINT);
VAR i:LONGINT;
BEGIN
  IF lp#NIL THEN
    OutCount(lp,cnt); (* cnt ist Anz LANGWORTE!!! *)
    INC(FileLen,cnt*4);
  END;
END Put;

PROCEDURE Put0(cnt:LONGINT);
VAR i:LONGINT;
BEGIN
  FOR i:=1 TO cnt DO
    W(0);
  END;
END Put0;

PROCEDURE WriteFile():BOOLEAN;
VAR h:WriteHunkPtr; i:INTEGER; hd:HunkDescPtr;
    rels:LONGINT; ry,drels,prev:RelocEntryPtr; a:ALVPtr;
    wasmergdata:BOOLEAN;
BEGIN
  OpenBinFile;
  rels:=0;
  drels:=NIL;
  h:=WriteList.head;
  W(hunkHeader); W(0);
  W(HunkCount); W(0); W(HunkCount-1);
  FOR i:=1 TO HunkCount DO
    IF h^.typ IN HunkTypeSet{chipcode,chipdata,chipbss} THEN
      W(CAST(LONGINT,CAST(LONGSET,h^.len)+LONGSET{chipMemBit}));
    ELSIF h^.typ IN HunkTypeSet{fastcode,fastdata,fastbss} THEN
      W(CAST(LONGINT,CAST(LONGSET,h^.len)+LONGSET{fastMemBit}));
    ELSIF (h^.typ IN HunkTypeSet{mergeddata,mergedbss}) & UsedNewDataL THEN
      prev:=ADR(h^.rel32); (* TRICK: next ist auf Offset 0 ! *)
      ry:=prev^.next;
      WHILE ry#NIL DO
        IF ry^.hunk=h^.nr THEN
          INC(rels);
	  (* den hier herausnehmen, in drels packen *)
	  prev^.next:=ry^.next;
	  ry^.next:=drels;
	  drels:=ry;
	ELSE
	  prev:=ry;
	END;
	ry:=prev^.next;
 (*
        INC(rels);
        IF ry^.hunk#h^.nr THEN
          CloseSeqOut;
          Err('Resident: Reloc32 in MergedData auf Fremdhunk!',Empty)
        END;
        ry:=ry^.next;
*)
      END;
      W(NEWDATAL+rels+1)
    ELSE
      W(h^.len) (* bei merged:bss+data *)
    END;
    h:=h^.succ
  END;

  h:=WriteList.head;
  WHILE h^.succ#NIL DO
    wasmergdata:=TRUE;
    CASE h^.typ OF
    (* Es gibt nur EINEN Merged-Hunk (data+bss oder bss)! *)
    |code,chipcode,fastcode: W(hunkCode);
    |data,mergeddata,chipdata,fastdata: W(hunkData);
    |bss,chipbss,fastbss: W(hunkBSS);
    |mergedbss: IF UsedNewDataL THEN
		  W(hunkData)
		ELSE
		  W(hunkBSS); wasmergdata:=FALSE;
		END;
    END;
    IF h^.typ>=mergeddata THEN (* special *)
      IF UsedNewDataL THEN (* data-Hunk! *)
        W(NEWDATAL+rels+1); (* hier noch datarelocs rein!!! *)
      ELSIF wasmergdata & UsedBSSLen THEN (*  ntig, weil Typ Data!! *)
        W(NEWDATAL); (* TrickHunk, Programm fllt BSS mit 0 *)
      ELSE (* BSS oder data&~usedbsslen *)
        W(h^.len); (* Linker oder DOS-Loader fllt mit 0 *)
      END;
      hd:=h^.first;
      WHILE (hd#NIL)&(hd^.type=mergeddata) DO
        Put(hd^.mem,hd^.lwSize);
        hd:=hd^.next;
      END;
      IF UsedNewDataL THEN
        ry:=drels;
        W(rels); (* hier noch datarelocs reinpacken cnt, reladrs!! *)
        WHILE ry#NIL DO
          W(ry^.offset);
          ry:=ry^.next;
        END;
      ELSIF ~UsedBSSLen & wasmergdata THEN
        Put0(BSSLen);
      END;
    ELSE
      W(h^.len);
      hd:=h^.first;
      WHILE hd#NIL DO
        Put(hd^.mem,hd^.lwSize); (* macht bei bss gar nichts *)
        hd:=hd^.next
      END;
      a:=h^.alvs; (* ALVs schreiben! *)
      i:=0;
      WHILE a#NIL DO
        GenJmp(a^.value);
        a:=a^.next;
        INC(i);
      END;
      IF ODD(i) THEN GenJmp(-1) END;
    END;
    HunkReloc32(h^.rel32);
    W(hunkEnd);
    h:=h^.succ;
  END;
  IF SeqOutOk THEN CloseSeqOut; RETURN TRUE
  ELSE RETURN FALSE
  END;
END WriteFile;


PROCEDURE AddReloc(VAR r: RelocEntryPtr; hunk: LONGINT; offset: LONGINT);
VAR help,p,root: RelocEntryPtr;
BEGIN
 root:=r;
 ALLOCATE(help,SIZE(RelocEntry));
 help^.hunk:=hunk;
 help^.offset:=offset;
 IF (root=NIL) OR (root^.hunk>=help^.hunk) THEN
  help^.next:=root;
  root:=help
 ELSE
  p:=root;
  WHILE (p^.next#NIL) & (p^.next^.hunk<=help^.hunk) DO
   p:=p^.next
  END;
  help^.next:=p^.next;
  p^.next:=help
 END;
 r:=root;
END AddReloc;


(*$ ReturnChk:=FALSE *)
PROCEDURE FindSym(n{10}:NameRecPtr):SymbolPtr;
VAR sym{11}:SymbolPtr;
BEGIN
  ASSEMBLE(
	MOVE.L	SymbolList(A4),sym
	MOVE.L	Symbol.right(sym),sym
  slp:	MOVE.L	sym,D0
	BEQ	raus
	MOVE.L	n,A0
	MOVE.L	Symbol.name(sym),A1
	MOVE.L	(A0),D1
  lp:	CMPM.L	(A0)+,(A1)+
	DBNE	D1,lp
	BHI.S	gr
	BLO.S	lo
	MOVE.L	sym,D0
	BRA.S	raus
  lo:	MOVE.L	Symbol.left(sym),sym
	BRA.S	slp
  gr:	MOVE.L	Symbol.right(sym),sym
	BRA.S	slp
  raus:
  END);
(*
  sym:=SymbolList^.right; (* Liste hat dummy Header! *)
  WHILE sym#NIL DO
    d:=Diff(n,sym^.name);
    IF d<0 THEN sym:=sym^.left
    ELSIF d>0 THEN sym:=sym^.right
    ELSE RETURN sym;
    END;
  END;
  RETURN NIL;
*)
END FindSym;
(*$ POP ReturnChk *)

(* nur zu gebrauchen, wenn die Liste noch in HunkList ist!!!! *)
(*$ ReturnChk:=FALSE *)
PROCEDURE FindHunk(nr{1}:LONGINT):HunkDescPtr;
VAR h{8}:HunkDescPtr;
BEGIN
  ASSEMBLE(
	MOVE.L	HunkList(A4),h
  lp:	MOVE.L	h,D0
	BEQ.S	raus
	CMP.L	HunkDesc.absnr(h),nr
	BEQ.S	raus
	MOVE.L	HunkDesc.next(h),h
	BRA.S	lp
  raus:	MOVE.L	h,D0
  END);
  (*
  h:=HunkList;
  WHILE (h#NIL)&(h^.absnr#nr) DO h:=h^.next END;
  RETURN h;
  *)
END FindHunk;
(*$ POP ReturnChk *)

PROCEDURE SearchHunk(nr{0}:LONGINT):HunkDescPtr;
VAR h{8}:HunkDescPtr; w{9}:WriteHunkPtr;
BEGIN
  w:=WriteList.head;
  WHILE w^.succ#NIL DO
    h:=w^.first;
    WHILE (h#NIL) DO
      IF (h^.absnr=nr) THEN RETURN h ELSE h:=h^.next END;
    END;
    w:=w^.succ;
  END;
  Err('SearchHunk: Hunk nicht gefunden!',Empty);
END SearchHunk;

PROCEDURE GetUndefined():SymbolPtr;
VAR s{8}:SymbolPtr;
BEGIN
  s:=SymbolQueue;
  WHILE (s#NIL)&(s^.defined) DO s:=s^.next END;
  RETURN s;
END GetUndefined;

PROCEDURE GetName(VAR n:NameRecPtr);
VAR cnt:LONGINT;
BEGIN
  n:=CAST(NameRecPtr,MemPtr);
  GetLong(cnt);
  SkipBlock(cnt);
END GetName;

PROCEDURE GetRefs(VAR n:ReferencesPtr);
VAR cnt:LONGINT;
BEGIN
  ALLOCATE(n,SIZE(References));
  n^.refs:=CAST(RefRecPtr,MemPtr);
  GetLong(cnt);
  SkipBlock(cnt);
END GetRefs;


PROCEDURE NewSym(n:NameRecPtr):SymbolPtr;
(* geklaut aus M2TM.NewObj/bp *)
VAR sym0, sym1: SymbolPtr;
    d:INTEGER;
BEGIN
(*BreakPoint(ADR('Enter NewSym'));*)
  (* SymbolList ist mit Dummy initialisiert! *)
  sym0:=SymbolList; sym1:=sym0^.right; d:=1;
  LOOP (* Was sind das blo fr blde Konstrukte???!!/bp *)
    IF sym1#NIL THEN (* Ende suchen *)
      d:=Diff(n,sym1^.name);
      IF d<0 THEN
        sym0:=sym1; sym1:=sym0^.left;
      ELSIF d>0 THEN
        sym0:=sym1; sym1:=sym0^.right;
      ELSE (* symbol doppelt vorhanden! *)
        NamErr('Symbol doppelt definiert: "%s"',n); EXIT;
      END;
    ELSE (* Ende der Liste, einfgen *)
      ALLOCATE(sym1,SIZE(Symbol));
      IF d<0 THEN sym0^.left:=sym1 ELSE sym0^.right:=sym1 END;
      sym1^.next:=SymbolQueue;
      SymbolQueue:=sym1;
      sym1^.left:=NIL; sym1^.right:=NIL; sym1^.hunk:=NIL;
      sym1^.defined:=FALSE; sym1^.name:=n;
      EXIT;
    END;
  END; (* loop *)
(*BreakPoint(ADR('Exit NewSym'));*)
  RETURN sym1;
END NewSym;

(*$ CopyDyn:=FALSE *)
PROCEDURE FindObj(modName:SymName):ModulePtr;
(* sucht das Modul in Liste, liefert Addresse zurck *)
VAR m:ModulePtr;
BEGIN
  m:=ModuleList.head;
  WHILE (m^.succ#NIL)&(Compare(modName,m^.name)#0) DO m:=m^.succ END;
  IF m^.succ=NIL THEN RETURN NIL
  ELSE RETURN m END;
END FindObj;


(*$ CopyDyn:=FALSE *)
PROCEDURE LoadObj(modName:ARRAY OF CHAR; getif:LoadTypes; first:BOOLEAN);
(* ldt das Modul, liefert neuen, eingelinkten ModulPtr zurck *)
VAR
  FullName: ARRAY[0..127] OF CHAR;
  FAddr:ADDRESS;
  FLen:LONGINT;
  Res: FileErrors;
  typ:FileType;
  m: ModulePtr;
  i,len: INTEGER;
  tmpName: ARRAY [0..127] OF CHAR;
  ch: CHAR;
  bool: BOOLEAN;
  o:ObjFilePtr;
BEGIN
  o:=NIL;
  CASE cpu OF
  | 0: typ:=objFile;
  | 1: typ:=ob1File;
  | 2: typ:=ob2File;
  | 3: typ:=ob3File;
  | 4: typ:=ob4File;
  | 8: typ:=ob8File;
  END;
  LOOP (* alle cpus rckwrts durch! Muss bleiben wg. GetInputFile *)
    TestBreak;
    IF getif=gf THEN
      o:=GetObj(FullName,typ,modName);
    ELSIF getif=gi THEN
      GetInputFile(FullName,typ,modName)
    ELSE Copy(FullName,modName);
    END;

    IF tempAskModule THEN
      LOOP
        WriteString(modName);
        FormatS(": [%s] >",FullName);
        bool:=ScanString(Read,tmpName,len,ch);
        WHILE (ch#ASCII.eol) & (ch#ASCII.eof) DO Read(ch) END;
        IF len=0 THEN EXIT END;
        IF (len=1)&(tmpName[0]='-') THEN tempAskModule:=FALSE; EXIT END;
        IF Exists(tmpName)#fileExists THEN
          WriteString(tmpName);
          WriteString(noSuchFile);
        ELSE
          Copy(FullName,tmpName);
          FreeObj(o,FALSE); (* o wird NIL, jetzt NIL macht nichts *)
          EXIT
        END
      END (* loop *)
    END; (* if tempAskModule *)

    Res:=GetFile(FullName,FAddr,FLen,o); (* wenn o#NIL wird Kopie erzeugt *)
    IF Res=noError THEN
(* hier noch realtyp fuer cpu und <<< ausgeben *)
      IF o#NIL THEN
        IF verbose THEN
          WHILE typ>o^.realType DO
            Write("<");
            DEC(typ);
          END;
          Flush;
        END;
        typ:=o^.realType;
        FreeObj(o,FALSE);
      END;
      IF verbose THEN FormatS(' - %s\n',FullName) END;
      ALLOCATE(m,SIZE(Module));
      INC(ModuleCount);
      AddTail(ADR(ModuleList),m);
      m^.addr:=FAddr;
      m^.len :=FLen;
      (*$ RangeChk:=FALSE *)
      m^.mCpu:=ORD(typ)-ORD(objFile);
      IF typ=ob8File THEN
        INC(m^.mCpu,3);
      END;
      (*$ POP RangeChk *)
      IF typ>MinCpu THEN MinCpu:=typ END;
      EXIT; (* best match! *)
    ELSE
      FreeObj(o,FALSE); (* kann nur Speichermangel sein, wenn o#NIL! *)
      IF (Res=notFound)&(typ>objFile) THEN
        DEC(typ);
        IF verbose THEN Write('<'); Flush END;
      ELSE
        WriteString(FullName);
        IF first THEN
	  SetReply(rcMainNotFound)
	ELSE
	  SetReply(rcImportantNotFound)
	END;
        Err(noSuchFile,Empty);
      END;
    END;
  END; (* cpu-loop *)
  InitSer(FAddr,FLen);
END LoadObj;

PROCEDURE SkipSymbols;
VAR lc:LONGINT;
BEGIN
  GetLong(lc);
  WHILE lc#0 DO
    SkipBlock(lc+1); (* Name+Wert *)
    GetLong(lc);
  END;
(*
  REPEAT
    GetLong(lc);
    SkipBlock(lc);
  UNTIL lc=0;
*)
END SkipSymbols;

PROCEDURE Entry(h:HunkDescPtr; sym:SymbolPtr; typ: WidType; refType:SymTypes);
VAR r:ReferencesPtr;
BEGIN
  GetRefs(r);
  r^.type:=typ;
  r^.symType:=refType;
  r^.symbol:=sym;
  r^.next:=h^.refs;
  h^.refs:=r;
(*
  IF sym=BSSLenSym THEN UsedBSSLen:=TRUE
  ELSIF sym=NEWDATALSym THEN UsedNewDataL:=TRUE
  ELSIF sym=LinkerDBSym THEN INC(UsedLinkerDB) END;
*)
END Entry;

PROCEDURE External(h:HunkDescPtr);
VAR
 i,type:INTEGER;
 len:LONGINT;
 lc:LONGINT;
 sym:SymbolPtr;
 nr:NameRecPtr;
BEGIN
 LOOP
   lc:=MemPtr^;
   type:=CAST(LONGCARD,lc) DIV 1000000H;
   len:=CAST(LONGINT,CAST(LONGCARD,lc) MOD 10000H);
   MemPtr^:=len; (* pure Lnge im Namen! *)
   GetName(nr); (* macht bei 0 gar nichts! *)
   IF lc=0 THEN EXIT END;
   sym:=FindSym(nr);
   IF sym=NIL THEN
     sym:=NewSym(nr);
   END;
   IF type=extSymb THEN
     Err('Symboldefinition im External Hunk',Empty);
   ELSIF (type=extDef)OR(type=extAbs) THEN
     IF sym^.defined THEN
       NamErr('Symbol doppelt definiert: "%s"',sym^.name)
     END;
     sym^.defined:=TRUE;
     IF type=extDef THEN sym^.symType:=rel; (* data- oder pcrel *)
     ELSE sym^.symType:=abs
     END;
     sym^.hunk:=h;
     GetLong(sym^.value);
   ELSIF type=extRes THEN
     Err('Resident library definition im Hunk',Empty);
   ELSIF type=extRef32  THEN Entry(h,sym,long,rel);
   ELSIF type=extCommon THEN Err("COMMON im Hunk",Empty);
   ELSIF type=extRef16  THEN Entry(h,sym,word,rel);
   ELSIF type=extRef8   THEN Entry(h,sym,byte,rel);
   ELSIF type=extDRel32 THEN Entry(h,sym,long,datarel);
   ELSIF type=extDRel16 THEN Entry(h,sym,word,datarel);
   ELSIF type=extDRel8  THEN Entry(h,sym,byte,datarel);
   ELSE
     Err("Unbekannte externe Referenz im Hunk",Empty)
   END;
 END; (* loop *)
END External;

(* data, code agal. geht aus dem hunktyp hervor! *)
PROCEDURE Relocation(h:HunkDescPtr; VAR r:RelocPtr);
VAR lc,dummy:LONGINT;
BEGIN
  r:=CAST(RelocPtr,MemPtr); (* im HunkDesc merken! *)
  LOOP
    GetLong(lc);
    IF lc=0 THEN EXIT END;
    INC(MemPtr^,ActHunkNr); (* absHunknr eintragen! *)
    SkipBlock(lc+1); (* auch HunkNr skippen *)
  END;
END Relocation;

PROCEDURE StripBits(VAR lc:LONGINT);
BEGIN
   lc:=CAST(LONGINT, CAST(LONGSET,lc)*LONGSET{0..29});
END StripBits;


(* global fr ReadHunk, ReadHunks, ParseUnit *)
VAR
   LastLong:LONGINT;

(* liest EINEN Hunk!!!! *)
(* erstes Long schon gelesen, raus mit hunkEnd *)
PROCEDURE ReadHunk(VAR relHunkNr:LONGINT);
VAR
  h:HunkDescPtr;
  chip,fast:BOOLEAN;
  dummy:NameRecPtr;
BEGIN
  ALLOCATE(h,SIZE(HunkDesc));
  h^.next:=HunkList;
  HunkList:=h;
  h^.absnr:=ActHunkNr+relHunkNr; INC(relHunkNr);
  h^.loadnr:=CurrentNr;
  (* 23.1.91/bp Name vorbesetzen, sonst NIL-Zugriffe in Diff *)
  h^.name:=ADR("\o\o\o\x01----");
  (* allocate macht 0!
  h^.used:=FALSE;
  h^.checked:=FALSE;
  h^.startAdr:=0;
  h^.reloc8:=NIL;
  h^.reloc16:=NIL;
  h^.reloc32:=NIL;
  h^.dreloc8:=NIL;
  h^.dreloc16:=NIL;
  h^.dreloc32:=NIL;
  h^.refs:=NIL;
  *)
(*BreakPoint(ADR('ent ReadHunk'));*)
 LOOP
   chip:=chipMemBit IN CAST(LONGSET,LastLong);
   fast:=fastMemBit IN CAST(LONGSET,LastLong);
   StripBits(LastLong);
   CASE LastLong OF
   | hunkUnit:
	Err('HunkUnit im Hunk',Empty);
   | hunkName:
        GetName(h^.name);
   | hunkCode:
   	IF chip THEN h^.type:=chipcode
	ELSIF fast THEN h^.type:=fastcode
	ELSE h^.type:=code
	END;
	GetLong(h^.lwSize);
	StripBits(h^.lwSize);
	h^.mem:=MemPtr;
	SkipBlock(h^.lwSize);
	INC(ModuleList.tailPred^.csize,h^.lwSize*4);
   | hunkData:
   	IF chip THEN h^.type:=chipdata
	ELSIF fast THEN h^.type:=fastdata
	ELSE h^.type:=data
	END;
	GetLong(h^.lwSize);
	StripBits(h^.lwSize);
	h^.mem:=MemPtr;
	SkipBlock(h^.lwSize);
   | hunkBSS:
   	IF chip THEN h^.type:=chipbss
	ELSIF fast THEN h^.type:=fastbss
	ELSE h^.type:=bss
	END;
	GetLong(h^.lwSize);
	StripBits(h^.lwSize);
	h^.mem:=NIL;
   | hunkReloc32:
   	Relocation(h,h^.reloc32);
   | hunkReloc16:
   	Relocation(h,h^.reloc16);
   | hunkReloc8:
   	Relocation(h,h^.reloc8);
   | hunkExt:
   	External(h);
   | hunkSymbol:
   	SkipSymbols;
   | hunkDebug:
   	GetLong(LastLong);
   	SkipBlock(LastLong);
   | hunkEnd:
   	 EXIT;
   | hunkHeader: Err('Header im Hunk',Empty);
   | hunkOverlay: Err('OVERLAY im Hunk',Empty);
   | hunkBreak: Err('BREAK im Hunk',Empty);
   | hunkDReloc32: Relocation(h,h^.dreloc32);
   | hunkDReloc16: Relocation(h,h^.dreloc16);
   | hunkDReloc8:  Relocation(h,h^.dreloc8);
   | libHunk,libIndex: Err("Gepackte Libraries kann ich nicht verarbeiten.",Empty);
   ELSE
     sprintf(binName,"%08lx",CAST(LONGINT,LastLong));
     Err('Unbekannter Hunktyp: %sH',binName);
   END; (* case *)
   GetLong(LastLong);
 END; (* loop *)
 (* hier LastLong= hunkend *)
 IF Diff(h^.name,MERGEDName)=0 THEN
   IF h^.type=data THEN h^.type:=mergeddata
   ELSIF h^.type=bss THEN h^.type:=mergedbss
   ELSE
     Err('"__MERGED" mu Data oder BSS sein!',Empty)
   END;
   h^.loadnr:=-1;
 END;
(*BreakPoint(ADR('exit ReadHunk'));*)
END ReadHunk;

(* Liest alle Hunks einer Unit. Startet nach UnitName *)
PROCEDURE ReadHunks;
VAR RelHunkNr:LONGINT;
BEGIN
  RelHunkNr:=0;
  REPEAT
    ReadHunk(RelHunkNr);
    (* fr Debug-Info *)
    IF debug THEN
      IF (HunkList^.type<=fastcode)&(ModuleList.tailPred^.firstCode=NIL) THEN
        ModuleList.tailPred^.firstCode:=HunkList
      ELSIF (HunkList^.type>fastcode) THEN
        CASE HunkList^.type OF
          | data,chipdata,fastdata,mergeddata:
            IF ModuleList.tailPred^.ini=NIL THEN
              ModuleList.tailPred^.ini:=HunkList;
            END;
	  | bss,chipbss,fastbss,mergedbss:
            IF ModuleList.tailPred^.bss=NIL THEN
              ModuleList.tailPred^.bss:=HunkList;
            END;
	END;
      END;
    END;
    IF ~eof THEN GetLong(LastLong) END;
  UNTIL eof OR (LastLong=hunkUnit); (* HunkUnit *)
  INC(ActHunkNr,RelHunkNr);
END ReadHunks;

(* Liest alle Units eines Files *)
(* nur bei der ersten Unit wird der Name vermerkt! *)
PROCEDURE ParseUnit;
VAR cnt:LONGINT;
    m:ModulePtr;
BEGIN
(*BreakPoint(ADR('ent ParseUnit'));*)
  GetLong(LastLong);
  IF LastLong=hunkUnit THEN
    CopyName(ModuleList.tailPred^.name,CAST(NameRecPtr,MemPtr));
    GetLong(cnt);
    SkipBlock(cnt);
    REPEAT
      GetLong(LastLong);
      ReadHunks;
      IF ~eof THEN
        IF LastLong#hunkUnit THEN
           Err('HunkUnit erwartet',Empty);
        ELSE
        (* 3.2.91/bp neue Unit anlegen, dann Libs IMMER an Arts *)
           ALLOCATE(m,SIZE(Module));
           INC(ModuleCount);
           AddTail(ADR(ModuleList),m);
           m^.mCpu:=ModuleList.tailPred^.pred^.mCpu;
           CopyName(ModuleList.tailPred^.name,CAST(NameRecPtr,MemPtr));
	(* ENDE neu *)
           GetLong(cnt);
           SkipBlock(cnt);

        END;
      END;
    UNTIL eof;
    INC(CurrentNr); (* je File eine nr zur Tennpunktbestimmung! *)
  ELSIF LastLong=1 THEN (* objFile <V4.0 *)
    Err("ALTE ObjectDatei (M2Amiga < V4.0)!!!",Empty);
  ELSE
    Err('HunkUnit erwartet!',Empty);
  END;
(*BreakPoint(ADR('exit ParseUnit'));*)
END ParseUnit;

PROCEDURE RelocOne(h,href:HunkDescPtr; val:LONGINT; wid:WidType;
		   symT:SymTypes; cnt:INTEGER; VAR ptr:LongPtr);
VAR i:INTEGER; field:TrickPtr; offset,cont:LONGINT; LoadNr:LONGINT;
    val1:LONGINT;
BEGIN
    IF (href#NIL)&(symT#abs) THEN (* kein Linkersymbol *)
      INC(val,href^.startAdr);
    END;
    IF (symT=datarel)&(wid#long) THEN DEC(val,RESBASE) END;
    IF href#NIL THEN LoadNr:=href^.loadnr ELSE LoadNr:=MergedHunkNr END;
    FOR i:=1 TO cnt DO
      val1:=val;
      offset:=ptr^; INC(ptr,4);
      IF (symT=rel)&(wid#long) THEN
        DEC(val1,CAST(LONGINT,h^.startAdr)+offset);
        IF LoadNr#h^.loadnr THEN Err('ref16 zwischen Hunks!',Empty) END;
      END;
      field:=h^.mem;
      INC(field,offset);
      IF wid=byte THEN (* bei Byte und word: Code anpassen *)
        cont:=field^.barr;
        INC(cont,val1);
        IF (cont<-128)OR(cont>127) THEN
          Err('Byteberlauf bei Relokation',Empty)
        END;
	field^.barr:=cont;
      ELSIF wid=word THEN
        cont:=field^.warr;
        INC(cont,val1);
        IF (cont<MIN(INTEGER))OR(cont>MAX(INTEGER)) THEN
          Err('Wortberlauf bei Relokation',Empty)
        END;
	field^.warr:=cont;
      ELSE (* bei long code UND/ODER reloc anpassen! *)
        cont:=field^.larr;
        INC(cont,val1);
	field^.larr:=cont;
	IF symT#abs THEN
(*	  BreakPoint(ADR('AddReloc'));*)
	  AddReloc(CurrentHunk^.rel32,LoadNr,CAST(LONGINT,h^.startAdr)+offset);
	END;
      END;
    END;
END RelocOne;

PROCEDURE FindALV(s:SymbolPtr):ALVPtr;
VAR a,a1:ALVPtr;
BEGIN
  a:=CurrentHunk^.alvs;
  WHILE (a#NIL)&(a^.sym#s) DO a:=a^.next END;
  IF a=NIL THEN
    ALLOCATE(a,SIZE(ALV));
    INC(ALVCount);
    a1:=CurrentHunk^.alvs; (* Ans ENDE anfgen!! *)
    IF a1=NIL THEN
      CurrentHunk^.alvs:=a;
    ELSE
      WHILE a1^.next#NIL DO a1:=a1^.next END;
      a1^.next:=a;
    END;
    a^.sym:=s;
    a^.reladr:=NextAlvOff;
    a^.value:=s^.hunk^.startAdr+s^.value;
    INC(NextAlvOff,6);
    AddReloc(CurrentHunk^.rel32,s^.hunk^.loadnr,a^.reladr+2);
  END;
  RETURN a;
END FindALV;

PROCEDURE DoRefs(h:HunkDescPtr);
VAR r:ReferencesPtr; sym:SymbolPtr; rf:RefRecPtr;
    href:HunkDescPtr;
    wid:WidType; lp:LongPtr; typ:SymTypes; alv:ALVPtr; value:LONGINT;
BEGIN
  r:=h^.refs;
  WHILE r#NIL DO
    sym:=r^.symbol;
    INC(sym^.useCount);
    rf:=r^.refs;
    wid:=r^.type;
    href:=sym^.hunk;
    typ:=sym^.symType;
    value:=sym^.value;
    IF typ#abs THEN
      typ:=r^.symType;
      IF (wid<long)&(typ=rel)&(href^.loadnr#CurrentNr) THEN (* ALV ntig *)
        alv:=FindALV(sym); (* nicht unbedingt neu, kann auch alt sein! *)
	href:=CurrentHunk^.first;
	value:=alv^.reladr;
      END;
    END;
    lp:=ADR(rf^.addrs);
    RelocOne(h,href,value,r^.type,typ,rf^.cnt,lp);
    r:=r^.next;
  END;
END DoRefs;

PROCEDURE DoReloc(h:HunkDescPtr; r:RelocPtr; wid:WidType);
VAR cnt,hunk:LONGINT;
    href:HunkDescPtr;
BEGIN
  IF r=NIL THEN RETURN END;
  LOOP
    cnt:=r^; INC(r,4);
    IF cnt=0 THEN EXIT END;
    hunk:=r^; INC(r,4); href:=SearchHunk(hunk);
    RelocOne(h,href,0,wid,rel,cnt,CAST(LongPtr,r));
  END;
END DoReloc;

PROCEDURE DoDReloc(h:HunkDescPtr; r:RelocPtr; wid:WidType);
VAR cnt,hunk:LONGINT;
    href:HunkDescPtr;
BEGIN
  IF r=NIL THEN RETURN END;
  LOOP
    cnt:=r^; INC(r,4);
    IF cnt=0 THEN EXIT END;
    hunk:=r^; INC(r,4); href:=SearchHunk(hunk);
    RelocOne(h,href,0,wid,datarel,cnt,CAST(LongPtr,r));
  END;
END DoDReloc;

(* Optimierung ---------------------------------------------- *)
PROCEDURE ParseReloc(r:RelocPtr);
VAR cnt,hunk:LONGINT; h:HunkDescPtr;
BEGIN
  IF r#NIL THEN
    LOOP
      cnt:=r^;
      IF cnt=0 THEN EXIT END;
      INC(r,4);
      hunk:=r^;
      h:=FindHunk(hunk);
      IF h=NIL THEN Err('Undefinierte Hunknummer!',Empty)
      ELSE h^.used:=TRUE;
      END;
      INC(r,4*cnt+4);
    END;
  END;
END ParseReloc;

(* Markiere alle von h referenzierten Hunks *)
PROCEDURE CheckHunk(h:HunkDescPtr);
VAR r:ReferencesPtr; UsedHunk:HunkDescPtr;
BEGIN
  h^.checked:=TRUE;
  h^.used:=TRUE;
  ParseReloc(h^.reloc8);
  ParseReloc(h^.reloc16);
  ParseReloc(h^.reloc32);
  ParseReloc(h^.dreloc8);
  ParseReloc(h^.dreloc16);
  ParseReloc(h^.dreloc32);
  r:=h^.refs;
  WHILE r#NIL DO
    UsedHunk:=r^.symbol^.hunk;
    IF UsedHunk#NIL THEN UsedHunk^.used:=TRUE END;
    r:=r^.next;
  END;
END CheckHunk;

(*$ ReturnChk:=FALSE *)
PROCEDURE GetUsed(VAR h{8}:HunkDescPtr):BOOLEAN;
VAR temp{9}:HunkDescPtr;
BEGIN
  ASSEMBLE(
	MOVE.L	HunkList(A4),temp
  lp:	MOVE.L	temp,D0
	BEQ.S	raus
	TST.B	HunkDesc.checked(temp)
	BNE.S	next
	TST.B	HunkDesc.used(temp)
	BNE.S	raus
  next:	MOVE.L	HunkDesc.next(temp),temp
	BRA.S	lp
  raus:	MOVE.L	temp,(h)
	SNE	D0
  END);
  (*
  h:=HunkList;
  WHILE (h#NIL)&(h^.checked OR ~h^.used) DO h:=h^.next END;
  RETURN h#NIL;
  *)
END GetUsed;
(*$ POP ReturnChk *)

(* Optimierung ende ------------------------------------------ *)

(*$ EntryExitCode:=FALSE *)
PROCEDURE EnqueueHunk(w{9}:WriteHunkPtr);
(* sortiert nach typ,loadnr (name egal) *)
BEGIN
  ASSEMBLE(
	MOVE.L	D2,-(A7)
	LEA	WriteList(A4),A0
	MOVE.B	WriteHunk.typ(A1),D1
	MOVE.L	WriteHunk.nr(A1),D2
	MOVE.L	(A0),D0
sr:	MOVEA.L	D0,A0
	MOVE.L	(A0),D0
	BEQ.S	raus
	CMP.B	WriteHunk.typ(A0),D1
	BLT.S	raus
	BGT.S	sr
	CMP.L	WriteHunk.nr(A0),D2
	BGT.S	sr
raus:	MOVE.L	4(A0),D0
	MOVE.L	A1,4(A0)
	MOVE.L	A0,(A1)
	MOVE.L	D0,4(A1)
	MOVE.L	D0,A0
	MOVE.L	A1,(A0)
	MOVE.L	(A7)+,D2
	RTS
  END);
END EnqueueHunk;

(*
 * Fgt einen Hunk je nach Typ, Name und Loadnr in die WriteList ein.
 * Achtung: h^.next wird verndert!!
 * Fgt Hunks VORNE an, dadurch kommt die ursprngliche Reihenfolge wieder.
 *)
PROCEDURE Append(h:HunkDescPtr);
VAR w:WriteHunkPtr;
BEGIN
  w:=WriteList.head;
  WHILE (w^.succ#NIL) & ( (w^.typ#h^.type) OR (w^.nr#h^.loadnr)
			OR (Diff(w^.name,h^.name)#0) ) DO
    w:=w^.succ
  END;
  IF w^.succ=NIL THEN (* neuen WriteHunk generieren *)
    ALLOCATE(w,SIZE(WriteHunk));
    w^.nr:=h^.loadnr;
    w^.typ:=h^.type;
    w^.name:=h^.name;
    EnqueueHunk(w);
  END;
  h^.next:=w^.first;
  w^.first:=h;
  INC(w^.len,h^.lwSize);
END Append;

(* Wird pro LinkUnit aufgerufen *)
PROCEDURE InitMLinkLoad;
VAR typ:HunkTypes;
BEGIN


  HunkName[code]:=ADR('CODE');
  HunkName[chipcode]:=ADR('CHIPCODE');
  HunkName[fastcode]:=ADR('FASTCODE');
  HunkName[data]:=ADR('DATA');
  HunkName[chipdata]:=ADR('CHIPDATA');
  HunkName[fastdata]:=ADR('FASTDATA');
  HunkName[bss]:=ADR('BSS');
  HunkName[chipbss]:=ADR('CHIPBSS');
  HunkName[fastbss]:=ADR('FASTBSS');
  HunkName[mergeddata]:=ADR('MERGDATA');
  HunkName[mergedbss]:=ADR('MERGBSS');
  ALLOCATE(SymbolList,SIZE(SymbolList^)); (* dummy header *)

  SymbolQueue:=NIL;
  NewList(ADR(ModuleList));
  HunkList:=NIL;
  NewList(ADR(WriteList));
  ActHunkNr:=0;
  ALVCount:=0;
  alvPos:=0;
  ModuleCount:=0;
  FOR typ:=MIN(HunkTypes) TO MAX(HunkTypes) DO
    HunkLen[typ]:=0
  END;
  MinCpu:=objFile;
  NOMERGEName:= ADR('\o\o\o\x02_NOMERGE');
  MERGEDName:=  ADR('\o\o\o\x02__MERGED');
  LinkerDBName:=ADR('\o\o\o\x03_LinkerDB\o\o\o');
  BSSBasName:=  ADR('\o\o\o\x02__BSSBAS');
  BSSLenName:=  ADR('\o\o\o\x02__BSSLEN');
  RESBASEName:= ADR('\o\o\o\x02_RESBASE');
  RESLENName:=  ADR('\o\o\o\x02_RESLEN\o');
  NEWDATALName:=ADR('\o\o\o\x03_NEWDATAL\o\o\o');
  STACKName :=  ADR('\o\o\o\x02_STACK\o\o');
  DEBUGName :=  ADR('\o\o\o\x02_DEBUG\o\o');
  LinkerDBSym:=NewSym(LinkerDBName);
  LinkerDBSym^.defined:=TRUE; LinkerDBSym^.symType:=datarel;
  BSSBasSym:=NewSym(BSSBasName);
  BSSBasSym^.defined:=TRUE; BSSBasSym^.symType:=datarel;
  BSSLenSym:=NewSym(BSSLenName);
  BSSLenSym^.defined:=TRUE; BSSLenSym^.symType:=abs;
  RESBASESym:=NewSym(RESBASEName);
  RESBASESym^.defined:=TRUE; RESBASESym^.symType:=abs;
  RESLENSym:=NewSym(RESLENName);
  RESLENSym^.defined:=TRUE; RESLENSym^.symType:=abs;
  NEWDATALSym:=NewSym(NEWDATALName);
  NEWDATALSym^.defined:=TRUE; NEWDATALSym^.symType:=abs;
  STACKSym:=NewSym(STACKName);
  STACKSym^.defined:=TRUE; STACKSym^.symType:=abs;
  DEBUGSym:=NewSym(DEBUGName);
  DEBUGSym^.defined:=TRUE; DEBUGSym^.symType:=rel;
  MergedHunkNr:=-1;
  relocsToMerged:=0;
END InitMLinkLoad;

PROCEDURE Link;
VAR mod:SymName;
    sym, oldSym:SymbolPtr;
    h,hn:HunkDescPtr;
    typ: HunkTypes;
    Add:LONGINT;
    w:WriteHunkPtr;
    ef:ExtraFilePtr;
    m:ModulePtr;
    info:DebugInfoPtr;
    info2:DebugInfo2Ptr;
    i:INTEGER;
BEGIN

  InitMLinkLoad; (* symbole setzen und zeiger nil *)

 (* a) alles einlesen
  * b) alle usedhunks suchen und markieren
  * c) alle unusedhunks weg
  * d) hunks gleichen typs und namens zusammen
  * e) wenn __merged, dann auch data+bss zusammen
  * f) relocations durchfhren, alvs erzeugen!
  * g) raus damit!
  *)
  (* alles einlesen *)
  CurrentNr:=0;
  LoadObj(startupName,gf,FALSE);
  ParseUnit;
  IF  (FirstPos(fName,0,".")<0)
    & (FirstPos(fName,0,"/")<0)
    & (FirstPos(fName,0,":")<0) THEN
    LoadObj(fName,gf,TRUE);
  ELSE
    LoadObj(fName,gi,TRUE);
  END;
  MainMod:=ModuleList.tailPred;
  ParseUnit;
  sym:=NIL;
  REPEAT
    oldSym:=sym;
    sym:=GetUndefined();
    IF sym#NIL THEN
(*BreakPoint(ADR('undef: sym#NIL'));*)
      IF sym=oldSym THEN (* 2mal durchgelaufen mit selbem sym! *)
        NamErr('Symbol "%s" nicht zu finden!',sym^.name);
      END;
      IF ExtractModuleName(sym^.name,mod) THEN
        IF FindObj(mod)#NIL THEN
          NamErr('Symbol "%s" nicht im Modul vorhanden!',sym^.name);
        ELSE
          LoadObj(mod,gf,FALSE);
          ParseUnit;
        END;
      ELSE
        IF AuxFiles#NIL THEN (* jeweils nur einzeln laden! *)
          ef:=AuxFiles;
          AuxFiles:=ef^.next;
          WriteString('lade:');WriteString(ef^.name);
          LoadObj(ef^.name,none,FALSE);
          ParseUnit;
        ELSE
          IF Diff(sym^.name,ADR("\o\o\o\x02__main\o\o"))=0 THEN
            WriteString("Dies ist KEIN Programm-Modul!\n");
          END;
          NamErr('Symbol "%s" nicht zu finden!',sym^.name);
        END;
      END;
    END;
(*    BreakPoint(ADR('Stop'));*)
  UNTIL sym=NIL;

(*BreakPoint(ADR('nach AllRead'));*)
  (* b) alle usedhunks markieren
   * Starte beim StartHunk, markiere alle hiervon benutzten,
   * gehe bei den neu benutzten genauso vor! Ende
   *)
  h:=HunkList; (* LETZTER in der Liste ist StartHunk! *)
  IF ~debug THEN
    WHILE h^.next#NIL DO h:=h^.next END;
    (*BreakPoint(ADR("opt"));*)
    (* _NOMERGE mu auch den nchsten Hunk einbinden! *)
    IF Diff(NOMERGEName,h^.name)=0 THEN
      CheckHunk(h);
      sym:=FindSym(ADR("\o\o\o\x03Arts_Startup"));
      IF sym=NIL THEN
        NamErr('Symbol "%s" nicht zu finden!',ADR("\o\o\o\x03Arts_Startup"));
      END;
      h:=sym^.hunk;
    END;
    REPEAT
      CheckHunk(h)
    UNTIL ~GetUsed(h);
  ELSE (* alles drinlassen! *)
    WHILE h#NIL DO h^.used:=TRUE; h:=h^.next END;
  END;
(*BreakPoint(ADR('nach checkhunks'));*)
  (* c) all unused weg entfllt *)

  (* d) Hunks gleichen Typs und Namens zusammen *)
  h:=HunkList;
  WHILE h#NIL DO
    hn:=h^.next;
    IF h^.used THEN Append(h) END; (* Je nach Typ, Name in WriteHunkListe *)
    h:=hn;
  END;

  (*
   * Nun sind die Hunks wieder in der richtigen Reihenfolge!
   * WriteList enthlt sortiert nach Typ und loadnr, name, also ist
   * der erste WriteHunk der mit dem StartHunk!
   *)
   w:=WriteList.head;

   IF smallCode THEN (* alle Codes gleichen Typs zusammen, wenns geht *)
     IF (w^.succ#NIL)&(Diff(w^.name,NOMERGEName)=0) THEN
       w:=w^.succ
     END;
     WHILE (w^.succ#NIL)&(w^.succ^.succ#NIL)&(w^.typ<data) DO
       IF (w^.typ=w^.succ^.typ)&(w^.len+w^.succ^.len<maxLwLen) THEN
         INC(w^.len,w^.succ^.len);
         h:=w^.first; (* beide WriteHunks zusammenlegen *)
         WHILE h^.next#NIL DO h:=h^.next END;
         h^.next:=w^.succ^.first;
         Remove(w^.succ);
       ELSE
         w:=w^.succ
       END;
     END;
   END;


   IF smallData THEN (* alle data,bss gleichen Typs zusammen *)
     WHILE (w^.succ#NIL)&(w^.typ<data) DO w:=w^.succ END;
     WHILE (w^.succ#NIL)&(w^.succ^.succ#NIL)&(w^.typ<mergeddata) DO
       IF (w^.typ=w^.succ^.typ) THEN
         INC(w^.len,w^.succ^.len);
         h:=w^.first; (* beide WriteHunks zusammenlegen *)
         WHILE h^.next#NIL DO h:=h^.next END;
         h^.next:=w^.succ^.first;
         Remove(w^.succ);
       ELSE
         w:=w^.succ
       END;
     END;
   END;

  (* mergeddata+mergedbss *)
   WHILE (w^.succ#NIL)&(w^.typ<mergeddata) DO w:=w^.succ END;

   NEWDATAL:=0;
   BSSLen:=0;
   IF w^.succ#NIL THEN (* noch mergeddata und/oder mergedbss *)
     IF w^.typ=mergeddata THEN
       NEWDATAL:=w^.len;
       IF w^.succ^.succ#NIL THEN
         (* INC(w^.len,w^.succ^.len); kommt gleich noch besser! *)
         h:=w^.first; (* beide WriteHunks zusammenlegen *)
         WHILE h^.next#NIL DO h:=h^.next END;
         h^.next:=w^.succ^.first;
         BSSLen:=w^.succ^.len;
         Remove(w^.succ);
       END;
     ELSE (* kann nur mergedbss alleine sein *)
       BSSLen:=w^.len;
     END;
   END;

(*BreakPoint(ADR('vor startadrs legen'));*)
  (* startAddrs,hunkNummern festlegen *)
  w:=WriteList.head;
  CurrentNr:=0;
  WHILE w^.succ#NIL DO
    w^.len:=0;
    w^.nr:=CurrentNr;
    IF w^.typ>=mergeddata THEN MergedHunkNr:=CurrentNr END;
    h:=w^.first;
    WHILE h#NIL DO
      h^.loadnr:=CurrentNr;
      h^.startAdr:=w^.len*4;
      INC(w^.len,h^.lwSize);
      h:=h^.next;
    END;
    INC(HunkLen[w^.typ],w^.len);
    INC(CurrentNr);
    w:=w^.succ
  END;
(*BreakPoint(ADR('vor symsetzen'));*)

  HunkLen[mergeddata]:=NEWDATAL;
  HunkLen[mergedbss]:=BSSLen;
  HunkCount:=CurrentNr;

  (* Linkersymbole erstellen *)
  RESLEN:=(BSSLen+NEWDATAL)*4;
  IF RESLEN<=8000H THEN RESBASE:=0 ELSE RESBASE:=8000H END;

  LinkerDBSym^.value:=RESBASE;
  BSSBasSym^.value:=NEWDATAL*4;
  BSSLenSym^.value:=BSSLen;
  NEWDATALSym^.value:=NEWDATAL;
  RESBASESym^.value:=RESBASE;
  RESLENSym^.value:=RESLEN;
  STACKSym^.value:=NormalStack;

  IF debug THEN
    DEBUGSym^.value:=0;
    ALLOCATE(DEBUGSym^.hunk,SIZE(HunkDesc));
    WITH DEBUGSym^.hunk^ DO
      loadnr:=HunkCount;
      startAdr:=0;
      (* 2*count!! *)
      lwSize:=(ModuleCount*(SIZE(ModuleInfo)+SIZE(ModuleInfo2))+(3+4+4)) DIV 4;
    END;
    ALLOCATE(w,SIZE(WriteHunk));
    AddTail(ADR(WriteList),w);
    w^.first:=DEBUGSym^.hunk;
    w^.typ:=data; (* Besser CODE, da unvernderlich! *)
    w^.name:=DEBUGName;
    w^.nr:=HunkCount;
    w^.len:=DEBUGSym^.hunk^.lwSize;
    ALLOCATE(info,w^.len*4);
    info2:=CAST(DebugInfo2Ptr,info);
    INC(info2,ModuleCount*SIZE(ModuleInfo)+4);
    DEBUGSym^.hunk^.mem:=info;
    DEBUGSym^.hunk^.type:=data;
    info^.modCount:=ModuleCount;
    info2^.modCount:=ModuleCount;
    m:=ModuleList.head;
    i:=0;
    WHILE m^.succ#NIL DO
      WITH m^ DO
      WITH info^.arr[i] DO
        modname:=name;
        modcodeSize:=m^.csize;
        cpuType:=mCpu;
        (*moddataSize:=*)
(*	WriteString(modname); WriteLn;*)
(*	FormatNr('  codelen:%06lx',modcodeSize);*)
	IF firstCode#NIL THEN
(*	  FormatNr(' startAdr:%06lx',firstCode^.startAdr);*)
(*	  FormatNr(' hunk:%ld',firstCode^.loadnr);*)
	  AddReloc(w^.rel32,firstCode^.loadnr,ADR(modcode)-LONGINT(info));
	  modcode:=firstCode^.startAdr;
	END;
	IF bss#NIL THEN
	  IF bss^.type=mergedbss THEN
	    bssmerged:=TRUE;
	    modbss:=bss^.startAdr-RESBASE;
	  ELSE
	    modbss:=bss^.startAdr;
	    AddReloc(w^.rel32,bss^.loadnr,ADR(modbss)-LONGINT(info));
	  END;
(*	  FormatNr(' datastart:%06ld',moddata);*)
(*	  FormatNr(' datahunk:%ld',data^.loadnr);*)
	END;
(*	WriteLn;*)
      END; (* With info^.arr[i] *)
      WITH info2^.arr2[i] DO
	IF ini#NIL THEN
	  IF ini^.type=mergeddata THEN
	    inimerged:=TRUE;
	    modini:=ini^.startAdr-RESBASE;
	  ELSE
	    modini:=ini^.startAdr;
	    AddReloc(w^.rel32,ini^.loadnr,ADR(modini)-LONGINT(info));
	  END;
	END;
      END; (* With info2^.arr[i] *)
      END; (* With m^ *)
      m:=m^.succ;
      INC(i);
    END;
    INC(HunkCount);
  END;

  IF RESLEN>10000H THEN Err('Mergedhunk >64KByte!',Empty) END;
  (* Referenz auf _BSSLEN vorhanden, dann TrickHunk, sonst BSS mit 0 fllen *)
  (* jetzt knnen wir richtig anfangen! *)

(*BreakPoint(ADR('nach newwrite'));*)
  CurrentHunk:=WriteList.head;
  WHILE CurrentHunk^.succ#NIL DO
    CurrentNr:=CurrentHunk^.nr;
    NextAlvOff:=CurrentHunk^.len*4;
    h:=CurrentHunk^.first;
    WHILE h#NIL DO
      DoReloc(h,h^.reloc8,byte);
      DoReloc(h,h^.reloc16,word);
      DoReloc(h,h^.reloc32,long);
      DoRefs(h);
      DoDReloc(h,h^.dreloc8,byte);
      DoDReloc(h,h^.dreloc16,word);
      DoDReloc(h,h^.dreloc32,long);
      h:=h^.next;
    END;
    CurrentHunk^.len:=(NextAlvOff+3) DIV 4;
    CurrentHunk:=CurrentHunk^.succ;
  END;

  UsedBSSLen:=BSSLenSym^.useCount>0;
  UsedNewDataL:=NEWDATALSym^.useCount>0;
  IF WriteFile() THEN
    isreentrant:=TRUE;
    FOR typ:=data TO fastbss DO
      IF HunkLen[typ]>0 THEN isreentrant:=FALSE END;
    END;
    isresident:=isreentrant;
    IF ~UsedNewDataL THEN
      isreentrant:=FALSE
    ELSE
      (* 12.4.91/bp Wenn reentrant startup, dann darf nur eine rel32 auf merged! *)
      IF relocsToMerged>1 THEN
        isreentrant:=TRUE; (* Hack: damit gleich Lschung erfolgt! *)
      END;
    END;
    IF verbose THEN
      FormatNr('%ld Bytes.  ',FileLen);
      FormatNr('%ld Hunks.  ',HunkCount);
      FormatNr('%ld ALVs erzeugt.\n',ALVCount);
      IF debug THEN
        WriteString(' Debug-Info verfgbar.\n');
      END;
      FOR typ:=code TO mergedbss DO
        IF HunkLen[typ]>0 THEN
          WriteString(HunkName[typ]^); FormatNr(':%ld ',HunkLen[typ]*4);
        END;
      END;
      WriteLn;
      IF MinCpu>objFile THEN
        WriteString('Das Programm bentigt mindestens eine ');
        CASE MinCpu OF
        | ob1File: WriteString('68010');
        | ob2File: WriteString('68020');
        | ob3File: WriteString('68030 oder 68020');
        | ob4File: WriteString('68040 oder 68020+68881');
        | ob8File: WriteString('68020+68881');
        END;
        WriteString(' CPU!\n');
      END;
    END;
    IF isreentrant THEN
      IF relocsToMerged>1 (*LinkerDBSym^.useCount>1*) THEN
        IF verbose THEN
          WriteString('FEHLER:\n Dies Programm KANN NICHT reentrant gelinkt werden!!\n'+
			       ' Mehr als eine Referenz auf den MERGED-Hunk!\n');
        END;
        IF DosL.DeleteFile(ADR(binName)) THEN END;
        loadErr:=TRUE;
      ELSE
        IF verbose THEN
	  FormatNr('Programm ist reentrant. Pure bit gesetzt. MindestStack: %ld\n'
		 ,NormalStack);
        END;
        IF DosL.SetProtection(ADR(binName),DosD.ProtectionFlagSet{DosD.pure}) THEN
        END; (* nur ein Versuch! *)
      END;
    ELSE (* nicht reentrant! *)
      IF DosL.SetProtection(ADR(binName),DosD.ProtectionFlagSet{}) THEN
      END; (* nur ein Versuch! *)
      IF verbose THEN
        WriteString('Programm ist NICHT reentrant. Pure bit gelscht.\n');
      END;
    END;
  ELSE
    IF verbose THEN WriteString('Schreibfehler!\n') END;
    loadErr:=TRUE;
  END;
  IF ~loadErr AND doStat THEN Stat END;
(* BreakPoint(ADR('ready'));*)
END Link;

(*$ CopyDyn:=FALSE *)
PROCEDURE Options(s:ARRAY OF CHAR; len:INTEGER):BOOLEAN;
TYPE Actions=(ok,showUsage,showOpts,useErr,cdErr,stackErr);
VAR set,okDir:BOOLEAN; status:Actions; cap:CHAR; i,pos:INTEGER;
    ef:ExtraFilePtr; st:LONGINT;
(*
 * -a=+askName -q=-verbose +x=+debug -i=-iconOn -r=+reentrant
 * -c=-smallCode -d=-smallData -m=+mini
 * +-Lname loadit
 * +-sstacksize
 * +-ttoFile (* Angabe Zielfile *)
 * +-gdir
 * ?=err, usage
 * ??=showstatus
 *  0..4,8=cpu
 *)
 BEGIN
  IF s[0]='?' THEN
    status:=showUsage;
    IF (HIGH(s)>0)&(s[1]='?') THEN status:=showOpts END;
  ELSE
    status:=ok;
    i:=0;
    LOOP
      cap:=CAP(s[i]);
      CASE cap OF (* zunchst kommt ja sicher '+' oder '-'! *)
      | '+': set:=TRUE;
      | '-': set:=FALSE;
      | '0'..'4','8': cpu:=ORD(s[i])-ORD('0');
      | 'Q': verbose:=set;
      | 'X': debug:=set;
      | 'I': iconOn:=set;
      | 'A': askModule:=set;
      | 'R': reentrant:=set;
      | 'C': smallCode:=set;
      | 'D': smallData:=set;
      | 'M': mini:=set;
      | 'P': doStat:=set;
      | 'L': ALLOCATE(ef,SIZE(ExtraFile));
	     pos:=0; INC(i);
	     WHILE i<len DO
	       ef^.name[pos]:=s[i];
	       INC(pos); INC(i)
	     END; (* hinten ist 0 wg. ALLOCATE! *)
	     ef^.next:=AuxFiles;
	     AuxFiles:=ef;
      | 'S': st:=0; INC(i);
	     WHILE i<len DO
	       IF (s[i]>='0')&(s[i]<='9') THEN
	         st:=st*10+ORD(s[i])-30H;
	       ELSE
	         status:=stackErr;
	         EXIT
	       END;
	       INC(i);
	     END;
	     NormalStack:=st;
      | 'T':	INC(i); (*tofile!*)
		pos:=0;
		WHILE i<len DO
		  binName[pos]:=s[i]; INC(i); INC(pos)
		END;
		binName[pos]:=0C;
		ignoreBin:=TRUE;
      | 'G':	INC(i);pos:=0; (* cd Directory *)
		WHILE i<len DO
		  binName[pos]:=s[i];
		  INC(pos); INC(i)
		END;
		binName[pos]:=0C;
		ForgetPathTable;
		okDir:=GotoDir(binName);
		ReadPathTable(pathFileName); (* und neu lesen! *)
		IF ~okDir THEN
		  status:=cdErr; EXIT
		END;
      | ELSE
	  status:=useErr;
	  EXIT
      END; (* case *)
      INC(i);
      IF i>=len THEN EXIT END;
    END; (* loop *)
    IF askModule OR interActive THEN interActive:=TRUE; verbose:=TRUE END;
  END;
  IF status#ok THEN
    SetReply(rcIllOpt);
    verbose:=TRUE;
    CASE status OF
    | showUsage,showOpts:
      WriteString(title1); WriteString(vers);
      Format(usage,ADR(programName));
      IF status=showOpts THEN
        WriteString('Status:\n  ');
        Write(plusMinus[smallCode]); WriteString('C (smallCode)   ');
        Write(plusMinus[smallData]); WriteString('D (smallData)   ');
        Write(plusMinus[iconOn]);    WriteString('I (icon)\n  ');
        Write(plusMinus[askModule]); WriteString('A (askModule)   ');
        Write(plusMinus[reentrant]); WriteString('R (reentrant)   ');
        Write(plusMinus[mini]);      WriteString('M (minArts)\n  ');
        Write(plusMinus[debug]);     WriteString('X (debug)       ');
        Write(plusMinus[doStat]);    WriteString('P (mapFile)     ');
        WriteString('CPU: '); Write(CHAR(cpu+30H));
        FormatNr('        MinStack: %ld\n',NormalStack);
      END;
    | useErr:
      pos:=INTEGER(cap);
      Format('Das Zeichen "%c" ist keine gltige Option!\n',ADR(pos));
    | cdErr:
      WriteString("Verzeichnis nicht gefunden!\n");
    | stackErr:
      WriteString("Ungltige Stackangabe!\n");
    END;
  END;
  RETURN (status=ok) OR (status=showOpts);
END Options;


BEGIN
  SETREG(8,ADR(verDollar));
  verbose:=TRUE; debug:=TRUE; askModule:=FALSE; doStat:=FALSE;
  smallCode:=TRUE; smallData:=TRUE;
  reentrant:=FALSE; mini:=FALSE;
  NormalStack:=4000;
  cpu:=0;
  iconOn:=wbStarted;
  crash:=TRUE;
(*
  AuxFiles:=NIL;
  dejaVue:=FALSE;
*)
  plusMinus[FALSE]:='-'; plusMinus[TRUE]:='+';

  SETREG(0,InitHandler(Options,defaultSize,
    ADR(rexxStr),ADR(portName),ADR(inMsg),ADR("ENV:m2l"),ADR("m2l.opt")));

  WriteString(title2); WriteString(vers);

  (* 12.9.92/bp bei link von Workbench wird sonst m2l.opt nicht gefd! *)
  ReadPathTable(pathFileName);

  (* Nun erstes Arg holen oder noch nicht, je nachdem...! *)
  IF ~FetchName() THEN crash:=FALSE; RETURN END; (* bei Aufruffehler gleich raus *)
  IF fNameLen=0 THEN interActive:=TRUE; verbose:=TRUE END;
  LOOP
    IF dejaVue OR (fNameLen=0) THEN
      REPEAT UNTIL FetchName(); (* bis Leerstring oder guter *)
    END;
    dejaVue:=TRUE;
    IF interActive THEN verbose:=TRUE; END;
    IF fNameLen=0 THEN EXIT END;
    IF    debug&reentrant THEN	startupName:='DRArts'
    ELSIF debug		  THEN	startupName:='DArts'
    ELSIF mini&reentrant  THEN	startupName:='MRArts'
    ELSIF mini&~reentrant THEN	startupName:='MArts'
    ELSIF reentrant	  THEN	startupName:='RArts'
    ELSE			startupName:='Arts'
    END;
    loadErr:=FALSE;
    tempAskModule:=askModule; (* kann sich bei '-' ndern! *)

    ForgetPathTable;
    SETREG(0,DosL.CurrentDir(myCD));
    ReadPathTable(pathFileName);

    Call(Link);

    ForgetMem;
    ignoreBin:=FALSE;
    AuxFiles:=NIL;
    IF loadErr THEN
      (* 30.12.90/bp bei quiet NICHT in interActive gehen! *)
      IF verbose THEN interActive:=TRUE END;
      SetReply(rcActionErr);
    END;
  END; (* loop *)
  IF interActive&verbose THEN
    WriteString(exit);
  END;
  waitCloseGadget:=verbose & ~interActive;
  crash:=FALSE;
CLOSE
  (* 30.12.90/bp bei Ctrl-C oer Absturz auf jeden Fall Fehler melden! *)
  IF crash THEN SetReply(rcActionErr) END;
END m2l.
