MODULE m2error;
(*$ LargeVars:=FALSE StackChk:=FALSE Volatile:=FALSE StackParms:=FALSE *)
(*
 * 12.11.90/bp
 * Neue Option +-lNummer : nur die Nummer ausgeben
 * 4.9.90/bp
 * Aktuelle Version ist deutsch UND englisch!
 *
 * 27.05.89 / ms
 *
 * Aktuelle Version ist in DEUTSCH
 *)
(*$ DEFINE English:=FALSE *)
FROM SYSTEM	IMPORT	ADDRESS,BITSET,ADR,CAST,SETREG;
FROM AMScan	IMPORT	ScanString;
FROM ArgHandler IMPORT	FetchName,InitHandler,fName,fNameLen,interActive,
			SetReply;
FROM ReplyVals	IMPORT	rcActionErr,rcMainNotFound,rcImportantNotFound,rcIllOpt;
FROM Arts	IMPORT	programName;
FROM ASCII	IMPORT	nul,ht,eol,eof;
FROM M2File	IMPORT	FileType,GetInputFile,pathFileName,ReadPathTable;
FROM SeqIO	IMPORT	SeqKey,OpenSeqIn,CloseSeq,SeqGetB,SeqInCount,
			SeqInLen,SeqOk,SeqInPos;
FROM Terminal	IMPORT	waitCloseGadget,Read,Write,WriteLn,WriteString,
			Format,FormatS,ReadLn;
FROM Break	IMPORT	TestBreak;
FROM String	IMPORT	Occurs,LastPos,Length;
FROM M2Amiga	IMPORT	GetErrMsgs, FreeErrMsgs, ErrorPtr;

CONST
 inMsg="m2error> ";
 title1="m2error";
 title2=
(*$ IF English *) "Amiga Modula-2 Error Lister";
(*$ ELSE *)	  "Amiga Modula-2 Fehlerlister";
(*$ ENDIF *)
 ver="4.4";
 date=COMPILEDATE;
 verDollar="$VER: m2error "+ver+" "+date;
 version=
(*$ IF English *) ", "+ver+"e, "+date+"\n";
(*$ ELSE *)	  ", "+ver+"d, "+date+"\n";
(*$ ENDIF *)
 usage=
(*$ IF English *)  "Usage:\n %s {+-x -l[ErrorNumber] ModulName}\n";
(*$ ELSE *)	  "Aufruf:\n %s {+-x -l[ErrorNumber] ModulName}\n";
(*$ ENDIF *)
 exit=
(*$ IF English *) " --- exit\n";
(*$ ELSE *)	  " --- ende\n";
(*$ ENDIF *)
 msgNotFound=
(*$ IF English *) " Error-Messages not found or insufficient memory\n";
(*$ ELSE *)	  " Fehler-Meldungen nicht gefunden oder zuwenig Speicher\n";
(*$ ENDIF *)
 errFileNotFound=
(*$ IF English *)  "%s: No error file found\n";
(*$ ELSE *)	   "%s: Keine Fehlerdatei gefunden\n";
(*$ ENDIF *)
 fileNotFound=
(*$ IF English *)  "%s: File not found\n";
(*$ ELSE *)	   "%s: Datei nicht gefunden\n";
(*$ ENDIF *)

 prompt="in> ";
 errTag=CHAR(0C1H);
 strTag=CHAR(0C2H);
 defInfo=0;
 modInfo=1;
 defDir="txt/";
 defExt=".def";
 modDir=defDir;
 modExt=".mod";

TYPE
 ErrorType=(number,string);
 ErrorPart=RECORD
  type: ErrorType;
  errNo: INTEGER;
  str: ARRAY [0..63] OF CHAR
 END;

VAR
 err,src: SeqKey;
 errLst: ErrorPtr;
 ch: CHAR; (* global lookahead character *)
 cp,lastPos: LONGINT;
 llen: INTEGER;
 interactive,notX: BOOLEAN;
 lineNr: CARDINAL;
 line,out: ARRAY [0..255] OF CHAR;


PROCEDURE OutCard(str:ADDRESS; c: CARDINAL);
BEGIN
 Format("%5d\t%s\n",ADR(c));
END OutCard;

PROCEDURE PrintErrMsgs(errLst: ErrorPtr);
VAR
 stk: RECORD no: INTEGER; str: ADDRESS END;
BEGIN
 WHILE errLst#NIL DO
  WITH errLst^ DO
   stk.no:=no; stk.str:=ADR(msg);
  END;
  Format('%5d: %s\n',ADR(stk));
  TestBreak;
  errLst:=errLst^.next
 END
END PrintErrMsgs;

PROCEDURE FetchErrMsg(errLst: ErrorPtr; error: INTEGER);
VAR
 stk: RECORD no: INTEGER; str: ADDRESS END;
 errPtr: ErrorPtr;
BEGIN
 stk.no:=error;
 errPtr:=errLst;
 WHILE (errLst#NIL) & (errLst^.no#error) DO
  errLst:=errLst^.next
 END;
 (* 21.2.89/ms
  * Falls der Fehler nicht gefunden wird, kann es sich noch
  * um einen 68xx Fehler handeln. Diese sind mit Nullen anstelle der x
  * in der Liste eingetragen.
  *)
 IF errLst=NIL THEN
  errLst:=errPtr;
  error:=error-(error MOD 100);
  WHILE (errLst#NIL) & (errLst^.no#error) DO
   errLst:=errLst^.next
  END
 END;
 IF errLst#NIL THEN
  WITH errLst^ DO
   stk.str:=ADR(msg);
  END;
  IF error<=15000 THEN
   Format("%5d: %s",ADR(stk))
  ELSE
   Format(" %s",ADR(stk.str))
  END
 ELSE
  Format("<%d>",ADR(error))
 END
END FetchErrMsg;

PROCEDURE ReadErrorPos(VAR errorPos: LONGINT): BOOLEAN;
VAR
 trick: RECORD
  CASE :INTEGER OF
  | 1: ch: ARRAY [0..3] OF CHAR
  | 2: li: LONGINT
  END
 END;
BEGIN
 IF ch=errTag THEN
  SeqGetB(err,ch);
  SeqGetB(err,ch);
  SeqGetB(err,ch);
  WITH trick DO
   SeqGetB(err,ch[0]);
   SeqGetB(err,ch[1]);
   SeqGetB(err,ch[2]);
   SeqGetB(err,ch[3]);
   errorPos:=li
  END;
  SeqGetB(err,ch);
  RETURN SeqOk(err);
 END;
 RETURN FALSE
END ReadErrorPos;

PROCEDURE ReadErrorPart(VAR errorPart: ErrorPart): BOOLEAN;
VAR
 i: INTEGER;
BEGIN
 WITH errorPart DO
  IF ch<CHAR(080H) THEN
   type:=number;
   errNo:=ORD(ch);
   SeqGetB(err,ch);
   errNo:=256*errNo+ORD(ch);
   SeqGetB(err,ch)
  ELSIF ch=strTag THEN
   type:=string;
(* 28.5.89/ms Einfgen eies Leerzeichens am Anfang des Strings *)
   str[0]:=' '; i:=1;
   REPEAT
    SeqGetB(err,ch);
    IF i<128 THEN str[i]:=ch END;
    INC(i)
   UNTIL ch=nul;
   IF ODD(i) THEN SeqGetB(err,ch) END;
   SeqGetB(err,ch)
  ELSE
   RETURN FALSE
  END
 END;
 RETURN SeqOk(err)
END ReadErrorPart;

PROCEDURE ReadLine(VAR line: ARRAY OF CHAR; VAR len: INTEGER);
VAR
 ch: CHAR;
BEGIN
 len:=0;
 LOOP
  SeqGetB(src,ch);
  IF ~SeqOk(src) THEN
   line[0]:=nul; len:=-1; RETURN
  ELSIF ch=eol THEN
   EXIT
  ELSIF len<=HIGH(line) THEN
   line[len]:=ch;
   INC(len)
  END
 END;
 IF len<=HIGH(line) THEN
  line[len]:=nul
 END;
 TestBreak;
END ReadLine;

PROCEDURE DisplayPos(pos: LONGINT);
VAR
 ch: CHAR;
 i,ofs: INTEGER;
BEGIN
 IF lastPos=pos THEN
  RETURN
 ELSIF notX & (cp<pos-100) THEN
  WriteString("\n ... \n\n");
  REPEAT
   ReadLine(line,llen); INC(lineNr);
   IF llen<0 THEN
    cp:=MAX(LONGINT);
    RETURN
   END;
   INC(cp,llen); INC(cp);
  UNTIL (cp>=pos-100);
 ELSIF cp<=pos THEN
  WriteLn
 END;
 WHILE cp<=pos DO
  ReadLine(line,llen); INC(lineNr);
  IF llen<0 THEN
   cp:=MAX(LONGINT);
   RETURN
  END;
  INC(cp,llen); INC(cp);
  OutCard(ADR(line),lineNr);
 END;
 ofs:=0;
 FOR i:=0 TO INTEGER(pos-cp+LONGINT(llen))-1 DO
  IF line[i]=ht THEN
   ofs:=CAST(INTEGER,CAST(BITSET,ofs)+{0..2}); (* ofs |= 0x07 *)
  END;
  INC(ofs)
 END;
 out[0]:=ht;
 IF ofs>=0 THEN
  out[1]:='|'; DEC(ofs);
  out[ofs+3]:='^';
  out[ofs+4]:=0C;
  INC(ofs,2);
  WHILE ofs>=2 DO
   out[ofs]:='-';
   DEC(ofs);
  END
 END;
 WriteString(out);
 WriteLn;
 lastPos:=pos
END DisplayPos;

PROCEDURE DisplayPart(part: ErrorPart);
BEGIN
 WITH part DO
  IF type=string THEN
   WriteString(str)
  ELSE
   FetchErrMsg(errLst,errNo);
  END
 END
END DisplayPart;

PROCEDURE ShowError(VAR name: ARRAY OF CHAR): BOOLEAN;
VAR
 i,len: INTEGER;
 pos: LONGINT;
 part: ErrorPart;
 result: BOOLEAN;
BEGIN
 result:=TRUE;
 lineNr:=0;
 IF (LastPos(name,1000,".")<0) OR (CAP(name[Length(name)-1])='D') THEN (* 26.1.91/bp kein ".": default .mod *)
   GetInputFile(name,modFile,name);
 ELSE
   GetInputFile(name,defFile,name);
 END;
 len:=Length(name);
 cp:=0; lastPos:=0;
 IF OpenSeqIn(src,name,8192) THEN
  name[len]:='E'; name[len+1]:=nul;
  IF OpenSeqIn(err,name,2048) THEN
   name[len]:=nul;
   FOR i:=0 TO 4 DO SeqGetB(err,ch) END; (* skip tag / read first char *)
   WHILE ReadErrorPos(pos) DO
    DisplayPos(pos);
    Write(ht); Write('|');
    WHILE ReadErrorPart(part) DO
     DisplayPart(part)
    END;
    WriteLn
   END;
   IF ~notX THEN (* show rest *)
    REPEAT
     ReadLine(line,i); INC(lineNr);
     OutCard(ADR(line),lineNr);
    UNTIL i<0
   END;
   CloseSeq(err)
  ELSE
   FormatS(errFileNotFound,name);
   SetReply(rcActionErr); (* SourceE *)
  END;
  CloseSeq(src);
  RETURN FALSE
 ELSE
  FormatS(fileNotFound,name);
  SetReply(rcMainNotFound); (* Source *)
  RETURN TRUE
 END
END ShowError;

VAR
 argErr,dejaVue,listMsgs: BOOLEAN;

(*$ CopyDyn:=FALSE *)
PROCEDURE OptProc(s:ARRAY OF CHAR; len:INTEGER):BOOLEAN;
VAR set,ok:BOOLEAN; i:INTEGER; st:LONGINT;
BEGIN
  IF s[0]='?' THEN
    ok:=FALSE;
  ELSE
    ok:=TRUE;
    i:=0;
    LOOP
      CASE CAP(s[i]) OF (* zunchst kommt ja sicher '+' oder '-'! *)
      | '+': set:=TRUE;
      | '-': set:=FALSE;
      | 'X': notX:=set;
      | 'L': st:=0; INC(i);
             IF i>=len THEN
               st:=-1;
	       PrintErrMsgs(errLst);
	       listMsgs:=TRUE;
             ELSE
	       WHILE i<len DO
	         IF (s[i]>='0')&(s[i]<='9')&(st<100000) THEN
	           st:=st*10+ORD(s[i])-30H;
	         ELSE
	           ok:=FALSE;
	           EXIT
	         END;
	         INC(i);
	       END;
	       IF st<=MAX(INTEGER) THEN
	         FetchErrMsg(errLst,st); WriteLn;
	       ELSE
	         ok:=FALSE;
	         EXIT
	       END;
	     END;
      | ELSE
	  ok:=FALSE;
	  EXIT
      END; (* case *)
      INC(i);
      IF i>=len THEN EXIT END;
    END; (* loop *)
  END;
  IF ~ok THEN
    WriteString(title1); WriteString(version);
    Format(usage,ADR(programName));
    SetReply(rcIllOpt);
  END;
  RETURN ok;
END OptProc;

BEGIN
 SETREG(11,ADR(verDollar));
 notX:=TRUE; listMsgs:=FALSE;
 InitHandler(OptProc,ADR(inMsg),ADR("ENV:m2error"),ADR("m2error.opt"));

 WriteString(title2); WriteString(version);

 errLst:=GetErrMsgs();
 IF errLst#NIL THEN
   IF ~FetchName() THEN RETURN END;
   IF fNameLen=0 THEN interActive:=TRUE END;

   IF listMsgs THEN RETURN END;
   ReadPathTable(pathFileName);
   argErr:=interActive;
   LOOP
     IF dejaVue OR (fNameLen=0) THEN
       REPEAT
       UNTIL FetchName(); (* bis Leerstring oder guter *)
     END;
     dejaVue:=TRUE;
     IF fNameLen=0 THEN EXIT END;
     argErr:=ShowError(fName) OR argErr;
     IF argErr THEN interActive:=TRUE END;
   END
 ELSE
   WriteString(msgNotFound);
   SetReply(rcImportantNotFound);
 END;
 waitCloseGadget:=~interActive;
CLOSE
  IF errLst#NIL THEN FreeErrMsgs; errLst:=NIL END;
END m2error.
