IMPLEMENTATION MODULE m2d;
(*$ LargeVars:=FALSE StackParms:=FALSE Volatile:=FALSE *)
(*
 * 1.1.91/bp
	Bei Records wird nun beim jeweils ersten Feld eines CASE-Falls
	ein '' angezeigt. (kleines c fr Case)
 * 14.4.89/ms
 *	Nun wird in der traceList zu jedem Knoten auch die aktuelle TopLine
 *	abgelegt. Dadurch erscheit beim Zurckblttern die ursprngliche
 *	Position.
 * 4.1.89/ms
 *
 * $ S-
 *---------------------------------------------------------------------------
 * Portable part of debugger
 *---------------------------------------------------------------------------
 *)


(*
 * 15.11.90/bp
 * ImmSource heit, das SOFORT die SourcePos angezeigt wird.
 * Das dauert aber bei groen Sourcen (M2AM=85KByte!) SEHR lang!
 * Sollte eigentlich vom Benutzer eingestellt werden knnen, aber
 * ich ndere ungern das Format von m2d.layout
 *
 * 6.2.94/bp
 * Ungltige Zeiger werden als X Adresse angezeigt und gehen nicht
 * weiter (also nicht "* xxxxxx")
 * Prfung mit TypeOfMem()
 *)

FROM SYSTEM IMPORT
 ADDRESS,ADR,CAST,LONGSET,SHIFT;
IMPORT SYSTEM;
FROM ExecL IMPORT TypeOfMem;
IMPORT A:Arts;
IMPORT DBD: DebugDef;
FROM m2cd IMPORT  (* COMPILER dependent part *)
 illSourcePos,StrPtr,StrForm,Item,ItemInfo,VarModes,VarModeSet,srcPos,
 GetErrPosition,GetModuleItem,GetProcedureItem,GetItemInfo,GetBrotherItem,
 GetSonItem,EmptyItem,NumberOfSons,FindType,ChangeType,
 OpenSource,SourceLength,ReadSourceChar,FindLine,GotoLine,
 InitM2CD,ExitM2CD,ForgetM2CD;

FROM m2md IMPORT  (* MACHINE dependent part *)
 maxMods,nil,IndType,modInfoList,procInfoList,processStatus,
 FindModule,GetProcedureChain,GetProcessStatus,GetValue,
 GetAddress,GetHIGH,InitM2MD,ExitM2MD;

FROM m2ud IMPORT  (* USER dependent part *)
 CommandType,SelectionKind,SelectionSet,Command,GetCommand,
 Window, WindowHeight, WindowWidth, WindowTopLine, RestoreWindow,
 InitWindowStatus, InitActions, RestoreLayout, ReadLayout, SaveLayout,
 DispLn, DispString, DispCard, DispInt, DispHex, DispChar, DispReal, DispFFP,
 DispLReal, Tab, Mark, InputString,InitM2UD,ExitM2UD,srcImm,Beep;

FROM ASCII IMPORT
 eol, ht;

FROM Conversions IMPORT
 ValToStr;

FROM String IMPORT
 last, CopyPart, Copy, FirstPos;
(*FROM Terminal IMPORT Write,WriteString,FormatNr,WriteLn;*)
(*---------------------------------------------------------------------------*)

CONST
 ok=FALSE;
 err=TRUE;
 headLines=2; (* in data windows *)
 noSourceFile=
(* "-- No Source File"; *)
   "-- Kein Quelltext vorhanden";
 noReferenceFile=
(* "-- No Reference File"; *)
   "-- Keine Referenzdatei vorhanden";
 pointsTo=
(* "Points to:"; *)
   "Zeigt auf:";
 address=
(* "Address "; *)
   "Adresse ";

TYPE
 Value=RECORD
  CASE :StrForm OF
  | Undef..Range,BPointer,Pointer,ProcTyp: p1:LONGINT; i:LONGINT;
  | FFP: p2:LONGINT; f:SYSTEM.FFP;
  | Real: p3:LONGINT; r:REAL;
  | LReal,UReal: lr:LONGREAL;
  | Set: p4:LONGINT; s:LONGSET;
  ELSE (* no fields *)
  END;
 END;

  (*
   * In the data window it is possible to walk through pointer lists, inspect
   * record fields and array elements. All elements of such a walk are stored
   * in a TraceInfoList. The global fields of a TraceInfoList are:
   *
   * string: All identifiers.
   * minPos: Points to the first item displayed in the header line.
   * curPos: Points to the last item in the list.
   *
   * For each field an entry in the list exists. This contains:
   *
   * item: The item represeting this field or element.
   * from: index into the string array defining the first character of the name.
   * to: index into the string array defining the first character of the next
   *     name.
   * wTopLine: Current top line of the window is remebered to return correctly.
   *
   * The length of the string is 5 times the number of trace infos. This
   * assume that a field/element identifier has a mean length of 5 characters.
   *)

CONST
 maxTrace=100;
 maxString=5*maxTrace;

TYPE
 TraceInfo=RECORD
  item:Item;
  from,to,wTopLine:CARDINAL;   (* 14.4.89/ms wTopLine *)
 END;
 TraceInfoList=RECORD (* 1.5 kBytes *)
  string:ARRAY [0..maxString] OF CHAR;
  minPos,curPos:INTEGER;
  list:ARRAY [1..maxTrace] OF TraceInfo;
 END;

VAR
 prcDataWdw,modDataWdw:Window;
 exitDebugger,srcIsMod:BOOLEAN;
 errorStart,errorStop:LONGINT;
 traces:ARRAY [dt1Wdw..dt2Wdw] OF TraceInfoList;

(*---------------------------------------------------------------------------*)

PROCEDURE Length(VAR s:ARRAY OF CHAR):CARDINAL;
   (*
    * Returns the length of string s.
    *)
 VAR
  i:CARDINAL;
 BEGIN
  i:=0;
  WHILE (i<=CARDINAL(HIGH(s))) & (s[i]#0C) DO INC(i); END;
  RETURN i;
 END Length;

(*$ CopyDyn:=FALSE *)
PROCEDURE Concat(VAR a:ARRAY OF CHAR; b:ARRAY OF CHAR);
   (*
    * Adds string b to string a iff there's enough room, otherwise
    * a is left unchanged. If a was NUL terminated, then it is also
    * NUL terminated after Concat.
    *)
 VAR i, la, lb: INTEGER;
 BEGIN
  la:=Length(a); lb:=Length(b);
  IF la+lb <= HIGH(a) THEN
   FOR i:=0 TO lb-1 DO a[la+i]:=b[i] END;
   a[la+lb]:=0C
  END
 END Concat;

(*$ CopyDyn:=FALSE *)
PROCEDURE Insert(VAR trace:TraceInfoList; it:Item; s:ARRAY OF CHAR;
                 topLine: CARDINAL; first:BOOLEAN);
   (*
    * Insert a new item and its name in the TraceInfoList. If first
    * is TRUE, then the list is reset and the item inserted as first
    * item in the list.
    *)
 VAR
  l:CARDINAL;
 BEGIN
(* WriteString('Insert: '); WriteString(s); WriteLn;*)
  WITH trace DO
     (*
      * If first then reset trace.
      *)
   IF first THEN curPos:=0; minPos:=1 END;
   IF curPos<maxTrace THEN
     (*
      * If we didn't reach the last element of the TraceInfoList, we
      * can add another one. from is set to the beginning of the string
      * and to is set to the character following the last character of
      * the end.
      *)
    INC(curPos);
    WITH list[curPos] DO
     IF curPos>1 THEN
      from:=list[curPos-1].to; list[curPos-1].wTopLine:=topLine
     ELSE
      from:=0; wTopLine:=0
     END;
     l:=Length(s); to:=from+l;
     IF to>maxString THEN
      DEC(curPos); (* reject as there is no room for the string *)
     ELSE
      WHILE l>0 DO DEC(l); string[from+l]:=s[l] END;
      item:=it;
     END;
    END;
   END;
  END;
 END Insert;

PROCEDURE RestoreWindow0(u: Window; topLine: CARDINAL);
  (*
   * Set the number of the first line of the window to 0 and the
   * number of lines in this window also to 0 (empty window).
   *)
 BEGIN
  InitWindowStatus(u,topLine,topLine); RestoreWindow(u);
 END RestoreWindow0;

(*---------------------------------------------------------------------------*)

PROCEDURE DisplaySource(topLine,displayLines:CARDINAL);
    (*
     *
     *)
 VAR
  atom:ARRAY [0..255] OF CHAR;
  i,line,linePos:CARDINAL;
  ch:CHAR;
 BEGIN
  IF srcPos=illSourcePos THEN
   (*
    * If there is no source file, then set the window to display
    * a single line and write the text "No source file".
    *)
   InitWindowStatus(srcWdw,0,1); DispString(srcWdw, noSourceFile, 0)
  ELSE
    (*
     * Reposition Source to the current topLine and init the window
     * to this position.
     *)
   GotoLine(topLine);
   InitWindowStatus(srcWdw,topLine,SourceLength());
    (*
     * Read the source and display it atom-wise, i.e. Call DispString
     * only when you encounter a blank, a semicolon or the end of the
     * line or the end of the source. When the errorStart is reached,
     * then Inversedisplaying is switched on. It is switched off when
     * errorStop is reached or at the end of line, whichever comes first.
     *)
   line:=0; i:=0; linePos:=0;
   REPEAT
(*
 * 4.1.89/ms Hier stand die ReadSourceChar Anweisung, die jetzt weiter unten
 *           Platz gefunden hat. Die srcPos bezieht sich jeweils auf den
 *           nchsten gelesenen Buchstaben. Ergo mssen diese Tests vorher
 *           passieren.
 *)
    IF errorStart#0 THEN  (* error in source file *)
     IF srcPos=errorStart THEN Mark(srcWdw, TRUE)
     ELSIF srcPos=errorStop THEN Mark(srcWdw, FALSE)
     END
    END;
    ReadSourceChar(ch);
    IF ch=eol THEN
     linePos:=0;
     INC(line); atom[i]:=0C;
     DispString(srcWdw, atom, 0); i:=0;
     IF srcPos>errorStart THEN Mark(srcWdw, FALSE) END;
     DispLn(srcWdw);
    ELSE
(*
 * 31.12.88/ms Hier mssen die Tabulatoren richtig expandiert werden. Dazu
 *             wird der gleiche Mechanismus wie im Editor verwendet.
 *)
     IF ch=ht THEN
      REPEAT atom[i]:=' '; INC(i); INC(linePos) UNTIL (linePos MOD 8)=0
     ELSE
      atom[i]:=ch; INC(i); INC(linePos)
     END;
     IF (ch=' ') OR (ch=';') OR (ch=0C) OR (i>=127) OR (ch=ht) THEN
      atom[i]:=0C; DispString(srcWdw, atom, 0); i:=0
     END
    END;
   UNTIL (line=displayLines) OR (ch=0C);
   Mark(srcWdw, FALSE)
  END
 END DisplaySource;

PROCEDURE SelectSource(sel: SelectionSet; line, column: CARDINAL);
   (*
    * If you click with the left mousebutton in the source nothing
    * happens.
    *)
 END SelectSource;

(*---------------------------------------------------------------------------*)

PROCEDURE DisplayData(u:Window; topLine,displayLines:CARDINAL);

 PROCEDURE DispValue(item:Item; val:Value; n:INTEGER);
   (*
    * Display the value of a variable, record field or array element.
    *)
  VAR
   info:ItemInfo;
   b:SHORTINT;
   w:INTEGER;
   regS:ARRAY[0..7] OF CHAR;
  BEGIN
   GetItemInfo(item, info);
   IF info.mode=regVar THEN
     regS[0]:='{'; regS[1]:='R'; regS[2]:='.';
     IF info.adr>=16 THEN
       regS[3]:='F'; regS[4]:='P'; w:=5;
     ELSIF info.adr>=8 THEN
       regS[3]:='A'; w:=4;
     ELSE
       regS[3]:='D'; w:=4;
     END;
     regS[w]:=CHAR(info.adr MOD 8 +30H);
     regS[w+1]:='}'; regS[w+2]:=0C;
     DispString(u,regS,n);
   ELSIF info.mode=extVar THEN
     DispString(u,'{ext LARGE}',n);
   ELSIF info.mode=smallExtVar THEN
     DispString(u,'{ext SMALL}',n);
   ELSE
   WITH val DO
    CASE info.form OF
    | Undef, Pointer, BPointer: (* BYTE, WORD, ADDRESS, BPTR and all ptrs *)
   (*$ RangeChk:=FALSE *)
     IF info.size=1 THEN b:=SHORTINT(i); DispHex(u,b,n)
     ELSIF info.size=2 THEN w:=INTEGER(i); DispHex(u,w,n)
   (*$ POP RangeChk *)
     ELSE (* size=4 *)
      GetSonItem(item,0);
      IF i=nil THEN DispString(u,'NIL',n)
      ELSIF EmptyItem(item) THEN DispHex(u,i,n) (* no baseTyp: ADDRESS,BPTR *)
(* Ungltige Adressen: *)
      ELSIF CAST(LONGSET,TypeOfMem(i)) = LONGSET{} THEN
        DispChar(u,'!',1); DispHex(u,i,n-1);
      ELSE DispChar(u,'*',1); DispHex(u,i,n-1)
      END
     END;
    | Bool:
     (*$ RangeChk:=FALSE *) b:=SHORTINT(i); (*$ POP RangeChk *)
     IF b=0 THEN DispString(u,'FALSE',n)
(*
 * 17.4.89/ms
 *	Hier habe ich b=1 hineingeschmuggelt. Dies ist ntig, damit Arrays
 *	ber [FALSE..TRUE] richtig dargestellt werden knnen.
 *)
     ELSIF (b=-1) OR (b=1) THEN DispString(u,'TRUE',n)
     ELSE DispChar(u,'?',1); DispHex(u,b,n-1)
     END
    | Char: (*$ RangeChk:=FALSE *)
         DispChar(u,CAST(CHAR,SHORTINT(i)),n)
          (*$ POP RangeChk *)
    | UInt:
     IF info.sign THEN DispInt(u,i,n) ELSE DispCard(u,CAST(LONGCARD,i),n) END
    | Enum:
         (*
          * Look for the ConstChain and select the i-th item of it.
          * Its itemInfo contains the name of the requested element.
          * 1.1.91/bp Enums knnen nun beliebig beginnen!
          *)
     GetSonItem(item,0);
     GetBrotherItem(item,i);
     IF item.obj#NIL THEN
      GetItemInfo(item,info);
      DispString(u,info.nameSpelling,n)
     ELSE
      DispChar(u,'?',1); DispHex(u,i,n-1)
     END
    | Range: GetSonItem(item,0); DispValue(item,val,n)
    | FFP: DispChar(u,' ',1); DispFFP(u,f,n-1)
    | Real: DispChar(u,' ',1); DispReal(u,r,n-1)
    | LReal, UReal: DispChar(u,' ',1); DispLReal(u,lr,n-1)
    | Set:
     DispChar(u,'*',1); DEC(n);
   (*$ RangeChk:=FALSE *)
     IF info.size=1 THEN b:=SHORTINT(i); DispHex(u,b,n)
     ELSIF info.size=2 THEN w:=INTEGER(i); DispHex(u,w,n)
   (*$ POP RangeChk *)
     ELSE DispHex(u,i,n)
     END
    | ProcTyp: DispHex(u,i,n)
    | Opaque: DispString(u,'(opaque)',n)
    | Array:
     DispChar(u,'*',1);
     IF info.dyn THEN DispString(u,'(dyn)',n-1);
     ELSE DispCard(u,info.size,n-1);
     END
    | Record: DispChar(u,'*',1); DispCard(u,info.size,n-1)
    | Mod: DispString(u,'local',n)
    | Prc: DispString(u,'?Prc',n)       (* error: should not *)
    | String: DispString(u,'?String',n) (*        occur      *)
    END
   END
   END;
  END DispValue;

 VAR
  fatherItem: Item;

 PROCEDURE DispHeaderType;
  VAR
   item, item1: Item;
   info, info1: ItemInfo;
   val: Value;
  BEGIN
   GetItemInfo(fatherItem, info); item:=fatherItem;
   DispLn(u); DispString(u,'-- Type = ',0);
(*
 * 17.4.89/ms
 *	Hier habe ich typeSpelling nach nameSpelling umgewandelt
 *  1.7.89/ms
 *	Korrektur der obigen nderung. Sobald kein Name vorhanden ist
 *	sollte der Typ-Name verwendet werden.
 *  1.11.89/jr
 *      wieder zurckgendert
 *
 *)
   DispString(u, info.typeSpelling, 0);
   DispString(u, '  ', 0);
   CASE info.form OF
   | BPointer:
    DispString(u,'(BPOINTER TO ',0);
    GetSonItem(item,0); GetItemInfo(item,info);
    DispString(u,info.typeSpelling,0); DispChar(u,')',1)
   | Pointer:
    DispString(u,'(POINTER TO ',0);
    GetSonItem(item,0); GetItemInfo(item,info);
    DispString(u,info.typeSpelling,0); DispChar(u,')',1)
   | Array:
    DispString(u,'(ARRAY [',0); item1:=item;
    IF info.dyn THEN
     DispCard(u,0,0); DispString(u,'..',0);
     DispCard(u,fatherItem.ahigh,0);
    ELSE
     GetSonItem(item1,1); GetItemInfo(item1,info1);  (* index *)
     val.i:=info1.min;
     DispValue(item1,val,1); DispString(u,'..',0);
     val.i:=info1.max;
     DispValue(item1,val,1)
    END;
    DispString(u,'] OF ',0);
    GetSonItem(item,0); GetItemInfo(item,info);  (* elem *)
    DispString(u,info.typeSpelling,0); DispChar(u,')',1)
   | Record:
    DispString(u,'(RECORD)',0)
   ELSE
   END
  END DispHeaderType;

 PROCEDURE WindowLines(len: LONGINT);
  VAR i: INTEGER;
  BEGIN
   INC(len, headLines);
   IF len>MAX(CARDINAL) THEN len:=MAX(CARDINAL) END;
   (*$ RangeChk:=FALSE *) InitWindowStatus(u, topLine, len); (*$ POP RangeChk *)
   DispString(u, '-- ', 0);
   WITH traces[u] DO
    minPos:=curPos;
    LOOP
     IF list[curPos].to-list[minPos].from+4 > WindowWidth(u) THEN
       (*
        * Inclusion of an additional item would result in a
        * line longer than what can be printed in this window,
        * thus go back to the next element. End the loop.
        *)
      IF curPos>1 THEN INC(minPos) END;
      EXIT;
     END;
       (*
        * Exit also if minPos reaches to the first element.
        *)
     IF minPos=1 THEN EXIT END;
     DEC(minPos)
    END;
      (*
       * Display the header line.
       *)
    FOR i:=list[minPos].from TO list[curPos].to-1 DO
     DispChar(u,string[i],1)
    END
   END;
   DispHeaderType
  END WindowLines;

 VAR
  info: ItemInfo;

 PROCEDURE GetV(VAR v: Value; base,ofs: LONGINT; ind: IndType);
  (* intermediate variables 'fatherItem' and 'info' MUST be set!! *)
  VAR
   adjust: INTEGER;
  BEGIN
   IF info.size=8 THEN
    GetValue(base+ofs, ind, v.lr)
   ELSE
    GetValue(base+ofs, ind, v.i);
    WITH info DO
     IF size<4 THEN
      adjust:=8*(size-4);
      IF sign THEN v.i:=SHIFT(v.i, adjust)
      ELSE (*$ RangeChk:=FALSE *) v.i:=SHIFT(CAST(LONGCARD, v.i), adjust)
           (*$ POP RangeChk *)
      END
     END
    END
   END;
(*   IF v.i=6 THEN A.BreakPoint(ADR("getv 6")) END;*)
  END GetV;

 VAR
  valLen, valPos: CARDINAL;

 PROCEDURE GetAndDisplay(it: Item; md:VarModes; ofs:LONGINT; ind: IndType);
  (* intermediate variables 'valLen', 'valPos' MUST be set!! *)
  VAR
   v: Value;
  BEGIN
   IF md IN VarModeSet{normVar,farVar,normIniVar,farIniVar} THEN
     GetV(v, fatherItem.dbase, ofs, ind);
   ELSIF md=absVar THEN
     GetValue(ofs,ind,v.i)
   ELSE
     v.i:=0;
   END;
   Tab(u, valPos);
   DispValue(it, v, valLen);
  END GetAndDisplay;

 VAR
  indType: IndType;
  rec:BOOLEAN;
  fatherMode:VarModes;
  lastAdr:LONGINT;
  item, item1: Item;
  info1: ItemInfo;
  i,jj,cnt: CARDINAL;
  j: LONGINT;  (* for Array index *)
  ls: LONGSET; (* for Set *)
  sarr: ARRAY[0..31] OF SHORTINT;
  v: Value;
  isdyn:BOOLEAN;
BEGIN  (* DisplayData *)
  WITH traces[u] DO fatherItem:=list[curPos].item; END;
  IF EmptyItem(fatherItem) THEN
    InitWindowStatus(u, 0, 1); DispString(u,noReferenceFile,0)
  ELSE
     (*
      * First divide the line width into three fields (name,value,type).
      * valLen is the length of one such field and valPos the starting
      * position of the second field.
      *)
    valLen:=WindowWidth(u) DIV 3-1; IF valLen<9 THEN valLen:=9 END;
    valPos:=(WindowWidth(u)-valLen) DIV 2-1;
     (*
      * Get the info of the fatherItem (the one in the header line) and
      * get the first item of this scope into item.
      *)
    GetItemInfo(fatherItem, info); item:=fatherItem; GetSonItem(item,0);
    fatherMode:=info.mode;
(*A.BreakPoint(ADR("in dispda"));*)
    CASE info.form OF  (* father *)
    | Mod,Prc,Record:
      (*
       * If the father is a module, procedure or record then we have to
       * display a list of variable or fields.
       *)
      WindowLines(NumberOfSons(fatherItem));
      (*
       * Go to the element corresponding to the first displayed line
       * in the window.
       *)
      GetBrotherItem(item,topLine);
      (* 1.1.91/bp CASE-Records: neues Feld: ein "" auf Screen! *)
      rec:=info.form=Record;
      lastAdr:=-1;
      FOR i:=1 TO displayLines-headLines DO
        IF ~EmptyItem(item) THEN
        (*
         * Get the item info and display name, value and type of this
         * variable or field.
         *)
          GetItemInfo(item, info);
          DispLn(u);
          IF rec THEN
            IF (info.adr<=lastAdr) THEN
              DispChar(u,'',1);
            ELSE
              DispChar(u,' ',1);
            END;
            lastAdr:=info.adr;
          END;
          DispString(u, info.nameSpelling, 0);
          (*hier!*)
          IF info.ind THEN indType:=aptr ELSE indType:=noptr END;
          GetAndDisplay(item, info.mode, info.adr, indType);
          DispChar(u,' ',1); DispString(u, info.typeSpelling, 0);
          GetBrotherItem(item,1)
        END
      END;
    | BPointer, Pointer:
      WindowLines(1);
      DispLn(u);
      DispString(u,pointsTo,0);
      IF info.form=BPointer THEN indType:=bptr ELSE indType:=aptr END;
      GetItemInfo(item, info); (* BaseTyp *)
      GetAndDisplay(item, fatherMode,0, indType);
      DispChar(u, ' ', 1); DispString(u, info.typeSpelling, 0)
    | Array:
      item1:=fatherItem;
      GetSonItem(item1, 1); GetItemInfo(item1, info1); (* index *)
(*
 * 28.5.89/ms
 *  Hier wurde 'info1.max:=INTEGER(fatherItem.high)' gesetzt. Inzwischen
 *  sind beide LOGINT Felder. Die letzten zwei Parameter von
 *  'InitWindowStatus' sind CARDINAL. Die Rechnerei mit min und max luft
 *  dann schief, wenn der Indexbereich des Feldes 64k erreicht.
 * 3.10.90/bp
 *  info.dyn ist hier nicht mehr gltig, da info=ElementTyp!
 *  Deshalb GetItemInfo(item,info) darunter verlagert.
 * 1.1.91/bp dyn wurde noch einmal abgefragt, deshalb neue var isdyn
 *)
      isdyn:=info.dyn;
      IF isdyn THEN info1.min:=0; info1.max:=fatherItem.ahigh END;
      GetItemInfo(item,info); (* Typ der Elemente *)
      WindowLines(info1.max-info1.min+1);
      i:=headLines+1; j:=info1.min+LONGINT(topLine);
      WHILE (i<=displayLines) & (j<=info1.max) DO
        DispLn(u);
        IF isdyn THEN DispInt(u, j, valLen)
        ELSE v.i:=j; DispValue(item1,v, valLen)
        END;
        GetAndDisplay(item, fatherMode,info.size*(j-info1.min), noptr);
        INC(i); INC(j);
        DispChar(u, ' ', 1); DispString(u, info.typeSpelling,0)
      END
    | Set: (* jr: quick and dirty implementation, no topLine... *)
      (* 23.11.90/bp slow and clean implementation ... *)
      GetV(v, fatherItem.dbase, 0, noptr); ls:=v.s;
      cnt:=0;
      FOR i:=0 TO 31 DO
        IF i IN ls THEN
          sarr[cnt]:=i;
          INC(cnt)
        END
      END;
      WindowLines(cnt); (* +1 fr "}" *)
      DispChar(u, '{', 1);
      i:=headLines+1; jj:=topLine;
      WHILE (i<=displayLines) & (jj<cnt) DO
        DispLn(u);
        v.i:=sarr[jj];
        DispValue(item,v,0);
        INC(i); INC(jj);
      END;
      IF jj=cnt THEN DispChar(u, '}', 1) END;
    ELSE (* CASE *)
      WindowLines(1);
      DispLn(u); DispString(u, 'Value =', 0);
      valPos:=8; GetAndDisplay(fatherItem, fatherMode, 0, noptr)
    END;
  END
END DisplayData;

PROCEDURE SelectData(u: Window; sel: SelectionSet; line, column: CARDINAL);

 PROCEDURE pointer(VAR i: ItemInfo): BOOLEAN;
  BEGIN
   RETURN (i.form=Pointer)
       OR (i.form=BPointer)
       OR (i.form=Opaque)
       OR (((i.form=Undef)OR(i.form=Range)) & (i.size=4)) (* type BPTR or ADDRESS *)
  END pointer;

 VAR
   typString: ARRAY [0..59] OF CHAR;

 PROCEDURE wannaChange(it: Item; i: ItemInfo): BOOLEAN;
  VAR
   modString: ARRAY [0..59] OF CHAR;
   n: INTEGER;
   mItem: Item;
  BEGIN
   IF ~(source IN sel) THEN RETURN FALSE END;
   IF ~pointer(i) THEN Beep; RETURN TRUE END;

   InputString(i.typeSpelling, typString);
   n:=FirstPos(typString,0,'.');
   IF n=last THEN Beep; RETURN TRUE END;
   CopyPart(modString, typString, 0, n);
   CopyPart(typString, typString, n+1, 59);
   GetModuleItem(FindModule(modString), mItem);
   IF EmptyItem(mItem) THEN Beep; RETURN TRUE END;

   FindType(mItem, typString);
   GetItemInfo(mItem, i);
   IF (mItem.str=NIL) OR ~pointer(i) THEN Beep; RETURN TRUE END;
(*-ms
 * WriteString(' found');
 *)
   ChangeType(it, mItem.str);

   RestoreWindow0(u, 0);
   RETURN TRUE
  END wannaChange;

 (* KEIN CopyDyn:=FALSE *)
 PROCEDURE CheckSelection(item: Item; s: ARRAY OF CHAR);
  VAR
   indType: IndType;
   info: ItemInfo;
   f: StrForm;
   ok: BOOLEAN;
  BEGIN
   GetItemInfo(item, info); f:=info.form;
   ok:=FALSE;
(*A.BreakPoint(ADR("anf checksel"));*)

   IF (f=BPointer) OR (f=Pointer) THEN
    IF f=BPointer THEN indType:=bptr; ELSE indType:=aptr; END;
    IF info.mode=absVar THEN
      GetAddress(info.adr,indType,item.dbase); GetSonItem(item,0);
    ELSE
      GetAddress(item.dbase,indType,item.dbase); GetSonItem(item,0);
    END;
    IF ~EmptyItem(item) THEN  (* variable not of type address *)
      Concat(s, '^');
      GetItemInfo(item, info);
      ok:=(item.dbase#nil) & (CAST(LONGSET,TypeOfMem(item.dbase)) <> LONGSET{});
    END
   END;
   IF ok OR (f=Array) OR (f=Record) OR (f=Mod) OR (f=Set) THEN
(*A.BreakPoint(ADR("ins checksel"));*)
    Insert(traces[u],item,s,WindowTopLine(u),FALSE); RestoreWindow0(u,0);
   END;
(*A.BreakPoint(ADR("end checksel"));*)
  END CheckSelection;

 PROCEDURE GetIndex(item:Item; n:LONGINT; VAR s:ARRAY OF CHAR);
  VAR
   info:ItemInfo;
   x:LONGINT;
   err:BOOLEAN;
   tmpS:POINTER TO ARRAY [0..9] OF CHAR;
  BEGIN
   s:='['; GetItemInfo(item,info); x:=info.min;
   GetSonItem(item,0); GetItemInfo(item,info);
   IF info.form=Enum THEN
    (* 1.1.91/bp korrigiert. falls MIN(enum)#0! *)
    GetSonItem(item,0); GetBrotherItem(item,x+n); GetItemInfo(item,info);
    Concat(s,info.nameSpelling)
   ELSE
    tmpS:=ADDRESS(ADR(s)+1);
    ValToStr(x+n,TRUE,tmpS^,10,0,' ',err) (* jr *)
   END;
   Concat(s,']')
  END GetIndex;

 VAR
  fatherItem, item, item1: Item;
  indType: IndType;
  info, info1: ItemInfo;
  specifier: ARRAY [0..127] OF CHAR;
  i: INTEGER;
 BEGIN (* SelectData *)
  IF line-WindowTopLine(u)=0 THEN  (* in trace line *)
   IF ~(data IN sel) THEN RETURN END;
   IF column>=3 THEN DEC(column,3) END; (* 3=Length(' --') *)
   WITH traces[u] DO
    INC(column,list[minPos].from); i:=1;
    WHILE i<=curPos DO
     WITH list[i] DO
      IF (from<=column) & (column<to) THEN
       curPos:=i; RestoreWindow0(u,wTopLine)
      END
     END;
     INC(i)
    END
   END (* WITH *)
  ELSIF line-WindowTopLine(u)>=headLines THEN
   DEC(line, headLines);
   WITH traces[u] DO fatherItem:=list[curPos].item END;
   item:=fatherItem; GetItemInfo(fatherItem, info);
   CASE info.form OF
   | Mod, Prc, Record:
      GetSonItem(item, 0);    (* get first obj of father: VAR or FIELD *)
      GetBrotherItem(item, line);             (* get n-th obj of scope *)
      GetItemInfo(item, info);
      (* 3.10.90/bp *)
      IF info.mode IN VarModeSet{normVar,absVar,farVar,normIniVar,farIniVar} THEN
      (* reg und ext nicht mglich! *)
        IF info.ind THEN indType:=aptr ELSE indType:=noptr END;
  (*hierauch!*)
        IF info.mode=absVar THEN
	  GetAddress(info.adr,indType,item.dbase);
	ELSE
	  GetAddress(fatherItem.dbase+info.adr,indType,item.dbase);
	END;
        IF (info.form=Array) & info.dyn THEN
          (* immer lokal, also dbase! *)
          GetHIGH(fatherItem.dbase+info.adr,item.ahigh)
        END;
        specifier:='.'; Concat(specifier, info.nameSpelling);
        IF ~wannaChange(item, info) THEN CheckSelection(item, specifier) END
      END; (* sonst nix! *)
   | BPointer, Pointer:
(* 4.3.89/ms
 *	Hier habe ich den BPointer auch zugefgt.
 *)
      IF line=0 THEN
       IF ~wannaChange(item, info) THEN CheckSelection(item, '') END
      END
   | Array:
      item1:=fatherItem;
      GetSonItem(item, 0);  GetItemInfo(item, info);   (* element *)
      GetSonItem(item1, 1); GetItemInfo(item1, info1); (* index *)
      IF info1.min+LONGINT(line)<=info1.max THEN
	item.dbase:=fatherItem.dbase+LONGINT(line)*info.size;
        GetIndex(item1, line, specifier);
        IF ~wannaChange(fatherItem, info) THEN
          CheckSelection(item, specifier)
        END
      END;
   | Set:
      GetSonItem(item, 0);
      specifier:='.'; Concat(specifier, info.nameSpelling);
      CheckSelection(item, specifier)
   ELSE (* ignore selection *)
   END
  END
 END SelectData;

(*---------------------------------------------------------------------------*)

PROCEDURE DisplayData1(topLine, displayLines: CARDINAL);
 BEGIN
  DisplayData(dt1Wdw, topLine, displayLines)
 END DisplayData1;

PROCEDURE SelectData1(sel: SelectionSet; line, column: CARDINAL);
 BEGIN
  SelectData(dt1Wdw, sel, line, column)
 END SelectData1;

PROCEDURE DisplayData2(topLine, displayLines: CARDINAL);
 BEGIN
  DisplayData(dt2Wdw, topLine, displayLines)
 END DisplayData2;

PROCEDURE SelectData2(sel: SelectionSet; line, column: CARDINAL);
 BEGIN
  SelectData(dt2Wdw, sel, line, column)
 END SelectData2;

(*---------------------------------------------------------------------------*)

PROCEDURE DisplayModule(topLine, displayLines: CARDINAL);
 VAR basePos, i: CARDINAL;
 BEGIN
  basePos:=WindowWidth(modWdw)-11;
  WITH modInfoList DO
   InitWindowStatus(modWdw, topLine, length);
   FOR i:=topLine TO topLine+displayLines-1 DO
    IF i<length THEN
     DispCard(modWdw, i, 2); DispChar(modWdw, ' ', 1);
     DispString(modWdw, contents[i].l^.modname, 0); Tab(modWdw, basePos);
(*   FormatNr('m2d:dataBase =%08lx\n',contents[i].dataBase);*)
     DispHex(modWdw, contents[i].bssBase, 9); DispLn(modWdw)
    END
   END (* FOR *)
  END
 END DisplayModule;

PROCEDURE SelectModule(sel: SelectionSet; line, column: CARDINAL);
 VAR
  item: Item;
  info: ItemInfo;
 BEGIN
  IF line<modInfoList.length THEN
   IF data IN sel THEN
    GetModuleItem(line, item);
    WITH modInfoList.contents[line] DO
      item.dbase:=bssBase;
      item.ibase:=iniBase;
    END;
    GetItemInfo(item, info);
    Insert(traces[modDataWdw], item, info.nameSpelling, 0, TRUE);
    RestoreWindow0(modDataWdw,0)
   END;
   IF source IN sel THEN
    OpenSource(line,srcIsMod);
    errorStart:=0; RestoreWindow0(srcWdw,0)
   END
  END
 END SelectModule;

(*---------------------------------------------------------------------------*)

PROCEDURE DisplayProcedure(topLine, displayLines: CARDINAL);
 VAR
  modPos:INTEGER;
  i: CARDINAL;
  modNo: INTEGER;
  pc: LONGINT;
  mod, proc: Item;
  info: ItemInfo;
 BEGIN
  modPos:=WindowWidth(prdWdw) DIV 2;
  WITH procInfoList DO
   InitWindowStatus(prdWdw, topLine, length+1);
   DispString(prdWdw, '-- ', 0); DispString(prdWdw, processStatus, 0);
   DispLn(prdWdw); i:=topLine;
   WHILE i+2 <= topLine+displayLines DO
    IF i<length THEN
      modNo:=contents[i].modNo; pc:=contents[i].pc;
      GetModuleItem(modNo, mod);
      IF (0<=pc) & (pc<=32767) THEN
       GetProcedureItem(mod, pc, proc);
       IF EmptyItem(proc) THEN
        DispString(prdWdw, address, 0); DispHex(prdWdw, pc, 1)
       ELSE
        GetItemInfo(proc, info); DispString(prdWdw, info.nameSpelling, 0)
       END;
      ELSE
       DispString(prdWdw, address, 0); DispHex(prdWdw, pc, 1)
      END;
      Tab(prdWdw, modPos); DispString(prdWdw, ' in ', 0);
      IF (modNo<0) OR (modNo>=INTEGER(modInfoList.length)) THEN modNo:=0; END;
      DispString(prdWdw, modInfoList.contents[modNo].l^.modname, 0);
      DispLn(prdWdw)
    END;
    INC(i)
   END
  END
 END DisplayProcedure;

PROCEDURE SelectProcedure(sel: SelectionSet; line, column: CARDINAL);
 VAR
  top: INTEGER;
  item: Item;
  info: ItemInfo;
 BEGIN
  (*
   * 29.3.89/ms In der ersten Zeile ist eine Auswahl ungltig
   *)
  IF (column#0) & (line-WindowTopLine(prdWdw)=0) THEN RETURN END;
  IF line>0 THEN DEC(line) END;
  IF line<procInfoList.length THEN
   WITH procInfoList.contents[line] DO
    IF data IN sel THEN
     GetModuleItem(modNo, item); GetProcedureItem(item, pc, item);
     GetItemInfo(item, info);
     IF info.form=Mod THEN
       WITH modInfoList.contents[modNo] DO
         item.dbase:=bssBase;
         item.ibase:=iniBase;
       END;
     ELSE
       item.dbase:=dataBase
     END;
     Insert(traces[prcDataWdw],item,info.nameSpelling,0,TRUE);
     RestoreWindow0(prcDataWdw,0)
    END;
    IF source IN sel THEN
     IF (modNo<0) OR (modNo>=INTEGER(modInfoList.length)) THEN modNo:=0; END;
     OpenSource(modNo,TRUE);
     errorStart:=errStart; errorStop:=errStop;
     IF srcPos#illSourcePos THEN
      top:=FindLine(errStart)-INTEGER(WindowHeight(srcWdw) DIV 2);
(*
 * 27.12.88/ms Es darf keine negative Zahl als 'top' verwendet werden!
 *)
      IF top<0 THEN top:=0 END;
      GotoLine(top);
      InitWindowStatus(srcWdw,top,SourceLength());
     END;
     RestoreWindow(srcWdw)
    END
   END (* WITH *)
  END
 END SelectProcedure;

(*---------------------------------------------------------------------------*)

PROCEDURE DebugProcess;
VAR
  i: CARDINAL;
  sel:SelectionSet;
  item: Item;
BEGIN
  GetProcessStatus; GetProcedureChain(); RestoreWindow0(prdWdw,0);
  FOR i:=1 TO procInfoList.length DO
   WITH procInfoList.contents[i-1] DO
    GetModuleItem(modNo, item);
    IF (0<=pc) & (pc<=32767) THEN GetErrPosition(modNo,pc,errStart,errStop);
    ELSE errStart:=0; errStop:=0;
    END;
   END
  END;

  sel:=SelectionSet{data};
  IF srcImm THEN INCL(sel,source) END;
  SelectProcedure(sel, 0, 0);

  i:=procInfoList.contents[0].modNo;
  IF i>=modInfoList.length THEN i:=0 END;
  SelectModule(SelectionSet{data}, i, 0)
END DebugProcess;

PROCEDURE Menu(nr: INTEGER);
(* Menu Struktur:
 * 0: .mod
 * 1: .def
 * 2: modData  a) 1 (Nr 8)      b) 2 (Nr 9)
 * 3: prcData  a) 1 (Nr 10)     b) 2 (Nr 11)
 * 4: Layout   a) save (Nr 12)  b) read (Nr 13)
 * 5: Interlace obsolet
 * 6: ImmSrc   a) Sofort (Nr 16)  b) Nur auf Taste (Nr 17)
 * 7: Quit
*)
 BEGIN
  CASE nr OF
  | 0: srcIsMod:=FALSE
  | 1: srcIsMod:=TRUE
  (*| 5: RestoreLayout*)
  | 7: exitDebugger:=TRUE
  | 8: modDataWdw:=dt1Wdw
  | 9: modDataWdw:=dt2Wdw
  |10: prcDataWdw:=dt1Wdw
  |11: prcDataWdw:=dt2Wdw
  |12: SaveLayout
  |13: ReadLayout;RestoreLayout
  |16,17: srcImm:=nr=16;
  ELSE
  END
 END Menu;

(*---------------------------------------------------------------------------*)

PROCEDURE Debug;
VAR
 i: INTEGER;
 command: Command;
BEGIN
(*-jr
 WriteString('<m2d');
*)
 InitM2MD; InitM2CD; InitM2UD;
 modDataWdw:=dt2Wdw; prcDataWdw:=dt1Wdw;

 InitActions(dt1Wdw, DisplayData1, SelectData1);
 InitActions(dt2Wdw, DisplayData2, SelectData2);
 InitActions(srcWdw, DisplaySource, SelectSource);
 InitActions(modWdw, DisplayModule, SelectModule);
 InitActions(prdWdw, DisplayProcedure, SelectProcedure);

 RestoreWindow0(modWdw,0);
 DebugProcess; exitDebugger:=FALSE;

 REPEAT
  GetCommand(command);
  WITH command DO
   CASE type OF
   | scroll: Display(newTopLine, displayLines);
   | select: Select(sel, line, column);
   | menu: Menu(itemNr);
   END
  END
 UNTIL exitDebugger;
 ExitM2UD;
 ExitM2CD;
 ExitM2MD;
END Debug;

(* pro Programm einmal *)
PROCEDURE ForgetDebug;
BEGIN
  ExitM2UD;
  ExitM2CD; (* tut gar nix *)
  ExitM2MD;
  ForgetM2CD;
END ForgetDebug;

BEGIN
  srcIsMod:=TRUE; (* nur hier wegen des Hakens! *)
END m2d.mod
