MODULE m2cache;


(*$ DEFINE StackTest:=FALSE *)

FROM SYSTEM	IMPORT	ADR,ADDRESS,CAST,ASSEMBLE,SETREG,LONGSET;

IMPORT	M: M2Amiga,
	A: Arts,
	Break,
	ExecD,
	ExecL;

FROM ArgHandler	IMPORT	interActive, verbose, InitHandler, FetchName,
			fName,fNameLen,SetReply;
FROM ReplyVals	IMPORT	rcIllOpt,rcWarn,rcActionErr,rcMainNotFound;
FROM String	IMPORT	Length, Compare, Copy, CopyPos, Concat, ComparePart;
FROM Terminal	IMPORT	WriteString, WriteLn, FormatS, FormatNr, Write, Read,
			waitCloseGadget,Format,WriteHex,WriteInt,Flush;

CONST
  in="in> ";
  title1="m2cache";
  title2="M2Amiga Cache Verwaltung";
  ver="4.4";
  date=COMPILEDATE;
  version=", "+ver+"d, "+date+"\n";
  verDollar="$VER: m2set "+ver+" "+date;
  usage="Aufruf:  %s {+- q l f dmros nCachegre ? * ModulName}\n\n";
  noSuchFile=": nicht gefunden\n";
  exit=" --- ende\n";


TYPE
  Welche = (hDef, hMod, hRef, hObj, hSym);
  WSet = SET OF Welche;
  WArr = ARRAY Welche OF BOOLEAN;
  FArr = ARRAY Welche OF M.FileType;
  NArr = ARRAY Welche OF ARRAY[0..3] OF CHAR;

CONST
  fArr = FArr{M.defFile,M.modFile,M.refFile,M.objFile,M.symFile};
  nArr = NArr{"def", "mod", "ref", "obx", "sym"};

VAR
  b:M.M2AmigaBasePtr;
  sem:ExecD.SignalSemaphorePtr;
  arr:= WArr{FALSE,FALSE,FALSE,TRUE,TRUE};
  dejaVue,
  delAll,
  done: BOOLEAN;
  fullName:ARRAY [0..127] OF CHAR;


PROCEDURE FindObj(t:M.FileType):BOOLEAN;
VAR o:M.ObjFilePtr;
BEGIN
  ExecL.ObtainSemaphore(sem);
  o:=b^.globs^.objList.head;
  WHILE (o^.succ#NIL) & NOT( (o^.type=t) & (ComparePart(fName,0,128,o^.name,FALSE)=0) ) DO
    o:=o^.succ;
  END;
  IF o^.succ#NIL THEN
    Copy(fullName,o^.pathName);
    ExecL.ReleaseSemaphore(sem);
    RETURN TRUE;
  END;
  ExecL.ReleaseSemaphore(sem);
  RETURN FALSE;
END FindObj;

PROCEDURE DoIt;
VAR
  typ:Welche;
BEGIN
  delAll:= ((fNameLen=1) & (fName[0]="*"));
  FOR typ:=MIN(Welche) TO MAX(Welche) DO
    IF arr[typ] THEN
      IF delAll THEN
        M.FlushType(fArr[typ]);
        IF verbose THEN
          WriteString("Alle ");
          WriteString(nArr[typ]);
          WriteString(" aus dem Cache gelscht.\n");
        END;
      ELSE
        IF verbose THEN
          WriteString(nArr[typ]); WriteString(": ");
        END;
        IF FindObj(fArr[typ]) THEN
          M.GeneratingNew(fName,fArr[typ]);
          IF verbose THEN
            WriteString(fullName); WriteString(" aus dem Cache gelscht.\n")
          END;
        ELSE
          IF verbose THEN
            WriteString(fName); WriteString(" ist nicht im Cache.\n")
          END;
        END;
      END;
    END;
  END;
END DoIt;

PROCEDURE ShowCacheSize(nr:LONGINT);
BEGIN
  IF nr<0 THEN
    FormatNr("\nDer Cache hlt ca. %ld Bytes Speicher frei.\n\n",-nr);
  ELSE
    FormatNr("\nDer Cache benutzt maximal ca. %ld Bytes Speicher.\n\n",nr);
  END;
END ShowCacheSize;


PROCEDURE ShowList();
VAR
  o:M.ObjFilePtr;
  t:M.FileType;
  s:M.ObTypeSet;
BEGIN
  ExecL.ObtainSemaphore(sem);
  WriteString("\nStatus:\n\n");
  Format("Library: %s\n",ADR(b^.lib.idString));
  WITH b^.globs^ DO
    IF errBuffer#NIL THEN
      FormatNr("Fehlerliste geladen, %ld mal in Benutzung.\n\n",errOpenCnt);
    ELSE
      WriteString("Fehlerliste nicht geladen.\n\n");
    END;
    ShowCacheSize(objMaxMem);
    FormatNr("Der Cache belegt zur Zeit %ld Bytes ",objUsedMem);
    FormatNr("in %ld Objekten\n\n",objUseCnt);
    o:=objList.head;
    WHILE o^.succ#NIL DO
      IF Break.GetBreak()#LONGSET{} THEN
        ExecL.ReleaseSemaphore(sem);
        Break.ExitBreak;
      END;
      FormatNr("used:%2ld, ",o^.useCount);
      FormatNr("size:%6ld, ",o^.buffLen);
      IF o^.valid THEN
        WriteString("ok,  ");
      ELSE
        WriteString("bad, ");
      END;
      IF o^.type = M.objFile THEN
        s:=o^.cpuDoesntExist;
        FOR t:=M.ob1File TO M.ob8File DO
          IF t IN s THEN
            Write("1")
          ELSE
            Write("0")
          END;
        END;
        WriteString(", ");
      ELSE
        WriteString("       ");
      END;
      WriteString(o^.pathName);
      WriteLn;
      o:=o^.succ;
    END;
  END;
  ExecL.ReleaseSemaphore(sem);
  WriteLn;
END ShowList;



(*$ CopyDyn:=FALSE *)
PROCEDURE Options(s:ARRAY OF CHAR; len:INTEGER):BOOLEAN;
VAR
  set,ok:BOOLEAN;
  cap:CHAR;
  i:INTEGER;
  number,memSize:LONGINT;
  (*
   * -f lscht lokale +f lscht alles
   * +-n setzt Cache-Gre. <0 bedeutet mind. freihalten
   * +-l gibt Liste aus
   * +-orsmd legt fest, welche module gelscht werden (Name erforderlich)
   *)
BEGIN
  IF s[0]='?' THEN
    ok:=FALSE;
  ELSE
    ok:=TRUE;
    i:=0;
    LOOP
      cap:=CAP(s[i]);
      CASE cap OF (* zunchst kommt ja sicher '+' oder '-'! *)
      | '+':	set:=TRUE;
      | '-':	set:=FALSE;
      | 'F':    IF set THEN
		  M.FlushAll;
		  IF verbose THEN
		    WriteString("\nAlle Objekte gelscht.\n");
		  END;
		ELSE
		  M.FlushLocals;
		  IF verbose THEN
		    WriteString("\nLokale Objekte gelscht.\n");
		  END;
		END;
		done:=TRUE;
      | 'O':	arr[hObj]:=set;
      | 'R':	arr[hRef]:=set;
      | 'S':	arr[hSym]:=set;
      | 'M':	arr[hMod]:=set;
      | 'D':	arr[hDef]:=set;
      | 'N':	number:=0; INC(i);
		WHILE i<len DO
		  IF (s[i]>='0')&(s[i]<='9') THEN
		    number:=number*10+ORD(s[i])-30H;
		  ELSE
		    ok:=FALSE;
		    EXIT
		  END;
		  INC(i);
		END;
		IF set THEN
		  memSize:=number;
		ELSE
		  memSize:=-number;
		END;
		b^.globs^.objMaxMem:=memSize;
		IF verbose THEN ShowCacheSize(memSize) END;
		done:=TRUE;
      | 'L':	ShowList; done:=TRUE;
      | 'Q':	verbose:=set;
      | ELSE
	  ok:=FALSE;
	  EXIT
      END; (* case *)
      INC(i);
      IF i>=len THEN EXIT END;
    END; (* loop *)
    IF interActive THEN verbose:=TRUE END;
  END;
  IF ~ok THEN
    WriteString(title1); WriteString(version);
    Format(usage,ADR(A.programName));
    SetReply(rcIllOpt);
  END;
  RETURN ok;
END Options;




BEGIN
  b:=ADR(M);
  SETREG(11,ADR(verDollar));
  sem:=ExecL.FindSemaphore(ADR("M2AmigaLibSem"));
  A.Assert(sem#NIL,ADR("Semaphor der Library nicht da!"));
  (* quiet:=FALSE; interActive:=FALSE *)
  InitHandler(Options,ADR(in),ADR('ENV:m2cache'),ADR("m2cache.opt"));
  WriteString(title2); WriteString(version);

  IF ~FetchName() THEN RETURN END; (* bei Aufruffehler gleich raus *)
  IF (fNameLen=0) & ~done THEN interActive:=TRUE END;
  (* Nun erstes Arg holen! *)
  LOOP
    IF dejaVue OR (fNameLen=0) THEN
      REPEAT
      UNTIL FetchName(); (* bis Leerstring oder guter *)
    END;
    dejaVue:=TRUE;
    IF fNameLen=0 THEN EXIT END;
    IF interActive THEN verbose:=TRUE END;

    DoIt;

  END; (* loop *)
  IF interActive&verbose THEN
    WriteString(exit);
  END;
  waitCloseGadget:=verbose & ~interActive;
END m2cache.
