IMPLEMENTATION MODULE Windows;
(*
 * 29.12.90/bp
 *	Das Scroll-Gadget an die Tiltle-Hhe angepat
 *	Lschen bis Zeilenende lschte zuviel!
 *	Window enthlt doch die Felder borderLeft, ...
 *	Damit ist titleBar obsolet!
 *	Allocate durch ALLOCATE erweitert. Es war nie eine Abfrage da..!
 * 15.4.89/ms
 *	Neu gibt es das Feld titleBar in der Info Struktur. Dieses Feld
 *	enthlt die Hhe des Titelbalkens abhngig von der Fonthhe beim
 *	Erffnen des Fensters. GetPos, SetPos, XYtoPos und GetSize sind
 *	angepasst worden. GetSize gibt nun korrekterweise die Anzahl Linien
 *	bzw. Zeilen zurck. Zuvor wurde eine zu kleine Zahl angegeben.
 *
 * jr/1jan88
 *)
(*$
   StackChk:=FALSE
   RangeChk:=FALSE
   OverflowChk:=FALSE
   ReturnChk:=FALSE
   LongAlign:=TRUE
   LargeVars:=FALSE
   NilChk:=FALSE
   Volatile:=FALSE
   StackParms:=FALSE
*)
FROM SYSTEM	IMPORT	BYTE, CAST, ADDRESS, ADR;
FROM Arts	IMPORT	Assert;
FROM Heap	IMPORT	Allocate,Deallocate;
IMPORT IntuitionL;
FROM IntuitionD	IMPORT	customScreen, propGadget, ScreenPtr, ScreenFlags,
			ScreenFlagSet, NewWindow, WindowFlags, WindowFlagSet,
			IDCMPFlagSet, GadgetPtr, GadgetFlags, GadgetFlagSet,
			ActivationFlags, ActivationFlagSet, ImagePtr,
			PropInfoPtr, PropInfoFlags, PropInfoFlagSet;
FROM IntuitionL	IMPORT	GetScreenData, SizeWindow, MoveWindow;
FROM GraphicsD	IMPORT	DrawModeSet;
FROM GraphicsL	IMPORT	SetAPen,SetBPen,SetDrMd,RectFill,ScrollRaster,Move,
			Text;
FROM String	IMPORT	Length,Copy;

TYPE
 WinInfoPtr = POINTER TO WinInfo;
 WinInfo = RECORD
  next: WinInfoPtr;
  w: Window;
  title,
  knob,
  prop,
  gadg:ADDRESS;
  clip, scroll: BOOLEAN;
 END;


VAR
 defScr: ScreenPtr;
 info: WinInfoPtr;


PROCEDURE ALLOCATE(VAR adr{10}:ADDRESS; size{2}:LONGINT);
BEGIN
  Allocate(adr,size);
  Assert(adr#NIL,ADR("Window: no memory"));
END ALLOCATE;

(* ------------ window info handling ----------------- *)
PROCEDURE exists(u{10}: Window; VAR i{11}: WinInfoPtr): BOOLEAN;
BEGIN
  i:=info;
  LOOP
    IF i=NIL THEN RETURN FALSE END;
    IF i^.w=u THEN RETURN TRUE END;
    i:=i^.next
  END;
END exists;


PROCEDURE new(VAR i: WinInfoPtr);
BEGIN
  ALLOCATE(i, SIZE(i^));
  i^.next:=info; info:=i;
END new;

PROCEDURE del(i: WinInfoPtr);
VAR p: WinInfoPtr;
BEGIN
  IF i=info THEN info:=i^.next
  ELSE
    p:=info; WHILE p^.next#i DO p:=p^.next END; p^.next:=i^.next;
  END;
  WITH i^ DO
    IF title#NIL THEN Deallocate(title) END;
    IF knob#NIL THEN Deallocate(knob) END;
    IF prop#NIL THEN Deallocate(prop) END;
    IF gadg#NIL THEN Deallocate(gadg) END;
  END;
  Deallocate(i)
END del;

(* --------------- main procedures ------------------- *)

PROCEDURE SetPos(VAR u: Window; l, c: INTEGER);
BEGIN
(*
 * 15.4.89/ms
 *	Korrektur der Position. Abhngig von der gewhlten Schriftart.
 * 29.12.90/bp
 *	dito
 *)
  IF u#NIL THEN
    WITH u^ DO
      WITH rPort^ DO
	Move(
	  rPort,
	  c*INTEGER(txWidth)+borderLeft,
	  l*INTEGER(txHeight)+INTEGER(txBaseline)+(borderTop)+2
	)
      END;
    END;
  END;
END SetPos;

PROCEDURE XYtoPos(VAR u: Window; xx, yy: INTEGER; VAR l, c: INTEGER);
BEGIN
(*
 * 15.4.89/ms
 *	Korrektur der Position. Abhngig von der gewhlten Schriftart.
 * 29.12.90/bp
 *	dito
 *)
  IF u#NIL THEN
    WITH u^ DO
      DEC(yy,(borderTop+2));
      DEC(xx,borderLeft);
    END;
    WITH u^.rPort^ DO
      l:=yy DIV INTEGER(txHeight);
      c:=xx DIV INTEGER(txWidth)
    END;
    IF l<0 THEN l:=0; END;
    IF c<0 THEN c:=0; END;
  END;
END XYtoPos;

PROCEDURE GetPos(VAR u: Window; VAR l, c: INTEGER);
BEGIN
(*
 * 15.4.89/ms
 *	Aufruf an XYtoPos anstelle einer Kopie dieser Prozedur.
 * 29.12.90/bp
 *	Korrektur
 *)
  IF u#NIL THEN
    WITH u^.rPort^ DO
      XYtoPos(u,x,y-CAST(INTEGER,txBaseline),l,c)
    END
  END
END GetPos;

PROCEDURE SetColor(VAR u: Window; fg, bg: INTEGER);
VAR wI: WinInfoPtr;
BEGIN
  IF exists(u, wI) THEN
    IF fg#-1 THEN SetAPen(u^.rPort, fg) END;
    IF bg#-1 THEN SetBPen(u^.rPort, bg) END
  END
END SetColor;

PROCEDURE SetMode(VAR u: Window; m: ModeSet);
VAR wI: WinInfoPtr;
BEGIN
  IF exists(u, wI) THEN SetDrMd(u^.rPort, CAST(DrawModeSet,m)) END
END SetMode;

PROCEDURE GetSize(VAR u: Window; VAR l, c: INTEGER);
VAR wI: WinInfoPtr;
BEGIN
(*
 * 15.4.89/ms
 *	Korrektur der Resultate. Jetzt wird die genaue Anzahl Zeile und
 *	Spalten angegeben.
 * 29.12.90/bp
 *	Jetzt aber wirklich!
 *)
  IF exists(u, wI) THEN
    WITH u^ DO
      l:=(height-borderTop-2-borderBottom) DIV INTEGER(rPort^.txHeight);
      c:=(width-borderRight-borderLeft) DIV INTEGER(rPort^.txWidth)
    END
  END
END GetSize;

PROCEDURE Scroll(VAR u: Window; nr: INTEGER);
(*
 * 29.12.90/bp
 * Anpassung an Fonts
 *)
VAR
  wI: WinInfoPtr;
BEGIN
  IF exists(u, wI) THEN
    WITH u^ DO
      ScrollRaster(rPort,0,INTEGER(rPort^.txHeight)*nr,
                 borderLeft,borderTop+2,
                 width-borderRight-1,height-borderBottom-1)
    END
  END
END Scroll;

PROCEDURE Clear(VAR u: Window);
(*
 * 29.12.90/bp
 * Angepat an border..
 *)
VAR
  fGround: INTEGER;
  wI: WinInfoPtr;
BEGIN
  IF exists(u, wI) THEN
    WITH u^ DO
      WITH rPort^ DO
        fGround:=fgPen; SetAPen(rPort, bgPen);
        RectFill(
          rPort, borderLeft, borderTop+2,
          width-borderRight-1, height-borderBottom-1);
        SetAPen(rPort, fGround)
      END;
    END
  END
END Clear;

PROCEDURE ClearEOL(VAR u: Window);
(*
 * 29.12.90/bp
 * Warum nutzen wir nicht GraphicsL.ClearEOL ????
 * Weil es das Scroll-Gadget lscht!
 *)
VAR
  wI: WinInfoPtr;
  fGround: INTEGER;
BEGIN
  IF exists(u, wI) THEN
    WITH u^ DO
      WITH rPort^ DO
        IF x<width-borderRight-1 THEN (* sonst crash! *)
          fGround:=fgPen; SetAPen(rPort, bgPen);
          RectFill(rPort,
              x, y-INTEGER(txBaseline),
              width-borderRight-1, y-1+INTEGER(txHeight-txBaseline));
          SetAPen(rPort, fGround)
        END;
      END;
    END;
  END;
END ClearEOL;

(*$ CopyDyn:=FALSE *)
PROCEDURE WriteS(VAR u: Window; s: ARRAY OF CHAR);
VAR
  written, done: BOOLEAN;
  a: ADDRESS;
  i, c, l, len, maxC, maxL, maxLen: INTEGER;
  wI: WinInfoPtr;
BEGIN
  IF exists(u, wI) THEN
    GetSize(u, maxL, maxC);
    i:=0;
    written:=FALSE; (* bichen kompliziert, gell? *)
    REPEAT
      GetPos(u, l, c);
      IF c>=maxC THEN
        IF wI^.clip THEN RETURN END;
        WriteL(u); maxLen:=maxC
      ELSE
        maxLen:=maxC-c
      END;
      a:=ADR(s[i]); len:=0; done:=FALSE;
      LOOP
        IF (i>HIGH(s)) OR (s[i]=0C) THEN written:=TRUE; EXIT END;
        IF done THEN EXIT END;
        INC(len); INC(i);
        IF len=maxLen THEN done:=TRUE END
      END;
      Text(u^.rPort, a, len)
    UNTIL written
  END
END WriteS;

PROCEDURE WriteC(VAR u: Window; c: CHAR);
VAR s: POINTER TO ARRAY [0..0] OF CHAR;
BEGIN
  s:=ADR(c); WriteS(u, s^)
END WriteC;

PROCEDURE WriteL(VAR u: Window);
VAR
  wI: WinInfoPtr;
  maxL, l, dummy: INTEGER;
BEGIN
  IF exists(u, wI) THEN
    ClearEOL(u); GetPos(u, l, dummy); GetSize(u, maxL, dummy);
    IF l<maxL THEN
      INC(l)
    ELSE
      IF ~wI^.clip THEN Scroll(u, 1) END; l:=maxL
    END;
    SetPos(u, l, 0)
  END
END WriteL;

(*$ CopyDyn:=FALSE *)
PROCEDURE OpenWindow(VAR u: Window; x, y, w, h: INTEGER;
                     title: ARRAY OF CHAR; gad: WinGadSet);
(*
 * 29.12.90/bp
 * Wir erstellen das ScrollGadget nun NACH dem ffnen, damit haben wir eine
 * optimale Anpassung an die System-Gadgets und Fomts!
 *)
VAR
  nw: NewWindow;
  t: POINTER TO ARRAY [0..99] OF CHAR;
  i: INTEGER;
  knob: ImagePtr;
  gadg: GadgetPtr;
  prop: PropInfoPtr;
  sc: BOOLEAN;
  wI: WinInfoPtr;
BEGIN
  CloseWindow(u);
  sc:=scrolling IN gad; EXCL(gad, scrolling);
  IF title[0]=0C THEN
    t:=NIL
  ELSE
    ALLOCATE(t,Length(title)+1);
    Copy(t^,title); (* seit M2Amiga 4.0 geht dies ohne Crash! *)
  END;
  WITH nw DO
    leftEdge:=x; topEdge:=y; width:=w; height:=h;
    detailPen:=0; blockPen:=1;
    idcmpFlags:=IDCMPFlagSet{};
    flags:=WindowFlagSet{noCareRefresh} +
           CAST(WindowFlagSet,LONGINT(CAST(SHORTCARD,gad)));
    IF sc THEN INCL(flags,sizeBRight) END; (* size gadget uses right border *)
    checkMark:=NIL; bitMap:=NIL; title:=t;
    IF defScr=NIL THEN
      screen:=NIL; type:=ScreenFlagSet{wbenchScreen}
    ELSE
      screen:=defScr; type:=customScreen
    END;
    minWidth:=144; minHeight:=40; maxWidth:=1024; maxHeight:=1024;
    firstGadget:=NIL;
  END;
  u:=IntuitionL.OpenWindow(nw);
  IF u#NIL THEN
    new(wI); (* setzt alles auf NIL! *)
    WITH wI^ DO
      w:=u; scroll:=sc; title:=t;
    END;
    IF sc THEN
      ALLOCATE(prop, SIZE(prop^));
      wI^.prop:=prop;
      WITH prop^ DO
        flags:=PropInfoFlagSet{freeVert};
        vertPot:=8000H; vertBody:=1000H; vPotRes:=1000H;
      END;

      ALLOCATE(knob, SIZE(knob^));
      wI^.knob:=knob;
      WITH knob^ DO
        depth:=1; planeOnOff:=255;
      END;

      ALLOCATE(gadg, SIZE(gadg^));
      wI^.gadg:=gadg;
      WITH gadg^ DO
        leftEdge:=-u^.borderRight+2;
        width:=u^.borderRight-2;
        (* topEdge:=10??; Hier ist das Problem!! *)
        topEdge:=u^.borderTop;
        IF sizing IN gad THEN
          height:=-topEdge-9; (* ??sizing gad immer 10! *)
        ELSE
          height:=-topEdge-u^.borderBottom;
        END; (* scheint ok! *)
        flags:=GadgetFlagSet{gadgHBox, gadgHImage, gRelRight, gRelHeight};
        activation:=ActivationFlagSet{relVerify, gadgImmediate, rightBorder};
        gadgetType:=propGadget;
        gadgetRender:=knob; specialInfo:=prop;
      END;

      IF IntuitionL.AddGadget(u,gadg,-1)=0 THEN END;
      (*IntuitionL.RefreshWindowFrame(u);*)
    END; (* scrollGad *)
    SetPos(u, 0, 0); SetMode(u, ModeSet{replMd});
    SetColor(u, 1, -1)
  END; (* u#NIL *)
END OpenWindow;

PROCEDURE ModifyWindow(VAR u: Window; newX, newY, newW, newH: INTEGER);
VAR
  dx, dy, dw, dh: INTEGER;
  wI: WinInfoPtr;
BEGIN
  IF exists(u, wI) THEN
    WITH u^ DO
      IF newX=-1 THEN dx:=0 ELSE dx:=newX-leftEdge END;
      IF newY=-1 THEN dy:=0 ELSE dy:=newY-topEdge END;
      IF newW=-1 THEN dw:=0 ELSE dw:=newW-width END;
      IF newH=-1 THEN dh:=0 ELSE dh:=newH-height END;
      IF dw<0 THEN SizeWindow(u, dw, 0) END;
      IF dh<0 THEN SizeWindow(u, 0, dh) END;
      IF (dx#0) OR (dy#0) THEN MoveWindow(u, dx, dy) END;
      IF dw>0 THEN SizeWindow(u, dw, 0) END;
      IF dh>0 THEN SizeWindow(u, 0, dh) END
    END
  END
END ModifyWindow;

PROCEDURE CloseWindow(VAR u: Window);
VAR
  wI: WinInfoPtr;
BEGIN
  IF exists(u, wI) THEN
    (* Hier kommt groe Verantwortung auf den Benutzer zu!!!
     * er mu Menu lschen, IDCMPs lschen, Messages fr DIES
     * Window beantworten, etc.!
     *)
    u^.userPort:=NIL;
    (* deallocate prop, knob, gadg, title ... *)
    IntuitionL.CloseWindow(u);
    u:=NIL; del(wI)
  END;
END CloseWindow;

(* --------------- advanced use ------------------ *)

PROCEDURE SetScreen(scr: ScreenPtr);
BEGIN
  defScr:=scr
END SetScreen;

PROCEDURE SetClip(VAR u: Window; on: BOOLEAN);
VAR wI: WinInfoPtr;
BEGIN
  IF exists(u, wI) THEN wI^.clip:=on END
END SetClip;

BEGIN
 (* defScr:=NIL; info:=NIL; *)
CLOSE
  WHILE info#NIL DO CloseWindow(info^.w) END
END Windows.
