(*$ LargeVars:=FALSE LongAlign:=FALSE RangeChk:=FALSE OverflowChk:=FALSE
    StackChk:=FALSE StackParms:=FALSE Volatile:=FALSE
*)
(*$ DEFINE English:=FALSE *)

IMPLEMENTATION MODULE Terminal2;

IMPORT	ASCII,Dos,Exec,Arts;
FROM SYSTEM	IMPORT	ADDRESS,ADR,CAST,ASSEMBLE;
FROM Exec	IMPORT	FindTask, RawDoFmt, OpenLibrary, CloseLibrary;
FROM Arts	IMPORT	startupMsg,wbStarted,Error,programName,thisTask;
FROM Workbench	IMPORT	WBStartup, WBArg, WBStartupPtr,DiskObjectPtr;

CONST
 iconName='icon.library';
 defaultSpecs="CON:000/050/640/150/";
 toolTypeEntry="WINDOW";
(*$ IF English *)
 errStr= "Terminal: Open() -Error";
(*$ ELSE *)
 errStr= "Terminal: Open() -Fehler";
(*$ ENDIF *)
 endMsg="\n<< RETURN >>";
 endLength=SIZE(endMsg);

VAR
 (*$ LongAlign:=TRUE *)
 input,output: Dos.FileHandlePtr;

(*
 * 8.6.90/bp
 * Dies ist eine UNGEPUFFERTE, stark erweiterte Version von Terminal.
 *)

CONST
  StringLen = 128;
VAR
  String:ARRAY [0..StringLen-1] OF CHAR;


(*$ EntryExitCode:=FALSE *)
PROCEDURE Write(ch:CHAR);
BEGIN
  ASSEMBLE(
	MOVEM.L	D2/D3/A6,-(A7)
	LEA	4+3*4(A7),A0
	MOVE.L	output(A4),D1
	MOVE.L	A0,D2
	MOVEQ	#1,D3
	MOVE.L	Dos(A4),A6
	JSR	Dos.Write(A6)
	MOVEM.L	(A7)+,D2/D3/A6
	MOVE.L	(A7)+,A0
	ADDQ.L	#2,A7
	JMP	(A0)
  END);
END Write;

PROCEDURE WriteLn; (*$ EntryExitCode:=FALSE *)
BEGIN
 ASSEMBLE(
	MOVE.B	#ASCII.lf,-(A7)
	BSR.S	Write
	RTS
 END);
END WriteLn;


(* Dies ergibt ein absolut sicheres RawDoFmt, weil der Puffer immer im
 * letzten Byte eine 0 hat und dann nicht mehr abgelegt wird!
 *)
PROCEDURE PutCh; (*$ EntryExitCode:=FALSE *)
BEGIN
  ASSEMBLE(
	TST.B	(A3)
	BEQ.S	nixMehr
	MOVE.B	D0,(A3)+
nixMehr:
	RTS
  END);
END PutCh;

(*$ EntryExitCode:=FALSE *)
PROCEDURE OutCount(from{8}:ADDRESS; count{0}:LONGINT);
BEGIN
  ASSEMBLE(
  	TST.L	D0
	BEQ.S   ready (* nichts zu tun???? *)
	MOVEM.L	D2/D3/A6,-(A7)
	MOVE.L	output(A4),D1
	MOVE.L	A0,D2
	MOVE.L	D0,D3
	MOVE.L	Dos(A4),A6
	JSR	Dos.Write(A6)
	MOVEM.L	(A7)+,D2/D3/A6
  ready:
	RTS
	END);
END OutCount;


PROCEDURE BusyRead(VAR ch: CHAR);
BEGIN
 IF Dos.IsInteractive(input) & ~Dos.WaitForChar(input,100) THEN
  ch:=ASCII.nul
 ELSE
  Read(ch)
 END
END BusyRead;


(*$ EntryExitCode:=FALSE *)
PROCEDURE Read(VAR ch: CHAR);
BEGIN
 ASSEMBLE(
 	MOVEM.L	D2/D3/A2/A6,-(A7)
	MOVE.L	4+4*4(A7),A2 (* addr ch *)
	MOVE.L	input(A4),D1
	MOVE.L	A2,D2
	MOVEQ	#1,D3
	MOVE.L	Dos(A4),A6
	JSR	Dos.Read(A6)
	SUBQ.L	#1,D0
	BEQ.S	ok (* war 1 *)
	MOVE.B	#ASCII.eof,(A2) (* mu A2 bleiben wg. ReadLn! *)
  ok: 	MOVEM.L	(A7)+,D2/D3/A2/A6
	MOVE.L	(A7)+,A0
  	ADDQ.L	#4,A7
  	JMP	(A0)
  END);
END Read;

(* Groer Unterschied: Nun am Ende IMMER 0C *)
PROCEDURE ReadLn(VAR st: ARRAY OF CHAR; VAR len: INTEGER);
BEGIN
 ASSEMBLE( (* len=d6, cp=a2 *)
	MOVEQ	#0,D6
	MOVE.L	st(A5),A2
  Loop:	PEA	(A2)
	BSR	Read
	MOVE.B	(A2),D0
	CMPI.B	#ASCII.eol,D0
	BEQ.S	Exit
	CMPI.B	#ASCII.eof,D0
	BEQ.S	Exit
	CMP.L	st+4(A5),D6
	BGE.S	Loop
	ADDQ.L	#1,A2
	ADDQ.L	#1,D6
	BRA.S	Loop
  Exit:	CLR.B	(A2) (* IMMER! *)
	MOVE.L	len(A5),A1
	MOVE.W	D6,(A1)
  END);
END ReadLn;


PROCEDURE WriteString(string: ARRAY OF CHAR); (*$ EntryExitCode:=FALSE *)
BEGIN
  ASSEMBLE(
	MOVE.L	4+0(A7),A1 (* A1=Str *)
	MOVE.L	A1,A0 (* 2. Para: Adr *)
	MOVE.L	8+0(A7),D0 (* High=max-1 *)
	MOVE.L  D0,D1
    Lp:	TST.B   (A1)+
	DBEQ    D1,Lp
	SUB.W	D1,D0
	EXT.L	D0
	BSR	OutCount
	MOVE.L	(A7)+,A0
	ADDQ.L	#8,A7
	JMP	(A0)
	END);
END WriteString;

(*$ CopyDyn:=FALSE *)
PROCEDURE Format(str:ARRAY OF CHAR; dats:ADDRESS);
BEGIN
  ASSEMBLE( (* string mit was fllen, letzter=0C *)
	LEA	String(A4),A0
	MOVEQ	#StringLen-1,D0
    Lp:	MOVE.B	D0,(A0)+
    	DBRA	D0,Lp
  END);
  Exec.RawDoFmt(ADR(str),dats,ADR(PutCh),ADR(String));
  WriteString(String);
END Format;

(* z.B. FormatS('- %s\n',inName) Spart einmal knstliches ADR()! *)
(*$ EntryExitCode:=FALSE *)
PROCEDURE FormatS(str:ARRAY OF CHAR; VAR innerStr:ARRAY OF CHAR);
BEGIN
  ASSEMBLE(
	MOVE.L	16(A7),-(A7)
	MOVE.L	16(A7),-(A7)
	PEA	12(A7)
	BSR.S	Format
	MOVE.L	(A7)+,A0
	LEA	16(A7),A7
	JMP	(A0)
  END);
END FormatS;

(*$ EntryExitCode:=FALSE *)
PROCEDURE RFproc;
BEGIN
  ASSEMBLE(
	MOVE.B	D0,(A3)+
	RTS
  END);
END RFproc;

(*$ CopyDyn:=FALSE *)
PROCEDURE FormatNr(str:ARRAY OF CHAR; nr:LONGINT);
BEGIN
  Format(str,ADR(nr));
END FormatNr;

PROCEDURE WriteInt(x:LONGINT; n:INTEGER);
VAR s:ARRAY[0..9] OF CHAR;
BEGIN
  RawDoFmt(ADR('%%%dld'),ADR(n),ADR(RFproc),ADR(s));
  Format(s,ADR(x));
END WriteInt;

PROCEDURE WriteHex(x:LONGINT; n:INTEGER);
VAR s:ARRAY[0..11] OF CHAR;
BEGIN
  IF n>=0 THEN (* RawDoFmt spinnt etwas bei neg. Zahlen und fhr. 0 *)
    RawDoFmt(ADR('%%0%dlx'),ADR(n),ADR(RFproc),ADR(s));
  ELSE
    n:=-n;
    RawDoFmt(ADR('%%-%dlx'),ADR(n),ADR(RFproc),ADR(s));
  END;
  Format(s,ADR(x));
END WriteHex;



PROCEDURE WBCleanup; (*$ EntryExitCode:=FALSE *)
BEGIN
  ASSEMBLE(
	MOVEM.L	A6,-(A7)
	TST.L	output(A4)
	BEQ.S	noOut
	TST.B	waitCloseGadget(A4)
	BEQ.S	noWait

	LEA	endMsg(PC),A0
	MOVEQ	#endLength,D0
	BSR	OutCount
	PEA	String(A4) (* irgendwohin *)
	BSR	Read
noWait:	LEA	output(A4),A0
	MOVE.L	(A0),D1
	CLR.L	(A0)
	MOVEA.L	Dos(A4),A6
	JSR	Dos.Close(A6)
noOut:	MOVE.L	(A7)+,A6
	RTS
  END);
END WBCleanup;


(* icon.library MUSS nicht da sein! *)
PROCEDURE GetDiskObject(base{16B}:ADDRESS;
			name{8}:ADDRESS):DiskObjectPtr; CODE -78;
PROCEDURE FindToolType(base{16B}:ADDRESS;
		toolTypes{8},
		typeName{9}:ADDRESS):ADDRESS; CODE -96;
PROCEDURE FreeDiskObject(base{16B}:ADDRESS;
		obj{8}:DiskObjectPtr); CODE -90;

PROCEDURE InitTerminal;
CONST maxLen=99;
VAR Name:ARRAY[0..maxLen] OF CHAR; (* reicht IMMER! *)
    diskObject:DiskObjectPtr;
    iconBase:ADDRESS;
    windowSpecs:POINTER TO CHAR;

    (* Packt str und programName nach Name *)
    PROCEDURE MakeName(str{10B}:ADDRESS);
    BEGIN
    ASSEMBLE( (* Name =concat(default+arg[0]) *)
	MOVE.L	8(A5),A1 (* lokale Proc! *)
	LEA	Name(A1),A1
      tool:
    	MOVEQ	#maxLen-1,D0
      lp1:
        MOVE.B	(A0)+,(A1)+
	DBEQ	D0,lp1
	BNE.S	rdy
	SUBQ.W	#1,A1	(* 0C wieder weg *)
	ADDQ.W	#1,D0
	MOVE.L	programName(A4),A0
      lp2:
        MOVE.B	(A0)+,(A1)+
	DBEQ	D0,lp2
      rdy:
    	CLR.B	(A1)	(* sicher eine 0 am Ende! *)
      END);
    END MakeName;

BEGIN
  waitCloseGadget:=TRUE;
  IF wbStarted THEN
    Name[0]:=0C;
    iconBase:=OpenLibrary(ADR(iconName),33);
    IF iconBase#NIL THEN
      diskObject:=GetDiskObject(iconBase,programName);
      IF diskObject#NIL THEN
        WITH diskObject^ DO
          windowSpecs:=FindToolType(iconBase,toolTypes,ADR(toolTypeEntry));
        END;
        IF (windowSpecs#NIL) & (windowSpecs^#ASCII.nul) THEN
          MakeName(windowSpecs);
        END;
        FreeDiskObject(iconBase,diskObject)
      END;
      CloseLibrary(iconBase);
    END;
    IF Name[0]=0C THEN
      MakeName(ADR(defaultSpecs));
    END;
    output:=Dos.Open(ADR(Name),Dos.oldFile);
    IF output=NIL THEN
      (* Zur Sicherheit, falls in CLOSE noch einer Ausgaben macht! *)
      output:=Dos.Open(ADR('NIL:'),Dos.oldFile);
      Error(ADR(errStr),ADR(Name));
    END;
    ASSEMBLE(
	MOVE.L	output(A4),input(A4)
	MOVE.L	thisTask(A4),A0
	MOVE.L	input(A4),Dos.Process.cis(A0)
	MOVE.L	output(A4),Dos.Process.cos(A0)
(* NEU: consoletask noch setzen *)
	MOVE.L	input(A4),A1
	ADDA.L	A1,A1
	ADDA.L	A1,A1
	MOVE.L	Dos.FileHandle.type(A1),Dos.Process.consoleTask(A0)
    END);
  ELSE
    input:=Dos.Input();
    output:=Dos.Output();
  END;
END InitTerminal;

BEGIN (* Terminal *)
  InitTerminal;
CLOSE
  IF wbStarted THEN
    WBCleanup;
  END;
END Terminal2.
