IMPLEMENTATION MODULE SeqIO;
(* 7.6.90/bp *)
(*$ LargeVars:=FALSE *)

FROM SYSTEM	IMPORT	BYTE, WORD, ADDRESS, ADR, ASSEMBLE, CAST, SETREG;
FROM Heap	IMPORT	Allocate, Deallocate;
FROM Arts	IMPORT	Assert;
FROM ExecL	IMPORT	AddHead, Remove;

IMPORT DosL,DosD;

(*$ StackChk:=FALSE RangeChk:=FALSE OverflowChk:=FALSE
    Volatile:=FALSE NilChk:=FALSE StackParms:=FALSE
 *)

TYPE
  SeqKey = POINTER TO Seq;
  Seq = RECORD
    succ,
    pred: SeqKey;
    f: DosD.FileHandlePtr; (* NIL: nicht ok *)
    ptr,
    end: ADDRESS; (* Zeiger und Ende des Puffers *)
    bsize:LONGINT; (* Gre des Puffers *)
    flen, (* nur bei InFiles benutzt, beim ffnen gesetzt! *)
    fpos:LONGINT;
    b: ARRAY[0..3] OF BYTE; (* hier beginnt der Puffer! *)
  END;

(*$ LongAlign:=TRUE *)
VAR
  FList: RECORD
    head,
    tail,
    tailPred: SeqKey;
  END;

PROCEDURE AllocSeq(VAR s:SeqKey; bSize:INTEGER);
BEGIN
  Assert((bSize>=4)&((bSize MOD 4)=0),ADR('SeqIO: illegal buffSize!'));
  Allocate(s,SIZE(Seq)-4+bSize);
  Assert(s#NIL,ADR('SeqIO: Out Of Memory'));
END AllocSeq;

(*$ EntryExitCode:=FALSE *) (* darf A0 nicht verndern! *)
PROCEDURE FlushBuffer(s{8}:SeqKey);
BEGIN
  ASSEMBLE(
 (* len:=outFile.ptr-outFile.b *)
	MOVEM.L	D2/D3/A6,-(A7)
	MOVE.L	A0,D0
	BEQ.S	BuffEmpty
	MOVE.L	Seq.f(A0),D1
	BEQ.S	Closed (* File geschlossen *)
	MOVE.L	Seq.ptr(A0),D3
	LEA	Seq.b(A0),A1
	SUB.L	A1,D3 (* len *)
	BLE.S	BuffEmpty
	MOVE.L	A1,D2 (* adr *)
 (* len>0, also len Bytes schreiben *)
	MOVE.L	A1,Seq.ptr(A0) (* bufferptr auf Anfang *)
	MOVEA.L	DosL(A4),A6
	MOVE.L	A0,-(A7)
	JSR	DosL.Write(A6) (* Testen, ob ok! *)
	MOVE.L	(A7)+,A0
	TST.L	D0
	BGT.S	BuffEmpty
	MOVE.L	Seq.f(A0),D1 (* bei Fehler gleich schliessen! *)
	CLR.L	Seq.f(A0)
	MOVE.L	A0,-(A7)
	JSR	DosL.Close(A6)
	MOVE.L	(A7)+,A0
  BuffEmpty:
	MOVEM.L	(A7)+,D2/D3/A6
  	RTS
  Closed: (* Hier mu der ptr zurckgesetzt werden, sonst Speicherzerstrung!*)
  	LEA	Seq.b(A0),A1
  	MOVE.L	A1,Seq.ptr(A0)
  	BRA.S	BuffEmpty
  END);
END FlushBuffer;

(*$ EntryExitCode:=FALSE *) (* darf A0 nicht verndern! *)
PROCEDURE FillBuffer(s{8}:SeqKey):LONGINT;
BEGIN
  ASSEMBLE(
	MOVEM.L	D2/D3/A2/A3/A6,-(A7)
  	MOVE.L	A0,A3
  	MOVE.L	A0,D0
  	BEQ.S	nono
	LEA     Seq.b(A3),A2
	MOVE.L  A2,Seq.ptr(A3)
	MOVE.L  Seq.f(A3),D1
	BEQ.S	nono
	MOVE.L  A2,D2
	MOVE.L  Seq.bsize(A3),D3
	MOVEA.L DosL(A4),A6
	JSR     DosL.Read(A6)
	ADDA.L  D0,A2
	MOVE.L  A2,Seq.end(A3) (*; end *)
	TST.L   D0
	BGT.S   ok
	MOVE.L	Seq.f(A3),D1
	CLR.L	Seq.f(A3)
	JSR	DosL.Close(A6)
nono:
	MOVEQ	#0,D0
	MOVE.L	A3,A0
ok:
	MOVEM.L	(A7)+,D2/D3/A2/A3/A6
	RTS
  END)
END FillBuffer;

(*$ CopyDyn:=FALSE *)
PROCEDURE OpenSeqIn(VAR key:SeqKey; name:ARRAY OF CHAR;
			buffSize:INTEGER):BOOLEAN;
VAR a:SeqKey;
BEGIN
  key:=NIL;
  AllocSeq(a,buffSize);
  a^.f:=DosL.Open(ADR(name),DosD.oldFile);
  IF a^.f#NIL THEN
    a^.ptr:=ADR(a^.b);
    a^.end:=a^.ptr;
    a^.bsize:=buffSize;
    (* a^.fpos:=0; *)
    SETREG(0,DosL.Seek(a^.f,0,DosD.end)); (* ans Ende gehen *)
    a^.flen:=DosL.Seek(a^.f,0,DosD.beginning);
    AddHead(ADR(FList),a);
    key:=a;
    RETURN TRUE;
  ELSE
    Deallocate(a);
    RETURN FALSE
  END;
END OpenSeqIn;

PROCEDURE CloseSeq(VAR key:SeqKey);
BEGIN
  IF key#NIL THEN
    IF key^.flen=0 THEN FlushBuffer(key) END; (* Writefile? Then flush. *)
    IF key^.f#NIL THEN DosL.Close(key^.f) END;
    Remove(key);
    Deallocate(key);
    key:=NIL;
  END;
END CloseSeq;

(*$ EntryExitCode:=FALSE *) (* darf auch A0 nicht verndern! *)
PROCEDURE SeqInB(key{8}:SeqKey):CHAR;
BEGIN
  ASSEMBLE(
	MOVE.L	A0,D0
	BEQ.S	nix
	TST.L	Seq.f(A0)
	BEQ.S	nix
	MOVE.L	Seq.end(A0),D0
	SUB.L	Seq.ptr(A0),D0
	BGT.S	noFill
	MOVE.L	A0,-(A7)
	BSR	FillBuffer (* A0 noch ok, danach neue BuffLen in D0! *)
	MOVE.L	(A7)+,A0
noFill:	TST.L	D0
	BLE.S	nix
	MOVEA.L	Seq.ptr(A0),A1
	MOVEQ	#0,D0
	MOVE.B	(A1)+,D0
	MOVE.L	A1,Seq.ptr(A0)
	ADDQ.L	#1,Seq.fpos(A0)
	BRA.S	ok
nix:	MOVEQ	#0,D0
ok:	RTS
	END);
END SeqInB;

(*$ EntryExitCode:=FALSE *)
PROCEDURE SeqGetB(key{8}:SeqKey; VAR b{9}:BYTE);
BEGIN
  ASSEMBLE(
	MOVE.L	A1,-(A7)
	BSR.S	SeqInB
	MOVE.L	(A7)+,A1
	MOVE.B	D0,(A1)
	RTS
  END);
END SeqGetB;

(*$ EntryExitCode:=FALSE *)
PROCEDURE SeqInW(key{8}:SeqKey):INTEGER;
BEGIN
  ASSEMBLE(
	MOVE.W	D2,-(A7)
	BSR	SeqInB
	ASL.W	#8,D0
	MOVE.W	D0,D2
	BSR	SeqInB
	OR.W	D2,D0
	MOVE.W	(A7)+,D2
	RTS
	END);
END SeqInW;

(*$ EntryExitCode:=FALSE *)
PROCEDURE SeqGetW(key{8}:SeqKey; VAR w{9}:WORD);
BEGIN
  ASSEMBLE(
	MOVE.L	A1,-(A7)
	BSR.S	SeqInW
	MOVE.L	(A7)+,A1
	MOVE.W	D0,(A1)
	RTS
  END);
END SeqGetW;

(*$ EntryExitCode:=FALSE *)
PROCEDURE SeqInL(key{8}:SeqKey):LONGINT;
BEGIN
  ASSEMBLE(
	MOVE.L	D2,-(A7)
	BSR	SeqInB
	ROR.L	#8,D0	(* highest *)
	MOVE.L	D0,D2
	BSR	SeqInB
	SWAP	D0
	OR.L	D0,D2
	BSR	SeqInB
	ASL.W	#8,D0
	OR.W	D0,D2
	BSR	SeqInB
	OR.L	D2,D0
	MOVE.L	(A7)+,D2
	RTS
	END);
END SeqInL;

(*$ EntryExitCode:=FALSE *)
PROCEDURE SeqGetL(key{8}:SeqKey; VAR l{9}:ADDRESS);
BEGIN
  ASSEMBLE(
	MOVE.L	A1,-(A7)
	BSR.S	SeqInL
	MOVE.L	(A7)+,A1
	MOVE.L	D0,(A1)
	RTS
  END);
END SeqGetL;

(*$ EntryExitCode:=FALSE *) (* Nur, wenn keine Einzelbytes geholt werden! *)
PROCEDURE SeqInLQuick(key{8}:SeqKey):LONGINT;
BEGIN
  ASSEMBLE(
	MOVE.L	A0,D0
	BEQ.S	nix
	TST.L	Seq.f(A0)
	BEQ.S	nix
	MOVE.L	Seq.end(A0),D0
	SUB.L	Seq.ptr(A0),D0
	BGT.S	noFill
	BSR	FillBuffer (* A0 noch ok, danach neue BuffLen in D0! *)
noFill:	TST.L	D0
	BLE.S	nix
	MOVEA.L	Seq.ptr(A0),A1
	MOVE.L	(A1)+,D0
	MOVE.L	A1,Seq.ptr(A0)
	ADDQ.L	#4,Seq.fpos(A0)
	BRA.S	ok
nix:	MOVEQ	#0,D0
ok:	RTS
	END);
END SeqInLQuick;

(*$ EntryExitCode:=FALSE *)
PROCEDURE SeqGetLQuick(key{8}:SeqKey; VAR l{9}:ADDRESS);
BEGIN
  ASSEMBLE(
	MOVE.L	A1,-(A7)
	BSR.S	SeqInLQuick
	MOVE.L	(A7)+,A1
	MOVE.L	D0,(A1)
	RTS
  END);
END SeqGetLQuick;

(* kein $ E - !! *)
PROCEDURE SeqInCount(key:SeqKey; adr:ADDRESS; cnt:CARDINAL);
BEGIN
  ASSEMBLE(
	MOVE.L	key(A5),A0
	MOVE.L	A0,D0
	BEQ	ready (* nix lesen! mte mit fllen!! *)
	MOVEQ	#0,D0
	MOVE.W	cnt(A5),D0
	ADD.L	D0,Seq.fpos(A0)
InWhile:
	MOVEQ	#0,D0
	MOVE.W  cnt(A5),D0
	BEQ.S   ready
	MOVE.L	key(A5),A2
	TST.L   Seq.f(A2)
	BEQ.S   ready

	MOVE.L  Seq.end(A2),D1
	SUB.L   Seq.ptr(A2),D1
	BLE.S   empty
	CMP.L   D1,D0
	BGT.S   single
	(*; count kopieren, ptr erhhen *)
	MOVEA.L	adr(A5),A3
	MOVEA.L	Seq.ptr(A2),A0
	ADD.L	D0,Seq.ptr(A2)
	SUBQ.L	#1,D0
cntlp:	MOVE.B	(A0)+,(A3)+
	DBRA	D0,cntlp
	(*; alles fertig *)
	BRA.S	ready

single: (*; else:count>in *)
	SUB.W   D1,cnt(A5) (*; dec(count,in) *)
	MOVEA.L	adr(A5),A3
	ADD.L	D1,adr(A5)
	MOVEA.L	Seq.ptr(A2),A1
	ADD.L	D1,Seq.ptr(A2)
	SUBQ.W	#1,D1
inlp:	MOVE.B	(A1)+,(A3)+
	DBRA	D1,inlp
(*;	BRA.S   InWhile ; weitermachen, aber logisch erst fllen! *)
empty:
	MOVE.L	A2,A0
	BSR     FillBuffer
	TST.L	D0
	BGT.S   InWhile
ready:
	END);
END SeqInCount;

PROCEDURE SeqInLen(key{8}:SeqKey):LONGINT;
BEGIN
  IF key#NIL THEN
    RETURN key^.flen
  ELSE
    RETURN 0
  END;
END SeqInLen;

PROCEDURE SeqInPos(key{8}:SeqKey):LONGINT;
BEGIN
  IF key#NIL THEN
    RETURN key^.fpos
  ELSE
    RETURN 0
  END;
END SeqInPos;

(*$ CopyDyn:=FALSE *)
PROCEDURE OpenSeqOut(VAR key:SeqKey; name:ARRAY OF CHAR;
			buffSize:INTEGER):BOOLEAN;
VAR a:SeqKey;
BEGIN
  key:=NIL;
  AllocSeq(a,buffSize);
  a^.f:=DosL.Open(ADR(name),DosD.newFile);
  IF a^.f#NIL THEN
    a^.ptr:=ADR(a^.b);
    a^.end:=LONGINT(a^.ptr)+buffSize;
    a^.bsize:=buffSize;
    (* a^.fpos:=0; *)
    AddHead(ADR(FList),a);
    key:=a;
    RETURN TRUE;
  ELSE
    Deallocate(a);
    RETURN FALSE
  END;
END OpenSeqOut;


(*$ EntryExitCode:=FALSE *)
PROCEDURE SeqOutB(key{8}:SeqKey; b{0}:BYTE);
BEGIN
  ASSEMBLE(
	MOVE.L	A0,D1
	BEQ.S	nono
	MOVE.B	D0,-(A7)
	MOVE.L	Seq.ptr(A0),A1
	CMPA.L	Seq.end(A0),A1
	BLT.S   NotFull		(* ptr<end: geht noch was rein *)
	BSR	FlushBuffer
	MOVE.L	Seq.ptr(A0),A1  (* evtl. von Flush verndert! *)
  NotFull:
	MOVE.B	(A7)+,(A1)+
	MOVE.L  A1,Seq.ptr(A0)
	ADDQ.L	#1,Seq.fpos(A0)
  nono:
	RTS
  	END
	);
END SeqOutB;

(*$ EntryExitCode:=FALSE *)
PROCEDURE SeqOutW(key{8}:SeqKey; w{0}:WORD);
BEGIN
  ASSEMBLE(
	MOVE.W	D0,-(A7)
	LSR.W	#8,D0
	BSR	SeqOutB (* high *)
	MOVE.W	(A7)+,D0
	BRA	SeqOutB (* low *)
  	END);
END SeqOutW;

(*$ EntryExitCode:=FALSE *)
PROCEDURE SeqOutL(key{8}:SeqKey; l{0}:ADDRESS);
BEGIN
  ASSEMBLE(
	ROL.L	#8,D0
	MOVE.L	D0,-(A7)
	BSR	SeqOutB (* high *)
	MOVE.L	(A7)+,D0
	ROL.L	#8,D0
	MOVE.L	D0,-(A7)
	BSR	SeqOutB (* mhigh *)
	MOVE.L	(A7)+,D0
	ROL.L	#8,D0
	MOVE.L	D0,-(A7)
	BSR	SeqOutB (* mlow *)
	MOVE.L	(A7)+,D0
	ROL.L	#8,D0
	BRA	SeqOutB (* low *)
  	END);
END SeqOutL;

(*$ EntryExitCode:=FALSE *)
PROCEDURE SeqOutLQuick(key{8}:SeqKey; b{0}:ADDRESS);
BEGIN
  ASSEMBLE(
	MOVE.L	A0,D1
	BEQ.S	nono
	MOVE.L	D0,-(A7)
	MOVE.L	Seq.ptr(A0),A1
	CMPA.L	Seq.end(A0),A1
	BLT.S   NotFull		(* ptr<end: geht noch was rein *)
	BSR	FlushBuffer
	MOVE.L	Seq.ptr(A0),A1  (* evtl. von Flush verndert! *)
  NotFull:
	MOVE.L	(A7)+,(A1)+
	ADDQ.L	#4,Seq.fpos(A0)
	MOVE.L  A1,Seq.ptr(A0)
  nono:
	RTS
  	END
	);
END SeqOutLQuick;


PROCEDURE SeqOutCount(key{8}:SeqKey; adr{9}:ADDRESS; cnt{0}:CARDINAL);
BEGIN
  ASSEMBLE(
	TST.W	D0
	BEQ.S   ready (* nichts zu tun???? *)
	MOVE.L	A0,D1
	BEQ.S	ready
 (* Versuch: wenn noch genug Platz im Puffer, dann direkt kopieren, sonst
    Bytes einzeln raus *)
	MOVE.L	Seq.ptr(A0),A2
	MOVE.L	Seq.end(A0),D1
	SUB.L	A2,D1 (* end-ptr=Platz *)
	CMP.W	D0,D1
	BCS.S	SingleCopy (* Platz < Bytes *)
	MOVEQ	#0,D1
	MOVE.W	D0,D1
	ADD.L	D1,Seq.fpos(A0)
	SUBQ.W	#1,D0
  Cpy:	MOVE.B	(A1)+,(A2)+
	DBRA	D0,Cpy
	MOVE.L	A2,Seq.ptr(A0)
	BRA.S	ready

  SingleCopy:
	SUBQ.W	#1,D0
	MOVE.W	D0,D7
	MOVE.L	A1,A3
  OutWhile:
	MOVE.B	(A3)+,D0
	BSR	SeqOutB (* a0 bleibt erhalten! *)
	DBRA	D7,OutWhile
  ready:
	END
	);
END SeqOutCount;

(* Liefert die momentane Lnge des Files zurck *)
PROCEDURE SeqOutPos(key{8}:SeqKey):LONGINT;
BEGIN
  IF key#NIL THEN
    RETURN key^.fpos
  ELSE
    RETURN 0
  END;
END SeqOutPos;


(* TRUE, wenn soweit kein Fehler aufgetreten *)
PROCEDURE SeqOk(key{8}:SeqKey):BOOLEAN;
BEGIN
  RETURN (key#NIL)&(key^.f#NIL)
END SeqOk;

(* 29.10.90/bp
 * CloseSeq hat einen VAR-Parameter und setzt die VAR auf NIL,
 * deshalb darf FList.head NICHT bergeben werden!
 *)
VAR
  help:SeqKey;
BEGIN
  ASSEMBLE( (* NewList *)
	LEA	FList(A4),A0
	MOVE.L	A0,(A0)	(* NewList *)
	ADDQ.L	#4,(A0)
	CLR.L	4(A0)
	MOVE.L	A0,8(A0)
  END);

CLOSE
  WHILE FList.head^.succ#NIL DO
    help:=FList.head;
    CloseSeq(help)
  END;
END SeqIO.
