IMPLEMENTATION MODULE MkPrint;
(*$ LargeVars:=FALSE LongAlign:=FALSE StackParms:=FALSE Volatile:=FALSE *)


FROM ASCII IMPORT
  nul, eol;

FROM Terminal IMPORT
  Write, WriteLn, WriteString;

FROM String IMPORT
  Copy;

FROM Break IMPORT
  TestBreak;

FROM MkBase IMPORT
  ModPtr, ImportPtr, modList;


CONST
 nameLen=15;
 maxDigits=3;
 title0=
"       \\  Modul B |     :     |     :     |     :     |     :     |     :     |\n";
 title1a=
"Modul A \\         |    5:   10|   15:   20|   25:   30|   35:   40|   45:   50|\n";
 title1b=
"Modul B \\         |   55:   60|   65:   70|   75:   80|   85:   90|   95:  100|\n";
 title1c=
"Modul B \\         |  105:  110|  115:  120|  125:  130|  135:  140|  145:  150|\n";
 title2=
(*1...+....1....5....2....5....3....5....4....5....5....5....6....5....7....5....8*)
 "------------------|-----:-----|-----:-----|-----:-----|-----:-----|-----:-----|\n";

VAR
  lp: INTEGER;
  line: ARRAY [0..85] OF CHAR;


PROCEDURE Put(ch: CHAR);
  BEGIN
    IF lp<SIZE(line) THEN
     line[lp]:=ch; INC(lp)
    END
  END Put;


(*$ CopyDyn:=FALSE *)
PROCEDURE PutName(name: ARRAY OF CHAR);
  BEGIN
    line:=title0;
    lp:=0;
    WHILE (lp<nameLen) & (lp<=HIGH(name)) & (name[lp]#nul) DO Put(name[lp]) END;
    WHILE lp<nameLen DO Put(' ') END;
  END PutName;


PROCEDURE PutInt(i: INTEGER);
  VAR
    j: INTEGER;
    st: ARRAY [0..maxDigits-1] OF CHAR;
  BEGIN
    st:="   "; j:=maxDigits-1;
    REPEAT
      st[j]:=CHAR(i MOD 10 + ORD("0")); i:=i DIV 10; DEC(j)
    UNTIL i=0;
    FOR j:=0 TO maxDigits-1 DO Put(st[j]) END
  END PutInt;


PROCEDURE PrintDependencies;

  CONST modPerLine=50;

  PROCEDURE PutImport(nr: INTEGER; def: BOOLEAN);
    BEGIN
      IF (0<nr) & (nr<=modPerLine) THEN
        lp:=nameLen + maxDigits + nr + (nr-1) DIV 5;
        IF def THEN Put('D') ELSE Put('X') END
      END
    END PutImport;

  VAR
    from,
    max: INTEGER;
    m: ModPtr;
    i: ImportPtr;
  BEGIN
    from:=0;
    (* 17.11.91/bp Warum nur bis 20, jr??? *)
    max:=0;
    WHILE from<=max DO
      WriteLn; WriteLn; WriteLn;
      WriteString(title0);
      IF    from=0            THEN WriteString(title1a)
      ELSIF from=modPerLine   THEN WriteString(title1b)
      ELSIF from=modPerLine*2 THEN WriteString(title1c)
      END;

      m:=modList;
      IF m#NIL THEN max:=m^.num END;
      WHILE m#NIL DO
        TestBreak;
        WriteString(title2);
        PutName(m^.name); PutInt(m^.num); Put("|");
        i:=m^.importList;
        WHILE i#NIL DO
          PutImport(i^.importedMod^.num-from, i^.importedByDef);
          i:=i^.next
        END;

        WriteString(line);
        m:=m^.next
      END;

      INC(from, modPerLine)
    END
  END PrintDependencies;

END MkPrint.mod
