IMPLEMENTATION MODULE MkParser;
(*$ LargeVArs:=FALSE LongAlign:=FALSE StackParms:=FALSE Volatile:=FALSE *)


FROM SYSTEM IMPORT ADDRESS, ADR, CAST, SETREG, SHIFT;

FROM Arts IMPORT
  maxModName, ModName, BreakPoint;

FROM ASCII IMPORT
  nul, eol;

FROM Terminal IMPORT
  Write, FormatS;

FROM Break IMPORT
  InstallException, TestBreak;

FROM FileSystem	IMPORT
  File, Response, Close, Lookup, ReadBytes, ReadChar, WriteBytes, WriteChar;

FROM String IMPORT
  Compare;

FROM MkBase IMPORT
  FileName, ModType, ModPtr, quiet, mainMod, isLinkable, modList, DependsOn,
  AddMod, CleanList;

FROM MkFile IMPORT
  pathFileName, FileType, GetFileName, ReadPathTable;


CONST
 termCh=377C;

TYPE
  Symbol = (ident, import, from, moduleKW, definition, implementation,
    var, type, const, procedure, begin, end, colon, eof);
  KeyWord = ARRAY [0..15] OF CHAR;

VAR
  id: ModName;
  modType: ModType;
  src: File;
  sym: Symbol;
  ch: CHAR;
  isImp, isDef: BOOLEAN;
  kw: ARRAY Symbol OF KeyWord;


PROCEDURE GetSym;


  PROCEDURE GetCh;
    BEGIN
      ReadChar(src, ch);
(*      Write(ch);*)
      IF src.eof OR (src.res#done) THEN ch:=termCh END;
    END GetCh;


  PROCEDURE GetId(cap: BOOLEAN);
    VAR i: INTEGER;
    BEGIN
      i:=0;
      REPEAT
        IF i<SIZE(id) THEN
          IF cap THEN ch:=CAP(ch) END;
          id[i]:=ch; INC(i)
        END;
        GetCh
      UNTIL ~(("A"<=CAP(ch))&(CAP(ch)<="Z") OR ("0"<=ch)&(ch<="9"));
      IF i<SIZE(id) THEN id[i]:=nul END
    END GetId;


  PROCEDURE CheckKW;
    VAR
      s: Symbol;
    BEGIN
      GetId(FALSE);
      FOR s:=import TO end DO
        IF Compare(id, kw[s])=0 THEN sym:=s; RETURN END
      END;
      sym:=ident
    END CheckKW;


  PROCEDURE ImplFalse(): BOOLEAN;
    (* vergleicht auf "implementation := FALSE" *)
    VAR m: ModName;
    BEGIN
      GetId(TRUE);
      IF Compare(id, kw[implementation])=0 THEN (* Zufall! *)
        WHILE (ch<=' ') DO GetCh END;
        IF ch=":" THEN
          GetCh;
          IF ch="=" THEN
            GetCh;
            WHILE (ch<=' ') DO GetCh END;
            GetId(FALSE);
            RETURN Compare(id, 'FALSE')=0
          END
        END
      END;
      RETURN FALSE;
    END ImplFalse;


  VAR
    nesting: INTEGER;
    compCom: BOOLEAN;
  BEGIN (* GetSym *)
    LOOP
      WHILE ch<=" " DO GetCh END;
      IF    ch=termCh                     THEN sym:=eof; EXIT
      ELSIF ch=":"                        THEN sym:=colon; GetCh; EXIT
      ELSIF ('A'<=CAP(ch))&(CAP(ch)<='Z') THEN CheckKW; EXIT
      ELSIF ch="(" THEN
        GetCh;
        IF ch="*" THEN
          compCom:=FALSE;
          GetCh;
          IF ch="$" THEN GetCh; compCom:=TRUE; END;
          nesting:=1;
          LOOP
            IF (nesting=0) OR (ch=termCh) THEN
              EXIT
            ELSIF ch="(" THEN
              GetCh;
              IF ch="*" THEN
                INC(nesting);
                GetCh
              END
            ELSIF ch="*" THEN
              GetCh;
              IF ch=")" THEN
                DEC(nesting);
                GetCh
              END
            ELSIF compCom & (nesting=1) & (CAP(ch)="I") & ImplFalse() THEN
              modType:=noImpMod
            ELSE
              GetCh
            END
          END
        END
      ELSIF ch="{" THEN
        modType:=libMod; GetCh
      ELSE
        GetCh
      END
    END
  END GetSym;


PROCEDURE GetImports(m: ModPtr; fType: FileType);
  VAR
    fName: FileName;
    modId: ModName;
    len: INTEGER;
    err, seen: BOOLEAN;
  BEGIN
    modType:=noSource;
    isImp:=FALSE; isDef:=FALSE;
    GetFileName(fName, len, len, fType, m^.name, FALSE);
    Lookup(src, fName, 2048, FALSE);
    IF src.res#done THEN RETURN END;

    IF ~quiet THEN FormatS(" - %s\n", fName); TestBreak END;
    modType:=progMod;
    seen:=FALSE;
    GetSym;
    LOOP (* little parser (assumes correct source, no error recovery..) *)
(*      Write('');
*)      IF sym>=var THEN EXIT END; (* the import section is over *)
      IF sym=import THEN
        GetSym;
        LOOP
          IF sym#ident THEN EXIT END;
          modId:=id; GetSym;
          IF sym#colon THEN DependsOn(m, modId, fType=defFile, err) ELSE GetSym END
        END
      ELSE
        CASE sym OF
        | from:           GetSym; DependsOn(m, id, fType=defFile, err); GetSym
        | moduleKW:       IF seen THEN EXIT END; seen:=TRUE
        | definition:     isDef:=TRUE
        | implementation: isImp:=TRUE; DependsOn(m, m^.name, FALSE, err)
        ELSE (* ident *)             (* ^^^ IMP implicitely imports its DEF!! *)
        END;
        GetSym
      END
    END;
(* 24.11.90/bp Arts und MathREAL herausgenommen, bringt nur rger! *)
    IF modType=libMod THEN
      DependsOn(m, 'Arts', TRUE, err);
    ELSIF ~isDef THEN
      DependsOn(m, 'MathREAL', FALSE, err);
      DependsOn(m, 'MathFFP', FALSE, err);
      DependsOn(m, 'MathIEEEDoubBas', FALSE, err);
      DependsOn(m, 'Profiler', FALSE, err);
    END;
    Close(src)
  END GetImports;


PROCEDURE GetDependencies(VAR module: ModName): BOOLEAN;
  VAR
    m: ModPtr;
    defFound: BOOLEAN;
  BEGIN
    CleanList;
    m:=AddMod(module); isLinkable:=FALSE;
    REPEAT
      IF m^.srcRead THEN m:=m^.next
      ELSE
        GetImports(m, defFile);

        (* consistency 1 *)
        IF modType=noSource THEN defFound:=FALSE
        ELSE
          defFound:=isDef;
          IF ~defFound THEN FormatS('%s: no DEFINITION in .def-file\n', m^.name) END;
        END;

        IF modType<=impMod THEN
          GetImports(m, modFile);
          IF m=mainMod THEN isLinkable:=~isImp END;

          (* consistency 2 *)
          IF defFound THEN
            IF modType=noSource THEN
              FormatS('%s: .mod-file missing\n', m^.name)
            ELSIF ~isImp THEN
              FormatS('%s: no IMPLEMENTATION in .mod-file\n', m^.name)
            END;
            modType:=impMod
          ELSIF isImp THEN
            FormatS('%s: IMPLEMENTATION found, no .def-file\n', m^.name)
          END;
        END;
        m^.srcRead:=TRUE;
        m^.type:=modType;
        m:=modList (* once again from the beginning *)
      END
    UNTIL m=NIL;

    RETURN TRUE; (* Is that ok ? /bp/jr *)
  END GetDependencies;


BEGIN
  InstallException; (*--------------< wieder lschen spter >-----------------*)
  kw[import        ]:="IMPORT";
  kw[from          ]:="FROM";
  kw[moduleKW      ]:="MODULE";
  kw[definition    ]:="DEFINITION";
  kw[implementation]:="IMPLEMENTATION";
  kw[var           ]:="VAR";
  kw[type          ]:="TYPE";
  kw[const         ]:="CONST";
  kw[procedure     ]:="PROCEDURE";
  kw[begin         ]:="BEGIN";
  kw[end           ]:="END";
END MkParser.mod
