IMPLEMENTATION MODULE MkCheck;

(*$ LargeVars:=FALSE LongAlign:=FALSE StackParms:=FALSE Volatile:=FALSE
    DEFINE English:=FALSE *)


FROM SYSTEM IMPORT ADR;

FROM Arts IMPORT
  ModName, BreakPoint;

FROM ASCII IMPORT
  nul;

FROM DosD IMPORT
  Date;

FROM Terminal IMPORT
  WriteLn, WriteString, WriteInt, FormatNr, FormatS;

FROM Break IMPORT
  TestBreak;

FROM String IMPORT
  Copy;

FROM MkBase IMPORT
  FileName, ModType, ModPtr, ImportPtr, modList, mainMod, warning, GetDate;

FROM MkFile IMPORT
  FileType, GetFileName;



CONST
(*$ IF English *)

 noDEF  = "%s: DEF missing";
 noMOD  = "%s: MOD missing";
 noOBJ  = ": OBJ missing";
 oldOBJ = ": OBJ older than MOD";
 newSYM = ": OBJ older than imported SYM";

(*$ ELSE *)

 noDEF  = "%s: DEF fehlt";
 noMOD  = "%s: MOD fehlt";
 noOBJ  = ": OBJ fehlt";
 oldOBJ = ": OBJ lter als MOD";
 newSYM = ": OBJ lter als importiertes SYM";

(*$ ENDIF *)



VAR
  latestObjDate: Date;


PROCEDURE older(VAR d1, d2: Date): BOOLEAN;
(* RETURNS d1 older than d2 *)
  BEGIN
    IF   d1.days#d2.days   THEN RETURN d1.days<d2.days     END;
    IF d1.minute#d2.minute THEN RETURN d1.minute<d2.minute END;
    RETURN d1.tick<=d2.tick
  END older;


PROCEDURE BinToLink(): BOOLEAN;
  VAR
    binDate: Date;
    len: INTEGER;
    fName: FileName;
  BEGIN
    IF toFile.str[0]#0C THEN
      Copy(fName, toFile.str);
    ELSE
      GetFileName(fName, len, len, binFile, mainMod^.name, TRUE);
    END;
    IF ~GetDate(fName, binDate) THEN RETURN TRUE END;

    RETURN older(binDate, latestObjDate)
  END BinToLink;


PROCEDURE Make(Compile: CompileProc);
(* Algorithmus:
    (1) Schleife: ein DEF-Modul muss kompiliert werden, wenn
     - SYM-Datei fehlt
     - SYM-Datei lter als DEF-Datei
     - SYM-Datei lter als mindestens eine importierte SYM-Datei
    (2) Schleife: ein PROG- oder IMP-Modul muss kompiliert werden
     - OBJ-Datei fehlt
     - OBJ-Datei lter als MOD-Datei
     - OBJ-Datei lter als mindestens eine importierte SYM-Datei
    (3) Spezialfall fr LIB-Module:
     - DEF Modul muss auch kompiliert werden, wenn OBJ fehlt!
*)
  PROCEDURE olderThanImports(d: Date; i: ImportPtr; checkAll: BOOLEAN): BOOLEAN;
    BEGIN
      WHILE i#NIL DO
        WITH i^ DO
          IF (checkAll OR importedByDef) & older(d, importedMod^.symDate)
          THEN
            RETURN TRUE
          END;
          i:=i^.next
        END
      END;
      RETURN FALSE
    END olderThanImports;


  TYPE
    FInfo = RECORD
      fName: FileName;
      fIdx: INTEGER;
      date: Date;
    END;

  (* 17.11.91/bp forceCPU sollte bei Libs nicht zuschlagen!!! *)
  PROCEDURE fileExists(typ: FileType; forceCPU:BOOLEAN; VAR name: ModName; VAR fi: FInfo): BOOLEAN;
    VAR
      len: INTEGER;
    BEGIN
      GetFileName(fi.fName, len, fi.fIdx, typ, name, FALSE);
      IF (typ=objType) & ~forceCPU THEN
        WHILE (len=0) & (typ>objFile) DO
          DEC(typ);
          GetFileName(fi.fName, len, fi.fIdx, typ, name, FALSE);
        END
      END;
      RETURN GetDate(fi.fName, fi.date)
    END fileExists;


  VAR
    m: ModPtr;
    srcInfo, compInfo: FInfo;
  BEGIN
    m:=modList;
    WHILE m#NIL DO                 (* check sym *)
      TestBreak;
      WITH m^ DO
        compInfo.date.days:=0;
        IF ~fileExists(defFile, FALSE, name, srcInfo) THEN
          IF type>=impMod THEN FormatS(noDEF, srcInfo.fName) END
        ELSIF
          ~fileExists(symFile, FALSE, name, compInfo) OR
          older(compInfo.date, srcInfo.date) OR
          olderThanImports(compInfo.date, importList, FALSE) OR
          ((type=libMod) &
            (~fileExists(objType, FALSE, name, compInfo) OR
             older(compInfo.date, srcInfo.date) OR
             olderThanImports(compInfo.date, importList, FALSE)
            )
          )
        THEN
          Compile(srcInfo.fName, srcInfo.fIdx);
          compInfo.date.days:=36499 (* future: 3-12-2077 *)
        END;
        symDate:=compInfo.date;
        m:=next
      END
    END;

    latestObjDate.days:=0; (* for 'BinToLink' *)
    m:=modList;
    WHILE m#NIL DO                (* check obj *)
      TestBreak;
      WITH m^ DO
        compInfo.date.days:=0;
        IF ~fileExists(modFile, FALSE, name, srcInfo) THEN
          IF (type=progMod) OR (type=impMod) THEN FormatS(noMOD, srcInfo.fName) END
        ELSIF
          ~fileExists(objType, forceCPU, name, compInfo) OR
          older(compInfo.date, srcInfo.date) OR
          olderThanImports(compInfo.date, importList, TRUE)
        THEN
          WriteString(srcInfo.fName);
          IF compInfo.fName[0]=0C THEN
            WriteString(noOBJ)
          ELSIF older(compInfo.date, srcInfo.date) THEN
            WriteString(oldOBJ)
          ELSE
            WriteString(newSYM);
(*
            BreakPoint(ADR('ImportListe'))
*)
          END;
          WriteLn;
          Compile(srcInfo.fName, srcInfo.fIdx);
          compInfo.date.days:=36499 (* future: 3-12-2077 *)
        END;
        (* remember youngest OBJ date *)
        IF older(latestObjDate, compInfo.date) THEN latestObjDate:=compInfo.date END;
        m:=next
      END
    END
  END Make;

END MkCheck.mod
