IMPLEMENTATION MODULE M2XM;
(*$ LargeVars:=FALSE LongAlign:=FALSE StackChk:=FALSE StackParms:=FALSE
    Volatile:=FALSE
*)
(*$ DEFINE MarkCode:=FALSE *) (* MOVEA.L Ax,Ax als Markierung zum Testen! *)
(* 31.12.88/ms *)
(* 27.2.90/bp
 * move.l #0,Ax --> suba.l ax,ax
 * move.b #$ff,ea --> st ea
 * Err, Put16, Put32 in Assembler und RegisterParas
 * aus M2SM sonst nichts mehr benutzt, also gelscht (nur noch Mark)
 * 28.2.90/bp
 * move.x $00000004,ea -> move.x $0004,ea
 * also absL als absW, wenn mglich.
 * 1.3.90/bp
 * Optimierung: move.l #long,mem -> moveq #xx,Dn move.l Dn,mem
 * 3.3.90/bp
 * Ext setzt nun bei Byte das High-Byte auf 0
 * Move: Wenn mglich: PEA abs.W
 * 8.3.90/bp
 * Move: setzt nach MOVEQ auch wid auf long
 * Move: LoadCC bei cocMd mglichst vermeiden. Ergibt dann: Scc ea
 *)

FROM SYSTEM IMPORT ADR,CAST,SHIFT,WORD,ASSEMBLE,BITSET;


FROM Arts IMPORT BreakPoint;
FROM Assembler IMPORT
 d0,d1,d2,d3,d6,d7,a0,a1,a3,a4,a5,a6,a7,ls3,ls6,ls7,ls8,ls9,ls10,ls11,ls12,
 adir,adec,aidr
 ,aidx,ainc,aoff,ddir,imm,prel,absW,absL,addL,addaL,addiL,addqL,andiW,andiL
 ,bcc,bra,beq
 ,bne,bpl,bseti,clrB,cmpiB,dbeq,dbra,extW,extL,lea,lslL,lsliL,lsrL,lsriL,moveB
 ,moveW,moveL,moveaW,moveaL,moveqL,movemL,movemmL,nop,orL,pea,roliL,st,subaL
 ,subqL,swapW,trap;
FROM M2DM IMPORT
 pc, Condition, VarModes, ModModes, Ident, ExportTypes,
 minSInt,maxSInt,maxSCard,minInt,maxInt,minCard,maxCard,maxReal,WidType,byte,
 word,long,RegType,Register,RegisterSet,ConstValue,StrPtr,StrForm,
 tp,GlobVarType;
IMPORT M2SM;
FROM M2SM	IMPORT	Mark;
FROM M2OM IMPORT Options,Option,CompOpts;
IMPORT M2LM;
FROM M2LM IMPORT
 ip,FixLink,PCRel,FCondBranch,BCondBranch,PCRef,DRel,DIniRel,AbsData,
 AbsIniData,ConstRel,AbsCode,HunkStart,NewRef,PutWord,PutLong,
 PutInBuffer;
FROM M2HM IMPORT Trap,lastProfOff;

CONST
 sb=a4; mp=a5; sp=a7; fp0=0; fp1=fp0+1; fp7=fp0+7; (* in set: +16 *)
 FWord = 0F200H; (* Standard 1. Wort bei 68881 *)
 fmoveMR=0101010000000000L; (* FMOVE.D ea,FPx *)
 fmoveRM=0111010000000000L; (* FMOVE.D FPx,ea *)
 fmoveRR=0000000000000000L; (* FMOVE.X FPx,FPy *)
 fmovemRM=1110000000000000L;
 fmovemMR=1101000000000000L;

 FirstDataReg=d7; FirstAdrReg=a3+8; FirstFReg=fp0+16;

 LibPtrBase=4; (* LibPtr steht bei Libraries in 4(A4) *)

VAR
 d0Ptr,
 cocMdPtr:ItemPtr; (* fr verzgertes LoadCC in Mode-->Gea mu auswerten! *)
 Regvalid: RegisterSet; (* a4,a5,a7,sp,fp0..fp7 NEVER used!!! *)
 (* da NilChk und RidxMd cc zerstren! *)

 Reg: ARRAY Register OF RegContents;
  (* Sicherheitshalber bis pc *)
 MoveCode:ARRAY WidType OF CARDINAL;


(*$ EntryExitCode:=FALSE *)
PROCEDURE IsByte(l{6}:LONGINT):BOOLEAN;
BEGIN
  ASSEMBLE(
	MOVEQ	#0,D0
	MOVEQ	#maxSInt,D1
	CMP.L	D1,D6
	BGT.S	false
	MOVEQ	#minSInt,D1
	CMP.L	D1,D6
	BLT.S	false
	MOVEQ	#-1,D0
 false: RTS
  END);
END IsByte;

(*$ EntryExitCode:=FALSE *)
PROCEDURE IsWord(l{6}:LONGINT):BOOLEAN;
BEGIN
  ASSEMBLE(
	MOVEQ	#0,D0
	CMPI.L	#maxInt,D6
	BGT.S	false
	CMPI.L	#minInt,D6
	BLT.S	false
	MOVEQ	#-1,D0 (* true *)
 false: RTS
  END);
END IsWord;

PROCEDURE CheckA(a:Register):Register;
VAR n:Register;
BEGIN
  IF a IN Rbusy THEN
    GetReg(n,Areg);
    IF n#a THEN PutWord(moveaL+(CARDINAL(n) MOD 8)*ls9+a) END;
    RETURN n;
  END;
  RETURN a;
END CheckA;

PROCEDURE SetConstReg(reg:Register; val:LONGINT; wide:WidType);
BEGIN
  INCL(Regvalid,reg);
  WITH Reg[reg] DO
    mode:=const;
    cVal:=val;
    wid:=wide;
  END;
END SetConstReg;

(*$ EntryExitCode:=FALSE *)
PROCEDURE Equal(a{2},b{3}:LONGINT; width{0}:WidType):BOOLEAN;
BEGIN
  ASSEMBLE( (* 0=byte 1=word 2=long *)
	SUBQ.B	#1,D0
	BEQ.S	TWord
	BMI.S	TByte
	CMP.L	D2,D3
	BRA.S	raus
 TByte:	CMP.B	D2,D3
	BRA.S	raus
 TWord:	CMP.W	D2,D3
 raus:	SEQ	D0 (* byte-weite reicht!! *)
 	RTS
 END);
END Equal;


(* sucht nur in Aregs! Niemals ndern!! *)
PROCEDURE FindLevel(l:INTEGER; VAR r:Register):INTEGER;
VAR i:Register;
BEGIN
  IF Regvalid#RegisterSet{} THEN
    FOR i:=a0+8 TO a3+8 DO
      WITH Reg[i] DO
        IF (mode=level) & (l<=lv) THEN
          r:=i;
          RETURN lv;
        END;
      END;
    END;
  END;
  RETURN -1;
END FindLevel;

(* sucht nur in Aregs! *)
PROCEDURE FindPtr(VAR x:Item; VAR n:Register):BOOLEAN;
VAR i:Register;
BEGIN (* off nicht vergleichen, indir auch nicht! *)
  IF Regvalid#RegisterSet{} THEN
   WITH x DO
    FOR i:=a0+8 TO a3+8 DO
      WITH Reg[i] DO
        IF (mode=varPtr)&(it.adr=adr)&(it.mod=mod)&(it.R=R)&(it.lev=lev)
          (* & (it.typ=typ)*) THEN
          n:=i;
          RETURN TRUE;
        END;
      END;
    END;
   END; (* with x *)
  END;
  RETURN FALSE;
END FindPtr;

PROCEDURE FindConstReg(val:LONGINT; minWide:WidType; VAR r:Register):BOOLEAN;
VAR i,maxr:Register;
BEGIN
  IF Regvalid#RegisterSet{} THEN
  IF minWide=byte THEN maxr:=d7 ELSE maxr:=a6+8 END; (* move.b Ax verboten! *)
    FOR i:=d0 TO maxr DO
      WITH Reg[i] DO
        IF (i IN Regvalid) & (mode=const) & (minWide<=wid)
            & Equal(cVal,val,minWide) THEN
          r:=i;
 (*$ IF MarkCode *)
	  PutWord(284CH); (* a4,a4 *)
 (*$ ENDIF *)
          RETURN TRUE
        END;
      END;
    END;
  END;
  RETURN FALSE;
END FindConstReg;

PROCEDURE FindLibReg(modnr:INTEGER; VAR r:Register):BOOLEAN;
VAR i:Register;
BEGIN (* off nicht vergleichen, indir auch nicht! *)
  IF Regvalid#RegisterSet{} THEN
    FOR i:=a6+8 TO a0+8 BY -1 DO
      WITH Reg[i] DO
        IF (mode=libPtr)&(mno=modnr) THEN
          r:=i;
          RETURN TRUE;
        END;
      END;
    END;
  END;
  RETURN FALSE;
END FindLibReg;

PROCEDURE LibToAreg(mnr:INTEGER; reg:Register);
VAR old:Register; ea2:CARDINAL;
BEGIN
  INCL(UsedRegs,reg);
  ea2:=(CARDINAL(reg) MOD 8)*ls9; (* +ls6;entfllt, da movea! *)
  IF FindLibReg(mnr,old) THEN
    IF reg#old THEN
      PutWord(moveaL+ea2+old);
    END;
  ELSE
    PutWord(moveaL+ea2+aoff+sb); DRel(mnr,LibPtrBase);
    INCL(UsedRegs,sb+8);
    (* Woher wei ich, welche Art VAR das ist?? Mu IMMER DRel sein! *)
  END;
  WITH Reg[reg] DO
    mode:=libPtr; mno:=mnr;
  END;
  INCL(Regvalid,reg);
END LibToAreg;

PROCEDURE LoadA6(mnr:INTEGER);
(* nur noch fr Libs! *)
VAR r:Register;
BEGIN
  LibToAreg(mnr,a6+8);
END LoadA6;

PROCEDURE NeedD0(VAR x:Item);
VAR
  y:Item;
  d:Register;
(* 3.11.91/bp y war nicht initialisiert! *)
(*$ EntryClear:=TRUE *)
BEGIN
  IF d0Ptr#NIL THEN
    IF d0Ptr^.mode=fltMd THEN
      GetFReg(d); SetfltMd(y,d,d0Ptr^.typ); FMove(d0Ptr^,y);
    ELSIF d0Ptr^.mode=DregMd THEN
      GetReg(d,Dreg); SetregMd(y,d,d0Ptr^.typ); Move(d0Ptr^,y);
    ELSE
      (*BreakPoint(ADR('7019'));*)
      Mark(7019); Mark(7700+ORD(d0Ptr^.mode));
    END;
    d0Ptr^:=y;
  ELSIF Islocked(d0) OR Islocked(d1) THEN
    (* BreakPoint(ADR('7027'));*)
    Mark(7027)
  END;
  d0Ptr:=ADR(x);
END NeedD0;
(*$ POP EntryClear *)

PROCEDURE SwapD0(VAR x,y: Item);
 VAR z: Item;
 BEGIN
  IF (y.mode=DregMd)&(y.R=d0) OR (y.mode=fltMd)&(y.FR=d0) THEN
   z:=x; x:=y; y:=z; d0Ptr:=ADR(x)
  END
 END SwapD0;

PROCEDURE FreeD0;
VAR x:Item; (* vllig egal! *)
BEGIN
  NeedD0(x);
  d0Ptr:=NIL;
END FreeD0;

PROCEDURE DiffCC(x,y:ConstValue; VAR dh,dl:LONGINT);
BEGIN
(*$ OverflowChk:=FALSE *)
 dh:=x.conSign-y.conSign;
(* Make a 32 subtraction with wraparound =>*)
 dl:=x.conLI-y.conLI;
(* And now adjust dh if there was a wraparound. *)
 IF CAST(LONGCARD,x.conLI)<CAST(LONGCARD,y.conLI) THEN DEC(dh) END;
(*$ POP OverflowChk *)
END DiffCC;

PROCEDURE AssignComp(x,y:StrPtr):BOOLEAN;
TYPE
 StrFormSet=SET OF StrForm;
VAR
 xf,yf:StrForm;
 xIsAdr,xIsPtr,yIsAdr,yIsPtr: BOOLEAN;
BEGIN
 xf:=x^.form; yf:=y^.form;
(* 22.4.89/ms
 * Vereinfachung und Verallgemeinerung der Kompatibilitt zwischen
 * ADDRESS, BPTR, POINTER und BPOINTER Typen.
 *
 * IF    (x=addrtyp) & ((y=bptrtyp) OR (yf=Pointer))
 *    OR (y=addrtyp) & ((x=bptrtyp) OR (xf=Pointer))
 *    OR (x=bptrtyp) & ((y=addrtyp) OR (yf=BPointer))
 *    OR (y=bptrtyp) & ((x=addrtyp) OR (xf=BPointer)) THEN
 *  RETURN TRUE;
 * END;
 *)
 xIsAdr:=(x=tp.addrtyp) OR (x=tp.bptrtyp);
 yIsAdr:=(y=tp.addrtyp) OR (y=tp.bptrtyp);
 xIsPtr:=xf IN StrFormSet{Pointer,BPointer};
 yIsPtr:=yf IN StrFormSet{Pointer,BPointer};
 IF    (xIsAdr & (yIsAdr OR yIsPtr))
    OR (yIsAdr & (xIsAdr OR xIsPtr)) THEN
  RETURN TRUE;
 END;
 IF xf=Range THEN x:=x^.RBaseTyp; xf:=x^.form END;
 IF yf=Range THEN y:=y^.RBaseTyp; yf:=y^.form END;
 CASE xf OF
 | Undef,ProcTyp,String,Array: RETURN FALSE
 | Enum,BPointer,Pointer,Set,Opaque,Record: RETURN x=y;
 | FFP..UReal: RETURN (FFP<=yf) & (yf<=UReal)
 | Bool,Char,UInt: RETURN xf=yf
 END;
 HALT;
END AssignComp;

PROCEDURE ConstSize(v:LONGINT; signed:BOOLEAN):INTEGER;
BEGIN
 IF signed THEN
  IF IsByte(v) THEN RETURN 1 END;
  IF IsWord(v) THEN RETURN 2 END
 ELSE
  IF CAST(LONGCARD,v)<=maxSCard THEN RETURN 1 END;
  IF CAST(LONGCARD,v)<=maxCard THEN RETURN 2 END
 END;
 RETURN 4
END ConstSize;

PROCEDURE SRTest(VAR x:Item; VAR sgn:BOOLEAN; VAR sze:INTEGER);
BEGIN
 WITH x.typ^ DO
  sze:=size;
  IF form=Range THEN
   sgn:=sign;
   x.typ:=RBaseTyp
  ELSIF form=UInt THEN
   sgn:=x.val.conSign<0;
   sze:=ConstSize(x.val.conLI,sgn)
  END
 END
END SRTest;

PROCEDURE SignedT(VAR x:Item):BOOLEAN;
(*
 * is x a signed type i.e. does it always need a signed treatment ?
 * Note:Real/LongReal excluded!
 *
 * 31.5.89/ms Hier kommt nun noch form=Pointer dazu
 *)
BEGIN
 WITH x DO
  IF mode=vconMd THEN RETURN val.conSign=-1 END;
  RETURN
   (typ^.form=Range) & typ^.sign
   OR (typ=tp.booltyp)
   OR (typ^.form=Pointer);
 END
END SignedT;

PROCEDURE UnsignedT(VAR x:Item):BOOLEAN;
(* is x a unsigned type i.e. does it always need an unsigned treatment ? *)
(* Note:Real/LongReal excluded! *)
TYPE
 FSet=SET OF StrForm;
VAR
 f:StrForm;
BEGIN
 WITH x DO
  IF mode=vconMd THEN RETURN val.conSign=0 END;
  f:=typ^.form;
  (* 8.3.90/bp Bool ist intern -1,0, also signed!! *)
  RETURN (f IN FSet{(*Bool,*)Char,Enum}) OR (f=Range) & ~typ^.sign;
 END
END UnsignedT;

PROCEDURE NumT(VAR x:Item):BOOLEAN;
 (* is x a number type *)
 (* Note:Real/LongReal excluded! *)
VAR
 f:StrForm;
BEGIN
 f:=x.typ^.form; (* let x.typ unchanged *)
 IF f=Range THEN f:=x.typ^.RBaseTyp^.form END;
 RETURN f=UInt;
END NumT;

PROCEDURE SetglbMd(VAR x:Item; fadr:LONGINT; ftyp:StrPtr);
(* setup of an item designating a global variable *)
(*wird nur bei error aufgerufen, kann also irgendwas setzen!*)
BEGIN
 WITH x DO
  IF ftyp#NIL THEN typ:=ftyp ELSE typ:=tp.undftyp END;
  adrtoload:=FALSE;
  nilToCheck:=FALSE;
  iniVars:=FALSE;
  IF GlobVarType=normVar THEN
    mode:=RindMd;
  ELSE
    mode:=FarMd;
  END;
  R:=sb+8;
  mod:=0; lev:=0;
  adr:=fadr; off:=0; indir:=FALSE;
 END (*WITH*);
END SetglbMd;

PROCEDURE SetlocMd(VAR x:Item; fadr:LONGINT; ftyp:StrPtr);
(* setup of an item which is relative to the Marker MP *)
BEGIN
 WITH x DO
  IF ftyp#NIL THEN typ:=ftyp ELSE typ:=tp.undftyp END;
  adrtoload:=FALSE;
  nilToCheck:=FALSE;
  mode:=RindMd; mod:=0; lev:=curLev;
  adr:=fadr; off:=0; indir:=FALSE;
  R:=mp+8;
 END (*WITH*);
END SetlocMd;

PROCEDURE SetregMd(VAR x:Item; freg:Register; ftyp:StrPtr);
(* setup of an item designating a (long) register. *)
BEGIN
 WITH x DO
  IF ftyp#NIL THEN typ:=ftyp ELSE typ:=tp.undftyp END;
  IF freg<=d7 THEN mode:=DregMd ELSE mode:=AregMd END;
  adrtoload:=FALSE;
  nilToCheck:=FALSE;
  mod:=0; lev:=curLev;
  adr:=0; off:=0; indir:=FALSE;
  R:=freg; wid:=long
 END;
END SetregMd;

PROCEDURE SetErrMd(VAR x:Item; ftyp:StrPtr);
BEGIN
  Release(x);
  SetglbMd(x,0,ftyp); (* keinesfalls d0 oder d1, testen! *)
END SetErrMd;

PROCEDURE SetfltMd(VAR x:Item; fR:Register; ftyp:StrPtr);
BEGIN
 WITH x DO
  typ:=ftyp; mode:=fltMd; FR:=fR;
  adrtoload:=FALSE;
  nilToCheck:=FALSE;
 END (*WITH*);
END SetfltMd;

PROCEDURE SetcocMd(VAR x:Item; fcc:Condition);
BEGIN
 Release(x);
 WITH x DO
  adrtoload:=FALSE;
  nilToCheck:=FALSE;
  typ:=tp.booltyp; mode:=cocMd; CC:=fcc;
  Tjmp:=0; Fjmp:=0;
 END;
END SetcocMd;

PROCEDURE SetstkMd(VAR x:Item; ftyp:StrPtr);
(* setup of an item on top of stack. *)
BEGIN
 WITH x DO
  adrtoload:=FALSE;
  nilToCheck:=FALSE;
  IF ftyp#NIL THEN typ:=ftyp ELSE typ:=tp.undftyp END;
  mode:=stkMd; mod:=0; lev:=curLev;
  adr:=0; off:=0; indir:=FALSE;
  R:=sp+8;
 END (*WITH*);
END SetstkMd;

PROCEDURE SetconMd(VAR x:Item; fval:LONGINT; ftyp:StrPtr);
BEGIN
 WITH x DO
  IF ftyp#NIL THEN typ:=ftyp ELSE typ:=tp.undftyp END;
  adrtoload:=FALSE;
  nilToCheck:=FALSE;
  IF typ^.form=Range THEN typ:=typ^.RBaseTyp END;
  IF NumT(x) THEN typ:=tp.uinttyp END;
  mode:=vconMd;
  val.inMem:=FALSE;
  val.conLI:=fval;
  IF val.conLI<0 THEN val.conSign:=-1 ELSE val.conSign:=0 END;
  val.conPrev:=NIL;
  size:=ConstSize(val.conLI,val.conSign#0); (*so it is set to something*)
  conOffset:=0;
 END (*WITH*);
END SetconMd;


(*$ EntryExitCode:=FALSE *)
PROCEDURE AllRegsDestroyed;
(* Alle Register sind ungltig *)
CONST rSize=SIZE(RegContents); notVal=ORD(nothing);
BEGIN
  ASSEMBLE(
	MOVE.W	#-1,lastProfOff(A4) (* M2HM Bescheid sagen! *)
	TST.L	Regvalid(A4)
	BEQ.S	raus
	CLR.L	Regvalid(A4)
	LEA	Reg+RegContents.mode(A4),A1
	MOVEQ	#15,D0
	MOVEQ	#notVal,D1
lp:	MOVE.B	D1,(A1)
	LEA	rSize(A1),A1
	DBRA	D0,lp
raus:	RTS
END);
(*
  IF Regvalid#RegisterSet{} THEN (* nicht zu oft!! *)
    FOR i:=d0 TO a6+8 DO Reg[i].mode:=nothing END;
    Regvalid:=RegisterSet{};
  END;
  hier NICHT in UsedRegs einfgen!!
*)
END AllRegsDestroyed;

(*$ EntryExitCode:=FALSE *)
PROCEDURE RegDestroyed(reg:Register);
CONST rSize=SIZE(RegContents); notVal=ORD(nothing);
BEGIN
  ASSEMBLE(
	MOVE.L	(A7)+,A0
	MOVE.B	(A7)+,D0
	MOVE.L	UsedRegs(A4),D1
	BSET	D0,D1
	MOVE.L	D1,UsedRegs(A4)
	MOVE.L	Regvalid(A4),D1
	BEQ.S	raus
	BCLR	D0,D1
	MOVE.L	D1,Regvalid(A4)
	LEA	Reg+RegContents.mode(A4),A1
	EXT.W	D0
	MULU	#rSize,D0
	MOVE.B	#notVal,0(A1,D0.L)
raus:	JMP	(A0)
END);
(*
  EXCL(Regvalid,reg);
  Reg[reg].mode:=nothing;
*)
END RegDestroyed;

PROCEDURE RegsDestroyed(reg:RegisterSet);
CONST rSize=SIZE(RegContents); notVal=ORD(nothing);
VAR i:Register;
BEGIN
  Regvalid:=Regvalid-reg;
  FOR i:=d0 TO a6+8 DO
    IF (i IN reg) THEN Reg[i].mode:=nothing END;
  END;
  UsedRegs:=UsedRegs+reg;
END RegsDestroyed;

(* nach einem BSR sind alle VAR-Pointer ungltig!
 * NICHT die VAR-Pars!
 * Also alle A4s und negative A5s
 *)
PROCEDURE PointersDestroyed(locDestr:BOOLEAN);
VAR i:Register;
BEGIN
  IF Regvalid#RegisterSet{} THEN
    FOR i:=a0+8 TO a6+8 DO
      WITH Reg[i] DO
        IF (mode=varPtr)
          &( (it.R=a4+8)  OR (locDestr & (it.R=a5+8)) ) THEN
          RegDestroyed(i)
        END;
      END;
    END;
  END;
END PointersDestroyed;

PROCEDURE AmigaDestroyed;
BEGIN
  RegsDestroyed(RegisterSet{d0,d1,a0+8,a1+8,fp0+16,fp1+16});
END AmigaDestroyed;

(*$ RangeChk:=FALSE OverflowChk:=FALSE *)
PROCEDURE MoveConstToReg(val:LONGINT; reg:Register);
(* Reg wid immer long!!! *)
VAR OldReg: Register; ea2:CARDINAL;
BEGIN
  INCL(UsedRegs,reg);
  IF (reg IN Regvalid) THEN (* ist es schon so wie es sein soll? *)
    WITH Reg[reg] DO
      IF (mode=const)&(wid=long)&(cVal=val) THEN RETURN END;
    END;
  END;
  ea2:=(CARDINAL(reg) MOD 8)*ls9;
  IF FindConstReg(val,long,OldReg) THEN
    IF OldReg#reg THEN (* reg-->reg *)
       PutWord(moveL+ea2+(reg DIV 8)*ls6+OldReg); (* geht auch bei Areg! *)
    END;
  ELSE (* Reg neu laden! *)
    IF reg<=a7 THEN (* DReg *)
      IF IsByte(val) THEN
        PutWord(moveqL+ea2+(CAST(CARDINAL,INTEGER(val)) MOD 256));
      ELSIF (val<0)&(val>=-128-8) THEN
        PutWord(moveqL+80H+ea2);
        PutWord(subqL+CARDINAL(-INTEGER(val)-128) MOD 8*ls9+reg);
      ELSIF (val>0)&(val<=127+8) THEN
        PutWord(moveqL+127+ea2);
        PutWord(addqL+CARDINAL(INTEGER(val)-127) MOD 8 *ls9+reg);
      ELSIF ~ODD(val)&(val>=-256)&(val<=254) THEN
        PutWord(moveqL+ea2+(CAST(CARDINAL,INTEGER(val) DIV 2) MOD 256));
        PutWord(addL+ea2+reg);
      ELSIF (val>0)&((val MOD 10000H)=0)&((val DIV 10000H)<=127) THEN
        PutWord(moveqL+ea2+(CAST(CARDINAL,INTEGER(val DIV 10000H)) MOD 256));
        PutWord(swapW+reg);
      ELSE (* not quick *)
        PutWord(moveL+ea2+imm);
        PutLong(val);
      END;
    ELSE (* AReg *)
      IF val=0 THEN
        PutWord(subaL+ea2+reg); (* ok, da Areg! *)
      ELSIF IsWord(val) THEN
        PutWord(moveaW+ea2+imm); PutWord(INTEGER(val));
      ELSE
        PutWord(moveaL+ea2+imm); PutLong(val);
      END;
    END;
  END;
  WITH Reg[reg] DO
    mode:=const; cVal:=val; wid:=long;
  END;
  INCL(Regvalid,reg);
END MoveConstToReg;
(*$ POP RangeChk POP OverflowChk *)

PROCEDURE MoveConstWordToDReg(val:LONGINT; reg:Register);
(* IMMER Dreg!!!! *)
(* Reg wid immer word oder long!!! *)
VAR OldReg: Register; ea2:CARDINAL;
BEGIN
  INCL(UsedRegs,reg);
  ea2:=reg*ls9;
  Reg[reg].wid:=word; (* bei quick:long! *)
  IF FindConstReg(val,word,OldReg) THEN
    IF OldReg#reg THEN (* reg-->reg *)
       PutWord(moveW+ea2+OldReg); (* geht auch bei Areg! *)
    END;
  ELSE (* Reg neu laden! *)
    (*$ RangeChk:=FALSE OverflowChk:=FALSE *)
    PutWord(moveW+ea2+imm);
    PutWord(INTEGER(val));
    (*$ POP RangeChk POP OverflowChk *)
  END;
  WITH Reg[reg] DO
    mode:=const; cVal:=val; wid:=word
  END;
  INCL(Regvalid,reg);
END MoveConstWordToDReg;


PROCEDURE SetbusyReg(r:Register);
BEGIN
 IF r IN Rpool THEN INCL(Rbusy,r) END;
 INCL(UsedRegs,r);
END SetbusyReg;

PROCEDURE SaveRegs(VAR save:RegisterSet; mask:RegisterSet);
(* save the busy registers and return the list of the saved registers in *)
(* 'save'. *)
(* Note:the saved registers are NOT released and remain busy ! *)
(*       SP is never saved nor restored ! *)
VAR
 r,lr:Register;
 n:INTEGER; regset:BITSET;
 regs:INTEGER;
BEGIN
 regset:={}; n:=0; save:=RegisterSet{};
 FOR r:=d0 TO sp+8-1 DO
  IF (r IN mask) & ((r IN Rbusy)OR(r IN Rlock)) THEN
   INC(n); lr:=r;
   INCL(regset,15-r); INCL(save,r); (* invertiert! *)
  END;
 END;
(*
 REPEAT (* from SP-1 downto D0 *)
  DEC(r); INC(x);
  IF (r IN mask) & ((r IN Rbusy)OR(r IN Rlock)) THEN
   INC(n); lr:=r;
   INCL(reglist,x); INCL(save,r);
  END;
 UNTIL r=d0; (* =d2; 3.8.90/bp SaveRegs wird SAUBER aufgerufen! *)
*)
(*
 IF (d0 IN mask) & (d0Ptr#NIL) THEN
  save:=save+RegisterSet{d0,d1};
  DEC(reglist,16384);
  INC(n,2);
  (* lr irrelevant, because n is not 1 *)
 END;
*)
 IF regset#{} THEN
  IF n=1 THEN PutWord(moveL+sp*ls9+adec*ls3+lr)
  ELSE PutWord(movemmL+adec+sp); PutWord(CAST(WORD,regset)) END;
 END;
 (* x x x x x x x pc  7 6 5 4 3 3 2 1 0  7 6 5 4 3 2 1 0  7 6 5 4 3 2 1 0 *)
 IF Option[m68881] THEN
   regset:=BITSET{};
   FOR r:=fp0+16 TO fp7+16 DO
     IF (r IN mask)&((r IN Rbusy) OR (r IN Rlock)) THEN
       INCL(regset,r-16); (* richtigrum, aber verschoben *)
       INCL(save,r);
     END;
   END;
   IF regset#BITSET{} THEN
     PutWord(FWord+adec+sp);
     PutWord(fmovemRM+CAST(CARDINAL,regset));
   END;
 END;
END SaveRegs;

(* ACHTUNG: Da Iea IMMER mit ls6 mult. wird, mach ich es gleich hier!!!/bp *)
(*$ EntryExitCode:=FALSE *)
PROCEDURE Iea6(fea:CARDINAL):CARDINAL;
(* invert the 'mode/reg' effective address to 'reg/mode' representation. *)
BEGIN
 ASSEMBLE( (* 00000000 00aaabbb --> 0000bbba aa000000 *)
	MOVE.L	(A7)+,A0
	MOVE.W	(A7)+,D0
	MOVE.W	D0,D1
	LSR.W	#3,D0
	ANDI.W	#7,D1
	LSL.W	#3,D1
	OR.W	D1,D0
	LSL.W	#6,D0
	JMP	(A0)
 END);
 (* RETURN (fea MOD 8)*8+(fea DIV 8) * ls6 *)
END Iea6;

PROCEDURE RestoreRegs(save:RegisterSet);
(* restore the registers given by 'save'. *)
VAR
 r,lr:Register;
 n:INTEGER;
 x,reglist:CARDINAL;
BEGIN
 x:=32768; reglist:=0; r:=sp+8; n:=0;
 REPEAT (* from SP-1 downto D0 *)
  DEC(r); x:=x DIV 2;
  IF r IN save THEN
   INC(n); lr:=r;
   INC(reglist,x);
  END;
 UNTIL r=d0;
 IF reglist#0 THEN
  IF n=1 THEN PutWord(moveL+Iea6(lr)+ainc+sp)
  ELSE PutWord(movemL+ainc+sp); PutWord(reglist) END;
 END;
 ASSEMBLE(
	MOVE.B	save+1(A5),D0
	BEQ.S	noFRestore
	MOVEQ	#7,D1	(* liste umdrehen *)
	MOVEQ	#0,D7
Flp:	ROXR.B	#1,D0
	ROXL.B	#1,D7
	DBRA	D1,Flp
	ORI.L	#{FWord+ainc+sp}*256*256+%1101000000000000,D7
	BSR	PutLong
noFRestore:
 END);
 RegsDestroyed(save);
END RestoreRegs;

PROCEDURE Islocked(r:Register):BOOLEAN;
BEGIN
 RETURN (r IN Rlock);
END Islocked;

PROCEDURE IsBusy(r:Register):BOOLEAN;
BEGIN
 RETURN (r IN Rbusy);
END IsBusy;

PROCEDURE ReleaseReg(r:Register);
BEGIN
 IF ~(r IN Rlock) THEN EXCL(Rbusy,r) END;
 IF r=d0 THEN d0Ptr:=NIL; END;
END ReleaseReg;

PROCEDURE LockReg(r:Register);
BEGIN
  INCL(Rlock,r);
END LockReg;

PROCEDURE UnlockReg(r:Register);
BEGIN
  EXCL(Rlock,r);
END UnlockReg;

PROCEDURE Release(VAR x:Item);
BEGIN
 WITH x DO
  IF mode IN ItSet{RindMd,RidxMd,AregMd,DregMd} THEN
   IF R IN RegisterSet{d0..a3+8} THEN ReleaseReg(R) END;
  ELSIF (mode=fltMd) THEN
   (* temporary solution for SANE *)
   IF FR IN RegisterSet{d0..d7} THEN ReleaseReg(FR); ReleaseReg(FR+1)
   ELSE ReleaseReg(FR) (* 68881! *)
   END;
  END;
  IF mode=RidxMd THEN ReleaseReg(RX) END;
 END (*WITH*);
END Release;


PROCEDURE GetReg(VAR r:Register; qual:RegType);
(* 10.3.90/bp
 * Es ist nicht einzusehen, da durch diese Allocation FltRegister blockiert
 * werden! Neue Reihenfolge: d6,5,4,3,2,7 Aber zirkulr!!
 *)
VAR
 hr:Register; i,cnt:INTEGER;
BEGIN
 IF qual=Areg THEN hr:=FirstAdrReg; cnt:=4;
 ELSIF qual=Dreg THEN hr:=FirstDataReg; cnt:=6;
 ELSE hr:=FirstFReg; cnt:=8
 END;
 FOR i:=1 TO cnt DO (* 1. Versuch mglichst kein bekanntes zerstren *)
   IF ~(hr IN Rbusy) & ~(hr IN Regvalid) THEN r:=hr; SetbusyReg(hr);
       RETURN
   END;
   IF hr<fp0+16 THEN DEC(hr) ELSE INC(hr) END;
 END;
 IF qual=Areg THEN hr:=FirstAdrReg;
 ELSIF qual=Dreg THEN hr:=FirstDataReg;
 ELSE hr:=FirstFReg;
 END;
 FOR i:=1 TO cnt DO
   IF ~(hr IN Rbusy) THEN r:=hr; SetbusyReg(hr);
     RETURN
   END;
   IF hr<fp0+16 THEN DEC(hr) ELSE INC(hr) END;
 END;
 Mark(7002); r:=hr;  (* register overflow *)
 ReleaseReg(hr); (* avoid endless loop *)
END GetReg;

PROCEDURE GetFReg(VAR r:Register);
(* reserve a pair of adjacent D-Registers. *)
VAR
 hr:Register;
BEGIN (* (D6,D7) -> (D4,D5) -> (D2,D3) *)
 IF Option[m68881] THEN
   FOR hr:=FirstFReg TO fp7+16 DO
     IF ~(hr IN Rbusy) THEN r:=hr; SetbusyReg(hr); RETURN END;
   END;
 ELSE
   FOR hr:=d6 TO d2 BY -2 DO
     IF ~(hr IN Rbusy) & ~((hr+1) IN Rbusy)
        & ~(hr IN Regvalid) & ~((hr+1) IN Regvalid) THEN
       r:=hr; SetbusyReg(hr); SetbusyReg(hr+1); RETURN
     END;
   END;
   FOR hr:=d6 TO d2 BY -2 DO
     IF ~(hr IN Rbusy) & ~((hr+1) IN Rbusy) THEN
       r:=hr; SetbusyReg(hr); SetbusyReg(hr+1); RETURN
     END;
   END;
 END;
 Mark(7003); r:=d2; (* D-Register overflow *)
 ReleaseReg(d2); ReleaseReg(d3); (* avoid endless loop *)
END GetFReg;


PROCEDURE GetConstReg(val:LONGINT; VAR reg:Register; VAR new:BOOLEAN);
BEGIN (* Mu IMMER Dreg!!!! *)
  IF FindConstReg(val,long,reg)&(reg<=d7) THEN
    new:=FALSE
  ELSE
    GetReg(reg,Dreg);
    MoveConstToReg(val,reg);
    new:=TRUE;
  END;
END GetConstReg;


PROCEDURE InitM2XM;
BEGIN
 trickAidr:=FALSE;
 (* 10.3.90/bp Init fr GetReg zirkulr *)
 Regvalid:=RegisterSet{d0..pc};
 AllRegsDestroyed;
 Rpool:=RegisterSet{d2..d7,a0+8..a3+8,fp0+16..fp7+16};
 Rlock:=RegisterSet{sb+8,mp+8,sp+8,pc}; (* A6 not locked *)
 Rbusy:=Rlock;
 d0Ptr:=NIL;
 cocMdPtr:=NIL;
END InitM2XM;

PROCEDURE CheckRegs;
BEGIN
 IF Rbusy#Rlock THEN
   Mark(7004);
   Rbusy:=Rlock;
 END;
 IF d0Ptr#NIL THEN Mark(7021); d0Ptr:=NIL; END;
END CheckRegs;

PROCEDURE Isz(VAR x:Item; VAR fsz:WidType);
(* instruction size for item x:byte/word/long. *)
(* Note:callable only for simple types ! *)
VAR
 s:LONGINT;
BEGIN
 s:=x.typ^.size;
 IF x.mode=vconMd THEN
(* IF x.typ#tp.uinttyp THEN BreakPoint(ADR('isz fuer const#uint')) END;*)
  IF (minSInt<=x.val.conLI) & (x.val.conLI<=maxSCard) THEN fsz:=byte;
  ELSIF (minInt<=x.val.conLI) & (x.val.conLI<=maxCard) THEN fsz:=word;
  ELSE fsz:=long;
  END;
  x.size:=SHIFT(1,fsz); (* Sideeffect !! wrg kotz *)
 ELSE
  IF s=1 THEN fsz:=byte
  ELSIF s=2 THEN fsz:=word
  ELSIF s=4 THEN fsz:=long
  ELSE fsz:=long; Mark(7001);
  END;
 END;
END Isz;

PROCEDURE StackTop(i:LONGINT);
(* increment/decrement stack pointer SP:*)
(* i>0:increment SP,reset stack  *)
(* i<0:decrement SP,reserve stack *)
VAR
 neg:BOOLEAN;
 c:INTEGER;
BEGIN
 IF i#0 THEN
  neg:=(i<0);
  IF ODD(i) THEN
   IF neg THEN DEC(i) ELSE INC(i) END;
  END;
  IF (-8<=i) & (i<=8) THEN
   c:=(ABS(i) MOD 8)*ls9;
   IF neg THEN PutWord(subqL+adir+sp+c)
   ELSE PutWord(addqL+adir+sp+c)
   END;
  ELSIF IsWord(i) THEN
   (*$ RangeChk:=FALSE *)
   PutWord(lea+sp*ls9+aoff+sp);
   PutWord(INTEGER(i));
   (*$ POP RangeChk *)
  ELSE
   PutWord(addaL+sp*ls9+imm); PutLong(i);
  END;
 END (*i#0*);
END StackTop;

PROCEDURE Scc(cond:Condition; Dn:Register);
(* set D-Register according to condition. *)
BEGIN
 PutWord(st+CARDINAL(cond)*ls8+ddir+Dn);
 RegDestroyed(Dn);
END Scc;

PROCEDURE InvertCC(cond:Condition):Condition;
(* generate the 'inverted' condition. *)
BEGIN
 IF ODD(ORD(cond)) THEN DEC(cond) ELSE INC(cond) END;
 RETURN cond
END InvertCC;

PROCEDURE Jf(cond:Condition; VAR l:INTEGER);
(* jump forward, build chain. *)
BEGIN
 FCondBranch(cond,l);
(*
 (* MC68000 does NOT have a "Branch on Never True" ! *)
 IF cond#F THEN
  PutWord(bra+CARDINAL(cond)*ls8); PutWord(l);
  l:=ip-2; (* location of word-displacement added to link *)
 END;
*)
 (* 10.3.90/bp *)
 IF cond=T THEN AllRegsDestroyed END;
END Jf;

PROCEDURE Jb(cond:Condition; l:INTEGER);
(* jump backward, no chain. *)
BEGIN
 BCondBranch(cond,l);
(*
 d:=l-ip-2; (* Compute displacement *)
 IF (d>=-128) & (cond#F) THEN (* short branch possible *)
  PutWord(bra+CARDINAL(cond)*ls8+CAST(CARDINAL,d) MOD 256);
 ELSE
  Jf(cond,d); (* let Jf handle it *)
 END;
*)
END Jb;

PROCEDURE LoadCC(VAR x:Item);
(* convert from 'cocMd' to 'DregMd' while generating conditional code. *)
VAR
 Dn:Register;
BEGIN
 WITH x DO
  GetReg(Dn,Dreg);
  RegDestroyed(Dn);
  IF (Tjmp=0) & (Fjmp=0) THEN
   Scc(InvertCC(CC),Dn);
   SetregMd(x,Dn,tp.booltyp); (* transform 'cocMd' to 'DregMd' *)
   wid:=byte;
  ELSE
   Jf(CC,Fjmp);
   FixLink(Tjmp); (* True jumps come here *)
   PutWord(moveqL+Dn*ls9+255); (* -1 *)
   PutWord(bra+2);
   FixLink(Fjmp); (* False jumps come here *)
   PutWord(moveqL+Dn*ls9+0);
   SetregMd(x,Dn,tp.booltyp); (* transform 'cocMd' to 'DregMd' *)
   wid:=long;
  END;
 END (*WITH*);
END LoadCC;

PROCEDURE downlevel(VAR x:Item);
(* for level difference>=1. *)
CONST
 offSL=8; (* offset of Static Link *)
VAR
 Rn,An:Register;
 n:INTEGER;
BEGIN			 (* 05.07.92/bp Eben doch! Bei Zuweisung! *)
 n:=FindLevel(x.lev,Rn); (* levelreg kann niemals busy sein!! *)
 IF n<0 THEN (* nicht da! *)
   GetReg(Rn,Areg); (* Rn IN { 8..15 } *)
   An:=Rn MOD 8;
   PutWord(moveaL+An*ls9+aoff+mp); (* MOVEA.L offSL(MP),An *) (* one level *)
   PutWord(offSL);
   n:=curLev-x.lev;
 ELSE
   DEC(n,x.lev-1);
   (* 05.07.92/bp Wenn Busy (und n>1 ??): neues holen *)
   IF IsBusy(Rn) & (n>1) THEN
     GetReg(An,Areg);
     PutWord(moveaL+(An-8)*ls9+aoff+(Rn-8)); (* MOVEA.L offSL(An),An *)
     PutWord(offSL);
     DEC(n);
     Rn:=An;
   END;
   SetbusyReg(Rn);
   An:=Rn MOD 8;
(*$ IF MarkCode *)
   PutWord(2048H); (* move.l a0,a0 *)
(*$ ENDIF *)

 END;
 WHILE n>1 DO (* foreach additional level *)
  DEC(n);
  PutWord(moveaL+An*ls9+aoff+An); (* MOVEA.L offSL(An),An *)
  PutWord(offSL);
 END;
 ReleaseReg(x.R);
 INCL(Regvalid,Rn);
 WITH Reg[Rn] DO mode:=level; lv:=x.lev END;
 (*ReleaseReg(Rn); GetReg(x.R,Areg);*) (* damit er dies reg mglichst behlt! *)
 x.R:=Rn;
END downlevel;

PROCEDURE Ext(VAR x:Item);
(* effective address extension of x. *)
VAR
 ext:INTEGER;
BEGIN
 WITH x DO
  CASE mode OF
  | absMd:
   (* 28.2.90/bp neu absW *)
   (*$ RangeChk:=FALSE OverflowChk:=FALSE *)
   IF IsWord(adr) THEN PutWord(INTEGER(adr)) ELSE PutLong(adr) END;
   (*$ POP RangeChk POP OverflowChk *)
  | RindMd:
   IF R=pc THEN Mark(7028); (* darf nicht mehr! *)
   ELSIF R=sb+8 THEN
     IF mod>=0 THEN
       IF iniVars THEN
         DIniRel(mod,adr);
       ELSE
         DRel(mod,adr)
       END;
     ELSE
       NewRef(0,ip,vname,noDHead,word); PutWord(INTEGER(adr));
     END;
   ELSIF adr#0 THEN PutWord(INTEGER(adr))
   END;
  | FarMd:
   IF iniVars THEN
     AbsIniData(mod,adr);
   ELSE
     AbsData(mod,adr);
   END;
  | ExtMd: NewRef(0,ip,vname,noHead,long); PutLong(adr);
  | RidxMd:
   IF wid=word THEN ext:=RX*ls12;
   ELSE ext:=RX*ls12+ls11;
   END;
   PutWord(ext+INTEGER(CARDINAL(adr) MOD 256));
  | memconMd:
   PutInBuffer(val);
   ConstRel(val.modNr,val.buffOffset+conOffset);
  | vconMd:
   (* 3.3.90/bp bei Byte: High-Byte auf 0 setzen! Motorola-Vorschrift!! *)
   (*$ RangeChk:=FALSE OverflowChk:=FALSE *)
   IF (size=1) THEN
     IF x.typ=tp.booltyp THEN ext:=-INTEGER(val.conLI) ELSE ext:=INTEGER(val.conLI) END;
     PutWord(CAST(CARDINAL,ext) MOD 256);
   ELSIF size=2 THEN
     PutWord(INTEGER(val.conLI));
   ELSIF size=4 THEN
     PutLong(val.conLI)
   ELSIF size=8 THEN
     PutLong(val.conSign); PutLong(val.conLI); (* unmglich!!/bp *)
   END;
   (*$ POP RangeChk POP OverflowChk *)
  | stkMd:(* no extension *)
  | AregMd,DregMd:(* no extension *)
  | procMd:
   IF (proc#NIL) THEN
     (* 04.07.92/bp externe Prozeduren ; "ident" *)
     IF proc^.pd^.external THEN
       AbsCode(0,CAST(Ident,proc^.pd^.adr),noHead);
     ELSIF proc^.pmod=0 THEN
       PCRel(proc);
     ELSE (* external procedure *)
       AbsCode(proc^.pmod,proc^.name,exported);
     END;
   ELSE
     Mark(7029);
   END;
  | modMd:
   IF (module^.mode=library) THEN
     DRel(module^.compmod,LibPtrBase); (* dos.library oder _DOSBase *)
   END;
  | prgMd: PCRef(ip,where-2,ip,2,word,-1); PutWord(where-ip);
  | typMd,codMd:(* no extension *)
  | cocMd:(* no extension *)
  | fltMd:
  |
  ELSE
   Mark(7022); Mark(7600+ORD(mode));
  END (*CASE*);
 END (*WITH*);
END Ext;

PROCEDURE NilCheck(VAR x:Item);
VAR Dn:Register;
BEGIN
  IF x.nilToCheck & Option[nilchk]
    (*& ((x.mode=RindMd) OR (x.mode=RidxMd)) & ~x.indir
    & (x.R<(a4+8)) & ~(x.R IN Regvalid) & ~(x.R IN Rlock)*) THEN
    IF cocMdPtr#NIL THEN LoadCC(cocMdPtr^); cocMdPtr:=NIL END;
    GetReg(Dn,Dreg);
    PutWord(moveL+Dn*ls9+x.R);
    Trap(13,EQ);
    ReleaseReg(Dn); RegDestroyed(Dn);
  END;
  x.nilToCheck:=FALSE;
END NilCheck;

PROCEDURE ReduceIndir(VAR x:Item; ea:CARDINAL);
(* Note:A-Registers internally numbered from 8..15! *)
VAR
 dst:Register;
BEGIN
 WITH x DO
  dst:=R;
  CASE mode OF
  | absMd,FarMd,ExtMd:
   GetReg(dst,Areg); PutWord(moveaL+(CARDINAL(dst) MOD 8)*ls9+ea); Ext(x);
  | RindMd,RidxMd:
   IF Islocked(R) THEN GetReg(dst,Areg) END;
   IF R=pc THEN
     Mark(7030) (* darf nicht mehr vorkommen! *)
   ELSE
     ReleaseReg(dst); GetReg(dst,Areg); (* gute Regs halten! *)
     PutWord(moveaL+(CARDINAL(dst) MOD 8)*ls9+ea); Ext(x);
     RegDestroyed(dst);
   END;
   IF mode=RidxMd THEN ReleaseReg(RX) END;
  ELSE
   Mark(7023); Mark(7500+ORD(mode));
  END (*CASE*);
  (* transform all modes to 'RindMd' *)
  mode:=RindMd; R:=dst; (* R IN { 8..15 } *)
  indir:=FALSE; adr:=off; off:=0;
 END (*WITH*);
 NilCheck(x);
END ReduceIndir;

PROCEDURE GeaP(VAR x:Item; VAR fea:CARDINAL);
(* effective address of an item designating a procedure. *)
BEGIN
 WITH x DO
  (* 05.09.92/bp externe auch far! *)
  IF (proc#NIL) & (proc^.pmod=0) & ~proc^.pd^.external THEN (* local procedure *)
   fea:=prel; (* braucht mehr Info! rel oder ref, falls forward! *)
  ELSE               (* external procedure *)
   fea:=absL; (* abermitreloc!!*)
  END;
 END (*WITH*);
 (* procMd bleibt stehen! *)
END GeaP;

PROCEDURE GeaM(VAR x:Item; VAR fea:CARDINAL);
VAR r:Register;
BEGIN
 IF x.module^.mode#library THEN Mark(7031) END;
 GetReg(r,Areg);
 LibToAreg(x.module^.compmod,r);
 SetregMd(x,r,x.typ);
 fea:=r; (* =adir + r mod 8 *)
END GeaM;

(* neuer Para: destr, wenn der Zeiger Ziel einer Operation *)
PROCEDURE Gea(VAR x:Item; VAR fea:CARDINAL; destr:BOOLEAN);
(* give effective address of x.
   x.RX must be a DATA register !! *)
VAR
 oldx:Item;
 ea:CARDINAL; An:Register; found,holdit:BOOLEAN;
BEGIN
IF x.adrtoload THEN Mark(7032) END;
 holdit:=FALSE; found:=FALSE;
  (* Genaugenommen mte er testen, ob er EINE Stufe niedrigere indir hat! *)
 IF ~Option[volatile] (* +u: weder suchen noch merken! *)
    &(x.mode=RindMd)&(x.R IN RegisterSet{sb+adir,mp+adir})&IsWord(x.off) THEN
  IF FindPtr(x,An) THEN
    IF (x.indir) THEN
      found:=TRUE; (* hier macht nur VarIndex rger, deshalb CheckA! *)
(*  BreakPoint(ADR('nop')); *)
(*$ IF MarkCode *)
      PutWord(nop);
(*$ ENDIF *)
      WITH x DO
	R:=CheckA(An);
	adr:=off; off:=0; (* ist IsWord!! *)
	indir:=FALSE;
	IF (adr=0)&(mod>=0) THEN
	  ea:=aidr+(CARDINAL(R) MOD 8)
	ELSE
	  ea:=aoff+(CARDINAL(R) MOD 8)
	END;
      END;
    ELSIF destr THEN
      RegDestroyed(An);
 (*$ IF MarkCode *)
      PutWord(2A4DH);(* move.l a5,a5 *)
 (*$ ENDIF *)
    ELSIF x.off=0 THEN (* das wre ja traumhafte Regvar!! *)
      found:=TRUE;
(*  BreakPoint(ADR('direct use'));*)
      WITH x DO
        R:=CheckA(An); adr:=0; mode:=AregMd;
        ea:=R (* =adir+AnMOD8 *)
      END;
 (*$ IF MarkCode *) PutWord(2249H); (*$ ENDIF *) (* move.l a1,a1 *)
    END;
  END;
  IF (x.indir) THEN oldx:=x; holdit:=TRUE END;
 END;
IF ~found THEN
 WITH x DO
  IF mode IN ItSet{RindMd,RidxMd} THEN
    IF (R=mp+8)OR(R=sb+8) THEN INCL(UsedRegs,R)
    ELSIF R <= d7 THEN
      ReleaseReg(R); GetReg(An,Areg); PutWord(moveaL+CARDINAL(An) MOD 8*ls9+R);
      R:=An; ea:=CARDINAL(An) MOD 8; RegDestroyed(R);
    END;
  END;
  LOOP
   ea:=CARDINAL(R) MOD 8;
   CASE mode OF
   | absMd: (* 28.2.90/bp *)
	IF IsWord(adr) THEN ea:=absW
	ELSE ea:=absL END;
   | FarMd,ExtMd:
        ea:=absL;
   | RindMd:
    IF (R=mp+8) & (lev#curLev) THEN downlevel(x); ea:=CARDINAL(R) MOD 8 END;
    IF R=pc THEN ea:=prel; Mark(7033); (* darf nicht! *)
    ELSIF (adr=0)&(mod>=0)&~((R=sb+8)&iniVars) THEN
      IF trickAidr&destr THEN (* nur bei Ziel wirksam! *)
        INC(ea,ainc);
        trickAidr:=FALSE (* bler Trick fr SYSTEM.TAG 26.12.90/bp *)
      ELSE
        INC(ea,aidr) (* 30.7.90/bp NICHT aidr bei ext!*)
      END;
    ELSIF IsWord(adr) THEN INC(ea,aoff)
    ELSE
     IF Islocked(R) THEN GetReg(R,Areg);PutWord(moveaL+(CARDINAL(R) MOD 8)*ls9+adir+ea) END;
     ea:=CARDINAL(R) MOD 8;
     PutWord(addaL+ea*ls9+imm); PutLong(adr);
     adr:=0; INC(ea,aidr);
     RegDestroyed(R);
    END;
   | RidxMd:
    IF IsByte(adr) THEN INC(ea,aidx)
    ELSIF IsWord(adr) THEN
     ReleaseReg(R); GetReg(R,Areg);
 (*IF Islocked(R) THEN GetReg(R,Areg) END;*)
     PutWord(lea+(CARDINAL(R) MOD 8)*ls9+aidx+ea);
     IF wid=word THEN PutWord(RX*ls12) ELSE PutWord(RX*ls12+ls11) END;
     ReleaseReg(RX);
     mode:=RindMd; ea:=aoff+(CARDINAL(R) MOD 8);  (* transform to 'RindMd' *)
     RegDestroyed(R);
    ELSE
     (* Dies zerstrt Condition Codes! *)
     IF cocMdPtr#NIL THEN LoadCC(cocMdPtr^); cocMdPtr:=NIL END;
     IF wid=word THEN PutWord(andiL+RX); PutLong(0FFFFH); wid:=long END;
     PutWord(addiL+RX); PutLong(adr);
     adr:=0; INC(ea,aidx);
     RegDestroyed(RX);
    END
   | vconMd: ea:=imm;
   | memconMd:
    PutInBuffer(val);
    IF val.modNr=0 THEN ea:=prel ELSE ea:=absL END;
   | stkMd: ea:=ainc+sp (* gives (SP)+ *)
   | AregMd: INC(ea,adir);
   | DregMd: INC(ea,ddir)
   | prgMd: ea:=prel
   | typMd,codMd: Mark(7005); ea:=ddir+d0   (* so it's set to something *)
   | procMd,cocMd,fltMd: Mark(7006); ea:=ddir+d0
   ELSE
    Mark(7024); Mark(7400+ORD(mode))
   END;
   IF (mode>=vconMd) OR ~indir THEN EXIT END;
   ReduceIndir(x,ea);
  END (* LOOP *)
 END; (* WITH *)
ELSE
 x.nilToCheck:=FALSE;
 SetbusyReg(An);
END; (* ~found *)
   (* Assertion: 'indir'=FALSE <==> 'off'=0, 'adr' is INETGER *)
 fea:=ea; (* resulting effective address *)
 IF holdit&(x.mode IN ItSet{RindMd,RidxMd,AregMd}) THEN
   INCL(Regvalid,x.R);
   WITH Reg[x.R] DO mode:=varPtr; it:=oldx END;
 END;
 (*
 IF x.nilToCheck THEN BreakPoint(ADR('Gea:niltocheck, No Error, but report it!!')) END;
 *)
END Gea;

PROCEDURE LoadAdrA(VAR x:Item; wishReg:BOOLEAN; Aw:Register);
(* ADR(x) -> pointer/address-register. *)
VAR
 oldTyp:StrPtr;
 ea:CARDINAL;
 am:INTEGER;
 An:Register;
 newA,loaded:BOOLEAN;
BEGIN                 (* !!!!! NoImp modules can be loaded !!!! *)
(*
 * 29.10.89/ms/cn
 *  Adresse von Library Prozeduren sind nun auch gltig.
 *)
 WITH x DO
  oldTyp:=typ;
  adrtoload:=FALSE;
  IF mode IN ItSet{stkMd,AregMd,DregMd,cocMd,typMd,codMd,fltMd,vconMd} THEN
   Mark(7007); (* no effective address possible *)
   Release(x); SetregMd(x,a0+8,tp.undftyp); oldTyp:=tp.undftyp;
  END;
  IF mode=procMd THEN GeaP(x,ea);
  ELSIF mode=modMd THEN GeaM(x,ea);
  ELSE Gea(x,ea,~indir) END;
  am:=(ea DIV 8)*8;
  loaded:=FALSE;
  newA:=~(mode IN ItSet{RindMd,RidxMd,AregMd}) OR Islocked(R) (*OR wishReg*);
  IF newA THEN
   IF wishReg (* & ~(Aw IN Rbusy) & ~(Aw IN Rlock)*) THEN
     An:=Aw; SetbusyReg(An);
 (*$ IF MarkCode *)  PutWord(2C4EH);  (*$ ENDIF *) (* a6,a6 *)
   ELSE
     GetReg(An,Areg)
   END;
  ELSE
   An:=R;
   IF (am=adir) OR (am=aidr) THEN loaded:=TRUE END;
  END;
(*BreakPoint(ADR("vor lea"));*)
  IF ~loaded THEN
   PutWord(lea+(CARDINAL(An) MOD 8)*ls9+ea);
   Ext(x);
   RegDestroyed(An); (*HierInhaltSetzen/bp!!*)
  END;
  IF mode=RidxMd THEN ReleaseReg(RX) END;
  (* resulting mode is 'AregMd'. *)
  SetregMd(x,An,oldTyp);
 END (*WITH*);
END LoadAdrA;

PROCEDURE LoadAdr(VAR x:Item);
BEGIN
  LoadAdrA(x,FALSE,d0); (* d0 hier dummy *)
END LoadAdr;

PROCEDURE LoadP(VAR x:Item);
(* load simple type or pointer to a pointer/address-register. *)
VAR
 y:Item;
 An:Register; ca:CARDINAL;
BEGIN
  WITH x DO
      IF (mode IN ItSet{RindMd,RidxMd}) & ~Islocked(R) THEN
        SetregMd(y,R,typ);
        Move(x,y); (* Move mu RegInhalt setzen??! *)
        SetbusyReg(R); (* do NOT release register R *)
        IF mode=RidxMd THEN ReleaseReg(RX) END;
        x:=y;
      ELSIF (mode<AregMd) OR (mode=DregMd) THEN
        GetReg(An,Areg);
        SetregMd(y,An,typ);
        Move(x,y);
        Release(x);
        x:=y;
      ELSIF (mode#AregMd) THEN
        Mark(7011); Release(x);
        SetregMd(x,a0+8,typ);
      END;
      IF (typ^.form=BPointer) OR (typ=tp.bptrtyp) THEN
      (* Force a LONGCARD Multiplication with 4 *)
        ca:=addaL+(CARDINAL(R) MOD 8)*ls9+R;
        PutWord(ca);
        PutWord(ca);
        RegDestroyed(R); (* hier!!! Dasweglassen!! *)
(*
 * 4.2.89/ms
 * ADDA never changes the condition codes. No overflow check possible!
 *)
      END;
  END (*WITH*);
  x.nilToCheck:=TRUE;
  NilCheck(x);
END LoadP;

PROCEDURE LoadX(VAR x:Item; req:WidType; willBeDestroyed:BOOLEAN);
(* mu Registerfeld auch behandeln! *)
(* load simple type x to a D-Register and  *)
(* sign extend it to the width given by req. *)
VAR
 y:Item;
 Dn:Register;
 sz:WidType;
 cload,signar:BOOLEAN;
 lv:LONGINT;

 PROCEDURE NewLoadX(VAR old,new:Item);
 BEGIN
  GetReg(Dn,Dreg);
  SetregMd(new,Dn,old.typ);
  IF ~signar & (sz<req) & (sz<long) THEN
   PutWord(moveqL+Dn*ls9);
   SetConstReg(Dn,0,long);
  END;
  Move(old,new);
  Release(old);
  IF signar & (sz<req) THEN
   (* 18.6.90/bp *)
   IF Option[m68020]&(sz=byte)&(req=long) THEN
     PutWord(extL+ls8+Dn) (* extB.L Dn *)
   ELSE
     IF sz=byte THEN PutWord(extW+Dn) END;
     IF req=long THEN PutWord(extL+Dn) END;
   END;
  END;
  new.wid:=req;
  WITH Reg[Dn] DO
    IF mode=const THEN wid:=new.wid END;
  END;
 END NewLoadX;

BEGIN (* LoadX *)
(* Debug.Item("LoadX",x);*)
 IF x.mode=cocMd THEN LoadCC(x) END;
 Isz(x,sz);
 cload:=x.mode=vconMd;
 signar:=~UnsignedT(x);
 WITH x DO
  IF cload THEN
   (* constants always loaded to long width. NO!!/bp *)
   lv:=x.val.conLI; IF x.typ=tp.booltyp THEN lv:=-lv; END;
   GetReg(Dn,Dreg);
   SetregMd(y,Dn,typ);
   IF (req=long) OR IsByte(lv) THEN
     MoveConstToReg(lv,Dn);
   ELSE
     MoveConstWordToDReg(lv,Dn);
   END;
   y.wid:=req; (* long satisfies req anyway *)
   x:=y;
  (* 9.3.90/bp darf nicht locked sein, wird sonst evtl. zerstrt,
   * z.B bei CASE und mul/div
   *)
  ELSIF (mode=DregMd) & ~(Islocked(R) & willBeDestroyed) THEN
   (* x is already in a FREE D-Register. *)
   IF wid<req THEN
    IF req=word THEN
     IF sz=byte THEN
      IF signar THEN PutWord(extW+R)
      ELSE (* unsigned types *)
       PutWord(andiW+R);
       PutWord(377B);
      END;
     END;
    ELSIF req=long THEN
     IF signar THEN
      IF sz<long THEN
       IF Option[m68020]&(sz=byte) THEN
         PutWord(extL+ls8+R);
       ELSE
         IF sz=byte THEN PutWord(extW+R) END;
         PutWord(extL+R);
       END;
      END;
     ELSE (* unsigned types *)
      IF sz<long THEN
       PutWord(andiL+R);
       IF sz=byte THEN PutLong(255) ELSE PutLong(65535) END;
      END;
     END;
    END;
    (* 10.3.90/bp Ich lasse mir wid keinesfalls verkleinern!! *)
    wid:=req;
    RegDestroyed(R);
   END (*wid<req*);
  (* 9.3.90/bp mu nun statt <=AregMd ---> <=DregMd heien! *)
  ELSIF (mode<=DregMd) THEN
   (* Real constants fall into this variant. *)
   NewLoadX(x,y);
   x:=y;
  ELSE
   Mark(7012); (* Release(x); *)
   SetErrMd(x,typ);
  END;
 END (*WITH*);
 IF willBeDestroyed THEN RegDestroyed(x.R) END;
END LoadX;

PROCEDURE MoveAdr(VAR x,y:Item);
(* ADR(x) -> y *)
VAR
 dst:INTEGER;
 op,src:CARDINAL;
 o,s:StrPtr;
BEGIN
 WITH x DO
  o:=typ;  (* save original type of x *)
  adrtoload:=FALSE;
  s:=y.typ; (* save original type of y *)
  IF (mode IN ItSet{stkMd,AregMd,DregMd,cocMd,typMd,codMd,fltMd,vconMd}) THEN
   Mark(7013); (* no effective address possible *)
   Release(x); SetregMd(x,a0+8,tp.undftyp);
  END;
  IF (mode<vconMd) & indir & (off=0) & nilToCheck & Option[nilchk] THEN
    LoadAdr(x); (* da indir: NilCheck! *)
  END;
  IF y.mode=stkMd THEN (* push address of x *)
   op:=0;
   IF (mode<vconMd) & indir & (off=0) THEN
    nilToCheck:=FALSE; (* mssen wir leider hier wegmachen! *)
    indir:=FALSE; op:=moveL+sp*ls9+adec*ls3;
   END;
   IF mode=procMd THEN GeaP(x,src) ELSE Gea(x,src,~indir) END;
   IF mode=AregMd THEN
    op:=moveL+sp*ls9+adec*ls3;  (* MOVE.L An,-(SP) *)
   ELSIF op=0 THEN
    op:=pea;
   END;
   PutWord(op+src);
   Ext(x);
  ELSE (* move address of x *)
   IF (mode<vconMd) & indir & (off=0) THEN
    indir:=FALSE;
    nilToCheck:=FALSE; (* geht leider nicht so einfach! *)
   ELSIF mode#AregMd THEN (* AregMd, gleich ins richtige Reg!/bp *)
    LoadAdrA(x, y.mode=AregMd, y.R);
   END;
   typ:=tp.addrtyp; y.typ:=tp.addrtyp;
   Move(x,y);
   IF y.mode=DregMd THEN y.wid:=long END;
  END;
  typ:=o;  (* restore original type of x *)
  y.typ:=s; (* restore original type of y *)
 END (*WITH*);
 Release(x); (* release associated registers, aber nicht, wenn beide gleich! *)
 IF y.mode=AregMd THEN SetbusyReg(y.R) END;
END MoveAdr;

PROCEDURE MoveBlock(VAR x,y:Item; sz:LONGINT; isstring:BOOLEAN);
(* Move a block of 'sz' bytes from x to y. *)
(* x.mode=stkMd:block comes from stack *)
(* y.mode=stkMd:block goes onto stack *)
(* Dogma:the implementation below presumes that all arrays and records *)
(* ------ are allocated on a Word-boundary. *)
VAR
 hsz:LONGINT;
 op,src,dst:CARDINAL;
 wid:WidType;
 restWord, restByte:BOOLEAN;
 xmode:ItemMode;
 z:Item;
BEGIN
 IF (x.mode#stkMd) OR (y.mode#stkMd) THEN
  xmode:=x.mode; (* save original mode of source op. *)
  IF y.mode=stkMd THEN
   StackTop(-sz);
   y.mode:=RindMd; (* transform 'stkMd' to 'RindMd' *)
  END;
  IF x.mode=stkMd THEN
   x.mode:=RindMd; (* transform 'stkMd' to 'RindMd' *)
  END;
  LoadAdr(x); src:=ainc+(CARDINAL(x.R) MOD 8);
  LoadAdr(y); dst:=ainc+(CARDINAL(y.R) MOD 8);
  restWord:=FALSE;
  restByte:=FALSE;
  (* 3.11.91/bp Arrays koennen auf ungeraden Adressen beginnen,
   * wenn ARRAY OF ARRAY OF
   * Ich frage nun auch auf ungerade Groesse ab.
   * Voraussetzung: eine gerade Anzahl kann niemals auf einer
   * ungeraden Adresse beginnen!
   *)
  IF isstring OR ODD(sz) THEN (* Note:always byte-move for Strings due to DBEQ! *)
    op:=moveB; hsz:=sz;
  ELSE
    op:=moveL; hsz:=sz DIV 4;
    restByte:=ODD(sz);
    restWord:=ODD(sz DIV 2);
  END;
  INC(op,Iea6(dst)+src);
  IF hsz<=3 THEN
   IF hsz=3 THEN PutWord(op) END;
   IF hsz>=2 THEN PutWord(op) END;
   IF hsz>=1 THEN PutWord(op) END
  ELSE
   IF hsz<=maxCard THEN wid:=word ELSE wid:=long END;
   SetconMd(z,hsz-1,tp.uinttyp);
   LoadX(z,wid,TRUE);
   PutWord(op);
   IF wid=word THEN
    IF isstring THEN PutWord(dbeq+z.R);
    ELSE PutWord(dbra+z.R);
    END;
    PutWord(177774B); (* -4 *)
   ELSE
    IF isstring THEN
     PutWord(beq+4);
     PutWord(subqL+ls9+z.R); (* 19.10.90/bp ls9 fehlte, unten auch !!! *)
     PutWord(bpl+256-8);
    ELSE
     PutWord(subqL+ls9+z.R);
     PutWord(bpl+256-6);
    END;
   END;
   ReleaseReg(z.R);
  END;
  IF restWord THEN PutWord(op+ls12) END; (* aus MOVE.L wird MOVE.W! *)
  IF restByte THEN PutWord(moveB+Iea6(dst)+src) END;
  IF xmode=stkMd THEN StackTop(sz) END;
  RegDestroyed(x.R); (* beide sicher in AReg oder sp *)
  RegDestroyed(y.R);
 END;
END MoveBlock;

(* 19.3.90/bp nicht exportiert, also wusch.. optimize *)
(*$ EntryExitCode:=FALSE *)
PROCEDURE MakeFFP(r{0}:LONGREAL):LONGINT; (* eigentlich :FFP! *)
BEGIN
  ASSEMBLE(
	MOVE.L	D2,-(A7)
	ADDI.L	#$00200000,D0
	MOVE.L	D0,D2
	SWAP	D2
	ANDI.W	#$7FF0,D2
	BNE.S	Not0
	MOVEQ	#0,D0
	BRA.S	ready (* hier war dicker Fehler in der INLINE-Version/bp!! *)
Not0:
	MOVEQ	#29,D2
	LSR.L	D2,D1
	MOVE.L	D0,D2
	ANDI.L	#$C0000000,D2
	OR.L	D2,D1
	MOVE.L	D0,D2
	LSL.L	#3,D2
	ANDI.L	#$007FFFF8,D2
	OR.L	D2,D1
	LSL.L	#4,D0
	ANDI.L	#$3F000000,D0
	OR.L	D1,D0
	ROL.L	#8,D0
	BSET	#31,D0
	MOVE.L	(A7)+,D2
 ready:	RTS
  END);
END MakeFFP;


(*$ EntryExitCode:=FALSE *)
PROCEDURE MakeREAL(r{0}:LONGREAL):LONGINT;
BEGIN
  ASSEMBLE(
	MOVE.L	D2,-(A7)
	MOVEQ	#29,D2
	LSR.L	D2,D1 (* lets wait for the barrel shifter, boys! *)
	MOVE.L	D0,D2
	ANDI.L	#$C0000000,D2
	OR.L	D2,D1
	LSL.L	#3,D0
	ANDI.L	#$3FFFFFF8,D0
	OR.L	D1,D0
	MOVE.L	(A7)+,D2
	RTS
  END);
END MakeREAL;

(*$ EntryExitCode:=FALSE *)
PROCEDURE Expo(r{0}:LONGREAL):INTEGER;
BEGIN
  ASSEMBLE(
	SWAP	D0
	LSR.L	#4,D0
	ANDI.W	#$07FF,D0
	SUBI.W	#$0400,D0
	RTS
  END);
END Expo;

PROCEDURE ConvLRConstTo(VAR x:Item; frm:StrForm);
VAR exp:INTEGER;
BEGIN
  WITH x DO
    exp:=Expo(val.conLR);
    IF frm=Real THEN
      typ:=tp.realtyp;
      IF exp<-127 THEN val.conLI:=0
      ELSIF exp<127 THEN val.conLI:=MakeREAL(val.conLR)
      ELSE Mark(7025);
      END; size:=4
    ELSIF frm=FFP THEN
      typ:=tp.ffptyp;
      IF exp<-65 THEN val.conLI:=0 (* wieso -65..62????/bp -64..63!!! *)
      ELSIF exp<62 THEN val.conLI:=MakeFFP(val.conLR)
      ELSE Mark(7026)
      END; size:=4;
    END;
  END;
END ConvLRConstTo;

PROCEDURE Move(VAR x,y:Item);
(* move simple type x -> simple type y *)
(* simple type means:item of size byte/word/long. *)
VAR
  op,ea1,ea2:CARDINAL;
  lv:LONGINT;
  cload,domove,gotCC:BOOLEAN;
  szx,szy:WidType;
  Dn,CReg: Register;
  source:Item;
BEGIN
  (* 8.3.90/bp Nicht immer nach DregMd wandeln!! *)
  WITH x DO
    IF (mode=cocMd) & ((y.mode=AregMd) OR (Tjmp#0) OR (Fjmp#0)) THEN
      LoadCC(x);
    END;
  END;
  gotCC:=FALSE;
  IF x.mode=cocMd THEN (* bleibt nur noch Scc y *)
    cocMdPtr:=ADR(x);
    Gea(y,ea2,TRUE); (* hier evtl. cond.codes retten! Auch fr NilCheck!*)
    IF cocMdPtr#NIL THEN (* cocMd wurde NICHT geladen! *)
      cocMdPtr:=NIL;
      gotCC:=TRUE;
      IF (y.mode=stkMd) THEN
        (* destination on top of stack:gives -(SP). *)
        ea2:=adec+sp;
        SetstkMd(y,y.typ); (* warum?? Ist doch stkMd??/bp *)
      END;
      PutWord(st+CARDINAL(InvertCC(x.CC))*ls8+ea2); Ext(y);
      y.wid:=byte; (* strt nicht, wenn wid nicht in CASE-Part von Item *)
      IF y.mode=DregMd THEN RegDestroyed(y.R) END;
     (* Dies ist hart, erspart aber ein weiteres groes IF! *)
      RETURN;
    END;
    (* 21.2.91/p 2te Bedingung war x.size=8. Dies war wohl falsch! *)
  ELSIF (x.mode=vconMd) THEN
    ConvLRConstTo(x,y.typ^.form); (* wirkt nur bei y.Real oder y.FFP! *)
  END;


  Isz(y,szy); Isz(x,szx);
  Gea(x,ea1,FALSE);
  IF ~gotCC THEN Gea(y,ea2,TRUE) END; (* cc geladen, ist schon fertig! *)
  source:=x; (* Wird evtl. von conMd zu ?regMd, spart auch Code!!!! *)

  cload:=source.mode=vconMd; domove:=TRUE;
  IF cload THEN
    lv:=source.val.conLI;
    source.size:=SHIFT(1,szy); szx:=szy;
    IF source.typ=tp.booltyp THEN lv:=-lv; END;
    IF (y.mode#DregMd)& FindConstReg(lv,szy,CReg) THEN
      SetregMd(source,CReg,source.typ); cload:=FALSE; source.wid:=szy;
      ea1:=CReg;
      (* x.R darf aber dann nicht Released werden!!! Nein, weil source=x *)
    END;
  END;
  IF y.mode=DregMd THEN
    RegDestroyed(y.R);
    (* Hat ja schon ConstReg gesucht! Was er wei, kann er wieder setzen! *)
    (* load to D-Register:*)
    ea2:=(CARDINAL(y.R) MOD 8)*ls9;
    IF cload THEN
      (* constant load to D-Register:*)
      IF IsByte(lv) THEN
        MoveConstToReg(lv,y.R);
        (* 8.3.90/bp EXT.x vermeiden! *)
        szy:=long;
      ELSIF (szx<=word) THEN
        MoveConstWordToDReg(lv,y.R);
        (* 8.3.90/bp Ext.W vermeiden! *)
        szy:=word; (* VORSICHT, evtl. FehlerbeiShortCard!!!/bp *)
      ELSE
        MoveConstToReg(lv,y.R);
      END;
    ELSE
      (* variable load to D:including structured constants. *)
      (* 8.3.90/bp wid von source ausnutzen, spart EXT.x! *)
      IF source.mode=DregMd THEN szy:=source.wid; domove:=(source.R#y.R) END;
      IF (source.mode=AregMd) & (szy<long) THEN szy:=long END;
      op:=MoveCode[szy];
      IF domove THEN
        PutWord(op+ea2+ea1); Ext(source); (* source effective address extension *)
      END;
    END;
    y.wid:=szy;
  ELSIF y.mode=AregMd THEN
    (* load to A-Register:always sign extends the data. *)
    RegDestroyed(y.R); (* hat ja schon gesucht! *)
    ea2:=(CARDINAL(y.R) MOD 8)*ls9;
    IF cload THEN
      (* constant load to A-Register:always load long. *)
      (* 27.2.90/bp bei #0,Ax -> suba.l ax,ax *)
      MoveConstToReg(lv,y.R);
    ELSE
      (* variable load to A-Register:*)
      IF source.mode=AregMd THEN domove:=(source.R#y.R) END;
      IF source.mode=DregMd THEN szy:=szx END;
      IF szy=byte THEN Mark(7008) END;
      IF domove THEN
        op:=MoveCode[szy]+adir*ls3;
        PutWord(op+ea2+ea1); Ext(source); (* source extension *)
      END;
    END;
  ELSE
    (*LetzteMovesAUSRegisternAuchMerken, Flags halten!!/bp *)
    (* move to memory:*)
    IF (source.mode=AregMd) & (szy=byte) THEN Mark(7009) END;
    IF (y.mode=stkMd) THEN
      (* destination on top of stack:gives -(SP). *)
      ea2:=adec+sp;
      SetstkMd(y,y.typ); (* WARUM, ist doch???? bp *)
    END;
    IF cload & (lv=0) THEN
      PutWord(clrB+szy*ls6+ea2); Ext(y); (* extend destination *)
    (* 27.2.90/bp *)
    ELSIF cload & (szy=byte) & ((lv=-1) OR (lv=maxSCard)) THEN
      PutWord(st+ea2); Ext(y);
    (* 01.03.90/bp Optimierung bei Long: erst in DReg mit Moveq *)
    ELSIF cload & ((szy=long) OR ~Option[joker])&
          (IsByte(lv) OR ((lv MOD 10000H)=0)&((lv DIV 10000H)<=127)) THEN
      GetReg(Dn,Dreg); (* war ja kein altes mit const vorhanden! *)
      (* gibt MOVEQ #xx,Dn  MOVE.L Dn,ea2 *)
      MoveConstToReg(lv,Dn);
      PutWord(MoveCode[szy]+Iea6(ea2)+ddir+Dn); Ext(y);
      ReleaseReg(Dn);
    (* 3.3.90/bp Wenn mglich PEA x.W, aber erst NACH dem vorigen Test! *)
    ELSIF cload & (szy=long) & (y.mode=stkMd) & IsWord(lv) THEN
      (*$ RangeChk:=FALSE OverflowChk:=FALSE *)
      PutWord(pea+absW); PutWord(INTEGER(lv));
      (*$ POP RangeChk POP OverflowChk *)
    ELSIF (source.mode#stkMd) OR (y.mode#stkMd) THEN
      op:=MoveCode[szy]+Iea6(ea2)+ea1;
      PutWord(op); Ext(source); Ext(y); (* extend source then destination *)
    END;
  END;
END Move;

PROCEDURE LoadD(VAR x:Item; willBeDestroyed:BOOLEAN);
(* load simple type x to a D-Register. *)
VAR
 y:Item;
 Dn:Register;
BEGIN
 WITH x DO
  (* 9.3.90/bp Wenn IsLocked(R), dann auch neues Reg nehmen!!!!! *)
  (* 10.3.90/bp willBeDestroyed gibt nun an, ob das Reg verndert wird *)
  IF (mode<DregMd) OR (willBeDestroyed & (mode=DregMd) & Islocked(R)) THEN
   GetReg(Dn,Dreg);
   SetregMd(y,Dn,typ);
   Move(x,y);
   Release(x);
   x:=y;
  ELSIF mode=cocMd THEN
   LoadCC(x)
  ELSIF mode>DregMd THEN
   Mark(7010);
   SetErrMd(x,typ);
  END;
  IF willBeDestroyed THEN RegDestroyed(R) END;
 END (*WITH*);
END LoadD;

PROCEDURE FMove(VAR x,y:Item);
(* floating move x->y *)
(* perform floating type moves:*)
(*  memory to memory / register to memory / memory to register *)
VAR
 Dn:Register;
 ea:CARDINAL;
 f:StrForm;
BEGIN
  WITH x DO
    IF (y.typ=tp.realtyp) OR (y.typ=tp.ffptyp) THEN Move(x,y)
    ELSIF (mode#stkMd) OR (y.mode#stkMd) THEN (* double real *)

      IF (mode<=stkMd)&(y.mode<=stkMd) THEN (* mem to mem *)

      (* Preload floating value to scratch D0/D1:*)
      (* Don't waste D-pool-Registers ! transform to 'fltMd':*)
        NeedD0(x);
        IF mode=vconMd THEN
          MoveConstToReg(val.conSign,d0);
          MoveConstToReg(val.conLI,d1);
        ELSE
          Gea(x,ea,FALSE);
          PutWord(movemL+ea); PutWord(3); Ext(x);  (* 3=register list for D0/D1 *)
          RegDestroyed(d0);RegDestroyed(d1);
          Release(x) (* NOW release old registers! *)
        END;
        mode:=fltMd; FR:=d0
      END;
(*
 * 31.12.88/ms Die beiden Flle '=DregMd' wurden eingebaut, weil der Compiler
 *             fr LONGREAL Register Parameter DregMd anstelle fltMd erzeugt.
 *             Dies sollte jedoch in M2CM.GenParam korrigiert werden, da
 *             momentan nicht beide Register reserviert werden.
 * 24.4.90/bp ist korrigiert, also DregMd wieder weg!
 *)
      IF (mode<=stkMd)&(y.mode=fltMd) THEN (* memory to register: *)

        Dn:=y.FR;
        IF Dn<fp0+16 THEN
          IF mode=vconMd THEN
            MoveConstToReg(val.conSign,Dn);
            MoveConstToReg(val.conLI,Dn+1);
          ELSE
            Gea(x,ea,FALSE);
            PutWord(movemL+ea); PutWord(CARDINAL(SHIFT(3,Dn))); Ext(x);
            RegDestroyed(Dn);RegDestroyed(Dn+1);
          END
        ELSE (* 68881! *)
          IF mode=vconMd THEN (* lr-const to freg *)
            IF (val.conSign=0)&(val.conLI=0)&~Option[m68040] THEN(*0.0: FMOVECR #$0F,FPn *)
              PutWord(FWord);
              PutWord(0101110000000000L+0FH+(CARDINAL(Dn) MOD 8)*ls7);
            ELSE
	      PutWord(FWord+imm); (* FMOVE.D #imm,FPn *)
	      PutWord(fmoveMR+(CARDINAL(Dn) MOD 8)*ls7);
	      PutLong(val.conSign);
	      PutLong(val.conLI)
	    END;
          ELSE (* mem to freg *)
            Gea(x,ea,FALSE); (* true oder false egal, wird nicht gemerkt?? *)
	    PutWord(FWord+ea);
            PutWord(fmoveMR+(CARDINAL(Dn) MOD 8)*ls7);
	    Ext(x);
          END;
        END;
      ELSIF (mode=fltMd) & (y.mode<=stkMd) THEN (* register to memory:*)
        Dn:=FR;
        IF Dn<fp0+16 THEN
          IF y.mode=stkMd THEN
            PutWord(movemmL+adec+sp); PutWord(CARDINAL(SHIFT(3,14-Dn)))
          ELSE
            Gea(y,ea,TRUE);
            PutWord(movemmL+ea); PutWord(CARDINAL(SHIFT(3,Dn))); Ext(y)
          END
        ELSE (* 68881 *)
          IF y.mode=stkMd THEN
            PutWord(FWord+adec+sp);
            PutWord(fmoveRM+(CARDINAL(Dn) MOD 8)*ls7);
          ELSE
            Gea(y,ea,TRUE);
            PutWord(FWord+ea);
            PutWord(fmoveRM+(CARDINAL(Dn) MOD 8)*ls7);
            Ext(y);
          END;
        END;
      ELSIF (mode=fltMd) & (y.mode=fltMd) THEN      (* register to register:*)
        Dn:=y.FR;
        IF FR#Dn THEN
          IF (FR<fp0+16)&(Dn<fp0+16) THEN
            PutWord(moveL+Dn*ls9+FR);
            PutWord(moveL+(Dn+1)*ls9+(FR+1));
            RegDestroyed(Dn); RegDestroyed(Dn+1);
          ELSIF (FR>=fp0+16)&(Dn<fp0+16) THEN (* freg nach dx,dx+1 *)
            PutWord(FWord+adec+sp); (* auf Stack *)
            PutWord(fmoveRM+(CARDINAL(FR) MOD 8)*ls7);
            PutWord(movemL+ainc+sp); PutWord(CARDINAL(SHIFT(3,Dn))); (* von Stack *)
            RegDestroyed(Dn); RegDestroyed(Dn+1);
          ELSIF (FR<fp0+16) THEN (* dx,dx+1 nach freg *)
            PutWord(movemmL+adec+sp); PutWord(CARDINAL(SHIFT(3,14-FR)));
            PutWord(FWord+ainc+sp);
            PutWord(fmoveMR+(CARDINAL(Dn) MOD 8)*ls7);
            RegDestroyed(Dn);
          ELSE (* freg to freg *)
            PutWord(FWord); (* fmove.x fr,dn *)
            PutWord(fmoveRR+(CARDINAL(FR) MOD 8)*ls10+(CARDINAL(Dn) MOD 8)*ls7);
            RegDestroyed(Dn);
          END;
        END;
      ELSE (* illegal modes *)
        Mark(7016);
(*
 * 31.12.88/ms Diese Folge-Fehler werden vom Scanner sowieso nicht ausgegeben
 *  Mark(7800+ORD(mode)); Mark(7900+ORD(y.mode));
 *)
      END;
    END (*double*);
  END (* with x *)
END FMove;

BEGIN
 MoveCode[byte]:=moveB; MoveCode[word]:=moveW; MoveCode[long]:=moveL;
END M2XM.
