IMPLEMENTATION MODULE M2TM;
(*
 * 30.5.89/ms
 *	Anpassung an den neuen Bezeichnertypen
 *
 * 24.1.90/bp
 * EnterProc('ASSEMBLE'...) eingefgt
 *)
(*$ LargeVars:=FALSE LongAlign:=FALSE StackChk:=FALSE StackParms:=FALSE
    Volatile:=FALSE EntryClear:=TRUE
*)
FROM SYSTEM IMPORT ADDRESS, ADR,CAST,SETREG,SHIFT,LONGSET;

FROM M2DM IMPORT
 nil,ObjPtr,Object,ObjClass,StrPtr,Structure,StrForm,Standard,ParPtr,Parameter,
 PDesc,PDPtr,KeyPtr,Key,mainmod,sysmod,tp,
 ALLOCATE,ResetHeap,VarModes,WidType,byte,word,long,
 minSInt,maxSInt,minSCard,maxSCard,minInt,maxInt,minCard,maxCard,minLInt,
 maxLInt,minLCard,maxLCard,Ident;
FROM M2DM IMPORT Diff;
FROM M2SM IMPORT Enter,Mark,MarkId;
FROM Arts IMPORT BreakPoint;

TYPE
  Str32Ptr=POINTER TO ARRAY[0..31] OF CHAR;

VAR (* sind longaligned! *)
 obj:ObjPtr;
 universe:ObjPtr;
 BBtyp,LBtyp,SBtyp:StrPtr;
 expo:BOOLEAN;


PROCEDURE FindInScope(id{6}: Ident; root{11B}: ObjPtr):ObjPtr;
VAR
 obj:ObjPtr;
 d:INTEGER;
BEGIN
 obj:=root;
 LOOP
  IF obj=NIL THEN EXIT END;
  d:=Diff(id,obj^.name);
  IF d<0 THEN obj:=obj^.left
  ELSIF d>0 THEN obj:=obj^.right
  ELSE EXIT
  END
 END;
 RETURN obj
END FindInScope;

PROCEDURE Find(id{6}: Ident):ObjPtr;
VAR
 obj:ObjPtr;
BEGIN
 Scope:=topScope;
 LOOP
  obj:=FindInScope(id,Scope^.right);
  IF obj#NIL THEN EXIT END;
  IF Scope^.kind=Module THEN
   obj:=FindInScope(id,universe^.right); EXIT
  END;
  Scope:=Scope^.left
 END;
 RETURN obj
END Find;

PROCEDURE FindImport(id{6}: Ident): ObjPtr;
VAR
 obj:ObjPtr;
BEGIN
 Scope:=topScope^.left;
 LOOP
  obj:=FindInScope(id,Scope^.right);
  IF obj#NIL THEN EXIT END;
  IF Scope^.kind=Module THEN
   obj:=FindInScope(id,universe^.right); EXIT
  END;
  Scope:=Scope^.left
 END;
 RETURN obj
END FindImport;

(* Volatile:=TRUE hier nicht ntig!! *)
PROCEDURE NewObj(id{6}: Ident; cl{7}:ObjClass):ObjPtr;
VAR
 ob0,ob1:ObjPtr;
 d:INTEGER;
BEGIN
 ob0:=topScope; ob1:=ob0^.right; d:=1;
 LOOP
  IF ob1#NIL THEN
   d:=Diff(id,ob1^.name);
   IF d<0 THEN
    ob0:=ob1; ob1:=ob0^.left
   ELSIF d>0 THEN
    ob0:=ob1; ob1:=ob0^.right
   ELSIF ob1^.class=Temp THEN (*export*)
    (*change variant*)
    ob1^.exported:=TRUE;
    topScope^.last^.next:=ob1; topScope^.last:=ob1; EXIT
   ELSE
    (*double def*) Mark(2001); MarkId(id); EXIT;
   END
  ELSE (*insert new object*)
   ALLOCATE(ob1,SIZE(Object));
   IF d<0 THEN ob0^.left:=ob1 ELSE ob0^.right:=ob1 END;
   (* ob1^.left:=NIL; ob1^.right:=NIL; ob1^.next:=NIL; *)
   IF cl#Temp THEN
    topScope^.last^.next:=ob1; topScope^.last:=ob1
   END;
   ob1^.exported:=FALSE; EXIT
  END
 END;
 WITH ob1^ DO
  name:=id; typ:=tp.undftyp; class:=cl;
  CASE cl OF
  | Header,Const,Typ,Field,Temp:
  | Var: vmode:=normVar
  | Proc: firstParam:=NIL; firstLocal:=NIL; ALLOCATE(pd,SIZE(PDesc))
  | Code: firstArg:=NIL; cd:=NIL
  | Module: firstObj:=NIL; root:=NIL; key:=NIL; mpc:=0; typ:=tp.notyp;
            realName:=name;
  END
 END;
 RETURN ob1;
END NewObj;


PROCEDURE NewConst(id{5}:Ident; typ{10}:StrPtr; value{4}:LONGINT);
VAR obj:ObjPtr;
BEGIN
  obj:=NewObj(id,Const);
  obj^.typ:=typ;
  obj^.conval.conLI:=value;
  obj^.conval.conSign:=0;
  (*
  obj^.conval.inMem:=FALSE;
  obj^.conval.conPrev:=NIL;
  *)
END NewConst;


PROCEDURE NewStr(frm:StrForm):StrPtr;
VAR
 str:StrPtr;
BEGIN
 ALLOCATE(str,SIZE(Structure));
 WITH str^ DO
  (* strobj:=NIL; size:=0; ref:=0; *)
  form:=frm;
  CASE frm OF
  | Undef..Enum,FFP..UReal,Opaque..String:
  | Range: RBaseTyp:=tp.undftyp; (* min:=0; max:=0; sign:=FALSE; *)
  | BPointer,Pointer: PBaseTyp:=tp.undftyp
  | Set: SBaseTyp:=tp.undftyp
  | ProcTyp: (* firstPar:=NIL; resTyp:=NIL *)
  | Array: ElemTyp:=tp.undftyp; IndexTyp:=tp.undftyp
  | Record: (* firstFld:=NIL *)
  END
 END;
 RETURN str
END NewStr;

PROCEDURE NewImp(scope,obj: ObjPtr);
VAR
 ob0,ob1,ob1L,ob1R:ObjPtr;
 d:INTEGER;
BEGIN
 ob0:=scope; ob1:=ob0^.right; d:=1;
 LOOP
  IF ob1#NIL THEN
   d:=Diff(obj^.name,ob1^.name);
   IF d<0 THEN
    ob0:=ob1; ob1:=ob1^.left
   ELSIF d>0 THEN
    ob0:=ob1; ob1:=ob1^.right
   ELSIF ob1^.class=Temp THEN (*exported*)
    ob1L:=ob1^.left; ob1R:=ob1^.right;
    ob1^:=obj^; ob1^.exported:=TRUE;
    ob1^.left:=ob1L; ob1^.right:=ob1R; EXIT
   ELSE
    Mark(2002); MarkId(obj^.name); EXIT;
   END
  ELSE (*insert copy of imported object*)
   ALLOCATE(ob1,SIZE(Object));
   ob1^:=obj^;
   IF d<0 THEN ob0^.left:=ob1 ELSE ob0^.right:=ob1 END;
   ob1^.left:=NIL; ob1^.right:=NIL; ob1^.exported:=FALSE;
   IF (obj^.class=Typ) & (obj^.typ^.form=Enum) THEN
    (*import enumeration constants too*)
    ob0:=obj^.typ^.ConstLink;
    WHILE ob0#NIL DO
     NewImp(scope,ob0); ob0:=ob0^.conval.conPrev
    END
   END;
   EXIT
  END
 END
END NewImp;

PROCEDURE NewPar(ident: Ident; isvar:BOOLEAN; parMode:INTEGER;
                 last:ParPtr):ParPtr;
VAR
 par:ParPtr;
BEGIN
 ALLOCATE(par,SIZE(Parameter)); par^.name:=ident;
 par^.varpar:=isvar; par^.parMode:=parMode; par^.next:=last; RETURN par
END NewPar;

PROCEDURE NewScope(cl:ObjClass);
VAR
 hd:ObjPtr;
BEGIN
 ALLOCATE(hd,SIZE(Object));
 WITH hd^ DO
(* name:=NIL;
  typ:=NIL;
 *)
  left:=topScope;
(*
  right:=NIL;
  next:=NIL;
 *)
(* exported *)
  class:=Header;
  kind:=cl;
  last:=hd;
(* heap *)
(* withadr *)
 END;
 topScope:=hd
END NewScope;

PROCEDURE CloseScope;
BEGIN
 topScope:=topScope^.left
END CloseScope;

PROCEDURE CheckUDP(obj:ObjPtr);
(*obj is newly defined type; check for undefined forward references
  pointing to this new type*)

 PROCEDURE ParseStruct(str:StrPtr; checkname:BOOLEAN);
 VAR
  n1:ObjPtr;
  f:StrForm;
 BEGIN
  LOOP
   WITH str^ DO
    IF checkname & (strobj#NIL) THEN EXIT END;
    f:=form;
    IF f=Array THEN
     str:=ElemTyp;
    ELSIF (f=BPointer) OR (f=Pointer) THEN
     IF PBaseTyp#tp.undftyp THEN
      str:=PBaseTyp;
     ELSE
      IF Diff(BaseId,obj^.name)=0 THEN PBaseTyp:=obj^.typ; END;
      EXIT;
     END;
    ELSIF f=Record THEN
     n1:=firstFld;
     WHILE n1#NIL DO
      ParseStruct(n1^.typ,TRUE); n1:=n1^.next;
     END;
     EXIT;
    ELSE
     EXIT;
    END;
    checkname:=TRUE;
   END;
  END;
 END ParseStruct;
VAR
 var:BOOLEAN;
 node:ObjPtr;
BEGIN
 node:=topScope^.next;
 WHILE node # NIL DO
  WITH node^ DO
   var:=class=Var;
   IF (class=Typ) OR var THEN ParseStruct(typ,var) END;
   node:=next
  END;
 END
END CheckUDP;

PROCEDURE MarkHeap;
BEGIN
 ALLOCATE(topScope^.heap,0)
END MarkHeap;

PROCEDURE ReleaseHeap;
BEGIN
 ResetHeap(topScope^.heap)
END ReleaseHeap;

PROCEDURE InitTableHandler;
BEGIN
 topScope:=universe; mainmod^.firstObj:=NIL; ReleaseHeap;
 (* 1.1.91/bp Weil nun Name durch IMPORT s:SYSTEM verndert werden kann! *)
 sysmod^.name:=sysmod^.realName;
END InitTableHandler;

(*$ CopyDyn:=FALSE *)
PROCEDURE EnterTyp(VAR str:StrPtr; name:ARRAY OF CHAR; frm:StrForm;
                   sz:INTEGER);
BEGIN
 obj:=NewObj(Enter(name),Typ); str:=NewStr(frm);
 obj^.typ:=str; str^.strobj:=obj; str^.size:=sz;
 obj^.exported:=expo
END EnterTyp;

(*$ NilChk:=FALSE *) (* ab hier sicher kein NIL *)

(*$ CopyDyn:=FALSE *)
PROCEDURE EnterNumTyp(VAR str:StrPtr; name:ARRAY OF CHAR; wid:WidType;
                      sgn:BOOLEAN; lo,hi:LONGINT);
BEGIN
 str:=NewStr(Range);
 WITH str^ DO
  size:=CAST(LONGINT,LONGSET{wid}); sign:=sgn;
  RBaseTyp:=tp.uinttyp;
  min:=lo; max:=hi;
 END;
 IF name[0]#0C THEN
  obj:=NewObj(Enter(name),Typ);
  obj^.typ:=str; str^.strobj:=obj;
  obj^.exported:=expo;
 END;
END EnterNumTyp;

(*$ CopyDyn:=FALSE *)
PROCEDURE EnterProc(name:ARRAY OF CHAR; num:Standard; res:StrPtr);
BEGIN
 obj:=NewObj(Enter(name),Code);
 obj^.typ:=res; obj^.std:=num; obj^.exported:=expo
END EnterProc;

BEGIN
 topScope:=NIL; Scope:=NIL;
 NewScope(Module); universe:=topScope;

 tp.undftyp:=NewStr(Undef); tp.undftyp^.size:=1;
 tp.notyp:=NewStr(Undef); tp.notyp^.size:=0;
 tp.uinttyp:=NewStr(UInt); tp.uinttyp^.size:=4;
 tp.urealtyp:=NewStr(UReal); tp.urealtyp^.size:=8;
 tp.stringtyp:=NewStr(String); tp.stringtyp^.size:=0;
 SBtyp:=NewStr(Range); (*SBitset Basetyp*)
 BBtyp:=NewStr(Range); (*Bitset Basetyp*)
 LBtyp:=NewStr(Range); (*LBitset Basetyp*)

 ALLOCATE(mainmod,SIZE(Object));
 WITH mainmod^ DO
  typ:=tp.notyp;
 (*
  next:=NIL;
  compmod:=0;
  exported:=FALSE;
 *)
  class:=Module;
  ALLOCATE(key,SIZE(Key))
 END;

 expo:=FALSE;              (*initialization of Universe*)
 EnterNumTyp(tp.numtyp[byte,FALSE],"SHORTCARD",byte,FALSE,minSCard,maxSCard);
 EnterNumTyp(tp.numtyp[byte,TRUE], "SHORTINT",byte,TRUE, minSInt, maxSInt);
 EnterNumTyp(tp.numtyp[word,FALSE],"CARDINAL",word,FALSE,minCard, maxCard);
 EnterNumTyp(tp.numtyp[word,TRUE], "INTEGER", word,TRUE, minInt,  maxInt);
 EnterNumTyp(tp.numtyp[long,FALSE],"LONGCARD",long,FALSE,minLCard,
             CAST(LONGINT,maxLCard));
 EnterNumTyp(tp.numtyp[long,TRUE], "LONGINT", long,TRUE, minLInt, maxLInt);
 EnterTyp(tp.booltyp, "BOOLEAN", Bool,   1);
 EnterTyp(tp.chartyp, "CHAR",    Char,   1);
 EnterTyp(tp.realtyp, "REAL",    Real,   4);
 EnterTyp(tp.proctyp, "PROC",    ProcTyp,4);
 EnterTyp(tp.lrealtyp,"LONGREAL",LReal,  8);
 NewScope(Module);         (*initialization of module SYSTEM*)
 expo:=TRUE;
 EnterNumTyp(SBtyp,             "",        byte,FALSE,0,       7);
 EnterNumTyp(BBtyp,             "",        byte,FALSE,0,       15);
 EnterNumTyp(LBtyp,             "",        byte,FALSE,0,       31);
 EnterNumTyp(tp.addrtyp,           "ADDRESS", long,TRUE, minLInt, maxLInt);
 EnterNumTyp(tp.bptrtyp,           "BPTR",    long,TRUE, minLInt, maxLInt);
 EnterTyp(tp.ssettyp, "SHORTSET",Set,    1); tp.ssettyp^.SBaseTyp:=SBtyp;
 EnterTyp(tp.bsettyp, "BITSET",  Set,    2); tp.bsettyp^.SBaseTyp:=BBtyp;
 EnterTyp(tp.lsettyp, "LONGSET", Set,    4); tp.lsettyp^.SBaseTyp:=LBtyp;
 EnterTyp(tp.bytetyp, "BYTE",    Undef,  1);
 EnterTyp(tp.wordtyp, "WORD",    Undef,  2);
 EnterTyp(tp.ffptyp,  "FFP",     FFP,    4);
 EnterProc("ADR",      Adr,      tp.addrtyp);
 EnterProc("TAG",      Tag,      tp.addrtyp);
 EnterProc("ASSEMBLE", Assemble, tp.notyp);
 EnterProc("CAST",     Cast,     tp.numtyp[long,TRUE]);
 EnterProc("LOADREGS", Loadregs, tp.notyp);
 EnterProc("REG",      Reg,      tp.numtyp[long,TRUE]);
 EnterProc("SHIFT",    Shift,    tp.numtyp[long,TRUE]);
 EnterProc("TSIZE",    Tsize,    tp.numtyp[long,TRUE]);
 EnterProc("SAVEREGS", Saveregs, tp.notyp);
 EnterProc("SETREG",   Setreg,   tp.notyp);
 (* 3.11.91/bp Mathe-Inline *)
 EnterProc("ACOS",     Facos,    tp.lrealtyp);
 EnterProc("ASIN",     Fasin,    tp.lrealtyp);
 EnterProc("ATAN",     Fatan,    tp.lrealtyp);
 EnterProc("COS",      Fcos,     tp.lrealtyp);
 EnterProc("COSH",     Fcosh,    tp.lrealtyp);
 EnterProc("EXP",      Fexp,     tp.lrealtyp);
 EnterProc("LOG10",    Flog10,   tp.lrealtyp);
 EnterProc("LOGN",     Flogn,    tp.lrealtyp);
 EnterProc("SIN",      Fsin,     tp.lrealtyp);
 EnterProc("SINH",     Fsinh,    tp.lrealtyp);
 EnterProc("SQRT",     Fsqrt,    tp.lrealtyp);
 EnterProc("TAN",      Ftan,     tp.lrealtyp);
 EnterProc("ATANH",    Fatanh,   tp.lrealtyp);
 EnterProc("ETOXM1",   Fetoxm1,  tp.lrealtyp);
 EnterProc("LOG2",     Flog2,    tp.lrealtyp);
 EnterProc("LOGNP1",   Flognp1,  tp.lrealtyp);
 EnterProc("TENTOX",   Ftentox,  tp.lrealtyp);
 EnterProc("TWOTOX",   Ftwotox,  tp.lrealtyp);
 EnterProc("SQR",      Fsqr,     tp.lrealtyp);
 EnterProc("TANH",     Ftanh,    tp.lrealtyp);
(*
 * 30.9.89/ms
 * Aus Kompatibilittsgrnden soll es mglich sein VAL (optional) von
 * SYSTEM zu importieren.
 *)
 EnterProc("VAL",  Val,  tp.numtyp[long,TRUE]);
 ALLOCATE(sysmod,SIZE(Object));
 WITH sysmod^ DO
  realName:=ADR("\o\x06SYSTEM");
  name:=realName;
 (*
  left:=NIL;
  right:=NIL;
  next:=NIL;
  compmod:=0;
  exported:=FALSE;
 *)
  class:=Module;
  ALLOCATE(key,SIZE(Key));
  firstObj:=topScope^.right;
  root:=topScope^.right;
 END;
 CloseScope;
 (* initialization of Universe continued *)
 expo:=FALSE;
 NewConst(Enter("FALSE"),tp.booltyp,0);
 NewConst(Enter("TRUE"),tp.booltyp,1);
 NewConst(Enter("NIL"),tp.addrtyp,nil);

 tp.proctyp^.firstPar:=NIL; tp.proctyp^.resTyp:=tp.notyp;
 EnterProc("CAP",  Cap,  tp.chartyp);
 EnterProc("CHR",  Chr,  tp.chartyp);
 EnterProc("ODD",  Odd,  tp.booltyp);
 EnterProc("FLOAT",Float,tp.realtyp);
 EnterProc("VAL",  Val,  tp.numtyp[long,TRUE]);
 EnterProc("ABS",  Abs,  tp.numtyp[long,TRUE]);
 EnterProc("HIGH", High, tp.numtyp[long,TRUE]);
 EnterProc("MAX",  Max,  tp.numtyp[long,TRUE]);
 EnterProc("MIN",  Min,  tp.numtyp[long,TRUE]);
 EnterProc("ORD",  Ord,  tp.numtyp[long,TRUE]);
 EnterProc("SIZE", Size, tp.numtyp[long,TRUE]);
 EnterProc("TRUNC",Trunc,tp.numtyp[long,TRUE]);
 EnterProc("DEC",  Dec,  tp.notyp);
 EnterProc("EXCL", Excl, tp.notyp);
 EnterProc("HALT", Halt, tp.notyp);
 EnterProc("INC",  Inc,  tp.notyp);
 EnterProc("INCL", Incl, tp.notyp);
 MarkHeap;
END M2TM.
