IMPLEMENTATION MODULE M2LM;
(*$ LargeVars:=FALSE LongAlign:=FALSE StackChk:=FALSE StackParms:=FALSE
    Volatile:=FALSE
*)
(*$ DEFINE OneUnit:=TRUE *) (* 1 Unit je File, sonst je Hunk! *)
(*$ DEFINE Demo:=FALSE *)

FROM SYSTEM	IMPORT	ADR,ADDRESS,BYTE,CAST,SHIFT,WORD,ASSEMBLE,SETREG;
FROM Arts	IMPORT	BreakPoint;
FROM ExecL	IMPORT	Insert, RawDoFmt, RemTail, CopyMem;
IMPORT DosL;
FROM DosD	IMPORT	Date;
FROM DosL	IMPORT	DateStamp;
FROM Assembler	IMPORT	ls8, bra, bsr, nop, jsr, prel, a4;
FROM M2DM	IMPORT	WidType,Ident, ExportTypes, KeyPtr,ModModes,ObjClass,ObjPtr,
			StrPtr,AllocHunkLev,ResetHunkHeap,Condition,byte,word,
			long,AllocLev0,ConstValue,ALLOCATE,
			CRel,CRelPtr;
FROM M2MM	IMPORT	codeBuffLen,codeBuff;
FROM M2File	IMPORT	FileType,GetFileName,GeneratingNew;
FROM M2Amiga	IMPORT	MakeIcon;
FROM M2SM	IMPORT	Mark;
FROM M2OM	IMPORT	Options,Option,CompOpts,cpuCh,verbose,optiCode,iconOn,
			toName;
FROM M2XM	IMPORT	AllRegsDestroyed,InvertCC,Item,ItemMode;
FROM Terminal	IMPORT	Format, FormatS, FormatNr, Write, WriteLn, WriteString,
			Flush;
FROM M2RM	IMPORT	ModList;
FROM String	IMPORT	Length,Copy,CapString;
FROM SeqIO	IMPORT	SeqKey,OpenSeqOut,CloseSeq,SeqOk,SeqOutLQuick,
			SeqOutCount;
IMPORT Storage;

(* 27.12.90/bp
   conBuff je Modul wird bei Bedarf alloziert
   Dadurch kann die Optimierung auch bei fremden Modulen
   verfolgt und korrekt angewandt werden!
   eigenes in 4K-Schritten, fremde in 1K-Schritten
 *)
CONST
  sb=a4+8;
  ownAdd=4096;
  foreignAdd=1024;

  maxIniSize=20000; (* minimal! *)

  cMax=32700; (* GesamtMax (bichen was fr ALVs lassen) *)
  maxConBuffSize=cMax;
  textString='text';
  buffSize=2048; (* fr objfile *)
  varId=      '\o\x03VAR';
  iniId=      '\o\x02IN';
  chrId=      '\o\x02BY'; (* mglichst kurzes reserviertes Wort *)
  dbId=       '\o\x08LinkerDB';
  mainId=     '\o\x05_main';
  maincloseId='\o\x08_mainEnd';
  endId=      '\o\x03END';
  nullId=     '\o\x00\o'; (* 0C kommt ja automatisch dran! *)

  chipBit=SHIFT(1,30);
  maxM2 = 64*2-1;

TYPE
 Str32Ptr=POINTER TO ARRAY[0..33] OF CHAR;

 ConBuffPtr = POINTER TO ARRAY[0..maxConBuffSize-1] OF CHAR;

 ConRec=RECORD
   cp:INTEGER; (* MUSS erstes Element sein wg. ASSEMBLE!! *)
   size:INTEGER; (* to Longword *)
   buff:ConBuffPtr;
 END;

 CaseCond = RECORD
   CASE :INTEGER OF
   | 0: b: SHORTINT;
   | 1: cond: Condition;
   END;
 END;

 List = RECORD
   head, tail, tailPred: ADDRESS
 END;

 PCRecPtr = POINTER TO PCRec;
 PCRec = RECORD
   succ,
   pred: PCRecPtr;
   pc, (* wo genau.  pc1 und pc2=0: nicht gefixt, ignore!!*)
   pc1, (* norm. Ziel *)
   pc2: INTEGER; (* bei pc wird pc1-pc2+off eingetragen! *)
   off: LONGINT;
   wid: WidType;
   cc: CaseCond;
   (* nur bei branch, wenn gltig und word , dann optimierbar *)
   (* -1 heit keine cond also kein bra, nicht optimierbar *)
 END;

 PCRecList = RECORD
   head,
   tail,
   tailPred: PCRecPtr;
 END;

 DeletionPtr = POINTER TO Deletion;
 Deletion = RECORD
   succ,
   pred: DeletionPtr;
   where: INTEGER;
   count: INTEGER (* count<=0 heit DeadEnd, lsche ABS(cnt)! *)
 END;

 DeletionList = RECORD
   head,
   tail,
   tailPred: DeletionPtr;
 END;

 HunkPtr = POINTER TO HunkDesc;
 HunkDesc = RECORD
   succ,pred: HunkPtr;
   start:INTEGER;
   nr:CARDINAL;
 END;
 HunkList=RECORD
   head,tail,tailPred: HunkPtr
 END;

 (* drel kommt momentan NICHT vor! Jetzt doch! *)
 (* drel,dref ist nur word! *)
 (* ref,rel kann alles sein: bwl *)
 (* bei rel ist modnr immer 0 bzw. egal *)
 RefTypes=(rel32,rel16,rel8,def,ref32,ref16,ref8,dref32,dref16);
 ExtRefPtr = POINTER TO ExtRef;
 ExtRef = RECORD
   succ,pred: ExtRefPtr;
   pc: INTEGER; (* rel zum 1. Hunkstart, also ip!! *)
   modnr:INTEGER; (* kann auch hunkNr sein! Nicht bei jedem RefTyp gltig! *)
   typ:RefTypes;
   CASE etyp:ExportTypes OF (* bei rel32,16,8 ist der Rest vllig egal *)
   | exported, noHead, noDHead:
	name:Ident;
   | private:
	procNo: LONGINT; (* gleiche SIZE wie Ident! *)
   | main, varref, iniref, charref, linkerDB, mainclose, closemod, openmod:
      (* nichts *)
   END;
 END;

 (* sortiert nach typ, wid, hunk modnr, name *)
 ExtRefList = RECORD
   head, tail, tailPred: ExtRefPtr;
 END;


VAR
 codeoverflow:BOOLEAN;
 (*$ LongAlign:=TRUE *)
 TM: Date; (* Mu auf LANGWORT!!! *)
 ProgDeleted:LONGINT;
 MainName:Ident;
 (*$ POP LongAlign *)
 NameBuffer: RECORD
		CASE :INTEGER OF
		| 0: str: ARRAY[0..127] OF CHAR;
		| 1: lws: ARRAY[0..31] OF LONGINT;
		END;
	     END;
 wordcount:INTEGER;
 BufferLen: INTEGER; (* immer Length(NameBuffer) fr Speed *)
 KeyId: RECORD len:INTEGER; buf:ARRAY[0..13] OF CHAR END; (* CHAR(13),'0123456789ab' *)

 (*$ LongAlign:=TRUE *)
 pcr: PCRecList;
 del: DeletionList;
 hunks:HunkList;
 codeRefs: ExtRefList;

 hunkHeap:ADDRESS; (* eigene Heapverwaltung! *)

 ObjFile: SeqKey;
 fileName: ARRAY[0..127] OF CHAR;

(* Lev0! *)
 iniBuff:POINTER TO ARRAY[0..maxIniSize] OF SHORTINT;
 iniRefs,
 constRefs:ExtRefList;
 iniOffset:INTEGER;
(* ----- *)

 chars: ARRAY[0..maxM2] OF ConRec;


PROCEDURE PutCh; (*$ EntryExitCode:=FALSE *)
BEGIN
  ASSEMBLE(
	MOVE.B	D0,(A3)+
	RTS
	END);
END PutCh;

(*$ CopyDyn:=FALSE *)
PROCEDURE sprintf(str:ARRAY OF CHAR; adr:ADDRESS);
BEGIN
  RawDoFmt(ADR(str),adr,ADR(PutCh),ADR(KeyId.buf));
END sprintf;

PROCEDURE WL(l{7}:LONGINT);
BEGIN
  SeqOutLQuick(ObjFile,l);
END WL;

PROCEDURE WC(adr:ADDRESS; len:LONGINT);
BEGIN
  SeqOutCount(ObjFile,adr,len); (* CARDINAL(len) !!! *)
END WC;

PROCEDURE WName(kenn:LONGINT);
VAR l,i:INTEGER;
BEGIN
  FOR i:=BufferLen TO BufferLen+2 DO NameBuffer.str[i]:=0C END; (* 3 Nullen ran *)
  l:=(BufferLen+3) DIV 4;
  (*$ RangeChk:=FALSE OverflowChk:=FALSE *)
  WL(l+SHIFT(kenn,24));
  (*$ POP RangeChk POP OverflowChk *)
  WC(ADR(NameBuffer.lws),l*4);
END WName;

(*############################################################*)
(* Stringverarbeitung *)
PROCEDURE IdentToStr(id:Ident;last:CHAR);
VAR i:INTEGER;
BEGIN
  WITH id^ DO
    FOR i:=0 TO len-1 DO
      NameBuffer.str[i]:=buf[i]
    END;
    NameBuffer.str[len]:=last;
    NameBuffer.str[len+1]:=0C;
    IF last#0C THEN BufferLen:=len+1 ELSE BufferLen:=len END;
  END;
END IdentToStr;

PROCEDURE GenName(e:ExtRefPtr);
VAR l,i:INTEGER; o:ObjPtr; id1,id2:Ident; ch:POINTER TO CHAR;
BEGIN
  IF e^.etyp<=charref THEN
    o:=ModList;
    FOR i:=0 TO e^.modnr DO o:=o^.next END;
    id1:=o^.realName;
  ELSE
    id1:=ADR(nullId);
  END;
  IF e^.etyp=private THEN
    IdentToStr(id1,'$');
  ELSE
    IdentToStr(id1,'_');
  END;
  CASE e^.etyp OF
  | exported:
	id2:=e^.name;
  | noHead,noDHead:
	id2:=e^.name;
	BufferLen:=0; (* '_' wieder weg! *)
  | private,openmod:
	IF e^.etyp=private THEN
	  sprintf('%ld',ADR(e^.procNo));
	ELSIF o^.mode=library THEN
	  (* 3.2.91/bp Wegen negativer Libs! OptLibs *)
	  l:=ABS(o^.key^.ver);
	  sprintf('%d',ADR(l));
	ELSE
	  sprintf('%08lx%04x',o^.key);
	  (*
	     3.11.91/bp wegen locale.library notwendig,
	     sie patcht RawDoFmt und erzeugt kleine Hexziffern!
	   *)
	  CapString(KeyId.buf);
	END;
	KeyId.len:=Length(KeyId.buf);
	id2:=ADR(KeyId);
  | closemod:
	id2:=ADR(endId);
  | mainclose:
	id2:=ADR(maincloseId);
  | varref:
	id2:=ADR(varId);
  | iniref:
	id2:=ADR(iniId);
  | charref:
	id2:=ADR(chrId);
  | main:
	id2:=ADR(mainId);
  | linkerDB:
 	id2:=ADR(dbId);
  END;
  l:=id2^.len; ch:=ADR(id2^.buf);
  FOR i:=BufferLen TO BufferLen+l-1 DO
    NameBuffer.str[i]:=ch^; INC(ch)
  END;
  INC(BufferLen,l);
END GenName;

(*############################################################*)

(*$ IF OneUnit *)
(* Hunkverwaltung *)
PROCEDURE WhichHunk(pc:INTEGER; VAR rel:INTEGER):CARDINAL;
VAR h:HunkPtr;
BEGIN
  h:=hunks.tailPred;
  WHILE h^.pred#NIL DO
    IF h^.start<=pc THEN
      rel:=pc-h^.start;
      RETURN h^.nr
    END;
    h:=h^.pred;
  END;
END WhichHunk;
(*$ ENDIF *)

(*$ EntryExitCode:=FALSE *)
PROCEDURE Remove(n{9}:ADDRESS);
BEGIN
  ASSEMBLE(
	MOVE.L	(A1),A0
	MOVE.L	4(A1),A1
	MOVE.L	A0,(A1)
	MOVE.L	A1,4(A0)
	RTS
  END);
END Remove;

(*$ EntryExitCode:=FALSE *)
PROCEDURE AddTail(list{8}:ADDRESS; node{9}:ADDRESS);
BEGIN
  ASSEMBLE(
	ADDQ.L	#4,A0
	MOVE.L	4(A0),D0
	MOVE.L	A1,4(A0)
	MOVE.L	A0,(A1)
	MOVE.L	D0,4(A1)
	MOVE.L	D0,A0
	MOVE.L	A1,(A0)
	RTS
	END);
END AddTail;

(*$ EntryExitCode:=FALSE *)
PROCEDURE Max(a{0},b{1}:INTEGER):INTEGER;
BEGIN
  ASSEMBLE(
	CMP.W	D1,D0
	BGE.S	ok
	MOVE.W	D1,D0
    ok:	RTS
  END);
END Max;

(*$ EntryExitCode:=FALSE *)
PROCEDURE NewList(VAR list{8}:List);
BEGIN
  ASSEMBLE(
	MOVE.L	A0,(A0)
	ADDQ.L	#4,(A0)
	CLR.L	4(A0)
	MOVE.L	A0,8(A0)
	RTS
  END);
END NewList;



(*$ EntryExitCode:=FALSE *)
PROCEDURE FindRef(where{2}:INTEGER):PCRecPtr;
BEGIN
  ASSEMBLE(
	LEA	pcr(A4),A1
	MOVEQ	#0,D0
  lp:	MOVE.L	(A1),A1 (* pcr^.head oder succ *)
	TST.L	(A1)
	BEQ.S	not (* tail! *)
	CMP.W	PCRec.pc(A1),D2
	BGT.S	lp
	BNE.S	not
	MOVE.L	A1,D0
  not:	RTS
  END);
END FindRef;

(*$ EntryExitCode:=FALSE *) (* sucht Deletion mit where=where *)
PROCEDURE FindDel(wo{2}:INTEGER):DeletionPtr;
BEGIN
  ASSEMBLE(
	LEA	del(A4),A1
	MOVEQ	#0,D0
  lp:	MOVE.L	(A1),A1 (* pcr^.head oder succ *)
	TST.L	(A1)
	BEQ.S	not (* tail! *)
	CMP.W	Deletion.where(A1),D2
	BGT.S	lp
	BLT.S	not
	MOVE.L	A1,D0
  not:	RTS
  END);
END FindDel;

(*$ EntryExitCode:=FALSE *) (* sucht Deletion mit where=where *)
PROCEDURE IsDead(wo{2}:INTEGER):BOOLEAN;
BEGIN
  ASSEMBLE(
	LEA	del(A4),A1
	MOVEQ	#0,D0
  lp:	MOVE.L	(A1),A1 (* pcr^.head oder succ *)
	TST.L	(A1)
	BEQ.S	not (* tail! *)
	CMP.W	Deletion.where(A1),D2
	BGT.S	lp
	BLT.S	not
	TST.W	Deletion.count(A1)
	SLE	D0 (* <=0: DeadEnd *)
  not:	RTS
  END);
END IsDead;

(*$ ReturnChk:=FALSE *) (* test, wie weit ein DeadEnd geht max. bis ip *)
PROCEDURE NextRef(where:INTEGER):INTEGER;
(*VAR r:PCRecPtr; next,i:INTEGER;*)
CONST defOrd=ORD(def);
BEGIN
  ASSEMBLE(
	MOVE.W	where(A5),D2
	MOVE.W	ip(A4),D0 (* next *)
(* refs auf Definitionen durchsuchen *)
	MOVEQ	#defOrd,D4
	MOVE.L	codeRefs.head(A4),A0
lp1:	MOVE.L	(A0),D3
	BEQ.S	refsrdy
	CMP.B	ExtRef.typ(A0),D4
	BNE.S	next1	(* keine Def. also nchster *)
	MOVE.W	ExtRef.pc(A0),D1
	CMP.W	D2,D1
	BLT.S	not1
	CMP.W	D0,D1
	BGE.S	not1
	MOVE.W	D1,D0
not1:	CMP.W	D2,D0
	BEQ.S	raus
next1:	MOVE.L	D3,A0
	BRA.S	lp1

refsrdy:
	MOVE.L	pcr.head(A4),A0
lp2:	MOVE.L	(A0),D3
	BEQ.S	rdy
	MOVE.W	PCRec.pc1(A0),D1
	CMP.W	D2,D1
	BLT.S	not2
	CMP.W	D0,D1
	BGE.S	not2
	MOVE.W	D1,D0
not2:	CMP.W	D2,D0
	BEQ.S	raus
	MOVE.L	D3,A0
	BRA.S	lp2
rdy:
raus:
  END);
 (*
  r:=pcr.head; next:=ip;
  FOR i:=0 TO jumpNr DO
    IF (jumps^[i]>=where)&(jumps^[i]<next) THEN
      next:=jumps^[i]
    END
  END;
  WHILE r^.succ#NIL DO
    WITH r^ DO
      IF (pc1>=where) & (pc1<next) THEN next:=pc1 END;
      IF next=where THEN RETURN where END;
      r:=succ;
    END;
  END;
  RETURN next;
*)
END NextRef;
(*$ POP ReturnChk *)

(*$ EntryExitCode:=FALSE *)
PROCEDURE EnqueueDel(d{9}:DeletionPtr; VAR l{8}:DeletionList);
BEGIN
  ASSEMBLE(
	MOVE.L	A2,-(A7)
	MOVE.W	Deletion.where(A1),D1
	MOVE.L	(A0),D0
  lp:	MOVEA.L	D0,A0
	MOVE.L	(A0),D0
	BEQ.S	ende
	CMP.W	Deletion.where(A0),D1
	BGT.S	lp
  ende:	MOVE.L	Deletion.pred(A0),A2
	MOVE.L	A1,Deletion.pred(A0)
	MOVE.L	A0,(A1)
	MOVE.L	A2,Deletion.pred(A1)
	MOVE.L	A1,(A2)
	MOVE.L	(A7)+,A2
	RTS
  END);
END EnqueueDel;

PROCEDURE PCFix(where,to,from:INTEGER);
VAR r:PCRecPtr; offVal:INTEGER;
BEGIN
  IF optiCode THEN
    r:=FindRef(where);
    IF r#NIL THEN
      WITH r^ DO
	pc1:=to; pc2:=from;
      END;
    END;
  END;
END PCFix;

(* geht davon aus, da aufsteigende 'where' kommen! *)
(* was ist bei forward-referenzen?? *)
PROCEDURE PCRef(where,to,from:INTEGER; add:LONGINT; size:WidType; cond:BYTE);
VAR r: PCRecPtr;
BEGIN
  IF optiCode THEN
    AllocHunkLev(r,SIZE(r^));
    WITH r^ DO
      pc:=where; pc1:=to; pc2:=from; off:=add; wid:=size; cc.b:=CAST(SHORTINT,cond);
    END;
    (* AddTail *)
    ASSEMBLE(
      LEA    pcr+4(A4),A0
      MOVE.L r(A5),A1
      MOVE.L 4(A0),A2
      MOVE.L A1,4(A0)
      MOVE.L A0,(A1)
      MOVE.L A2,4(A1)
      MOVE.L A1,(A2)
    END);
  END;
END PCRef;

(* NIEMALS $ E - !!! *)
PROCEDURE EnqueueRef(VAR list{8}:ExtRefList; e:ExtRefPtr);
(* sortiert nach typ,etyp,modnr,name*)
(*VAR old:ExtRefPtr;*)
BEGIN
  ASSEMBLE(
	MOVE.L	e(A5),A1
	(*LEA	codeRefs(A4),A0*)
	MOVE.B	ExtRef.typ(A1),D1
	MOVE.B	ExtRef.etyp(A1),D4
	MOVE.W	ExtRef.modnr(A1),D2
	MOVE.L	ExtRef.name(A1),D3
	MOVE.L	(A0),D0
sr:	MOVEA.L	D0,A0
	MOVE.L	(A0),D0
	BEQ.S	raus
	CMP.B	ExtRef.typ(A0),D1
	BLT.S	raus
	BGT.S	sr
	CMP.B	ExtRef.etyp(A0),D4
	BLT.S	raus
	BGT.S	sr
	CMP.W	ExtRef.modnr(A0),D2
	BLT.S	raus
	BGT.S	sr
	CMP.L	ExtRef.name(A0),D3
	BGT.S	sr
raus:	MOVE.L	4(A0),D0
	MOVE.L	A1,4(A0)
	MOVE.L	A0,(A1)
	MOVE.L	D0,4(A1)
	MOVE.L	D0,A0
	MOVE.L	A1,(A0)
  END);
END EnqueueRef;


PROCEDURE PutWord(w{7}:WORD);
(* put a 16-bit word into the codeBuff-buffer. *)
BEGIN
 IF NOT codeoverflow THEN
  ASSEMBLE(
(*  codeBuff.card[ip DIV 2]:=CAST(CARDINAL,w); INC(ip,2);*)
	LEA	codeBuff.card(A4),A0
	MOVE.W	ip(A4),D1
	MOVE.W	D7,0(A0,D1.W)
	ADDQ.W	#2,D1
	MOVE.W	D1,ip(A4)
(*  IF ip+cp>cMax THEN codeoverflow:=TRUE; Mark(8001); END;*)
(* IF ip>=codeBuffLen THEN err *)
	CMPI.W	#codeBuffLen,D1
	BGE.S	err8000
	LEA	chars(A4),A0 (* chars[0].cp =Offset 0 *)
	ADD.W	(A0),D1
	BVS.S	err8000
	CMPI.W	#cMax,D1
	BLE.S	noOvfl
err8000:ST	codeoverflow(A4)
	MOVE.W	#8001,-(A7)
	JSR	Mark(PC)
noOvfl:
  END);
  INC(wordcount);
  IF ((wordcount MOD 512)=0) & verbose THEN
    Write('.'); Flush;
  END;
 END;
END PutWord;

PROCEDURE PutLong(l{7}:LONGINT); (*$ EntryExitCode:=FALSE *)
(* put a 32-bit longword into the codeBuff-buffer. *)
BEGIN
 ASSEMBLE(
	SWAP	D7
	BSR	PutWord
	SWAP	D7
	BSR	PutWord
	RTS
 END);
END PutLong;

PROCEDURE DelLastBranch;
(* ip-4, letztes DeadEnd und PCRef weg! *)
BEGIN
  DEC(ip,4);
  SETREG(0,RemTail(ADR(del))); (* sicher einer da! *)
  SETREG(0,RemTail(ADR(pcr)));
END DelLastBranch;


PROCEDURE AddCodeReloc;
VAR e:ExtRefPtr;
BEGIN
  AllocHunkLev(e,SIZE(e^));
  e^.modnr:=AktHunk;
  e^.typ:=rel32;
  e^.pc:=ip;
  EnqueueRef(codeRefs,e);
END AddCodeReloc;


(* Dies Proc nicht exportieren! Immer direkt nach der Ablage im Buffer aufrufen! *)
PROCEDURE AddRelocs(VAR list:ExtRefList; VAR c:ConstValue; addi:INTEGER);
VAR
  rel{10}:CRelPtr;
  e:ExtRefPtr;
BEGIN
 IF (c.conRelocs#NIL)& ODD(LONGINT(c.conRelocs)) THEN
   BreakPoint(ADR("AddRelo ODD!!"));
 END;
  IF ~c.inMem THEN
    Mark(8014);
    RETURN
  END;
  IF c.modNr#0 THEN
    RETURN
  END; (* brauche ich nicht zu generieren!!!! *)
  rel:=c.conRelocs;
  WHILE rel#NIL DO
    AllocLev0(e,SIZE(e^));
    (*INC(rel^.conOffset,c.A);*) (* !! anpassen *) (*nein,hier nicht!*)
    e^.pc:=rel^.conOffset+addi;
    e^.modnr:=rel^.modnr;
    e^.typ:=ref32; (* oder auch dref32? *)
    e^.etyp:=rel^.etyp;
    e^.name:=rel^.name;
(* BreakPoint(ADR("in AddRelocs"));*)
    EnqueueRef(list,e);
    rel:=rel^.next;
  END;
END AddRelocs;

PROCEDURE PutValInConst(VAR c:ConstValue; VAR val:ConstValue; size,offset:INTEGER);
VAR
  src,dest:ADDRESS;
BEGIN
  IF ~c.inMem OR c.inBuff THEN (* darf noch nicht im Buffer sein! *)
    Mark(8015);
    RETURN
  END;
  dest:=ADR(c.heapCon^.buf);
  INC(dest,offset);
  IF (size<=0) OR ((size>4)&(size#8)) OR (size+offset>c.conSize) THEN
    Mark(8016);
    size:=1;
  END;
  IF size<=4 THEN
    src:=ADR(val.conLI);
    INC(src,4-size);
  ELSE
    src:=ADR(val.conLR);
  END;
  CopyMem(src,dest,size);
END PutValInConst;

PROCEDURE GetConstVal(VAR c:ConstValue; offset:INTEGER):LONGINT;
VAR
  src,dest:ADDRESS;
  val:LONGINT;
  size:INTEGER;
BEGIN
  IF ~c.inMem THEN (* zwar Unsinn, aber ... *)
    RETURN c.conLI
  END;
  val:=0;
  size:=c.conSize;
  src:=ADR(c.heapCon^.buf);
  INC(src,offset);
  IF (size<=0) OR (size>4) OR (size+offset>c.conSize) THEN
    Mark(8017);
    size:=1;
  END;
  dest:=ADR(val);
  INC(dest,4-size);
  CopyMem(src,dest,size);
  RETURN val;
END GetConstVal;

PROCEDURE PutConstInConst(VAR dest,with:ConstValue; offset:INTEGER);
VAR
  s,d:ADDRESS;
  orel,nrel:CRelPtr;
  size:INTEGER;
BEGIN
  IF ~dest.inMem OR dest.inBuff OR ~with.inMem THEN
    Mark(8018);
    RETURN
  END;
  size:=with.conSize;
  IF ~with.inBuff THEN
    s:=ADR(with.heapCon^.buf);
  ELSE
    s:=ADR(chars[with.modNr].buff^[with.buffOffset]); (* ACHTUNG: Pool! Nur bei 0 zugelassen *)
  END;
  d:=ADR(dest.heapCon^.buf);
  INC(d,offset);

  IF size+offset<=dest.conSize THEN
    CopyMem(s,d,size);
    orel:=with.conRelocs;
    WHILE orel#NIL DO
      (* Neuen erzeugen, conOffset anpassen, einlinken *)
(*BreakPoint(ADR("new nrel in coco"));*)
      AllocLev0(nrel,SIZE(nrel^));
      nrel^:=orel^;
      nrel^.next:=dest.conRelocs;
      dest.conRelocs:=nrel;
      INC(nrel^.conOffset,offset);
      orel:=orel^.next;
    END;
  ELSE
    Mark(8019); (* Const-Dekl. berlauf, Compilerfehler *)
  END;
END PutConstInConst;

PROCEDURE PutIniVar(VAR c:ConstValue; VAR offset:LONGINT);
(* Packe Const in IniBuffer, gebe offset fr vadr zurck *)
BEGIN
  IF c.inMem THEN
    IF (c.conSize>1)&ODD(iniOffset) THEN INC(iniOffset) END;
    IF Option[longWordAlign]&(c.conSize>=4) THEN
      INC(iniOffset,3);
      iniOffset:=(iniOffset DIV 4)*4;
    END;
    offset:=iniOffset;
    IF iniOffset+c.conSize<maxIniSize THEN
      CopyMem(ADR(c.heapCon^.buf),ADR(iniBuff^[iniOffset]),c.conSize);
      INC(iniOffset,c.conSize); (*RangeCheck!!*)
      AddRelocs(iniRefs,c,offset);
    ELSE
      Mark(8020); (* inBuffer overflow *)
    END;
  ELSE
    Mark(8021); (* mu memcon sein! Implemenbeschrnkung! *)
  END;
END PutIniVar;

PROCEDURE NewRef(mno,pc:INTEGER; name:Ident; typ:ExportTypes; wid:WidType);
VAR e:ExtRefPtr;
BEGIN
  AllocHunkLev(e,SIZE(e^));
  e^.pc:=pc;
  e^.modnr:=mno;
  e^.etyp:=typ;
  e^.name:=name;
  IF (typ=varref) OR (typ=noDHead) THEN e^.typ:=dref16 (* wid mu word sein!! *)
  ELSIF wid=byte THEN e^.typ:=ref8
  ELSIF wid=word THEN e^.typ:=ref16
  ELSE e^.typ:=ref32
  END;
  EnqueueRef(codeRefs,e);
END NewRef;

PROCEDURE ExportId(id:Ident; adr:INTEGER; typ:ExportTypes):ExtRefPtr;
(* id=NIL: keyhex, id<0: __main *)
VAR e:ExtRefPtr;
BEGIN
  AllocHunkLev(e,SIZE(e^));
  e^.typ:=def;
  e^.etyp:=typ;
  e^.modnr:=0;
  e^.pc:=adr; (* NICHT rel zum HunkStart!!!! *)
  e^.name:=id;
  EnqueueRef(codeRefs,e);
  RETURN e;
END ExportId;

PROCEDURE Define(typ:ExportTypes;id:Ident); (* immer mit 'Main_' *)
BEGIN
  SETREG(0,ExportId(id,ip,typ));
END Define;


(*$ EntryExitCode:=FALSE *)
PROCEDURE DeadEnd; (* nach rtx oder jmp oder bra *)
BEGIN
  ASSEMBLE(
	MOVE.W	ip(A4),-(A7)
	CLR.W	-(A7)
	BSR	Delete
	RTS
  END);
 (*Nicht, wenn schon eine Referenz hierher!*)
(*  Delete(ip,0);*)
END DeadEnd;

(*$ IF OneUnit *)
PROCEDURE Rel(pc:INTEGER;hunk:CARDINAL; wid:WidType);
VAR e:ExtRefPtr;
BEGIN
  AllocHunkLev(e,SIZE(e^));
  IF wid=byte THEN
    e^.typ:=rel8;
  ELSE
    e^.typ:=rel16 (* niemals rel32 *)
  END;
  e^.modnr:=hunk;
  e^.pc:=pc;
  EnqueueRef(codeRefs,e);
END Rel;
(*$ ENDIF *)

PROCEDURE PCRel(proc:ObjPtr); (* packt auch word in codeBuff! *)
(* PutWord(wohin-ip);*)
VAR hunk:CARDINAL; reladdr,wohin:INTEGER;
BEGIN
  IF proc^.pd^.implemented THEN
    wohin:=proc^.pd^.adr;
    IF wohin<HunkStart THEN (* fremder Hunk!! *)
(*$ IF OneUnit *)
      hunk:=WhichHunk(wohin,reladdr);
      Rel(ip,hunk,word);
      PutWord(reladdr);
(*$ ELSE *)
      IF proc^.pd^.exp THEN
        NewRef(0,ip,proc^.name,exported,word);
      ELSE
        NewRef(0,ip,CAST(Ident,LONGINT(proc^.pd^.num)),private,word)
      END;
      PutWord(0);
(*$ ENDIF *)
    ELSE
      PCRef(ip,wohin,ip,0,word,-1);
      PutWord(wohin-ip);
    END;
  ELSE (* nicht imple! *)
    IF proc^.pd^.forward THEN
      NewRef(0,ip,CAST(Ident,LONGINT(proc^.pd^.num)),private, word)
    ELSE
      NewRef(0,ip,proc^.name,exported,word);
    END;
    PutWord(0);
  END;
END PCRel;

PROCEDURE DiffPCRel(lab1,lab2:INTEGER); (* fr CASE *)
(* put16(lab1-lab2) *)
BEGIN
  PCRef(ip,lab1,lab2,0,word,-1);
  PutWord(lab1-lab2);
END DiffPCRel;

PROCEDURE ConstRel(mno,offs:INTEGER);
VAR e:ExtRefPtr;
BEGIN
  AllocHunkLev(e,SIZE(e^));
  e^.pc:=ip;
  IF mno=0 THEN
    PutWord(offs);
    e^.typ:=ref16;
  ELSE
    PutLong(offs);
    e^.typ:=ref32;
  END;
  e^.modnr:=mno;
  e^.etyp:=charref;
  EnqueueRef(codeRefs,e);
END ConstRel;

PROCEDURE DRel(mno,offs:INTEGER);
VAR e:ExtRefPtr;
BEGIN
  AllocHunkLev(e,SIZE(e^));
  e^.typ:=dref16;
  e^.etyp:=varref;
  e^.modnr:=mno;
  e^.pc:=ip;
  EnqueueRef(codeRefs,e);
  PutWord(offs);
END DRel;

PROCEDURE DIniRel(mno,offs:INTEGER);
VAR e:ExtRefPtr;
BEGIN
  AllocHunkLev(e,SIZE(e^));
  e^.typ:=dref16;
  e^.etyp:=iniref;
  e^.modnr:=mno;
  e^.pc:=ip;
  EnqueueRef(codeRefs,e);
  PutWord(offs);
END DIniRel;

PROCEDURE AbsData(mno:INTEGER;offs:LONGINT);
VAR e:ExtRefPtr;
BEGIN
  AllocHunkLev(e,SIZE(e^));
  e^.typ:=ref32;
  e^.etyp:=varref;
  e^.modnr:=mno;
  e^.pc:=ip;
  EnqueueRef(codeRefs,e);
  PutLong(offs);
END AbsData;

PROCEDURE AbsIniData(mno:INTEGER;offs:LONGINT);
VAR e:ExtRefPtr;
BEGIN
  AllocHunkLev(e,SIZE(e^));
  e^.typ:=ref32;
  e^.etyp:=iniref;
  e^.modnr:=mno;
  e^.pc:=ip;
  EnqueueRef(codeRefs,e);
  PutLong(offs);
END AbsIniData;

PROCEDURE AbsCode(mno:INTEGER; id:Ident; etyp:ExportTypes);
VAR e:ExtRefPtr;
BEGIN
  AllocHunkLev(e,SIZE(e^));
  e^.typ:=ref32;
  e^.etyp:=etyp;
  e^.name:=id;
  e^.modnr:=mno;
  e^.pc:=ip;
  EnqueueRef(codeRefs,e);
  PutLong(0);
END AbsCode;

PROCEDURE GetA4;
VAR e:ExtRefPtr;
BEGIN
  AllocHunkLev(e,SIZE(e^));
  e^.typ:=ref32;
  e^.etyp:=linkerDB;
  e^.modnr:=0; (* LinkerSymbol OHNE modul_! *)
  e^.pc:=ip;
  EnqueueRef(codeRefs,e);
  PutLong(0);
END GetA4;

PROCEDURE ExtCall(mno:INTEGER;id:Ident; etyp:ExportTypes);
VAR e:ExtRefPtr;
BEGIN
  IF mno#0 THEN
    PutWord(jsr+prel)
  ELSE
    PutWord(bsr);
  END;
  AllocHunkLev(e,SIZE(e^));
  e^.typ:=ref16;
  e^.etyp:=etyp;
  e^.modnr:=mno;
  e^.name:=id;
  e^.pc:=ip;
  EnqueueRef(codeRefs,e);
  PutWord(0);
END ExtCall;

PROCEDURE FCondBranch(cc:Condition; VAR to:INTEGER);
BEGIN
  IF cc#F THEN
    PCRef(ip+2,0,0,0,word,cc);
    PutWord(bra+CARDINAL(cc)*ls8); PutWord(to);
    to:=ip-2;
  END;
  IF cc=T THEN DeadEnd END;
END FCondBranch;


PROCEDURE BCondBranch(cc:Condition; to:INTEGER);
VAR d,reladdr:INTEGER; hunk:CARDINAL;
BEGIN
  d:=to-ip-2;
  IF (cc=T)&(to<HunkStart) THEN
(*$ IF OneUnit *)
    hunk:=WhichHunk(to,reladdr);
    (* 8.7.90/bp Schwerer Fehler, wenn reladdr>128, wg. MOD!! *)
    IF (d>=-128)&(reladdr<=126) THEN
      PutWord(bra+CAST(CARDINAL,reladdr-1) MOD 256);
      Rel(ip-1,hunk,byte);
    ELSE
      PutWord(bra);
      Rel(ip,hunk,word);
      PutWord(reladdr);
    END;
(*$ ELSE *)
    Mark(8889);
(*$ ENDIF *)
  ELSIF cc#F THEN
    IF d>=-128 THEN (* hier kein debug, weil niemals Proc-bergreifend*)
      PutWord(bra+CARDINAL(cc)*ls8+CAST(CARDINAL,d) MOD 256);
      PCRef(ip-1,to,ip,0,byte,cc);
    ELSE
      PutWord(bra+CARDINAL(cc)*ls8);
      PCRef(ip,to,ip,0,word,cc);
      PutWord(d);
    END;
  END;
  IF cc=T THEN DeadEnd END;
END BCondBranch;

PROCEDURE SubBranch(ob:ObjPtr); (* immer rckwrts! *)
VAR d,reladdr,to:INTEGER; hunk:CARDINAL;
    (*$ IF NOT OneUnit *) id:Ident; cl:ExportTypes; (*$ ENDIF *)
BEGIN
(*$ IF NOT OneUnit *)
  IF ob^.class=Module THEN
    id:=CAST(Ident,LONGINT(-ob^.mmod));
    to:=ob^.mpc;
    cl:=private;
  ELSIF ob^.pd^.exp THEN
    id:=ob^.name;
    to:=ob^.pd^.adr;
    cl:=exported;
  ELSE
    id:=CAST(Ident,LONGINT(ob^.pd^.num));
    to:=ob^.pd^.adr;
    cl:=private;
  END;
  d:=to-ip-2;
  IF to<HunkStart THEN (* fremder Hunk!! *)
  (* fr blink keine 8er relocs und refs! DOCH!! *)
    IF d>=-128 THEN
      PutWord(bsr+0FFH);
      NewRef(0,ip-1,id,cl,byte);
    ELSE
   (**)
      PutWord(bsr);
      NewRef(0,ip,id,cl,word);
      PutWord(0);
   (**)
    END;
   (**)
  ELSE (* lokale Proc bleibt so *)
    IF (d>=-128) & ~optiCode THEN
      PutWord(bsr+CAST(CARDINAL,d) MOD 256);
      (*PCRef(ip-1,to,ip,0,byte,F);*)
    ELSE (* wird nachher wegoptimiert! *)
      PutWord(bsr);
      PCRef(ip,to,ip,0,word,F); (* bsr=bf *)
      PutWord(d);
    END;
  END;
(*$ ELSE *)
  IF ob^.class=Module THEN to:=ob^.mpc ELSE to:=ob^.pd^.adr END;
  d:=to-ip-2;
  IF to<HunkStart THEN (* fremder Hunk!! *)
    hunk:=WhichHunk(to,reladdr);
    (* 8.7.90/bp siehe BCondBranch!! *)
    IF (d>=-128)&(reladdr<=126) THEN
      PutWord(bsr+CAST(CARDINAL,reladdr-1) MOD 256);
      Rel(ip-1,hunk,byte);
    ELSE
      PutWord(bsr);
      Rel(ip,hunk,word);
      PutWord(reladdr);
    END;
  ELSE (* lokale Proc bleibt so *)
    IF (d>=-128) & ~optiCode THEN
      PutWord(bsr+CAST(CARDINAL,d) MOD 256);
      (*PCRef(ip-1,to,ip,0,byte,F);*)
    ELSE (* wird nachher wegoptimiert! *)
      PutWord(bsr);
      PCRef(ip,to,ip,0,word,F); (* bsr=bf *)
      PutWord(d);
    END;
  END;
  (*$ ENDIF *)
END SubBranch;

(* mssen in aufsteigender Folge kommen! *)
PROCEDURE Delete(wo, wievielByte:INTEGER); (* lscht *)
VAR d:DeletionPtr; i,min,max:INTEGER; e:ExtRefPtr;
BEGIN
 IF ~codeoverflow THEN
  IF optiCode THEN
    IF (wievielByte#0)OR(wo>HunkStart) THEN
      d:=FindDel(wo);
      IF d=NIL THEN
        AllocHunkLev(d,SIZE(d^));
        WITH d^ DO
          where:=wo; count:=wievielByte;
        END;
        EnqueueDel(d,del);
      ELSE
        i:=Max(ABS(d^.count),wievielByte);
        WITH d^ DO
          IF (count<=0) OR (wievielByte=0) THEN
            count:=-i
          ELSE
            count:=i
          END;
        END;
      END;
    END;
  ELSE
    FOR i:=wo DIV 2 TO ((wo+wievielByte) DIV 2)-1 DO codeBuff.card[i]:=nop END;
    (* Normales Delete vom Compiler kann sein:
        a) StackCheck ganz weg
        b) stckcheck auf moveq
        c) movem halb oder ganz
        d) link weg
        e) lea _linkerdb weg
      dabei hat nur a eine referenz, nmlich auf Art_StackCheck
      Diese mu auf jeden Fall auch weg!
    *)
    IF wievielByte>4 THEN
      min:=wo; max:=wo+wievielByte;
      e:=codeRefs.head;
      WHILE e^.succ#NIL DO
	IF (e^.typ#def)&(e^.pc>=min)&(e^.pc<max) THEN Remove(e) END;
	e:=e^.succ;
      END;
    END;
  END;
 END;
END Delete;

PROCEDURE DelQuick(wo,wievielByte:INTEGER);
(* ohne Lschung mit NOPs, ohne Check auf debug *)
VAR d:DeletionPtr; maxV:INTEGER;
BEGIN
  d:=FindDel(wo);
  IF d=NIL THEN
    AllocHunkLev(d,SIZE(d^));
    WITH d^ DO
      where:=wo; count:=wievielByte;
    END;
    EnqueueDel(d,del);
  ELSE
    WITH d^ DO
      maxV:=Max(ABS(count),wievielByte);
      IF (count<=0) OR (wievielByte=0) THEN (* ist oder war deadEnd! *)
        count:=-maxV
      ELSE
        count:=maxV
      END;
    END;
  END;
END DelQuick;

PROCEDURE CleanRefs():INTEGER; (* wieviele nun gelscht *)
(* alle refs und auch Relocs, die in einem Del-Bereich liegen: weg! *)
(* Nur zu Beginn, nachher immer gleich weglschen! *)
VAR d:DeletionPtr; r:PCRecPtr; l:ExtRefPtr;
    adr1,adr2,cnt:INTEGER;
BEGIN
  d:=del.head;
  r:=pcr.head;
  cnt:=0;
  WHILE d^.succ#NIL DO
    IF d^.count#0 THEN
      adr1:=d^.where; adr2:=adr1+ABS(d^.count);
      WHILE (r^.succ#NIL) & (r^.pc<adr1) DO r:=r^.succ END;
      WHILE (r^.succ#NIL) & (r^.pc<adr2) DO
        Remove(r); r:=r^.succ; INC(cnt);
      END;

      l:=codeRefs.head;
      WHILE (l^.succ#NIL) DO
        IF (l^.typ#def)&(l^.pc>=adr1)&(l^.pc<adr2) THEN Remove(l) END;
        l:=l^.succ
      END;
    END;
    d:=d^.succ
  END;
  RETURN cnt;
END CleanRefs;

PROCEDURE CleanDeads;
VAR d:DeletionPtr; anz:INTEGER;
(* deadEnds, die keine sind:lschen. Nur zu Beginn! 2mal!! *)
BEGIN
  d:=del.head;
  WHILE d^.succ#NIL DO
    WITH d^ DO
      IF count<=0 THEN
        anz:=where-NextRef(where); (* negativer Wert!! *)
        IF anz<count THEN count:=anz END;
        (* IF count=0 THEN Remove(d) END;*)
      END;
      d:=succ;
    END;
  END;
END CleanDeads;

PROCEDURE NextRec(r:PCRecPtr; to:INTEGER):PCRecPtr;
BEGIN
  IF r^.succ#NIL THEN r:=r^.succ END;
  WHILE r^.succ#NIL DO
    IF r^.pc1=to THEN RETURN r
    ELSE r:=r^.succ
    END
  END;
  RETURN NIL
END NextRec;

PROCEDURE CheckJumps;
(* alle Bcc +4 BRA xx --> Bncc xx, wenn:
   sonst keine Ref auf +4
   alle bra XX BRA YY --> bra yy weg und referenzen umleiten, wenn mglich
*)
VAR r,t:PCRecPtr; candel,afterjump:BOOLEAN; aktPc,minDelete,i:INTEGER;
    value:LONGINT;
BEGIN
  (* jump0 umleiten *)
(*noch proc-sprnge!!*)
  r:=pcr.tailPred;
  WHILE (r^.pred#NIL) (*&(r^.pred^.pred#NIL)*) DO
    WITH r^ DO (* bra xx bra yy --> bra xx die nach yy umleiten, wenn mglich *)
      IF (cc.cond=T) THEN
        t:=CAST(PCRecPtr,ADR(pcr));
        aktPc:=pc2-2; (* start dieses Sprungs *)
        minDelete:=(INTEGER(wid)+1)*2; (* bei byte:2 sonst: 4 *)
        candel:=TRUE;
        REPEAT (* alle SPRUNG-Referenzen suchen und umleiten *)
	  t:=NextRec(t,aktPc);
	  IF (t#NIL) THEN
	    IF t^.cc.b>=0 THEN
	      IF (t^.wid>byte) THEN
	        t^.pc1:=pc1; (* Umleiten! *)
	      ELSE (* short-Reference kann nie wieder long werden! *)
	        value:=pc1-t^.pc2+t^.off;
	        IF (value>=-128)&(value<=127) THEN
	          t^.pc1:=pc1
	        ELSE
	          candel:=FALSE; (* kann dann nicht gelscht werden! *)
	        END;
	      END;
	    ELSE
	      candel:=FALSE; (* kein sprung oder bsr! *)
	    END;
	  END;
	UNTIL t=NIL;
	IF pred^.pred#NIL THEN
	  (* direkt vor mir cc-Sprung direkt hinter mich? *)
	  afterjump:=(pred^.pc+INTEGER(pred^.wid)+1=aktPc) & (pred^.cc.b>=2)
		   & (pred^.pc1=aktPc+minDelete);
	ELSE
	  afterjump:=FALSE
	END;
	candel:=candel&(afterjump OR IsDead(aktPc) OR (aktPc=HunkStart));
	IF candel&afterjump THEN
	  pred^.cc.cond:=InvertCC(pred^.cc.cond);
	  (* cond in code ndern! *)
	  codeBuff.si[pred^.pc-INTEGER(pred^.wid)-1]:=60H+ORD(pred^.cc.cond);
	  pred^.pc1:=pc1;
	  IF pred^.wid=byte THEN
	    value:=pc1-pred^.pc2+pred^.off;
	    IF (value<-128) OR (value>127) THEN (* noch optimierbar! *)
	      DEC(minDelete,2); (* nicht soviel lschen *)
	      INC(aktPc,2);
	      INC(pred^.pc); pred^.wid:=word;
	    END;
	  END;
	END;
	IF candel THEN
          IF minDelete>0 THEN DelQuick(aktPc,minDelete) END;
          Remove(r);
        END; (* if ~short *)
      END; (* if bcc bra *)
      r:=pred;
    END;
  END;
END CheckJumps;


PROCEDURE ConcatDels;
VAR d:DeletionPtr;
(* Deletions zusammenfassen *)
BEGIN
  d:=del.head;
  WHILE (d^.succ#NIL) DO
    WITH d^ DO
      WHILE (succ^.succ#NIL) & (succ^.where<(where+ABS(count))) DO
        count:=Max(where+ABS(count),succ^.where+ABS(succ^.count))-where;
        Remove(succ);
      END;
      d:=succ;
    END;
  END;
END ConcatDels;

PROCEDURE DoDeletions():LONGINT;
VAR d:DeletionPtr; r:PCRecPtr; l:ExtRefPtr; VAR deleted:LONGINT;
    anf,versch,bytes,i,src,dst:INTEGER;
BEGIN
  ConcatDels;
  deleted:=0;
  d:=del.tailPred; (* rckwrts!! *)
  WHILE d^.pred#NIL DO
    WITH d^ DO
      anf:=where; dst:=where; bytes:=ABS(count); src:=where+bytes;
      versch:=ip-src;
      DEC(ip,bytes);
      INC(deleted,bytes);
    END;
    (* 1. Code verschieben *)
    (* bytes zu verschieben = ip-(where+bytes) *)
    ASSEMBLE(
	LEA	codeBuff(A4),A0
	MOVE.L	A0,A1
	ADDA.W	dst(A5),A0
	ADDA.W	src(A5),A1
	MOVE.W	versch(A5),D0
	BLE.S	raus
	(* kann ruhig hinten berhngen, also DEC entfllt! *)
	ASR.W	#2,D0 (* /4 = Anzahl LangWorte *)
    lp:	MOVE.L	(A1)+,(A0)+ (* noch auf .L optimieren! Ok *)
	DBRA	D0,lp
    raus:
    END);
    (* 2. Relocs, jumps und PCRecs anpassen *)
    ASSEMBLE(
	MOVE.L	pcr.head(A4),A0
	MOVE.W	anf(A5),D0
	EXT.L	D0
	MOVE.W	bytes(A5),D1
	EXT.L	D1
next:	MOVE.L	(A0),D2 (* next *)
	BEQ.S	rdy
	CMP.W	PCRec.pc(A0),D0
	BGE.S	Nopc
	SUB.W	D1,PCRec.pc(A0)
Nopc:	CMP.W	PCRec.pc1(A0),D0
	BGE.S	Nopc1
	SUB.W	D1,PCRec.pc1(A0)
Nopc1:	CMP.W	PCRec.pc2(A0),D0
	BGE.S	Nopc2
	SUB.W	D1,PCRec.pc2(A0)
Nopc2:	MOVE.L	D2,A0
	BRA.S	next

rdy:	MOVE.L	codeRefs.head(A4),A0
next2:	MOVE.L	(A0),D2
	BEQ.S	rdy2
	CMP.W	ExtRef.pc(A0),D0
	BGE.S	Norel
	SUB.W	D1,ExtRef.pc(A0)
Norel:	MOVE.L	D2,A0
	BRA.S	next2

rdy2:
	(* Remove(d) *)
	MOVE.L	d(A5),A1
	MOVE.L	(A1),A0
	MOVE.L	4(A1),A1 (* pred!! *)
	MOVE.L	A0,(A1)
	MOVE.L	A1,4(A0)
	(* d:=d^.pred *)
	MOVE.L	A1,d(A5)
  END);
(*
    r:=pcr.head;
    WHILE r^.succ#NIL DO
      WITH r^ DO
        IF (pc>anf) THEN DEC(pc,bytes) END;
        IF (pc1>anf) THEN DEC(pc1,bytes) END;
        IF (pc2>anf) THEN DEC(pc2,bytes) END;
        r:=succ;
      END;
    END;
    l:=codeReloc.head;
    WHILE l^.succ#NIL DO
      WITH l^ DO
        IF (pc>anf) THEN DEC(pc,bytes) END;
        l:=succ
      END;
    END;
    Remove(d);
    d:=d^.pred;
*)
  END;
  INC(ProgDeleted,deleted);
  RETURN deleted;
END DoDeletions;


PROCEDURE OptiJumps;
VAR r:PCRecPtr; bVal:INTEGER;
BEGIN
(*BreakPoint(ADR('OptiJumps'));*)
  r:=pcr.head;
  WHILE r^.succ#NIL DO
    WITH r^ DO
      IF (cc.b>=0) THEN
        bVal:=pc1-pc2+off;
        IF (bVal=0)&(wid=byte) THEN
          DelQuick(pc-1,2);
          Remove(r);
        ELSIF (wid>byte) & (bVal>=-128) & (bVal<127) THEN
          IF bVal=2 THEN
            DelQuick(pc-2,4);
            Remove(r)
          ELSE
            DelQuick(pc,2);
            wid:=byte;
            DEC(pc);
          END;
        END;
      END;
      r:=succ;
    END;
  END;
END OptiJumps;

PROCEDURE RebuildCode;
TYPE CaseVal = RECORD
       CASE :INTEGER OF
       |0: l:LONGINT;
       |1: c1,c2:CARDINAL;
       |2: b1,b2,b3,b4:CHAR
       END
     END;
     CP = POINTER TO CaseVal;
VAR  r:PCRecPtr;
     value:CaseVal;
     p:CP;
BEGIN
(*BreakPoint(ADR('Rebuild'));*)
  r:=pcr.head;
  WHILE r^.succ#NIL DO
    WITH r^ DO
      p:=ADR(codeBuff.si[pc]);
      value.l:=off+pc1-pc2;
      IF wid=byte THEN (* Es MUSS in 1 Byte passen! *)
        p^.b1:=value.b4;
      ELSIF wid=word THEN (* MUST BE EVEN!!! *)
        p^.c1:=value.c2;
      ELSE
        p^.l:=value.l
      END;
      r:=succ;
    END;
  END;
END RebuildCode;

PROCEDURE Optimize;
(* das wird hart!! *)
VAR r: PCRecPtr; e:ExtRefPtr; d:DeletionPtr; deleted:LONGINT;
BEGIN
(*
 0) wenn 1.=sprung, dann proc^.pd^.adr anpassen
 c) Bcc + BRA --> Bncc
 a) wenn Lschungen weg: goto f (exit)
    sonst:
    Dummy-refs lschen: x,0,0,0,w,T (von Proc-Entrys)
    DeadEnd abchecken, aber vorher Main- und Def-Prozeduren merken!
    Alle PCRefs und Relocs in gelschten Bereichen lschen
 b) alle Lschungen ausfhren, auch Code bewegen! Alles umrechnen!
 d) BRA auf BRA direkt umleiten, wenn mglich (Vorsicht bei short-Referenzen)
    Wenn sonst keiner mehr auf diesen bra: bra lschen
 e) goto a
 f) alle rels in code anpassen
 g) neuen ip setzen!
*)
 IF verbose THEN
   (*
   WriteString('\nOptimizing..\n');
   *)
   Write('o'); Flush;
 END;
 (* 1.: ungefixte refs lschen (von Proc-Entries) *)
(* BreakPoint(ADR('opti!!'));*)
  r:=pcr.head;
  WHILE r^.succ#NIL DO
    WITH r^ DO
      IF (pc1=0) & (pc2=0) & (off=0) & (cc.cond=T) THEN (* ungltig BRA xx *)
	Remove(r);
      END;
      r:=succ; (* bleibt ja stehen trotz Remove *)
    END;
  END;

  (* 2. DeadEnds auswerten *)
  REPEAT
    (*WriteString('CleanDeadEnds.. ');*)
    CleanDeads; (* solche, die ganz klar KEINE sind: weg! *)
    (*WriteString('CleanRefs\n');*)
  UNTIL CleanRefs()=0;

  (* 4.: Optimiere unntige Branches! *)
  REPEAT
    (*WriteString('CheckJumps.. ');*)
    CheckJumps;
    (*WriteString('Delete.. ');*)
    deleted:=DoDeletions();
    (*
    IF verbose THEN
      FormatNr('%ld Bytes\n',deleted);
    END;
    *)
  UNTIL deleted=0;
  (* 5. Optimiere lange Branches *)
  REPEAT
    (*WriteString('OptiJumps..  ');*)
    OptiJumps;
    (*WriteString('Delete.. ');*)
    deleted:=DoDeletions();
    (*
    IF verbose THEN
      FormatNr('%ld Bytes\n',deleted);
    END;
    *)
  UNTIL deleted=0;

  (*WriteString('RebuildCode\n');*)
  RebuildCode; (* alle Sprnge und Referenzen wieder herstellen! *)
END Optimize;

PROCEDURE WRel(type:RefTypes; kenn:LONGINT; VAR e:ExtRefPtr);
VAR i,cnt,hnr:INTEGER; help:ExtRefPtr; head:BOOLEAN;
BEGIN
  head:=FALSE;
  WHILE (e^.succ#NIL)&(e^.typ=type) DO
    IF ~head THEN WL(kenn); head:=TRUE END;
    hnr:=e^.modnr; (* hunknr! *)
    cnt:=0;
    help:=e;
    WHILE (e^.succ#NIL)&(e^.typ=type)&(e^.modnr=hnr) DO
      INC(cnt); e:=e^.succ;
    END;
    WL(cnt); WL(hnr);
    FOR i:=1 TO cnt DO WL(help^.pc-HunkStart); help:=help^.succ END;
  END;
  IF head THEN WL(0) END;
END WRel;

PROCEDURE WDefs(VAR e:ExtRefPtr);
BEGIN
  WHILE (e^.succ#NIL)&(e^.typ=def) DO
    GenName(e);
    WName(1); (* extDef *)
    WL(e^.pc-HunkStart);
    e:=e^.succ;
  END;
END WDefs;

PROCEDURE WRefs(VAR e:ExtRefPtr);
VAR help:ExtRefPtr; mnr,i,cnt:INTEGER; type:RefTypes; eTyp:ExportTypes;id:Ident;
BEGIN
  WHILE (e^.succ#NIL) DO
    GenName(e);
    type:=e^.typ; mnr:=e^.modnr; id:=e^.name; eTyp:=e^.etyp;
    CASE type OF
    | ref32: WName(129);
    | ref16: WName(131);
    | ref8:  WName(132);
    | dref16:WName(134);
    END;
    cnt:=0;
    help:=e;
    WHILE (e^.succ#NIL)&(e^.typ=type)&(e^.etyp=eTyp)&(e^.modnr=mnr)&(e^.name=id) DO
      INC(cnt);
      e:=e^.succ;
    END;
    WL(cnt);
    FOR i:=1 TO cnt DO WL(help^.pc-HunkStart); help:=help^.succ END;
  END;
END WRefs;

PROCEDURE OutHunk(fast:BOOLEAN);
VAR lenLws, len:LONGINT; e:ExtRefPtr; done:BOOLEAN;
BEGIN
  len:=ip-HunkStart; (* ist sicher auf Lw!! *)
  lenLws:=len DIV 4;

(*$ IF NOT OneUnit *) (* jeder Hunk eine Unit *)
  IdentToStr(MainName,0C);
  WL(999);
  WName(0);
(*$ ENDIF *)

  WL(1000); (* name *)
  WL(1);
  WL(CAST(LONGINT,textString));
  IF ~fast THEN
    WL(1001+chipBit);
  ELSE
    WL(1001);
  END;
  WL(lenLws);
  WC(ADR(codeBuff.si[HunkStart]),len);

  (* refs, defs! relocs, drels *)
  e:=codeRefs.head;
  (* 1. hunk reloc8, 16, 32 *)
  WRel(rel32,1004,e);
  WRel(rel16,1005,e);
  WRel(rel8,1006,e);
  (* 2. hunk ext, darin den Rest. *)
  done:=FALSE;
  IF e^.succ#NIL THEN WL(1007); done:=TRUE END;
  WDefs(e);
  WRefs(e);
  IF done THEN WL(0) END;
  WL(1010); (* hunkEnd *)
END OutHunk;

PROCEDURE EndHunk(proc:ObjPtr; isimp,fast:BOOLEAN);
(* sicher der richtige Level! Kann Glob-Proc oder Module sein!! *)
VAR h:HunkPtr; e:ExtRefPtr;
BEGIN
  IF proc^.class=Proc THEN
    WITH proc^.pd^ DO
      IF optiCode & (pcr.head^.succ#NIL)
         &(pcr.head^.cc.cond=T)&(pcr.head^.pc=HunkStart+2) THEN
        adr:=pcr.head^.pc1; (* adr ist das Sprungziel! *)
      END;
      (*size:=ip-adr; hier evtl noch mehr!*)
      IF exp THEN
        e:=ExportId(proc^.name,adr,exported);
      ELSE
        e:=ExportId(CAST(Ident,LONGINT(num)),adr,private)
      END;
    END;
  ELSIF proc^.class=Module THEN
    IF proc^.compmod=0 THEN
      IF isimp THEN
        e:=ExportId(NIL,proc^.mpc,openmod);
      ELSE
        e:=ExportId(NIL,proc^.mpc,main);
      END;
  (*$ IF NOT OneUnit *)
    ELSE
      e:=ExportId(CAST(Ident,LONGINT(-proc^.mmod)),proc^.mpc,private);
  (*$ ENDIF *)
    END;
  ELSE
    Mark(8007);
  END;
  IF optiCode THEN
     Optimize;
     IF proc^.class=Proc THEN
        proc^.pd^.adr:=e^.pc
     ELSIF (proc^.class=Module)&(proc^.compmod=0) THEN
        proc^.mpc:=e^.pc
     END;
  END;
  IF (ip MOD 4)#0 THEN PutWord(nop) END; (* auf Langwort *)
  OutHunk(fast);
  ResetHunkHeap;

  NewList(CAST(List,pcr));
  NewList(CAST(List,del));
  NewList(CAST(List,codeRefs));

  AllocLev0(h,SIZE(h^));
  h^.nr:=AktHunk; h^.start:=HunkStart;
  AddTail(ADR(hunks),h);
  INC(AktHunk);
  HunkStart:=ip;
END EndHunk;

PROCEDURE FindString(id:Ident;mNo:INTEGER):LONGINT;
TYPE
  TR=POINTER TO SHORTINT;
VAR
  searchLen,i:INTEGER;
  p,p2{8},s,s2{9}:TR;
  end:LONGINT;
BEGIN
  searchLen:=id^.len;
  WITH chars[mNo] DO
    IF buff=NIL THEN RETURN -1 END;
    p:=CAST(TR,buff);
    s:=ADR(id^.buf[0]);
    end:=CAST(LONGINT,ADR(buff^[cp]))-searchLen;
  END;
  LOOP
    IF searchLen>0 THEN
      WHILE (p^#s^) & (CAST(LONGINT,p)<end) DO INC(p,2) END;
       (* wir bleiben EVEN!*)
      IF CAST(LONGINT,p)>=end THEN RETURN -1 END;
      p2:=p; s2:=s; i:=1;
      REPEAT
        INC(p2); INC(s2); INC(i)
      UNTIL (p2^#s2^) OR (i>searchLen);
    ELSE
      i:=1;
      p2:=p; s2:=s;
    END;
    IF i>searchLen THEN (* soweit ok, nun Rest vergleichen! *)
      IF p2^=0 THEN
(*BreakPoint(ADR("Found old String!!"));*)
        RETURN CAST(LONGINT,p)-CAST(LONGINT,chars[mNo].buff);
      END;
    END;
    INC(p,2); (* Start nur auf geraden! *)
  END;
END FindString;

(* Buffer fr mNo vergrern *)
PROCEDURE NewBuff(mNo:INTEGER; add:INTEGER);
VAR
  std,newSize:INTEGER;
  newBuff:ConBuffPtr;
BEGIN
  WITH chars[mNo] DO
    IF mNo=0 THEN std:=ownAdd ELSE std:=foreignAdd END;
    newSize:=size;
    REPEAT
      INC(newSize,std);
    UNTIL newSize>=cp+add;
    Storage.ALLOCATE(newBuff,newSize);
    IF cp>0 THEN
      CopyMem(buff,newBuff,cp);
      Storage.DEALLOCATE(buff,size);
    END;
    size:=newSize;
    buff:=newBuff;
  END;
END NewBuff;

PROCEDURE AllocString(s: Ident; VAR c:ConstValue; toBuff:BOOLEAN);
(* allocate a string-constant. *)
VAR
  l,addi:INTEGER;
  a:ADDRESS;
BEGIN
  l:=s^.len;
  c.conSize:=l;
  c.inMem:=TRUE;
  IF toBuff THEN
    IF c.heapCon#s THEN (* wird FRISCH  alloziert! *)
      AllocLev0(a,l+2);
      CopyMem(s,a,l+2);
      c.heapCon:=a;
      c.conRelocs:=NIL;
    END;
    WITH chars[c.modNr] DO
      c.inBuff:=TRUE;
        (*
         * Sobald Relocs vorhanden sind oder hineinkommen,
	 * wird nicht mehr optimiert, weil ja noch unrelozierte Werte
	 * drinstehen, die zur Laufzeit nicht mehr stimmen!!
	 *)
      IF (c.modNr=0) & ((c.conRelocs#NIL) OR (constRefs.head^.succ#NIL)) THEN
	c.buffOffset:=-1;
      ELSE
        c.buffOffset:=FindString(s,c.modNr);
      END;
      IF c.buffOffset<0 THEN (* nicht gefunden, neu allozieren *)
        IF ODD(l) THEN addi:=l+1 ELSE addi:=l+2 END;
        IF cp+addi>size THEN
	  NewBuff(c.modNr,addi);
	END;
	c.buffOffset:=cp;
(*$ IF Demo *)
        IF cp+l <1000 THEN
(*$ ELSE *)
        IF ip+cp+l < cMax THEN
(*$ ENDIF *)
          CopyMem(ADR(s^.buf),ADR(buff^[cp]),l);
          buff^[cp+l]:=0C;
          INC(cp,addi);
        ELSIF NOT codeoverflow THEN
          codeoverflow:=TRUE;
          Mark(8002);
        END;
      END; (* neu alloc *)
    END; (* with chars[ *)
    AddRelocs(constRefs,c,c.buffOffset);
  ELSE (* inHeap *)
    c.inBuff:=FALSE;
    AllocLev0(a,l+2);
    CopyMem(s,a,l+2);
    c.heapCon:=a;
    c.conRelocs:=NIL;
    (* c.mNo bleibt! *)
  END;
END AllocString;

PROCEDURE AllocConstHeap(VAR c:ConstValue; size:INTEGER);
VAR
  id:Ident;
BEGIN
  AllocLev0(id,size+2);
  id^.len:=size;
  c.heapCon:=id;
  c.modNr:=0;
  c.conSize:=size;
  c.inMem:=TRUE;
  c.inBuff:=FALSE; (* Rest ist 0 *)
  c.conRelocs:=NIL;
  c.buffOffset:=0;
END AllocConstHeap;

PROCEDURE PutInBuffer(VAR c:ConstValue);
BEGIN
  IF ~c.inMem THEN
    Mark(8022);
    RETURN
  END;
  IF ~c.inBuff THEN
    AllocString(c.heapCon,c,TRUE);
  END;
END PutInBuffer;

PROCEDURE EatThisConst(VAR c:ConstValue);
BEGIN
  c.modNr:=0;
  PutInBuffer(c);
END EatThisConst;

(* Achtung bei Mischung inHeap,~inHeap! result=~inHeap! *)
PROCEDURE AppendString(VAR a,b:ConstValue);
VAR new:Ident; i:INTEGER;
BEGIN
  AllocLev0(new,a.conSize+b.conSize+2);
  CopyMem(a.heapCon,new,a.conSize+2);
  new^.len:=a.conSize+b.conSize;
  CopyMem(ADR(b.heapCon^.buf),LONGINT(new)+2+a.conSize,b.conSize);
  a.heapCon:=new;
  a.conSize:=new^.len;
  a.inBuff:=FALSE;
  a.modNr:=0;
END AppendString;

PROCEDURE AllocChar(ch:CHAR; VAR c:ConstValue; toBuff:BOOLEAN);
(* allocate a character-constant. *)
VAR id:RECORD len:INTEGER; buf:ARRAY[0..1] OF CHAR END;
BEGIN
 id.len:=1;
 id.buf[0]:=ch;
 c.modNr:=0;
 c.inMem:=TRUE;
 c.conRelocs:=NIL;
 AllocString(ADR(id),c,toBuff);
END AllocChar;



PROCEDURE fixup(loc:INTEGER);
(* enter 16-bit displacement at loc. *)
VAR
 x:INTEGER;
BEGIN
 IF codeoverflow THEN RETURN END;
 x:=ip-loc; (* forward distance in bytes *)
(*
 * 5.8.89/ms
 *   Diese Optimierung produziert tatschlich Probleme in IF-ELSIF-ELSE-END
 *   Strukturen. In M2CM habe ich aber lokal im GetReturn eine Elimination
 *   von BRA 2 eingebaut. Beim fixup mssen nun zu kleine Vorwrtssprnge
 *   ignoriert werden. Der kleinste, erlaubte Sprung ist 2.
 *
 * No, because of problems with ELSIF:
 * IF (x=2) & (BITSET(codeBuff.i[loc DIV 2-1])*{12..15}={13,14}) THEN
 *  ip:=ip-4;
 * ELSE
 *)
 IF x>=2 THEN
  codeBuff.card[loc DIV 2]:=x;
  PCFix(loc,ip,loc);
 END;
 AllRegsDestroyed;
END fixup;

PROCEDURE FixShort(loc:INTEGER);
(* enter 8-bit displacement at loc. *)
VAR
 x:INTEGER;
BEGIN
 IF codeoverflow THEN RETURN END;
 x:=ip-loc-2; (* forward distance in bytes *)
 codeBuff.si[loc+1]:=x;
 PCFix(loc+1,ip,loc+2);
END FixShort;

PROCEDURE FixShortWith(loc: INTEGER; val:CHAR);
(* enter 8-bit!! value val at loc *)
BEGIN
 IF ~codeoverflow THEN
   codeBuff.si[loc]:=CAST(SHORTINT,val);
 END;
END FixShortWith;

PROCEDURE FixLink(l:INTEGER);
VAR
 l1:INTEGER;
BEGIN
 IF codeoverflow THEN RETURN END;
 WHILE (l>0) & (l<codeBuffLen) DO
  l1:=CAST(INTEGER,codeBuff.card[l DIV 2]);
  fixup(l);
  l:=l1;
 END;
END FixLink;

PROCEDURE FixupWith(loc:INTEGER; val:INTEGER);
(* enter 16-bit value disp at loc. *)
BEGIN
 (* HIER kein PCFix, da auch fr nops und anderes benutzt!!! *)
 IF codeoverflow THEN RETURN END;
 codeBuff.card[loc DIV 2]:=CAST(CARDINAL,val); (*??? Why negativ jumps ???*)
END FixupWith;

PROCEDURE GetWord(loc{0}:INTEGER):WORD;
BEGIN
  RETURN codeBuff.card[loc DIV 2]
END GetWord;

PROCEDURE FixLinkWith(l,val:INTEGER);
VAR
 l1:INTEGER;
BEGIN
 IF codeoverflow THEN RETURN END;
 WHILE (l>0) & (l<codeBuffLen) DO
  l1:=CAST(INTEGER,codeBuff.card[l DIV 2]);
  FixupWith(l,val-l); (* forward distance *)
  PCFix(l,val,l);
  l:=l1;
 END;
END FixLinkWith;

PROCEDURE MergedLinks(l0,l1:INTEGER):INTEGER;
(* merge chain of the 2 operands of AND and OR. *)
VAR
 l2,l3:INTEGER;
BEGIN
 IF codeoverflow THEN RETURN 0 END;
 IF l0#0 THEN
    (* Search end of chain l0 *)
  l2:=l0;
  LOOP
   l3:=CAST(INTEGER,codeBuff.card[l2 DIV 2]);
   IF l3=0 THEN EXIT END;
   l2:=l3;
  END;
  (* let the last entry of chain l0 point to chain l1 *)
  codeBuff.card[l2 DIV 2]:=CAST(CARDINAL,l1); (* KEIN PCFix, da immer noch Forward!! *)
  RETURN l0;
 ELSE
  RETURN l1
 END;
END MergedLinks;


PROCEDURE InitM2LM;
VAR i:INTEGER;
BEGIN
 FOR i:=0 TO maxM2 DO
   WITH chars[i] DO
     IF buff#NIL THEN Storage.DEALLOCATE(buff,size); buff:=NIL END;
     size:=0;
     cp:=0;
   END;
 END;
 (*
 Storage.ALLOCATE(chars[0].buff,ownAdd);
 chars[0].size:=ownAdd;
 *)
 ProgDeleted:=0;
 ResetHunkHeap;
 hunkHeap:=NIL;
 ip:=0; wordcount:=0;
 AktHunk:=0; HunkStart:=0;
 codeoverflow:=FALSE;
 NewList(CAST(List,pcr));
 NewList(CAST(List,del));
 NewList(CAST(List,hunks));
 NewList(CAST(List,codeRefs));

 AllocLev0(iniBuff,SIZE(iniBuff^));
 iniOffset:=0;
 NewList(CAST(List,iniRefs));
 NewList(CAST(List,constRefs));

END InitM2LM;

PROCEDURE InitKey(VAR key: KeyPtr);
BEGIN
  DateStamp(ADR(TM));
  WITH key^ DO
   k0:=TM.days; k1:=TM.minute; k2:=TM.tick;
  END;
END InitKey;


PROCEDURE OpenCodeFile(progid:Ident);
VAR
  typ:FileType;
BEGIN
  MainName:=progid;
  IdentToStr(progid,0C);
  CASE cpuCh OF
  | '0': typ:=objFile;
  | '1': typ:=ob1File;
  | '2': typ:=ob2File;
  | '3': typ:=ob3File;
  | '4': typ:=ob4File;
  | ELSE typ:=ob8File; (* kann nur noch 8 sein! *)
  END;
  (* 23.8.92/bp fr M2Amiga.Library *)
  IF toName[0]=0C THEN
    GeneratingNew(NameBuffer.str,typ);
    GetFileName(fileName,typ,NameBuffer.str,TRUE);
  ELSE
    GeneratingNew(toName,typ);
    GetFileName(fileName,typ,toName,TRUE);
  END;
  IF verbose THEN
    FormatS(" + %s\n",fileName);
  END;
  IF ~OpenSeqOut(ObjFile,fileName,buffSize) THEN
    Mark(8005)
  ELSE
(*$ IF OneUnit *)
    WL(999); (* unit *)
    WName(0);
(*$ ENDIF *)
  END;
END OpenCodeFile;

(* datasize<0: Deletefile, weil error! *)
PROCEDURE CloseCodeFile(datasize:LONGINT; merg:BOOLEAN);
(* mu data- und bss-hunk noch schreiben und close *)
VAR
  charLws: LONGINT;
  iniLws:LONGINT;
  e:ExtRef;
  rec: RECORD
   codemsg:ADDRESS;
   codeSize:LONGINT;
   charmsg:ADDRESS;
   charSize:LONGINT;
   bssmsg:ADDRESS;
   bssSize:LONGINT;
   datmsg:ADDRESS;
   datSize:LONGINT;
  END;

BEGIN
  IF datasize>=0 THEN (* <0 heit: lschen! *)

    rec.codeSize:=(ip+3)DIV 4 *4;

    (* 1.: datahunk *)
    charLws:=(chars[0].cp+3) DIV 4;
    rec.charSize:=charLws*4;

    IF ~Option[chipCode] THEN
      rec.codemsg:=ADR('CODE');
    ELSE
      rec.codemsg:=ADR('CHIPCODE');
    END;
    rec.charmsg:=ADR('CONST');
    rec.bssmsg:=ADR('BSS');
    rec.datmsg:=ADR('DATA');

    IF chars[0].cp>0 THEN
   (*$ IF NOT OneUnit *)
      IdentToStr(MainName,0C);
      WL(999);
      WName(0);
      AktHunk:=0;
   (*$ ENDIF *)
      WL(1000); (* hunkName *)
      WL(1);
      WL(CAST(LONGINT,textString)); (*'text'*)
      IF ~Option[chipCode] THEN
        WL(1001);
      ELSE
        rec.charmsg:=ADR('CHIPCONST');
        WL(1001+chipBit); (* chipdata *)
      END;
      WL(charLws);
      WC(chars[0].buff,rec.charSize);
      HunkStart:=0;
      WL(1007); (* hunkext *)
      WRefs(constRefs.head); (*...reloc32 auf eigenen Consts!*)
      e.modnr:=0;
      e.etyp:=charref;
      GenName(ADR(e));
      WName(1); (* extDef *)
      WL(0); (* value=0 *)
      WL(0);
      WL(1010); (* hunkend *)
      INC(AktHunk);
    END;

    (* 2. IniHunk (data) *)
    iniLws:=(iniOffset+3) DIV 4;
    rec.datSize:=iniLws*4;
    IF iniLws>0 THEN
   (*$ IF NOT OneUnit *)
      IdentToStr(MainName,0C);
      WL(999);
      WName(0);
      AktHunk:=0;
   (*$ ENDIF *)
      IF ~Option[chipData] THEN
        IF merg THEN
          rec.datmsg:=ADR('SMALLDATA');
          WL(1000); (* hunkname *)
          WL(2);
          WL(CAST(LONGINT,'__ME'));
          WL(CAST(LONGINT,'RGED'));
        END; (* else unnamed! *)
        WL(1002); (* hunkDTA *)
      ELSE
        rec.datmsg:=ADR('CHIPDATA');
        WL(1002+chipBit);
      END;
      WL(iniLws);
      WC(iniBuff,rec.datSize);
      HunkStart:=0;
      WL(1007); (* hunkext *)
      WRefs(iniRefs.head); (* reloc32 innerhalb DATA... *)
      e.modnr:=0;
      e.etyp:=iniref;
      GenName(ADR(e));
      WName(1); (* extDef *)
      WL(0); (* value=0 *)
      WL(0);
      WL(1010); (* hunkend *)
    END;

    (* 2.: BSS-Hunk *)
    datasize:=(datasize+3) DIV 4;
    rec.bssSize:=datasize*4;
    IF datasize#0 THEN
   (*$ IF NOT OneUnit *)
      IdentToStr(MainName,0C);
      WL(999);
      WName(0);
   (*$ ENDIF *)
      IF merg THEN (* kann nicht chip sein! *)
        WL(1000); (* hunkname *)
        WL(2);
        WL(CAST(LONGINT,'__ME'));
        WL(CAST(LONGINT,'RGED'));
        rec.bssmsg:=ADR('SMALLBSS');
      END; (* else unnamed! *)
      IF ~Option[chipBss] THEN
        WL(1003); (* bss *)
      ELSE
        rec.bssmsg:=ADR('CHIPBSS');
        WL(1003+chipBit); (* chipbss *)
      END;
      WL(datasize);
      WL(1007); (* hunkext *)
      e.modnr:=0;
      e.etyp:=varref;
      GenName(ADR(e));
      WName(1); (* extDef *)
      WL(0); (* value=0 *)
      WL(0);
      WL(1010); (* hunkend *)
    END;
    IF (ObjFile#NIL)&SeqOk(ObjFile) THEN
      IF verbose THEN
        WriteLn;
        IF optiCode THEN
          FormatNr(" Optimierte Bytes: %ld\n",ProgDeleted);
        END;
        Format(" fertig. %s: %ld, %s: %ld, %s: %ld, %s: %ld\n",ADR(rec));
      END;
      CloseSeq(ObjFile);
      IF iconOn THEN MakeIcon(fileName,"obj") END;
    ELSE
      Mark(8004);
      IF DosL.DeleteFile(ADR(fileName)) THEN END;
    END
  ELSE
    IF ObjFile#NIL THEN
      CloseSeq(ObjFile);
      (* ObjFile:=NIL; *)
      DosL.Delay(5); (* crash? *)
      IF DosL.DeleteFile(ADR(fileName)) THEN END;
    END;
  END;
END CloseCodeFile;


BEGIN
  (* ObjFile:=NIL; geht leider nicht, opaque! *)
CLOSE
  CloseCodeFile(-1,TRUE); (* lschen! *)
END M2LM.
