MODULE M2Debug;
(*$ LargeVars:=FALSE StackChk:=FALSE StackParms:=FALSE Volatile:=FALSE
    NilChk:=FALSE RangeChk:=FALSE OverflowChk:=FALSE
*)
(*
 * 2.10.90/bp
 * Hintergrundprozess!
 * Problem:
 * Da m2mc alles im Speicher hlt..
 * Lsung: wenn process#vorigem: vorher ForgetMem!
 * Andere Lsung, da manchmal beim nchsten Start des Programms
 * gleiche SegList und TaskPtr:
 * DArts mu am Schlu ForgetMsg schicken
 *)

FROM SYSTEM	IMPORT	ADR,ADDRESS,SETREG;
FROM Arts	IMPORT	thisTask, Assert;
FROM DebugDef	IMPORT	debPortName,magicDebug,magicForget,magicOk,magicErr,
			magicTerminate,DebugInfoPtr,DebugMsgPtr;
FROM ExecD	IMPORT	NodeType,MsgPortPtr;
FROM ExecL	IMPORT	FindPort,Forbid,GetMsg,Permit,ReplyMsg,WaitPort;
FROM ExecSupport IMPORT	CreatePort,DeletePort;
FROM Heap	IMPORT	Allocate;
FROM m2d	IMPORT	moduleInfo,errFrame,Debug,ForgetDebug;
FROM DosD	IMPORT	ProcessPtr,FileLockPtr;
FROM DosL	IMPORT	CurrentDir,DupLock,UnLock;

VAR
  (*$ LongAlign:=TRUE *)
  debuggerPort: MsgPortPtr;
  msg:DebugMsgPtr;
  lastProcess,myProcess:ProcessPtr;
  lastInfo:DebugInfoPtr;
  startCD,hisCD:FileLockPtr;

PROCEDURE InitDebugger;
VAR oldp:ADDRESS;
BEGIN
  myProcess:=thisTask;
  startCD:=myProcess^.currentDir;
  oldp:=FindPort(ADR(debPortName));
  Assert(oldp=NIL,ADR('Debugger schon vorhanden!'));
  debuggerPort:=CreatePort(ADR(debPortName),0);
  Assert(debuggerPort#NIL,ADR('M2-Debugger: no mem'));
END InitDebugger;

PROCEDURE Reply(val:LONGINT);
BEGIN
  IF msg#NIL THEN
    msg^.magic:=val;
    ReplyMsg(msg);
    msg:=NIL;
  END;
END Reply;

PROCEDURE DebugLoop;
BEGIN
  LOOP
    WaitPort(debuggerPort);
    msg:=GetMsg(debuggerPort);
    IF msg^.magic=magicTerminate THEN
      Reply(magicOk);
      EXIT
    ELSIF msg^.magic=magicForget THEN
      ForgetDebug;
      lastProcess:=NIL;
      lastInfo:=NIL;
      Reply(magicOk);
    ELSIF (msg^.magic=magicDebug) THEN
      IF (msg^.process=thisTask)OR(msg^.info=NIL) THEN
        (* das bin ich selbst! oder kein Info! *)
        Reply(magicErr);
        EXIT
      ELSE
        IF (lastProcess#msg^.process) OR (lastInfo#msg^.info) THEN
          ForgetDebug;
          lastProcess:=msg^.process;
          lastInfo:=msg^.info;
        END;
        moduleInfo:=msg^.info; (* ich benutze meine eigenen Vars! *)
        errFrame:=msg^.frame^;
        IF lastProcess^.task.node.type=process THEN
          IF hisCD#NIL THEN UnLock(hisCD); hisCD:=NIL END;
          hisCD:=DupLock(lastProcess^.currentDir);
          SETREG(0,CurrentDir(hisCD));
        END;
        Debug;
        Reply(magicOk);
      END;
    ELSE
      Reply(magicErr);
    END;
  END; (* loop *)
END DebugLoop;

PROCEDURE CloseDebugger;
BEGIN
  IF debuggerPort#NIL THEN
    Forbid; (* damit mir keiner mehr was schickt! *)
    Reply(magicErr); (* globale zurck *)
    LOOP (* Port leeren! *)
      msg:=GetMsg(debuggerPort);
      IF msg=NIL THEN EXIT END;
      Reply(magicErr);
    END;
    DeletePort(debuggerPort);
    Permit;
  END;
END CloseDebugger;

BEGIN
  InitDebugger;
  DebugLoop;
CLOSE
  SETREG(0,CurrentDir(startCD));
  IF hisCD#NIL THEN UnLock(hisCD); hisCD:=NIL END;
  CloseDebugger;
END M2Debug.
