IMPLEMENTATION MODULE M2AmigaLib;


(*$ DEFINE Test:=FALSE *) (* TRUE: wird dann normales Modul! *)

(*
 * 8.92/bp
 *
 * 27.8.92/bp
 * Die Namen werden nun immer in Grobuchstaben gespeichert.
 * Der Linker und m2cache machten rger. m2l features -->
 * features im Cache, aber GeneratingNew(Features) lscht es nicht!
 * 28.8.92/bp
 * Wenn keine SubDir vorhanden, dann mu FlushLocals auch
 * diese lschen (abc.obj)
 * 29.8.92/bp
 * Das LRU-Prinzip hat noch gar nicht richtig funktioniert!
 * Wenn das Objekt schon im Cache ist, muss es auch an den
 * Anfang der Liste! done.
 * Ausserdem statt Forbid, Permit nun einen Semaphore eingerichtet
 * Dann kann m2cache ihn sauber locken.
 *)
(*$ LargeVars:=FALSE StackParms:=FALSE Volatile:=FALSE *)

(*$ StackChk:=FALSE RangeChk:=FALSE OverflowChk:=FALSE
    NilChk:=FALSE CaseChk:=FALSE *)

FROM SYSTEM	IMPORT	ADR, ADDRESS, ASSEMBLE, CAST, SETREG;
FROM String	IMPORT	CapString,Compare,Concat,Copy,FirstPos,Length,
			ConcatChar;
IMPORT
  Arts,
  ASCII,
  DosD, DosL,
  ExecD, ExecL,
  IconL,
  R,
  WorkbenchD;

(*$ IF Test *)
IMPORT Heap, ExecSupport;
(*$ ENDIF *)


(*$ DEFINE English:=FALSE *)

CONST
  revision = 014;

  MY_MAGIC = 11F94321H; (* irgendwas unwahrscheinliches. *)

  semName = "M2AmigaLibSem";

(*$ IF English *)
  errMsgFile  ="M2:Error-Messages";
  memOverflow ="Not enough memory";
  pathOverflow="Path Entry Too Long";
(*$ ELSE *)
  errMsgFile  ="M2:Fehler-Meldungen";
  memOverflow ="Zuwenig Speicher";
  pathOverflow="Pfadname zu lang";
(*$ ENDIF *)

  pcFlags   = ExecD.MemReqSet{ExecD.public,ExecD.memClear};
  pFlags    = ExecD.MemReqSet{ExecD.public};
  freeFlags = ExecD.MemReqSet{ExecD.public};

  iconDir = "m2:icons/";


TYPE
 Path=ARRAY [0..maxPathLen-1] OF CHAR;
 PathPtr = POINTER TO Path;
 PathEntryPtr=POINTER TO PathEntry;
 PathEntry=RECORD
   next: PathEntryPtr;
   pLock: DosD.FileLockPtr; (* path Lock *)
   dLock: ARRAY [MIN(FileType)..MAX(FileType)] OF DosD.FileLockPtr;
   (* a lock for each subdir *)
   size: INTEGER;
   path: Path;
 END;
 ShString=ARRAY [0..5] OF CHAR;
 FilTArr = ARRAY FileType OF ShString;

CONST
  Empty = "";
  dir = FilTArr{"TXT/","TXT/","SYM/","OBJ/","OBJ/","OBJ/",
		"OBJ/","OBJ/","OBJ/","REF/","BIN/"};
  ext = FilTArr{".def",".mod",".sym",".obj",".ob1",".ob2",
		".ob3",".ob4",".ob8",".ref",""};


VAR
  (*$ LongAlign:=TRUE *) (* Besser fr 68020... *)
  myLib: M2AmigaBasePtr;
  Glob:  GlobVars; (* Ptr in myLib zeigt hierhin *)
  fib:   DosD.FileInfoBlock; (* einmal global reicht Forbid! *)
  listSema := ExecD.SignalSemaphore{
		link: ExecD.Node{type:ExecD.signalSem, name:ADR(semName)}
	      };

(* Mu-Prozeduren: *)
(*######################################################################*)
(* Bitte hier nichts verndern!......................................*)
CONST
  delOrd = ORD(ExecD.delExp); (* ASSEMBLE kennt keine Aufzhlungstypen! *)

PROCEDURE LibOpen(myLib{R.A6}:M2AmigaBasePtr):ADDRESS;
(*$ EntryExitCode:=FALSE *)
BEGIN
  ASSEMBLE(
	ADDQ.W	#1,ExecD.Library.openCnt(A6)
	BCLR	#delOrd,ExecD.Library.flags(A6)
	MOVE.L	A6,D0
	RTS
  END);
END LibOpen;

PROCEDURE LibClose(myLib{R.A6}:M2AmigaBasePtr): ADDRESS;
(*$ EntryExitCode:=FALSE *)
BEGIN
  ASSEMBLE(
	MOVEQ	#0,D0
	SUBQ.W	#1,ExecD.Library.openCnt(A6)
	BNE.S	noExp
	BTST	#delOrd,ExecD.Library.flags(A6)
	BEQ.S	noExp
	BSR.S	LibExpunge
noExp:
	RTS
  END);
END LibClose;

PROCEDURE LibExpunge(myLib{R.A6}:M2AmigaBasePtr): ADDRESS;
(*$ EntryExitCode:=FALSE *)
VAR exec[4]:ADDRESS;
BEGIN
  ASSEMBLE(
	XREF	_LinkerDB (* Basis der NEAR-Variablen *)
	TST.W	ExecD.Library.openCnt(A6)
	BEQ.S	canExp
	BSET	#delOrd,ExecD.Library.flags(A6)
	BSR	FlushAll
	MOVEQ	#0,D0
	RTS
canExp:	MOVEM.L	A4-A6,-(A7)
	LEA	_LinkerDB,A4 (* Sehr wichtig!!! *)
	MOVEA.L	A6,A5
	MOVEA.L	A5,A1
	MOVEA.L	exec,A6
	JSR	ExecL.Remove(A6)
	JSR	Arts.Terminate(PC) (* Schliee Module und Libraries *)
	MOVEA.L	A5,A1
	MOVEQ	#0,D0
	MOVE.W	ExecD.Library.negSize(A5),D0
	SUBA.W	D0,A1
	ADD.W	ExecD.Library.posSize(A5),D0
	JSR	ExecL.FreeMem(A6) (* exec.library ist schon geschlossen! *)
	MOVE.L	Arts.dosCmdBuf(A4),D0 (* segList von Init *)
	MOVEM.L	(A7)+,A4-A6
	RTS
  END);
END LibExpunge;

PROCEDURE LibExtFunc(myLib{R.A6}:M2AmigaBasePtr): ADDRESS;
(*$ EntryExitCode:=FALSE *)
BEGIN
  ASSEMBLE(
	MOVEQ	#0,D0 (* Immer NIL *)
	RTS
  END);
END LibExtFunc;

(*######################################################################*)
(* end of closed block....................................................*)




(*
 **************************************************************************
 * Utilities:
 *)


PROCEDURE LockMyVars;
BEGIN
  (*$ IF NOT Test *)
  ExecL.ObtainSemaphore(ADR(listSema));
  (*$ ENDIF *)
END LockMyVars;

PROCEDURE UnlockMyVars;
BEGIN
  (*$ IF NOT TEST *)
  ExecL.ReleaseSemaphore(ADR(listSema));
  (*$ ENDIF *)
END UnlockMyVars;


(*$ LoadA4:=TRUE CopyDyn:=FALSE *)
PROCEDURE Exists(name:ARRAY OF CHAR):ExistsResult;
VAR
  l  {R.D6}: DosD.FileLockPtr;
  res{R.D7}: ExistsResult;
BEGIN
  res:=errExists;
  l:=DosL.Lock(ADR(name),DosD.sharedLock);
  IF l <> NIL THEN
    LockMyVars;
    IF DosL.Examine(l,ADR(fib)) THEN
      IF fib.dirEntryType >= 0 THEN (* directory *)
        res:=dirExists;
      ELSE
        res:=fileExists;
      END;
    END;
    UnlockMyVars;
    DosL.UnLock(l);
  ELSE
    res:=noExists;
  END;
  RETURN res;
END Exists;

(*$ LoadA4:=TRUE CopyDyn:=FALSE *)
PROCEDURE ObjExists(name: ARRAY OF CHAR): BOOLEAN;
VAR
  lock{R.D7}: DosD.FileLockPtr;
BEGIN
  lock:=DosL.Lock(ADR(name),DosD.sharedLock);
  IF lock#NIL THEN
    DosL.UnLock(lock);
    RETURN TRUE
  ELSE
    RETURN FALSE
  END
END ObjExists;


(*$ LoadA4:=TRUE CopyDyn:=FALSE *)
PROCEDURE LoadFile(name:ARRAY OF CHAR; VAR adr:ADDRESS; VAR len:LONGINT):LFResult;
VAR
  in: DosD.FileHandlePtr;
  ibuff{R.A2}:ADDRESS;
  ilen{R.D7}:LONGINT;
  res{R.D6}:LFResult;
BEGIN
  adr:=NIL; len:=NIL;
  in:=DosL.Open(ADR(name),DosD.readOnly);
  IF in#NIL THEN
    SETREG(0,DosL.Seek(in,0,DosD.end)); (* ans Ende gehen *)
    ilen:=DosL.Seek(in,0,DosD.beginning);
    IF ilen >= 0 THEN
      ibuff:=ExecL.AllocMem(ilen,pFlags);
      IF ibuff#NIL THEN
        IF ilen=DosL.Read(in,ibuff,ilen) THEN
          adr:=ibuff;
          len:=ilen;
          res:=lfOk;
        ELSE
          ExecL.FreeMem(ibuff,ilen);
          res:=lfDosErr;
        END;
      ELSE
        res:=lfNoMem;
      END;
    ELSE
      res:=lfDosErr;
    END;
    DosL.Close(in);
  ELSE
    res:=lfNotFound;
  END;
  RETURN res;
END LoadFile;

(*$ LoadA4:=TRUE *)
PROCEDURE FreeFile(VAR adr:ADDRESS; VAR len:LONGINT);
BEGIN
  IF adr#NIL THEN
    ExecL.FreeMem(adr,len);
    adr:=NIL;
  END;
  len:=NIL;
END FreeFile;





(*
 **************************************************************************
 * M2Errors:
 *)


PROCEDURE Fixup(errLst{R.A0}: ErrorPtr);
VAR
  base{R.D0}: ADDRESS;
BEGIN
  base:=errLst;
  WHILE errLst^.next#NIL DO
    INC(errLst^.next,base);
    errLst:=errLst^.next
  END;
END Fixup;


(*$ LoadA4:=TRUE *)
PROCEDURE GetErrMsgs():ErrorPtr;
VAR
  errBF: ErrorPtr;
  errSZ: LONGINT;
BEGIN
  LockMyVars;
  IF Glob.errBuffer = NIL THEN
    IF LoadFile(errMsgFile,errBF,errSZ) = lfOk THEN
      Fixup(errBF);
      Glob.errBuffer:=errBF;
      Glob.errSize:=errSZ;
    END;
  END;
  IF Glob.errBuffer # NIL THEN
    INC(Glob.errOpenCnt);
  END;
  UnlockMyVars;
  RETURN Glob.errBuffer;
END GetErrMsgs;


(*$ LoadA4:=TRUE *)
PROCEDURE FreeErrMsgs;
BEGIN
  DEC(Glob.errOpenCnt); (* kein LockMyVars ntig, unre Operation *)
END FreeErrMsgs;





(*
 **************************************************************************
 * M2Icon:
 *)
(*
 * Example: MakeIcon(fileName,"sym");
 * Sucht in m2:icons/ erzeugt KEIN neues Icon, wenn eins da ist!
 * name, icon sind CONST!
 *)
(*$ LoadA4:=TRUE CopyDyn:=FALSE *)
PROCEDURE MakeIcon(name,icon: ARRAY OF CHAR);
VAR
 iconName: ARRAY [0..63] OF CHAR;
 do: WorkbenchD.DiskObjectPtr;
BEGIN
  do:=IconL.GetDiskObject(ADR(name));
  IF do=NIL THEN (* noch keins da. *)
    iconName:="m2:icons/";
    Concat(iconName,icon);
    do:=IconL.GetDiskObject(ADR(iconName));
    IF do#NIL THEN
      IF IconL.PutDiskObject(ADR(name),do) THEN END;
      IconL.FreeDiskObject(do)
    END;
  ELSE (* gibt es schon, alles klar. *)
    IconL.FreeDiskObject(do);
  END;
END MakeIcon;




(*
 **************************************************************************
 * M2File
 *)


(* interne Procs ##############################################*)


PROCEDURE InitPathLocks(path: PathEntryPtr);
VAR
  t: FileType;
  dl: DosD.FileLockPtr;
BEGIN
  WITH path^ DO
    IF pLock=NIL THEN
      pLock:=DosL.Lock(ADR(path),DosD.sharedLock);
      IF pLock#NIL THEN
        dl:=DosL.CurrentDir(pLock);
        FOR t:=MIN(FileType) TO MAX(FileType) DO
          dLock[t]:=DosL.Lock(ADR(dir[t]),DosD.sharedLock);
        END;
        dl:=DosL.CurrentDir(dl);
      END
    END
  END
END InitPathLocks;


(* falls wir aus einer SubDir gestartet wurden, wechseln wir ins ParentDir *)
PROCEDURE SetProjectDir(VAR p:MFPars);
VAR
  ft: FileType;
  eq: BOOLEAN;
  i:INTEGER;
  str: ARRAY[0..7] OF CHAR;
BEGIN
  p.originalDirectory:=CAST(DosD.ProcessPtr,ExecD.execBase^.thisTask)^.currentDir;
  LockMyVars;
  IF DosL.Examine(p.originalDirectory,ADR(fib)) THEN
    Copy(str,fib.fileName);
    CapString(str);
    ConcatChar(str,"/");
  ELSE
    str[0]:=ASCII.nul;
  END;
  (*$ IF Test *) Arts.BreakPoint(ADR('nach examine'));  (*$ ENDIF *)
  UnlockMyVars;
  ft:=MIN(FileType);
  REPEAT
    eq:=Compare(str,dir[ft])=0;
    (*$ RangeChk:=FALSE *)
    INC(ft);
    (*$ POP RangeChk *)
  UNTIL eq OR (ft>MAX(FileType));
  IF eq THEN
    p.newDir:=DosL.ParentDir(p.originalDirectory); (* neues Lock, merken! *)
    SETREG(0,DosL.CurrentDir(p.newDir));
  ELSE
    p.originalDirectory:=NIL;
    p.newDir:=NIL;
  END;
END SetProjectDir;


(* externe Procs ##############################################*)


(*$ LoadA4:=TRUE CopyDyn:=FALSE *)
PROCEDURE GetFileName(VAR p: MFPars; VAR name: ARRAY OF CHAR;
                      type: FileType; module: ARRAY OF CHAR; new: BOOLEAN);
VAR
  curPath: PathEntryPtr;
  lock: DosD.FileLockPtr;
  sdir: BOOLEAN;
  fname: ARRAY [0..maxFileName] OF CHAR;
BEGIN
  curPath:=p.userPath;
  IF ObjExists(dir[type]) THEN
    Copy(fname,dir[type]);
  ELSE
    fname:=Empty;
  END;
  Concat(fname,module);
  Concat(fname,ext[type]);
  IF ObjExists(fname) OR new THEN
  ELSE
    Copy(fname,module);
    Concat(fname,ext[type]);
    LOOP
      IF curPath=NIL THEN EXIT END;
      InitPathLocks(curPath);
      WITH curPath^ DO
        IF pLock#NIL THEN
          sdir:=dLock[type] # NIL;
          IF sdir THEN
            lock:=DosL.CurrentDir(dLock[type]);
          ELSE
            lock:=DosL.CurrentDir(pLock)
          END;
          IF ObjExists(fname) THEN
            Copy(fname,path);
            IF sdir THEN
              Concat(fname,dir[type])
            END;
            Concat(fname,module);
            Concat(fname,ext[type]);
            lock:=DosL.CurrentDir(lock);
            EXIT
          END;
          lock:=DosL.CurrentDir(lock);
        END
      END;
      curPath:=curPath^.next;
    END
  END;
  Copy(name,fname);
END GetFileName;


(*$ LoadA4:=TRUE *)
PROCEDURE GetInputFile(VAR p: MFPars; VAR name: ARRAY OF CHAR;
                       type: FileType; givenName: ARRAY OF CHAR);
VAR
  hasPath: BOOLEAN;
  i: INTEGER;
  extension: ShString;
BEGIN
  i:=0;
  hasPath:=FALSE;
 (* Besser wre:
  * i:=FirstPos(...);
  * hasExtension:=Occurs(name,i,ext[type],FALSE)=Length(name)-Length(ext[type]);
  *)
  i:=Length(givenName);
  hasPath:=(FirstPos(givenName,0,":")>=0)
           OR (FirstPos(givenName,0,"/")>=0);


  IF ~hasPath & ObjExists(dir[type]) THEN
    Copy(name,dir[type]);
  ELSE
    name[0]:=ASCII.nul
  END;
  Concat(name,givenName);

  extension:=ext[type];
  CapString(extension);

  IF (i>4) (* Extension schon dran? *)
   & (CAP(givenName[i-4])=extension[0])
   & (CAP(givenName[i-3])=extension[1])
   & (CAP(givenName[i-2])=extension[2])
   & ((CAP(givenName[i-1])=extension[3]) OR (type=objFile)) THEN
    extension:=Empty
  ELSE
    extension:=ext[type]
  END;
  Concat(name,extension);
END GetInputFile;


(*$ LoadA4:=TRUE *)
PROCEDURE ForgetPathTable(VAR p: MFPars);
VAR
  path: PathEntryPtr;
  t: FileType;
  me:DosD.ProcessPtr;
BEGIN
 WITH p DO
  WHILE (userPath#NIL) & (userPath#defaultPath) DO
    path:=userPath;
    userPath:=userPath^.next;
    WITH path^ DO
      IF pLock#NIL THEN DosL.UnLock(pLock) END;
      FOR t:=MIN(FileType) TO MAX(FileType) DO
        IF dLock[t]#NIL THEN DosL.UnLock(dLock[t]) END;
      END
    END;
    ExecL.FreeMem(path,path^.size);
  END;
  userPath:=defaultPath;
  (* Wieder in StartDir gehen! *)
  IF newDir#NIL THEN
    me:=CAST(DosD.ProcessPtr,ExecD.execBase^.thisTask);
    IF newDir = me^.currentDir THEN (* alles klar, kein Schwein da gewesen! *)
      SETREG(0,DosL.CurrentDir(originalDirectory));
    END; (* Sonst um Gottes willen nicht!/bp *)
    DosL.UnLock(newDir); newDir:=NIL;
  END;
 END; (* with p *)
END ForgetPathTable;


(*$ LoadA4:=TRUE CopyDyn:=FALSE *)
PROCEDURE ReadPathTable(VAR p: MFPars; name: ARRAY OF CHAR);
TYPE CharPtr = POINTER TO CHAR;
VAR
  f: DosD.FileHandlePtr;
  ch: CHAR;
  eof: BOOLEAN;
  i: INTEGER;
  allocSize:INTEGER;
  entry: Path;
  lastEntry: PathEntryPtr;
  npath: PathEntryPtr;
  cp1,cp2:CharPtr;
BEGIN (* ReadPathTable *)
  ForgetPathTable(p); (* alten lschen und in alte Dir wechseln, UnLocken *)
  SetProjectDir(p); (* ins Project heruntergehen, falls in SubDir *)
  lastEntry:=ADR(p.userPath);
  f:=DosL.Open(ADR(name),DosD.oldFile);
  IF f#NIL THEN
    eof:=DosL.Read(f,ADR(ch),1)#1;
    i:=0;
    WHILE ~eof DO
      IF (ch=ASCII.lf) & (i#0) THEN
        ch:=entry[i-1];
        IF (ch#":") & (ch#"/") THEN
          entry[i]:="/"; INC(i)
        END;
        entry[i]:=ASCII.nul;
        allocSize:=(SIZE(PathEntry)-SIZE(Path)+1)+i;
        npath:=ExecL.AllocMem(allocSize,pcFlags);
        IF npath=NIL THEN
          DosL.Close(f);
          lastEntry^.next:=p.defaultPath;
          RETURN; (* ohoh, blo raus hier! *)
        END;
        npath^.size:=allocSize; (* fr Dealloc merken *)
        cp1:=ADR(npath^.path); cp2:=ADR(entry);
        WHILE cp2^#ASCII.nul DO
          cp1^:=cp2^;
          INC(cp1); INC(cp2);
        END;
        cp1^:=ASCII.nul;
        (* Copy(npath^.path,entry); Copy kopiert den GANZEN String!! Nicht mehr!/bp *)
        npath^.next:=NIL;
        lastEntry^.next:=npath;
        lastEntry:=npath;
        i:=0;
      ELSIF i<maxPathLen THEN
        entry[i]:=ch; INC(i)
      END;
      eof:=DosL.Read(f,ADR(ch),1)#1
    END;
    DosL.Close(f)
  END;
  lastEntry^.next:=p.defaultPath;
END ReadPathTable;






(*
 **************************************************************************
 * Objs und Syms:
 *)


(* interne Procs ###############################################*)



(*
 * Wenn useCount<=0: FreeMem, delete Node,
 * sonst: valid:=FALSE
 * Nicht exportiert, mu gltigen Parameter erhalten!
 * braucht kein LoadA4, uere hat schon
 *
 * Mssen ALLE im LockMyVars-Status aufgerufen werden!
 *
 *)



PROCEDURE KillObj(o: ObjFilePtr);
BEGIN
  WITH o^ DO
    IF useCount <= 0 THEN
      IF buffer # NIL THEN
        ExecL.FreeMem(buffer, buffLen);
        DEC(Glob.objUsedMem, buffLen);
      END;
      ExecL.Remove(o);
      ExecL.FreeMem(o,SIZE(ObjFile));
      DEC(Glob.objUseCnt);
    ELSE
      valid:=FALSE;
    END;
  END;
END KillObj;


(*$ CopyDyn:=FALSE *) (* o^.realType nachsehen!! *)
PROCEDURE FindObj(modName:ARRAY OF CHAR; t:FileType):ObjFilePtr;
VAR
  o{R.A3}: ObjFilePtr;
  capName: ModName;
BEGIN
  Copy(capName,modName);
  CapString(capName);
  IF (t>objFile) & (t<=ob8File) THEN t:=objFile END;
  o:=Glob.objList.head;
  WHILE (o^.succ#NIL)
        & NOT( o^.valid & (o^.type=t) & (Compare(o^.name,capName)=0) ) DO
    o:=o^.succ;
  END;
  IF o^.succ=NIL THEN o:=NIL END;
  RETURN o;
END FindObj;


(* gibt lru frei, wenn mem berschritten todo *)
PROCEDURE MemCheck;
(* alle, die invalid und usecount<=0 sowie die mit usecount<=0
 * und lru
 *)
VAR
  obj{R.A3},
  merk{R.D6}: ObjFilePtr;
  minFree{R.D7}: LONGINT;
BEGIN
  LockMyVars;
  IF (Glob.objMaxMem>=0) THEN (* was lschen *)
    obj:=Glob.objList.tailPred;
    WHILE (obj^.pred#NIL) & (Glob.objUsedMem>Glob.objMaxMem) DO
      merk:=obj^.pred;
      IF obj^.useCount<=0 THEN
        KillObj(obj);
      END;
      obj:=merk;
    END;
  ELSIF (Glob.objMaxMem<0) THEN
    minFree:=-Glob.objMaxMem;
    obj:=Glob.objList.tailPred;
    WHILE (obj^.pred#NIL) & (ExecL.AvailMem(freeFlags)<minFree) DO
      merk:=obj^.pred;
      IF obj^.useCount<=0 THEN
        KillObj(obj);
      END;
      obj:=merk;
    END;
  END;
  UnlockMyVars;
END MemCheck;


(* stellt fest, ob der pathName lokal ist (???/..) *)
PROCEDURE IsLocal(o:ObjFilePtr):BOOLEAN;
VAR
  first4: ARRAY [0..4] OF CHAR;
  t{R.D7}: FileType;
BEGIN
  (* berhaupt ein Pfad drin? *)
  IF (FirstPos(o^.pathName,0,"/")<0)
     & (FirstPos(o^.pathName,0,":")<0) THEN
    RETURN TRUE (* ohne Pfad, also lokal *)
  END;
  Copy(first4,o^.pathName); (* schneidet genau 4 Zeichen ab *)
  CapString(first4);
  t:=MIN(FileType);
  WHILE (t<MAX(FileType)) DO
    IF Compare(first4,dir[t])=0 THEN
      RETURN TRUE;
    END;
    INC(t);
  END;
  RETURN FALSE;
END IsLocal;


(* externe Procs ###############################################*)


(*$ LoadA4:=TRUE *)
PROCEDURE FlushAll;
VAR
  obj{R.A2},
  merk{R.D7}: ObjFilePtr;
BEGIN
  LockMyVars;

  (* Sicherheitshalber nur freigeben, was unbenutzt! *)

  IF (Glob.errOpenCnt <= 0) AND (Glob.errBuffer # NIL) THEN
    ExecL.FreeMem(Glob.errBuffer,Glob.errSize);
    Glob.errBuffer:=NIL;
    Glob.errSize:=0;
    Glob.errOpenCnt:=0;
  END;

  obj:=Glob.objList.head;
  WHILE obj^.succ # NIL DO
    merk:=obj^.succ;
    IF obj^.useCount<=0 THEN
      KillObj(obj);
    END;
    obj:=merk;
  END;

  UnlockMyVars;
END FlushAll;


(*$ LoadA4:=TRUE *) (* KEIN CopyDyn:=FALSE wegen LOOP und CapString *)
PROCEDURE GetObj(VAR p:MFPars; VAR fullName:ARRAY OF CHAR;
		 t:FileType; modName: ARRAY OF CHAR): ObjFilePtr;
VAR
  o(*$ IF NOT Test *){R.A2}(*$ ENDIF *): ObjFilePtr;
  st(*$ IF NOT Test *){R.D7}(*$ ENDIF *): FileType;
BEGIN
 (*
  * in liste suchen
  * wenn da, ok
  * sonst
  *   namen erzeugen
  *)
  st:=t;
  LockMyVars;
  o:=FindObj(modName,st);
(*$ IF Test *) Arts.BreakPoint(ADR('enter getobj')); (*$ ENDIF *)
  IF o#NIL THEN (* gefunden *)
    (*
     * wenn objFile und
     *   t>realtype:
     *       t IN cpuDoesntExist: ok, nehmen wir diesen, t ist nicht da
     *       sonst: weg damit, neu zu laden versuchen
     *   t=realtype: alles klar!
     *   t<realtype: weg damit! neu laden. (habe 20er, will 10er)
     *)
    IF (o^.type=objFile) &
       ((st<o^.realType) OR ((st>o^.realType) & NOT(st IN o^.cpuDoesntExist))) THEN
      KillObj(o);
      o:=NIL;
    ELSE
      (* 29.8.92/bp auch hier an den Anfang! LRU-Prinzip *)
      ExecL.Remove(o);
      ExecL.AddHead(ADR(Glob.objList),o);
      INC(o^.useCount);
      Copy(fullName,o^.pathName);
    END;
  END;
  UnlockMyVars;
  IF o=NIL THEN
    o:=ExecL.AllocMem(SIZE(ObjFile),pcFlags);
    IF o#NIL THEN
      Copy(o^.name,modName);
      CapString(o^.name);
      GetFileName(p,fullName,st,modName,FALSE);
      WHILE (st>objFile) & (st<=ob8File) & NOT ObjExists(fullName) DO
        INCL(o^.cpuDoesntExist,st);
        DEC(st);
        GetFileName(p,fullName,st,modName,FALSE);
      END;
      Copy(o^.pathName,fullName);
      IF LoadFile(fullName,o^.buffer,o^.buffLen)=lfOk THEN
        o^.magic:=MY_MAGIC;
        o^.useCount:=1;
        o^.valid:=TRUE;
        o^.realType:=st;
        IF (st>=objFile) & (st<=ob8File) THEN
          o^.type:=objFile;
        ELSE
          o^.type:=st;
        END;
        LockMyVars;
        INC(Glob.objUseCnt);
        INC(Glob.objUsedMem,o^.buffLen);
        ExecL.AddHead(ADR(Glob.objList),o);
        UnlockMyVars;
      ELSE
        ExecL.FreeMem(o,SIZE(ObjFile));
        o:=NIL;
      END;
    END;
  END;
  MemCheck;
  RETURN o;
END GetObj;



(*$ LoadA4:=TRUE *)
PROCEDURE FreeObj(VAR o: ObjFilePtr; killIt:BOOLEAN);
BEGIN
  LockMyVars;
  IF (o # NIL) & (o^.magic = MY_MAGIC) THEN
    DEC(o^.useCount);
    IF killIt OR NOT o^.valid THEN
      KillObj(o);
    END;
    MemCheck;
    o:=NIL;
  END; (* if *)
  UnlockMyVars;
END FreeObj;


(*$ LoadA4:=TRUE CopyDyn:=FALSE *)
PROCEDURE GeneratingNew(modName: ARRAY OF CHAR; t:FileType);
VAR
  o{R.D7}:ObjFilePtr;
BEGIN
  LockMyVars;
  o:=FindObj(modName,t);
  IF o # NIL THEN (* gefunden, flush it! *)
    KillObj(o);
  END;
  UnlockMyVars;
END GeneratingNew;


(*$ LoadA4:=TRUE *) (* nicht mit ob1..ob8 aufrufen! *)
PROCEDURE FlushType(t:FileType);
VAR
  obj{R.A2},
  merk{R.D7}: ObjFilePtr;
BEGIN
  LockMyVars;
  obj:=Glob.objList.head;
  WHILE obj^.succ#NIL DO
    merk:=obj^.succ;
    IF (obj^.useCount<=0) & (obj^.type=t) THEN
      KillObj(obj);
    END;
    obj:=merk;
  END;
  UnlockMyVars;
END FlushType;


(*$ LoadA4:=TRUE *)
PROCEDURE FlushLocals;
VAR
  obj{R.A2},
  merk{R.D7}: ObjFilePtr;
BEGIN
  LockMyVars;
  obj:=Glob.objList.head;
  WHILE obj^.succ#NIL DO
    merk:=obj^.succ;
    IF (obj^.useCount<=0) & IsLocal(obj) THEN
      KillObj(obj);
    END;
    obj:=merk;
  END;
  UnlockMyVars;
END FlushLocals;






(*
 **************************************************************************
 * Main:
 *)
BEGIN

(*$ IF Test *)
    (*$ "\n\nACHTUNG!!!\tTEST-Version\n\n" *)

    Heap.Allocate(myLib,SIZE(myLib^)); (* Dummy-Library allozieren *)
    myLib^.globs:=ADR(Glob);
    ExecSupport.NewList(ADR(Glob.objList));
(*$ ELSE *)
    (*$ "\n\nACHTUNG!!!!\tLibrary-Version\n\n" *)

  ASSEMBLE(

	MOVEA.L	Arts.dosCmdLen(A4),A0	 (* myLib:=Arts.dosCmdLen *)
	MOVE.L	A0,myLib(A4)
	LEA	Glob(A4),A1
	MOVE.L	A1,M2AmigaBase.globs(A0) (* myLib^.globs:=ADR(Glob) *)

	LEA	Glob.objList(A4),A0	 (* NewList(Glob.objList) *)
	MOVE.L	A0,8(A0)
	ADDQ.L	#4,A0
	CLR.L	(A0)
	MOVE.L	A0,-(A0)
  END);

(*$ ENDIF *)
  (* Semaphor einrichten. type, name sind schon *)
  (* AddSemaphore ist fehlerhaft bei <36 *)
  ExecL.InitSemaphore(ADR(listSema));
  ExecL.Forbid;
  ExecL.Enqueue(ADR(ExecL.execBase^.semaphoreList),ADR(listSema));
  ExecL.Permit;
  Glob.objMaxMem:=-300000; (* 300KB frei halten *)
  (* Rest ist 0 und NIL *)

(*
 * Der Close-Teil wird von Arts.Terminate, also indirekt von LibExpunge
 * aufgerufen. Hier darf aufgerumt werden. A4 ist geladen und Forbid.
 *)
CLOSE
  FlushAll;
  ExecL.RemSemaphore(ADR(listSema)); (* das ist clean! *)
END M2AmigaLib.mod
