MODULE LoadRes;
(*
 * V 1.0 18.12.89 Bernd Preusing
 * V 1.1 08.01.90 bp Fehler in SearchResident
 * V 4.0 16.10.90 bp Anpassung an M2Amiga V4.0
 * Ldt ein Lib, Dev, Rsrc in den Speicher und initialisiert das Resident.
 * Somit knnen
 * a) auch Resources geladen werden
 * b) auch Files geladen werden, die nicht in libs: oder devs: stehen.
 * Falls einm Fehler auftrat -> returnVal:=10;
 * 19.12.89/bp Test eingefgt, ob Objekt schon im System vorhanden
 *)

(*$ LargeVars:=FALSE *)

FROM SYSTEM	IMPORT	ADR, ADDRESS, BPTR, CAST,SETREG;
FROM Arts	IMPORT	programName, returnVal, BreakPoint;
FROM DosL	IMPORT	LoadSeg, UnLoadSeg;
FROM ExecD	IMPORT	matchword, Resident, ResidentPtr,
			execBase, NodeType;
FROM ExecL	IMPORT	FindName, InitResident;
FROM Arguments	IMPORT	GetArg, NumArgs;
FROM Terminal	IMPORT	waitCloseGadget, WriteString, WriteLn, Format;

(*$ LongAlign:=FALSE StackChk:=FALSE RangeChk:=FALSE OverflowChk:=FALSE
    NilChk:=FALSE StackParms:=FALSE Volatile:=FALSE *)

CONST
  date=COMPILEDATE;
  ver="4.4";
  verDollar="$VER: LoadRes "+ver+" "+date;

TYPE
    eErr = (ok, notFound, noRes, wrongType, alrExst);

VAR SegList: BPTR;
    Len,Arg,Args: INTEGER;
    ArgString: ARRAY[0..79] OF CHAR;
    Rp: ResidentPtr;
    List,found: ADDRESS;
    s: POINTER TO ARRAY[0..79] OF CHAR;
    Error: eErr;

PROCEDURE SearchResident(a{1}:BPTR):ResidentPtr;
VAR len{0}:LONGINT;
    adr{9}: POINTER TO LONGINT;
    tp{8}:ResidentPtr;
BEGIN
  adr:=ADDRESS(a); (* autom. Umwandlung BPTR->ADDRESS ! *)
  DEC(adr,4); (* auf len des 1. Segments *)
  len:=adr^-SIZE(Resident); (* max. Suchlnge *)
  INC(adr,8); (* Beginn des Segments *)
  tp:=CAST(ResidentPtr,adr);
  WHILE ((tp^.matchWord#matchword) OR (tp^.matchTag#tp)) AND (len>=0) DO
    INC(tp,2);
    DEC(len,2); (* 8.1.90 *)
  END;
  IF len<0 THEN
    RETURN NIL
  END;
  RETURN tp
END SearchResident;

BEGIN
  SETREG(11,ADR(verDollar));
  WriteString("Resident Loader "+ver+", "+date+"\n");
  waitCloseGadget:=FALSE;
  Args:=NumArgs();
  IF Args>0 THEN
    GetArg(1,ArgString,Len);
  END;
  IF (Args=0) OR (ArgString[0]='?') THEN
    Format('usage: %s {filename}\n',ADR(programName));
  ELSE
    Arg:=1;
    WHILE Arg<=Args DO
      GetArg(Arg,ArgString,Len);
      INC(Arg);
      WriteString(' - ');
      WriteString(ArgString);
      SegList:=LoadSeg(ADR(ArgString));
      IF SegList=NIL THEN
        Error:=notFound;
      ELSE
        Rp:=SearchResident(SegList);
        IF Rp=NIL THEN
          Error:=noRes;
        ELSE
          CASE Rp^.type OF
          | resource: List:=ADR(execBase^.resourceList);
          | library:  List:=ADR(execBase^.libList);
          | device:   List:=ADR(execBase^.deviceList);
          | ELSE      List:=NIL;
          END;
          IF List=NIL THEN
            Error:=wrongType;
          ELSE
            found:=FindName(List,Rp^.name);
            IF found#NIL THEN
              Error:=alrExst;
            ELSE
              InitResident(Rp,SegList);
              Error:=ok;
            END;
          END;
        END;
      END;
      CASE Error OF
      | ok:	  s:=ADR(' geladen und initialisiert.');
      | notFound: s:=ADR(' nicht gefunden oder kein LoadFile.');
      | noRes:	  s:=ADR(' enthlt keine Resident-Struktur!');
      | wrongType:s:=ADR(' falscher NodeType!');
      | ELSE  s:=ADR(' ist schon vorhanden!');
      END;
      WriteString(s^);
      WriteLn;
      IF Error>notFound THEN
        UnLoadSeg(SegList)
      END;
      IF Error#ok THEN
        returnVal:=10;
        waitCloseGadget:=TRUE;
      ELSE
        Format("\tId: %s\n",ADR(Rp^.idString));
      END;
    END;
    WriteString('fertig.\n');
  END;
END LoadRes.
