IMPLEMENTATION MODULE FFPInOut; (* jr/8jul87 *)
(*$ LargeVars:=FALSE
    Volatile:=FALSE
    StackChk:=FALSE
    RangeChk:=FALSE
    OverflowChk:=FALSE
*)

FROM SYSTEM		IMPORT FFP;
FROM FFPConversions	IMPORT RealToStr, StrToReal;
FROM InOut		IMPORT WriteString, ReadString;

TYPE String=ARRAY [0..99] OF CHAR;

PROCEDURE WriteReal(r: FFP; width, dec: INTEGER);
 VAR s: String;
 BEGIN
  RealToStr(r, s, width, dec, FALSE, done);
  IF done THEN RealToStr(r, s, width, dec, TRUE, done); END;
  done:=~done; WriteString(s)
 END WriteReal;

PROCEDURE ReadReal(VAR r: FFP);
 VAR s: String;
 BEGIN
  ReadString(s); StrToReal(s, r, done); done:=~done
 END ReadReal;

END FFPInOut.mod
