IMPLEMENTATION MODULE Conversions; (* jr/16sep87 bp/14aug90 *)
(*$ LargeVars:=FALSE
    StackChk:=FALSE
    RangeChk:=FALSE
    OverflowChk:=FALSE
    Volatile:=FALSE
    StackParms:=FALSE
    NilChk:=FALSE
*)

FROM SYSTEM IMPORT ADR,CAST;

TYPE LC=LONGCARD;

PROCEDURE StrToVal(VAR s: ARRAY OF CHAR; VAR l: LONGINT; VAR signed: BOOLEAN;
                   base: INTEGER; VAR err: BOOLEAN);
 CONST max=MAX(LC);
 VAR i, d: INTEGER;
 BEGIN
  l:=0; err:=TRUE; IF (base<2) OR (16<base) THEN RETURN END;
  signed:=s[0]='-'; IF signed OR (s[0]='+') THEN i:=1 ELSE i:=0 END;
  LOOP
   IF i>HIGH(s) THEN EXIT END;
   d:=ORD(s[i]); IF d=0 THEN EXIT END;
   DEC(d, 48); IF d<0 THEN RETURN END;
   IF d>9 THEN IF d<17 THEN RETURN END; DEC(d, 7) END;
   IF (d>=base) OR (LC(l)>(max-LC(d)) DIV LC(base)) THEN RETURN END;
   l:=l*LONGINT(base)+LONGINT(d);
   INC(i)
  END;
  IF signed THEN
   IF LC(l)>80000000H THEN RETURN END; (* negation not allowed *)
   l:=-l
  END;
  err:=FALSE
 END StrToVal;

PROCEDURE ValToStr(l: LONGINT; signed: BOOLEAN; VAR s: ARRAY OF CHAR;
                   base, width: INTEGER; fillC: CHAR; VAR err: BOOLEAN);
 CONST max=31;
 VAR
  hex: POINTER TO ARRAY [0..15] OF CHAR;
  minus: BOOLEAN;
  t: ARRAY [0..max] OF CHAR;
  j, i, n: INTEGER;
 BEGIN
  hex:=ADR('0123456789ABCDEF');
  s[0]:=0C; err:=TRUE; IF (base<2) OR (16<base) THEN RETURN END;
  minus:=signed & (l<0); IF minus THEN l:=-l END;
  i:=max;
  REPEAT
   t[i]:=hex^[INTEGER(LC(l) MOD CAST(CARDINAL,base))];
    l:=LC(l) DIV CAST(CARDINAL,base); DEC(i)
  UNTIL l=0;
  IF minus THEN t[i]:='-' ELSE INC(i) END;
  IF max-i>HIGH(s) THEN RETURN END; (* more digits than characters in 's' *)
  j:=0;
  IF width>HIGH(s)+1 THEN width:=HIGH(s)+1 END; n:=width+i-(max+1);
  WHILE j<n DO s[j]:=fillC; INC(j) END;
  WHILE i<=max DO s[j]:=t[i]; INC(i); INC(j) END;
  n:=-width-1; IF n>HIGH(s) THEN n:=HIGH(s) END;
  WHILE j<=n DO s[j]:=fillC; INC(j) END;
  IF j<=HIGH(s) THEN s[j]:=0C END;
  err:=FALSE
 END ValToStr;

END Conversions.mod
