MODULE AskEnv;
(* 17.2.91/bp Hilfsprogramm fr Scripts *)
(* askenv frage? envvar, legt Antwort in env:envvar ab *)
FROM SYSTEM IMPORT ADR,ADDRESS,CAST,LONGSET,BPTR;
IMPORT T:Terminal,A:Arts, DD:DosD, DL:DosL, Arguments, String;
IMPORT DS:DosSupport;

VAR
  i,args,len:INTEGER;
  arg: ARRAY[1..2] OF ARRAY[0..127] OF CHAR;
  str:ARRAY[0..127] OF CHAR;

PROCEDURE Env;
VAR old:ADDRESS; l:DD.FileLockPtr;
BEGIN
  old:=CAST(DD.ProcessPtr,A.thisTask)^.windowPtr;
  CAST(DD.ProcessPtr,A.thisTask)^.windowPtr:=-1;
  l:=DS.Lock(ADR("ENV:"),DD.sharedLock);
  IF l=NIL THEN
    l:=DS.Lock(ADR("RAM:ENV"),DD.sharedLock);
    IF l=NIL THEN
      l:=DS.CreateDir(ADR("ram:Env"));
    ELSE
    END;
    IF DL.Execute(ADR("Assign ENV: ram:env"),NIL,NIL)=0 THEN END;
  ELSE

  END;
  IF l#NIL THEN DS.UnLock(l) END;
  CAST(DD.ProcessPtr,A.thisTask)^.windowPtr:=old;
END Env;

PROCEDURE Input;
BEGIN
  REPEAT
    T.WriteString(arg[1]);
    T.ReadLn(str,len);
  UNTIL (len>0);
END Input;

PROCEDURE PutEnv;
VAR fh:DD.FileHandlePtr;
BEGIN
  String.Insert(arg[2],0,"ENV:");
  fh:=DS.Open(ADR(arg[2]),DD.newFile);
  IF fh=NIL THEN
    A.Error(ADR("Kann Datei nicht anlegen:"),ADR(arg[2]));
  ELSE (*$ StackParms:=TRUE *)
    String.ConcatChar(str,"\x0a");
    A.Assert(DL.Write(fh,ADR(str),String.Length(str))=String.Length(str),ADR("Schreibfehler"));
    (*$ POP StackParms *)
    DS.Close(fh);
  END;
END PutEnv;

BEGIN
  A.returnVal:=20;
  A.Assert(~A.wbStarted,ADR("Nur vom CLI benutzen!"));
  A.Assert(A.kickVersion>=34,ADR("Braucht Kickstart 1.3!"));
  (* test ob env: sonst auf ram:env anlegen *)
  Env;
  args:=Arguments.NumArgs();
  FOR i:=1 TO args DO
    Arguments.GetArg(i,arg[i],len);
  END;
  A.Assert((args=2)&(arg[1,0]#0C)&(arg[2,0]#0C),ADR("Usage: AskEnv eingabe envvar"));
  Input;
  PutEnv;
  A.returnVal:=0;
END AskEnv.
