IMPLEMENTATION MODULE AmigaLib;
(*
 *	24.04.93/bp
 *	Wichtige fehlende BOOPSI-Prozeduren aus amiga.lib
 *	Alle V37!
 *	02 Sep 1993/bp
 *	HookEntry fuehrte zum Crash. Korrigiert.
 *
 *)

(*$ LargeVars:=FALSE StackChk:=FALSE OverflowChk:=FALSE
    NilChk:=FALSE RangeChk:=FALSE
 *)

FROM SYSTEM IMPORT ADR, ADDRESS, ASSEMBLE, CAST, TAG;
IMPORT	ID: IntuitionD,
	UD: UtilityD,
	R;


TYPE
  TrickObjectPtr=POINTER TO RECORD
    cl: ID.IClassPtr;
    (* Object: *)
  END;


(*$ EntryExitCode:=FALSE *)
PROCEDURE(*36*) CoerceMethodA(cl:ID.IClassPtr; obj:ADDRESS; msg:ADDRESS):ADDRESS;
BEGIN
  ASSEMBLE(
	MOVEA.L	(A7)+,A0	(* ret -> soll Stack *)
	MOVEA.L	(A7)+,A1	(* msg -> soll A1    *)
	MOVE.L	(A7)+,D0	(* obj -> soll A2    *)
	MOVE.L	(A7)+,D1	(* cl  -> soll A0    *)
	MOVE.L	A0,-(A7)	(* RetAdr zurueck *)
	MOVE.L	A2,-(A7)	(* A2 sichern *)
	TST.L	D0
	BEQ.S	cmnullreturn	(* kein obj *)
	TST.L	D1
	BEQ.S	cmnullreturn	(* keine class *)
	MOVEA.L	D0,A2		(* obj *)
	MOVEA.L	D1,A0		(* cl *)
	PEA	cmreturn(PC)
	MOVE.L	ID.IClass.dispatcher.entry(A0),-(A7)
	RTS
  cmnullreturn:
	MOVEQ	#0,D0
  cmreturn:
	MOVEA.L	(A7)+,A2
	RTS
  END);
END CoerceMethodA;

PROCEDURE(*36*) DoMethodA(obj:ADDRESS; msg:ADDRESS):ADDRESS;
VAR
  top{R.A3}:TrickObjectPtr;
BEGIN
  IF obj#NIL THEN
    top:=obj;
    DEC(top,4);
    RETURN CoerceMethodA(top^.cl,obj,msg);
  ELSE
    RETURN 0
  END;
END DoMethodA;

PROCEDURE(*36*) DoSuperMethodA(cl:ID.IClassPtr; obj:ADDRESS; msg:ADDRESS):ADDRESS;
BEGIN
  IF cl#NIL THEN
    RETURN CoerceMethodA(cl^.super,obj,msg);
  ELSE
    RETURN 0
  END;
END DoSuperMethodA;

PROCEDURE(*36*) SetSuperAttrsA(cl:ID.IClassPtr; obj:ADDRESS; tags:ADDRESS):ADDRESS;
VAR
  s: ID.OpSet;
BEGIN
  s.methodID:=ID.omSET;
  s.attrList:=tags;
  s.gInfo:=NIL;
  RETURN DoSuperMethodA(cl, obj, ADR(s));
END SetSuperAttrsA;


(*$ EntryExitCode:=FALSE *)
PROCEDURE(*36*) CallHookA(
                 hook{R.A0}:UD.HookPtr;
                 object{R.A2}:ADDRESS;
                 paramPacket{R.A1}:ADDRESS
                 ):ADDRESS;
BEGIN
  ASSEMBLE(
	MOVE.L	UD.Hook.entry(A0),-(A7)
	RTS
  END);
END CallHookA;

(*$ EntryExitCode:=FALSE *)
PROCEDURE(*36*) HookEntry(hook{R.A0}:UD.HookPtr;
                    obj{R.A2}:ADDRESS;
                    msg{R.A1}:ADDRESS
                    ):ADDRESS;
BEGIN
  ASSEMBLE(
	MOVE.L	hook,-(SP)
	MOVE.L	obj,-(SP)
	MOVE.L	msg,-(SP)
	MOVE.L	UD.Hook.subEntry(hook),A0
	JSR	(A0) (* M2-Proc baut Paras selbst ab! *)
	RTS
  END);
(*
  IF (hook<>NIL) & (hook^.subEntry<>NIL) THEN
    RETURN CAST(HLHookProc,hook^.subEntry)(hook,obj,msg);
  ELSE
    RETURN NIL
  END;
*)
END HookEntry;

END AmigaLib.mod
