	incdir	asm:
	include	rmacros.i

	section	koodi,code

start
	move.l	#1000000,d0
	bsr	sqrt
	rts

sqrt	push	d1-d2/a0
	move.l	d0,a0		; save original input value for the iteration
	beq.b	exit		; unfortunately we must special case zero
	moveq	#2,d1		; init square root guess
	move.l	d0,d2
	swap	d2		; do [and.l 0xFFFF0000,d2] this way to...
	tst.w	d2		; go faster on 68000 and to avoid having to...
	beq.b	skip8		; reload d2 for the next test below
	move	#$200,d1	; faster than lsl.w #8,d1 (68000)
	lsr.l	#8,d0
skip8	and	#$fe00,d2	; this value and shift by 5 are magic
	beq.b	skip4
	lsl	#5,d1
	lsr.l	#5,d0
skip4
loop	add.l	d1,d1
	lsr.l	#1,d0
	cmp.l	d0,d1
	bcs.b	loop
skip	lsr.l	#1,d1		; adjust the approximation
	add.l	d0,d1		; here we just add and shift to...
	lsr.l	#1,d1		; get the first iteration "for free"!
loop2	move.l	a0,d2		; get original input value
	move	d1,d0		; save current guess
	divu	d1,d2		; do the Newton method thing
	bvs.b	exit		; if div overflows, exit with current guess
	add	d2,d1
	roxr	#1,d1		; roxr ensures shifting back carry overflow
	cmp	d0,d1
	bcs.b	loop2		; exit with result in d0.w
exit	pull	d1-d2/a0
	rts
