   }  J  Z                            ;======================================================================
;=== Vector Color Fill Routive V1.2 === (C)1996 by Vlastimil Knotek ===
;======================================================================
MAXPOINTS1	=	8+6
MAXPOINTS2	=	8+6
MAXPOINTS3	=	1
MAXPOINTS4	=	24
SUMAPLANES	=	24
RESOLUTION	=	320
INTERLACE	=	256
DEPTH		=	3
;---------------------------------------------------------
Start:
	movem.l	d0-d7/a0-a6,-(a7)
	bsr	SaveAll
	bsr	InitAll
	bsr	MakeMulsList

	lea	Scene(pc),a1
	bsr	InitAnim
	move.l	chipbase(pc),a6
	bsr	StartCopper
	bsr	MainLoop

	bsr	RestoreAll
	movem.l	(a7)+,d0-d7/a0-a6
	rts

SaveAll:
	move.l	$4.w,a6
	lea.l	GfxName(pc),a1
	moveq	#0,D0
	jsr	-408(a6)	;OldOpenLibrary
	move.l	d0,a1
	lea	OldCopper1(pc),a0
	move.l	$26(a1),(a0)
	lea	OldCopper2(pc),a0
	move.l	$32(a1),(a0)
	jsr	-414(a6)	;CloseLibrary

	move.l	chipbase(pc),a6
	lea	OldDMACON(pc),a0
	move.w	$002(a6),(a0)+
	move.w	$01c(a6),(a0)+
	move.l	$64.w,(a0)+
	rts

InitAll:
	move.l	TMapAddress(pc),a5
	move.l	#((RESOLUTION/8)*INTERLACE)/2-1,d0
.clrbuf	move.w	#0,(a5)+
	dbf	d0,.clrbuf

	lea	Interrupt(pc),a0
	move.l	a0,$64.w
	rts

MakeMulsList:
	move.l	MulsPtr(pc),a0
	moveq	#0,d0
	move.l	#INTERLACE-1,d1
mmloop:	move.w	d0,(a0)+
	addi.w	Width(pc),d0
	dbf	d1,mmloop
	rts

StartCopper:
	cmp.b	#-1,$6(a6)
	bne.s	StartCopper
	move.w	#$7fff,$96(a6)
	move.w	#$7fff,$9a(a6)
	move.l	#CopperList,$80(a6)
	tst.w	$88(a6)
	move.w	#$83c0,$96(a6)
	;move.w	OldINTENA(pc),d0
	;or.w	#$c004,d0
	move.w	#$c004,$9a(a6)
	rts

InitAnim:
	bsr	ClearNorm
	movem.l	PlaneH(pc),d0-d1
	move.l	d0,PlaneS
	move.l	d1,PlaneH
	bsr	ClearNorm	

	move.l	a1,ScenePtr
	move.l	RootPtr(pc),a2
	move.w	(a1)+,d0	; number of objects
	subq.w	#1,d0
IA_01:	move.l	(a1)+,a0	; address of object
	move.l	4(a0),a3
	bsr	PMuls	
	move.l	8(a0),a3
	lea	-14(a3),a3
	move.l	a3,4(a2)	; adresa na cinnost
	move.w	#0,8(a2)
	move.w	#0,10(a2)
	lea	12(a2),a2
	dbf	d0,IA_01

	bsr	Move
	move.w	#0,ends
	rts
PMuls:
	move.l	d0,-(a7)
	move.w	(a3)+,d1
	subq.w	#1,d1
.loop1
	moveq	#0,d0
	move.b	1(a3),d0
	addq.l	#4,a3
.loop2	move.w	(a3),d2
	add.w	d2,d2
	add.w	d2,d2
	move.w	d2,(a3)+
	dbf	d0,.loop2
	dbf	d1,.loop1
	move.l	(a7)+,d0
	rts

MainLoop:
	cmp.b	#-1,$6(a6)
	bne.s	MainLoop
.ml	cmp.b	#$18,$6(a6)
	bne.s	.ml

	bsr	Show
	bsr	ClearNorm	;ClearBig
	bsr	DoAnim

	move.w	ends(pc),d0
	tst.w	d0
	bne.s	mlend

	btst	#6,$bfe001
	beq.s	mlend

	bra.s	MainLoop

mlend	rts

RestoreAll:
	move.l	chipbase(pc),a6
raw:	btst	#6,$dff002
	bne.s	raw
wvb:	cmp.b	#-1,$6(a6)
	bne.s	wvb
	move.w	#$7fff,$96(a6)
	move.w	#$7fff,$9a(a6)
	move.l	OldCopper1(pc),$080(a6)
	tst.w	$88(a6)
	move.l	OldCopper2(pc),$084(a6)
	tst.w	$8a(a6)
	move.l	OldSOFT(pc),$64.w
	move.w	OldDMACON(pc),d0
	or.w	#$8000,d0
	move.w	OldINTENA(pc),d1
	or.w	#$8000,d1
	move.w	d0,$096(a6)
	move.w	d1,$09a(a6)
	rts
;=========================================================
GfxName		DC.B	'graphics.library',0
		even
OldCopper1:	DC.L	0
OldCopper2:	DC.L	0
OldDMACON:	DC.W	0
OldINTENA:	DC.W	0
OldSOFT:	DC.L	0
;=========================================================
Interrupt:
	movem.l	d0-d7/a0-a6,-(a7)
	move.l	chipbase(pc),a6
	bsr	Move
	move.w	#$4,$09c(a6)
	movem.l	(a7)+,d0-d7/a0-a6
	rte
;=========================================================
Show:
	movem.l	PlaneH(pc),d0-d1
	move.l	d0,PlaneS
	move.l	d1,PlaneH
	lea	BitMaps+$2(pc),a0
	moveq.l	#DEPTH-1,d1
.clp:	swap	d0
	move.w	d0,(a0)
	swap	d0
	move.w	d0,4(a0)
	add.l	#(RESOLUTION/8)*INTERLACE,d0
	addq.l	#8,a0
	dbf	d1,.clp
	rts
;---------------------------------------------------------
ClearNorm:
	move.l	chipbase(pc),a6

w1	btst	#6,$dff002
	bne.s	w1
         
	moveq	#-1,d0
	move.l	d0,$44(a6)
	move.w	#0,$66(a6)
	move.l	#$1000000,$40(a6)
	move.l	PlaneH(pc),$54(a6)
	move.w	#DEPTH*INTERLACE*64+RESOLUTION/16,$58(a6)
	rts
;---------------------------------------------------------
ClearBig:
	move.l	chipbase(pc),a6

w2	btst	#6,$dff002
	bne.s	w2
  
	moveq	#-1,d0
	move.l	d0,$44(a6)
	move.w	#0,$66(a6)  
	move.l	#$1000000,$40(a6)
	move.l	PlaneH(pc),$54(a6)
	move.w	#DEPTH*INTERLACE,$5c(a6)
	move.w	#RESOLUTION/16,$5e(a6)
	rts
;---------------------------------------------------------
Move:
	movem.l	d2-d3/a2-a3,-(a7)
	move.l	ScenePtr(pc),a2		; scene struct
	move.l	RootPtr(pc),a3
	move.w	(a2)+,d2		; number of objects
	subq.w	#1,d2
.lab
	move.l	(a2)+,a1	; address of object
	tst.w	10(a3)
	bne.w	.end
	move.l	4(a3),a0
	subq.w	#1,8(a3)
	bge.s	.ok
	lea	14(a0),a0
.ok3:
	cmp.w	#-1,(a0)	; koniec tabulky cinnosti ?
	bgt.s	.ok2
	move.w	#1,10(a3)
	movem.l	(a7)+,d2-d3/a2-a3
	rts
.ok2:
	move.w	(a0),8(a3)
	subq.w	#1,8(a3)
	move.l	a0,4(a3)
.ok:
	addq.l	#2,a0
	move.w	(a0)+,d0
	add.w	d0,12(a1)	; addx
	move.w	(a0)+,d0
	add.w	d0,14(a1)	; addy
	move.w	(a0)+,d0
	add.w	d0,16(a1)	; addz
	move.w	#360,d1
	move.w	d1,d3
	neg.w	d3
	move.w	(a0)+,d0
	add.w	d0,18(a1)	; add alfa
	cmp.w	18(a1),d3	; menej nez -360 ?
	blt.s	.okx
	add.w	d1,18(a1)
.okx:
	cmp.w	18(a1),d1	; viac ako 360 ?
	bgt.s	.ok1x
	sub.w	d1,18(a1)
.ok1x:
	move.w	(a0)+,d0
	add.w	d0,20(a1)	; add beta
	cmp.w	20(a1),d3
	blt.s	.oky
	add.w	d1,20(a1)
.oky:
	cmp.w	20(a1),d1
	bgt.s	.ok1y
	sub.w	d1,20(a1)
.ok1y:
	move.w	(a0)+,d0	; add gama
	add.w	d0,22(a1)
	cmp.w	22(a1),d3
	blt.s	.okz
	add.w	d1,22(a1)
.okz:
	cmp.w	22(a1),d1
	bgt.s	.end
	sub.w	d1,22(a1)
.end:
	lea	12(a3),a3
	dbf	d2,.lab
	movem.l	(a7)+,d2-d3/a2-a3
	rts
;---------------------------------------------------------
DoAnim:
	move.l	zorgptr(pc),ztabptr
	move.l	dtorgptr(pc),dttabptr
	move.w	#-1,drawnum		; forbit drawing
	move.l	RootPtr(pc),a2
	move.l	(a2),tmom
	move.l	ScenePtr(pc),a1
	move.w	(a1)+,d0		; numbers of objects
	subq.w	#1,d0
.ok:
	move.l	(a1)+,a0		; address of object
	movem.l	d0/a1-a2,-(a7)
	move.l	(a0)+,pdptr		; pointer to points
	move.l	(a0)+,atabptr		; pointer to areas
	lea	addx(pc),a1
	addq.l	#4,a0			; set ptr to start coords (x,y,z)
	movem.w	(a0),d0-d5		; x,y,z,alfa,beta,gama
	add.w	d3,d3			; alfa*2
	bge.s	.ok1
	add.w	#720,d3			; angle correction
.ok1:
	add.w	d4,d4
	bge.s	.ok2
	add.w	#720,d4
.ok2:
	add.w	d5,d5
	bge.s	.ok3
	add.w	#720,d5
.ok3:
	ext.l	d0
	asl.l	#4,d0		;start x*16
	ext.l	d1
	asl.l	#4,d1		;start y*16
	ext.l	d2
	asl.l	#4,d2		;start z*16
	movem.l	d0-d2,(a1)	;addx,addy,addz
	lea	12(a1),a1	;rx addrress
	movem.w	d3-d5,(a1)	;write angles to rx,ry,rz

	lea	6*2(a0),a0
	move.l	a0,ColPtr

	bsr.w	transform
	move.l	backside(pc),a0
	jsr	(a0)

	movem.l	(a7)+,d0/a1-a2
.nocalc:
	lea	12(a2),a2
	move.l	(a2),tmom
	dbf	d0,.ok

	bsr.w	vector

	move.l	ScenePtr(pc),a1
	move.w	(a1),d2		;pocet objectov
	subq.w	#1,d2
	move.l	RootPtr(pc),a3
endlp:
	tst.w	10(a3)
	beq.w	.end
	lea	12(a3),a3
	dbf	d2,endlp
	move.w	#1,ends
.end	rts
;---------------------------------------------------------
transform:
	move.l	pdptr(pc),a2	; address of points tab
	move.l	tmom(pc),a3	; address of new 2D coords
	lea	sintab(pc),a0
	lea	costab(pc),a1
	move.l	z2orgptr(pc),a4	; address of Z coords
	move.w	(a2)+,d5	; number of points
	subq.w	#1,d5
lp7:
	movem.w	(a2)+,d0-d2	; read x,y,z
	moveq	#4,d4
	asl.w	d4,d0
	asl.w	d4,d1
	asl.w	d4,d2
	move.w	rx(pc),d3	; rotate x [x angle(alfa)]
	move.w	d1,d4
	move.w	d2,d7
	muls	(a1,d3.w),d1	; ny=y*cos(al)
	muls	(a0,d3.w),d2	; nz=z*sin(al)
	sub.l	d2,d1		; fy=ny-nz
	add.l	d1,d1
	swap	d1
	muls	(a0,d3.w),d4	; ny=y*sin(al)
	muls	(a1,d3.w),d7	; nz=z*cos(al)
	add.l	d7,d4		; fz=ny-nz
	add.l	d4,d4
	swap	d4
	move.w	d4,d2		; d2=z

	move.w	ry(pc),d3
	move.w	d0,d4
	move.w	d2,d7
	muls	(a1,d3.w),d0	; nx=x*cos(be)
	muls	(a0,d3.w),d2	; nz=z*sin(be)
	add.l	d2,d0		; fx=nx+nz
	add.l	d0,d0
	swap	d0
	neg.w	d4		; d4=-x
	muls	(a0,d3.w),d4	; nx=-x*sin(be)
	muls	(a1,d3.w),d7	; ny=y*cos(be)
	add.l	d7,d4		; fz=nx+ny
	add.l	d4,d4
	swap	d4
	move.w	d4,d2

	move.w	rz(pc),d3
	move.w	d0,d4
	move.w	d1,d7
	muls	(a1,d3.w),d0	; nx=x*cos(ga)
	muls	(a0,d3.w),d1	; ny=y*sin(ga)
	sub.l	d1,d0		; fx=nx-ny
	add.l	d0,d0
	swap	d0
	muls	(a0,d3.w),d4	; nx=x*sin(ga)
	muls	(a1,d3.w),d7	; ny=y*cos(ga)
	add.l	d7,d4		; fy=nx+ny
	add.l	d4,d4
	swap	d4
	move.w	d4,d1

;PERSPECTIVE
	move.w	d2,(a4)+	; Z coord
	move.w	d0,(a4)+	; X coord
	ext.l	d0
	ext.l	d1
	ext.l	d2
	add.l	addx(pc),d0
	add.l	addy(pc),d1
	add.l	addz(pc),d2
	moveq	#10,d3
	asl.l	d3,d0
	asl.l	d3,d1
	asr.l	#3,d2
	beq.s	.pjtend
	divs	d2,d0
	divs	d2,d1
	neg.w	d0
	add.w	Midx(pc),d0
	add.w	Midy(pc),d1
.pjtend:
	movem.w	d0-d1,(a3)
;	move.w	#0,(a4)+
	addq.l	#4,a3
	dbf	d5,lp7
	rts
;---------------------------------------------------------
backs:
	move.l	atabptr(pc),a2	; PLOCHY
	move.l	tmom(pc),a3	; 2D SUR
	move.l	z2orgptr(pc),a1	; Z SUR
	lea	8*4(a1),a5	; normals Z coords
	move.l	ztabptr(pc),a0	; Priemer Z
	move.l	dttabptr(pc),a4	; Pointer na plochu (4B) ; +6 Pointer na SUR 
	move.w	(a2)+,d7	; number of areas
	subq.w	#1,d7
lpb:
	tst.w	(a2)		; test number of points
	beq.w	olinb
	tst.b	(a2)
	bne.s	visib
vp3:
	move.w	(a5)+,d6
	addq.w	#2,a5
	asr.w	#4,d6
	ble	notvisib
	asr.w	#3,d6
	add.w	d6,d6
	move.l	ColPtr,a6
	move.w	(a6,d6.w),d5
	move.w	2(a2),d0
	add.w	d0,d0
	add.w	d0,d0
	lea	CopC1+2,a6
	move.w	d5,(a6,d0.w)

visib:	moveq	#0,d6
	move.b	1(a2),d6	; pocita sa priemer Z pre Quicksort
	subq.w	#1,d6
	moveq	#4,d5		; preskoc pocet a farbu
	moveq	#0,d1
.slp:
	move.w	(a2,d5),d0
	add.w	(a1,d0),d1	; suma Z
	addq.w	#2,d5
	dbf	d6,.slp
	addq.w	#1,drawnum
	ext.l	d1
	divs	(a2),d1		; priemer Z
	ext.l	d1
	add.l	addz(pc),d1
	move.l	d1,(a0)+
	move.l	a2,(a4)+	; pointer na plochu
	move.l	a3,(a4)+	; pointer na 2D suradnice
notvisib:
	moveq	#0,d0
	move.b	1(a2),d0
	add.w	d0,d0
	addq.w	#6,d0
	lea	(a2,d0.w),a2
	dbf	d7,lpb		; vsetky plochy
	move.l	a0,ztabptr
	move.l	a4,dttabptr
	subq.l	#4,a0
	move.l	a0,zend    ; koniec ztab - pre Quicksort
	rts
olinb:	rts
;---------------------------------------------------------
vector:
	tst.w	drawnum		; ma sa nieco kreslit ?
	blt.w	end
	bsr.w	quicksort
	move.l	dtorgptr(pc),a5	; zotriedene
	move.w	drawnum(pc),d7
lp:
	move.l	(a5)+,a3	; adresa na plochu
	move.l	(a5),a2		; adresa na 2D suradnice
vp4:
	move.l	linrout(pc),liner
	moveq	#0,d5
	move.b	1(a3),d5	; pocet bodov v ploche
	addq.l	#2,a3
	tst.w	d5
	bne.s	nolin
	move.l	#WLine,liner
	moveq	#1,d5
nolin:
	addq.l	#$4,a5		; next pointer to next area
	subq.w	#1,d5
	move.w	(a3)+,-(a7)	; farba plochy
	moveq	#-1,d0
	lea	hix(pc),a1
	move.w	#320,2(a1)	; reset oblasti na kopirovanie,filovanie,...
	move.w	d0,(a1)
	move.w	#320,6(a1)
	move.w	d0,4(a1)
	move.w	#0,line
	lea	scx1(pc),a4
	move.l	d0,(a4)
	move.l	d0,4(a4)
.lnlp:
	move.w	(a3)+,d6	; cislo vrcholu * 4
	movem.w	(a2,d6),d0-d1	; x,y coords of points
	move.w	(a3),d6		; next point * 4
	movem.w	(a2,d6),d2-d3	; x,y,cords of point
	asr.w	#4,d0
	asr.w	#4,d1
	asr.w	#4,d2
	asr.w	#4,d3
	bsr.w	drawl
	dbf	d5,.lnlp
	cmp.l	#FLine,liner
	bne.s	nodr
	tst.w	scx1
	blt.s	noclip
	tst.w	scx2
	blt.s	noclip
	lea	scx1(pc),a4
	movem.w	(a4),d0-d3
	bsr.w	drawl		;uzatvara pravy okraj ak treba
noclip:
	tst.w	line
	beq.s	nodr
	bsr.w	CSize		; spocitaj velkost oblasti pre Copy/Fill
	move.w	(a7),d4		; farba
	bsr.w	Copy		; Fill, Copy, Buffer clear
nodr:
	addq.l	#2,a7		; zanechanie farby
vok:
	dbf	d7,lp		; vsetky plochy ?
end
	move.l	chipbase(pc),a6
	rts
;---------------------------------------------------------
quicksort:
	moveq	#0,d4
	move.l	zorgptr(pc),d5
	move.l	lrtabptr(pc),a0
	move.l	dtorgptr(pc),a1		; zosortovane cisla
	move.l	d5,(a0,d4.w)
	move.l	zend(pc),a5
	move.l	a5,4(a0,d4.w)
l20:
	move.l	(a0,d4.w),d5
	move.l	4(a0,d4.w),a5
	subq.w	#8,d4
l30:
	move.l	d5,a2
	move.l	a5,a3
	move.l	a2,d1
	sub.l	zorgptr(pc),d1
	add.w	d1,d1
	move.l	a3,d2
	sub.l	zorgptr(pc),d2
	add.w	d2,d2
	move.l	d5,d0
	add.l	a5,d0
	asr.l	#3,d0
	asl.l	#2,d0
	move.l	d0,a6
	move.l	(a6),d3
l40:
	cmp.l	(a2),d3
	ble.s	l41
	addq.l	#4,a2
	addq.w	#8,d1
	bra.s	l40
l41:
	cmp.l	(a3),d3
	bge.s	l42
	subq.l	#4,a3
	subq.w	#8,d2
	bra.s	l41
l42:
	cmp.l	a3,a2
	bgt.s	l50
	move.l	(a3),d0
	move.l	(a2),(a3)
	move.l	d0,(a2)
	exg.l	d0,d5
	movem.l	(a1,d1.w),d5-d6
	move.l	(a1,d2.w),(a1,d1.w)
	move.l	4(a1,d2.w),4(a1,d1.w)
	movem.l	d5-d6,(a1,d2.w)
	exg.l	d0,d5
	addq.l	#4,a2
	subq.l	#4,a3
	addq.w	#8,d1
	subq.w	#8,d2
	cmp.l	a3,a2
	ble.s	l40
l50:
	cmp.l	a5,a2
	blt.s	l52
l51:
	move.l	a3,a5
	cmp.l	a5,d5
	blt.w	l30
	tst.w	d4
	bge.w	l20
	rts
l52:
	addq.w	#8,d4
	move.l	a2,(a0,d4.w)
	move.l	a5,4(a0,d4.w)
	bra.s	l51
;---------------------------------------------------------
drawl:
	movem.l	d4-d7/a5-a6,-(a7)
	cmp.w	d1,d3
	bge.s	.ec
	exg.l	d0,d2
	exg.l	d1,d3
.ec
	cmp.w	6(a1),d1	; loy
	bge.s	.lyk
	move.w	d1,6(a1)
.lyk:
	cmp.w	4(a1),d3	; hiy
	ble.s	.hyk
	move.w	d3,4(a1)
.hyk:
	move.w	d0,d4
	move.w	d2,d5
	cmp.w	d4,d5
	bge.s	.ok
	exg.l	d4,d5
.ok
	cmp.w	2(a1),d4	; lox
	bge.s	.lxk0
	move.w	d4,2(a1)
.lxk0:
	cmp.w	(a1),d5		; hix
	ble.s	chky
	move.w	d5,(a1)
chky:				;clipping
;	move.w	PWidth(pc),d6
;	cmp.w	d6,d0		; point1 napravo za okrajom ?
;	bgt.s	ctx21
;	cmp.w	d6,d2		; point2 napravo za okrajom ?
;	bgt.s	ctx22
;	moveq	#0,d6
;	tst.w	d1
;	bmi.s	cty11		; point1 nad hornym okrajom ?
;	tst.w	d3
;	bmi.s	cty12		; point2 nad hornym okrajom ?
;	move.w	HeightM1(pc),d6
;	cmp.w	d6,d1		; point1 pod spodnym okrajom ?
;	bgt.s	cty21
;	cmp.w	d6,d3		; point2 pod spodnym okrajom ?
;	bgt.s	cty22
;chkx:
;	moveq	#0,d6
;	tst.w	d0		; point1 nalavo za okrajom ?
;	bmi.s	ctx11
;	tst.w	d2		; point2 nalavo za okrajom  ?
;	bmi.s	ctx12
	move.l	liner(pc),a0
	jmp	(a0)
;cty11:				; Clip nad okrajom
;	tst.w	d3		; point2 ber Oberkante (-> ciaru
;	bmi.s	clpend		; nevidno) ?
;	bsr.s	clipy
;	move.w	d4,d0		; berechnete x-Koordinate
;	moveq	#0,d1		; y logischerweise = 0
;	bra.s	chky
;cty12:
;	bsr.s	clipy		; s.o.
;	move.w	d4,d2
;	moveq	#0,d3
;	bra.s	chky
;cty21:				; Clip Unterkante
;	cmp.w	d6,d3		; auch p2 unter Unterkante ?
;	bgt.s	clpend
;	bsr.s	clipy
;	move.w	d4,d0		; berechnete x-Koordinate
;	move.w	d6,d1		; y=255
;	bra.s	chky
;cty22:
;	bsr.s	clipy		; s.o.
;	move.w	d4,d2
;	move.w	d6,d3
;	bra.s	chky
;ctx11:				; Clip linke Kante
;	tst.w	d2		; auch p2 links von
;	bmi.s	clpend		; linker Kante ?
;	bsr.s	clipx
;	move.w	d4,d1		; berechnete y-Koordinate
;	moveq	#0,d0		; x logischerweise = 0
;	bra.s	chky		; noch einmal berprfen
;ctx12:				; s.o.
;	bsr.s	clipx
;	move.w	d4,d3
;	moveq	#0,d2
;	bra.s	chky		; noch einmal berprfen
;ctx21:				; Clip rechte Kante
;	cmp.w	d6,d2		; auch p2 rechts davon ?
;	bgt.s	clpend
;	bsr.s	clipx
;	move.w	d4,d1		; berechnete y-Koordinate
;	move.w	d6,d0		; x=319
;	cmp.l	#endsc,a4
;	beq.s	.ok
;	movem.w	d0-d1,(a4)
;	addq.l	#4,a4
;.ok:
;	bra.w	chky		; noch einmal berprfen
;ctx22:				; s.o.
;	bsr.s	clipx
;	move.w	d4,d3
;	move.w	d6,d2
;	cmp.l	#endsc,a4
;	beq.s	.ok
;	movem.w	d2-d3,(a4)
;	addq.l	#4,a4
;.ok:
;	bra.w	chky		; noch einmal berprfen
;clpend:
;	movem.l	(a7)+,d4-d7/a5-a6
;	rts
;clipy:				; y-Koord. bekannt, x berechnen
;	move.w	d0,d4
;	sub.w	d2,d4
;	move.w	d3,d5
;	move.w	d3,d7
;	sub.w	d6,d7
;	muls	d7,d4		; d4=(x2-x1) * (y bek. - y2)
;	sub.w	d1,d5
;	divs	d5,d4		; d4=d4 / (y2-y1)
;	add.w	d2,d4		; d4=d4 + y2
;	rts
;clipx:				; x-Koordinate bek., y berechnen
;	move.w	d1,d4
;	sub.w	d3,d4
;	move.w	d2,d5
;	move.w	d2,d7
;	sub.w	d6,d7
;	muls	d7,d4		; d4=(y2-y1) * (x bek. -x2)
;	sub.w	d0,d5
;	divs	d5,d4		; d4=d4 / (x2-x1)
;	add.w	d3,d4		; d4=d4 + y2
;	rts
;---------------------------------------------------------
FLine:
	cmp.w	d1,d3
	beq.w	drawend
	move.w	d1,d5
	move.l	MulsPtr(pc),a5
	add.w	d5,d5
	move.w	(a5,d5.w),d5
	ext.l	d5
	move.l	TMapAddress(pc),a5
	add.l	d5,a5
	move.w	d0,d4
	asr.w	#4,d4
	add.w	d4,d4
	lea	(a5,d4.w),a5
	sub.w	d0,d2
	sub.w	d1,d3
	moveq	#15,d5
	and.l	d5,d0
	move.w	d0,d4
	ror.l	#4,d0
	eor.w	d5,d4
	moveq	#0,d5
	bset	d4,d5
	move.w	#4,d0
	tst.w	d2
	bpl.s	.l1
	addq.w	#1,d0
	neg.w	d2
.l1:
	cmp.w	d2,d3
	ble.s	.l2
	exg.l	d2,d3
	subq.w	#4,d0
	add.w	d0,d0
.l2:
	move.w	d3,d4
	sub.w	d2,d4
	add.w	d4,d4
	add.w	d4,d4
	add.w	d3,d3
	moveq	#0,d6
	move.w	d3,d6
	sub.w	d2,d6
	bpl.s	.l3
	or.w	#16,d0
.l3:
	add.w	d3,d3
	add.w	d0,d0
	add.w	d0,d0
	addq.w	#1,d2
	asl.w	#6,d2
	addq.w	#2,d2
	swap	d3
	move.w	d4,d3
	or.l	#$b4a0003,d0
	move.w	Width(pc),d1

	move.l	chipbase(pc),a6

w5	btst	#6,$dff002
	bne.s	w5

	move.w	d1,$60(a6)
	move.w	d1,$66(a6)
	moveq	#-1,d1
	move.l	d1,$44(a6)
	move.w	d1,$72(a6)
	move.w	#$8000,$74(a6)
	move.l	d3,$62(a6)
	eor.w	d5,(a5)
	move.l	a5,$48(a6)
	move.l	a5,$54(a6)
	move.w	d6,$52(a6)
	move.l	d0,$40(a6)
	move.w	d2,$58(a6)
	addq.w	#1,line
drawend:
	movem.l	(a7)+,d4-d7/a5-a6
	rts
;---------------------------------------------------------
WLine:
	move.w	d1,d5
	move.l	MulsPtr(pc),a5
	add.w	d5,d5
	move.w	(a5,d5.w),d5
	ext.l	d5
	move.l	PlaneH(pc),a5
	add.l	d5,a5
	move.w	d0,d4
	asr.w	#4,d4
	add.w	d4,d4
	lea	(a5,d4.w),a5
	sub.w	d0,d2
	sub.w	d1,d3
	moveq	#15,d5
	and.l	d5,d0
	ror.l	#4,d0
	move.w	#4,d0
	tst.w	d2
	bpl.s	.l1
	addq.w	#1,d0
	neg.w	d2
.l1:
	cmp.w	d2,d3
	ble.s	.l2
	exg.l	d2,d3
	subq.w	#4,d0
	add.w	d0,d0
.l2:
	move.w	d3,d4
	sub.w	d2,d4
	add.w	d4,d4
	add.w	d4,d4
	add.w	d3,d3
	moveq	#0,d6
	move.w	d3,d6
	sub.w	d2,d6
	bpl.s	.l3
	or.w	#16,d0
.l3:
	add.w	d3,d3
	add.w	d0,d0
	add.w	d0,d0
	addq.w	#1,d2
	asl.w	#6,d2
	addq.w	#2,d2
	swap	d3
	move.w	d4,d3
	or.l	#$bca0001,d0
	move.w	Width(pc),d1

	move.l	chipbase(pc),a6

w6	btst	#6,$dff002
	bne.s	w6

	move.w	d1,$60(a6)
	move.w	d1,$66(a6)
	moveq	#-1,d1
	move.l	d1,$44(a6)
	move.w	d1,$72(a6)
	move.w	#$8000,$74(a6)
	move.l	d3,$62(a6)
	move.w	28(a7),d1
	moveq	#0,d3
lp6:
	btst	d3,d1
	bne.s	.ok
	and.l	#$ff0fffff,d0
.ok:

w7	btst	#6,$dff002
	bne.s	w7

	move.l	a5,$48(a6)
	move.l	a5,$54(a6)
	move.w	d6,$52(a6)
	move.l	d0,$40(a6)
	move.w	d2,$58(a6)
	or.l	#$00c00000,d0
	add.l	#(RESOLUTION/8)*INTERLACE,a5
	addq.w	#1,d3
	cmp.w	#DEPTH,d3
	blt.s	lp6
	addq.w	#1,line
	movem.l	(a7)+,d4-d7/a5-a6
	rts
;---------------------------------------------------------
CSize:
	move.w	PWidth(pc),d0
	cmp.w	(a1),d0
	bge.s	.ok1
	move.w	d0,(a1)
.ok1:
	tst.w	2(a1)
	bge.s	.ok2
	move.w	#0,2(a1)
.ok2:
	move.w	HeightM1(pc),d0
	cmp.w	4(a1),d0
	bge.s	.ok3
	move.w	d0,4(a1)
.ok3:
	tst.w	6(a1)
	bge.s	.ok4
	move.w	#0,6(a1)
.ok4:
	move.w	(a1),d0
	asr.w	#4,d0
	asl.w	#1,d0
	move.w	d0,woffx
	asr.w	#1,d0
	move.w	2(a1),d1
	asr.w	#4,d1
	sub.w	d1,d0
	addq.w	#1,d0
	move.w	d0,wsizex
	asl.w	#1,d0
	move.w	Width(pc),d1
	sub.w	d0,d1
	move.w	d1,tmpmod
	move.w	4(a1),d0
	sub.w	6(a1),d0
	addq.w	#1,d0
	move.w	d0,wsizey
	move.w	4(a1),d0
	mulu	Width(pc),d0
	move.w	d0,woffy
	rts
;---------------------------------------------------------
Copy:
	move.l	chipbase(pc),a6
	move.l	TMapAddress(pc),a0
	move.l	PlaneH(pc),a1
	moveq	#0,d2
	move.w	woffx(pc),d2
	add.w	woffy(pc),d2
	add.l	d2,a0
	add.l	d2,a1
	move.w	wsizey(pc),d2
	asl.w	#6,d2
	add.w	wsizex(pc),d2
	move.w	tmpmod(pc),d0
	moveq	#-1,d1

w8	btst	#6,$dff002
	bne.s	w8

	move.w	d0,$62(a6)		; BMOD
	move.w	d0,$64(a6)		; AMOD
	move.w	d0,$66(a6)		; DMOD
	move.l	d1,$44(a6)		; AFWM
	move.l	a0,$50(a6)		; APTH
	move.l	a0,$54(a6)		; DPTH
	move.l	#$9f00012,$40(a6)	; CON0	
	move.w	d2,$58(a6)        ; Fllen	; SIZE
	move.l	#$dfc0002,d1
	moveq	#0,d0
	move.l	#$f00000,d3
loop1:
	btst	d0,d4
	bne.w	.ok
	sub.l	d3,d1
.ok:

w9	btst	#6,$dff002
	bne.s	w9

	move.l	d1,$40(a6)	; CON0		A*B	USE A,B,D
	move.l	a0,$50(a6)	; APTH
	move.l	a1,$4c(a6)	; BPTH
	move.l	a1,$54(a6)	; DPTH
	move.w	d2,$58(a6)	; nach Farb-Werten kopieren	; SIZE
	or.l	d3,d1
	add.l	#(RESOLUTION/8)*INTERLACE,a1
	addq.w	#1,d0
	cmp.w	#DEPTH,d0
	blt.s	loop1

w10	btst	#6,$dff002
	bne.s	w10

	move.l	#$1000002,$40(a6)		; CON0		USED
	move.l	a0,$54(a6)			; DPTH
	move.w	d2,$58(a6)   ; Window lschen	; SIZE
	rts
;---------------------------------------------------------
sintab:	DC.W	$011D,$0358,$0592,$07CC,$0A05,$0C3E,$0E75,$10AC,$12E1,$1514
	DC.W	$1746,$1976,$1BA5,$1DD1,$1FFA,$2222,$2446,$2668,$2887,$2AA2
	DC.W	$2CBB,$2ED0,$30E1,$32EE,$34F8,$36FD,$38FE,$3AFB,$3CF3,$3EE7
	DC.W	$40D5,$42BF,$44A3,$4682,$485B,$4A2F,$4BFD,$4DC5,$4F88,$5144
	DC.W	$52F9,$54A9,$5651,$57F3,$598E,$5B23,$5CB0,$5E36,$5FB4,$612B
	DC.W	$629B,$6403,$6563,$66BB,$680C,$6954,$6A94,$6BCC,$6CFC,$6E23
	DC.W	$6F41,$7057,$7164,$7268,$7364,$7456,$7540,$7620,$76F7,$77C5
	DC.W	$788A,$7945,$79F7,$7A9F,$7B3E,$7BD3,$7C5F,$7CE1,$7D59,$7DC8
	DC.W	$7E2D,$7E88,$7ED9,$7F20,$7F5E,$7F91,$7FBB,$7FDB,$7FF1,$7FFD
costab:	DC.W	$7FFF,$7FF7,$7FE5,$7FC9,$7FA3,$7F74,$7F3A,$7EF7,$7EA9,$7E52
	DC.W	$7DF1,$7D87,$7D12,$7C94,$7C0C,$7B7B,$7AE0,$7A3B,$798D,$78D6
	DC.W	$7815,$774B,$7677,$759B,$74B5,$73C6,$72CE,$71CD,$70C4,$6FB1
	DC.W	$6E96,$6D73,$6C47,$6B12,$69D5,$6890,$6743,$65EE,$6491,$632C
	DC.W	$61C0,$604C,$5ED0,$5D4D,$5BC3,$5A31,$5899,$56FA,$5554,$53A7
	DC.W	$51F4,$503A,$4E7B,$4CB5,$4AE9,$4918,$4740,$4564,$4381,$419A
	DC.W	$3FAD,$3DBC,$3BC6,$39CB,$37CC,$35C8,$33C0,$31B4,$2FA4,$2D91
	DC.W	$2B7A,$2960,$2742,$2521,$22FE,$20D8,$1EAF,$1C84,$1A56,$1827
	DC.W	$15F6,$13C3,$118E,$0F58,$0D21,$0AE9,$08B0,$0677,$043C,$0202
	DC.W	$FFC7,$FD8D,$FB52,$F918,$F6DF,$F4A6,$F26E,$F037,$EE02,$EBCE
	DC.W	$E99B,$E76A,$E53B,$E30E,$E0E3,$DEBB,$DC95,$DA72,$D852,$D635
	DC.W	$D41C,$D205,$CFF3,$CDE4,$CBD9,$C9D2,$C7CF,$C5D0,$C3D6,$C1E1
	DC.W	$BFF0,$BE05,$BC1F,$BA3D,$B862,$B68C,$B4BB,$B2F1,$B12C,$AF6E
	DC.W	$ADB5,$AC03,$AA58,$A8B3,$A716,$A57F,$A3EF,$A266,$A0E4,$9F6A
	DC.W	$9DF7,$9C8C,$9B29,$99CE,$987A,$972E,$95EB,$94B0,$937D,$9253
	DC.W	$9131,$9017,$8F07,$8DFF,$8D00,$8C0A,$8B1D,$8A39,$895E,$888C
	DC.W	$87C4,$8705,$864F,$85A3,$8501,$8468,$83D8,$8352,$82D6,$8263
	DC.W	$81FB,$819C,$8147,$80FB,$80BA,$8082,$8055,$8031,$8017,$8007
	DC.W	$8001,$8005,$8013,$802B,$804D,$8078,$80AE,$80ED,$8137,$818A
	DC.W	$81E7,$824D,$82BE,$8338,$83BC,$844A,$84E1,$8582,$862C,$86E0
	DC.W	$879D,$8863,$8933,$8A0C,$8AEE,$8BD9,$8CCE,$8DCB,$8ED1,$8FE0
	DC.W	$90F7,$9217,$9340,$9471,$95AB,$96EC,$9836,$9988,$9AE2,$9C44
	DC.W	$9DAD,$9F1F,$A097,$A217,$A39F,$A52D,$A6C3,$A85F,$AA03,$ABAD
	DC.W	$AD5D,$AF14,$B0D1,$B295,$B45E,$B62D,$B802,$B9DD,$BBBD,$BDA2
	DC.W	$BF8D,$C17C,$C371,$C56A,$C767,$C969,$CB6F,$CD7A,$CF88,$D19A
	DC.W	$D3B0,$D5C9,$D7E5,$DA04,$DC27,$DE4C,$E074,$E29E,$E4CA,$E6F9
	DC.W	$E929,$EB5C,$ED90,$EFC5,$F1FC,$F433,$F66C,$F8A5,$FADF,$FD1A
	DC.W	$FF54,$018F,$03C9,$0603,$083D,$0A76,$0CAF,$0EE6,$111C,$1351
	DC.W	$1584,$17B6,$19E6,$1C13,$1E3F,$2068,$228F,$24B3,$26D4,$28F2
	DC.W	$2B0D,$2D25,$2F39,$314A,$3357,$355F,$3764,$3964,$3B60,$3D57
	DC.W	$3F49,$4137,$431F,$4503,$46E0,$48B9,$4A8C,$4C59,$4E20,$4FE0
	DC.W	$519B,$5350,$54FE,$56A5,$5846,$59DF,$5B72,$5CFE,$5E82,$5FFF
	DC.W	$6175,$62E3,$644A,$65A8,$66FF,$684E,$6995,$6AD3,$6C09,$6D37
	DC.W	$6E5C,$6F79,$708D,$7198,$729B,$7395,$7485,$756D,$764B,$7721
	DC.W	$77ED,$78B0,$7969,$7A19,$7ABF,$7B5C,$7BF0,$7C79,$7CFA,$7D70
	DC.W	$7DDD,$7E3F,$7E99,$7EE8,$7F2D,$7F69,$7F9A,$7FC2,$7FE0,$7FF4

;---------------------------------------------------------
PWidth:		dc.w	RESOLUTION-1
Width:		dc.w	RESOLUTION/8
WWidth:		dc.w	RESOLUTION/16
Height:		dc.w	INTERLACE
HeightM1:	dc.w	INTERLACE-1
Midx:		dc.w	(RESOLUTION/2)<<4
Midy:		dc.w	(INTERLACE/2)<<4
PlaneH:		dc.l	Screen1
PlaneS:		dc.l	Screen2
TMapAddress:	dc.l	Buffer
ends:		dc.w	0

addx     dc.l 0
addy     dc.l 0
addz     dc.l 0
rx       dc.w 0
ry       dc.w 0
rz       dc.w 0
         dc.w 0
pdptr    dc.l 0
anptr    dc.l 0
atabptr  dc.l 0
zend     dc.l 0
hix      dc.w 0
lox      dc.w 0
hiy      dc.w 0
loy      dc.w 0
wsizex   dc.w 1
wsizey   dc.w 1
woffx    dc.w 0
woffy    dc.w 0
tmpmod   dc.w 0
scx1     dc.w 0
scy1     dc.w 0
scx2     dc.w 0
scy2     dc.w 0
endsc
drawnum  dc.w 0
line     dc.w 0
liner    dc.l 0
linrout  dc.l FLine
backside dc.l backs
anim	 dc.l 0
dttabptr dc.l 0
ztabptr  dc.l 0
zorgptr  dc.l zorg
z2orgptr dc.l z2org
dtorgptr dc.l dtorg
lrtabptr dc.l lrtab
tmom:	 dc.l 0
ScenePtr dc.l 0
RootPtr  dc.l Root
chipbase dc.l $dff000
MulsPtr  dc.l MulsList
ColPtr:	 dc.l 0
	cnop	0,2
;=========================================================
Scene:
	dc.w 1
	dc.l Object1

Object1:
	dc.l Body1
	dc.l Plochy1
	dc.l Anim1
	dc.w 0,0,-2000
	dc.w 0,0,0
	dc.w $000,$002,$013,$024,$035,$046,$057,$068
	dc.w $079,$08a,$09b,$0ac,$0bd,$0ce,$0df,$fff
Body1:
	dc.w 8+6
	dc.w -150,-150,150
	dc.w 150,-150,150
	dc.w 150,150,150
	dc.w -150,150,150
	dc.w -150,-150,-150
	dc.w 150,-150,-150
	dc.w 150,150,-150
	dc.w -150,150,-150
	dc.w 0,0,120
	dc.w 120,0,0
	dc.w 0,-120,0
	dc.w -120,0,0
	dc.w 0,120,0
	dc.w 0,0,-120

Plochy1:
	dc.w 6
	dc.w 4,1,0,3,2,1,0
	dc.w 4,2,1,2,6,5,1
	dc.w 4,3,0,1,5,4,0
	dc.w 4,2,0,4,7,3,0
	dc.w 4,3,2,3,7,6,2
	dc.w 4,1,6,7,4,5,6

Anim1:
	dc.w 60,   0,0,12,   1,0,1
	dc.w 350,  0,0,0,   -1,1,1
	dc.w 100,  0,0,-20, 3,4,2
 	dc.w -1				;end of table
 	even
;=========================================================
Root:	dc.l	Coords2DP1
	dc.l	0
	dc.w	0
	dc.w	0
	dc.l	Coords2DP2
	dc.l	0
	dc.w	0
	dc.w	0
	dc.l	Coords2DP3
	dc.l	0
	dc.w	0
	dc.w	0
	dc.l	Coords2DP4
	dc.l	0
	dc.w	0
	dc.w	0
Coords2DP1:
	dcb.b	MAXPOINTS1*4,0
Coords2DP2:
	dcb.b	MAXPOINTS2*4,0
Coords2DP3:
	dcb.b	MAXPOINTS3*4,0
Coords2DP4:
	dcb.b	MAXPOINTS4*4,0
MulsList:
	dcb.w	INTERLACE,0
	even
;---------------------------------------------------------
CopperList:
	dc.w	$008E,$2C81,$0090,$2CC1
	dc.w	$0092,$0038,$0094,$00D0
	dc.w	$01A0,$0999,$01A2,$0876,$01A4,$0543,$01A6,$0321	; spr cols
	dc.w	$01A8,$0CBA,$01AA,$0EDC,$01AC,$0F40,$01AE,$0F60
	dc.w	$01B0,$0F80,$01B2,$0FB0,$01B4,$0FD0,$01B6,$0FD3
	dc.w	$01B8,$0FE9,$01BA,$0FFF,$01BC,$0F4C,$01BE,$0F8F
	dc.w	$0108,$0000,$010A,$0000
CopC1:	dc.w	$0180,$0999,$0182,$0000,$0184,$0000,$0186,$0000
	dc.w	$0188,$0000,$018A,$0000,$018C,$0000,$018E,$0F00
BitMaps:
	dc.w	$00E0,$0000,$00E2,$0000
	dc.w	$00E4,$0000,$00E6,$0000
	dc.w	$00E8,$0000,$00EA,$0000
	dc.w	$0100,$3200,$0102,$0000,$0104,$003f
	dc.w	$0108,$0000,$010A,$0000
	dc.w	$ffdf,$fffe
	dc.w	$009c,$8004
	dc.w	$ffff,$fffe
	even
;------------------------------------
Screen1:	dcb.b	40*256*3,0
Screen2:	dcb.b	40*256*3,0
Buffer:		dcb.b	40*256,0

	cnop	0,4
zorg:	dcb.l	68,0		; sum of areas
z2org:	dcb.l	156,0		; max amount of points in scene
lrtab:	dcb.l	68,0		; sum of areas
dtorg:	dcb.b	68*14,0		; sum of areas * 14
