  	1                                    ;======================================================================
;=== Vector Color Fill Routive V1.2 === (C)1996 by Vlastimil Knotek ===
;======================================================================
Start:
	movem.l	d0-d7/a0-a6,-(a7)
	bsr	SaveAll
	bsr	InitAll
	bsr	MakeMulsList
	bsr	StartCopper
	bsr	MainLoop
	bsr	RestoreAll
	movem.l	(a7)+,d0-d7/a0-a6
	rts

SaveAll:
	move.l	$4.w,a6
	lea.l	GfxName(pc),a1
	moveq	#0,D0
	jsr	-408(a6)	;OldOpenLibrary
	move.l	d0,a1
	lea	OldCopper1(pc),a0
	move.l	$26(a1),(a0)
	lea	OldCopper2(pc),a0
	move.l	$32(a1),(a0)
	jsr	-414(a6)	;CloseLibrary

	move.l	chipbase(pc),a6
	lea	OldDMACON(pc),a0
	move.w	$002(a6),(a0)+
	move.w	$01c(a6),(a0)+
	rts

InitAll:
	lea	BitMaps+$2,a0
	move.l	PlaneS(pc),d0
	adda.l	#64*56+8,d0
	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
	rts

MakeMulsList:
	move.l	MulsPtr(pc),a0
	moveq	#0,d0
	move.l	#384-1,d1
mmloop:	move.w	d0,(a0)+
	addi.w	#56,d0
	dbf	d1,mmloop
	rts

StartCopper:
	move.l	#CopperList,$80(a6)
	tst.w	$88(a6)
	move.w	#$7fff,$96(a6)
	move.w	#$83c0,$96(a6)
	move.w	#$7fff,$9a(a6)
	;move.w	OldINTENA(pc),d0
	;or.w	#$c000,d0
	move.w	#$c000,$9a(a6)
	rts

MainLoop:
	cmp.b	#-1,$6(a6)
	bne.s	MainLoop

	bsr	DoubleBuffer
	bsr	Tunnel

	move.l	chipbase(pc),a6


wlm:	btst	#6,$bfe001
	bne.s	MainLoop
	rts

RestoreAll:
	move.l	chipbase(pc),a6
raw:	btst	#6,$dff002
	bne.s	raw
	move.l	OldCopper1(pc),$080(a6)
	tst.w	$88(a6)
	move.l	OldCopper2(pc),$084(a6)
	tst.w	$8a(a6)
	move.w	OldDMACON(pc),d0
	or.w	#$8000,d0
	move.w	OldINTENA(pc),d1
	or.w	#$8000,d1
	move.w	d0,$096(a6)
	move.w	d1,$09a(a6)
	rts
;=========================================================
GfxName:	DC.B	'graphics.library',0
		even
OldCopper1:	DC.L	0
OldCopper2:	DC.L	0
OldDMACON:	DC.W	0
OldINTENA:	DC.W	0
;=========================================================
DoubleBuffer:
	movem.l	PlaneH(pc),d0-d2	; H S C
	move.l	d0,PlaneS
	move.l	d1,PlaneC
	move.l	d2,PlaneH
	lea	BitMaps+$2,a0
	addi.l	#64*56+8,d0
	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
;---------------------------------------------------------
ClearNorm:
	move.l	chipbase(pc),a6

w1:	btst	#6,$dff002
	bne.s	w1
         
	moveq	#-1,d0
	move.l	d0,$44(a6)
	move.w	#16,$66(a6)
	move.l	#$1000000,$40(a6)
	move.l	PlaneC(pc),d0
	addi.l	#64*56+8,d0
	move.l	d0,$54(a6)
	move.w	#256*64+20,$58(a6)
	rts
;---------------------------------------------------------
Tunnel:
	lea	Pers(pc),a2
	move.l	PlaneH(pc),a3
	move.l	MulsPtr(pc),a4
	lea	zc(pc),a5
	lea	jv(pc),a6

	moveq	#0,d0
	moveq	#0,d1
	moveq	#0,d2
	moveq	#0,d3

	move.w	#24,zcnt

z_loop:
	lea	sintab2(pc),a0
	lea	sintab2+90*2(pc),a1

	move.w	(a6),d0			; J
	lsr.w	#2,d0
	add.w	d0,d0
	move.w	(a0,d0.w),d0		; Sin(J/2)
	move.w	(a6)+,d1
	lsr.w	#3,d1
	add.w	d1,d1
	move.w	(a1,d1.w),d1		; Cos(J/4)

	move.w	(a5)+,d6
	add.w	d6,d6

	lea	sintab(pc),a0
	lea	sintab+90*2(pc),a1

	move.w	#36,ccnt
	move.w	#0,d5			; I
circle_loop:
	move.w	(a0,d5.w),d2		; Sin(I)
	move.w	(a1,d5.w),d3		; Cos(I)
	add.w	d0,d2			; Sin(I)+Sin(J/2)
	add.w	d1,d3			; Cos(I)+Sin(J/2)
	muls	(a2,d6.w),d2
	muls	(a2,d6.w),d3
	asr.l	#7,d2
	asr.l	#7,d2
	asr.l	#7,d3
	asr.l	#7,d3
	sub.w	d0,d2
	sub.w	d1,d3
	add.w	Midx(pc),d2
	add.w	Midy(pc),d3
	add.w	d3,d3
	move.w	(a4,d3.w),d3		; y * 56
	move.w	d2,d7
	lsr.w	#3,d2
	add.w	d2,d3
	eori.w	#7,d7
	bset	d7,(a3,d3.w)		; draw point
	addi.w	#20,d5			; I
	subq.w	#1,ccnt
	bne.s	circle_loop
	subq.w	#1,zcnt
	bne.w	z_loop

	lea	zc(pc),a0
	lea	jv(pc),a1
	moveq	#24-1,d0
ztst:	subi.w	#60,(a0)
	bge.s	zok
	addi.w	#1200,(a0)+
	addi.w	#242,(a1)
jvtst:	cmpi.w	#720*4,(a1)
	blt.s	jvok
	subi.w	#720*4,(a1)
jvok:	addq.w	#2,a1
	dbf	d0,ztst
	rts

zok:	addq.w	#2,a0
	addi.w	#2,(a1)
	bra.s	jvtst

ccnt:	dc.w	0
zcnt:	dc.w	0

zc:	dc.w	0,50,100,150,200,250,300,350,400,450
	dc.w	500,550,600,650,700,750,800,850,900,950
	dc.w	1000,1050,1100,1150
jv:	dc.w	0,10,20,30,40,50,60,70,80,90
	dc.w	100,110,120,130,140,150,160,170,180,190
	dc.w	200,210,220,230

Midx:		dc.w	224
Midy:		dc.w	192
PlaneH:		dc.l	Screen1
PlaneS:		dc.l	Screen2
PlaneC:		dc.l	Screen3

chipbase:	dc.l $dff000
MulsPtr:	dc.l MulsList
;---------------------------------------------------------
sintab:		incbin	'sin.data'
sintab2:	incbin	'sin2.data'
Pers:		incbin	'tunel.data'
;=========================================================
MulsList:	dcb.w	384,0
;=========================================================
	section	'copper',data_c
CopperList:
	dc.w	$008E,$2C81,$0090,$2CC1
	dc.w	$0092,$0038,$0094,$00D0
	dc.w	$0180,$0000,$0182,$0FFF
BitMaps:
	dc.w	$00e0,$0000,$00e2,$0000
	dc.w	$0100,$1200,$0108,$0010,$010A,$0010
	dc.w	$ffff,$fffe
	even
;------------------------------------
	section	'screens',BSS_C

Screen1:	ds.b	56*384
Screen2:	ds.b	56*384
Screen3:	ds.b	56*384
