                                        ;===============================================
;=== METHAMORPH V1.1b			     ===
;=== Copyright (C)1997 by Vlastimil Knotek   ===
;=== Assembler used: ASM-ONE V1.29 by T.F.A. ===
;=== Released day: 22th October 1997         ===
;=== File: metamorph2.s			     ===
;===============================================
>EXTERN	'tbsd:Morph_Hand_Zoom/bitmapdef/CAmiga.RAW',Face1
>EXTERN	'tbsd:Morph_Hand_Zoom/bitmapdef/Elvira.RAW',Face2
TopLeftCornerX1	=	50
TopLeftCornerY1	=	10
TopLeftCornerX2	=	25
TopLeftCornerY2	=	10
SPEED	=	5
;----------------------------
Start:
	movem.l	d0-d7/a0-a6,-(a7)
	bsr	SaveAll
	bsr	InitAll
	bsr	SetDeltas
	bsr	MakeMulsList

	move.l	#module,tp_data
	jsr	tp_init
	lea	$dff000,a6

	bsr	StartCopper
	bsr	DrawFirst
	bsr	MainLoop
	movem.l	(a7)+,d0-d7/a0-a6
	jmp	StartPart2
;----------------------------
SaveAll:
;	move.l	$4.w,a6
;	lea.l	GfxName(pc),a1
;	moveq	#0,D0
;	jsr	-408(a6)	;OldOpenLibrary
;	move.l	d0,a1
	lea	OldCopper1(pc),a0
	move.l	$100,(a0)
;	move.l	$26(a1),(a0)
	lea	OldCopper2(pc),a0
	move.l	$104,(a0)
;	move.l	$32(a1),(a0)
;	jsr	-414(a6)	;CloseLibrary

	move.l	chipbase(pc),a6
	lea	OldDMACON(pc),a0
	move.w	$002(a6),(a0)+
	move.w	$01c(a6),(a0)+
	move.l	$6c.w,(a0)
	rts
;----------------------------
InitAll:
	move.l	Screen(pc),d0
	lea	CopBitMaps+$2(pc),a0
	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)

	move.l	Field1Ptr(pc),a0
	addq.w	#2,a0
	move.l	Face1Ptr(pc),a1
	moveq	#0,d5
	move.l	#TopLeftCornerX1,d3
	move.l	#TopLeftCornerY1,d4
	move.l	#217-1,d0
All1:
	moveq	#28-1,d1
OneLine1:
	moveq	#8-1,d2
OneByte1:
	btst	d2,(a1)
	beq.s	NoSet1
	move.l	d3,(a0)+
	move.l	d4,(a0)+
	addq.w	#1,d5
NoSet1:	addq.w	#1,d3
	dbf	d2,OneByte1
	addq.l	#1,a1
	dbf	d1,OneLine1
	move.l	#TopLeftCornerX1,d3
	addq.w	#1,d4
	dbf	d0,All1
	move.l	Field1Ptr(pc),a0
	move.w	d5,(a0)

	move.l	Field2Ptr(pc),a0
	addq.w	#2,a0
	move.l	Face2Ptr(pc),a1
	moveq	#0,d5
	move.l	#TopLeftCornerX2,d3
	move.l	#TopLeftCornerY2,d4
	move.l	#147-1,d0
All2:
	moveq	#32-1,d1
OneLine2:
	moveq	#8-1,d2
OneByte2:
	btst	d2,(a1)
	beq.s	NoSet2
	move.l	d3,(a0)+
	move.l	d4,(a0)+
	addq.w	#1,d5
NoSet2:	addq.w	#1,d3
	dbf	d2,OneByte2
	addq.l	#1,a1
	dbf	d1,OneLine2
	move.l	#TopLeftCornerX2,d3
	addq.w	#1,d4
	dbf	d0,All2
	move.l	Field2Ptr(pc),a1
	move.w	d5,(a1)

	move.l	Field1Ptr(pc),a0
	move.w	(a0),d4
	cmp.w	d4,d5
	bgt.s	Correction1
	blt.s	Correction2
	rts
Correction1:
	move.w	d5,(a0)+
	sub.w	d4,d5
	add.w	d4,d4
	add.w	d4,d4
	add.w	d4,d4
	subq.w	#1,d5
Corr1:	move.l	(a0),(a0,d4.w)
	addq.w	#4,a0
	move.l	(a0),(a0,d4.w)
	addq.w	#4,a0
	dbf	d5,Corr1
	rts
Correction2:
	move.w	d4,(a1)+
	sub.w	d5,d4
	add.w	d5,d5
	add.w	d5,d5
	add.w	d5,d5
	subq.w	#1,d4
Corr2:	move.l	(a1),(a1,d5.w)
	addq.w	#4,a1
	move.l	(a1),(a1,d5.w)
	addq.w	#4,a1
	dbf	d4,Corr2
	rts
;----------------------------
SetDeltas:
	move.l	Field1Ptr(pc),a0
	move.l	Field2Ptr(pc),a1
	move.l	FieldDeltaPtr(pc),a2
	addq.w	#2,a1
	move.w	(a0)+,d7
	subq.w	#1,d7
SD_Loop:
	move.l	(a0)+,d0
	move.l	(a0)+,d1
	move.l	(a1)+,d2
	move.l	(a1)+,d3
	sub.l	d0,d2
	sub.l	d1,d3
	addq.l	#1,d2
	addq.l	#1,d3
	swap	d2
	swap	d3
	clr.w	d2
	clr.w	d3
	asr.l	#SPEED,d2
	asr.l	#SPEED,d3
	move.l	d2,(a2)+
	move.l	d3,(a2)+
	dbf	d7,SD_Loop

	move.l	Field1Ptr(pc),a0
	move.w	(a0)+,d7
	subq.w	#1,d7
Multi_Loop:
	move.l	(a0),d0
	swap	d0
	move.l	d0,(a0)+
	move.l	(a0),d0
	swap	d0
	move.l	d0,(a0)+
	dbf	d7,Multi_Loop
	rts
;-----------------------------------
DrawFirst:
	move.l	Field1Ptr(pc),a0
	move.l	MulsListPtr(pc),a1
	lea	Screen(pc),a3
	move.l	(a3)+,a2
	move.l	(a3),a3
	move.w	(a0)+,d6
	subq.w	#1,d6
DrawF:
	move.l	(a0)+,d0
	move.l	(a0)+,d1
	swap	d0
	swap	d1
	move.w	d0,d2
	add.w	d1,d1
	move.w	(a1,d1.w),d3
	lsr.w	#3,d2
	add.w	d2,d3
	and.w	#$f,d0
	not.b	d0
	bset	d0,(a2,d3.w)
	bset	d0,(a3,d3.w)
	dbf	d6,DrawF

	lea	$dff000,a6
w11:	cmpi.b	#-1,$6(a6)
	bne.s	w11
	lea	cnt11(pc),a0
	subq.w	#1,(a0)
	bne.s	w11
	rts

cnt11:	dc.w	500
;----------------------------
MakeMulsList:
	move.l	MulsListPtr(pc),a0
	moveq	#0,d0
	move.l	#256-1,d1
MML_Loop:
	move.w	d0,(a0)+
	addi.w	#40,d0
	dbf	d1,MML_Loop
	rts
;----------------------------
StartCopper:
	cmpi.b	#-1,$6(a6)
	bne.s	StartCopper
	move.w	#$24,$9a(a6)
sc1wb:	btst	#6,$2(a6)
	bne.s	sc1wb
	move.w	#$40,$096(a6)
sc1wvb:	cmpi.b	#-1,$6(a6)
	bne.s	sc1wvb
	move.w	#$7fff,$96(a6)
	move.w	#$3fff,$9a(a6)
	lea	CopperList(pc),a0
	move.l	a0,$80(a6)
	tst.w	$88(a6)
	move.w	#$83C0,$96(a6)
	lea	NewVB(pc),a0
	move.l	a0,$6c.w
	move.w	#$c020,$9a(a6)
	rts
;----------------------------
MainLoop:
	move.l	#2^SPEED,d7
Main:	cmp.b	#-1,$6(a6)
	bne.s	Main

	bsr	DoubleBuffer

	;move.w	#$0f00,$DFF180
	bsr	DoMetamorph
	;move.w	#$0000,$dff180

	dbf	d7,Main

	lea	$dff000,a6
w12:	cmpi.b	#-1,$6(a6)
	bne.s	w12
	lea	cnt12(pc),a0
	subq.w	#1,(a0)
	bne.s	w12
	rts

cnt12:	dc.w	500
;----------------------------
RestoreAll:
	jsr	tp_end
	move.l	chipbase(pc),a6
ra_wvb:	cmpi.b	#-1,$6(a6)
	bne.s	ra_wvb
	move.w	#$7fff,$9a(a6)
ra_wb:	btst	#6,$2(a6)
	bne.s	ra_wb
	move.w	#$7fff,$96(a6)
	move.l	OldCopper1(pc),$080(a6)
	tst.w	$88(a6)
	move.l	OldCopper2(pc),$084(a6)
	tst.w	$8a(a6)
	move.l	OldVB(pc),$6c.w
	move.w	OldDMACON(pc),d0
	or.w	#$8000,d0
	move.w	OldINTENA(pc),d1
	or.w	#$8000,d1
	move.w	d0,$096(a6)
	move.w	d1,$09a(a6)
	rts
;============================
GfxName		DC.B	'graphics.library',0
		even
OldCopper1:	DC.L	0
OldCopper2:	DC.L	0
OldDMACON:	DC.W	0
OldINTENA:	DC.W	0
OldVB:		dc.l	0
chipbase:	DC.L	$DFF000
;============================
NewVB:
	movem.l	d0-d7/a0-a6,-(sp)
	jsr	tp_play
	movem.l	(sp)+,d0-d7/a0-a6
	move.w	#$20,$dff09c
	rte
;============================
DoubleBuffer:
	lea	Screen(pc),a0
	movem.l	(a0),d0-d2
	exg.l	d0,d2
	exg.l	d0,d1
	movem.l	d0-d2,(a0)

	lea	CopBitMaps+$2(pc),a0
	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)

	lea	$DFF000,a6
WaitBlit:
	btst	#6,$dff002
	bne.s	WaitBlit
	move.w	#0,$066(a6)
	move.l	d2,$054(a6)
	move.l	#$01000000,$040(a6)
	move.w	#256*64+20,$058(a6)
	rts
;----------------------------
DoMetamorph:
	move.l	Field1Ptr(pc),a0
	move.l	FieldDeltaPtr(pc),a3
	move.l	MulsListPtr(pc),a1
	move.l	Screen+$4(pc),a2
	move.w	(a0)+,d6
	subq.w	#1,d6
Draw:	move.l	(a0),d0
	move.l	4(a0),d1
	add.l	(a3)+,d0
	add.l	(a3)+,d1
	move.l	d0,(a0)+
	move.l	d1,(a0)+
	swap	d0
	swap	d1
	move.w	d0,d2
	add.w	d1,d1
	move.w	(a1,d1.w),d3
	lsr.w	#3,d2
	add.w	d2,d3
	not.b	d0
	bset	d0,(a2,d3.w)
	dbf	d6,Draw
	rts
;----------------------------
Screen:
	dc.l	Buffer1,Buffer2,Buffer3
Field1Ptr:
	dc.l	Field1
Field2Ptr:
	dc.l	Field2
Face1Ptr:
	dc.l	Face1
Face2Ptr:
	dc.l	Face2
FieldDeltaPtr:
	dc.l	FieldDelta
MulsListPtr:
	dc.l	MulsList
;----------------------------
CopperList:
	dc.w	$008E,$2C81,$0090,$2CC1
	dc.w	$0092,$0038,$0094,$00D0
	dc.w	$0102,$0000,$0104,$0000
	dc.w	$0180,$0000,$0182,$0FFF
CopBitMaps:
	dc.w	$00E0,$0000,$00E2,$0000
	dc.w	$0100,$1200,$0108,$0000,$010A,$0000
	dc.w	$ffff,$fffe
;----------------------------
MulsList:	dcb.w	256,0
Field1:		dcb.l	1+2*3000,0
Field2:		dcb.l	1+2*3000,0
FieldDelta:	dcb.l	2*3000,0 ;p,konst1,konst2,addx,addy,XorY
Face1:		dcb.b	28*217,0
Face2:		dcb.b	32*147,0
Buffer1:	dcb.b	40*256,0
Buffer2:	dcb.b	40*256,0
Buffer3:	dcb.b	40*256,0

;*********************************************************
;*********************************************************
;*********************************************************
;*********************************************************
;*********************************************************
;======================================================================
;=== Vector Color Fill Routive V1.2 === (C)1996 by Vlastimil Knotek ===
;======================================================================
StartPart2:
	movem.l	d0-d7/a0-a6,-(a7)
	bsr	InitAllPart2

	move.l	chipbasePart2(pc),a6
	bsr	StartCopperPart2
	bsr	MainLoopPart2

	movem.l	(a7)+,d0-d7/a0-a6
	jmp	StartPart3

InitAllPart2:
	lea	BM1Part2+2(pc),a1
	lea	BM2Part2+2(pc),a0
	move.l	#Screen1Part2+40*3*40,d0
	move.l	#Screen3Part2,d1
	moveq	#3-1,d2
setbmPart2:	move.w	d0,4(a0)
	move.w	d1,4(a1)
	swap	d0
	swap	d1
	move.w	d0,(a0)
	move.w	d1,(a1)
	swap	d0
	swap	d1
	addi.l	#40,d0
	addi.l	#40,d1
	addq.w	#8,a0
	addq.w	#8,a1
	dbf	d2,setbmPart2

	rts

StartCopperPart2:
	cmpi.b	#-1,$6(a6)
	bne.s	StartCopperPart2
	move.w	#$24,$9a(a6)
sc2wb:	btst	#6,$2(a6)
	bne.s	sc2wb
	move.w	#$40,$096(a6)
sc2wvb:	cmpi.b	#-1,$6(a6)
	bne.s	sc2wvb
	move.w	#$7ff0,$96(a6)
	move.w	#$3fdf,$9a(a6)
	move.l	#CopperListPart2,$80(a6)
	tst.w	$88(a6)
	move.w	#$87c0,$96(a6)
	move.w	#$c020,$9a(a6)
	rts

MainLoopPart2:
	cmp.b	#-1,$6(a6)
	bne.s	MainLoopPart2

	bsr	DoubleBufferPart2
	bsr	RotatePart2

	lea	cnt2(pc),a0
	subq.w	#1,(a0)
	bne.s	MainLoopPart2
	rts

cnt2:	dc.w	450
;=========================================================
chipbasePart2:	dc.l	$dff000
ScreenPart2:		dc.l	Screen1Part2,Screen2Part2
;=========================================================
DoubleBufferPart2:
	lea	ScreenPart2(pc),a0
	movem.l	(a0),d0/d1
	exg.l	d0,d1
	movem.l	d0/d1,(a0)
db_bltwaitPart2:
	btst	#6,$2(a6)
	bne.s	db_bltwaitPart2

	move.l	d1,$50(a6)	; apth
	move.l	d0,$54(a6)	; dpth
	move.l	#0,$64(a6)	; amod, dmod
	move.l	#-1,$44(a6)	; afwm, alwm
	move.l	#$9f00000,$40(a6)	; con0, con1
	move.w	#320*3<<6+20,$58(a6)

	lea	BM2Part2+2(pc),a0
	move.l	ScreenPart2+4,d0
	addi.l	#40*3*40,d0
	moveq	#3-1,d2
db_setbmPart2:
	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
	swap	d0
	addi.l	#40,d0
	addq.w	#8,a0
	dbf	d2,db_setbmPart2
	rts

RotatePart2:
	lea	timesPart2(pc),a0
	subq.w	#1,(a0)
	beq.s	antispinPart2

	lea	BlitDatPart2(pc),a0
	move.l	ScreenPart2,a1
	move.l	ScreenPart2,a2
	moveq	#40-1,d0
rloopPart2:	btst	#6,$2(a6)
	bne.s	rloopPart2
	move.l	(a0)+,d1
	move.l	(a0)+,d2
	lea	(a1,d1.l),a3
	lea	(a2,d2.l),a4
	move.l	a3,$50(a6)
	move.l	a4,$54(a6)
	move.l	(a0)+,$64(a6)
	move.l	(a0)+,$44(a6)
	move.l	(a0)+,$40(a6)
	move.w	(a0)+,$58(a6)
	dbf	d0,rloopPart2
	rts

antispinPart2:
	move.w	#1,(a0)

	lea	BlitDat2Part2(pc),a0
	move.l	ScreenPart2,a1
	move.l	ScreenPart2,a2
	moveq	#40-1,d0
rloop1Part2:	btst	#6,$2(a6)
	bne.s	rloop1Part2
	move.l	(a0)+,d1
	move.l	(a0)+,d2
	lea	(a1,d1.l),a3
	lea	(a2,d2.l),a4
	move.l	a3,$50(a6)
	move.l	a4,$54(a6)
	move.l	(a0)+,$64(a6)
	move.l	(a0)+,$44(a6)
	move.l	(a0)+,$40(a6)
	move.w	(a0)+,$58(a6)
	dbf	d0,rloop1Part2
	rts

timesPart2:	dc.w	150

BlitDatPart2:
	Dc.l	40*16*3*0,40*16*3*0
	Dc.w	0,0,$ffff,$fc00,$a9f0,$0000,16*3<<6+20
	Dc.l	40*16*3*1,40*16*3*1
	Dc.w	0,0,$ffff,$fe00,$99f0,$0000,16*3<<6+20
	Dc.l	40*16*3*2,40*16*3*2
	Dc.w	0,0,$ffff,$ff00,$89f0,$0000,16*3<<6+20
	Dc.l	40*16*3*3,40*16*3*3
	Dc.w	0,0,$ffff,$ff80,$79f0,$0000,16*3<<6+20
	Dc.l	40*16*3*4,40*16*3*4
	Dc.w	0,0,$ffff,$ffc0,$69f0,$0000,16*3<<6+20
	Dc.l	40*16*3*5,40*16*3*5
	Dc.w	0,0,$ffff,$ffe0,$59f0,$0000,16*3<<6+20
	Dc.l	40*16*3*6,40*16*3*6
	Dc.w	0,0,$ffff,$fff0,$49f0,$0000,16*3<<6+20
	Dc.l	40*16*3*7,40*16*3*7
	Dc.w	0,0,$ffff,$fff8,$39f0,$0000,16*3<<6+20
	Dc.l	40*16*3*8,40*16*3*8
	Dc.w	0,0,$ffff,$fffc,$29f0,$0000,16*3<<6+20
	Dc.l	40*16*3*9,40*16*3*9
	Dc.w	0,0,$ffff,$fffe,$19f0,$0000,16*3<<6+20

	Dc.l	40*16*3*11-2,40*16*3*11-2
	Dc.w	0,0,$ffff,$7fff,$19f0,$0002,16*3<<6+20
	Dc.l	40*16*3*12-2,40*16*3*12-2
	Dc.w	0,0,$ffff,$3fff,$29f0,$0002,16*3<<6+20
	Dc.l	40*16*3*13-2,40*16*3*13-2
	Dc.w	0,0,$ffff,$1fff,$39f0,$0002,16*3<<6+20
	Dc.l	40*16*3*14-2,40*16*3*14-2
	Dc.w	0,0,$ffff,$0fff,$49f0,$0002,16*3<<6+20
	Dc.l	40*16*3*15-2,40*16*3*15-2
	Dc.w	0,0,$ffff,$07ff,$59f0,$0002,16*3<<6+20
	Dc.l	40*16*3*16-2,40*16*3*16-2
	Dc.w	0,0,$ffff,$03ff,$69f0,$0002,16*3<<6+20
	Dc.l	40*16*3*17-2,40*16*3*17-2
	Dc.w	0,0,$ffff,$01ff,$79f0,$0002,16*3<<6+20
	Dc.l	40*16*3*18-2,40*16*3*18-2
	Dc.w	0,0,$ffff,$00ff,$89f0,$0002,16*3<<6+20
	Dc.l	40*16*3*19-2,40*16*3*19-2
	Dc.w	0,0,$ffff,$007f,$99f0,$0002,16*3<<6+20
	Dc.l	40*16*3*20-2,40*16*3*20-2
	Dc.w	0,0,$ffff,$003f,$a9f0,$0002,16*3<<6+20

	Dc.l	40*3*10+0,0
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0000,320*3<<6+1
	Dc.l	40*3*9+2,2
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0000,320*3<<6+1
	Dc.l	40*3*8+4,4
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0000,320*3<<6+1
	Dc.l	40*3*7+6,6
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0000,320*3<<6+1
	Dc.l	40*3*6+8,8
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0000,320*3<<6+1
	Dc.l	40*3*5+10,10
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0000,320*3<<6+1
	Dc.l	40*3*4+12,12
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0000,320*3<<6+1
	Dc.l	40*3*3+14,14
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0000,320*3<<6+1
	Dc.l	40*3*2+16,16
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0000,320*3<<6+1
	Dc.l	40*3*1+18,18
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0000,320*3<<6+1

	Dc.l	40*3*319-20,40*3*320-20
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0002,320*3<<6+1
	Dc.l	40*3*318-18,40*3*320-18
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0002,320*3<<6+1
	Dc.l	40*3*317-16,40*3*320-16
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0002,320*3<<6+1
	Dc.l	40*3*316-14,40*3*320-14
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0002,320*3<<6+1
	Dc.l	40*3*315-12,40*3*320-12
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0002,320*3<<6+1
	Dc.l	40*3*314-10,40*3*320-10
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0002,320*3<<6+1
	Dc.l	40*3*313-8,40*3*320-8
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0002,320*3<<6+1
	Dc.l	40*3*312-6,40*3*320-6
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0002,320*3<<6+1
	Dc.l	40*3*311-4,40*3*320-4
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0002,320*3<<6+1
	Dc.l	40*3*310-2,40*3*320-2
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0002,320*3<<6+1

BlitDat2Part2:
	Dc.l	40*3*10+38,38
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0000,320*3<<6+1
	Dc.l	40*3*9+36,36
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0000,320*3<<6+1
	Dc.l	40*3*8+34,34
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0000,320*3<<6+1
	Dc.l	40*3*7+32,32
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0000,320*3<<6+1
	Dc.l	40*3*6+30,30
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0000,320*3<<6+1
	Dc.l	40*3*5+28,28
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0000,320*3<<6+1
	Dc.l	40*3*4+26,26
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0000,320*3<<6+1
	Dc.l	40*3*3+24,24
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0000,320*3<<6+1
	Dc.l	40*3*2+22,22
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0000,320*3<<6+1
	Dc.l	40*3*1+20,20
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0000,320*3<<6+1

	Dc.l	40*3*319-22,40*3*320-22
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0002,320*3<<6+1
	Dc.l	40*3*318-24,40*3*320-24
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0002,320*3<<6+1
	Dc.l	40*3*317-26,40*3*320-26
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0002,320*3<<6+1
	Dc.l	40*3*316-28,40*3*320-28
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0002,320*3<<6+1
	Dc.l	40*3*315-30,40*3*320-30
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0002,320*3<<6+1
	Dc.l	40*3*314-32,40*3*320-32
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0002,320*3<<6+1
	Dc.l	40*3*313-34,40*3*320-34
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0002,320*3<<6+1
	Dc.l	40*3*312-36,40*3*320-36
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0002,320*3<<6+1
	Dc.l	40*3*311-38,40*3*320-38
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0002,320*3<<6+1
	Dc.l	40*3*310-40,40*3*320-40
	Dc.w	40-2,40-2,$ffff,$ffff,$09f0,$0002,320*3<<6+1

	Dc.l	40*16*3*19,40*16*3*19
	Dc.w	0,0,$ffff,$fc00,$a9f0,$0000,16*3<<6+20
	Dc.l	40*16*3*18,40*16*3*18
	Dc.w	0,0,$ffff,$fe00,$99f0,$0000,16*3<<6+20
	Dc.l	40*16*3*17,40*16*3*17
	Dc.w	0,0,$ffff,$ff00,$89f0,$0000,16*3<<6+20
	Dc.l	40*16*3*16,40*16*3*16
	Dc.w	0,0,$ffff,$ff80,$79f0,$0000,16*3<<6+20
	Dc.l	40*16*3*15,40*16*3*15
	Dc.w	0,0,$ffff,$ffc0,$69f0,$0000,16*3<<6+20
	Dc.l	40*16*3*14,40*16*3*14
	Dc.w	0,0,$ffff,$ffe0,$59f0,$0000,16*3<<6+20
	Dc.l	40*16*3*13,40*16*3*13
	Dc.w	0,0,$ffff,$fff0,$49f0,$0000,16*3<<6+20
	Dc.l	40*16*3*12,40*16*3*12
	Dc.w	0,0,$ffff,$fff8,$39f0,$0000,16*3<<6+20
	Dc.l	40*16*3*11,40*16*3*11
	Dc.w	0,0,$ffff,$fffc,$29f0,$0000,16*3<<6+20
	Dc.l	40*16*3*10,40*16*3*10
	Dc.w	0,0,$ffff,$fffe,$19f0,$0000,16*3<<6+20

	Dc.l	40*16*3*10-2,40*16*3*10-2
	Dc.w	0,0,$ffff,$7fff,$19f0,$0002,16*3<<6+20
	Dc.l	40*16*3*9-2,40*16*3*9-2
	Dc.w	0,0,$ffff,$3fff,$29f0,$0002,16*3<<6+20
	Dc.l	40*16*3*8-2,40*16*3*8-2
	Dc.w	0,0,$ffff,$1fff,$39f0,$0002,16*3<<6+20
	Dc.l	40*16*3*7-2,40*16*3*7-2
	Dc.w	0,0,$ffff,$0fff,$49f0,$0002,16*3<<6+20
	Dc.l	40*16*3*6-2,40*16*3*6-2
	Dc.w	0,0,$ffff,$07ff,$59f0,$0002,16*3<<6+20
	Dc.l	40*16*3*5-2,40*16*3*5-2
	Dc.w	0,0,$ffff,$03ff,$69f0,$0002,16*3<<6+20
	Dc.l	40*16*3*4-2,40*16*3*4-2
	Dc.w	0,0,$ffff,$01ff,$79f0,$0002,16*3<<6+20
	Dc.l	40*16*3*3-2,40*16*3*3-2
	Dc.w	0,0,$ffff,$00ff,$89f0,$0002,16*3<<6+20
	Dc.l	40*16*3*2-2,40*16*3*2-2
	Dc.w	0,0,$ffff,$007f,$99f0,$0002,16*3<<6+20
	Dc.l	40*16*3*1-2,40*16*3*1-2
	Dc.w	0,0,$ffff,$003f,$a9f0,$0002,16*3<<6+20

;=========================================================
CopperListPart2:
	dc.w	$008E,$2C81,$0090,$2CC1
	dc.w	$0092,$0038,$0094,$00D0
	dc.w	$0190,$0000,$0192,$0998,$0194,$000C,$0196,$002C
	dc.w	$0198,$0853,$019A,$0005,$019C,$0C99,$019E,$0EED
	dc.w	$0180,$0000,$0182,$0BBB,$0184,$0444,$0186,$0888
	dc.w	$0188,$0222,$018A,$0DDD,$018C,$0EEE,$018E,$0f00
BM1Part2:	dc.w	$00E0,$0000,$00E2,$0000
	dc.w	$00E8,$0000,$00EA,$0000
	dc.w	$00F0,$0000,$00F2,$0000
BM2Part2:	dc.w	$00E4,$0000,$00E6,$0000
	dc.w	$00EC,$0000,$00EE,$0000
	dc.w	$00F4,$0000,$00F6,$0000
	dc.w	$0100,$6600,$0102,$0000,$0104,$0000
	dc.w	$0108,$0050,$010A,$0050
	dc.w	$ffff,$fffe
	even
;------------------------------------
		incdir	'tbsd:Morph_Hand_Zoom/'
		dcb.b	40*10*3,0
Screen1Part2:	incbin	'bitmapdef/e&a.blt'
		dcb.b	40*10*3,0

		dcb.b	40*10*3,0
Screen2Part2:	dcb.b	40*320*3,0
		dcb.b	40*10*3,0

Screen3Part2:	incbin	'bitmapdef/e&a_window.blt'

;*********************************************************
;*********************************************************
;*********************************************************
;*********************************************************
;*********************************************************
;========================================================
;=== Bitmap ZoomPart3 V1.0 === (C)1999 by Vlastimil Knotek ===
;========================================================

StartPart3:	movem.l	d0-d7/a0-a6,-(a7)
	bsr	InitAllPart3
	bsr	MakeMulsListPart3

	move.l	chipbasePart3(pc),a6
	bsr	StartCopperPart3

	bsr	ZoomOutPart3

	bsr	MainLoopPart3

tosPart3:
	cmp.b	#-1,$6(a6)
	bne.s	tosPart3
	move.w	#$20,$96(a6)
	bsr	ZoomInPart3

	jsr	RestoreAll
	movem.l	(a7)+,d0-d7/a0-a6
	rts

chipbasePart3:	dc.l	$dff000

;--- StartPart3 Own CopperPart3 ------------------------------------

StartCopperPart3:
	cmpi.b	#-1,$6(a6)
	bne.s	StartCopperPart3
	move.w	#$24,$9a(a6)
sc3wb:	btst	#6,$2(a6)
	bne.s	sc3wb
	move.w	#$40,$096(a6)
sc3wvb:	cmpi.b	#-1,$6(a6)
	bne.s	sc3wvb
	move.w	#$7ff0,$96(a6)
	move.w	#$3fdf,$9a(a6)
	move.l	#CopperListPart3,$80(a6)
	tst.w	$88(a6)
	move.w	#$83e0,$96(a6)
	move.w	#$c020,$9a(a6)
	rts

;--- Main Loop -------------------------------------------

MainLoopPart3:
	cmp.b	#-1,$6(a6)
	bne.s	MainLoopPart3

	bsr	DoubleBufferPart3

	move.l	XValPtrPart3,a0
	lea	XValPtrPart3,a1
	cmpa.l	a0,a1
	bgt.s	xokPart3
	move.l	#XValPart3,a0
	subq.w	#1,cntPart3
xokPart3:	move.w	(a0)+,XPosPart3
	move.l	a0,XValPtrPart3

	move.l	YValPtrPart3,a0
	lea	YValPtrPart3,a1
	cmpa.l	a0,a1
	bgt.s	yokPart3
	move.l	#YValPart3,a0
yokPart3:	move.w	(a0)+,YPosPart3
	move.l	a0,YValPtrPart3

	bsr	ZoomPart3
	move.w	XPosPart3,d0
	move.w	YPosPart3,d1
	bsr	MoveSpritePart3

	tst.w	cntPart3
	bne.s	MainLoopPart3

mlendPart3:
	move.l	CopperPart3,a0
	cmpi.l	#CopperListPart3,a0
	bne.s	mlrendPart3
	bsr	DoubleBufferPart3
	bsr	ZoomPart3
	move.w	XPosPart3,d0
	move.w	YPosPart3,d1
	bsr	MoveSpritePart3
mlrendPart3:
	rts

cntPart3:	dc.w	1
;--- Initiation ------------------------------------------

InitAllPart3:
	lea	CopperListPart3+2,a0
	lea	SprsPart3,a1
	moveq	#8-1,d1
ssprPart3:	move.l	(a1)+,d0
	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
	addq.w	#8,a0
	dbf	d1,ssprPart3

	lea	CopperList2Part3+2,a0
	lea	Sprs2Part3,a1
	moveq	#8-1,d1
sspr2Part3:	move.l	(a1)+,d0
	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
	addq.w	#8,a0
	dbf	d1,sspr2Part3

	lea	CopBMPart3,a0
	move.l	#$3701fffe,d0
	move.w	#200-1,d1
ccopPart3:	move.l	d0,(a0)+
	move.l	#$00e00000,(a0)+
	move.l	#$00e20000,(a0)+
	move.l	#$00e40000,(a0)+
	move.l	#$00e60000,(a0)+
	move.l	#$00e80000,(a0)+
	move.l	#$00ea0000,(a0)+
	move.l	#$00ec0000,(a0)+
	move.l	#$00ee0000,(a0)+
	addi.l	#$01000000,d0
	dbf	d1,ccopPart3

	lea	CopBMPart3+6,a0
	move.l	ScreenPart3,d2
	move.w	#200-1,d3
slinePart3:	move.l	d2,d0
	moveq	#4-1,d1
sbmpPart3:	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
	swap	d0
	addi.l	#40*200,d0
	addq.w	#8,a0
	dbf	d1,sbmpPart3
	addq.w	#4,a0
	addi.l	#40,d2
	dbf	d3,slinePart3

	rts

MakeMulsListPart3:
	move.l	MulsPtrPart3(pc),a0
	moveq	#0,d0
	move.l	#200-1,d1
mmloopPart3:	move.w	d0,(a0)+
	addi.w	#40,d0
	dbf	d1,mmloopPart3
	rts

MulsPtrPart3:	dc.l	MListPart3
;=========================================================

;--- DoubleBufferPart3 ----------------------------------------

DoubleBufferPart3:
	lea	CopperPart3,a0
	movem.l	(a0),d0/d1
	exg.l	d0,d1
	movem.l	d0/d1,(a0)

	move.l	d1,$80(a6)
	tst.w	$88(a6)

	lea	SListDBPart3,a0
	movem.l	(a0),d0/d1
	exg.l	d0,d1
	movem.l	d0/d1,(a0)

	lea	SprsDBPart3,a0
	movem.l	(a0),d0/d1
	exg.l	d0,d1
	movem.l	d0/d1,(a0)

	rts

CopperPart3:	dc.l	CopperListPart3,CopperList2Part3

;--- ZoomPart3 Out Routine ------------------------------------

ZoomOutPart3:
	move.w	#144,StartXPart3	; startPart3 X
	move.w	#90,StartYPart3	; startPart3 Y
	move.w	#32,WidthPart3	; widthPart3
	move.w	#20,HeightPart3	; heightPart3

zo_loopPart3:
	lea	PicturePart3,a0
	move.l	ScreenPart3+4,a1

	moveq	#0,d0
	moveq	#0,d1
	moveq	#0,d2
	moveq	#0,d3
	move.w	#14,d4
	move.w	StartXPart3(pc),d0
	asl.l	d4,d0
	move.w	WidthPart3(pc),d2
	asl.l	d4,d2
	divs	#320,d2
	swap	d2
	clr.w	d2
	swap	d2
	moveq	#0,d7

zo_loopXPart3:
	move.l	d0,d4
	move.w	d7,d5

	lsr.w	#4,d5
	add.w	d5,d5
	lea	(a1,d5.w),a4	; dest

	move.w	#14,d5
	lsr.l	d5,d4
	move.w	d4,d6
	lsr.w	#4,d4
	add.w	d4,d4		; startPart3 X / 8
	lea	(a0,d4.w),a3	; source
	andi.w	#$f,d6		; startPart3 X mod 8
	move.w	d7,d5
	andi.l	#$f,d5
	subi.w	d6,d5
	bmi.s	setdescPart3
	ror.l	#4,d5
	ori.l	#$bfa0000,d5
	bra.s	wbltPart3
setdescPart3:
	neg.w	d5
	ror.l	#4,d5
	ori.l	#$bfa0002,d5
	adda.l	#40*200*4,a3
	adda.l	#40*200*4,a4

wbltPart3:	btst	#6,$2(a6)
	bne.s	wbltPart3

	move.l	d5,$40(a6)		; con1, con0
	move.l	a3,$50(a6)		; apth
	move.l	a4,$48(a6)		; cpth
	move.l	a4,$54(a6)		; dpth
	move.l	#$80008000,d5
	ror.l	d6,d5
	move.l	d5,$44(a6)		; afwm, alwm
	move.w	#38,$64(a6)		; amod
	move.w	#38,$60(a6)		; cmod
	move.w	#38,$66(a6)		; dmod
	move.w	#200*4*64+1,$58(a6)	; bltsize

	add.l	d2,d0
	addq.w	#1,d7
	cmpi.w	#320,d7
	blt.w	zo_loopXPart3

;--- Y ------
	lea	CopBMPart3+6,a0
	move.l	ScreenPart3+4,a1
	move.l	MulsPtrPart3,a2

	moveq	#0,d0
	moveq	#0,d1
	moveq	#0,d2
	moveq	#0,d3
	move.w	#14,d4
	move.w	StartYPart3(pc),d0
	asl.l	d4,d0
	move.w	HeightPart3(pc),d2
	asl.l	d4,d2
	divs	#200,d2
	swap	d2
	clr.w	d2
	swap	d2
	moveq	#0,d7

zo_loopYPart3:
	move.l	d0,d4

	move.w	#14,d5
	lsr.l	d5,d4
	add.w	d4,d4
	move.w	(a2,d4.w),d4
	lea	(a1,d4.w),a3	; screenPart3

	move.l	a3,d3
	moveq	#4-1,d1
zo_setbmPart3:
	move.w	d3,4(a0)
	swap	d3
	move.w	d3,(a0)
	swap	d3
	addi.l	#40*200,d3
	addq.w	#8,a0
	dbf	d1,zo_setbmPart3
	addq.w	#4,a0

	add.l	d2,d0
	addq.w	#1,d7
	cmpi.w	#200,d7
	blt.w	zo_loopYPart3


	lea	ScreenPart3,a3
	movem.l	(a3),d0/d1
	exg.l	d0,d1
	movem.l	d0/d1,(a3)

wblt3Part3:	btst	#6,$2(a6)
	bne.s	wblt3Part3

	move.l	#$1000000,$40(a6)	; con1, con0
	move.l	d1,$54(a6)		; dpth
	move.w	#0,$66(a6)		; dmod
	move.w	#200*4*64+20,$58(a6)	; bltsize

	subi.w	#16,StartXPart3
	subi.w	#10,StartYPart3
	addi.w	#32,WidthPart3
	addi.w	#20,HeightPart3
	cmpi.w	#0,StartXPart3
	bne.w	zo_loopPart3

wblt4Part3:	btst	#6,$2(a6)
	bne.s	wblt4Part3

	move.l	#$ffffffff,$44(a6)
	move.l	#$09f00000,$40(a6)	; con1, con0
	move.l	ScreenPart3,$54(a6)		; dpth
	move.l	#PicturePart3,$50(a6)	; apth
	move.l	#0,$64(a6)		; amod, dmod
	move.w	#200*4*64+20,$58(a6)	; bltsize

	lea	CopBMPart3+6,a0
	move.l	ScreenPart3,d2
	move.w	#200-1,d3
sline3Part3:	move.l	d2,d0
	moveq	#4-1,d1
sbmp3Part3:	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
	swap	d0
	addi.l	#40*200,d0
	addq.w	#8,a0
	dbf	d1,sbmp3Part3
	addq.w	#4,a0
	addi.l	#40,d2
	dbf	d3,sline3Part3

	lea	CopBM2Part3+2,a0
	move.l	ScreenPart3,d0
	moveq	#4-1,d1
sbmp2Part3:	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
	swap	d0
	addi.l	#40*200,d0
	addq.w	#8,a0
	dbf	d1,sbmp2Part3

wblt5Part3:	btst	#6,$2(a6)
	bne.s	wblt5Part3
	rts

;--- ZoomPart3 In Routine ------------------------------------

ZoomInPart3:
	move.w	#16,StartXPart3	; startPart3 X
	move.w	#10,StartYPart3	; startPart3 Y
	move.w	#288,WidthPart3	; widthPart3
	move.w	#180,HeightPart3	; heightPart3

zi_loopPart3:
	lea	PicturePart3,a0
	move.l	ScreenPart3+4,a1

	moveq	#0,d0
	moveq	#0,d1
	moveq	#0,d2
	moveq	#0,d3
	move.w	#14,d4
	move.w	StartXPart3(pc),d0
	asl.l	d4,d0
	move.w	WidthPart3(pc),d2
	asl.l	d4,d2
	divs	#320,d2
	swap	d2
	clr.w	d2
	swap	d2
	moveq	#0,d7

zi_loopXPart3:
	move.l	d0,d4
	move.w	d7,d5

	lsr.w	#4,d5
	add.w	d5,d5
	lea	(a1,d5.w),a4	; dest

	move.w	#14,d5
	lsr.l	d5,d4
	move.w	d4,d6
	lsr.w	#4,d4
	add.w	d4,d4		; startPart3 X / 8
	lea	(a0,d4.w),a3	; source
	andi.w	#$f,d6		; startPart3 X mod 8
	move.w	d7,d5
	andi.l	#$f,d5
	subi.w	d6,d5
	bmi.w	setdesc2Part3
	ror.l	#4,d5
	ori.l	#$bfa0000,d5
	bra.s	wblt6Part3
setdesc2Part3:
	neg.w	d5
	ror.l	#4,d5
	ori.l	#$bfa0002,d5
	adda.l	#40*200*4,a3
	adda.l	#40*200*4,a4

wblt6Part3:	btst	#6,$2(a6)
	bne.s	wblt6Part3

	move.l	d5,$40(a6)		; con1, con0
	move.l	a3,$50(a6)		; apth
	move.l	a4,$48(a6)		; cpth
	move.l	a4,$54(a6)		; dpth
	move.l	#$80008000,d5
	ror.l	d6,d5
	move.l	d5,$44(a6)		; afwm, alwm
	move.w	#38,$64(a6)		; amod
	move.w	#38,$60(a6)		; cmod
	move.w	#38,$66(a6)		; dmod
	move.w	#200*4*64+1,$58(a6)	; bltsize

	add.l	d2,d0
	addq.w	#1,d7
	cmpi.w	#320,d7
	blt.w	zi_loopXPart3

;--- Y ------
	lea	CopBMPart3+6,a0
	move.l	ScreenPart3+4,a1
	move.l	MulsPtrPart3,a2

	moveq	#0,d0
	moveq	#0,d1
	moveq	#0,d2
	moveq	#0,d3
	move.w	#14,d4
	move.w	StartYPart3(pc),d0
	asl.l	d4,d0
	move.w	HeightPart3(pc),d2
	asl.l	d4,d2
	divs	#200,d2
	swap	d2
	clr.w	d2
	swap	d2
	moveq	#0,d7

zi_loopYPart3:
	move.l	d0,d4

	move.w	#14,d5
	lsr.l	d5,d4
	add.w	d4,d4
	move.w	(a2,d4.w),d4
	lea	(a1,d4.w),a3	; screenPart3

	move.l	a3,d3
	moveq	#4-1,d1
zi_setbmPart3:
	move.w	d3,4(a0)
	swap	d3
	move.w	d3,(a0)
	swap	d3
	addi.l	#40*200,d3
	addq.w	#8,a0
	dbf	d1,zi_setbmPart3
	addq.w	#4,a0

	add.l	d2,d0
	addq.w	#1,d7
	cmpi.w	#200,d7
	blt.w	zi_loopYPart3


	lea	ScreenPart3,a3
	movem.l	(a3),d0/d1
	exg.l	d0,d1
	movem.l	d0/d1,(a3)

wblt7Part3:	btst	#6,$2(a6)
	bne.s	wblt7Part3

	move.l	#$1000000,$40(a6)	; con1, con0
	move.l	d1,$54(a6)		; dpth
	move.w	#0,$66(a6)		; dmod
	move.w	#200*4*64+20,$58(a6)	; bltsize

	addi.w	#16,StartXPart3
	addi.w	#10,StartYPart3
	subi.w	#32,WidthPart3
	subi.w	#20,HeightPart3
	cmpi.w	#160,StartXPart3
	bne.w	zi_loopPart3

wblt8Part3:	btst	#6,$2(a6)
	bne.s	wblt8Part3

	move.l	#$ffffffff,$44(a6)
	move.l	#$09f00000,$40(a6)	; con1, con0
	move.l	ScreenPart3,$54(a6)		; dpth
	move.l	#PicturePart3,$50(a6)	; apth
	move.l	#0,$64(a6)		; amod, dmod
	move.w	#200*4*64+20,$58(a6)	; bltsize

	lea	CopBMPart3+6,a0
	move.l	ScreenPart3,d2
	move.w	#200-1,d3
sline4Part3:	move.l	d2,d0
	moveq	#4-1,d1
sbmp4Part3:	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
	swap	d0
	addi.l	#40*200,d0
	addq.w	#8,a0
	dbf	d1,sbmp4Part3
	addq.w	#4,a0
	addi.l	#40,d2
	dbf	d3,sline4Part3

	lea	CopBM2Part3+2,a0
	move.l	ScreenPart3,d0
	moveq	#4-1,d1
sbmp5Part3:	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
	swap	d0
	addi.l	#40*200,d0
	addq.w	#8,a0
	dbf	d1,sbmp5Part3

wblt9Part3:	btst	#6,$2(a6)
	bne.s	wblt9Part3
	rts

StartXPart3:	dc.w	0
StartYPart3:	dc.w	0
WidthPart3:	dc.w	0
HeightPart3:	dc.w	0
ScreenPart3:	dc.l	ScreenSPart3,ScreenHPart3
;--- Galss ZoomPart3 Routine ----------------------------------

ZoomPart3:	move.l	ScreenPart3,a0
	move.l	a0,a1
	addi.l	#40*200,a1
	move.l	a1,a2
	addi.l	#40*200,a2
	move.l	a2,a3
	addi.l	#40*200,a3
	lea	BufferPart3,a4
	lea	ZDataPart3,a5
	move.l	MulsPtrPart3,a6

	move.w	(a5)+,d7

	move.w	YPosPart3(pc),d1
	add.w	d1,d1
	move.w	(a6,d1.w),d1
	move.w	XPosPart3(pc),d0
zoom_loopPart3:
	move.w	d0,d2
	move.w	d1,d3

	add.w	(a5)+,d3	; B in pic
	add.w	(a5)+,d2	; A in pic
	move.w	d2,d6
	lsr.w	#3,d6
	add.w	d6,d3		; pos in pic
	eori.b	#7,d2		; bit in pos in pic

	move.w	(a5)+,d4	; Y+X/8 in buf
	move.w	(a5)+,d5	; X mod 8

	bclr	d5,(a4,d4.w)
	btst	d2,(a0,d3.w)
	beq.s	znset1Part3
	bset	d5,(a4,d4.w)
znset1Part3:	addi.w	#8,d4
	bclr	d5,(a4,d4.w)
	btst	d2,(a1,d3.w)
	beq.s	znset2Part3
	bset	d5,(a4,d4.w)
znset2Part3:	addi.w	#8,d4
	bclr	d5,(a4,d4.w)
	btst	d2,(a2,d3.w)
	beq.s	znset3Part3
	bset	d5,(a4,d4.w)
znset3Part3:	addi.w	#8,d4
	bclr	d5,(a4,d4.w)
	btst	d2,(a3,d3.w)
	beq.s	znset4Part3
	bset	d5,(a4,d4.w)
znset4Part3:	dbf	d7,zoom_loopPart3


; a4 = bufferPart3


	move.l	chipbasePart3,a6

	move.l	#-1,$44(a6)

	move.l	SListDBPart3,a5
	moveq	#4-1,d7

cpyPart3:	move.l	(a5)+,a0

w1Part3:	btst	#6,$2(a6)
	bne.s	w1Part3

	move.l	a4,$50(a6)		; apth	= bufferPart3
	move.l	a0,$54(a6)		; dpth	= sprite
	move.w	#6+8*3,$64(a6)		; amod
	move.w	#2,$66(a6)		; dmod
	move.l	#$9f00000,$40(a6)	; con0, con1
	move.w	#64*64+1,$58(a6)	; size

	adda.l	#8,a4
	addq.l	#2,a0

w2Part3:	btst	#6,$2(a6)
	bne.s	w2Part3

	move.l	a4,$50(a6)		; apth	= bufferPart3
	move.l	a0,$54(a6)		; dpth	= sprite
	move.w	#6+8*3,$64(a6)		; amod
	move.w	#2,$66(a6)		; dmod
	move.l	#$9f00000,$40(a6)	; con0, con1
	move.w	#64*64+1,$58(a6)	; size

	move.l	(a5)+,a0
	adda.l	#8,a4

w3Part3:	btst	#6,$2(a6)
	bne.s	w3Part3

	move.l	a4,$50(a6)		; apth	= bufferPart3
	move.l	a0,$54(a6)		; dpth	= sprite
	move.w	#6+8*3,$64(a6)		; amod
	move.w	#2,$66(a6)		; dmod
	move.l	#$9f00000,$40(a6)	; con0, con1
	move.w	#64*64+1,$58(a6)	; size

	adda.l	#8,a4
	addq.l	#2,a0

w4Part3:	btst	#6,$2(a6)
	bne.s	w4Part3

	move.l	a4,$50(a6)		; apth	= bufferPart3
	move.l	a0,$54(a6)		; dpth	= sprite
	move.w	#6+8*3,$64(a6)		; amod
	move.w	#2,$66(a6)		; dmod
	move.l	#$9f00000,$40(a6)	; con0, con1
	move.w	#64*64+1,$58(a6)	; size

	subi.w	#2*8+6,a4
	dbf	d7,cpyPart3
	rts

XPosPart3:	dc.w	0
YPosPart3:	dc.w	80
SListDBPart3:
	dc.l	SListPart3,SList2Part3
SListPart3:	dc.l	S1OddPart3,S1EvenPart3,S2OddPart3,S2EvenPart3,S3OddPart3,S3EvenPart3,S4OddPart3,S4EvenPart3
SList2Part3:	dc.l	S1Odd3Part3,S1Even3Part3,S2Odd3Part3,S2Even3Part3,S3Odd3Part3,S3Even3Part3,S4Odd3Part3,S4Even3Part3
;---------------------------------------------------------
MoveSpritePart3:
	addi.w	#$81,d0
	addi.w	#$37,d1
	move.w	d0,d3
	move.w	d1,d4
	moveq	#64,d2
	move.l	SprsDBPart3,a2
	moveq	#4-1,d7
MSP_LOOPPart3:
	move.l	(a2)+,a0
	move.l	(a2)+,a1
	move.b	d1,(a0)
	move.b	d1,(a1)
	btst	#8,d1
	bne.s	MSP_01Part3
	bclr	#2,3(a0)
	bclr	#2,3(a1)
	bra.s	MSP_10Part3
MSP_01Part3:	bset	#2,3(a0)
	bset	#2,3(a1)
MSP_10Part3:	add.w	d2,d1
	move.b	d1,2(a0)
	move.b	d1,2(a1)
	btst	#8,d1
	bne.s	MSP_11Part3
	bclr	#1,3(a0)
	bclr	#1,3(a1)
	bra.s	MSP_20Part3
MSP_11Part3:	bset	#1,3(a0)
	bset	#1,3(a1)
MSP_20Part3:	lsr.w	#1,d0
	bcs.s	MSP_21Part3
	bclr	#0,3(a0)
	bclr	#0,3(a1)
	bra.s	MSP_22Part3
MSP_21Part3:	bset	#0,3(a0)
	bset	#0,3(a1)
MSP_22Part3:	move.b	d0,1(a0)
	move.b	d0,1(a1)
	addi.w	#16,d3
	move.w	d3,d0
	move.w	d4,d1
	dbf	d7,MSP_LOOPPart3
	rts

SprsDBPart3:	dc.l	SprsPart3,Sprs2Part3
SprsPart3:	dc.l	S1Part3,S12Part3,S2Part3,S22Part3,S3Part3,S32Part3,S4Part3,S42Part3
Sprs2Part3:	dc.l	S13Part3,S123Part3,S23Part3,S223Part3,S33Part3,S323Part3,S43Part3,S423Part3
;=========================================================
XValPart3:
	DC.W	$0083,$008A,$0091,$0097,$009E,$00A4,$00AB,$00B1,$00B7,$00BD
	DC.W	$00C3,$00C8,$00CE,$00D3,$00D8,$00DD,$00E1,$00E5,$00E9,$00ED
	DC.W	$00F0,$00F3,$00F6,$00F9,$00FB,$00FC,$00FE,$00FF,$0100,$0100
	DC.W	$0100,$0100,$00FF,$00FE,$00FD,$00FB,$00F9,$00F6,$00F4,$00F1
	DC.W	$00ED,$00EA,$00E6,$00E2,$00DD,$00D8,$00D3,$00CE,$00C9,$00C3
	DC.W	$00BD,$00B7,$00B1,$00AB,$00A5,$009E,$0098,$0091,$008A,$0084
	DC.W	$007D,$0076,$0070,$0069,$0063,$005C,$0056,$004F,$0049,$0043
	DC.W	$003D,$0038,$0032,$002D,$0028,$0023,$001F,$001B,$0017,$0013
	DC.W	$0010,$000D,$000A,$0008,$0005,$0004,$0002,$0001,$0000,$0000
	DC.W	$0000,$0000,$0001,$0002,$0003,$0005,$0007,$000A,$000C,$000F
	DC.W	$0013,$0016,$001A,$001E,$0023,$0027,$002C,$0032,$0037,$003D
	DC.W	$0042,$0048,$004E,$0055,$005B,$0061,$0068,$006F,$0075,$007C
	DC.W	$0083,$0089,$0090,$0097,$009D,$00A4,$00AA,$00B0,$00B6,$00BC
	DC.W	$00C2,$00C8,$00CD,$00D2,$00D8,$00DC,$00E1,$00E5,$00E9,$00ED
	DC.W	$00F0,$00F3,$00F6,$00F8,$00FA,$00FC,$00FE,$00FF,$0100,$0100
	DC.W	$0100,$0100,$00FF,$00FE,$00FD,$00FB,$00F9,$00F7,$00F4,$00F1
	DC.W	$00EE,$00EA,$00E6,$00E2,$00DE,$00D9,$00D4,$00CF,$00C9,$00C4
	DC.W	$00BE,$00B8,$00B2,$00AC,$00A5,$009F,$0098,$0092,$008B,$0084
	DC.W	$007E,$0077,$0070,$006A,$0063,$005D,$0056,$0050,$004A,$0044
	DC.W	$003E,$0038,$0033,$002E,$0029,$0024,$001F,$001B,$0017,$0014
	DC.W	$0010,$000D,$000A,$0008,$0006,$0004,$0002,$0001,$0001,$0000
	DC.W	$0000,$0000,$0001,$0002,$0003,$0005,$0007,$0009,$000C,$000F
	DC.W	$0012,$0016,$001A,$001E,$0022,$0027,$002C,$0031,$0036,$003C
	DC.W	$0042,$0048,$004E,$0054,$005A,$0061,$0067,$006E,$0074,$007B
	DC.W	$0082,$0089,$008F,$0096,$009C,$00A3,$00A9,$00B0,$00B6,$00BC
	DC.W	$00C2,$00C7,$00CD,$00D2,$00D7,$00DC,$00E0,$00E5,$00E9,$00EC
	DC.W	$00F0,$00F3,$00F6,$00F8,$00FA,$00FC,$00FE,$00FF,$00FF,$0100
	DC.W	$0100,$0100,$00FF,$00FE,$00FD,$00FB,$00F9,$00F7,$00F4,$00F1
	DC.W	$00EE,$00EA,$00E7,$00E2,$00DE,$00D9,$00D4,$00CF,$00CA,$00C4
	DC.W	$00BF,$00B9,$00B3,$00AC,$00A6,$00A0,$0099,$0093,$008C,$0085
	DC.W	$007F,$0078,$0071,$006B,$0064,$005D,$0057,$0051,$004B,$0045
	DC.W	$003F,$0039,$0034,$002E,$0029,$0025,$0020,$001C,$0018,$0014
	DC.W	$0010,$000D,$000B,$0008,$0006,$0004,$0003,$0001,$0001,$0000
	DC.W	$0000,$0000,$0001,$0002,$0003,$0005,$0007,$0009,$000C,$000F
	DC.W	$0012,$0015,$0019,$001D,$0022,$0026,$002B,$0030,$0036,$003B
	DC.W	$0041,$0047,$004D,$0053,$005A,$0060,$0066,$006D,$0074,$007A


XValPtrPart3:	dc.l	XValPart3

YValPart3:	DC.W	$0088,$0088,$0088,$0088,$0088,$0088,$0088,$0087,$0087,$0087
	DC.W	$0087,$0087,$0086,$0086,$0086,$0086,$0085,$0085,$0085,$0084
	DC.W	$0084,$0083,$0083,$0082,$0082,$0081,$0081,$0080,$0080,$007F
	DC.W	$007F,$007E,$007D,$007D,$007C,$007B,$007B,$007A,$0079,$0079
	DC.W	$0078,$0077,$0076,$0075,$0075,$0074,$0073,$0072,$0071,$0070
	DC.W	$006F,$006E,$006E,$006D,$006C,$006B,$006A,$0069,$0068,$0067
	DC.W	$0066,$0065,$0064,$0063,$0061,$0060,$005F,$005E,$005D,$005C
	DC.W	$005B,$005A,$0059,$0058,$0056,$0055,$0054,$0053,$0052,$0051
	DC.W	$004F,$004E,$004D,$004C,$004B,$004A,$0048,$0047,$0046,$0045
	DC.W	$0044,$0043,$0041,$0040,$003F,$003E,$003D,$003B,$003A,$0039
	DC.W	$0038,$0037,$0036,$0034,$0033,$0032,$0031,$0030,$002F,$002E
	DC.W	$002D,$002B,$002A,$0029,$0028,$0027,$0026,$0025,$0024,$0023
	DC.W	$0022,$0021,$0020,$001F,$001E,$001D,$001C,$001B,$001A,$0019
	DC.W	$0018,$0017,$0016,$0016,$0015,$0014,$0013,$0012,$0011,$0011
	DC.W	$0010,$000F,$000E,$000E,$000D,$000C,$000C,$000B,$000A,$000A
	DC.W	$0009,$0008,$0008,$0007,$0007,$0006,$0006,$0005,$0005,$0004
	DC.W	$0004,$0004,$0003,$0003,$0003,$0002,$0002,$0002,$0001,$0001
	DC.W	$0001,$0001,$0001,$0001,$0000,$0000,$0000,$0000,$0000,$0000
	DC.W	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0001,$0001,$0001
	DC.W	$0001,$0001,$0001,$0002,$0002,$0002,$0003,$0003,$0003,$0004
	DC.W	$0004,$0004,$0005,$0005,$0006,$0006,$0007,$0007,$0008,$0008
	DC.W	$0009,$000A,$000A,$000B,$000C,$000C,$000D,$000E,$000E,$000F
	DC.W	$0010,$0011,$0011,$0012,$0013,$0014,$0015,$0016,$0016,$0017
	DC.W	$0018,$0019,$001A,$001B,$001C,$001D,$001E,$001F,$0020,$0021
	DC.W	$0022,$0023,$0024,$0025,$0026,$0027,$0028,$0029,$002A,$002B
	DC.W	$002D,$002E,$002F,$0030,$0031,$0032,$0033,$0034,$0036,$0037
	DC.W	$0038,$0039,$003A,$003B,$003D,$003E,$003F,$0040,$0041,$0043
	DC.W	$0044,$0045,$0046,$0047,$0048,$004A,$004B,$004C,$004D,$004E
	DC.W	$004F,$0051,$0052,$0053,$0054,$0055,$0056,$0058,$0059,$005A
	DC.W	$005B,$005C,$005D,$005E,$005F,$0060,$0061,$0063,$0064,$0065
	DC.W	$0066,$0067,$0068,$0069,$006A,$006B,$006C,$006D,$006E,$006E
	DC.W	$006F,$0070,$0071,$0072,$0073,$0074,$0075,$0075,$0076,$0077
	DC.W	$0078,$0079,$0079,$007A,$007B,$007B,$007C,$007D,$007D,$007E
	DC.W	$007F,$007F,$0080,$0080,$0081,$0081,$0082,$0082,$0083,$0083
	DC.W	$0084,$0084,$0085,$0085,$0085,$0086,$0086,$0086,$0086,$0087
	DC.W	$0087,$0087,$0087,$0087,$0088,$0088,$0088,$0088,$0088,$0088

YValPtrPart3:	dc.l	YValPart3
;=========================================================
CopperListPart3:
	dc.w	$0120,$0000,$0122,$0000
	dc.w	$0124,$0000,$0126,$0000
	dc.w	$0128,$0000,$012A,$0000
	dc.w	$012C,$0000,$012E,$0000
	dc.w	$0130,$0000,$0132,$0000
	dc.w	$0134,$0000,$0136,$0000
	dc.w	$0138,$0000,$013A,$0000
	dc.w	$013C,$0000,$013E,$0000
	dc.w	$008E,$3781,$0090,$ffC1
	dc.w	$0092,$0038,$0094,$00D0
	dc.w	$0180,$0000,$0182,$0CAB,$0184,$0222,$0186,$0333
	dc.w	$0188,$0444,$018A,$0666,$018C,$0754,$018E,$0777
	dc.w	$0190,$0877,$0192,$0FB8,$0194,$0111,$0196,$0FBA
	dc.w	$0198,$08BF,$019A,$0ABE,$019C,$0CBD,$019E,$0DDD
	dc.w	$01A0,$0000,$01A2,$0CAB,$01A4,$0222,$01A6,$0333
	dc.w	$01A8,$0444,$01AA,$0666,$01AC,$0754,$01AE,$0777
	dc.w	$01B0,$0877,$01B2,$0FB8,$01B4,$0111,$01B6,$0FBA
	dc.w	$01B8,$08BF,$01BA,$0ABE,$01BC,$0CBD,$01BE,$0DDD
	dc.w	$0100,$4200,$0102,$0000,$0104,$003f
	dc.w	$0108,0,$010A,0
CopBMPart3:	dcb.w	18*200,0
	dc.w	$ffff,$fffe
	even

CopperList2Part3:
	dc.w	$0120,$0000,$0122,$0000
	dc.w	$0124,$0000,$0126,$0000
	dc.w	$0128,$0000,$012A,$0000
	dc.w	$012C,$0000,$012E,$0000
	dc.w	$0130,$0000,$0132,$0000
	dc.w	$0134,$0000,$0136,$0000
	dc.w	$0138,$0000,$013A,$0000
	dc.w	$013C,$0000,$013E,$0000
	dc.w	$008E,$3781,$0090,$ffC1
	dc.w	$0092,$0038,$0094,$00D0
	dc.w	$0180,$0000,$0182,$0CAB,$0184,$0222,$0186,$0333
	dc.w	$0188,$0444,$018A,$0666,$018C,$0754,$018E,$0777
	dc.w	$0190,$0877,$0192,$0FB8,$0194,$0111,$0196,$0FBA
	dc.w	$0198,$08BF,$019A,$0ABE,$019C,$0CBD,$019E,$0DDD
	dc.w	$01A0,$0000,$01A2,$0CAB,$01A4,$0222,$01A6,$0333
	dc.w	$01A8,$0444,$01AA,$0666,$01AC,$0754,$01AE,$0777
	dc.w	$01B0,$0877,$01B2,$0FB8,$01B4,$0111,$01B6,$0FBA
	dc.w	$01B8,$08BF,$01BA,$0ABE,$01BC,$0CBD,$01BE,$0DDD
CopBM2Part3:	dc.w	$00E0,$0000,$00E2,$0000
	dc.w	$00E4,$0000,$00E6,$0000
	dc.w	$00E8,$0000,$00EA,$0000
	dc.w	$00EC,$0000,$00EE,$0000
	dc.w	$0100,$4200,$0102,$0000,$0104,$003f
	dc.w	$0108,0,$010A,0
	dc.w	$ffff,$fffe
	even
;------------------------------------
ScreenSPart3:	dcb.b	40*200*4,0
ScreenHPart3:	dcb.b	40*200*4,0
PicturePart3:	incbin	'zoom/camera.raw'
BufferPart3:	dcb.b	8*64*4,0
MListPart3:	dcb.w	200,0
ZDataPart3:	incbin	'zoom/zoom.data'

S1Part3:	dc.w	$0000,$0000
S1OddPart3:	dcb.w	64*2,0
	dc.l	0
S2Part3:	dc.w	$0000,$0000
S2OddPart3:	dcb.w	64*2
	dc.l	0
S3Part3:	dc.w	$0000,$0000
S3OddPart3:	dcb.w	64*2
	dc.l	0
S4Part3:	dc.w	$0000,$0000
S4OddPart3:	dcb.w	64*2
	dc.l	0

S12Part3:	dc.w	$0000,$0080
S1EvenPart3:	dcb.w	64*2
	dc.l	0
S22Part3:	dc.w	$0000,$0080
S2EvenPart3:	dcb.w	64*2
	dc.l	0
S32Part3:	dc.w	$0000,$0080
S3EvenPart3:	dcb.w	64*2
	dc.l	0
S42Part3:	dc.w	$0000,$0080
S4EvenPart3:	dcb.w	64*2
	dc.l	0

;--- DB Sprites

S13Part3:	dc.w	$0000,$0000
S1Odd3Part3:	dcb.w	64*2,0
	dc.l	0
S23Part3:	dc.w	$0000,$0000
S2Odd3Part3:	dcb.w	64*2
	dc.l	0
S33Part3:	dc.w	$0000,$0000
S3Odd3Part3:	dcb.w	64*2
	dc.l	0
S43Part3:	dc.w	$0000,$0000
S4Odd3Part3:	dcb.w	64*2
	dc.l	0

S123Part3:	dc.w	$0000,$0080
S1Even3Part3:	dcb.w	64*2
	dc.l	0
S223Part3:	dc.w	$0000,$0080
S2Even3Part3:	dcb.w	64*2
	dc.l	0
S323Part3:	dc.w	$0000,$0080
S3Even3Part3:	dcb.w	64*2
	dc.l	0
S423Part3:	dc.w	$0000,$0080
S4Even3Part3:	dcb.w	64*2
	dc.l	0
;***********************************************
	include	'tbsd:trackerpackerreplayv3.1.s'

module:	incbin	'zoom/zoom.tp3'
