  2~  '  ~  
p                        ;======================================================================
;=== The Bull Shit Demo - Main Part === (C)1999 by Vlastimil Knotek ===
;======================================================================
	org	$120000
	load	$120000
Start:

;	lea	$2f000,a7

	movem.l	d0-d7/a0-a6,-(a7)
	bsr	SaveSystem
	bsr	InitAll

	jsr	mt_init

	bsr	MakeMulsList

	lea	$dff000,a6
	bsr	StartCopper
	bsr	MainLoop

	bsr	RestoreSystem
	movem.l	(a7)+,d0-d7/a0-a6
	rts

;--- SaveSystem ------------------------------------------

SaveSystem:
	move.l	$4.w,a6
	lea.l	GfxName(pc),a1
	moveq	#0,D0
	jsr	-408(a6)	;OldOpenLibrary
	move.l	d0,a1
	lea	OldCopper1(pc),a0
	move.l	$26(a1),(a0)
	lea	OldCopper2(pc),a0
	move.l	$32(a1),(a0)
	jsr	-414(a6)	;CloseLibrary

	lea	$dff000,a6
	lea	OldDMACON(pc),a0
	move.w	$002(a6),(a0)+
	move.w	$01c(a6),(a0)+
	move.l	$64.w,(a0)+
	move.l	$6c.w,(a0)
	rts

;--- RestoreSystem ---------------------------------------

RestoreSystem:
	jsr	mt_end
	lea	$dff000,a6
raw:	btst	#6,$dff002
	bne.s	raw
wvb:	cmp.b	#-1,$6(a6)
	bne.s	wvb
	move.w	#$7fff,$96(a6)
	move.w	#$7fff,$9a(a6)
	move.l	OldSOFT(pc),$64.w
	move.l	OldVB(pc),$6c.w
	move.l	OldCopper1(pc),$080(a6)
	tst.w	$88(a6)
	move.l	OldCopper2(pc),$084(a6)
	tst.w	$8a(a6)
	move.w	OldDMACON(pc),d0
	or.w	#$8000,d0
	move.w	OldINTENA(pc),d1
	or.w	#$8000,d1
	move.w	d0,$096(a6)
	move.w	d1,$09a(a6)
	rts

GfxName		DC.B	'graphics.library',0
		even
OldCopper1:	DC.L	0
OldCopper2:	DC.L	0
OldDMACON:	DC.W	0
OldINTENA:	DC.W	0
OldSOFT:	DC.L	0
OldVB:		dc.l	0
;=========================================================
;--- Start Own Copper List & Interrupts ------------------

StartCopper:
	cmpi.b	#-1,$6(a6)
	bne.s	StartCopper
	move.w	#$3fbf,$9a(a6)
scwb:	btst	#6,$2(a6)
	bne.s	scwb
	move.w	#$40,$96(a6)
scwvb:	cmpi.b	#-1,$6(a6)
	bne.s	scwvb
	move.w	#$7fff,$96(a6)
	move.w	#$7fff,$9a(a6)
	move.l	#CopperList1,$100
	move.l	#CopperList1,$104
	move.l	#CopperList1,$80(a6)
	tst.w	$88(a6)
	move.w	#$83c0,$96(a6)
	lea	NewSOFT(pc),a0
	move.l	a0,$64.w
	lea	NewVB(pc),a0
	move.l	a0,$6c.w
	move.w	#$c024,$9a(a6)
	rts

;=========================================================
;--- MainLoop --------------------------------------------

MainLoop:
	cmpi.b	#-1,$6(a6)
	bne.s	MainLoop
	btst	#2,$16(a6)
	beq.s	ml_exit

	tst.w	pt_waitnew
	beq.s	MainLoop
	lea	mlcnt(pc),a0
	subq.w	#1,(a0)
	bne.s	MainLoop
	move.w	#2000,(a0)

	bsr	GoToPart

	move.w	#0,pt_enable
	bsr	ExgPtr
	move.w	#16,xpos
	move.w	#70,ypos
	lea	$dff000,a6
	bsr	ClearText
	lea	Messages(pc),a0
	lea	msgcnt(pc),a1
	move.w	(a1),d0
	addq.w	#4,(a1)
	move.l	(a0,d0.w),a0
	move.l	a0,TxtPos
	move.w	#1,pt_enable
	move.w	#0,pt_waitnew
	bra.s	MainLoop

ml_exit:
	rts

mlcnt:	dc.w	2000
Messages:
	dc.l	Msg2,Msg3,Msg4,Msg5,Msg6,Msg7
msgcnt:	dc.w	0
;=========================================================
GoToPart:
	lea	Parts(pc),a0
	lea	PPos(pc),a1
	move.w	(a1),d0
	addq.w	#4,(a1)
	move.l	(a0,d0.w),a0
	adda.l	#$20,a0
	jsr	(a0)
	rts

Parts:	dc.l	Part1,Part2,Part3,Part4,Part5,Part6,Part7
PPos:	dc.w	0
;=========================================================
ExgPtr:
	not.w	ptype

	lea	cols,a0
	movem.l	(a0),d0/d1
	exg.l	d0,d1
	movem.l	d0/d1,(a0)

	lea	Sinus,a0
	movem.l	(a0),d0/d1
	exg.l	d0,d1
	movem.l	d0/d1,(a0)
	addq.l	#8,a0
	movem.l	(a0),d0/d1
	exg.l	d0,d1
	movem.l	d0/d1,(a0)

	lea	Sinpos,a0
	movem.l	(a0),d0/d1
	exg.l	d0,d1
	movem.l	d0/d1,(a0)

	lea	Pattern,a0
	movem.l	(a0),d0/d1
	exg.l	d0,d1
	movem.l	d0/d1,(a0)
	rts
;=========================================================
InitAll:
	lea.l	CopBM+2,a0
	move.l	#Screen,d0
	moveq	#5-1,d1
ia_loop1:
	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
	swap	d0
	addi.l	#44*288,d0
	addq.w	#8,a0
	dbf	d1,ia_loop1

	lea	CopPL,a0
	move.l	Pattern,d1
	move.l	#$1bdffffe,d0
	movem.l	cols1(pc),d2/d3
	moveq	#9-1,d5
ia_loop2:
	moveq	#32-1,d4
ia_loop3:
	move.l	d0,(a0)+
	addi.l	#$01000000,d0
	move.w	#$F0,(a0)+
	swap	d1
	move.w	d1,(a0)+
	move.w	#$F2,(a0)+
	swap	d1
	move.w	d1,(a0)+
	move.w	#$180,(a0)+
	move.w	d2,(a0)+
	move.w	#$1a0,(a0)+
	move.w	d3,(a0)+

	cmpi.w	#6,d5
	bne.s	skip_cols
	cmpi.w	#24,d4
	bne.s	skip_cols
	move.l	#$01820FFF,(a0)+
	move.l	#$01840000,(a0)+
	move.l	#$01860076,(a0)+
	move.l	#$01A20FFF,(a0)+
	move.l	#$01A40000,(a0)+
	move.l	#$01A60076,(a0)+
skip_cols:
	dbf	d4,ia_loop3
	exg.l	d2,d3
	dbf	d5,ia_loop2
	move.l	d0,(a0)
	rts

cols:	dc.l	cols1,cols2
cols1:	dc.l	$f00,$ff0
cols2:	dc.l	$080,$060
;---------------------------------------------------------
MakeMulsList:
	lea.l	MulsList(pc),a0
	moveq	#0,d0
	move.l	#288-1,d1
mmloop:	move.w	d0,(a0)+
	addi.w	#44,d0
	dbf	d1,mmloop
	rts

MulsList:	dcb.w	288,0
	even
;=========================================================
;--- Interrupts ------------------------------------------

NewSOFT:
	movem.l	d0-d7/a0-a6,-(sp)

	tst.w	ptype
	bne.s	type2
	bsr	MovePlasma1
	bsr	PrintText
	movem.l	(sp)+,d0-d7/a0-a6
	move.w	#$4,$dff09c
	rte

type2:	bsr	MovePlasma2
	bsr	PrintText
	movem.l	(sp)+,d0-d7/a0-a6
	move.w	#$4,$dff09c
	rte

ptype:	dc.w	0

;---------------------------------------------------------
NewVB:	movem.l	d0-d7/a0-a6,-(sp)
	jsr	mt_music
	movem.l	(sp)+,d0-d7/a0-a6
	move.w	#$20,$dff09c
	rte
;=========================================================
PrintText:
	tst.w	pt_enable
	beq.w	pt_end
	lea	MulsList,a2
	lea	Offsets,a1
	move.l	TxtPos,a0
next_char:
	tst.b	(a0)
	bne.w	nch_ok
	move.w	#1,pt_waitnew
	rts

nch_ok:	addq.l	#1,TxtPos
	moveq	#0,d0
	move.b	(a0)+,d0
	cmpi.b	#10,d0
	bne.s	no_enter
	addi.w	#12,ypos
deb:	move.w	#16,xpos
	bra.s	next_char
no_enter:
	subi.w	#' ',d0
	add.w	d0,d0
	move.w	(a1,d0.w),d0
	lea	Font,a3
	lea	(a3,d0.w),a3
	lea	FontS,a5
	lea	(a5,d0.w),a5
	move.w	ypos(pc),d1
	add.w	d1,d1
	move.w	(a2,d1.w),d1
	move.w	xpos(pc),d2
	move.w	d2,d3
	lsr.w	#4,d3
	add.w	d3,d3
	add.w	d3,d1		; Screen offset
	lea	Screen,a4
	lea	(a4,d1.w),a4
	andi.w	#$f,d2
	ror.w	#4,d2
	ori.w	#$bfa,d2	; con0
	swap	d2
	move.w	#0,d2		; con0, con1

	addi.w	#10,xpos

	lea	$dff000,a6

pt_wb1:	btst	#6,$2(a6)
	bne.s	pt_wb1
	move.l	a3,$50(a6)	; apth
	move.l	a4,$48(a6)	; cpth
	move.l	a4,$54(a6)	; dpth
	move.w	#28,$64(a6)	; amod
	move.w	#40,$60(a6)	; cmod
	move.w	#40,$66(a6)	; dmod
	move.l	d2,$40(a6)	; con0, con1
	move.l	#$ffff0000,$44(a6)	; afwm, alwm
	move.w	#12<<6+2,$58(a6)

	addi.l	#32*96,a3
	addi.l	#44*288,a4

pt_wb2:	btst	#6,$2(a6)
	bne.s	pt_wb2
	move.l	a3,$50(a6)	; apth
	move.l	a4,$48(a6)	; cpth
	move.l	a4,$54(a6)	; dpth
	move.w	#28,$64(a6)	; amod
	move.w	#40,$60(a6)	; cmod
	move.w	#40,$66(a6)	; dmod
	move.l	d2,$40(a6)	; con0, con1
	move.l	#$ffff0000,$44(a6)	; afwm, alwm
	move.w	#12<<6+2,$58(a6)

	addi.l	#44*288*3,a4

pt_wb3:	btst	#6,$2(a6)
	bne.s	pt_wb3
	move.l	a5,$50(a6)	; apth
	move.l	a4,$48(a6)	; cpth
	move.l	a4,$54(a6)	; dpth
	move.w	#28,$64(a6)	; amod
	move.w	#40,$60(a6)	; cmod
	move.w	#40,$66(a6)	; dmod
	move.l	d2,$40(a6)	; con0, con1
	move.l	#$ffff0000,$44(a6)	; afwm, alwm
	move.w	#12<<6+2,$58(a6)
pt_end:	rts

xpos:		dc.w	16
ypos:		dc.w	70
pt_enable:	dc.w	1
pt_waitnew:	dc.w	0
;---------------------------------------------------------
ClearText:
	lea	Screen,a0
	lea	Plane6,a1
	addi.l	#70*44,a0
	addi.l	#70*44,a1

ctw1:	btst	#6,$2(a6)
	bne.s	ctw1
	
	move.l	#-1,$44(a6)
	move.l	#$1000000,$40(a6)
	clr.w	$66(a6)
	move.l	a0,$54(a6)
	move.w	#17*12<<6+22,$58(a6)

	addi.l	#288*44,a0

ctw2:	btst	#6,$2(a6)
	bne.s	ctw2
	
	move.l	#-1,$44(a6)
	move.l	#$1000000,$40(a6)
	clr.w	$66(a6)
	move.l	a0,$54(a6)
	move.w	#17*12<<6+22,$58(a6)

ctw3:	btst	#6,$2(a6)
	bne.s	ctw3
	
	move.l	#-1,$44(a6)
	move.l	#$1000000,$40(a6)
	clr.w	$66(a6)
	move.l	a1,$54(a6)
	move.w	#17*12<<6+22,$58(a6)
	rts

;---------------------------------------------------------
MovePlasma1:
	lea	CopPL+6,a0
	lea	MulsList,a1
	move.l	Pattern,a3
	move.l	cols(pc),a4
	movem.l	(a4),d2/d3

	move.l	Sinpos,a2
	addi.w	#6,a2
	move.l	Sinus,a4
	addi.l	#288*4,a4
	cmp.l	a2,a4
	bgt.s	sinok
	subi.w	#288*4,a2
sinok:	move.l	a2,Sinpos

	move.l	Sinus+8,a5

	move.w	(a2),d5
	lsr.w	#3,d5
	add.w	d5,d5
	move.w	(a5,d5.w),d4

	move.w	#288-1,d7
mp_loop1:
	move.w	(a2)+,d1
	move.w	(a1,d1.w),d5
	lea	(a3,d5.w),a4
	move.l	a4,d0
	swap	d0
	move.w	d0,(a0)
	swap	d0
	move.w	d0,4(a0)
	addq.w	#8,a0
	move.w	d2,(a0)
	move.w	d3,4(a0)
	cmpi.w	#216,d7
	bne.s	skip_more
	lea	24(a0),a0
skip_more:
	lea	12(a0),a0
	tst.w	d4
	bgt.s	nonew
	lsr.w	#3,d1
	add.w	d1,d1
	move.w	(a5,d1.w),d4
	exg.l	d2,d3
nonew:	subq.w	#1,d4
	dbf	d7,mp_loop1

	lea	$dff000,a6
	rts
;---------------------------------------------------------
MovePlasma2:
	lea	CopPL+6,a0
	lea	MulsList,a1
	move.l	Pattern,a3
	move.l	cols(pc),a4
	movem.l	(a4),d2/d3

	move.l	Sinus,a6

	move.l	Sinpos,a2
	addi.w	#2,a2
	move.l	Sinus,a4
	addi.l	#288*4,a4
	cmp.l	a2,a4
	bgt.s	sinok2
	subi.w	#288*4,a2
sinok2:	move.l	a2,Sinpos

	move.l	Sinus+8,a5

	move.w	(a2),d5
	lsr.w	#3,d5
	add.w	d5,d5
	move.w	(a5,d5.w),d4

	move.w	#288-1,d7
mp_loop2:
	move.w	(a2)+,d1
	add.w	(a6)+,d1
	lsr.w	#2,d1
	add.w	d1,d1
	move.w	(a1,d1.w),d5
	lea	(a3,d5.w),a4
	move.l	a4,d0
	swap	d0
	move.w	d0,(a0)
	swap	d0
	move.w	d0,4(a0)
	addq.w	#8,a0
	move.w	d2,(a0)
	move.w	d3,4(a0)
	cmpi.w	#216,d7
	bne.s	skip_more2
	lea	24(a0),a0
skip_more2:
	lea	12(a0),a0
	tst.w	d4
	bgt.s	nonew2
	lsr.w	#3,d1
	add.w	d1,d1
	move.w	(a5,d1.w),d4
nonew2:	subq.w	#1,d4
	dbf	d7,mp_loop2

	lea	$dff000,a6
	rts
;---------------------------------------------------------
Offsets:

R1=32*16*1
R2=32*16*2
R3=32*16*3
R4=32*16*4
R5=32*16*5

	dc.w	0			; space
	dc.w	2,4,6,8			; ! " # $
	dc.w	10,12,14,16		; % & ' (
	dc.w	18,20,22,24		; ) * + ,
	dc.w	26,28,30		; - . /
	dc.w	R1+0,R1+2,R1+4,R1+6	; 0 1 2 3
	dc.w	R1+8,R1+10,R1+12,R1+14	; 4 5 6 7
	dc.w	R1+16,R1+18,R1+20,R1+22	; 8 9 : ;
	dc.w	R1+24,R1+26,R1+28,R1+30	; < = > ?
	dc.w	R2+0,R2+2,R2+4,R2+6	; @ A B C
	dc.w	R2+8,R2+10,R2+12,R2+14	; D E F G
	dc.w	R2+16,R2+18,R2+20,R2+22	; H I J K
	dc.w	R2+24,R2+26,R2+28,R2+30	; L M N O
	dc.w	R3+0,R3+2,R3+4,R3+6	; P Q R S
	dc.w	R3+8,R3+10,R3+12,R3+14	; T U V W
	dc.w	R3+16,R3+18,R3+20,R3+22	; X Y Z [
	dc.w	R3+24,R3+26,R3+28,R3+30	; \ ] ^ _
	dc.w	R4+0,R4+2,R4+4,R4+6	; ' a b c
	dc.w	R4+8,R4+10,R4+12,R4+14	; d e f g
	dc.w	R4+16,R4+18,R4+20,R4+22	; h i j k
	dc.w	R4+24,R4+26,R4+28,R4+30	; l m n o
	dc.w	R5+0,R5+2,R5+4,R5+6	; p q r s
	dc.w	R5+8,R5+10,R5+12,R5+14	; t u v w
	dc.w	R5+16,R5+18,R5+20,R5+22	; x y z {
	dc.w	R5+24,R5+26,R5+28	; | } ~
;---------------------------------------------------------
Msg:
	dc.b	'--------------------------------',10
	dc.b	'            NO IDEA             ',10
	dc.b	'     is proudly to present',10
	dc.b	'       my new demo called',10,10
	dc.b	'   T H E   B U L L   S H I T',10,10
	dc.b	"If I don't count some old intros,",10
	dc.b	'and one stupid music disk, then',10
	dc.b	'this is my very first demo and',10
	dc.b	"I'm afraid,it's very last one.",10
	dc.b	'It was made only to release my',10
	dc.b	'old routines.',10
	dc.b	'--------------------------------',10
	dc.b	'NEXT:     VECTOR BOBS',10,10
	dc.b	'  DECRUNCHING & RELOCATING ...',10
	dc.b	0,0
	cnop	0,4

TxtPos:
	dc.l	Msg

Msg2:	dc.b	10
	dc.b	'Next you will see some old lame',10
	dc.b	'vectors. There are still missing',10
	dc.b	'rubbers,weither & shadow casting,',10
	dc.b	'but all are old and lame.',10
	dc.b	'Like everything in this demo. :-)',10
	dc.b	'--------------------------------',10,10,10,10,10
	dc.b	'--------------------------------',10
	dc.b	'NEXT:      VECTOR PART',10,10
	dc.b	'  DECRUNCHING & RELOCATING ...',10
	dc.b	0,0
	cnop	0,4

Msg3:	dc.b	10
	dc.b	'--------------------------------',10,10
	dc.b	'OK. Next you will see some dots',10
	dc.b	'effects.There are one big sphere',10
	dc.b	'and two tunnels. When I coded it',10
	dc.b	'I had wanted to broke some',10
	dc.b	'records, but it was realy hard',10
	dc.b	"to do. So I didn't break anyone.",10
	dc.b	'But instead of this I think,that',10
	dc.b	"I made it so fast. Let's see.",10,10
	dc.b	'--------------------------------',10
	dc.b	'NEXT:      DOTS EFECTS',10,10
	dc.b	'  DECRUNCHING & RELOCATING ...',10
	dc.b	0,0
	cnop	0,4

Msg4:	dc.b	'--------------------------------',10
	dc.b	'If you want to contact me from',10
	dc.b	'any reason, write to:',10
	dc.b	'                         NO IDEA',10
	dc.b	'                Vlastimil Knotek',10
	dc.b	'                       Tr.SNP 15',10
	dc.b	'                   040 11 Kosice',10
	dc.b	'                        SLOVAKIA',10
	dc.b	'er better email to:',10,10
	dc.b	'               noIdea@mailbox.sk',10,10
	dc.b	'--------------------------------',10
	dc.b	'NEXT:        PLASMA',10,10
	dc.b	'  DECRUNCHING & RELOCATING ...',10
	dc.b	0,0
	cnop	0,4

Msg5:	dc.b	10
	dc.b	'How do you like my plasma ?',10
	dc.b	"I've still made some other kinds",10
	dc.b	'of plasma, but this one is',10
	dc.b	'the most beautiful one.',10
	dc.b	'--------------------------------',10,10
	dc.b	'Now you will see a metamorph',10
	dc.b	'with 2701 pixels, then one lame',10
	dc.b	'bitmap deformation, and finally',10
	dc.b	'there is a very nice and fast',10
	dc.b	'zoom effect.',10,10
	dc.b	'--------------------------------',10
	dc.b	'NEXT:    BITMAP EFFECTS',10,10
	dc.b	'  DECRUNCHING & RELOCATING ...',10
	dc.b	0,0
	cnop	0,4

Msg6:	dc.b	10
	dc.b	"It was great zoom, wasn't it ?",10
	dc.b	"I've never seen this effect",10
	dc.b	"on old Amiga 500. Wasn't it",10
	dc.b	'fast ?',10
	dc.b	'--------------------------------',10
	dc.b	'Next, we will go on with very',10
	dc.b	'fast bitmap rotations. First one',10
	dc.b	'is the fastest one.With no copper',10
	dc.b	'but processor. Then will go on',10
	dc.b	'still two different ones with',10
	dc.b	'copper.',10,10
	dc.b	'--------------------------------',10
	dc.b	'NEXT:   BITMAP ROTATIONS',10,10
	dc.b	'  DECRUNCHING & RELOCATING ...',10
	dc.b	0,0
	cnop	0,4

Msg7:	dc.b	10
	dc.b	'So, what do you think about it?',10
	dc.b	'Am I good coder ? :)',10
	dc.b	'May be it was little bit buggy.',10
	dc.b	'Problem is that program works',10
	dc.b	"correct only if it isn't crunched",10
	dc.b	"I've never solved this problems.",10
	dc.b	"I still don't understand why it",10
	dc.b	"doesn't work crunched.So mystery.",10
	dc.b	'--------------------------------',10,10
	dc.b	"It's all folks.",10,10
	dc.b	'--------------------------------',10
	dc.b	'NEXT:       CREDITS',10,10
	dc.b	'  DECRUNCHING & RELOCATING ...',10
	dc.b	0,0
	cnop	0,4
;---------------------------------------------------------
CopperList1:
	dc.w	$09c,$8004
	dc.w	$1fc,$0,$106,$0
	dc.w	$008E,$1C71,$0090,$3CD1
	dc.w	$0092,$0030,$0094,$00D8
	dc.w	$0180,$0000,$0182,$0060,$0184,$0281,$0186,$04A2
	dc.w	$0188,$06D4,$018A,$08F7,$018C,$054A,$018E,$065B
	dc.w	$0190,$077B,$0192,$099C,$0194,$0BBD,$0196,$0953
	dc.w	$0198,$0A75,$019A,$0C98,$019C,$0DCB,$019E,$0FFF
	dc.w	$01A0,$0fff,$01A2,$0060,$01A4,$0281,$01A6,$04A2
	dc.w	$01A8,$06D4,$01AA,$08F7,$01AC,$054A,$01AE,$065B
	dc.w	$01B0,$077B,$01B2,$099C,$01B4,$0BBD,$01B6,$0953
	dc.w	$01B8,$0A75,$01BA,$0C98,$01BC,$0DCB,$01BE,$0FFF
CopBM:	dc.w	$00E0,$0000,$00E2,$0000
	dc.w	$00E4,$0000,$00E6,$0000
	dc.w	$00E8,$0000,$00EA,$0000
	dc.w	$00EC,$0000,$00EE,$0000
	dc.w	$00F4,$0000,$00F6,$0000
	dc.w	$0100,$6200,$0102,$0000,$0104,$0000
	dc.w	$0108,$0000,$010A,$0000
CopPL:	dcb.w	(2+4+4)*288+2+12,0
	dc.w	$0180,0
	dc.w	$ffff,$fffe
	even
;------------------------------------
		incdir 'tbsd:'
Screen:		incbin	'main/TheBullShit.RAW'
Plane6:		incbin	'main/TheBullShit_Shadow.RAW'
Font:		incbin	'main/font12x12x2.raw'
FontS:		incbin	'main/font12x12x2_shadow.RAW'
Pattern1:	incbin	'main/Pattern1.RAW'
Pattern2:	incbin	'main/Pattern2.RAW'
Pattern:	dc.l	Pattern1,Pattern2
;=========================================================
Sinus:	dc.l	Sinus1,Sinus2,Sinus12,Sinus22
Sinpos:	dc.l	sin1pos,sin2pos
Sinus1:
	DC.W	$00FE,$0100,$0102,$0106,$0108,$010A,$010E,$0110,$0114,$0116
	DC.W	$0118,$011C,$011E,$0120,$0124,$0126,$0128,$012C,$012E,$0132
	DC.W	$0134,$0136,$013A,$013C,$013E,$0142,$0144,$0146,$014A,$014C
	DC.W	$014E,$0152,$0154,$0156,$0158,$015C,$015E,$0160,$0164,$0166
	DC.W	$0168,$016A,$016E,$0170,$0172,$0174,$0176,$017A,$017C,$017E
	DC.W	$0180,$0182,$0186,$0188,$018A,$018C,$018E,$0190,$0192,$0196
	DC.W	$0198,$019A,$019C,$019E,$01A0,$01A2,$01A4,$01A6,$01A8,$01AA
	DC.W	$01AC,$01AE,$01B0,$01B2,$01B4,$01B6,$01B8,$01BA,$01BC,$01BE
	DC.W	$01C0,$01C0,$01C2,$01C4,$01C6,$01C8,$01CA,$01CC,$01CC,$01CE
	DC.W	$01D0,$01D2,$01D2,$01D4,$01D6,$01D8,$01D8,$01DA,$01DC,$01DC
	DC.W	$01DE,$01E0,$01E0,$01E2,$01E2,$01E4,$01E6,$01E6,$01E8,$01E8
	DC.W	$01EA,$01EA,$01EC,$01EC,$01EE,$01EE,$01EE,$01F0,$01F0,$01F2
	DC.W	$01F2,$01F2,$01F4,$01F4,$01F4,$01F6,$01F6,$01F6,$01F6,$01F8
	DC.W	$01F8,$01F8,$01F8,$01FA,$01FA,$01FA,$01FA,$01FA,$01FA,$01FA
	DC.W	$01FA,$01FA,$01FA,$01FA,$01FA,$01FA,$01FA,$01FA,$01FA,$01FA
	DC.W	$01FA,$01FA,$01FA,$01FA,$01FA,$01FA,$01F8,$01F8,$01F8,$01F8
	DC.W	$01F8,$01F6,$01F6,$01F6,$01F6,$01F4,$01F4,$01F4,$01F2,$01F2
	DC.W	$01F2,$01F0,$01F0,$01EE,$01EE,$01EE,$01EC,$01EC,$01EA,$01EA
	DC.W	$01E8,$01E8,$01E6,$01E4,$01E4,$01E2,$01E2,$01E0,$01DE,$01DE
	DC.W	$01DC,$01DC,$01DA,$01D8,$01D6,$01D6,$01D4,$01D2,$01D2,$01D0
	DC.W	$01CE,$01CC,$01CA,$01CA,$01C8,$01C6,$01C4,$01C2,$01C0,$01BE
	DC.W	$01BE,$01BC,$01BA,$01B8,$01B6,$01B4,$01B2,$01B0,$01AE,$01AC
	DC.W	$01AA,$01A8,$01A6,$01A4,$01A2,$01A0,$019E,$019C,$019A,$0196
	DC.W	$0194,$0192,$0190,$018E,$018C,$018A,$0188,$0184,$0182,$0180
	DC.W	$017E,$017C,$0178,$0176,$0174,$0172,$0170,$016C,$016A,$0168
	DC.W	$0166,$0162,$0160,$015E,$015A,$0158,$0156,$0154,$0150,$014E
	DC.W	$014C,$0148,$0146,$0144,$0140,$013E,$013C,$0138,$0136,$0134
	DC.W	$0130,$012E,$012C,$0128,$0126,$0122,$0120,$011E,$011A,$0118
	DC.W	$0116,$0112,$0110,$010E,$010A,$0108,$0104,$0102,$0100,$00FE
	DC.W	$00FC,$00F8,$00F6,$00F4,$00F0,$00EE,$00EC,$00E8,$00E6,$00E2
	DC.W	$00E0,$00DE,$00DA,$00D8,$00D6,$00D2,$00D0,$00CE,$00CA,$00C8
	DC.W	$00C4,$00C2,$00C0,$00BC,$00BA,$00B8,$00B4,$00B2,$00B0,$00AE
	DC.W	$00AA,$00A8,$00A6,$00A2,$00A0,$009E,$009C,$0098,$0096,$0094
	DC.W	$0090,$008E,$008C,$008A,$0088,$0084,$0082,$0080,$007E,$007C
	DC.W	$0078,$0076,$0074,$0072,$0070,$006E,$006A,$0068,$0066,$0064
	DC.W	$0062,$0060,$005E,$005C,$005A,$0058,$0056,$0054,$0052,$0050
	DC.W	$004E,$004C,$004A,$0048,$0046,$0044,$0042,$0040,$003E,$003C
	DC.W	$003A,$0038,$0038,$0036,$0034,$0032,$0030,$0030,$002E,$002C
	DC.W	$002A,$0028,$0028,$0026,$0024,$0024,$0022,$0020,$0020,$001E
	DC.W	$001C,$001C,$001A,$0018,$0018,$0016,$0016,$0014,$0014,$0012
	DC.W	$0012,$0010,$0010,$000E,$000E,$000C,$000C,$000C,$000A,$000A
	DC.W	$000A,$0008,$0008,$0008,$0006,$0006,$0006,$0004,$0004,$0004
	DC.W	$0004,$0004,$0002,$0002,$0002,$0002,$0002,$0002,$0002,$0002
	DC.W	$0002,$0002,$0002,$0002,$0002,$0002,$0002,$0002,$0002,$0002
	DC.W	$0002,$0002,$0002,$0002,$0002,$0004,$0004,$0004,$0004,$0004
	DC.W	$0006,$0006,$0006,$0006,$0008,$0008,$0008,$000A,$000A,$000A
	DC.W	$000C,$000C,$000E,$000E,$0010,$0010,$0010,$0012,$0012,$0014
	DC.W	$0016,$0016,$0018,$0018,$001A,$001A,$001C,$001E,$001E,$0020
	DC.W	$0022,$0022,$0024,$0026,$0026,$0028,$002A,$002C,$002C,$002E
	DC.W	$0030,$0032,$0034,$0034,$0036,$0038,$003A,$003C,$003E,$0040
	DC.W	$0042,$0044,$0044,$0046,$0048,$004A,$004C,$004E,$0050,$0052
	DC.W	$0054,$0056,$0058,$005A,$005C,$0060,$0062,$0064,$0066,$0068
	DC.W	$006A,$006C,$006E,$0070,$0074,$0076,$0078,$007A,$007C,$007E
	DC.W	$0082,$0084,$0086,$0088,$008A,$008E,$0090,$0092,$0094,$0098
	DC.W	$009A,$009C,$00A0,$00A2,$00A4,$00A6,$00AA,$00AC,$00AE,$00B2
	DC.W	$00B4,$00B6,$00BA,$00BC,$00BE,$00C2,$00C4,$00C6,$00CA,$00CC
	DC.W	$00CE,$00D2,$00D4,$00D6,$00DA,$00DC,$00E0,$00E2,$00E4,$00E8
	DC.W	$00EA,$00EC,$00F0,$00F2,$00F6,$00F8
	DC.W	$00FE,$0100,$0102,$0106,$0108,$010A,$010E,$0110,$0114,$0116
	DC.W	$0118,$011C,$011E,$0120,$0124,$0126,$0128,$012C,$012E,$0132
	DC.W	$0134,$0136,$013A,$013C,$013E,$0142,$0144,$0146,$014A,$014C
	DC.W	$014E,$0152,$0154,$0156,$0158,$015C,$015E,$0160,$0164,$0166
	DC.W	$0168,$016A,$016E,$0170,$0172,$0174,$0176,$017A,$017C,$017E
	DC.W	$0180,$0182,$0186,$0188,$018A,$018C,$018E,$0190,$0192,$0196
	DC.W	$0198,$019A,$019C,$019E,$01A0,$01A2,$01A4,$01A6,$01A8,$01AA
	DC.W	$01AC,$01AE,$01B0,$01B2,$01B4,$01B6,$01B8,$01BA,$01BC,$01BE
	DC.W	$01C0,$01C0,$01C2,$01C4,$01C6,$01C8,$01CA,$01CC,$01CC,$01CE
	DC.W	$01D0,$01D2,$01D2,$01D4,$01D6,$01D8,$01D8,$01DA,$01DC,$01DC
	DC.W	$01DE,$01E0,$01E0,$01E2,$01E2,$01E4,$01E6,$01E6,$01E8,$01E8
	DC.W	$01EA,$01EA,$01EC,$01EC,$01EE,$01EE,$01EE,$01F0,$01F0,$01F2
	DC.W	$01F2,$01F2,$01F4,$01F4,$01F4,$01F6,$01F6,$01F6,$01F6,$01F8
	DC.W	$01F8,$01F8,$01F8,$01FA,$01FA,$01FA,$01FA,$01FA,$01FA,$01FA
	DC.W	$01FA,$01FA,$01FA,$01FA,$01FA,$01FA,$01FA,$01FA,$01FA,$01FA
	DC.W	$01FA,$01FA,$01FA,$01FA,$01FA,$01FA,$01F8,$01F8,$01F8,$01F8
	DC.W	$01F8,$01F6,$01F6,$01F6,$01F6,$01F4,$01F4,$01F4,$01F2,$01F2
	DC.W	$01F2,$01F0,$01F0,$01EE,$01EE,$01EE,$01EC,$01EC,$01EA,$01EA
	DC.W	$01E8,$01E8,$01E6,$01E4,$01E4,$01E2,$01E2,$01E0,$01DE,$01DE
	DC.W	$01DC,$01DC,$01DA,$01D8,$01D6,$01D6,$01D4,$01D2,$01D2,$01D0
	DC.W	$01CE,$01CC,$01CA,$01CA,$01C8,$01C6,$01C4,$01C2,$01C0,$01BE
	DC.W	$01BE,$01BC,$01BA,$01B8,$01B6,$01B4,$01B2,$01B0,$01AE,$01AC
	DC.W	$01AA,$01A8,$01A6,$01A4,$01A2,$01A0,$019E,$019C,$019A,$0196
	DC.W	$0194,$0192,$0190,$018E,$018C,$018A,$0188,$0184,$0182,$0180
	DC.W	$017E,$017C,$0178,$0176,$0174,$0172,$0170,$016C,$016A,$0168
	DC.W	$0166,$0162,$0160,$015E,$015A,$0158,$0156,$0154,$0150,$014E
	DC.W	$014C,$0148,$0146,$0144,$0140,$013E,$013C,$0138,$0136,$0134
	DC.W	$0130,$012E,$012C,$0128,$0126,$0122,$0120,$011E,$011A,$0118
	DC.W	$0116,$0112,$0110,$010E,$010A,$0108,$0104,$0102,$0100,$00FE
	DC.W	$00FC,$00F8,$00F6,$00F4,$00F0,$00EE,$00EC,$00E8,$00E6,$00E2
	DC.W	$00E0,$00DE,$00DA,$00D8,$00D6,$00D2,$00D0,$00CE,$00CA,$00C8
	DC.W	$00C4,$00C2,$00C0,$00BC,$00BA,$00B8,$00B4,$00B2,$00B0,$00AE
	DC.W	$00AA,$00A8,$00A6,$00A2,$00A0,$009E,$009C,$0098,$0096,$0094
	DC.W	$0090,$008E,$008C,$008A,$0088,$0084,$0082,$0080,$007E,$007C
	DC.W	$0078,$0076,$0074,$0072,$0070,$006E,$006A,$0068,$0066,$0064
	DC.W	$0062,$0060,$005E,$005C,$005A,$0058,$0056,$0054,$0052,$0050
	DC.W	$004E,$004C,$004A,$0048,$0046,$0044,$0042,$0040,$003E,$003C
	DC.W	$003A,$0038,$0038,$0036,$0034,$0032,$0030,$0030,$002E,$002C
	DC.W	$002A,$0028,$0028,$0026,$0024,$0024,$0022,$0020,$0020,$001E
	DC.W	$001C,$001C,$001A,$0018,$0018,$0016,$0016,$0014,$0014,$0012
	DC.W	$0012,$0010,$0010,$000E,$000E,$000C,$000C,$000C,$000A,$000A
	DC.W	$000A,$0008,$0008,$0008,$0006,$0006,$0006,$0004,$0004,$0004
	DC.W	$0004,$0004,$0002,$0002,$0002,$0002,$0002,$0002,$0002,$0002
	DC.W	$0002,$0002,$0002,$0002,$0002,$0002,$0002,$0002,$0002,$0002
	DC.W	$0002,$0002,$0002,$0002,$0002,$0004,$0004,$0004,$0004,$0004
	DC.W	$0006,$0006,$0006,$0006,$0008,$0008,$0008,$000A,$000A,$000A
	DC.W	$000C,$000C,$000E,$000E,$0010,$0010,$0010,$0012,$0012,$0014
	DC.W	$0016,$0016,$0018,$0018,$001A,$001A,$001C,$001E,$001E,$0020
	DC.W	$0022,$0022,$0024,$0026,$0026,$0028,$002A,$002C,$002C,$002E
	DC.W	$0030,$0032,$0034,$0034,$0036,$0038,$003A,$003C,$003E,$0040
	DC.W	$0042,$0044,$0044,$0046,$0048,$004A,$004C,$004E,$0050,$0052
	DC.W	$0054,$0056,$0058,$005A,$005C,$0060,$0062,$0064,$0066,$0068
	DC.W	$006A,$006C,$006E,$0070,$0074,$0076,$0078,$007A,$007C,$007E
	DC.W	$0082,$0084,$0086,$0088,$008A,$008E,$0090,$0092,$0094,$0098
	DC.W	$009A,$009C,$00A0,$00A2,$00A4,$00A6,$00AA,$00AC,$00AE,$00B2
	DC.W	$00B4,$00B6,$00BA,$00BC,$00BE,$00C2,$00C4,$00C6,$00CA,$00CC
	DC.W	$00CE,$00D2,$00D4,$00D6,$00DA,$00DC,$00E0,$00E2,$00E4,$00E8
	DC.W	$00EA,$00EC,$00F0,$00F2,$00F6,$00F8

sin1pos:	dc.l	Sinus1

Sinus12:
	DC.W	$0022,$0022,$0022,$0022,$0022,$0021,$0021,$0021,$0021,$0021
	DC.W	$0020,$0020,$001F,$001F,$001F,$001E,$001E,$001D,$001D,$001C
	DC.W	$001B,$001B,$001A,$001A,$0019,$0018,$0018,$0017,$0016,$0016
	DC.W	$0015,$0014,$0014,$0013,$0012,$0012,$0011,$0010,$0010,$000F
	DC.W	$000E,$000E,$000D,$000D,$000C,$000B,$000B,$000A,$000A,$0009
	DC.W	$0009,$0009,$0008,$0008,$0007,$0007,$0007,$0007,$0007,$0006
	DC.W	$0006,$0006,$0006,$0006

Sinus2:
	DC.W	$0104,$010E,$011A,$0124,$0130,$013A,$0146,$0150,$015A,$0164
	DC.W	$016E,$0178,$0182,$018C,$0194,$019C,$01A6,$01AE,$01B6,$01BC
	DC.W	$01C4,$01CA,$01D2,$01D8,$01DC,$01E2,$01E6,$01EA,$01EE,$01F2
	DC.W	$01F4,$01F8,$01FA,$01FA,$01FC,$01FC,$01FC,$01FC,$01FA,$01FA
	DC.W	$01F8,$01F4,$01F2,$01EE,$01EA,$01E6,$01E2,$01DC,$01D8,$01D2
	DC.W	$01CC,$01C4,$01BE,$01B6,$01AE,$01A6,$019E,$0194,$018C,$0182
	DC.W	$0178,$016E,$0164,$015A,$0150,$0146,$013A,$0130,$0126,$011A
	DC.W	$0110,$0104,$00FA,$00EE,$00E2,$00D8,$00CE,$00C2,$00B8,$00AC
	DC.W	$00A2,$0098,$008E,$0084,$007A,$0072,$0068,$0060,$0058,$004E
	DC.W	$0048,$0040,$0038,$0032,$002C,$0026,$0020,$001A,$0016,$0012
	DC.W	$000E,$000A,$0008,$0006,$0004,$0002,$0000,$0000,$0000,$0000
	DC.W	$0002,$0002,$0004,$0008,$000A,$000E,$0010,$0016,$001A,$001E
	DC.W	$0024,$002A,$0030,$0038,$003E,$0046,$004E,$0056,$005E,$0068
	DC.W	$0070,$007A,$0082,$008C,$0096,$00A0,$00AC,$00B6,$00C0,$00CC
	DC.W	$00D6,$00E2,$00EC,$00F8,$0102,$010E,$0118,$0124,$012E,$013A
	DC.W	$0144,$014E,$0158,$0164,$016E,$0178,$0180,$018A,$0194,$019C
	DC.W	$01A4,$01AC,$01B4,$01BC,$01C4,$01CA,$01D0,$01D6,$01DC,$01E2
	DC.W	$01E6,$01EA,$01EE,$01F2,$01F4,$01F6,$01F8,$01FA,$01FC,$01FC
	DC.W	$01FC,$01FC,$01FA,$01FA,$01F8,$01F6,$01F2,$01EE,$01EC,$01E8
	DC.W	$01E2,$01DE,$01D8,$01D2,$01CC,$01C6,$01BE,$01B6,$01AE,$01A6
	DC.W	$019E,$0196,$018C,$0184,$017A,$0170,$0166,$015C,$0152,$0146
	DC.W	$013C,$0132,$0126,$011C,$0110,$0106,$00FA,$00F0,$00E4,$00DA
	DC.W	$00CE,$00C4,$00B8,$00AE,$00A4,$009A,$0090,$0086,$007C,$0072
	DC.W	$006A,$0060,$0058,$0050,$0048,$0040,$003A,$0032,$002C,$0026
	DC.W	$0020,$001C,$0016,$0012,$000E,$000A,$0008,$0006,$0004,$0002
	DC.W	$0000,$0000,$0000,$0000,$0002,$0002,$0004,$0006,$000A,$000C
	DC.W	$0010,$0014,$001A,$001E,$0024,$002A,$0030,$0036,$003E,$0046
	DC.W	$004C,$0054,$005E,$0066,$0070,$0078,$0082,$008C,$0096,$00A0
	DC.W	$00AA,$00B4,$00C0,$00CA,$00D6,$00E0,$00EC,$00F6,$0102,$010C
	DC.W	$0118,$0122,$012E,$0138,$0142,$014E,$0158,$0162,$016C,$0176
	DC.W	$0180,$018A,$0192,$019C,$01A4,$01AC,$01B4,$01BC,$01C2,$01CA
	DC.W	$01D0,$01D6,$01DC,$01E0,$01E6,$01EA,$01EE,$01F2,$01F4,$01F6
	DC.W	$01F8,$01FA,$01FC,$01FC,$01FC,$01FC,$01FA,$01FA,$01F8,$01F6
	DC.W	$01F2,$01F0,$01EC,$01E8,$01E2,$01DE,$01D8,$01D2,$01CC,$01C6
	DC.W	$01BE,$01B8,$01B0,$01A8,$01A0,$0196,$018E,$0184,$017A,$0170
	DC.W	$0166,$015C,$0152,$0148,$013E,$0132,$0128,$011C,$0112,$0106
	DC.W	$00FC,$00F0,$00E6,$00DA,$00D0,$00C4,$00BA,$00B0,$00A4,$009A
	DC.W	$0090,$0086,$007C,$0074,$006A,$0062,$0058,$0050,$0048,$0040
	DC.W	$003A,$0032,$002C,$0026,$0020,$001C,$0016,$0012,$000E,$000C
	DC.W	$0008,$0006,$0004,$0002,$0000,$0000,$0000,$0000,$0002,$0002
	DC.W	$0004,$0006,$000A,$000C,$0010,$0014,$0018,$001E,$0024,$002A
	DC.W	$0030,$0036,$003C,$0044,$004C,$0054,$005C,$0066,$006E,$0078
	DC.W	$0080,$008A,$0094,$009E,$00AA,$00B4,$00BE,$00CA,$00D4,$00E0
	DC.W	$00EA,$00F6,$0100,$010C,$0116,$0122,$012C,$0138,$0142,$014C
	DC.W	$0156,$0162,$016C,$0176,$017E,$0188,$0192,$019A,$01A2,$01AC
	DC.W	$01B4,$01BA,$01C2,$01C8,$01D0,$01D6,$01DA,$01E0,$01E6,$01EA
	DC.W	$01EE,$01F0,$01F4,$01F6,$01F8,$01FA,$01FC,$01FC,$01FC,$01FC
	DC.W	$01FA,$01FA,$01F8,$01F6,$01F2,$01F0,$01EC,$01E8,$01E4,$01DE
	DC.W	$01DA,$01D4,$01CE,$01C6,$01C0,$01B8,$01B0,$01A8,$01A0,$0198
	DC.W	$018E,$0186,$017C,$0172,$0168,$015E,$0154,$0148,$013E,$0134
	DC.W	$0128,$011E,$0112,$0108,$00FC,$00F2,$00E6,$00DC,$00D0,$00C6
	DC.W	$00BA,$00B0,$00A6,$009C,$0092,$0088,$007E,$0074,$006C,$0062
	DC.W	$005A,$0052,$004A,$0042,$003A,$0034,$002E,$0028,$0022,$001C
	DC.W	$0018,$0012,$000E,$000C,$0008,$0006,$0004,$0002,$0000,$0000
	DC.W	$0000,$0000,$0002,$0002,$0004,$0006,$0008,$000C,$0010,$0014
	DC.W	$0018,$001E,$0022,$0028,$002E,$0036,$003C,$0044,$004C,$0054
	DC.W	$005C,$0064,$006E,$0076,$0080,$008A,$0094,$009E,$00A8,$00B2
	DC.W	$00BE,$00C8,$00D2,$00DE,$00E8,$00F4
	DC.W	$0104,$010E,$011A,$0124,$0130,$013A,$0146,$0150,$015A,$0164
	DC.W	$016E,$0178,$0182,$018C,$0194,$019C,$01A6,$01AE,$01B6,$01BC
	DC.W	$01C4,$01CA,$01D2,$01D8,$01DC,$01E2,$01E6,$01EA,$01EE,$01F2
	DC.W	$01F4,$01F8,$01FA,$01FA,$01FC,$01FC,$01FC,$01FC,$01FA,$01FA
	DC.W	$01F8,$01F4,$01F2,$01EE,$01EA,$01E6,$01E2,$01DC,$01D8,$01D2
	DC.W	$01CC,$01C4,$01BE,$01B6,$01AE,$01A6,$019E,$0194,$018C,$0182
	DC.W	$0178,$016E,$0164,$015A,$0150,$0146,$013A,$0130,$0126,$011A
	DC.W	$0110,$0104,$00FA,$00EE,$00E2,$00D8,$00CE,$00C2,$00B8,$00AC
	DC.W	$00A2,$0098,$008E,$0084,$007A,$0072,$0068,$0060,$0058,$004E
	DC.W	$0048,$0040,$0038,$0032,$002C,$0026,$0020,$001A,$0016,$0012
	DC.W	$000E,$000A,$0008,$0006,$0004,$0002,$0000,$0000,$0000,$0000
	DC.W	$0002,$0002,$0004,$0008,$000A,$000E,$0010,$0016,$001A,$001E
	DC.W	$0024,$002A,$0030,$0038,$003E,$0046,$004E,$0056,$005E,$0068
	DC.W	$0070,$007A,$0082,$008C,$0096,$00A0,$00AC,$00B6,$00C0,$00CC
	DC.W	$00D6,$00E2,$00EC,$00F8,$0102,$010E,$0118,$0124,$012E,$013A
	DC.W	$0144,$014E,$0158,$0164,$016E,$0178,$0180,$018A,$0194,$019C
	DC.W	$01A4,$01AC,$01B4,$01BC,$01C4,$01CA,$01D0,$01D6,$01DC,$01E2
	DC.W	$01E6,$01EA,$01EE,$01F2,$01F4,$01F6,$01F8,$01FA,$01FC,$01FC
	DC.W	$01FC,$01FC,$01FA,$01FA,$01F8,$01F6,$01F2,$01EE,$01EC,$01E8
	DC.W	$01E2,$01DE,$01D8,$01D2,$01CC,$01C6,$01BE,$01B6,$01AE,$01A6
	DC.W	$019E,$0196,$018C,$0184,$017A,$0170,$0166,$015C,$0152,$0146
	DC.W	$013C,$0132,$0126,$011C,$0110,$0106,$00FA,$00F0,$00E4,$00DA
	DC.W	$00CE,$00C4,$00B8,$00AE,$00A4,$009A,$0090,$0086,$007C,$0072
	DC.W	$006A,$0060,$0058,$0050,$0048,$0040,$003A,$0032,$002C,$0026
	DC.W	$0020,$001C,$0016,$0012,$000E,$000A,$0008,$0006,$0004,$0002
	DC.W	$0000,$0000,$0000,$0000,$0002,$0002,$0004,$0006,$000A,$000C
	DC.W	$0010,$0014,$001A,$001E,$0024,$002A,$0030,$0036,$003E,$0046
	DC.W	$004C,$0054,$005E,$0066,$0070,$0078,$0082,$008C,$0096,$00A0
	DC.W	$00AA,$00B4,$00C0,$00CA,$00D6,$00E0,$00EC,$00F6,$0102,$010C
	DC.W	$0118,$0122,$012E,$0138,$0142,$014E,$0158,$0162,$016C,$0176
	DC.W	$0180,$018A,$0192,$019C,$01A4,$01AC,$01B4,$01BC,$01C2,$01CA
	DC.W	$01D0,$01D6,$01DC,$01E0,$01E6,$01EA,$01EE,$01F2,$01F4,$01F6
	DC.W	$01F8,$01FA,$01FC,$01FC,$01FC,$01FC,$01FA,$01FA,$01F8,$01F6
	DC.W	$01F2,$01F0,$01EC,$01E8,$01E2,$01DE,$01D8,$01D2,$01CC,$01C6
	DC.W	$01BE,$01B8,$01B0,$01A8,$01A0,$0196,$018E,$0184,$017A,$0170
	DC.W	$0166,$015C,$0152,$0148,$013E,$0132,$0128,$011C,$0112,$0106
	DC.W	$00FC,$00F0,$00E6,$00DA,$00D0,$00C4,$00BA,$00B0,$00A4,$009A
	DC.W	$0090,$0086,$007C,$0074,$006A,$0062,$0058,$0050,$0048,$0040
	DC.W	$003A,$0032,$002C,$0026,$0020,$001C,$0016,$0012,$000E,$000C
	DC.W	$0008,$0006,$0004,$0002,$0000,$0000,$0000,$0000,$0002,$0002
	DC.W	$0004,$0006,$000A,$000C,$0010,$0014,$0018,$001E,$0024,$002A
	DC.W	$0030,$0036,$003C,$0044,$004C,$0054,$005C,$0066,$006E,$0078
	DC.W	$0080,$008A,$0094,$009E,$00AA,$00B4,$00BE,$00CA,$00D4,$00E0
	DC.W	$00EA,$00F6,$0100,$010C,$0116,$0122,$012C,$0138,$0142,$014C
	DC.W	$0156,$0162,$016C,$0176,$017E,$0188,$0192,$019A,$01A2,$01AC
	DC.W	$01B4,$01BA,$01C2,$01C8,$01D0,$01D6,$01DA,$01E0,$01E6,$01EA
	DC.W	$01EE,$01F0,$01F4,$01F6,$01F8,$01FA,$01FC,$01FC,$01FC,$01FC
	DC.W	$01FA,$01FA,$01F8,$01F6,$01F2,$01F0,$01EC,$01E8,$01E4,$01DE
	DC.W	$01DA,$01D4,$01CE,$01C6,$01C0,$01B8,$01B0,$01A8,$01A0,$0198
	DC.W	$018E,$0186,$017C,$0172,$0168,$015E,$0154,$0148,$013E,$0134
	DC.W	$0128,$011E,$0112,$0108,$00FC,$00F2,$00E6,$00DC,$00D0,$00C6
	DC.W	$00BA,$00B0,$00A6,$009C,$0092,$0088,$007E,$0074,$006C,$0062
	DC.W	$005A,$0052,$004A,$0042,$003A,$0034,$002E,$0028,$0022,$001C
	DC.W	$0018,$0012,$000E,$000C,$0008,$0006,$0004,$0002,$0000,$0000
	DC.W	$0000,$0000,$0002,$0002,$0004,$0006,$0008,$000C,$0010,$0014
	DC.W	$0018,$001E,$0022,$0028,$002E,$0036,$003C,$0044,$004C,$0054
	DC.W	$005C,$0064,$006E,$0076,$0080,$008A,$0094,$009E,$00A8,$00B2
	DC.W	$00BE,$00C8,$00D2,$00DE,$00E8,$00F4

sin2pos:	dc.l	Sinus2

Sinus22:
	dcb.w	64,0

	cnop	0,2

;---------------------------------------------------------
	include	'tbsd:ptplay.s'
;---------------------------------------------------------

mt_data:	incbin	'main/mod.dragon'

;*********************************************************
;*********************************************************
;*********************************************************
	even

	incdir 'tbsd:'

Part1:	incbin	'VectorBobs.crm'
	even
Part2:	incbin	'Vectors.crm'
	even
Part3:	incbin	'Dots.crm'
	even
Part4:	incbin	'Plasma.crm'
	even
Part5:	incbin	'Everithing.crm'
	even
Part6:	incbin	'2d_bitmap_rot.crm'
	even
Part7:	incbin	'TitleScroll.crm'
	even
RelBuf:
