                                        ;===============================================
;=== Vector Bobs Routive V1.2 		     ===
;=== Copyright (c)1997 by Vlastimil Knotek   ===
;=== Assembler used: ASM-One V1.29 By T.F.A. ===
;=== Released day: 29-Mar-1997		     ===
;=== File: VectorBobs.asm		     ===
;===============================================
>EXTERN 'tbsd:bobs3d/MirBlue',MirrorTab
>EXTERN 'tbsd:bobs3d/balls.blt',Balls
>EXTERN 'tbsd:bobs3d/masks.blt',Masks
>EXTERN	'tbsd:bobs3d/BSBobs.RAW',Pic
>EXTERN	'tbsd:bobs3d/bobs3D.tp3',module
;---------------------------------------------------------
MAXPOINTS1	=	105
MAXPOINTS2	=	7
MAXPOINTS3	=	5
RESOLUTION	=	320
LACE		=	256
DEPTH		=	4
;---------------------------------------------------------
Start:
	movem.l	d0-d7/a0-a6,-(a7)
	bsr	SaveAll
	bsr	InitAll
	bsr	MakeMulsList

	move.l	#module,tp_data
	bsr	tp_init

	lea	Scene1(pc),a1
	bsr	InitAnim
	bsr	StartCopper
	bsr	MainLoop

	lea	Scene2(pc),a1
	bsr	InitAnim
	bsr	MainLoop

	lea	Scene3(pc),a1
	bsr	InitAnim
	bsr	MainLoop

	lea	Scene4(pc),a1
	bsr	InitAnim
	bsr	MainLoop

	lea	Scene5(pc),a1
	bsr	InitAnim
	bsr	MainLoop

	lea	Scene6(pc),a1
	bsr	InitAnim
	bsr	MainLoop

	lea	Scene7(pc),a1
	bsr	InitAnim
	bsr	MainLoop

	lea	Scene8(pc),a1
	bsr	InitAnim
	bsr	MainLoop

	lea	Scene9(pc),a1
	bsr	InitAnim
	bsr	MainLoop

	lea	Scene10(pc),a1
	bsr	InitAnim
	bsr	MainLoop

	lea	Scene11(pc),a1
	bsr	InitAnim
	bsr	MainLoop

	bsr	tp_end

	bsr	RestoreAll
	movem.l	(a7)+,d0-d7/a0-a6
	rts
;---------------------------------------------------------
SaveAll:
;	move.l	$4.w,a6
;	lea.l	GfxName(pc),a1
;	moveq	#0,D0
;	jsr	-408(a6)	;OldOpenLibrary
;	move.l	d0,a1
	lea	OldCopper1(pc),a0
	move.l	$100,(a0)
;	move.l	$26(a1),(a0)
	lea	OldCopper2(pc),a0
	move.l	$104,(a0)
;	move.l	$32(a1),(a0)
;	jsr	-414(a6)	;CloseLibrary

	move.l	chipbase(pc),a6
	lea	OldDMACON(pc),a0
	move.w	$002(a6),(a0)+
	move.w	$01c(a6),(a0)+
	move.l	$64.w,(a0)
	rts
;---------------------------------------------------------
InitAll:
	lea	SpritesPtr(pc),a0
	move.l	(a0)+,a1
	move.l	(a0)+,a2
	move.l	(a0)+,a3
	move.l	#200-1,d0
.cloop	move.w	(a1),40(a1)
	move.w	(a2),40(a2)
	move.w	(a3),40(a3)
	addq.l	#2,a1
	addq.l	#2,a2
	addq.l	#2,a3
	dbf	d0,.cloop

	lea	SpritesPtr(pc),a0
	lea	SpritesPos(pc),a2
	moveq	#3-1,d0
.setc1	move.l	(a0)+,a1
	moveq	#11-1,d1
.setc2	move.w	(a2),(a1)
	move.b	(a2),2(a1)
	add.b	#9,2(a1)
	addq.l	#2,a2
	lea	40(a1),a1
	dbf	d1,.setc2
	dbf	d0,.setc1

	lea	CopperList+$2,a0
	lea	SpritesPtr(pc),a1
	moveq	#3-1,d1
.ints	move.l	(a1)+,d0
	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
	addq.l	#$8,a0
	dbf	d1,.ints

	move.l	(a1),d0
	moveq	#5-1,d1
.sloop	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
	swap	d0
	addq.l	#$8,a0
	dbf	d1,.sloop

	lea	BMaps+$2,a0
	move.l	PicPtr(pc),d0
	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)

	lea	Top,a0
	move.l	#$2c07fffe,d0
	move.l	#$01800f00,d1
	move.l	#$01820000,d2
	moveq	#15,d3
.tset	move.l	d0,(a0)+
	addi.l	#$01000000,d0
	move.l	d1,(a0)+
	move.l	d2,(a0)+
	subi.l	#$00000100,d1
	addi.l	#$00000100,d2
	dbf	d3,.tset

	lea	Mirror,a0
	lea	MirrorTab,a1
	moveq	#11-1,d1
	move.l	#$f507fffe,d0
.scol1	move.l	d0,(a0)+
	addi.l	#$01000000,d0
	move.w	#$0180,(a0)+
	move.w	(a1)+,(a0)+
	dbf	d1,.scol1

	lea	12(a0),a0
	moveq	#48-1,d1
	move.l	#$0007fffe,d0
.scol2	move.l	d0,(a0)+
	addi.l	#$01000000,d0
	move.w	#$0180,(a0)+
	move.w	(a1)+,(a0)+
	dbf	d1,.scol2

	rts
;---------------------------------------------------------
MakeMulsList:
	move.l	MulsPtr(pc),a0
	move.l	Width(pc),d1
	add.l	d1,d1
	add.l	d1,d1
	moveq	#0,d0
	move.l	#LACE-1,d2
mmloop:	move.l	d0,(a0)+
	add.l	d1,d0
	dbf	d2,mmloop
	rts
;---------------------------------------------------------
StartCopper:
	cmpi.b	#-1,$6(a6)
	bne.s	StartCopper
	move.w	#$24,$9a(a6)
sc1wb:	btst	#6,$2(a6)
	bne.s	sc1wb
	move.w	#$40,$096(a6)
sc1wvb:	cmpi.b	#-1,$6(a6)
	bne.s	sc1wvb
	move.w	#$7fff,$96(a6)
	move.w	#$3fff,$9a(a6)
	lea	CopperList,a0
	move.l	a0,$80(a6)
	tst.w	$88(a6)
	move.w	#$82e0,$96(a6)
	lea	Interrupt(pc),a0
	move.l	a0,$64.w
	move.w	#$c004,$9a(a6)
	rts
;---------------------------------------------------------
InitAnim:
	bsr	ClearBig
	movem.l	PlaneH(pc),d0-d1
	move.l	d0,PlaneS
	move.l	d1,PlaneH
	bsr	ClearBig	

	move.l	a1,ScenePtr
	move.l	RootPtr(pc),a2
	move.w	(a1)+,d0	; number of objects
	subq.w	#1,d0
IA_01:
	move.l	(a1)+,a0	; address of object
	move.l	8(a0),a3
	lea	-14(a3),a3
	move.l	a3,4(a2)	; adresa na cinnost
	move.w	#0,8(a2)
	move.w	#0,10(a2)
	lea	12(a2),a2
	dbf	d0,IA_01

	lea	24(a0),a0
	lea	CopCol+$2,a1
	moveq	#15,d1
.scol	move.w	(a0)+,(a1)
	addq.l	#4,a1
	dbf	d1,.scol

	bsr	Move
	move.w	#0,ends
	rts
;---------------------------------------------------------
MainLoop:
	cmp.b	#-1,$6(a6)
	bne.s	MainLoop
.ml	cmp.b	#$18,$6(a6)
	bne.s	.ml

	bsr	Show
	bsr	ClearBig
	bsr	DoAnim

	move.w	ends(pc),d0
	tst.w	d0
	beq.s	MainLoop
	rts
;---------------------------------------------------------
RestoreAll:
	move.l	chipbase(pc),a6
ra_wvb:	cmpi.b	#-1,$6(a6)
	bne.s	ra_wvb
	move.w	#$7fff,$09a(a6)
raw:	btst	#6,$2(a6)
	bne.s	raw
	move.w	#$7fff,$096(a6)
	move.l	OldCopper1(pc),$080(a6)
;	move.l	$100,$080(a6)
	tst.w	$88(a6)
	move.l	OldCopper2(pc),$084(a6)
	tst.w	$8a(a6)
	move.l	OldSOFT(pc),$64.w
	move.w	OldDMACON(pc),d0
	or.w	#$8000,d0
	move.w	OldINTENA(pc),d1
	or.w	#$8000,d1
	move.w	d0,$096(a6)
	move.w	d1,$09a(a6)
	rts
;=========================================================
GfxName		DC.B	'graphics.library',0
		even
OldCopper1:	DC.L	0
OldCopper2:	DC.L	0
OldDMACON:	DC.W	0
OldINTENA:	DC.W	0
OldSOFT:	DC.L	0
;=========================================================
Interrupt:
	movem.l	d0-d7/a0-a6,-(a7)
	bsr	Stars
	bsr	tp_play
	move.l	chipbase(pc),a6
	bsr	Move
InterEnd:
	move.w	#$4,$09c(a6)
	movem.l	(a7)+,d0-d7/a0-a6
	rte
;=========================================================
Stars:	lea	Sprite1(pc),a0
	lea	Sprite2(pc),a1
	lea	Sprite3(pc),a2
	moveq	#11-1,d0
	moveq	#0,d1
.sloop	addq.b	#3,1(a0)
	addq.b	#2,1(a1)
	addq.b	#1,1(a2)
	add.b	d1,1(a0)
	add.b	d1,1(a1)
	add.b	d1,1(a2)
	lea	40(a0),a0
	lea	40(a1),a1
	lea	40(a2),a2
	addq.l	#1,d1
	cmpi.b	#4,d1
	bne.s	.cont
	moveq	#1,d1
.cont	dbf	d0,.sloop
	rts
;---------------------------------------------------------
Show:
	movem.l	PlaneH(pc),d0-d1
	move.l	d0,PlaneS
	move.l	d1,PlaneH
	lea	BitMaps+$2,a0
	moveq	#DEPTH-1,d1
	addi.l	#$c80,d0
.clp:	swap	d0
	move.w	d0,(a0)
	swap	d0
	move.w	d0,4(a0)
	add.l	#RESOLUTION/8,d0
	addq.l	#8,a0
	dbf	d1,.clp
	rts
;---------------------------------------------------------
ClearBig:
	move.l	chipbase(pc),a6

w2	btst	#6,$dff002
	bne.s	w2
  
	moveq	#-1,d0
	move.l	d0,$44(a6)
	move.w	#0,$66(a6)  
	move.l	#$1000000,$40(a6)
	move.l	PlaneH(pc),$54(a6)
	move.w	#DEPTH*LACE,$5c(a6)
	move.w	#RESOLUTION/16,$5e(a6)
	rts
;---------------------------------------------------------
Move:
	movem.l	d2-d3/a2-a3,-(a7)
	move.l	ScenePtr(pc),a2		; scene struct
	move.l	RootPtr(pc),a3
	move.w	(a2)+,d2		; number of objects
	subq.w	#1,d2
.lab
	move.l	(a2)+,a1	; address of object
	tst.w	10(a3)
	bne.w	.end
	move.l	4(a3),a0
	subq.w	#1,8(a3)
	bge.s	.ok
	lea	14(a0),a0
.ok3:
	cmp.w	#-1,(a0)	; koniec tabulky cinnosti ?
	bgt.s	.ok2
	move.w	#1,10(a3)
	movem.l	(a7)+,d2-d3/a2-a3
	rts
.ok2:
	move.w	(a0),8(a3)
	subq.w	#1,8(a3)
	move.l	a0,4(a3)
.ok:
	addq.l	#2,a0
	move.w	(a0)+,d0
	add.w	d0,12(a1)	; addx
	move.w	(a0)+,d0
	add.w	d0,14(a1)	; addy
	move.w	(a0)+,d0
	add.w	d0,16(a1)	; addz
	move.w	#360,d1
	move.w	d1,d3
	neg.w	d3
	move.w	(a0)+,d0
	add.w	d0,18(a1)	; add alfa
	cmp.w	18(a1),d3	; menej nez -360 ?
	blt.s	.okx
	add.w	d1,18(a1)
.okx:
	cmp.w	18(a1),d1	; viac ako 360 ?
	bgt.s	.ok1x
	sub.w	d1,18(a1)
.ok1x:
	move.w	(a0)+,d0
	add.w	d0,20(a1)	; add beta
	cmp.w	20(a1),d3
	blt.s	.oky
	add.w	d1,20(a1)
.oky:
	cmp.w	20(a1),d1
	bgt.s	.ok1y
	sub.w	d1,20(a1)
.ok1y:
	move.w	(a0)+,d0	; add gama
	add.w	d0,22(a1)
	cmp.w	22(a1),d3
	blt.s	.okz
	add.w	d1,22(a1)
.okz:
	cmp.w	22(a1),d1
	bgt.s	.end
	sub.w	d1,22(a1)
.end:
	lea	12(a3),a3
	dbf	d2,.lab
	movem.l	(a7)+,d2-d3/a2-a3
	rts
;---------------------------------------------------------
DoAnim:
	move.l	zorgptr(pc),ztabptr
	move.l	dtorgptr(pc),dttabptr
	move.w	#-1,drawnum		; forbit drawing
	move.l	RootPtr(pc),a2
	move.l	(a2),tmom
	move.l	ScenePtr(pc),a1
	move.w	(a1)+,d0		; numbers of objects
	subq.w	#1,d0
.ok:
	move.l	(a1)+,a0		; address of object
	movem.l	d0/a1-a2,-(a7)
	move.l	(a0)+,pdptr		; pointer to points
	move.l	(a0)+,atabptr		; pointer to gule
	lea	addx(pc),a1
	addq.l	#4,a0			; set ptr to start coords (x,y,z)
	movem.w	(a0),d0-d5		; x,y,z,alfa,beta,gama
	add.w	d3,d3			; alfa*2
	bge.s	.ok1
	add.w	#720,d3			; angle correction
.ok1:
	add.w	d4,d4
	bge.s	.ok2
	add.w	#720,d4
.ok2:
	add.w	d5,d5
	bge.s	.ok3
	add.w	#720,d5
.ok3:
	ext.l	d0
	asl.l	#4,d0		;start x*16
	ext.l	d1
	asl.l	#4,d1		;start y*16
	ext.l	d2
	asl.l	#4,d2		;start z*16
	movem.l	d0-d2,(a1)	;addx,addy,addz
	lea	12(a1),a1	;rx addrress
	movem.w	d3-d5,(a1)	;write angles to rx,ry,rz

	bsr.w	transform
	bsr	preparequick

	movem.l	(a7)+,d0/a1-a2
.nocalc:
	lea	12(a2),a2
	move.l	(a2),tmom
	dbf	d0,.ok

	bsr.w	vector

	move.l	ScenePtr(pc),a1
	move.w	(a1),d2		;pocet objectov
	subq.w	#1,d2
	move.l	RootPtr(pc),a3
endlp:
	tst.w	10(a3)
	beq.w	.end
	lea	12(a3),a3
	dbf	d2,endlp
	move.w	#1,ends
.end	rts
;---------------------------------------------------------
transform:
	move.l	pdptr(pc),a2	; address of points tab
	move.l	tmom(pc),a3	; address of new 2D coords
	lea	sintab(pc),a0
	lea	costab(pc),a1
	move.l	ztabptr(pc),a4	; address of Z coords
	move.w	(a2)+,d5	; number of points
	subq.w	#1,d5
lp7:
	movem.w	(a2)+,d0-d2	; read x,y,z
	moveq	#4,d4
	asl.w	d4,d0
	asl.w	d4,d1
	asl.w	d4,d2
	move.w	rx(pc),d3	; rotate x [x angle(alfa)]
	move.w	d1,d4
	move.w	d2,d7
	muls	(a1,d3.w),d1	; ny=y*cos(al)
	muls	(a0,d3.w),d2	; nz=z*sin(al)
	sub.l	d2,d1		; fy=ny-nz
	add.l	d1,d1
	swap	d1
	muls	(a0,d3.w),d4	; ny=y*sin(al)
	muls	(a1,d3.w),d7	; nz=z*cos(al)
	add.l	d7,d4		; fz=ny-nz
	add.l	d4,d4
	swap	d4
	move.w	d4,d2		; d2=z

	move.w	ry(pc),d3
	move.w	d0,d4
	move.w	d2,d7
	muls	(a1,d3.w),d0	; nx=x*cos(be)
	muls	(a0,d3.w),d2	; nz=z*sin(be)
	add.l	d2,d0		; fx=nx+nz
	add.l	d0,d0
	swap	d0
	neg.w	d4		; d4=-x
	muls	(a0,d3.w),d4	; nx=-x*sin(be)
	muls	(a1,d3.w),d7	; ny=y*cos(be)
	add.l	d7,d4		; fz=nx+ny
	add.l	d4,d4
	swap	d4
	move.w	d4,d2

	move.w	rz(pc),d3
	move.w	d0,d4
	move.w	d1,d7
	muls	(a1,d3.w),d0	; nx=x*cos(ga)
	muls	(a0,d3.w),d1	; ny=y*sin(ga)
	sub.l	d1,d0		; fx=nx-ny
	add.l	d0,d0
	swap	d0
	muls	(a0,d3.w),d4	; nx=x*sin(ga)
	muls	(a1,d3.w),d7	; ny=y*cos(ga)
	add.l	d7,d4		; fy=nx+ny
	add.l	d4,d4
	swap	d4
	move.w	d4,d1

;PERSPECTIVE
	ext.l	d0
	ext.l	d1
	ext.l	d2
	add.l	addx(pc),d0
	add.l	addy(pc),d1
	add.l	addz(pc),d2
	move.l	d2,(a4)+	; Z coord
	moveq	#10,d3
	asl.l	d3,d0
	asl.l	d3,d1
	asr.l	#3,d2
	beq.s	.pjtend
	divs	d2,d0
	divs	d2,d1
	neg.w	d0
	add.w	Midx(pc),d0
	add.w	Midy(pc),d1
.pjtend:
	movem.w	d0-d1,(a3)
	addq.l	#4,a3
	dbf	d5,lp7
	move.l	a4,ztabptr
	subq.l	#4,a4
	move.l	a4,zend		; koniec ztab - pre Quicksort
	rts
;---------------------------------------------------------
preparequick:
	move.l	pdptr(pc),a1	; points
	move.l	atabptr(pc),a2	; gule
	move.l	tmom(pc),a3	; 2D SUR
	move.l	dttabptr(pc),a4	; Pointer na 2d sur , num. of bob 
	move.w	(a1),d7		; number of bobs
	subq.w	#1,d7
lpb:
	addq.w	#1,drawnum
	move.l	a3,(a4)+	; pointer na 2D suradnice
	move.w	(a2)+,(a4)+	; cislo gule
	addq.l	#$4,a3
	dbf	d7,lpb
notvisib:
	move.l	a4,dttabptr
	rts
;---------------------------------------------------------
vector:
	bsr.w	quicksort

	move.l	dtorgptr(pc),a0
	lea	Offsets(pc),a1
	move.l	MulsPtr(pc),a6
	move.w	drawnum(pc),d7
PB_Loop:
	move.l	MasksPtr(pc),a3
	move.l	BallsPtr(pc),a4
	move.l	PlaneH(pc),a5
	move.l	(a0)+,a2
	move.w	(a0)+,d2
	lsl.w	#3,d2
	movem.w	(a1,d2.w),d0/d3/d4/d6
	lea	(a3,d0.w),a3
	lea	(a4,d0.w),a4
	movem.w	(a2),d0-d1
	asr.w	#4,d0
	asr.w	#4,d1
	sub.w	d3,d0
	sub.w	d3,d1
	move.w	d1,d3
	add.w	d3,d3
	add.w	d3,d3
	move.l	(a6,d3.w),d1
	move.w	d0,d3
	asr.w	#3,d0	;x/8
	add.l	d0,d1
	lea	(a5,d1.l),a5
	andi.w	#$f,d3
	ror.w	#4,d3
	move.w	#$FCA,d5	;#USEA!USEB!USEC!USED!LF7!LF6!LF3!LF1
	or.w	d3,d5
PB_Wait:btst	#6,$DFF002
	bne.s	PB_Wait
	move.l	a3,$DFF050
	move.l	a4,$DFF04C
	move.l	a5,$DFF048
	move.l	a5,$DFF054
	move.w	d4,$DFF062
	move.w	d4,$DFF064
	move.w	d4,$DFF060
 	move.w	d4,$DFF066
 	move.l	#$FFFF0000,$DFF044
	move.w	d5,$DFF040
	move.w	d3,$DFF042
	move.w	d6,$DFF058
	dbf	d7,PB_Loop
	move.l	chipbase(pc),a6
	rts
;---------------------------------------------------------
quicksort:
	moveq	#0,d4
	move.l	zorgptr(pc),d5
	move.l	lrtabptr(pc),a0
	move.l	dtorgptr(pc),a1		; zosortovane cisla
	move.l	d5,(a0,d4.w)
	move.l	zend(pc),a5
	move.l	a5,4(a0,d4.w)
l20:
	move.l	(a0,d4.w),d5
	move.l	4(a0,d4.w),a5
	subq.w	#8,d4
l30:
	move.l	d5,a2
	move.l	a5,a3
	move.l	a2,d1
	sub.l	zorgptr(pc),d1
	move.w	d1,d3
	asr.w	#1,d3
	add.w	d3,d1
	move.l	a3,d2
	sub.l	zorgptr(pc),d2
	move.w	d2,d3
	asr.w	#1,d3
	add.w	d3,d2
	move.l	d5,d0
	add.l	a5,d0
	asr.l	#3,d0
	asl.l	#2,d0
	move.l	d0,a6
	move.l	(a6),d3
l40:
	cmp.l	(a2),d3
	ble.s	l41
	addq.l	#4,a2
	addq.w	#6,d1	;
	bra.s	l40
l41:
	cmp.l	(a3),d3
	bge.s	l42
	subq.l	#4,a3
	subq.w	#6,d2	;
	bra.s	l41
l42:
	cmp.l	a3,a2
	bgt.s	l50
	move.l	(a3),d0
	move.l	(a2),(a3)
	move.l	d0,(a2)
	exg.l	d0,d5
	move.l	(a1,d1.w),d5
	move.w	4(a1,d1.w),d6
	move.l	(a1,d2.w),(a1,d1.w)
	move.w	4(a1,d2.w),4(a1,d1.w)
	move.l	d5,(a1,d2.w)
	move.w	d6,4(a1,d2.w)
	exg.l	d0,d5
	addq.l	#4,a2
	subq.l	#4,a3
	addq.w	#6,d1	;
	subq.w	#6,d2	;
	cmp.l	a3,a2
	ble.s	l40
l50:
	cmp.l	a5,a2
	blt.s	l52
l51:
	move.l	a3,a5
	cmp.l	a5,d5
	blt.w	l30
	tst.w	d4
	bge.w	l20
	rts
l52:
	addq.w	#8,d4
	move.l	a2,(a0,d4.w)
	move.l	a5,4(a0,d4.w)
	bra.s	l51
;---------------------------------------------------------
	include	'tbsd:trackerpackerreplayv3.1.s'
;---------------------------------------------------------
sintab	DC.W	0,$23B,$477,$6B2,$8ED,$B27,$D61,$F99
	DC.W	$11D0,$1405,$1639,$186C,$1A9C,$1CCA,$1EF7,$2120
	DC.W	$2347,$256C,$278D,$29AB,$2BC6,$2DDE,$2FF2,$3203
	DC.W	$340F,$3617,$381C,$3A1B,$3C17,$3E0D,$3FFF,$41EC
	DC.W	$43D3,$45B6,$4793,$496A,$4B3B,$4D07,$4ECD,$508C
	DC.W	$5246,$53F9,$55A5,$574B,$58E9,$5A81,$5C12,$5D9C
	DC.W	$5F1E,$6099,$620C,$6378,$64DC,$6638,$678D,$68D9
	DC.W	$6A1D,$6B58,$6C8C,$6DB6,$6ED9,$6FF2,$7103,$720B
	DC.W	$730A,$7400,$74EE,$75D2,$76AD,$777E,$7846,$7905
	DC.W	$79BB,$7A67,$7B09,$7BA2,$7C31,$7CB7,$7D32,$7DA4
	DC.W	$7E0D,$7E6B,$7EC0,$7F0A,$7F4B,$7F82,$7FAF,$7FD2
	DC.W	$7FEB,$7FFA
costab	DC.W    $7FFF,$7FFA,$7FEB,$7FD2,$7FAF,$7F82
	DC.W	$7F4B,$7F0A,$7EC0,$7E6B,$7E0D,$7DA4,$7D32,$7CB7
	DC.W	$7C31,$7BA2,$7B09,$7A67,$79BB,$7905,$7846,$777E
	DC.W	$76AD,$75D2,$74EE,$7400,$730A,$720B,$7103,$6FF2
	DC.W	$6ED9,$6DB6,$6C8B,$6B58,$6A1D,$68D9,$678D,$6638
	DC.W	$64DC,$6378,$620C,$6099,$5F1E,$5D9C,$5C12,$5A81
	DC.W	$58E9,$574B,$55A5,$53F9,$5246,$508C,$4ECD,$4D07
	DC.W	$4B3B,$496A,$4793,$45B6,$43D3,$41EC,$3FFF,$3E0D
	DC.W	$3C17,$3A1B,$381C,$3618,$340F,$3203,$2FF2,$2DDE
	DC.W	$2BC7,$29AB,$278D,$256C,$2347,$2120,$1EF7,$1CCB
	DC.W	$1A9C,$186C,$163A,$1406,$11D0,$F99,$D61,$B27
	DC.W	$8ED,$6B3,$477,$23C,0,$FDC5,$FB89,$F94E
	DC.W	$F713,$F4D9,$F2A0,$F067,$EE30,$EBFB,$E9C7,$E794
	DC.W	$E564,$E336,$E10A,$DEE0,$DCB9,$DA95,$D873,$D655
	DC.W	$D43A,$D222,$D00E,$CDFE,$CBF1,$C9E9,$C7E5,$C5E5
	DC.W	$C3EA,$C1F3,$C001,$BE14,$BC2D,$BA4B,$B86E,$B696
	DC.W	$B4C5,$B2F9,$B133,$AF74,$ADBB,$AC08,$AA5B,$A8B6
	DC.W	$A717,$A57F,$A3EE,$A264,$A0E2,$9F67,$9DF4,$9C88
	DC.W	$9B24,$99C8,$9874,$9728,$95E4,$94A8,$9375,$924A
	DC.W	$9128,$900E,$8EFD,$8DF5,$8CF6,$8C00,$8B13,$8A2E
	DC.W	$8954,$8882,$87BA,$86FB,$8645,$8599,$84F7,$845E
	DC.W	$83CF,$8349,$82CE,$825C,$81F3,$8195,$8140,$80F6
	DC.W	$80B5,$807E,$8051,$802E,$8015,$8006,$8001,$8006
	DC.W	$8015,$802E,$8051,$807E,$80B5,$80F6,$8140,$8195
	DC.W	$81F3,$825B,$82CD,$8349,$83CF,$845E,$84F7,$8599
	DC.W	$8645,$86FB,$87B9,$8882,$8953,$8A2E,$8B12,$8BFF
	DC.W	$8CF5,$8DF5,$8EFD,$900E,$9127,$9249,$9374,$94A7
	DC.W	$95E3,$9727,$9873,$99C7,$9B23,$9C87,$9DF3,$9F67
	DC.W	$A0E1,$A264,$A3ED,$A57E,$A716,$A8B5,$AA5B,$AC07
	DC.W	$ADBA,$AF73,$B133,$B2F8,$B4C4,$B696,$B86D,$BA4A
	DC.W	$BC2C,$BE14,$C000,$C1F2,$C3E9,$C5E4,$C7E4,$C9E8
	DC.W	$CBF0,$CDFD,$D00D,$D221,$D439,$D654,$D872,$DA94
	DC.W	$DCB8,$DEDF,$E109,$E335,$E563,$E794,$E9C6,$EBFA
	DC.W	$EE30,$F066,$F29F,$F4D8,$F712,$F94D,$FB88,$FDC4
sinend	DC.W	0,$23B,$477,$6B2,$8ED,$B27,$D61,$F99
	DC.W	$11D0,$1405,$1639,$186C,$1A9C,$1CCA,$1EF7,$2120
	DC.W	$2347,$256C,$278D,$29AB,$2BC6,$2DDE,$2FF2,$3203
	DC.W	$340F,$3617,$381C,$3A1B,$3C17,$3E0D,$3FFF,$41EC
	DC.W	$43D3,$45B6,$4793,$496A,$4B3B,$4D07,$4ECD,$508C
	DC.W	$5246,$53F9,$55A5,$574B,$58E9,$5A81,$5C12,$5D9C
	DC.W	$5F1E,$6099,$620C,$6378,$64DC,$6638,$678D,$68D9
	DC.W	$6A1D,$6B58,$6C8C,$6DB6,$6ED9,$6FF2,$7103,$720B
	DC.W	$730A,$7400,$74EE,$75D2,$76AD,$777E,$7846,$7905
	DC.W	$79BB,$7A67,$7B09,$7BA2,$7C31,$7CB7,$7D32,$7DA4
	DC.W	$7E0D,$7E6B,$7EC0,$7F0A,$7F4B,$7F82,$7FAF,$7FD2
	DC.W	$7FEB,$7FFA
cosend
;---------------------------------------------------------
Width:		dc.l	RESOLUTION/8
Midx:		dc.w	(RESOLUTION/2)<<4
Midy:		dc.w	(LACE/2)<<4
PicPtr:		dc.l	Pic
PlaneH:		dc.l	Screen1
PlaneS:		dc.l	Screen2
ends:		dc.w	0

addx     dc.l 0
addy     dc.l 0
addz     dc.l 0
rx       dc.w 0
ry       dc.w 0
rz       dc.w 0
         dc.w 0
pdptr    dc.l 0
atabptr  dc.l 0
zend     dc.l 0
endsc
drawnum  dc.w 0
dttabptr dc.l 0
ztabptr  dc.l 0
zorgptr  dc.l zorg
dtorgptr dc.l dtorg
lrtabptr dc.l lrtab
tmom:	 dc.l 0
ScenePtr dc.l 0
RootPtr  dc.l Root
chipbase dc.l $dff000
MulsPtr  dc.l MulsList
ColPtr:	 dc.l 0
	cnop	0,2
;=========================================================
Offsets:
R2=2560
R3=5120
;	dc.w	Offset,Shift,Modulo,BlitterSize
	dc.w	0,8,36,4098
	dc.w	2,8,36,4098
	dc.w	4,8,36,4098
	dc.w	6,8,36,4098
	dc.w	8,8,36,4098
	dc.w	10,8,36,4098
	dc.w	12,8,36,4098
	dc.w	14,8,36,4098
	dc.w	16,8,36,4098
	dc.w	18,8,36,4098
	dc.w	20,8,36,4098
	dc.w	22,8,36,4098
	dc.w	24,8,36,4098
	dc.w	26,8,36,4098
	dc.w	28,8,36,4098
	dc.w	30,8,36,4098
	dc.w	32,8,36,4098
	dc.w	34,8,36,4098
	dc.w	36,8,36,4098
	dc.w	38,8,36,4098

	dc.w	R2+0,8,36,4098
	dc.w	R2+2,8,36,4098
	dc.w	R2+4,8,36,4098
	dc.w	R2+6,8,36,4098
	dc.w	R2+8,8,36,4098
	dc.w	R2+10,8,36,4098
	dc.w	R2+12,8,36,4098
	dc.w	R2+14,8,36,4098
	dc.w	R2+16,8,36,4098
	dc.w	R2+18,8,36,4098
	dc.w	R2+20,8,36,4098
	dc.w	R2+22,8,36,4098
	dc.w	R2+24,8,36,4098
	dc.w	R2+26,8,36,4098
	dc.w	R2+28,8,36,4098
	dc.w	R2+30,8,36,4098
	dc.w	R2+32,8,36,4098
	dc.w	R2+34,8,36,4098
	dc.w	R2+36,8,36,4098
	dc.w	R2+38,8,36,4098

	dc.w	R3,16,34,8195
	dc.w	R3+4,16,34,8195
	dc.w	R3+8,16,34,8195
	dc.w	R3+12,16,34,8195
	dc.w	R3+16,16,34,8195
	dc.w	R3+20,16,34,8195
	dc.w	R3+24,16,34,8195
	dc.w	R3+28,16,34,8195
	dc.w	R3+32,16,34,8195
;=========================================================
Scene1:
	dc.w 1
	dc.l Object1
Object1:
	dc.l Body1
	dc.l Gule1
	dc.l Anim1
	dc.w 0,0,-750
	dc.w 0,0,0
	dc.w $0000,$0040,$0060,$0080,$0090,$00B0,$00F0,$0000
	dc.w $0333,$0444,$0666,$0888,$0AAA,$0CCC,$0EEE,$0FFF
Body1:
	dc.w 32
	dc.w 0,0,0
	dc.w -42,0,0
	dc.w -72,-1,0
	dc.w -97,0,0
	dc.w 4,-31,3
	dc.w 4,31,3
	dc.w -14,23,3
	dc.w -23,13,3
	dc.w -24,-17,3
	dc.w -14,-25,3
	dc.w 2,-2,-31
	dc.w 3,-2,32
	dc.w -13,-2,25
	dc.w -26,0,16
	dc.w -27,-1,-16
	dc.w -17,-1,-25
	dc.w -70,-14,-13
	dc.w -70,13,13
	dc.w -82,8,9
	dc.w -82,-9,-8
	dc.w 2,-2,-46
	dc.w 3,-3,49
	dc.w 3,-2,70
	dc.w 3,-1,-73
	dc.w -26,1,-75
	dc.w -25,1,70
	dc.w -49,1,69
	dc.w -50,1,-74
	dc.w -83,9,-8
	dc.w -83,-8,9
	dc.w -73,14,-12
	dc.w -73,-13,13
Gule1:
	dc.w 43,44,45,25,6,6,4,3
	dc.w 3,4,6,6,4,3,3,4
	dc.w 3,3,3,3,3,3,44,44
	dc.w 45,45,26,26,3,3,3,3
Anim1:
	dc.w 450, 0,0,0, 2,2,2
 	dc.w -1				;end of table
 	even
;=========================================================
Scene2:
	dc.w 1
	dc.l Object2
Object2:
	dc.l Body2
	dc.l Gule2
	dc.l Anim2
	dc.w 0,0,-1600
	dc.w 180,0,0
	dc.w $0000,$0500,$0710,$0930,$0A50,$0D90,$0FD0,$0000
	dc.w $0005,$0006,$0118,$033A,$055B,$088C,$0CCD,$0FFF
Body2:
	dc.w 48
	dc.w 0,0,0
	dc.w 15,-15,0
	dc.w 45,-45,0
	dc.w 30,-30,0
	dc.w 60,-60,0
	dc.w -15,15,0
	dc.w -30,30,0
	dc.w -45,45,0
	dc.w -60,60,0
	dc.w -75,45,0
	dc.w -90,30,0
	dc.w -105,15,0
	dc.w 75,-60,15
	dc.w 60,-45,15
	dc.w 45,-30,15
	dc.w 30,-15,15
	dc.w 15,0,15
	dc.w 0,15,15
	dc.w -15,30,15
	dc.w -30,45,15
	dc.w -45,60,15
	dc.w -60,45,15
	dc.w -75,30,15
	dc.w -90,15,15
	dc.w -75,15,30
	dc.w -60,30,30
	dc.w -45,45,30
	dc.w -30,60,30
	dc.w -15,45,30
	dc.w 0,30,30
	dc.w 15,15,30
	dc.w 30,0,30
	dc.w 45,-15,30
	dc.w 60,-30,30
	dc.w 75,-45,30
	dc.w 90,-60,30
	dc.w -60,15,45
	dc.w -45,30,45
	dc.w -30,45,45
	dc.w -15,60,45
	dc.w 0,45,45
	dc.w 15,30,45
	dc.w 30,15,45
	dc.w 45,0,45
	dc.w 60,-15,45
	dc.w 75,-30,45
	dc.w 90,-45,45
	dc.w 105,-60,45
Gule2:
	dc.w 6,6,6,6,6,6,6,6
	dc.w 6,6,6,6,6,6,6,6
	dc.w 6,6,6,6,6,6,6,6
	dc.w 26,26,26,26,26,26,26,26
	dc.w 26,26,26,26,26,26,26,26
	dc.w 26,26,26,26,26,26,26,26
Anim2:
	dc.w 110, 0,0,8, 0,0,0
	dc.w 15, 0,0,0, 0,0,0
	dc.w 450, 0,0,0, 1,-1,2
 	dc.w -1				;end of table
 	even
;=========================================================
Scene3:
	dc.w 1
	dc.l Object3
Object3:
	dc.l Body3
	dc.l Gule3
	dc.l Anim3
	dc.w 0,10,-800
	dc.w 0,0,0
	dc.w $0000,$0500,$0710,$0930,$0A50,$0D90,$0FD0,$0000
	dc.w $0005,$0006,$0118,$033A,$055B,$088C,$0CCD,$0FFF
Body3:
	dc.w 52
	dc.w 10,0,0
	dc.w 10,15,0
	dc.w 10,30,0
	dc.w 10,45,0
	dc.w -5,45,0
	dc.w -20,45,0
	dc.w -35,45,0
	dc.w -50,45,0
	dc.w -50,30,0
	dc.w -50,15,0
	dc.w -50,0,0
	dc.w 10,-15,0
	dc.w -5,-15,0
	dc.w -20,-15,0
	dc.w -35,-15,0
	dc.w -50,-15,0
	dc.w -5,30,0
	dc.w -20,30,0
	dc.w -35,30,0
	dc.w -5,15,0
	dc.w -20,15,0
	dc.w -35,15,0
	dc.w -5,0,0
	dc.w -20,0,0
	dc.w -35,0,0
	dc.w -5,45,-45
	dc.w -20,45,-45
	dc.w -35,45,-45
	dc.w -5,45,-30
	dc.w -20,45,-30
	dc.w -35,45,-30
	dc.w -5,45,-15
	dc.w -20,45,-15
	dc.w -35,45,-15
	dc.w -50,45,-15
	dc.w -50,45,-30
	dc.w -50,45,-45
	dc.w 10,45,-15
	dc.w 10,45,-45
	dc.w 10,45,-30
	dc.w -50,60,-45
	dc.w -50,75,-45
	dc.w -50,90,-45
	dc.w -50,60,0
	dc.w -50,75,0
	dc.w 10,60,0
	dc.w 10,75,0
	dc.w 10,90,0
	dc.w 10,75,-45
	dc.w 10,90,-45
	dc.w 10,60,-45
	dc.w -50,90,0
Gule3:
	dc.w 3,3,3,3,3,3,3,3
	dc.w 3,3,3,3,3,3,3,3
	dc.w 3,3,3,3,3,3,3,3
	dc.w 3,23,23,23,23,23,23,23
	dc.w 23,23,3,3,3,3,3,3
	dc.w 3,3,3,3,3,3,3,3
	dc.w 3,3,3,3
Anim3:
	dc.w 500, 0,0,0, -2,2,-1
	dc.w -1				;end of table
 	even
;=========================================================
Scene4:
	dc.w 3
	dc.l Object41
	dc.l Object42
	dc.l Object43
Object41:
	dc.l Body41
	dc.l Gule41
	dc.l Anim41
	dc.w 0,0,-1000
	dc.w 0,-90,0
Body41:
	dc.w 21
	dc.w 0,0,0
	dc.w 0,65,0
	dc.w 0,-65,0
	dc.w 0,0,-65
	dc.w 0,0,65
	dc.w 0,47,47
	dc.w 0,-48,47
	dc.w 0,-47,-47
	dc.w 0,47,-47
	dc.w 0,60,25
	dc.w 0,25,60
	dc.w 0,-25,60
	dc.w 0,-60,25
	dc.w 0,-60,-25
	dc.w 0,-25,-60
	dc.w 0,25,-60
	dc.w 0,60,-25
	dc.w 0,51,0
	dc.w 0,-49,0
	dc.w 0,2,49
	dc.w 0,2,-46
Gule41:
	dc.w 1,24,24,24,24,24,24,24
	dc.w 24,24,24,24,24,24,24,24
	dc.w 24,37,37,37,37
Anim41:
	dc.w 400, 0,0,0, 0,0,0
	dc.w 150, 0,0,0, 1,-1,2
 	dc.w -1				;end of table
;---------------------
Object42:
	dc.l Body42
	dc.l Gule42
	dc.l Anim42
	dc.w 0,0,-1000
	dc.w 0,-90,0
Body42:
	dc.w 6
	dc.w 0,10,-2
	dc.w 0,16,-2
	dc.w 0,22,-2
	dc.w 0,22,-2
	dc.w 0,28,-2
	dc.w 0,34,-2
Gule42:
	dc.w 18,18,18,18,18,18
Anim42:
	dc.w 400, 0,0,0, 0,0,-8
	dc.w 150, 0,0,0, 1,-1,2
 	dc.w -1				;end of table
;-----------------------
Object43:
	dc.l Body43
	dc.l Gule43
	dc.l Anim43
	dc.w 0,0,-1000
	dc.w 0,-90,0
	dc.w $0000,$0500,$0710,$0930,$0A50,$0D90,$0FD0,$0000
	dc.w $0005,$0006,$0118,$033A,$055B,$088C,$0CCD,$0FFF
Body43:
	dc.w 4
	dc.w 0,-2,-12
	dc.w 0,-2,-17
	dc.w 0,-2,-22
	dc.w 0,-2,-27
Gule43:
	dc.w 18,18,18,18
Anim43:
	dc.w 400, 0,0,0, 0,0,-1
	dc.w 150, 0,0,0, 1,-1,2
 	dc.w -1				;end of table
 	even
;=========================================================
Scene5:
	dc.w 1
	dc.l Object5
Object5:
	dc.l Body5
	dc.l Gule5
	dc.l Anim5
	dc.w 0,0,-1000
	dc.w 0,0,0
	dc.w $0000,$0500,$0710,$0930,$0A50,$0D90,$0FD0,$0000
	dc.w $0005,$0006,$0118,$033A,$055B,$088C,$0CCD,$0FFF
Body5:
	dc.w 50
	dc.w -52,29,0
	dc.w -36,29,0
	dc.w -20,29,0
	dc.w -4,29,0
	dc.w -52,20,11
	dc.w -36,18,11
	dc.w -20,18,11
	dc.w -4,19,11
	dc.w -52,10,22
	dc.w -36,8,22
	dc.w -20,7,22
	dc.w -4,7,22
	dc.w -52,4,38
	dc.w -36,3,38
	dc.w -20,2,38
	dc.w -3,3,38
	dc.w -30,33,33
	dc.w -30,33,63
	dc.w -29,33,88
	dc.w -29,6,57
	dc.w -95,-19,58
	dc.w -29,-16,57
	dc.w -45,-21,57
	dc.w -62,-20,57
	dc.w -79,-19,57
	dc.w -12,-23,57
	dc.w 6,-23,57
	dc.w 23,-23,57
	dc.w 35,-23,58
	dc.w -28,23,107
	dc.w -43,22,106
	dc.w -43,22,93
	dc.w -43,22,117
	dc.w -43,10,104
	dc.w -44,34,105
	dc.w -11,42,10
	dc.w -31,42,10
	dc.w -50,42,11
	dc.w -50,42,28
	dc.w -11,42,27
	dc.w -64,32,11
	dc.w -64,32,25
	dc.w -64,31,38
	dc.w -64,21,23
	dc.w -64,18,37
	dc.w 8,29,8
	dc.w 8,29,24
	dc.w 8,29,41
	dc.w 8,16,22
	dc.w 8,15,39
Gule5:
	dc.w 6,6,6,6,6,6,6,6
	dc.w 6,6,6,6,6,6,6,6
	dc.w 43,44,45,45,22,26,26,26
	dc.w 24,26,26,24,22,26,3,2
	dc.w 2,2,2,27,27,27,27,27
	dc.w 4,4,4,4,4,4,4,4
	dc.w 4,4
Anim5:
	dc.w 450, 0,0,0, 1,-1,2
 	dc.w -1				;end of table
 	even
;=========================================================
Scene6:
	dc.w 1
	dc.l Object6
Object6:
	dc.l Body6
	dc.l Gule6
	dc.l Anim6
	dc.w 0,0,-1000
	dc.w 0,0,0
	dc.w $0000,$00FF,$00EE,$00DD,$00CC,$00BB,$00AA,$00A9
	dc.w $0099,$0088,$0077,$0066,$0055,$0044,$0043,$0033
Body6:
	dc.w 7
	dc.w 0,0,0
	dc.w 40,0,0
	dc.w -40,0,0
	dc.w 0,40,0
	dc.w 0,-40,0
	dc.w 0,0,40
	dc.w 0,0,-40
Gule6:
	dc.w 48,48,48,48,48,48,48
Anim6:
	dc.w 450, 0,0,0, 1,-1,2
 	dc.w -1				;end of table
 	even
;=========================================================
Scene7:
	dc.w 1
	dc.l Object7
Object7:
	dc.l Body7
	dc.l Gule7
	dc.l Anim7
	dc.w 0,0,-1000
	dc.w 0,0,0
	dc.w $0000,$0500,$0710,$0930,$0A50,$0D90,$0FD0,$0000
	dc.w $0005,$0006,$0118,$033A,$055B,$088C,$0CCD,$0FFF
Body7:
	dc.w 79
	dc.w 59,58,0
	dc.w 45,60,0
	dc.w 30,60,0
	dc.w 15,60,0
	dc.w 0,60,0
	dc.w -15,60,0
	dc.w -15,45,0
	dc.w -15,30,0
	dc.w -15,15,0
	dc.w -15,0,0
	dc.w -15,-15,0
	dc.w 0,-15,0
	dc.w 15,-15,0
	dc.w 30,-15,0
	dc.w 45,-15,0
	dc.w 60,-15,0
	dc.w 60,0,0
	dc.w 60,15,0
	dc.w 60,30,0
	dc.w 60,45,0
	dc.w 60,60,-15
	dc.w 60,60,-30
	dc.w 60,60,-45
	dc.w 60,60,-60
	dc.w 60,60,-75
	dc.w 45,60,-75
	dc.w 30,60,-75
	dc.w 15,60,-75
	dc.w 0,60,-75
	dc.w -15,60,-75
	dc.w -15,60,-60
	dc.w -15,60,-45
	dc.w -15,60,-30
	dc.w -15,60,-15
	dc.w -15,45,-75
	dc.w -15,30,-75
	dc.w -15,15,-75
	dc.w -15,0,-75
	dc.w -15,-15,-75
	dc.w -15,-15,-60
	dc.w -15,-15,-45
	dc.w -15,-15,-30
	dc.w -15,-15,-15
	dc.w 0,-15,-75
	dc.w 15,-15,-75
	dc.w 30,-15,-75
	dc.w 45,-15,-75
	dc.w 60,-15,-75
	dc.w 60,0,-75
	dc.w 60,15,-75
	dc.w 60,30,-75
	dc.w 60,45,-75
	dc.w 60,-15,-60
	dc.w 60,-15,-45
	dc.w 60,-15,-30
	dc.w 60,-15,-15
	dc.w 60,20,-60
	dc.w 60,45,-15
	dc.w 60,45,-60
	dc.w 60,20,-15
	dc.w 60,0,-60
	dc.w 60,0,-15
	dc.w -15,20,-40
	dc.w 25,20,-75
	dc.w 45,0,-75
	dc.w 0,0,-75
	dc.w 45,45,-75
	dc.w 0,45,0
	dc.w 0,45,-75
	dc.w 45,0,0
	dc.w 45,60,-15
	dc.w 25,60,-40
	dc.w 0,60,-60
	dc.w 0,-15,-60
	dc.w 45,-15,-60
	dc.w 0,-15,-15
	dc.w 45,-15,-15
	dc.w 0,-15,-60
	dc.w 45,-15,-59
Gule7:
	dc.w 22,22,22,22,22,22,22,22
	dc.w 22,22,22,22,22,22,22,22
	dc.w 22,22,22,22,22,22,22,22
	dc.w 22,22,22,22,22,22,22,22
	dc.w 22,22,22,22,22,22,22,22
	dc.w 22,22,22,22,22,22,22,22
	dc.w 22,22,22,22,22,22,22,22
	dc.w 3,3,3,3,3,3,3,3
	dc.w 3,3,3,3,3,3,3,3
	dc.w 3,3,3,3,3,3,3
Anim7:
	dc.w 450, 0,0,0, 1,-1,2
 	dc.w -1				;end of table
 	even
;=========================================================
Scene8:
	dc.w 1
	dc.l Object8
Object8:
	dc.l Body8
	dc.l Gule8
	dc.l Anim8
	dc.w 0,0,-1000
	dc.w 0,0,0
	dc.w $0000,$0040,$0060,$0080,$0090,$00B0,$00F0,$0CCC
	dc.w $0333,$0444,$0666,$0888,$0AAA,$0CCC,$0EEE,$0FFF
Body8:
	dc.w 49
	dc.w 10,0,0
	dc.w -20,0,0
	dc.w -40,0,0
	dc.w 40,0,0
	dc.w 60,0,0
	dc.w 80,0,0
	dc.w -60,0,0
	dc.w -60,20,0
	dc.w -60,0,-20
	dc.w -60,0,20
	dc.w -60,-20,0
	dc.w -60,-20,20
	dc.w -60,-40,20
	dc.w -60,-60,20
	dc.w -60,-60,0
	dc.w -60,-40,0
	dc.w -60,-60,-20
	dc.w -60,-40,-20
	dc.w -60,-20,-20
	dc.w -60,20,-20
	dc.w -60,20,20
	dc.w -60,40,20
	dc.w -60,40,0
	dc.w -60,40,-20
	dc.w -60,60,20
	dc.w -60,60,0
	dc.w -60,60,-20
	dc.w 80,60,-20
	dc.w 80,60,0
	dc.w 80,60,20
	dc.w 80,40,-20
	dc.w 80,40,0
	dc.w 80,40,20
	dc.w 80,20,-20
	dc.w 80,20,0
	dc.w 80,20,20
	dc.w 80,0,-20
	dc.w 80,0,20
	dc.w 80,-20,0
	dc.w 80,-20,20
	dc.w 80,-40,-20
	dc.w 80,-40,0
	dc.w 80,-60,-20
	dc.w 80,-60,0
	dc.w 80,-60,20
	dc.w 80,-20,-20
	dc.w 80,-40,20
	dc.w 20,-20,0
	dc.w 0,-20,0
Gule8:
	dc.w 43,6,6,6,6,6,6,6
	dc.w 6,6,6,6,6,6,6,6
	dc.w 6,6,6,6,6,6,6,6
	dc.w 6,6,6,6,6,6,6,6
	dc.w 6,6,6,6,6,6,6,6
	dc.w 6,6,6,6,6,6,6,19
	dc.w 19
Anim8:
	dc.w 450, 0,0,0, 1,-1,2
 	dc.w -1				;end of table
 	even
;=========================================================
Scene9:
	dc.w 1
	dc.l Object9
Object9:
	dc.l Body9
	dc.l Gule9
	dc.l Anim9
	dc.w 0,0,-1000
	dc.w 0,0,0
	dc.w $0000,$0300,$0500,$0722,$0955,$0A99,$0DBB,$0000
	dc.w $0333,$0444,$0666,$0888,$0AAA,$0CCC,$0EEE,$0FFF
Body9:
	dc.w 55
	dc.w 100,120,0
	dc.w 100,80,0
	dc.w 100,40,0
	dc.w 100,0,0
	dc.w 100,-40,0
	dc.w 60,-40,0
	dc.w 60,0,0
	dc.w 60,40,0
	dc.w 60,80,0
	dc.w 60,120,0
	dc.w 20,120,0
	dc.w 20,80,0
	dc.w 20,40,0
	dc.w 20,0,0
	dc.w 20,-40,0
	dc.w -20,120,0
	dc.w -20,80,0
	dc.w -20,40,0
	dc.w -20,0,0
	dc.w -20,-40,0
	dc.w -60,-40,0
	dc.w -60,0,0
	dc.w -60,40,0
	dc.w -60,80,0
	dc.w -60,120,0
	dc.w 80,100,20
	dc.w 80,60,20
	dc.w 80,20,20
	dc.w 80,-20,20
	dc.w 40,-20,20
	dc.w 40,20,20
	dc.w 40,60,20
	dc.w 40,100,20
	dc.w 0,100,20
	dc.w 0,60,20
	dc.w 0,20,20
	dc.w 0,-20,20
	dc.w -40,-20,20
	dc.w -40,20,20
	dc.w -40,60,20
	dc.w -40,100,20
	dc.w 60,80,40
	dc.w 60,40,40
	dc.w 60,0,40
	dc.w 20,0,40
	dc.w 20,40,40
	dc.w 20,80,40
	dc.w -20,80,40
	dc.w -20,40,40
	dc.w -20,0,40
	dc.w 40,60,60
	dc.w 40,20,60
	dc.w 0,20,60
	dc.w 0,60,60
	dc.w 20,40,80
Gule9:
	dc.w 46,46,46,46,46,46,46,46
	dc.w 46,46,46,46,46,46,46,46
	dc.w 46,46,46,46,46,46,46,46
	dc.w 46,46,46,46,46,46,46,46
	dc.w 46,46,46,46,46,46,46,46
	dc.w 46,46,46,46,46,46,46,46
	dc.w 46,46,46,46,46,46,46
Anim9:
	dc.w 450, 0,0,0, 1,-1,2
 	dc.w -1				;end of table
 	even
;=========================================================
Scene10:
	dc.w 1
	dc.l Object10
Object10:
	dc.l Body10
	dc.l Gule10
	dc.l Anim10
	dc.w 0,0,-1000
	dc.w 0,0,0
	dc.w $0000,$0500,$0710,$0930,$0A50,$0D90,$0FD0,$0000
	dc.w $0005,$0006,$0118,$033A,$055B,$088C,$0CCD,$0FFF
Body10:
	dc.w 78
	dc.w -10,20,0
	dc.w -10,85,0
	dc.w -10,-45,0
	dc.w -10,20,-65
	dc.w -10,20,65
	dc.w -10,65,45
	dc.w -10,-25,45
	dc.w -10,-25,-45
	dc.w -10,65,-45
	dc.w -10,80,25
	dc.w -10,45,59
	dc.w -10,-5,59
	dc.w -10,-40,25
	dc.w -10,-40,-25
	dc.w -10,-5,-59
	dc.w -10,45,-59
	dc.w -10,80,-25
	dc.w -26,70,10
	dc.w -26,70,-10
	dc.w -26,-30,-10
	dc.w -26,-30,10
	dc.w -26,10,50
	dc.w -26,30,50
	dc.w -26,30,-50
	dc.w -26,10,-50
	dc.w -26,-8,-42
	dc.w -26,-8,42
	dc.w -26,48,42
	dc.w -26,48,-42
	dc.w -26,62,-28
	dc.w -26,62,28
	dc.w -26,-22,28
	dc.w -26,-22,-28
	dc.w -39,55,-1
	dc.w -39,-14,-1
	dc.w -39,20,35
	dc.w -39,20,-35
	dc.w -39,-5,-25
	dc.w -39,-5,25
	dc.w -39,45,25
	dc.w -39,45,-25
	dc.w -39,12,-20
	dc.w -39,12,20
	dc.w -39,30,20
	dc.w -39,30,-20
	dc.w -39,38,0
	dc.w -39,2,0
	dc.w -49,21,1
	dc.w 6,83,-2
	dc.w 6,-43,-2
	dc.w 6,20,-65
	dc.w 6,20,65
	dc.w 14,65,-2
	dc.w 14,-25,-2
	dc.w 14,20,-45
	dc.w 14,20,45
	dc.w 23,45,-2
	dc.w 23,-5,-2
	dc.w 23,20,-25
	dc.w 23,20,25
	dc.w 32,30,-2
	dc.w 32,10,-3
	dc.w 32,20,-12
	dc.w 32,20,11
	dc.w 32,21,2
	dc.w 149,22,2
	dc.w -64,20,2
	dc.w -64,8,2
	dc.w -64,-5,2
	dc.w -64,-18,2
	dc.w -64,-30,2
	dc.w -64,-43,2
	dc.w -64,-56,-1
	dc.w -64,-68,0
	dc.w -64,-68,14
	dc.w -64,-69,-13
	dc.w -64,-69,-26
	dc.w -64,-68,26
Gule10:
	dc.w 0,24,24,24,24,24,24,24
	dc.w 24,24,24,24,24,24,24,24
	dc.w 24,24,24,24,24,24,24,24
	dc.w 24,24,24,24,24,24,24,24
	dc.w 24,24,24,24,24,24,24,24
	dc.w 24,24,24,24,24,24,24,24
	dc.w 1,1,1,1,1,1,1,1
	dc.w 1,1,1,1,1,1,1,1
	dc.w 4,46,3,3,3,3,3,3
	dc.w 3,3,3,3,3,3
Anim10:
	dc.w 450, 0,0,0, 1,-1,2
 	dc.w -1				;end of table
 	even
;=========================================================
Scene11:
	dc.w	1
	dc.l	Object11
Object11:
	dc.l	Body11
	dc.l	Gule11
	dc.l	Anim11
	dc.w	0,0,-11000
	dc.w	0,180,0
	dc.w	$0000,$0500,$0710,$0930,$0A50,$0D90,$0FD0,$0000
	dc.w	$0005,$0006,$0118,$033A,$055B,$088C,$0CCD,$0FFF
Body11:
	dc.w 105
	dc.w 200,30,0
	dc.w 210,30,0
	dc.w 220,30,0
	dc.w 230,30,0
	dc.w 230,20,0
	dc.w 230,10,0
	dc.w 230,0,0
	dc.w 230,-10,0
	dc.w 230,-20,0
	dc.w 230,-30,0
	dc.w 220,-30,0
	dc.w 210,-30,0
	dc.w 200,-30,0
	dc.w 190,-20,0
	dc.w 190,-10,0
	dc.w 200,0,0
	dc.w 190,10,0
	dc.w 190,20,0
	dc.w 170,30,0
	dc.w 170,20,0
	dc.w 170,10,0
	dc.w 170,0,0
	dc.w 170,-10,0
	dc.w 170,-20,0
	dc.w 160,-30,0
	dc.w 150,-30,0
	dc.w 140,-30,0
	dc.w 130,-20,0
	dc.w 130,-10,0
	dc.w 130,0,0
	dc.w 130,10,0
	dc.w 130,20,0
	dc.w 130,30,0
	dc.w 110,30,0
	dc.w 110,20,0
	dc.w 110,10,0
	dc.w 110,0,0
	dc.w 110,-10,0
	dc.w 110,-20,0
	dc.w 110,-30,0
	dc.w 100,-30,0
	dc.w 90,-30,0
	dc.w 80,-30,0
	dc.w 70,-30,0
	dc.w 50,30,0
	dc.w 50,20,0
	dc.w 50,10,0
	dc.w 50,0,0
	dc.w 50,-10,0
	dc.w 50,-20,0
	dc.w 50,-30,0
	dc.w 40,-30,0
	dc.w 30,-30,0
	dc.w 20,-30,0
	dc.w 10,-30,0
	dc.w -10,20,0
	dc.w -10,10,0
	dc.w -20,30,0
	dc.w -30,30,0
	dc.w -40,30,0
	dc.w -50,20,0
	dc.w -20,0,0
	dc.w -30,0,0
	dc.w -40,0,0
	dc.w -50,-10,0
	dc.w -50,-20,0
	dc.w -40,-30,0
	dc.w -30,-30,0
	dc.w -20,-30,0
	dc.w -10,-20,0
	dc.w -70,30,0
	dc.w -70,20,0
	dc.w -70,10,0
	dc.w -70,0,0
	dc.w -70,-10,0
	dc.w -70,-20,0
	dc.w -70,-30,0
	dc.w -80,0,0
	dc.w -90,0,0
	dc.w -100,0,0
	dc.w -110,30,0
	dc.w -110,20,0
	dc.w -110,10,0
	dc.w -110,0,0
	dc.w -110,-10,0
	dc.w -110,-20,0
	dc.w -110,-30,0
	dc.w -130,30,0
	dc.w -130,20,0
	dc.w -130,10,0
	dc.w -130,0,0
	dc.w -130,-10,0
	dc.w -130,-20,0
	dc.w -130,-30,0
	dc.w -150,30,0
	dc.w -160,30,0
	dc.w -170,30,0
	dc.w -180,30,0
	dc.w -190,30,0
	dc.w -170,20,0
	dc.w -170,10,0
	dc.w -170,0,0
	dc.w -170,-10,0
	dc.w -170,-20,0
	dc.w -170,-30,0
Gule11:
	dc.w 18,18,18,18,18,18,18,18
	dc.w 18,18,18,18,18,18,18,18
	dc.w 18,18,18,18,18,18,18,18
	dc.w 18,18,18,18,18,18,18,18
	dc.w 18,18,18,18,18,18,18,18
	dc.w 18,18,18,18,18,18,18,18
	dc.w 18,18,18,18,18,18,18,38
	dc.w 38,38,38,38,38,38,38,38
	dc.w 38,38,38,38,38,38,38,38
	dc.w 38,38,38,38,38,38,38,38
	dc.w 38,38,38,38,38,38,38,38
	dc.w 38,38,38,38,38,38,38,38
	dc.w 38,38,38,38,38,38,38,38
	dc.w 38

Anim11:
	dc.w 202, 0,0,50, 0,0,0
	dc.w 100, 0,0,0, 0,0,0
	dc.w 300, 0,0,0, 0,2,0
	dc.w 300, 0,0,-5, -1,2,1
 	dc.w -1				;end of table
;=========================================================
Root:	dc.l	Coords2DP1
	dc.l	0
	dc.w	0
	dc.w	0
	dc.l	Coords2DP2
	dc.l	0
	dc.w	0
	dc.w	0
	dc.l	Coords2DP3
	dc.l	0
	dc.w	0
	dc.w	0
Coords2DP1:
	dcb.b	MAXPOINTS1*4,0
Coords2DP2:
	dcb.b	MAXPOINTS2*4,0
Coords2DP3:
	dcb.b	MAXPOINTS3*4,0
MulsList:
	dcb.l	LACE,0
Sprite1:
	dc.w	$0,$0
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0400,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
spr1	dcb.w	20*10,0
	dc.l	0
Sprite2:
	dc.w	$0,$0
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0100
	dc.w	$0000,$0000
	dc.w	$0000,$0000
spr2	dcb.w	20*10,0
	dc.l	0
Sprite3:
	dc.w	$0,$0
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0800,$0800
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
spr3	dcb.w	20*10,0
	dc.l	0
SpriteFalse:
	dc.l	0
SpritesPtr:
	dc.l	Sprite1,Sprite2,Sprite3,SpriteFalse
SpritesPos:
	dc.w	$30e1,$40a0,$5030,$60f0,$7060,$803a,$90d3,$a015
	dc.w	$b0b0,$c075,$d0cd
	dc.w	$3572,$4533,$55c0,$6505,$7567,$85b3,$95fd,$a592
	dc.w	$b526,$c588,$d5bb
	dc.w	$3225,$42fa,$5264,$62a6,$7248,$82bd,$9219,$a2a1
	dc.w	$b23a,$c2cc,$d255

BallsPtr:	dc.l	Balls
MasksPtr:	dc.l	Masks

	even
;---------------------------------------------------------
CopperList:
	dc.w	$0120,$0000,$0122,$0000
	dc.w	$0124,$0000,$0126,$0000
	dc.w	$0128,$0000,$012A,$0000
	dc.w	$012C,$0000,$012E,$0000
	dc.w	$0130,$0000,$0132,$0000
	dc.w	$0134,$0000,$0136,$0000
	dc.w	$0138,$0000,$013A,$0000
	dc.w	$013C,$0000,$013E,$0000
	dc.w	$008E,$2C81,$0090,$2CC1
	dc.w	$0092,$0038,$0094,$00D0
	dc.w	$01A0,$0000,$01A2,$0eee,$01A4,$0888,$01A6,$0555  ;spr0&1
	dc.w	$01A8,$0000,$01AA,$0eee,$01AC,$0888,$01AE,$0555  ;spr2&3
	dc.w	$0180,$00f0,$0182,$0000
BMaps:	dc.w	$00E0,$0000,$00E2,$0000
	dc.w	$0100,$1200,$0102,$0000,$0104,$0000
	dc.w	$0108,$0000,$010A,$0000
	dc.w	$0180,$0f00
	dc.w	$2c01,$fffe,$0096,$8100
Top:	dcb.w	16*2*2+16*2,0
	dc.w	$3c01,$fffe,$0096,$0100
CopCol:	dc.w	$0180,$0000,$0182,$0000,$0184,$0000,$0186,$0000  ;plf1
	dc.w	$0188,$0000,$018A,$0000,$018C,$0000,$018E,$0000
	dc.w	$0190,$0000,$0192,$0000,$0194,$0000,$0196,$0000
	dc.w	$0198,$0000,$019A,$0000,$019C,$0000,$019E,$0000
BitMaps:
	dc.w	$00E0,$0000,$00E2,$0000
	dc.w	$00E4,$0000,$00E6,$0000
	dc.w	$00E8,$0000,$00EA,$0000
	dc.w	$00EC,$0000,$00EE,$0000
	dc.w	$0100,$4200,$0102,$0000,$0104,$0000
	dc.w	$0108,$0078,$010A,$0078
	dc.w	$3d01,$fffe,$0096,$8100
	dc.w	$e001,$fffe
	dc.w	$009c,$8004
Mirror:	dcb.w	11*2*2,0
	dc.w	$ffdf,$fffe
	dc.w	$0108,-520,$010A,-520
	dcb.w	48*2*2,0
	dc.w	$ffff,$fffe
;---------------------------------
MirrorTab:	dcb.b	118,0
Balls:		dcb.b	10240,0
Masks:		dcb.b	10240,0
Pic:		dcb.b	40*16,0
		even

Screen1:	dcb.b	40*256*4,0
Screen2:	dcb.b	40*256*4,0
module:		dcb.b	8062,0

	cnop	0,4
zorg:	dcb.l	105,0		; sum of areas
lrtab:	dcb.l	105,0		; sum of areas
dtorg:	dcb.b	105*14,0		; sum of areas * 14
