  9                                    ;=============================================
;=== Bull Shit Mega Demo - Bitmap Rot Part ===
;=== Demo by Vlastimil Knotek in 1998	   ===
;=============================================
SideSize_1	=	48
SideSize_2	=	40
SideSize_3	=	32
;-----------------------------------
>EXTERN 'tbsd:bitmaprot/Amiga.raw',AmigaPic
>EXTERN 'tbsd:bitmaprot/TopTxt.BLT',TopText
>EXTERN 'tbsd:bitmaprot/BTxt.BLT',BottomText
>EXTERN 'tbsd:bitmaprot/Face.RGB',FacePic
>EXTERN 'tbsd:bitmaprot/TheBullShit.blt',LogoPic
>EXTERN	'tbsd:bitmaprot/BRMask.blt',Mask
>EXTERN	'tbsd:bitmaprot/Font.3pl.BLT',Font
;-----------------------------------
Start:
	movem.l	d0-d7/a0-a6,-(a7)
	bsr	SaveAll
	bsr	InitAll
	bsr	MakeMulsLists
	lea	$dff000,a6
	bsr	StartCopper_1
	bsr	MainLoop_1
	bsr	StartCopper_2
	bsr	MainLoop_2
	bsr	StartCopper_3
	move.w	#1,ScrollEnable
	bsr	MainLoop_3
	bsr	RestoreAll
	movem.l	(a7)+,d0-d7/a0-a6
	rts
;--------------------------------------------------------< SaveAll Begin >-----
SaveAll:
;	move.l	$4.w,a6
;	lea.l	GfxName(pc),a1
;	moveq	#0,D0
;	jsr	-408(a6)	;OldOpenLibrary
;	move.l	d0,a1
	lea	OldCopper1(pc),a0
;	move.l	$26(a1),(a0)
	move.l	$100,(a0)
	lea	OldCopper2(pc),a0
;	move.l	$32(a1),(a0)
	move.l	$104,(a0)
;	jsr	-414(a6)	;CloseLibrary

	move.l	chipbase(pc),a6
	lea	OldDMACON(pc),a0
	move.w	$002(a6),(a0)+
	move.w	$01c(a6),(a0)+
	move.l	$64.w,(a0)+
	move.l	$6c.w,(a0)
	rts
;---------------------------------------------------------< SaveAll End >-----

;-------------------------------------------------------< InitAll Begin >-----
InitAll:
	move.l	#ScrollMap,d0
	moveq.l	#2,d7
	lea	ScrollMaps+$2,a0
InitScroll:	
	move.w	d0,$4(a0)
	swap	d0
	move.w	d0,(a0)
	swap	d0
	addq.l	#$8,a0
	addi.l	#42,d0
	dbra	d7,InitScroll

	lea	TopTextCopper+$2(pc),a0
	move.l	TopTextPtr(pc),d0
	moveq	#2,d1
set_t:	swap	d0
	move.w	d0,(a0)
	swap	d0
	move.w	d0,4(a0)
	addi.l	#40,d0
	addq.w	#$8,a0
	dbf	d1,set_t

	lea	BottomTextCopper+$2(pc),a0
	move.l	BottomTextPtr(pc),d0
	moveq	#2,d1
set_b:
	swap	d0
	move.w	d0,(a0)
	swap	d0
	move.w	d0,4(a0)
	addi.l	#40,d0
	addq.w	#$8,a0
	dbf	d1,set_b

	move.l	PlaneH(pc),a5
	move.l	#(40*100*3)/2/4-1,d0
	moveq	#0,d1
clr1	move.w	d1,(a5)+
	move.w	d1,(a5)+
	move.w	d1,(a5)+
	move.w	d1,(a5)+
	dbf	d0,clr1

	move.l	PlaneS(pc),a5
	move.l	#(40*100*3)/2/4-1,d0
	moveq	#0,d1
clr2	move.w	d1,(a5)+
	move.w	d1,(a5)+
	move.w	d1,(a5)+
	move.w	d1,(a5)+
	dbf	d0,clr2

	move.l	Screen_2(pc),a0
	move.w	#200-1,d3
	move.w	#$303f,d0
	moveq	#2,d4
PutWait:
	move.w	d0,(a0)+
	move.w	#$fffe,(a0)+
	moveq	#41-1,d1
FillBack:
	move.w	#$0180,(a0)+
	move.w	#$0000,(a0)+
	dbra	d1,FillBack
	addi.w	#$0100,d0
	add.w	d4,d0
	neg.w	d4
	dbf	d3,PutWait
	addi.w	#$0100,d0
	move.b	#$07,d0
	move.w	d0,(a0)+
	move.w	#$fffe,(a0)+
	move.l	#$0180000f,(a0)+
	addi.w	#$0100,d0
	move.b	#$01,d0
	move.w	d0,(a0)+
	move.w	#$fffe,(a0)+
	move.l	#$01800000,(a0)+

	lea	CopLogoPic+$2,a0
	move.l	#LogoPic,d0
	moveq	#4-1,d1
IA_loop1:
	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
	swap	d0
	addi.l	#40,d0
	addq.w	#$8,a0
	dbf	d1,IA_loop1

	lea	CopMask+$2,a0
	move.l	#Mask,d0
	moveq	#4-1,d1
IA_loop2:
	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
	swap	d0
	addi.l	#40,d0
	addq.w	#$8,a0
	dbf	d1,IA_loop2

	lea	CopScr_3,a0
	move.w	#120-1,d3
	move.l	#$6971fffe,d0
loop2:
	move.l	#$01820001,(a0)+
	move.l	#$01840002,(a0)+
	move.l	#$01860003,(a0)+
	move.l	#$01880004,(a0)+
	move.l	#$018A0005,(a0)+
	move.l	#$018C0006,(a0)+
	move.l	#$018E0007,(a0)+
	move.l	#$01900008,(a0)+
	move.l	#$01920009,(a0)+
	move.l	#$0194000a,(a0)+
	move.l	#$0196000b,(a0)+
	move.l	#$0198000c,(a0)+
	move.l	#$019A000d,(a0)+
	move.l	#$019C000e,(a0)+
	move.l	#$019E000f,(a0)+
	move.l	d0,(a0)+
	moveq	#16-1,d4
loop3:	move.l	#$01800000,(a0)+
	dbf	d4,loop3
	addi.l	#$01000000,d0
	dbf	d3,loop2

	move.l	#module,tp_data
	bsr	tp_init
	lea	$dff000,a6
	rts
;-------------------------------------------------------< InitAll End >-----

;-----------------------------------------------< MakeMulsLists Begin >-----
MakeMulsLists:
	move.l	MulsPtr_1(pc),a0
	moveq	#0,d0
	move.l	#110-1,d1
mmloop_1:
	move.w	d0,(a0)+
	addi.w	#40,d0
	dbf	d1,mmloop_1

	move.l	MulsPtr_2(pc),a0
	moveq	#0,d0
	move.l	#256-1,d1
mmloop_2:
	move.l	d0,(a0)+
	add.l	#144*2,d0
	dbf	d1,mmloop_2
	rts
;---------------------------------------------------< MakeMulsLists End >-----

;---------------------------------------------------< StartCopper Begin >-----
StartCopper_1:
	cmpi.b	#-1,$6(a6)
	bne.s	StartCopper_1
	move.w	#$24,$09a(a6)
sc1wb:	btst	#6,$2(a6)
	bne.s	sc1wb
	move.w	#$40,$096(a6)
sc1wvb:	cmpi.b	#-1,$6(a6)
	bne.s	sc1wvb
	move.w	#$7fff,$96(a6)
	move.w	#$3fff,$9a(a6)
	lea	CopperList_1(pc),a0
	move.l	a0,$80(a6)
	tst.w	$88(a6)
	move.w	#$82c0,$96(a6)
	move.l	#NewSI,$64.w
	move.l	#NewVB,$6c.w
	move.w	#$c024,$9a(a6)
	rts

StartCopper_2:
	btst	#6,$2(a6)
	bne.s	StartCopper_2
	move.w	#$7fb0,$96(a6)
	lea	CopperList_2(pc),a0
	move.l	a0,$80(a6)
	tst.w	$88(a6)
	move.w	#$8280,$96(a6)
	rts

StartCopper_3:
	btst	#6,$2(a6)
	bne.s	StartCopper_3
	move.w	#$7fb0,$96(a6)
	lea	CopperList_3,a0
	move.l	a0,$80(a6)
	tst.w	$88(a6)
	move.w	#$83c0,$96(a6)
	rts
;------------------------------------------------------< StartCopper End >-----

;------------------------------------------------------< Main Loop Begin >-----
MainLoop_1:
	lea	$dff000,a6
	cmp.b	#-1,$6(a6)
	bne.s	MainLoop_1

	bsr	DoubleBuffer_1
	bsr	Movement_1
	bsr	Transform_1
	bsr	MakeSquare_1

wblit:	btst	#6,$dff002
	bne.s	wblit

	bsr	PlotPoints_1
	tst.w	Count_1
	beq.s	NoFaders_1
	lea	Count_1(pc),a0
	subq.w	#1,(a0)

	moveq	#4,d1
	lea	TColours_1+$2,a0
	lea	TextColours_1(pc),a1
	moveq	#8-1,d7
	bsr	FadeFromBlack_1

	moveq	#4,d1
	lea	BColours_1+$2,a0
	lea	TextColours_1(pc),a1
	moveq	#8-1,d7
	bsr	FadeFromBlack_1

NoFaders_1:
	lea	Count_11(pc),a0
	tst.w	(a0)
	beq.s	Exit_1
	subq.w	#1,(a0)
	bra.s	MainLoop_1
Exit_1:
	moveq	#15,d5
fadeout_loop_1:
	moveq	#4,d1
	lea	TColours_1+$2,a0
	moveq	#8-1,d7
	bsr	FadeToBlack_1

	moveq	#4,d1
	lea	BColours_1+$2,a0
	moveq	#8-1,d7
	bsr	FadeToBlack_1

	moveq	#4,d1
	lea	PicCol_1+$2,a0
	moveq	#8-1,d7
	bsr	FadeToBlack_1

	moveq	#4,d1
	lea	CL1_1+$2,a0
	moveq	#1-1,d7
	bsr	FadeToBlack_1

	moveq	#4,d1
	lea	CA_1+$2,a0
	moveq	#1-1,d7
	bsr	FadeToBlack_1

	moveq	#4,d1
	lea	CL2_1+$2,a0
	moveq	#1-1,d7
	bsr	FadeToBlack_1

	move.w	#$5000,d4
fowait_loop_1:
	nop
	dbf	d4,fowait_loop_1
	dbf	d5,fadeout_loop_1
	rts

Count_1:	dc.w	15
Count_11:	dc.w	240


MainLoop_2:
	cmp.b	#-1,$6(a6)
	bne.s	MainLoop_2

	bsr	Movement_2
	bsr	Transform_2
	bsr	MakeSquare_2

;wblit_2	btst	#6,$dff002
;	bne.s	wblit_2

	bsr	DrawChunky_2

	lea	Count_2(pc),a0
	tst.w	(a0)
	beq	Exit_2
	subq.w	#1,(a0)
	bra.s	MainLoop_2
Exit_2:	rts

Count_2:	dc.w	250

MainLoop_3:
	cmp.b	#-1,$6(a6)
	bne.s	MainLoop_3

	bsr	Zoomer_3
	bsr	Transform_3
	bsr	MakeSquare_3

	bsr	DrawChunky_3

	lea	Count_3(pc),a0
	tst.w	(a0)
	beq	Exit_3
	subq.w	#1,(a0)
	bra.s	MainLoop_3
Exit_3:	rts

Count_3:	dc.w	450
;--------------------------------------------------------< MainLoop End >-----

;----------------------------------------------------< RestoreAll Begin >-----
RestoreAll:
	bsr	tp_end
	move.l	chipbase(pc),a6
ra_wvb:	cmpi.b	#-1,$6(a6)
	bne.s	ra_wvb
	move.w	#$7FFF,$09a(a6)
ra_wb:	btst	#6,$2(a6)
	bne.s	ra_wb
	move.w	#$7fff,$096(a6)

	move.l	OldSIVect(pc),$64.w
	move.l	OldVB(pc),$6c.w
	move.l	OldCopper1(pc),$080(a6)
;	move.l	$100,$080(a6)
	tst.w	$88(a6)
	move.l	OldCopper2(pc),$084(a6)
;	move.l	$104,$084(a6)
	tst.w	$8a(a6)
	move.w	OldDMACON(pc),d0
	or.w	#$8000,d0
	move.w	OldINTENA(pc),d1
	or.w	#$8000,d1
	move.w	d0,$096(a6)
	move.w	d1,$09a(a6)
	rts
;------------------------------------------------------< RestoreAll End >-----
NewVB:	movem.l	d0-d7/a0-a6,-(sp)
	bsr	tp_play
	movem.l	(sp)+,d0-d7/a0-a6
	move.w	#$20,$dff09c
	rte

NewSI:	movem.l	d0-d7/a0-a6,-(sp)
	tst.w	ScrollEnable
	beq	NoScroll
	bsr	ScrollText
NoScroll:
	movem.l	(sp)+,d0-d7/a0-a6
	move.w	#$4,$dff09c
	rte

ScrollEnable:	dc.w	0
;=========================================================
GfxName:	DC.B	'graphics.library',0
		even
OldCopper1:	DC.L	0
OldCopper2:	DC.L	0
OldDMACON:	DC.W	0
OldINTENA:	DC.W	0
OldSIVect:	DC.L	0
OldVB:		dc.l	0
;=========================================================

DoubleBuffer_1:
	lea	PlaneH(pc),a0
	move.l	(a0),d0
	move.l	4(a0),(a0)
	move.l	d0,4(a0)
	lea	BitMaps_1+$2(pc),a0
	moveq	#3-1,d1
.clp:	swap	d0
	move.w	d0,(a0)
	swap	d0
	move.w	d0,4(a0)
	addi.w	#40*100,d0
	addq.w	#8,a0
	dbf	d1,.clp

	move.l	chipbase(pc),a6

.w1	btst	#6,$dff002
	bne.s	.w1
         
	moveq	#-1,d0
	move.l	d0,$44(a6)
	move.l	#$1000000,$40(a6)
	move.l	PlaneH(pc),$54(a6)
	clr.w	$66(a6)
	move.w	#100*3*64+20,$58(a6)
	rts
;---------------------------------------------------------
Movement_1:
	lea	AddTableXPtr_1(pc),a0
	move.l	(a0),a1
	move.w	(a1)+,d0
	cmp.w	#'x',d0
	bne.s	NoNewX_1
	lea	AddTableX_1(pc),a1
	move.w	(a1)+,d0
NoNewX_1:
	move.l	a1,(a0)
	move.w	d0,AddPicX_1

	lea	AddTableYPtr_1(pc),a0
	move.l	(a0),a1
	move.w	(a1)+,d0
	cmp.w	#'x',d0
	bne.s	NoNewY_1
	lea	AddTableY_1(pc),a1
	move.w	(a1)+,d0
NoNewY_1:
	move.l	a1,(a0)
	move.w	d0,AddPicY_1
	rts

Movement_2:
	lea	AddTableXPtr_2(pc),a0
	move.l	(a0),a1
	move.w	(a1)+,d0
	cmp.w	#'x',d0
	bne.s	NoNewX_2
	lea	AddTableX_2(pc),a1
	move.w	(a1)+,d0
NoNewX_2:	move.l	a1,(a0)
	lea	AddPicX_2(pc),a0
	move.w	d0,(a0)

	lea	AddTableYPtr_2(pc),a0
	move.l	(a0),a1
	move.w	(a1)+,d0
	cmp.w	#'x',d0
	bne.s	NoNewY_2
	lea	AddTableY_2(pc),a1
	move.w	(a1)+,d0
NoNewY_2:	move.l	a1,(a0)
	lea	AddPicY_2(pc),a0
	move.w	d0,(a0)
	rts

Zoomer_3:
	lea	AddTableZPtr_3(pc),a0
	move.l	(a0),a1
	move.w	(a1)+,d0
	cmp.w	#'x',d0
	bne.s	NoNewZ_3
	lea	AddTableZ_3(pc),a1
	move.w	(a1)+,d0
NoNewZ_3:	move.l	a1,(a0)
	lea	Zoom1_3(pc),a0
	move.w	d0,(a0)
	rts

;---------------------------------------------------------
Transform_1:
	move.l	CoordsPtr_1(pc),a2
	move.l	NCPtr(pc),a3
	lea	sintab(pc),a0
	lea	costab(pc),a1

	lea	AngleZ_1(pc),a4
	move.w	(a4),d3
	addq.w	#6,d3
	cmpi.w	#720,d3
	blt.s	zok_1
	subi.w	#720,d3
zok_1:	move.w	d3,(a4)

	moveq	#3-1,d5
RotZ_1:
	move.w	(a2)+,d0	;x
	move.w	(a2)+,d1	;y
	asl.w	#4,d0
	asl.w	#4,d1

	move.w	d0,d4
	move.w	d1,d7
	muls	(a1,d3.w),d0	; nx=x*cos(ga)
	muls	(a0,d3.w),d1	; ny=y*sin(ga)
	sub.l	d1,d0		; fx=nx-ny
	add.l	d0,d0
	swap	d0
	muls	(a0,d3.w),d4	; nx=x*sin(ga)
	muls	(a1,d3.w),d7	; ny=y*cos(ga)
	add.l	d7,d4		; fy=nx+ny
	add.l	d4,d4
	swap	d4

	ext.l	d0
	ext.l	d4
	asr.l	#4,d0
	asr.l	#4,d4
	add.w	Midx_1(pc),d0
	add.w	AddPicX_1(pc),d0
	add.w	Midy_1(pc),d4
	add.w	AddPicY_1(pc),d4
	move.w	d0,(a3)+
	move.w	d4,(a3)+
	dbf	d5,RotZ_1
	rts

Transform_2:
	move.l	CoordsPtr_2(pc),a2
	move.l	NCPtr(pc),a3
	lea	sintab(pc),a0
	lea	costab(pc),a1

	lea	AngleZ_2(pc),a4
	move.w	(a4),d3
	addq.w	#6,d3
	cmpi.w	#720,d3
	blt.s	zok_2
	subi.w	#720,d3
zok_2:	move.w	d3,(a4)

	moveq	#4-1,d5
RotZ_2:
	move.w	(a2)+,d0	;x
	move.w	(a2)+,d1	;y
	asl.w	#4,d0
	asl.w	#4,d1

	move.w	d0,d4
	move.w	d1,d7
	muls	(a1,d3.w),d0	; nx=x*cos(ga)
	muls	(a0,d3.w),d1	; ny=y*sin(ga)
	sub.l	d1,d0		; fx=nx-ny
	add.l	d0,d0
	swap	d0
	muls	(a0,d3.w),d4	; nx=x*sin(ga)
	muls	(a1,d3.w),d7	; ny=y*cos(ga)
	add.l	d7,d4		; fy=nx+ny
	add.l	d4,d4
	swap	d4

	ext.l	d0
	ext.l	d4
	asr.l	#4,d0
	asr.l	#4,d4
	add.w	Midx_2(pc),d0
	add.w	AddPicX_2(pc),d0
	add.w	Midy_2(pc),d4
	add.w	AddPicY_2(pc),d4
	move.w	d0,(a3)+
	move.w	d4,(a3)+
	dbf	d5,RotZ_2
	rts

Transform_3:
	move.l	CoordsPtr_3(pc),a2
	move.l	NCPtr(pc),a3
	lea	sintab(pc),a0
	lea	costab(pc),a1

	lea	AngleZ_3(pc),a4
	move.w	(a4),d3
	addq.w	#8,d3
	cmpi.w	#720,d3
	blt.s	zok_3
	subi.w	#720,d3
zok_3:	move.w	d3,(a4)

	moveq	#3-1,d5
RotZ_3:
	move.w	(a2)+,d0	;x
	move.w	(a2)+,d1	;y
	asl.w	#4,d0
	asl.w	#4,d1

	move.w	d0,d4
	move.w	d1,d7
	muls	(a1,d3.w),d0	; nx=x*cos(ga)
	muls	(a0,d3.w),d1	; ny=y*sin(ga)
	sub.l	d1,d0		; fx=nx-ny
	add.l	d0,d0
	swap	d0
	muls	(a0,d3.w),d4	; nx=x*sin(ga)
	muls	(a1,d3.w),d7	; ny=y*cos(ga)
	add.l	d7,d4		; fy=nx+ny
	add.l	d4,d4
	swap	d4

	ext.l	d0
	ext.l	d4
	asr.l	#4,d0
	asr.l	#4,d4
	muls	Zoom1_3(pc),d0
	divs	Zoom2_3(pc),d0
	add.w	Midx_3(pc),d0
	muls	Zoom1_3(pc),d4
	divs	Zoom2_3(pc),d4
	add.w	Midy_3(pc),d4
	move.w	d0,(a3)+
	move.w	d4,(a3)+
	dbf	d5,RotZ_3
	rts

Zoom1_3:	dc.w	400
Zoom2_3:	dc.w	400

;---------------------------------------------------------
MakeSquare_1:
	move.l	NCPtr(pc),a0
	move.w	(a0)+,d0
	move.w	(a0)+,d1
	move.w	(a0)+,d2
	move.w	(a0)+,d3
	move.l	Line1ParmPtr(pc),a0
	bsr	SelectOctants_1

	move.l	Line1ParmPtr(pc),a0
	move.l	Line1Ptr_1(pc),a1
	move.l	NCPtr(pc),a2
	moveq	#SideSize_1-1,d6
	bsr	MakeLine_1

	move.l	SquareParmPtr_1(pc),a0
	move.l	Line1Ptr_1(pc),a1
	move.l	NCPtr(pc),a2
	addq.w	#$8,a2
SqrLoop_1:
	move.w	(a1)+,d0
	move.w	(a1)+,d1
	move.w	(a2)+,d2
	move.w	(a2)+,d3
	bsr	SelectOctants_1

	move.l	SquareParmPtr_1(pc),a0
	move.l	SquarePtr_1(pc),a1
	move.l	Line1Ptr_1(pc),a2
	move.l	(a2),-(sp)
SqrLoop2_1:
	moveq	#SideSize_1-1,d6
	bsr	MakeLine_1
	move.l	SquarePtr_1(pc),a1
	move.l	Line1Ptr_1(pc),a2
	move.l	(sp)+,(a2)
	moveq	#SideSize_1-2,d7
SqrLoop3_1:
	move.w	(a2)+,d0
	move.w	(a2)+,d1
	move.w	(a2),d2
	move.w	2(a2),d3
	sub.w	d0,d2
	sub.w	d1,d3
	moveq	#SideSize_1-1,d6
SqrLoop4_1:
	move.w	(a1),d0
	move.w	2(a1),d1
	add.w	d2,d0
	add.w	d3,d1
	move.w	d0,SideSize_1*4(a1)
	move.w	d1,SideSize_1*4+2(a1)
	addq.w	#$4,a1
	dbf	d6,SqrLoop4_1
	dbf	d7,SqrLoop3_1
	rts

MakeSquare_2:
	move.l	NCPtr(pc),a0
	move.w	(a0)+,d0
	move.w	(a0)+,d1
	move.w	(a0)+,d2
	move.w	(a0)+,d3
	move.l	Line1ParmPtr(pc),a0
	bsr	SelectOctants_2

	move.l	NCPtr(pc),a0
	addq.l	#$8,a0
	move.w	(a0)+,d0
	move.w	(a0)+,d1
	move.w	(a0)+,d2
	move.w	(a0),d3
	move.l	Line2ParmPtr(pc),a0
	bsr	SelectOctants_2

	move.l	Line1ParmPtr(pc),a0
	move.l	Line1Ptr_2(pc),a1
	move.l	NCPtr(pc),a2
	moveq	#SideSize_2-1,d6
	bsr	MakeLine_1

	move.l	Line2ParmPtr(pc),a0
	move.l	Line2Ptr_2(pc),a1
	move.l	NCPtr(pc),a2
	addq.l	#$8,a2
	moveq	#SideSize_2-1,d6
	bsr	MakeLine_1

	move.l	SquareParmPtr_2(pc),a0
	move.l	Line1Ptr_2(pc),a1
	move.l	Line2Ptr_2(pc),a2
	move.w	#SideSize_2-1,d4
SqrLoop_2:
	move.w	(a1)+,d0
	move.w	(a1)+,d1
	move.w	(a2)+,d2
	move.w	(a2)+,d3
	move.l	d4,-(sp)
	bsr	SelectOctants_2
	move.l	(sp)+,d4
	dbf	d4,SqrLoop_2

	move.l	SquareParmPtr_2(pc),a0
	move.l	SquarePtr_2(pc),a1
	move.l	Line1Ptr_2(pc),a2
	move.w	#SideSize_2-1,d7
SqrLoop2_2:
	moveq	#SideSize_2-1,d6
	bsr	MakeLine_1
	lea	12(a0),a0
	addq.l	#$4,a2
	dbf	d7,SqrLoop2_2
	rts

MakeSquare_3:
	move.l	NCPtr(pc),a0
	moveq	#0,d0
	moveq	#0,d1
	moveq	#0,d2
	moveq	#0,d3
	move.w	(a0)+,d0
	move.w	(a0)+,d1
	move.w	(a0)+,d2
	move.w	(a0)+,d3
	move.l	Line1Ptr_3(pc),a0
	bsr	MakeLine_3

	move.l	NCPtr(pc),a0
	moveq	#0,d0
	moveq	#0,d1
	moveq	#0,d2
	moveq	#0,d3
	move.w	(a0)+,d0
	move.w	(a0)+,d1
	addq.w	#$4,a0
	move.w	(a0)+,d2
	move.w	(a0),d3
	move.l	Line2Ptr_3(pc),a0
	bsr	MakeLine_3


	move.l	SquarePtr_3(pc),a0
	move.l	Line2Ptr_3(pc),a1
	move.w	#SideSize_3-1,d4
SqrLoop_3:
	move.w	(a1)+,(a0)+
	move.w	(a1)+,(a0)+
	dbf	d4,SqrLoop_3

	move.l	SquarePtr_3(pc),a0
	move.l	Line1Ptr_3(pc),a1
	move.w	#SideSize_3-2,d7
SqrLoop2_3:
	move.w	(a1)+,d0
	move.w	(a1)+,d1
	move.w	(a1),d2
	move.w	2(a1),d3
	sub.w	d0,d2
	sub.w	d1,d3
	move.w	#SideSize_3-1,d6
Sqrloop3_3:
	move.w	(a0),d0
	move.w	2(a0),d1
	add.w	d2,d0
	add.w	d3,d1
	move.w	d0,SideSize_3*4(a0)
	move.w	d1,SideSize_3*4+2(a0)
	addq.w	#$4,a0
	dbf	d6,Sqrloop3_3
	dbf	d7,SqrLoop2_3
	rts

;---------------------------------------------------------
SelectOctants_1:
	sub.w	d0,d2
	sub.w	d1,d3
	bgt.s	Octs4567_1
Octs0123_1:
	neg.w	d3
	tst.w	d2
	bgt.s	Octs01_1
Octs23_1:	neg.w	d2
	cmp.w	d2,d3
	bgt.s	Oct2_1
Oct3_1:	moveq	#-1,d5
	moveq	#-1,d6
	moveq	#1,d7
	bra.s	OctOK_1
Oct2_1:	moveq	#-1,d5
	moveq	#-1,d6
	moveq	#-1,d7
	exg	d2,d3
	bra.s	OctOK_1
Octs01_1:	cmp.w	d2,d3
	bgt.s	Oct1_1
Oct0_1:	moveq	#1,d5
	moveq	#-1,d6
	moveq	#1,d7
	bra.s	OctOK_1
Oct1_1:	moveq	#1,d5
	moveq	#-1,d6
	moveq	#-1,d7
	exg	d2,d3
	bra.s	OctOK_1
Octs4567_1:
	tst.w	d2
	bgt.s	Octs67_1
Octs45_1:	neg.w	d2
	cmp.w	d2,d3
	bgt.s	Oct5_1
Oct4_1:	moveq	#-1,d5
	moveq	#1,d6
	moveq	#1,d7
	bra.s	OctOK_1
Oct5_1:	moveq	#-1,d5
	moveq	#1,d6
	moveq	#-1,d7
	exg	d2,d3
	bra.s	OctOK_1
Octs67_1:	cmp.w	d2,d3
	bgt.s	Oct6_1
Oct7_1:	moveq	#1,d5
	moveq	#1,d6
	moveq	#1,d7
	bra.s	OctOK_1
Oct6_1:	moveq	#1,d5
	moveq	#1,d6
	moveq	#-1,d7
	exg	d2,d3
OctOK_1:	add.w	d3,d3		;const2 = 2*dy
	move.w	d3,d0
	sub.w	d2,d0		;p = 2*dy-dx
	move.w	d0,d1
	sub.w	d2,d1		;const1 = 2*dy-2*dx
	move.w	d0,(a0)+
	move.w	d1,(a0)+
	move.w	d3,(a0)+
	move.w	d5,(a0)+
	move.w	d6,(a0)+
	move.w	d7,(a0)+
	rts

SelectOctants_2:
	sub.w	d0,d2
	sub.w	d1,d3
	bgt.s	Octs4567_2
Octs0123_2:
	neg.w	d3
	tst.w	d2
	bgt.s	Octs01_2
Octs23_2:	neg.w	d2
	cmp.w	d2,d3
	bgt.s	Oct2_2
Oct3_2:	moveq	#-1,d5
	moveq	#-1,d6
	moveq	#1,d7
	bra.s	OctOK_2
Oct2_2:	moveq	#-1,d5
	moveq	#-1,d6
	moveq	#-1,d7
	exg	d2,d3
	bra.s	OctOK_2
Octs01_2:	cmp.w	d2,d3
	bgt.s	Oct1_2
Oct0_2:	moveq	#1,d5
	moveq	#-1,d6
	moveq	#1,d7
	bra.s	OctOK_2
Oct1_2:	moveq	#1,d5
	moveq	#-1,d6
	moveq	#-1,d7
	exg	d2,d3
	bra.s	OctOK_2
Octs4567_2:
	tst.w	d2
	bgt.s	Octs67_2
Octs45_2:	neg.w	d2
	cmp.w	d2,d3
	bgt.s	Oct5_2
Oct4_2:	moveq	#-1,d5
	moveq	#1,d6
	moveq	#1,d7
	bra.s	OctOK_2
Oct5_2:	moveq	#-1,d5
	moveq	#1,d6
	moveq	#-1,d7
	exg	d2,d3
	bra.s	OctOK_2
Octs67_2:	cmp.w	d2,d3
	bgt.s	Oct6_2
Oct7_2:	moveq	#1,d5
	moveq	#1,d6
	moveq	#1,d7
	bra.s	OctOK_2
Oct6_2:	moveq	#1,d5
	moveq	#1,d6
	moveq	#-1,d7
	exg	d2,d3
OctOK_2:	add.w	d3,d3		;const2 = 2*dy
	move.w	d3,d0
	sub.w	d2,d0		;p = 2*dy-dx
	move.w	d0,d1
	sub.w	d2,d1		;const1 = 2*dy-2*dx
	move.w	d0,(a0)+
	move.w	d1,(a0)+
	move.w	d3,(a0)+
	move.w	d5,(a0)+
	move.w	d6,(a0)+
	move.w	d7,(a0)+
	rts

;---------------------------------------------------------
MakeLine_1:
	move.w	(a2),d0
	move.w	2(a2),d1
	move.w	d0,(a1)+
	move.w	d1,(a1)+
Shift_1:
	move.w	(a0),d0		;p
	move.w	2(a0),d1	;const1
	move.w	4(a0),d2	;const2
	move.w	6(a0),d3	;addx_1
	move.w	8(a0),d4	;addy_1
	move.w	10(a0),d5	;XorY
	tst.w	d0
	bgt.s	pHi_1
pLow_1:	add.w	d2,d0
	tst.w	d5
	blt.s	AddY_1
AddX_1:	add.w	d3,(a2)
	move.w	d0,(a0)
	dbf	d6,MakeLine_1
	rts
AddY_1:	add.w	d4,2(a2)
	move.w	d0,(a0)
	dbf	d6,MakeLine_1
	rts
pHi_1:	add.w	d1,d0
	add.w	d3,(a2)
	add.w	d4,2(a2)
	move.w	d0,(a0)
	dbf	d6,MakeLine_1
	rts

MakeLine_3:
	moveq	#SideSize_3-1,d4
	swap	d0
	swap	d1
	swap	d2
	swap	d3
	sub.l	d0,d2
	sub.l	d1,d3
	asr.l	#5,d2
	asr.l	#5,d3
mlloop_3:	swap	d0
	swap	d1
	move.w	d0,(a0)+
	move.w	d1,(a0)+
	swap	d0
	swap	d1
	add.l	d2,d0
	add.l	d3,d1
	dbf	d4,mlloop_3
	rts
;-----------------------------------------------< Draw to Screen Begin >-----
PlotPoints_1:
	move.l	SquareParmPtr_1(pc),a0
	subq.l	#$4,a0
	move.l	PlaneH(pc),a1
	move.l	MulsPtr_1(pc),a2
	move.l	PicPtr_1(pc),a3
	moveq	#0,d5
	move.l	#(50-SideSize_1>>1)*40,d4
	add.w	#19+SideSize_1>>4,d4
	moveq	#SideSize_1-1,d3
Draw_Loop_1:
	moveq	#SideSize_1-1,d7
Draw_1:	move.w	d4,d6
	move.w	(a0),d0
	move.w	2(a0),d1
	subq.l	#$4,a0
	move.w	d0,d2
	add.w	d1,d1
	move.w	(a2,d1.w),d1
	lsr.w	#3,d2
	add.w	d2,d1
	andi.w	#$f,d0
	not.b	d0
B0_1:	btst	d0,(a3,d1.w)
	beq.s	B1_1
	bset	d5,(a1,d6.w)
B1_1:	addi.w	#40*100,d6
	addi.w	#40*110,d1
	btst	d0,(a3,d1.w)
	beq.s	B2_1
	bset	d5,(a1,d6.w)
B2_1:	addi.w	#40*100,d6
	addi.w	#40*110,d1
	btst	d0,(a3,d1.w)
	beq.s	BTest_1
	bset	d5,(a1,d6.w)
BTest_1:
	cmp.b	#7,d5
	bne.s	NoZero_1
	move.b	#-1,d5
	subq.w	#1,d4
NoZero_1:
	addq.b	#1,d5
	dbf	d7,Draw_1
	addi.w	#40+SideSize_1>>3,d4
	moveq	#0,d5
	dbf	d3,Draw_Loop_1
	rts

DrawChunky_2:
	move.l	SquareParmPtr_2(pc),a0
	subi.l	#SideSize_2*4,a0
	move.l	Screen_2(pc),a1
	addq.l	#$6,a1
	move.l	MulsPtr_2(pc),a2
	move.l	PicPtr_2(pc),a3

	moveq	#SideSize_2-1,d6
AllLines_2:
	moveq	#SideSize_2-1,d7
OneLine_2:
	moveq	#0,d0
	moveq	#0,d1
	move.w	(a0)+,d0
	move.w	(a0)+,d1
	add.w	d0,d0
	add.w	d1,d1
	add.w	d1,d1
	move.l	(a2,d1.w),d4
	add.l	d0,d4
	move.w	(a3,d4.l),d2
	move.w	d2,(a1)
	move.w	d2,168(a1)
	move.w	d2,2*168(a1)
	move.w	d2,3*168(a1)
	move.w	d2,4*168(a1)
	addq.l	#4,a1
	dbf	d7,OneLine_2
	addi.l	#8+4*168,a1
	subi.l	#40*4*2,a0
	dbf	d6,AllLines_2
	rts

DrawChunky_3:
	move.l	SquarePtr_3(pc),a0
	lea	CopScr_3+$2,a1
	move.l	MulsPtr_2(pc),a2
	lea	FacePic,a3
	moveq	#30-1,d6
AllLines_3:
	moveq	#30-1,d7
	lea	Offsets_3(pc),a4
OneLine_3:
	move.w	(a4)+,d5
	moveq	#0,d0
	moveq	#0,d1
	move.w	(a0)+,d0
	move.w	(a0)+,d1
	add.w	d0,d0
	add.w	d1,d1
	add.w	d1,d1
	move.l	(a2,d1.w),d4
	add.l	d0,d4
	move.w	(a3,d4.l),d2
	move.w	d2,(a1,d5.w)
	addi.w	#128,d5
	move.w	d2,(a1,d5.w)
	addi.w	#128,d5
	move.w	d2,(a1,d5.w)
	addi.w	#128,d5
	move.w	d2,(a1,d5.w)
	dbf	d7,OneLine_3
	addi.w	#4*128,a1
	addi.w	#8,a0
	dbf	d6,AllLines_3
	rts
Offsets_3:
	dc.w	64,0,68,4,72,8,76,12,80,16,84,20,88,24,92,28
	dc.w	96,32,100,36,104,40,108,44,112,48,116,52,120,56,124,60

;--------------------------------------------------< Draw to Screen End >-----

;--------------------------------------------------------< Faders Begin >-----
FadeToBlack_1:
	move.w	(a0),d0
	andi.w	#$0F00,d0
	tst.w	d0
	beq.s	FB_01_1
	subi.w	#$0100,(a0)
FB_01_1:
	move.w	(a0),d0
	andi.w	#$00F0,d0
	tst.w	d0
	beq.s	FB_02_1
	subi.w	#$0010,(a0)
FB_02_1:
	move.w	(a0),d0
	andi.w	#$000F,d0
	tst.w	d0
	beq.s	FB_03_1
	subq.w	#$0001,(a0)
FB_03_1:
	adda.l	d1,a0
	dbf	d7,FadeToBlack_1
	rts

FadeFromBlack_1:
	move.w	(a0),d0
	move.w	(a1),d2
	andi.w	#$0F00,d0
	andi.w	#$0F00,d2
	cmpi.w	d0,d2
	beq.s	FC_01_1
	addi.w	#$0100,(a0)
FC_01_1:
	move.w	(a0),d0
	move.w	(a1),d2
	andi.w	#$00F0,d0
	andi.w	#$00F0,d2
	cmpi.w	d0,d2
	beq.s	FC_02_1
	addi.w	#$0010,(a0)
FC_02_1:
	move.w	(a0),d0
	move.w	(a1),d2
	andi.w	#$000F,d0
	andi.w	#$000F,d2
	cmpi.w	d0,d2
	beq.s	FC_03_1
	addq.w	#$0001,(a0)
FC_03_1:
	adda.l	d1,a0
	addq.l	#2,a1
	dbf	d7,FadeFromBlack_1
	rts
;---------------------------------------------------------< Faders End >-----

;--------------------------------------------------< Scroll Text Begin >-----
ScrollText:
	subq.b	#2,Count
	cmpi.b	#-2,Count
	bne	ScrollIt
	move.b	#6,Count
	lea	TextPosition(pc),a0
	move.l	(a0),a0
	moveq.l	#0,d0
	move.b	(a0),d0
	cmpi.b	#-1,d0
	bne	NoRestart
	move.l	#Text,TextPosition
	lea	TextPosition(pc),a0
	move.l	(a0),a0
	moveq.l	#0,d0
	move.b	(a0),d0
NoRestart:
	addq.l	#1,TextPosition
	subi.b	#32,d0
	lsl.w	#1,d0
	lea	Offsets(pc),a1
	moveq.l	#0,d1
	move.w	0(a1,d0.w),d1
	lea	Font,a2
	adda.l	d1,a2
BltWait:
	btst	#14,2(a6)
	bne.s	BltWait
	move.l	a2,$4c(a6)
	move.l	#ScrollMap+40,$54(a6)
	move.w	#38,$62(a6)
	move.w	#40,$66(a6)
	move.w	#$5cc,$40(a6)
	clr.w	$42(a6)
	move.w	#16*64*3+1,$58(a6)
ScrollIt:
	btst	#14,2(a6)
	bne.s	ScrollIt
	move.l	#ScrollMap+(42*16*3)-2,$4c(a6)
	move.l	#ScrollMap+(42*16*3)-2,$54(a6)
	clr.w	$62(a6)
	clr.w	$66(a6)
	move.w	#$5cc,$40(a6)
	move.w	#2!$4000,$42(a6)
	move.w	#16*64*3+21,$58(a6)
	rts

Count:	dc.b	0
Text:	dc.b	'                                     '
	dc.b	'HEY PEOPLE. DID YOU SEE THE FIRST BITMAP ROTATION WITH '
	dc.b	'NO COPPER BUT PROCESSOR ?     OH, DID YOU ALREADY SEE '
	dc.b	'THIS EFFECT ?'
	dc.b	'      OK, BUT MY IS BETTER. ;-)      '
	dc.b	'AND HOW DO YOU LIKE THIS ONE ?'
	dc.b	'                                                 '
	dc.b	'                                                 '
	dc.b	-1
	EVEN

TextPosition:	dc.l	Text
;------------- Font16x16.3PL Offsets ------------------
R2=1920
R3=3840
Offsets:
	dc.w	0			; SPACE
	dc.w	2,4,6,8			; ! " # $
	dc.w	10,12,14,16		; % & ' (
	dc.w	18,20,22,24		; ) * + ,
	dc.w	26,28,30,32		; - . / 0
	dc.w	34,36,38,R2		; 1 2 3 4
	dc.w	R2+2,R2+4,R2+6,R2+8	; 5 6 7 8
	dc.w	R2+10,R2+12,R2+14,R2+16	; 9 : ; <
	dc.w	R2+18,R2+20,R2+22,R2+24	; = > ? @
	dc.w	R2+26,R2+28,R2+30,R2+32	; A B C D
	dc.w	R2+34,R2+36,R2+38,R3	; E F G H
	dc.w	R3+2,R3+4,R3+6,R3+8	; I J K L
	dc.w	R3+10,R3+12,R3+14,R3+16	; M N O P
	dc.w	R3+18,R3+20,R3+22,R3+24	; Q R S T
	dc.w	R3+26,R3+28,R3+30,R3+32	; U V W X
	dc.w	R3+34,R3+36		; Y Z
;------------- End of Font 16x16.3PL Offsets ----------
;----------------------------------------------------< Scroll Text End >-----
sintab
	DC.W	0,$23B,$477,$6B2,$8ED,$B27,$D61,$F99
	DC.W	$11D0,$1405,$1639,$186C,$1A9C,$1CCA,$1EF7,$2120
	DC.W	$2347,$256C,$278D,$29AB,$2BC6,$2DDE,$2FF2,$3203
	DC.W	$340F,$3617,$381C,$3A1B,$3C17,$3E0D,$3FFF,$41EC
	DC.W	$43D3,$45B6,$4793,$496A,$4B3B,$4D07,$4ECD,$508C
	DC.W	$5246,$53F9,$55A5,$574B,$58E9,$5A81,$5C12,$5D9C
	DC.W	$5F1E,$6099,$620C,$6378,$64DC,$6638,$678D,$68D9
	DC.W	$6A1D,$6B58,$6C8C,$6DB6,$6ED9,$6FF2,$7103,$720B
	DC.W	$730A,$7400,$74EE,$75D2,$76AD,$777E,$7846,$7905
	DC.W	$79BB,$7A67,$7B09,$7BA2,$7C31,$7CB7,$7D32,$7DA4
	DC.W	$7E0D,$7E6B,$7EC0,$7F0A,$7F4B,$7F82,$7FAF,$7FD2
	DC.W	$7FEB,$7FFA
costab
	DC.W    $7FFF,$7FFA,$7FEB,$7FD2,$7FAF,$7F82
	DC.W	$7F4B,$7F0A,$7EC0,$7E6B,$7E0D,$7DA4,$7D32,$7CB7
	DC.W	$7C31,$7BA2,$7B09,$7A67,$79BB,$7905,$7846,$777E
	DC.W	$76AD,$75D2,$74EE,$7400,$730A,$720B,$7103,$6FF2
	DC.W	$6ED9,$6DB6,$6C8B,$6B58,$6A1D,$68D9,$678D,$6638
	DC.W	$64DC,$6378,$620C,$6099,$5F1E,$5D9C,$5C12,$5A81
	DC.W	$58E9,$574B,$55A5,$53F9,$5246,$508C,$4ECD,$4D07
	DC.W	$4B3B,$496A,$4793,$45B6,$43D3,$41EC,$3FFF,$3E0D
	DC.W	$3C17,$3A1B,$381C,$3618,$340F,$3203,$2FF2,$2DDE
	DC.W	$2BC7,$29AB,$278D,$256C,$2347,$2120,$1EF7,$1CCB
	DC.W	$1A9C,$186C,$163A,$1406,$11D0,$F99,$D61,$B27
	DC.W	$8ED,$6B3,$477,$23C,0,$FDC5,$FB89,$F94E
	DC.W	$F713,$F4D9,$F2A0,$F067,$EE30,$EBFB,$E9C7,$E794
	DC.W	$E564,$E336,$E10A,$DEE0,$DCB9,$DA95,$D873,$D655
	DC.W	$D43A,$D222,$D00E,$CDFE,$CBF1,$C9E9,$C7E5,$C5E5
	DC.W	$C3EA,$C1F3,$C001,$BE14,$BC2D,$BA4B,$B86E,$B696
	DC.W	$B4C5,$B2F9,$B133,$AF74,$ADBB,$AC08,$AA5B,$A8B6
	DC.W	$A717,$A57F,$A3EE,$A264,$A0E2,$9F67,$9DF4,$9C88
	DC.W	$9B24,$99C8,$9874,$9728,$95E4,$94A8,$9375,$924A
	DC.W	$9128,$900E,$8EFD,$8DF5,$8CF6,$8C00,$8B13,$8A2E
	DC.W	$8954,$8882,$87BA,$86FB,$8645,$8599,$84F7,$845E
	DC.W	$83CF,$8349,$82CE,$825C,$81F3,$8195,$8140,$80F6
	DC.W	$80B5,$807E,$8051,$802E,$8015,$8006,$8001,$8006
	DC.W	$8015,$802E,$8051,$807E,$80B5,$80F6,$8140,$8195
	DC.W	$81F3,$825B,$82CD,$8349,$83CF,$845E,$84F7,$8599
	DC.W	$8645,$86FB,$87B9,$8882,$8953,$8A2E,$8B12,$8BFF
	DC.W	$8CF5,$8DF5,$8EFD,$900E,$9127,$9249,$9374,$94A7
	DC.W	$95E3,$9727,$9873,$99C7,$9B23,$9C87,$9DF3,$9F67
	DC.W	$A0E1,$A264,$A3ED,$A57E,$A716,$A8B5,$AA5B,$AC07
	DC.W	$ADBA,$AF73,$B133,$B2F8,$B4C4,$B696,$B86D,$BA4A
	DC.W	$BC2C,$BE14,$C000,$C1F2,$C3E9,$C5E4,$C7E4,$C9E8
	DC.W	$CBF0,$CDFD,$D00D,$D221,$D439,$D654,$D872,$DA94
	DC.W	$DCB8,$DEDF,$E109,$E335,$E563,$E794,$E9C6,$EBFA
	DC.W	$EE30,$F066,$F29F,$F4D8,$F712,$F94D,$FB88,$FDC4
sinend_1
	DC.W	0,$23B,$477,$6B2,$8ED,$B27,$D61,$F99
	DC.W	$11D0,$1405,$1639,$186C,$1A9C,$1CCA,$1EF7,$2120
	DC.W	$2347,$256C,$278D,$29AB,$2BC6,$2DDE,$2FF2,$3203
	DC.W	$340F,$3617,$381C,$3A1B,$3C17,$3E0D,$3FFF,$41EC
	DC.W	$43D3,$45B6,$4793,$496A,$4B3B,$4D07,$4ECD,$508C
	DC.W	$5246,$53F9,$55A5,$574B,$58E9,$5A81,$5C12,$5D9C
	DC.W	$5F1E,$6099,$620C,$6378,$64DC,$6638,$678D,$68D9
	DC.W	$6A1D,$6B58,$6C8C,$6DB6,$6ED9,$6FF2,$7103,$720B
	DC.W	$730A,$7400,$74EE,$75D2,$76AD,$777E,$7846,$7905
	DC.W	$79BB,$7A67,$7B09,$7BA2,$7C31,$7CB7,$7D32,$7DA4
	DC.W	$7E0D,$7E6B,$7EC0,$7F0A,$7F4B,$7F82,$7FAF,$7FD2
	DC.W	$7FEB,$7FFA
cosend_1
;---------------------------------------------------------
AddTableX_1:
	DC.W	$FFBA,$FFBA,$FFBB,$FFBC,$FFBD,$FFBF,$FFC1,$FFC3,$FFC6,$FFC9
	DC.W	$FFCC,$FFCF,$FFD3,$FFD7,$FFDB,$FFDF,$FFE4,$FFE8,$FFED,$FFF1
	DC.W	$FFF6,$FFFB,$0000,$0005,$000A,$000F,$0013,$0018,$001C,$0021
	DC.W	$0025,$0029,$002D,$0031,$0034,$0037,$003A,$003D,$003F,$0041
	DC.W	$0043,$0044,$0045,$0046,$0046,$0046,$0046,$0045,$0044,$0043
	DC.W	$0041,$003F,$003D,$003A,$0037,$0034,$0031,$002D,$0029,$0025
	DC.W	$0021,$001C,$0018,$0013,$000F,$000A,$0005,$0000,$FFFB,$FFF6
	DC.W	$FFF1,$FFED,$FFE8,$FFE4,$FFDF,$FFDB,$FFD7,$FFD3,$FFCF,$FFCC
	DC.W	$FFC9,$FFC6,$FFC3,$FFC1,$FFBF,$FFBD,$FFBC,$FFBB,$FFBA,$FFBA
	DC.W	'x'
AddTableY_1:
	DC.W	$0000,$0001,$0002,$0002,$0003,$0003,$0004,$0004,$0005,$0005
	DC.W	$0005,$0005,$0005,$0005,$0004,$0004,$0004,$0003,$0003,$0002
	DC.W	$0001,$0001,$0000,$FFFF,$FFFF,$FFFE,$FFFD,$FFFD,$FFFC,$FFFC
	DC.W	$FFFC,$FFFB,$FFFB,$FFFB,$FFFB,$FFFB,$FFFB,$FFFC,$FFFC,$FFFD
	DC.W	$FFFD,$FFFE,$FFFE,$FFFF,$0000
	DC.W	'x'
AddTableX_2:
	DC.W	$0000,$0001,$0002,$0003,$0004,$0004,$0005,$0006,$0007,$0007
	DC.W	$0008,$0009,$0009,$000A,$000A,$000B,$000B,$000B,$000C,$000C
	DC.W	$000C,$000C,$000C,$000C,$000C,$000C,$000C,$000B,$000B,$000B
	DC.W	$000A,$000A,$0009,$0009,$0008,$0007,$0007,$0006,$0005,$0004
	DC.W	$0004,$0003,$0002,$0001,$0000,$0000,$FFFF,$FFFE,$FFFD,$FFFC
	DC.W	$FFFC,$FFFB,$FFFA,$FFF9,$FFF9,$FFF8,$FFF7,$FFF7,$FFF6,$FFF6
	DC.W	$FFF5,$FFF5,$FFF5,$FFF4,$FFF4,$FFF4,$FFF4,$FFF4,$FFF4,$FFF4
	DC.W	$FFF4,$FFF4,$FFF5,$FFF5,$FFF5,$FFF6,$FFF6,$FFF7,$FFF7,$FFF8
	DC.W	$FFF9,$FFF9,$FFFA,$FFFB,$FFFC,$FFFC,$FFFD,$FFFE,$FFFF,$0000
	DC.W	'x'
AddTableY_2:
	DC.W	$000A,$000A,$000A,$000A,$000A,$0009,$0009,$0009,$0008,$0008
	DC.W	$0007,$0007,$0006,$0006,$0005,$0005,$0004,$0003,$0003,$0002
	DC.W	$0001,$0001,$0000,$FFFF,$FFFF,$FFFE,$FFFD,$FFFD,$FFFC,$FFFB
	DC.W	$FFFB,$FFFA,$FFFA,$FFF9,$FFF9,$FFF8,$FFF8,$FFF7,$FFF7,$FFF7
	DC.W	$FFF6,$FFF6,$FFF6,$FFF6,$FFF6,$FFF6,$FFF6,$FFF6,$FFF6,$FFF6
	DC.W	$FFF7,$FFF7,$FFF7,$FFF8,$FFF8,$FFF9,$FFF9,$FFFA,$FFFA,$FFFB
	DC.W	$FFFB,$FFFC,$FFFD,$FFFD,$FFFE,$FFFF,$FFFF,$0000,$0001,$0001
	DC.W	$0002,$0003,$0003,$0004,$0005,$0005,$0006,$0006,$0007,$0007
	DC.W	$0008,$0008,$0009,$0009,$0009,$000A,$000A,$000A,$000A,$000A
	DC.W	'x'
AddTableZ_3:
	DC.W	$0067,$006C,$0071,$0076,$007B,$007F,$0083,$0087,$008B,$008E
	DC.W	$0091,$0093,$0094,$0095,$0096,$0096,$0095,$0094,$0093,$0091
	DC.W	$008E,$008B,$0087,$0083,$007F,$007B,$0076,$0071,$006C,$0067
	DC.W	$0061,$005C,$0057,$0052,$004D,$0049,$0045,$0041,$003D,$003A
	DC.W	$0037,$0035,$0034,$0033,$0032,$0032,$0033,$0034,$0035,$0037
	DC.W	$003A,$003D,$0041,$0045,$0049,$004D,$0052,$0057,$005C,$0061
	DC.W	'x'
;---------------------------------------------------------
Midx_1:			dc.w	160
Midy_1:			dc.w	50
Midx_2:			dc.w	72
Midy_2:			dc.w	80
Midx_3:			dc.w	72
Midy_3:			dc.w	80

PlaneH:			dc.l	Screen1_1
PlaneS:			dc.l	Screen2_1

PicPtr_1:		dc.l	AmigaPic
TopTextPtr:		dc.l	TopText
BottomTextPtr:		dc.l	BottomText

AngleZ_1:		dc.w	0
AngleZ_2:		dc.w	0
AngleZ_3:		dc.w	0

AddPicX_1:		dc.w	0
AddPicY_1:		dc.w	0
AddPicX_2:		dc.w	0
AddPicY_2:		dc.w	0

AddTableXPtr_1:		dc.l	AddTableX_1
AddTableYPtr_1:		dc.l	AddTableY_1
AddTableXPtr_2:		dc.l	AddTableX_2
AddTableYPtr_2:		dc.l	AddTableY_2
AddTableZPtr_3:		dc.l	AddTableZ_3

chipbase:		dc.l	$dff000

MulsPtr_1:		dc.l	MulsList_1
MulsPtr_2:		dc.l	MulsList_2

CoordsPtr_1:		dc.l	Coords_1
CoordsPtr_2:		dc.l	Coords_2
CoordsPtr_3:		dc.l	Coords_3

NCPtr:			dc.l	NewCoords

Line1ParmPtr:		dc.l	Line1Parm
Line2ParmPtr:		dc.l	Line2Parm

Line1Ptr_1:		dc.l	Line1_1
Line2Ptr_1:		dc.l	Line2_1
Line1Ptr_2:		dc.l	Line1_2
Line2Ptr_2:		dc.l	Line2_2
Line1Ptr_3:		dc.l	Line1_3
Line2Ptr_3:		dc.l	Line2_3

SquarePtr_1:		dc.l	Square_1
SquareParmPtr_1:	dc.l	SquareParm_1
SquarePtr_2:		dc.l	Square_2
SquareParmPtr_2:	dc.l	SquareParm_2
SquarePtr_3:		dc.l	Square_3

Screen_2:		dc.l	CopperScr_2
PicPtr_2:		dc.l	FacePic
;---------------------------------------------------------
Coords_1:	dc.w	1-SideSize_1>>1,SideSize_1>>1
		dc.w	1-SideSize_1>>1,1-SideSize_1>>1
		dc.w	SideSize_1>>1,SideSize_1>>1

Coords_2:	dc.w	1-SideSize_2>>1,SideSize_2>>1
		dc.w	1-SideSize_2>>1,1-SideSize_2>>1
		dc.w	SideSize_2>>1,SideSize_2>>1
		dc.w	SideSize_2>>1,1-SideSize_2>>1

Coords_3:	dc.w	1-SideSize_3<<2,SideSize_3<<2
		dc.w	1-SideSize_3<<2,1-SideSize_3<<2
		dc.w	SideSize_3<<2,SideSize_3<<2

NewCoords:	dcb.w	2*3,0

MulsList_1:	dcb.w	110,0
MulsList_2:	dcb.l	256,0

TextColours_1:	dc.w	$0000,$0222,$0444,$0666
		dc.w	$0999,$0BBB,$0DDD,$0FFF

;---------------------------------------------------------
	include	'tbsd:trackerpackerreplayv3.1.s'
;-----------------------------------------------< Begin of Copper Lists >-----
CopperList_1:
	dc.w	$01fc,$0000,$106,0
	dc.w	$008E,$2C81,$0090,$2CC1
	dc.w	$0092,$0038,$0094,$00D0
TColours_1:
	dc.w	$0180,$0000,$0182,$0000,$0184,$0000,$0186,$0000
	dc.w	$0188,$0000,$018A,$0000,$018C,$0000,$018E,$0000
TopTextCopper:
	dc.w	$00E0,$0000,$00E2,$0000
	dc.w	$00E4,$0000,$00E6,$0000
	dc.w	$00E8,$0000,$00EA,$0000
	dc.w	$0100,$3200,$0102,$0000,$0104,$0000
	dc.w	$0108,$0050,$010A,$0050
	dc.w	$2d01,$fffe,$0096,$8100
	dc.w	$7101,$fffe,$0096,$0100
PicCol_1:
	dc.w	$0180,$0000,$0182,$0C82,$0184,$0EA2,$0186,$0FE8
	dc.w	$0188,$0400,$018A,$0600,$018C,$0EEE,$018E,$0A50
BitMaps_1:
	dc.w	$00E0,$0000,$00E2,$0000
	dc.w	$00E4,$0000,$00E6,$0000
	dc.w	$00E8,$0000,$00EA,$0000
	dc.w	$0100,$3200,$0102,$0000,$0104,$0000
	dc.w	$0108,$0000,$010A,$0000
	dc.w	$7307,$fffe
CL1_1:	dc.w	$0180,$0f00
	dc.w	$7407,$fffe
CA_1:	dc.w	$0180,$0123,$0096,$8100
	dc.w	$d807,$fffe
CL2_1:	dc.w	$0180,$0f00,$0096,$0100
	dc.w	$d907,$fffe,$0180,$0000
BColours_1:
	dc.w	$0180,$0000,$0182,$0000,$0184,$0000,$0186,$0000
	dc.w	$0188,$0000,$018A,$0000,$018C,$0000,$018E,$0000
BottomTextCopper:
	dc.w	$00E0,$0000,$00E2,$0000
	dc.w	$00E4,$0000,$00E6,$0000
	dc.w	$00E8,$0000,$00EA,$0000
	dc.w	$0100,$3200,$0102,$0000,$0104,$0000
	dc.w	$0108,$0050,$010A,$0050
	dc.w	$da01,$fffe,$0096,$8100,$ffdf,$fffe
	dc.w	$1101,$fffe,$0096,$0100
	dc.w	$ffff,$fffe
;------------------------------------------------------
CopperList_2:
	dc.w	$01fc,$0000,$106,0
	dc.w	$008E,$2C81,$0090,$2CC1
	dc.w	$0092,$0038,$0094,$00D0
	dc.w	$0102,$0000,$0104,$0000
	dc.w	$0180,$0000
	dc.w	$2e07,$fffe,$0180,$000f
	dc.w	$2f01,$fffe,$0180,$0000
CopperScr_2:
	dcb.w	(2+41*2)*200,0
	dcb.w	2+2+4,0
	dc.w	$ffff,$fffe
;-----------------------------------------
CopperList_3:
	dc.w	$01fc,$0000,$106,0
	dc.w	$008E,$2C81,$0090,$2CC1
	dc.w	$0092,$0038,$0094,$00D0
	dc.w	$0102,$0000,$0104,$0000
	dc.w	$0180,$0000,$0182,$0060,$0184,$0281,$0186,$04A2
	dc.w	$0188,$06D4,$018A,$08F7,$018C,$054A,$018E,$065B
	dc.w	$0190,$077B,$0192,$099C,$0194,$0BBD,$0196,$0953
	dc.w	$0198,$0A75,$019A,$0C98,$019C,$0DCB,$019E,$0FFF
CopLogoPic:
	dc.w	$00E0,$0000,$00E2,$0000
	dc.w	$00E4,$0000,$00E6,$0000
	dc.w	$00E8,$0000,$00EA,$0000
	dc.w	$00EC,$0000,$00EE,$0000
	dc.w	$0108,$0078,$010A,$0078,$0100,$4200
	dc.w	$2c01,$fffe,$0096,$8100
	dc.w	$5d01,$fffe,$0096,$0100
CopMask:dc.w	$00E0,$0000,$00E2,$0000
	dc.w	$00E4,$0000,$00E6,$0000
	dc.w	$00E8,$0000,$00EA,$0000
	dc.w	$00EC,$0000,$00EE,$0000
	dc.w	$6801,$fffe,$0096,$8100,$0108,-40,$010A,-40
	dc.w	$0180,$0,$0182,$0,$0184,$0,$0186,$0
	dc.w	$0188,$0,$018A,$0,$018C,$0,$018E,$0
	dc.w	$0190,$0,$0192,$0,$0194,$0,$0196,$0
	dc.w	$0198,$0,$019A,$0,$019C,$0,$019E,$0,$6881,$fffe
CopScr_3:
	dcb.l	(15+1+16)*120,0
	dc.w	$e101,$fffe,$0096,$0100

	dc.w	$0102,$0000,$0104,$0000
	dc.w	$0180,$0000,$0182,$0EEF,$0184,$0CDE,$0186,$0BCD
	dc.w	$0188,$09AB,$018A,$0789,$018C,$0567,$018E,$0456
	dc.w	$0100,$3100
	dc.w	$0108,2*42+2,$010a,2*42+2
ScrollMaps:
	dc.w	$00e0,$0000,$00e2,$0000
	dc.w	$00e4,$0000,$00e6,$0000
	dc.w	$00e8,$0000,$00ea,$0000
	dc.w	$ffdf,$fffe
	dc.w	$0501,$fffe
	dc.w	$96,$8100
	dc.w	$1501,$fffe
	dc.w	$96,$100
	dc.w	$108,-3*42*2-40,$10a,-3*42*2-40
	dc.w	$1601,$fffe
	dc.w	$0180,$0234,$0182,$0ccd,$0184,$0abc,$0186,$09ab
	dc.w	$0188,$0789,$018A,$0567,$018C,$0345,$018E,$0234
	dc.w	$96,$8100
	dc.w	$1e01,$ff00
	dc.w	$96,$100
	dc.w	$009c,$8004
	dc.w	$ffff,$fffe
;-------------------------------------------------< End of Copper Lists >-----
Line1Parm:	dcb.w	1+1+1+3,0
Line2Parm:	dcb.w	1+1+1+3,0
Line1_1:	dcb.w	2*SideSize_1,0
Line2_1:	dcb.w	2*SideSize_1,0
Square_1:	dcb.w	SideSize_1*SideSize_1*2,0
SquareParm_1:	dcb.w	6*SideSize_1,0

Line1_2:	dcb.w	2*SideSize_2,0
Line2_2:	dcb.w	2*SideSize_2,0
Square_2:	dcb.w	SideSize_2*SideSize_2*2,0
SquareParm_2:	dcb.w	6*SideSize_2,0

Line1_3:	dcb.w	2*SideSize_3,0
Line2_3:	dcb.w	2*SideSize_3,0
Square_3:	dcb.w	SideSize_3*SideSize_3*2,0
;---------------------------------------------------------
AmigaPic:	dcb.b	40*110*3,0
TopText:	dcb.b	40*68*3,0
BottomText:	dcb.b	40*55*3,0

FacePic:	dcb.w	144*160,0
LogoPic:	dcb.b	40*49*4,0
Mask:		dcb.b	40*1*4,0

Screen1_1:	dcb.b	40*100*3,0
Screen2_1:	dcb.b	40*100*3,0

Font:		dcb.b	5760,0
ScrollMap:	dcb.b	42*17*3,0

module:		incbin	'tbsd:BitmapRot/bmrot.tp3'
