#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <dos.h>
#include <libraries/dosextens.h>
#include <exec/types.h>

#include <dlg/dlg.h>
#include <dlg/user.h>
#include <dlg/input.h>
#include <dlg/resman.h>
#include <dlg/misc.h>

#include <link/io.h>

#include <proto/dos.h>
#include <proto/exec.h>
#include <proto/dlg.h>

#include <pragmas/dlg.h>

#include <private/Version.h>
#define  ObjRev "1"
const UBYTE version[]="\0$VER: ListUser " BUILDVER "." ObjRev " " COPYRIGHT " by Digerati Dreams "__AMIGADATE__;

void  main(void);
void  List(char *, char , long , char , char *, char *);
BYTE  Print_User(char *);
void  Get_Computer_Type(char, char *);
void _CXBRK(void);
int   Read_Users(void);

#define STK  RStruct.Command_Stack
#define HOT  UserDat.Hot_Keys

BPTR               sout;
struct USER_DATA   UserDat;
struct USER_DATA   User;
struct Ram_File    RStruct;
struct UserInfo    ui      = {&UserDat, &RStruct};
struct Query       q       = {NULL, NULL, NULL, NULL, NULL, 0, 0, QUERY_UPCASE};
struct NameStruct *users = NULL;
char               Ext[4];

long   numusers = 0;
USHORT pos      = 4;
char   moreon   = 1;
char  *displaybuf;

struct Library    *DLGBase = NULL;
struct LangStruct *ls;
char             **SA;


void main(void)

{char *c;
 char  match  [40] = "*";
 char  tempstr[40];

 sout = Output();
 if (!(DLGBase = OpenLibrary(DLGNAME, DLGVERSION)))  exit(5);

 if (GetDevName(Ext)==-1)              _CXBRK();
 if (!ReadUser(&RStruct,&UserDat,Ext))  _CXBRK();
 if (!(ls = GetLang(Ext)))             _CXBRK();
 SA = ls->strings;

 ASPrintf(NULL, RStruct.Action, SA[1001]);
 WriteRam(&RStruct, Ext);

 numusers = Read_Users();

 q.prompt     = SA[1002];
 q.string     = tempstr;
 q.length     = 36;
 q.typelength = 36;
 if (DLGQuery(&q, &ui))
    {if (tempstr[0] != '*')
         c = match+1;
       else
         c = match;

     c = stpcpy(c, tempstr);
     if (*(c-1) != '*')  stpcpy(c, "*");
    }

  AFPrintf(NULL, sout, "\n\n");
  List(match,0,0,0,"","");
 _CXBRK();
}


void List(char *name,char computer,long login,char userlevel,char *city,char *province)

{int   counter;
 int   passflag;
 int   count;
 char  filename[255];
 char *match;

 AFPrintf(&UserDat, sout, SA[1003]);
 Draw_Line(UserDat.Screen_Width);

 count = 0;
 for(counter = 0; counter < numusers; counter++)
    {match = (char *)(users + counter);

     chkabort();
     if (!DLGPatternMatch(name,match))  continue;

     ASPrintf(NULL, filename, "USER:%s/User.Data", users+counter);
     UnderScore(filename);
     if (GetFirstStruct(filename, (char *)&User, sizeof(struct USER_DATA)))  continue;

     passflag = 1;

     if (computer)
         if (computer!=User.Computer_Type)
        passflag = 0;

     if (login)
      ;

     if (userlevel)
         if (userlevel >= User.User_Level)
        passflag = 0;

     if (strcmp(city,""))
      ;

     if (strcmp(province,""))
      ;

     if (passflag)
        {if (Print_User((char *)(users+counter))==-1)
             break;
         count++;
        }             
    }

  Draw_Line(UserDat.Screen_Width);
  AFPrintf(&UserDat, sout, SA[1004],count);
  _CXBRK();
}


BYTE Print_User(char *name)

{char ct       [80];
 char outbuffer[256];
 int  retval;

 Capitalize(name);
 Get_Computer_Type(User.Computer_Type, ct);
 Capitalize(User.Prov);
 Capitalize(User.City);

 ASPrintf(&UserDat, outbuffer, SA[1005], name, ct, User.Total_Calls, User.City,User.Prov, User.Last_Login);

 retval = DisplayBuffer(sout, outbuffer, UserDat.Screen_Width-1, UserDat.Screen_Len, (UserDat.More_Flag && moreon), UserDat.Ansi_Flag, &pos, 0, NULL, 1, "\x03");
 if (retval==-2)
     moreon = 0;
   else
     if (retval)
         return(-1);

 return(0);
}


void Get_Computer_Type(char type,char *retstr)

{struct Computer_Type Ct;

 *retstr    =  0;
  Ct.Number = type;

 if (!GetStruct("DlgConfig:Port/ComputerTypes.bbs", (char *)&Ct, sizeof(struct Computer_Type), 1))
      ASPrintf(&UserDat,retstr,SA[1006],Ct.Name);

 return;
}


void _CXBRK(void)

{WriteRam(&RStruct,Ext);
 CloseLibrary(DLGBase);

 if (users)  free(users);

 exit(0);
}


int Read_Users(void)

{ULONG  filesize;

 if (FileSize("DLGConfig:Misc/Users.bbs",&filesize)==-1)  return(FALSE);
 if (!(users = malloc(filesize)))                         return(FALSE);

 GetFirstStruct("DLGConfig:Misc/Users.bbs", (char *)users, filesize);
 return((int)(filesize/(long)sizeof(struct NameStruct)));
}
