#include "UserEdit.h"

char notes[128];

void ViewAcct(void);

/// EditAcct()
void EditAcct(void)
{
   BOOL  b;
   BOOL  Write    = FALSE;
   char  c[2];
   long  l;

   ASPrintf(NULL,notes,"DLGConfig:Notes/%s.Notes",name);
   UnderScore(notes);

   while(TRUE)
   {
      ViewAcct();

      DLGInput("Select letter to edit parameter -> ",NULL,c,NULL,1,1,1);
      TwoLines();

      if(Sysop)
      {

///      Change Access Level (A)
         if(!Strnicmp(c,"A",1))
         {
            l = IntQuery("New Access Level -> ",1,255,0,&uin);
            TwoLines();

            if(l == 0) continue;

            if(Same && (UserDat.User_Level < (SHORT)l ) && UserDat.User_Level != 255)
            {
               AFPrintf(&UserDat,sout,"You cannot increase your own access level.\n");
               Pause();
               continue;
            }

            if(udat.User_Level != (SHORT)l)
            {
               udat.User_Level = (SHORT)l;
               AFPrintf(&UserDat,sout,"%a7Changed!\n\n");
               Write = TRUE;
            }
         }
//-

///      Change Account Type (B)
         if(!Strnicmp(c,"B",1))
         {
            BOOL u;

            AFPrintf(&UserDat,sout,"%b0%a7");
            Draw_Line(UserDat.Screen_Width);
            AFPrintf(&UserDat,sout,"%a2[%a71%a2] %a3- %a6SHELL Account\n");
            AFPrintf(&UserDat,sout,"%a2[%a72%a2] %a3- %a6UUCP Client\n");
            AFPrintf(&UserDat,sout,"%b0%a7");
            Draw_Line(UserDat.Screen_Width);
            OneLine();

            l = IntQuery("Account Type -> ",1,2,0,&uin);
            TwoLines();

            if(l == 0) continue;

            u = udat.UUCP & UUCP_CLIENT;

            switch(l)
            {
               case 1:
                     if(u) Write = TRUE;
                     udat.UUCP = udat.UUCP & ~UUCP_CLIENT;
                     break;

               case 2:
                     if(!u) Write = TRUE;
                     udat.UUCP = udat.UUCP | UUCP_CLIENT;
                     break;
            }

            if(Write)
               AFPrintf(&UserDat,sout,"%a7Changed!\n\n");
         }
//-

///      Change Daily Limit (C)
         if(!Strnicmp(c,"C",1))
         {
            l = IntQuery("New Daily Limit -> ",1,1440,0,&uin);
            TwoLines();

            if(l == 0) continue;

            if(udat.Daily_Limit != (SHORT)l)
            {
               udat.Daily_Limit = (SHORT)l;
               AFPrintf(&UserDat,sout,"%a7Changed!\n\n");
               Write = TRUE;
            }
         }
//-

///      Change Session Limit (D)
         if(!Strnicmp(c,"D",1))
         {
            l = IntQuery("New Session Limit -> ",1,udat.Daily_Limit,0,&uin);
            TwoLines();

            if(l == 0) continue;

            if(udat.Session_Limit != (SHORT)l)
            {
               udat.Session_Limit = (SHORT)l;
               AFPrintf(&UserDat,sout,"%a7Changed!\n\n");
               Write = TRUE;
            }
         }
//-

///      Change Directory Limit (E)
         if(!Strnicmp(c,"E",1))
         {
            l = IntQuery("New Directory Limit (kb) -> ",1,10000,0,&uin);
            TwoLines();

            if(l == 0) continue;

            if(udat.DirLimit != (SHORT)l)
            {
               udat.DirLimit = (SHORT)l;
               AFPrintf(&UserDat,sout,"%a7Changed!\n\n");
               Write = TRUE;
            }
         }
//-

///      Change File Ratio (F)
         if(!Strnicmp(c,"F",1))
         {
            l = IntQuery("New File Ratio (0 to disable) -> ",1,126,0,&uin);
            TwoLines();

            if(l == 0) continue;

            if(udat.Ratio != (char)l)
            {
               udat.Ratio = (char)l;
               AFPrintf(&UserDat,sout,"%a7Changed!\n\n");
               Write = TRUE;
            }
         }
//-

///      Change Bulletin Write Access (G)
         if(!Strnicmp(c,"G",1))
         {
            b = BoolQuery("Enable Bulletin Write Access -> ",FALSE,&uin);
            TwoLines();

            if(udat.Bulletin_Access != (char)b)
            {
               udat.Bulletin_Access = (char)b;
               AFPrintf(&UserDat,sout,"%a7Changed!\n\n");
               Write = TRUE;
            }
         }
//-

///      Change Pop Screen (I)
         if(!Strnicmp(c,"I",1))
         {
            b = BoolQuery("Pop open screen when user logs in -> ",FALSE,&uin);
            TwoLines();

            if(udat.Pop_Screen != (char)b)
            {
               udat.Pop_Screen = (char)b;
               AFPrintf(&UserDat,sout,"%a7Changed!\n\n");
               Write = TRUE;
            }
         }
//-

///      Edit User Notes (J)
         if(!Strnicmp(c,"J",1))
         {
            CallEditor(NULL,NULL,notes,10,&UserDat,&RStruct,Ext);
         }
//-

      }

///   Exit
      if(!Strnicmp(c,"X",1))
      {
         if(Write && Sysop)
         {
            struct NameStruct ns;

            strcpy(ns.name,name);

            if(0 == DeleteStruct(NAMERECORD,(char *)&ns,sizeof(struct NameStruct),30))
            {
               char fname[128];

               strcpy(ns.alias,udat.Alias);
               strcpy(ns.email,udat.Email);
               AddStruct(NAMERECORD,(char *)&ns,sizeof(struct NameStruct),30);

               ASPrintf(NULL,fname,"USER:%s/User.Data",name);
               UnderScore(fname);

               if(Same) memcpy(&UserDat,&udat,sizeof(struct USER_DATA));
               DeleteFile(fname);
               DumpFile(fname,(char *)&udat,sizeof(struct USER_DATA));
            }

            AFPrintf(&UserDat,sout,"%a7Changes saved.\n\n");
            Pause();
         }
         else
         {
            if(Sysop)
            {
               AFPrintf(&UserDat,sout,"%a7User record unchanged.\n\n");
               Pause();
            }
         }

         break;
      }
//-

///   Quit
      if(!Strnicmp(c,"Q",1))
      {
         if(Write)
         {
            AFPrintf(&UserDat,sout,"%b7 %a1NOTE: %b0%a7 Changes not saved!\n\n");
            Pause();
         }

         break;
      }
//-

   }

   return;
}
//-

/// ViewAcct()
void ViewAcct(void)
{
   char temp[128];

   Clr(UserDat.Ansi_Flag);
   AFPrintf(&UserDat,sout,"\n%a6Account Information for user %a2[%au%a7%s%ao%a2]%a7\n",name);
   Draw_Line(UserDat.Screen_Width);

   if(Sysop)
      AFPrintf(&UserDat,sout,"%b0%a2[%a7A%a2] %a6ACCESS LEVEL ....... %b7%a4    %3d ",udat.User_Level);
   else
      AFPrintf(&UserDat,sout,"%b0%a2[ ] %a6ACCESS LEVEL ....... %b7%a1    %3d ",udat.User_Level);

   if(Sysop)
      AFPrintf(&UserDat,sout,"%b0  %a2[%a7B%a2] %a6ACCOUNT TYPE ......... %b7%a4 %-5.5s  \n",(udat.UUCP & UUCP_CLIENT) ? "UUCP" : "SHELL");
   else
      AFPrintf(&UserDat,sout,"%b0  %a2[ ] %a6ACCOUNT TYPE ......... %b7%a1 %-5.5s  \n",(udat.UUCP & UUCP_CLIENT) ? "UUCP" : "SHELL");

   AFPrintf(&UserDat,sout,"%b0%a7");
   Draw_Line(UserDat.Screen_Width);

   if(Sysop)
      AFPrintf(&UserDat,sout,"%b0%a2[%a7C%a2] %a6DAILY TIME LIMIT ... %b7%a4   %4d ",udat.Daily_Limit);
   else
      AFPrintf(&UserDat,sout,"%b0%a2[ ] %a6DAILY TIME LIMIT ... %b7%a1   %4d ",udat.Daily_Limit);

   if(Sysop)
      AFPrintf(&UserDat,sout,"%b0  %a2[%a7D%a2] %a6SESSION TIME LIMIT ... %b7%a4 %4d   \n",udat.Session_Limit);
   else
      AFPrintf(&UserDat,sout,"%b0  %a2[ ] %a6SESSION TIME LIMIT ... %b7%a1 %4d   \n",udat.Session_Limit);

   if(Sysop)
      AFPrintf(&UserDat,sout,"%b0%a2[%a7E%a2] %a6DIRECTORY LIMIT .... %b7%a4 %6ld ",udat.DirLimit);
   else
      AFPrintf(&UserDat,sout,"%b0%a2[ ] %a6DIRECTORY LIMIT .... %b7%a1 %6ld ",udat.DirLimit);

   if(udat.Ratio)
      ASPrintf(NULL,temp,"%-4d:1",udat.Ratio);
   else
      ASPrintf(NULL,temp,"NONE");

   if(Sysop)
      AFPrintf(&UserDat,sout,"%b0  %a2[%a7F%a2] %a6FILE RATIO ........... %b7%a4 %-6.6s \n",temp);
   else
      AFPrintf(&UserDat,sout,"%b0  %a2[ ] %a6FILE RATIO ........... %b7%a1 %-6.6s \n",temp);

   AFPrintf(&UserDat,sout,"%b0%a7");
   Draw_Line(UserDat.Screen_Width);

   if(Sysop)
      AFPrintf(&UserDat,sout,"%b0%a2[%a7G%a2] %a6BULLETIN WRITE ..... %b7%a4 %-3.3s    ",udat.Bulletin_Access ? "YES" : "NO");
   else
      AFPrintf(&UserDat,sout,"%b0%a2[ ] %a6BULLETIN WRITE ..... %b7%a1 %-3.3s    ",udat.Bulletin_Access ? "YES" : "NO");

   if(Sysop)
      AFPrintf(&UserDat,sout,"%b0  %a2[%a7I%a2] %a6POP SCREEN ........... %b7%a4 %-3.3s    \n",udat.Pop_Screen ? "YES" : "NO");
   else
      AFPrintf(&UserDat,sout,"%b0  %a2[ ] %a6POP SCREEN ........... %b7%a1 %-3.3s    \n",udat.Pop_Screen ? "YES" : "NO");

   if(Sysop)
      AFPrintf(&UserDat,sout,"%b0%a2[%a7J%a2] %a6USER NOTES ......... %b7%a4 %-3.3s    \n",Exists(notes) ? "YES" : "NO");

   AFPrintf(&UserDat,sout,"%b0%a7");
   Draw_Line(UserDat.Screen_Width);

   AFPrintf(&UserDat,sout,"%a2[%a7H%a2] %a6Help    %a2[%a7?%a2] %a6Re-Display    %a2[%a7X%a2] %a6Save and Exit   %a2[%a7Q%a2] %a6Quit (no save)%a7\n");
   Draw_Line(UserDat.Screen_Width);

   AFPrintf(&UserDat,sout,"    %a6Text in %b7 %a1Red Text %b0%a6 is not editable.%a7\n");
   Draw_Line(UserDat.Screen_Width);
   OneLine();

   return;
}
//-
