#include "UserEdit.h"

struct USER_DATA        UserDat;
struct USER_DATA        udat;
struct Ram_File         RStruct;

char   Ext[5];
char   Overlay      =   FALSE;
char   exitflag     =   FALSE;
char   MenuName[13] =  "UED_Main";
char   name[30];


/// Main Menu
#define MAIN_FUNCS   8

struct NewShortMenu Menu[MAIN_FUNCS]   =
{
   {"Abort",1},
   {"UED_Exit",1},
   {"UED_MSG",1},
   {"UED_Personal",1},
   {"UED_Prefs",1},
   {"UED_SelectUser",0},
   {"UED_Stats",1},
   {"UED_System",1},
};

#define  ABORT    0
#define  EXIT     1
#define  MSG      2
#define  PERS     3
#define  PREF     4
#define  SELECT   5
#define  STAT     6
#define  SYS      7
//-

/// Translation Table
#define TRANSELEMENTS 3
char UED_Trans[TRANSELEMENTS][21] =
{
   {"UED_ActiveUser"},
   {"UED_ActiveAlias"},
   {"UED_ActiveEmail"},
};
//-


BOOL               Sysop   = FALSE;
BOOL               Same    = FALSE;

BPTR               sout;
struct Library    *DLGBase = NULL;
struct LangStruct *ls;
struct UserInfo    uin;
char             **SA;

static char version[]="$VER: UserEdit 1.5  1995-1997 by DLG Development "__AMIGADATE__"";

void _CXBRK(void);
int   HandleBuiltIn(UBYTE);
int   UEDSubstitute(char *cstr, char *result);

/// Main
void main(int argc,char **argv)
{
   char *s;
   char *stack =  NULL;

   sout = Output();
 
   if (!(DLGBase = OpenLibrary(DLGNAME, DLGVERSION)))  exit(5);

/// parse args
   while(--argc>0)
   {
      s = *++argv;
      
      if (*s++=='-')
      {
         while(*s)
         {
            switch(*s++)
            {
               case 'o':
               case 'O':
                        Overlay=TRUE;
                        break;

               case 'c':
               case 'C':
                        if (!--argc)  break;
                        stack = *++argv;
                        break;

               case 'm':
               case 'M':
                        if (!--argc)  break;
                        strncpy(MenuName,*++argv,12);
                        MenuName[12]='\0';
                        break;

               case 's':
               case 'S':
                        Sysop = TRUE;
                        break;
            }
         }
      }
   }
//-

   if (-1 == GetDevName(Ext))   _CXBRK();
   if (!(ls = GetLang(Ext)))    _CXBRK();
   SA = ls->strings;

   if (!ReadUser(&RStruct,&UserDat,Ext))  _CXBRK();
   uin.User = &UserDat;
   uin.Ram  = &RStruct;

   if (stack)   InsertStack(STK,stack);

   if(Sysop)
   {
      if(!SelectUser())
      {
         AFPrintf(NULL,sout,"User not selected.\n\n");
         Pause();
        _CXBRK();
      }

      Menu[SELECT].status = 1;
   }
   else
   {
      strcpy(name,RStruct.Name);
      Upper(name);
      memcpy(&udat,&UserDat,sizeof(struct USER_DATA));
      Same = TRUE;
      Menu[SELECT].status = 0;
   }


//   WriteLog(SYSOP_CONFIG,RStruct.Name,Ext,SA[2074]);

/// main loop
   while(!exitflag)
   {
      Chk_Abort();

      if (MenuInput(MenuName,Ext,"UED",Menu,MAIN_FUNCS,HandleBuiltIn,&UserDat,&RStruct,UserDat.Help_Level,UEDSubstitute) == MENUNOTFOUND)
         _CXBRK();
   }
//-

   _CXBRK();
}
//-

/// _CXBRK
void _CXBRK(void)
{
   WriteRam(&RStruct, Ext);

   if(!Overlay)   ChainProgram("DLG:Menu", Ext);
   if(DLGBase)    CloseLibrary(DLGBase);

   exit(0);
}
//-

/// HandleBuiltIn
int HandleBuiltIn(UBYTE cmd)
{
   switch(cmd)
   {
      case EXIT:
      case ABORT:
                 _CXBRK();
                  break;

      case PERS:
                  EditPersonal();
                  break;

      case PREF:
                  EditPrefs();
                  break;

      case SELECT:
                  if(!SelectUser())
                  {
                     AFPrintf(NULL,sout,"Aborted.\n\n");
                     Pause();
                    _CXBRK();
                  }

                  break;

      case STAT:
                  EditStats();
                  break;

      case SYS:
                  EditAcct();
                  break;


      case MSG:
                  EditMess();
                  break;

      default:
                  break;
   }

   return(TRUE);
}
//-

/// UEDSubstitute
int UEDSubstitute(char *cstr, char *result)
{
   char *s;

   s = (char *) DLGSearch((char *) UED_Trans, cstr, 21, 21, TRANSELEMENTS);

   if (!s)
   {
      strcpy(result, "");
      return (FALSE);
   }

   switch ((char) (((long) s - (long) UED_Trans) / 21L) + 1)
   {
      case 1:
               ASPrintf(NULL,result,"%s",name);
               break;

      case 2:
               ASPrintf(NULL,result,"%s",udat.Alias);
               break;

      case 3:
               ASPrintf(NULL,result,"%s",udat.Email);
               break;

      default:
               strcpy(result,"");
               return(FALSE);
               break;
   }

   return (TRUE);
}
//-

