#include <exec/types.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <libraries/bgui_macros.h>

#include <private/privs.h>

#include <proto/dos.h>
#include <proto/exec.h>
#include <proto/intuition.h>
#include <proto/utility.h>

#include "IDs.h"

char              DLGCW    =  (BASIC | FIDO);

struct   MsgPort *SharedPort;

struct   Library *BGUIBase =  NULL;
struct   Window  *MainWin  =  NULL;

void ShutDown(int code, char *err);
void CheckForGo(long Ser, char *Name);
BOOL GenerateKeyFile(void);

extern   struct   Window  *OpenMainWindow( void );
extern   void              RefreshChex( struct Window * );

extern   char     OwnerName[];

extern   long     SerNo;

extern   Object  *MKF_Main;
extern   Object  *MKF_Serial;
extern   Object  *MKF_Name;
extern   Object  *MKF_Go;

#include <private/Version.h>
#define  ObjRev "1"
const UBYTE version[]="\0$VER: MakeKeyFile " BUILDVER "." ObjRev " " COPYRIGHT " by Digerati Dreams "__AMIGADATE__;

#define  SERFILE  "RAM:DLGSerial"

/// main
void main( void )
{
   ULONG       sigmask = 0L, sigrec, rc;
   BOOL        running = TRUE;

   struct   Window   *sigwin;

   BGUIBase = OpenLibrary("bgui.library",41L);

   if(!BGUIBase) ShutDown(20,"Cannot open bgui.library version 41!");

   if ( SharedPort = CreateMsgPort())
   {
      if ( MainWin = OpenMainWindow())
      {
         sigmask |= ( ( 1L << SharedPort->mp_SigBit ));

         do
         {
            // Wait for the signals to come.

            sigrec = Wait( sigmask );

            // Find out the which window signalled us.

            if ( sigrec & ( 1 << SharedPort->mp_SigBit ))
            {
               while ( sigwin = GetSignalWindow( MKF_Main ))
               {
                  if ( sigwin == MainWin )
                  {
                     while (( rc = HandleEvent( MKF_Main )) != WMHI_NOMORE )
                     {
                        char *t;

                        switch ( rc )
                        {
                           case  WMHI_CLOSEWINDOW:
                           case  ID_Quit:
                              running = FALSE;
                              break;

                           case  ID_SerNo:         GetAttr(STRINGA_LongVal,MKF_Serial,(ULONG *)&SerNo);
                                                   CheckForGo(SerNo,OwnerName);
                                                   break;

                           case  ID_Name:          GetAttr(STRINGA_TextVal,MKF_Name,(ULONG *)&t);
                                                   strcpy(OwnerName,t);
                                                   CheckForGo(SerNo,OwnerName);
                                                   break;

                           case  ID_Boss:          if(ISBOSS())
                                                      DLGCW = DLGCW & ~BOSS;
                                                   else
                                                      DLGCW = DLGCW | BOSS;

                                                   RefreshChex(MainWin);
                                                   break;

                           case  ID_Basic:         if(ISBASIC())
                                                      DLGCW = DLGCW & ~BASIC;
                                                   else
                                                      DLGCW = DLGCW | BASIC;

                                                   RefreshChex(MainWin);
                                                   break;

                           case  ID_Fido:          if(ISFIDO())
                                                      DLGCW = DLGCW & ~FIDO;
                                                   else
                                                      DLGCW = DLGCW | FIDO;

                                                   RefreshChex(MainWin);
                                                   break;

                           case  ID_Telnet:        if(ISTELNET())
                                                      DLGCW = DLGCW & ~TELNET;
                                                   else
                                                      DLGCW = DLGCW | TELNET;

                                                   RefreshChex(MainWin);
                                                   break;


                           case  ID_Go:            GenerateKeyFile();
                                                   break;
                        }
                     }

                     continue;
                  }
               }
            }
         }  while ( running );
      }

      if(MKF_Main)    DisposeObject(MKF_Main);

      DeleteMsgPort( SharedPort );
   }

   ShutDown(0,NULL);
}
//-
/// ShutDown()
void ShutDown(int code, char *err)
{
   if(BGUIBase) CloseLibrary(BGUIBase);

   if(code) printf("%s\n\n",err);

   exit(code);
}
//-
/// CheckForGo()
void CheckForGo(long Ser, char *Name)
{
   if(Ser == 0)               return;
   if(!stricmp(Name,"Demo"))  return;
   if(MainWin == NULL)        return;

   SetGadgetAttrs((struct Gadget *)MKF_Go, MainWin, NULL, GA_Disabled,FALSE);
   return;
}
//-
/// GenerateKeyFile
BOOL  GenerateKeyFile(void)
{
   char  SERIAL[12];

   int   Lines = 0;
   int   Groups = 0;
   int   Chars = 0;
   int   FirstChar = 0;

   int   line, group, mychar;

   char  temp[7];

   FILE *fp   =  NULL;

   fp =  fopen(SERFILE,"w");

   if(!fp)  {  printf("Cannot open output file!\n"); return(FALSE);   }

   fprintf(fp,"RE%04.04ld\n\n",SerNo);

   fprintf(fp,"; DLG Keyfile -- do not edit anything other than\n; your name or DLG will quit working!\n\n");

   sprintf(SERIAL,"%06.06ld",SerNo);
   fprintf(fp,"%s\n",SERIAL);
   fprintf(fp,"OWNER %s\n\n",OwnerName);

   strncpy(temp,SERIAL+2,1);
   Lines = atoi(temp) + 2;

   strncpy(temp,SERIAL+3,1);
   Groups = atoi(temp) + 2;

   strncpy(temp,SERIAL+4,1);
   Chars = atoi(temp) + 2;

   strncpy(temp,SERIAL+5,1);
   FirstChar = atoi(temp) + 2;

//   printf("Lines = %d\nGroups = %d\nChars = %d\nFirst Char = %d\n",Lines,Groups,Chars,FirstChar);

   for(line = 0; line < Lines; line++)
   {
      for(group = 0; group < Groups; group++)
      {
         for(mychar = 0; mychar < Chars; mychar++)
         {
            if((line == 0) && (group == 0) && (mychar == 0))
            {
               fprintf(fp,"%01.1X",FirstChar);
               continue;
            }

            if((line == 1) && (group == 0) && (mychar == 0))
            {
               // lower capability word
               fprintf(fp,"%01.1X",DLGCW);
               continue;
            }

            fprintf(fp,"%01.1X",(0xF & GetUniqueID()));
         }

         fprintf(fp," ");
      }

      fprintf(fp,"\n");
   }

   if(fp)   {  fclose(fp); fp = NULL;   }
   return(TRUE);
}
//-

