#include "SysUser.h"

#include <link/io.h>

BOOL PurgeAll(char *array,int numusers)
{
   BPTR fp;
   BPTR tp;
   
   struct Msg_Log *log = NULL;
   struct Msg_Area area;
   long   counter;
   long   numinarea;
 
   ULONG  size;
   ULONG  lsize = 0;
   char   mode  = 0;
   char   filename[56];

   AFPrintf(NULL,sout,"\nCleaning up \n\n");

   // loop for two modes MSG and then FILE

   for(mode=0;mode<2;mode++)
   {
      strcpy(filename,(mode)?"FILE:Area.bbs":"MSG:Area.bbs");
      AFPrintf(NULL,sout,"%s areas... ",(mode)?"File":"Message");
  
      if ((fp=Open(filename,MODE_OLDFILE))==EOF)
         continue;

      // while we read a new area from the mail area file
      
      while(Read(fp,&area,sizeof(area))==sizeof(area))
      {
         // calculate the filename of the actual area user file
         
         ASPrintf(NULL,filename,"%s:%d/User.%s",(mode)?"FILE":"MSG",area.Number,(mode)?"file":"msg");

         if (FileSize(filename,&size)==-1)
            continue;
         
         if (lsize < size)
         {
            if (lsize)
               free(log);
            
            if (!(log   = malloc(size)))
               continue;
            
            lsize = size;
         }
         
         if (GetFirstStruct(filename, (char *)log, size) == -1)
            continue;

         BorrowArea(area.Number,"SYSUSER","purging area",64,(mode)?FILELOCK:MSGLOCK | WRITELOCK);

         DeleteFile(filename);
         numinarea=size/sizeof(struct Msg_Log);

         if ((tp=Open(filename,MODE_READWRITE))==EOF)
         {
            FreeArea(area.Number,"SYSUSER",(mode)?FILELOCK:MSGLOCK | WRITELOCK);
            continue;
         }

         for(counter=0;counter<numinarea;counter++)
         {
            if (!DLGBinSearch(array,(log+counter)->Name,36,36,numusers))    
               Write(tp,log+counter,sizeof(struct Msg_Log));
         }
         
         Close(tp);

         FreeArea(area.Number,"SYSUSER",(mode)?FILELOCK:MSGLOCK | WRITELOCK);
      }

      Close(fp);
   }

  // delete list of users from groups
  
   if ((fp=Open("DLGCONFIG:Group/Group.bbs",MODE_OLDFILE))!=EOF)
   {
      char *grps  = NULL;
      ULONG gsize =  0;

      AFPrintf(NULL,sout,SA[2308]);

      while(Read(fp,&Group,sizeof(Group))==sizeof(Group))
      {
         ASPrintf(NULL,filename,"DLGCONFIG:Group/%s.Group",Group.name);

         if (FileSize(filename, &size)==-1)
            continue;
         
         if (gsize < size)
         {
            if (gsize)
               free(grps);
            
            if (!(grps   = malloc(size)))
               continue;
            
            gsize = size;
         }
         
         if (GetFirstStruct(filename, grps, size) == -1)
            continue;

         DeleteFile(filename);
         numinarea = (int)(size/36);

         if ((tp=Open(filename,MODE_READWRITE))==EOF)
            continue;

         for(counter=0;counter<numinarea;counter++)
         {
            if (!DLGBinSearch(array,grps+(long)(counter*36),36,36,numusers))    
            {
               Write(tp,grps+(long)(counter*36),36);
            }
         }

         Close(tp);
      }

      if (grps)
         free(grps);
      
      Close(fp);
   }

   // delete the users from the bulletin area
  
   AFPrintf(NULL,sout,SA[2309]);

   strcpy(filename,"MSG:0/User.msg");

   if (FileSize(filename, &size) != -1)
   {
      if (lsize < size)
      {
         if (lsize)
            free(log);
         
         log = malloc(size);
         
         lsize = size;
      }

      if (log)
      {
         if (GetFirstStruct(filename, (char *)log, size) != -1)
         {
            BorrowArea(0,"SYSUSER","purging area",64,MSGLOCK|WRITELOCK);
            DeleteFile(filename);

            numinarea=(int)(size/sizeof(struct Msg_Log));

            if ((tp=Open(filename,MODE_READWRITE))!=EOF)
            {
               for(counter=0;counter<numinarea;counter++)
               {
                  if (!DLGBinSearch(array,(log+counter)->Name,36,36,numusers))    
                  {
                     Write(tp,log+counter,sizeof(struct Msg_Log));
                  }
               }
                  
               Close(tp);
            }

            FreeArea(0,"SYSUSER",MSGLOCK|WRITELOCK);
         }
      }
   }

   if (log)
      free(log);
      
   AFPrintf(NULL,sout,SA[2089]);
   return(TRUE);
}


