#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <fcntl.h>
#include <fctype.h>
#include <sys/stat.h>
#include <exec/types.h>
#include <libraries/dosextens.h>

#include <dlg/dlg.h>
#include <dlg/msg.h>
#include <dlg/log.h>
#include <dlg/resman.h>
#include <dlg/user.h>
#include <dlg/menu.h>
#include <dlg/input.h>
#include <dlg/portconfig.h>

#include <devices/tpt.h>

#include <link/io.h>

#include <proto/dos.h>
#include <proto/exec.h>
#include <proto/dlg.h>

#include <pragmas/dlg.h>

#include <private/Version.h>
#define  ObjRev "1"
const UBYTE version[]="\0$VER: ReadLog " BUILDVER "." ObjRev " " COPYRIGHT " by Digerati Dreams "__AMIGADATE__;


void   main (void);
void  _CXBRK(void);

#define INSTACK    RStruct.Command_Stack[0]
#define STK        RStruct.Command_Stack

struct Ram_File    RStruct;
struct USER_DATA   UserDat;
struct UserInfo    ui      = {&UserDat, &RStruct};

struct Log        *log     = NULL;
ULONG              csize   =  0;
char              *logdata = NULL;
BPTR               lfile   = NULL;

BPTR               sout;
struct LangStruct *ls;
struct Library    *DLGBase = NULL;
char             **SA;


void main()

{char   tempname[80];
 char   tempport[4];
 char   today   [36];

 struct LogLevels Log;
 struct Log_Entry LogData;

 char            *obuffer;
 char             Ext[4];

 sout = Output();
 if (!(DLGBase = OpenLibrary(DLGNAME, DLGVERSION)))  exit(5);

 if (GetDevName(Ext) == -1)            _CXBRK();
 if (!ReadUser(&RStruct,&UserDat,Ext))  _CXBRK();
 if (!(ls = GetLang(Ext)))             _CXBRK();
 SA = ls->strings;


 WriteLog(VIEW_LOG, RStruct.Name, Ext, "");

 {ULONG  now;
  ULONG  then;
  long   index;
  long   selection;

  now  = AmigaTime();
  then = now;

  if (!INSTACK)  AFPrintf(&UserDat, sout, SA[1756]);
  for(index = 2; index < 8; index++)
     {then -= 86400;
      SMDate(then, today);
      if (!INSTACK) AFPrintf(&UserDat, sout, SA[1757], index, today);
     }
  if (!INSTACK)  AFPrintf(NULL, sout, "\n");

  selection = IntQuery(SA[1758], 1, 7, 1, &ui);
  then      = now - ((selection-1) * 86400);
  SMDate(then, today);

  today[3] =  0;
  ASPrintf(NULL, tempname, "DLGConfig:Text/Log.%s", today);
  today[3] = ' ';

  if (!(lfile = Open(tempname, MODE_OLDFILE)))
     {AFPrintf(&UserDat, sout, SA[1724], tempname);
     _CXBRK();
     }
 }


 {ULONG logsize;

  FileSize(tempname, &logsize);
  logsize = (logsize / sizeof(LogData)) * 128 + 2;
  if (!(logdata = malloc(logsize)))  _CXBRK();
  obuffer = logdata;
 }


 GetFirstStruct("DLGConfig:Port/LogLevels.bbs", (char *)&Log, sizeof(Log));
 if (!FileSize("DLGConfig:Port/CustomLog.bbs", &csize))
    {if (csize)
        {if (!(log = malloc(csize)))                                              _CXBRK();
         if (GetFirstStruct("DLGConfig:Port/CustomLog.bbs", (char *)log, csize))  _CXBRK();
         csize = csize / sizeof(struct Log);
        }
    }


 tempname[0] = 0;
 tempport[0] = 0;
 while(Read(lfile, &LogData, sizeof(LogData)))
      {char   activity[64];
       char   loginfo [64];
       char   logdate [36];
       char  *act;
       long   a;

       act = SA[1754];

       if (LogData.Code < 128)
          {if (Log.Log_Access[LogData.Code] > UserDat.User_Level)  continue;

           switch(LogData.Code)
                 {case VIEW_INFO:          act = SA[1726];
                                           break;

                  case VIEW_USER_STATS:    act = SA[1727];
                                           break;

                  case USER_OPTION_MODULE: act = SA[1728];
                                           break;

                  case PAGED_SYSOP:        act = SA[1729];
                                           break;

                  case VIEW_LOG:           act = SA[1730];
                                           break;

                  case VIEW_TDIH:          act = SA[1731];
                                           break;

                  case SYSOP_CONFIG:       act = SA[1732];
                                           break;

                  case DROP_TO_DOS:        act = SA[1733];
                                           break;

                  case READ_HELP:          act = SA[1734];
                                           break;

                 case NORMAL_LOGOUT:       act = SA[1735];
                                           break;

                 case WROTE_MESSAGE:       act = SA[1736];
                                           break;

                 case KILLED_MESSAGE:      act = SA[1737];
                                           break;

                 case EDITED_SIGNATURE:    act = SA[1738];
                                           break;

                 case RE_EDITED_MESSAGE:   act = SA[1739];
                                           break;

                 case WROTE_BULLETIN:      act = SA[1740];
                                           break;

                 case BAD_PASSWORD:        act = SA[1741];
                                           break;

                 case SUCCESSFUL_LOGIN:    act = SA[1742];
                                           break;

                 case HAPPY_BIRTHDAY:      act = SA[1743];
                                           break;

                 case DOWNLOADED_FILE:     act = SA[1744];
                                           break;

                 case UPLOADED_FILE:       act = SA[1745];
                                           break;

                 case KILLED_FILE:         act = SA[1746];
                                           break;

                 case RE_EDITED_FILE:      act = SA[1747];
                                           break;

                 case HURLED_FILE:         act = SA[1748];
                                           break;

                 case NEW_USER:            act = SA[1749];
                                           break;

                 case CONF:                act = SA[1750];
                                           break;

                 case HURLED_MESSAGE:      act = SA[1751];
                                           break;

                 case FORWARDED_MESSAGE:   act = SA[1752];
                                           break;

                 case CONNECT:             act = SA[1753];
                                           break;

                 case LOST_CARRIER:        act = SA[1759];
                                           break;
                }

          }
        else
          {if (log)
              {for(a = 0; (log+a)->number != LogData.Code && a < csize; a++);
               if (LogData.Code == (log+a)->number && (log+a)->level > UserDat.User_Level)
                   continue;
               act = (log+a)->desc;
              }
          }

       if (!(strcmp(tempname, LogData.Name)))
             LogData.Name[0] = 0;
           else
             strcpy(tempname, LogData.Name);

/*       if (!(strcmp(tempport, LogData.Ext)))
             LogData.Ext[0] = 0;
           else
             strcpy(tempport, LogData.Ext); */

       SMDate(LogData.Long_Time, logdate);
       logdate[19] = 0;

       ASPrintf(&UserDat, activity, act);
       for(act = activity, a = 0; *act; act++)
          {if (*act != '\033')
              {a++;
               if (a > 21)
                  {strcpy(act, act+1);
                   act--;
                  }

               continue;
              }

           while(*act)
                {if (isalpha(*act))  break;
                 act++;
                }
           if (!*act)  act--;
          }
       while(a < 21)
            {*act++ = ' ';
             *act   =  0;
              a++;
            }

       ASPrintf(&UserDat, loginfo,  LogData.Info);
       for(act = loginfo, a = 0; *act; act++)
          {if (*act != '\033')
              {a++;
               if (a > 24)
                  {strcpy(act, act+1);
                   act--;
                  }

               continue;
              }

           while(*act)
                {if (isalpha(*act))  break;
                 act++;
                }

           if (!*act)  act--;
          }

       obuffer += ASPrintf(&UserDat, obuffer, SA[1755], LogData.Name, LogData.Ext, activity, &logdate[14], loginfo);
      }
 *obuffer = 0;
 Close(lfile);
 lfile = NULL;

 {USHORT pos = 0;
  long   retval;

  Clr(UserDat.Ansi_Flag);
  AFPrintf(&UserDat, sout, SA[1725], today);
  retval = DispBuffer(sout, logdata, &pos, 0, NULL, 1, "\x03", &UserDat);
  if (retval == -2  ||  retval == 0)  Pause();
 }

 AFPrintf(NULL, sout, "\n\n");
_CXBRK();
}


void _CXBRK()

{if (log)       free(log);
 if (logdata)   free(logdata);
 if (lfile)     Close(lfile);

 CloseLibrary(DLGBase);
 exit(0);
}
