#include <exec/types.h>

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <exec/libraries.h>

#include <proto/exec.h>
#include <proto/dos.h>
#include <proto/DLG.h>

extern   BPTR              sout;
extern   struct   Library *DLGBase;

/****************************************************************
**
** CheckAreaRange - Check to see if an area is within a specified range
**
** Inputs
**
** long  Area     The file area to investigate
**
** char *ORange   A string with an area range pattern in it. Spaces, commas,
**                dashes, and the + symbol are all recognized.
*/


BOOL CheckAreaRange(long Area, char *ORange)
{
   char    *t[100];
   char    *Range;

   int      c = 0;
   int      i;

   if(Area > 9999) return(FALSE);
   if(strlen(ORange) == 0) return(FALSE);

/// Pre-condition range string
   Range = strdup(ORange);          // We make a copy because this function is destructive

   for(i = 0; i < strlen(Range); i++)
   {
      if(Range[i] == ',') Range[i] = ' ';
   }
//-

   c = ArgParse(Range,t,99);

   if(c == 0) return(FALSE);

   for(i = 0; i < c; i++)
   {
      if(DLGPatternMatch("*-*",t[i]))
      {
         char *p[3];
         int   d;
         long  j;

         for(j = 0; j < strlen(t[i]); j++)
         {
            if(t[i][j] == '-') t[i][j] = ' ';
         }

         d = ArgParse(t[i],p,2);

         if(d > 1)
         {
            for(j = atol(p[0]); j <= atol(p[1]); j++)
            {
               if(Area == j) return(TRUE);
            }
         }
      }

      if(DLGPatternMatch("*+",t[i]))
      {
         long  j;

         for(j = 0; j < strlen(t[i]); j++)
         {
            if(t[i][j] == '+') t[i][j] = ' ';
         }

         for(j = atol(t[i]); j < 10000; j++)
         {
            if(Area == j) return(TRUE);
         }
      }

      if(Area == atol(t[i])) return(TRUE);
   }

   return(FALSE);
}

