#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <exec/types.h>

#include <link/io.h>

#include <proto/dos.h>
#include <proto/dlg.h>

#include <pragmas/dlg.h>

void ScanUpBatch(char *);

extern struct Library *DLGBase;

void ScanUp(char *path,long area,char *name,char success)

{struct SearchCookie *sc;
 char  comment[116];
 char *filename;
 char  lastfile[36];
 char  fullname[255];
 char  lastname[36];
 char  cname[36];
 char  cstatus[9];
 long  carea;
 long  lastarea;
 long  secs;
 long  latest=0L;
 int   len;
 int   scanresult;

 if (name)  UnderScore(name);

 *lastfile = 0;

 strcpy(fullname, path);
 len = strlen(fullname);
 if (fullname[len-1] != ':'  &&  fullname[len-1] != '/')
    {fullname[len] =  '/';
     len++;
     fullname[len] =   0;
    }

 /* start searching the directory */
 sc = (struct SearchCookie *)SearchStart(path,"*");

 /* main loop, while there are still files */
 while(filename=SearchNext(sc))
      {strcpy(fullname+len,filename);

       /* get the existing comment */
       GetComment(fullname,comment);

       /* try to parse the comment */
       scanresult=sscanf(comment,"Area: %d User: %35s Status: %8s", &carea,cname,cstatus);

       /* if this file already has a comment, continue */
       if (scanresult==3)  continue;

       /* if this file has an invalid comment, we will add one */
       if (scanresult<3)
          {carea = area;
           strcpy(cname,(name)?name:"Public");
          }

       ASPrintf(NULL, comment,"Area: %d User: %s Status: Complete",carea,cname);
       SetComment(fullname,comment);

       /* if the download was not successful, we are keeping track of the oldest file */
       if (!success)
          {if (!GetFileDate(fullname,&secs))  continue;

           if (secs > latest)
              {latest = secs;
               strcpy(lastfile,filename);
               strcpy(lastname,cname);
               lastarea = carea;
              }
          }
      }

 SearchEnd(sc);

 if (!success && latest)
    {strcpy(fullname+len,lastfile);

     ASPrintf(NULL, comment,"Area: %d User: %s Status: Partial",lastarea,lastname);
     SetComment(fullname,comment);
    }


 if (Exists("DLGConfig:batch/ReceivedFile.batch"))  ScanUpBatch(path);
}


void ScanUpBatch(char *path)

{struct SearchCookie *sc;
 long   carea;
 long   len;

 char  *filename;
 char   batchname[150];
 char   comment[116];
 char   fullname[255];
 char   cname[36];
 char   cstatus[9];

 /* ensure that path ends in a / or : character */
 strcpy(fullname, path);
 len = strlen(fullname);
 if (fullname[len-1] != ':'  &&  fullname[len-1] != '/')
    {fullname[len] = '/';
     len++;
     fullname[len] =  0;
    }

 /* start searching the directory */
 sc = SearchStart(path,"*");

 /* main loop, while there are still files */
 while(filename = SearchNext(sc))
      {strcpy(fullname+len, filename);

       /* get the existing comment */
       GetComment(fullname, comment);

       /* try to parse the comment */
       sscanf(comment,"Area: %d User: %35s Status: %8s",&carea,cname,cstatus);

       /* if this file is partial skip it */
       if(!Stricmp(cstatus,"Partial"))  continue;

       ASPrintf(NULL, batchname,"Execute DLGConfig:batch/ReceivedFile.batch %s",fullname);
       Execute(batchname,0L,0L);
      }

 SearchEnd(sc);
}
