#include <fcntl.h>
#include <stdio.h>
#include <dlg/msg.h>
#include <dlg/user.h>
#include <proto/dlg.h>
#include <proto/dos.h>

#include <link/io.h>

#include <pragmas/dlg.h>

#define   MSG   0
#define   FILE  1

extern struct Library  *DLGBase;
extern char           **SA;
extern struct USER_DATA UserDat;

BOOL PurgeArea(int lower,int upper,long area,char mode)
{struct Msg_Log  log;
 int              fp;
 int              op;
 struct USER_DATA user;
 char             filename[20];
 char             userfile[64];

 /* Calculate filename for msg/file area log file */
 ASPrintf(NULL, filename,"%s:%d/User.%s",(mode==MSG)?"MSG":"FILE",area,(mode==MSG)?"msg":"file");

 /* Open the log file for reading */
 if ((fp=open(filename,O_RDONLY))==EOF)
      return(FALSE);

 if ((op=open("T:Temp.UserFile",O_RDWR+O_CREAT))==EOF)
    {close(fp);
     return(FALSE);
    }

 /* Main loop: loop through user log file reading and writing each entry */
 while(read(fp,&log,sizeof(log))==sizeof(log))
      {AFPrintf(NULL, Output(), "Checking %s... ", log.Name);

       ASPrintf(NULL, userfile, "USER:%s/User.data", log.Name);
       UnderScore(userfile);
  
       /* If user file does not exist, then skip this user */  
       if (GetFirstStruct(userfile,(char *)&user,sizeof(user))==-1)
          {AFPrintf(&UserDat, Output(), SA[3575]);
           continue;
          }
  
       /* If the user's level does not allow access and he was not specifically
          placed into the area, skip this user - he no longer has access and he
          is not the sysop */
       if ((user.User_Level<lower || user.User_Level>upper) && !log.special && user.User_Level!=255)
          {AFPrintf(&UserDat, Output(), SA[3576]);
           continue;
          }

       /* User still has access, write him to the temp file */
       write(op,&log,sizeof(log));
       AFPrintf(&UserDat, Output(), SA[3577]);
      }

 close(fp);
 close(op);

 DeleteFile(filename);
 Copy("T:Temp.UserFile",filename);
 DeleteFile("T:Temp.UserFile");

 return(TRUE);
}
