/******************************************************************
**
** Mail.h      (c) 1995-1997 by DLG Development
**
** Structures and defines used by mail-oriented modules
**
** Permission is granted for use in supporting DLG and DLG third
** party utilities.
*/


/************************
**
** This address structure will be used in all mail-oriented programs.
*/

struct DLG_Addr
{
   char     Type;          // Type of addressee; see defines below
   char     Domain[36];    // The domain name of the addressee
   int      Zone;          // The zone, net, node, point of a
   int      Net;           //    Fidonet stype address
   int      Node;
   int      Point;
   char     Email[128];    // The full email address of an internet address
   char     Name[50];      // The name (underscored or not) of a local address
};


/************************
**
** These defines are used to determine the type of address
*/

#define  Addr_Local  0     // Only the NAME field will be examined
#define  Addr_Fido   1     // Fidonet address
#define  Addr_INet   2     // Internet email address


