#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <fcntl.h>
#include <dos.h>
#include <exec/types.h>

#include <dlg/dlg.h>
#include <dlg/user.h>
#include <dlg/msg.h>
#include <dlg/portconfig.h>

#include <link/config.h>
#include <link/io.h>
#include <link/lang.h>

#include <proto/exec.h>
#include <proto/dos.h>
#include <proto/dlg.h>

#include <pragmas/dlg.h>

static char version[]="$VER: UUCP2DLG 2.0  1995-1997 by DLG Development ("__AMIGADATE__")";

#define TFILE "T:uucp2dlg.tmp"

void  main(void);
void  CRLine(int);
BOOL  DoMsg(void);
void _CXBRK(void);
void  CleanUp(char *);

BPTR                   sout;
char                 **SA;
struct Library        *DLGBase = NULL;

struct Global_Settings Globals;
struct Msg_Header      header;
struct SearchCookie   *sc      = NULL;


char   buf     [256];
char   filename[128];
UBYTE  delflag   = FALSE;
int    rfd       = EOF;
FILE  *fp        = NULL;
ULONG  bsize     =  0;
UBYTE *mybuf     = NULL;


void main(void)
{
   UBYTE fflag;
   UBYTE tflag;
   UBYTE fsttime;
   UBYTE noprint = TRUE;
   char *username;
   int   len;

   sout = Output();
   if (!(DLGBase = OpenLibrary(DLGNAME,DLGVERSION)))  CleanUp("Unable to open DLG.library");
   if (!(SA = getlang(NULL)))                         CleanUp("Can't read language file");
   AFPrintf(NULL, sout, SA[3327]);
   AFPrintf(NULL, sout, SA[3328]);

   if (ReadGlobals("TR0", &Globals) == -1)  CleanUp(SA[3330]);
   if (!(sc = SearchStart("uumail:","*")))  CleanUp(SA[3329]);

   while(username = SearchNext(sc))
   {
      if (delflag)
      {
         delflag = FALSE;
         DeleteFile(filename);
      }

      if (!Stricmp(username,"mbox")) continue;

      ASPrintf(NULL, filename, "uumail:%s", username);
      DeScore(username);
      AFPrintf(NULL, sout, " [%s]...", username);

      if (!CheckUser(username))
      {
         AFPrintf(NULL, sout, SA[3331]);
         Chk_Abort();
         continue;
      }

      strncpy(header.To,username,35);
      header.To[35] = '\0';

      if (!(fp = fopen(filename,"r")))
      {
         AFPrintf(NULL, sout, SA[3332]);
         continue;
      }

      header.TimesRead = 0;
      header.DestNode  = 0;
      header.OrigNet   = 0;
      header.OrigNode  = 0;
      header.Cost      = 0;
      header.DestNet   = 0;
      header.ReplyTo   = 0;
      header.Attribute = 0;
      header.NextReply = 0;
      
      fsttime = TRUE;

      while(fgets(buf,254,fp))
      {
         len = strlen(buf)-1;
         buf[len] = 0;

         if (!strncmp(buf,"From ",5))
         {
            if (fsttime)
               fsttime = FALSE;
            else
               DoMsg();

            fflag = FALSE;
            tflag = FALSE;

            header.From[0]  = 0;
            header.Title[0] = 0;
            if ((rfd=open(TFILE,O_WRONLY+O_CREAT))==EOF)
               CleanUp(SA[3333]);

            CRLine(len);
            noprint = TRUE;
            continue;
         }

         if (noprint && !buf[0])  noprint = FALSE;

         if (!strncmp(buf,"From:",5))
         {
            CRLine(len);
            if (fflag) continue;
            fflag = TRUE;
            strncpy(header.From,buf+6,35);
            header.From[35] = 0;
            continue;
         }

         if (!strncmp(buf,"Subject:",8))
         {
            CRLine(len);
            if (tflag) continue;
            tflag = TRUE;
            strncpy(header.Title,buf+9,71);
            header.Title[71] = 0;
            continue;
         }

         if (!strncmp(buf,"Date:",5) || !strncmp(buf,"Message-Id:",11) ||
             !strncmp(buf,"Reply-To:",9))
         {
            CRLine(len);
            continue;
         }

         if (!noprint) CRLine(len);
      }

      if (!fsttime)
         if (DoMsg())
         {
            AFPrintf(NULL, sout, SA[3334]);
            delflag = TRUE;
         }
         else
            AFPrintf(NULL, sout, SA[3335]);

      fclose(fp);
      fp = NULL;
   }


   if (delflag)  DeleteFile(filename);
   AFPrintf(NULL, sout, SA[3336]);

   CleanUp(NULL);
}


void CRLine(int len)
{
   write(rfd,buf,len);
   write(rfd,"\x0d",1);
}


BOOL DoMsg(void)
{
   ULONG  size;

   close(rfd);
   rfd = EOF;

   FileSize(TFILE, &size);

   if (bsize < size)
   {
      if (bsize)
      {
         free(mybuf);
         bsize = 0;
      }

      mybuf = malloc(size + 1);

      if (!mybuf)
      {
         DeleteFile(TFILE);
         return(FALSE);
      }

      bsize = size;
   }

   if (GetFirstStruct(TFILE, mybuf, size))
   {
      DeleteFile(TFILE);
      return(FALSE);
   }

   *(mybuf+size)='\0';


   MDate(header.Date);
   SendPrivateMsg(&header, mybuf, UUCP_MSG, "uucp2dlg", "NOL");

   if (Globals.PrivateArea)
   {
      struct Msg_Area msgarea;
      
      if (ReadArea(Globals.PrivateArea,&msgarea,0))
      {
         struct MsgStruct ms;

         ms.header    = &header;
         ms.repheader =  NULL;
         ms.body      =  mybuf;
         ms.replyto   =  0;
         ms.areainfo  = &msgarea;
         ms.flags     =  0;

         SendRawMsg(&ms,NULL,"uucp2dlg");
      }
   }

   DeleteFile(TFILE);
   Chk_Abort();
   return(TRUE);
}


void _CXBRK(void)
{
   CleanUp(SA[3337]);
}


void CleanUp(char *s)
{
   if (fp)          fclose(fp);
   if (rfd != EOF)  close(rfd);
   if (bsize)       free(mybuf);

   DeleteFile(TFILE);

   if (DLGBase)
   {
      if (sc) SearchEnd(sc);
      CloseLibrary(DLGBase);
   }

   if (s)
   {
      Write(sout, "\n Error: ", 9);
      Write(sout,  s,   strlen(s));
      Write(sout, "\n\n",      2);
   }

   exit(s?5:0);
}
