#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <devices/tpt.h>

#include <dlg/dlg.h>
#include <dlg/portconfig.h>

#include <link/io.h>
#include <link/lang.h>

#include <proto/exec.h>
#include <proto/dos.h>
#include <proto/dlg.h>

#include <pragmas/dlg.h>

#include <private/Version.h>
#define  ObjRev "1"
const UBYTE version[]="\0$VER: TScreen " BUILDVER "." ObjRev " " COPYRIGHT " by Digerati Dreams "__AMIGADATE__;

void main(int argc, char **argv);
void Usage(char *);
void CleanUp(char *);

#define CT MyDisplay.Screen.colortable

BPTR            sout;
char          **SA;
struct Library *DLGBase =  NULL;

UWORD  colortable[8]    = {0x000,0xdb6,0x373,0xf70,0x00d,0xb07,0x0bd,0xccc};


void main(int argc, char **argv)

{ULONG  scr;
 LONG   retval;
 char  *s;
 char   devname[4] = "";
 char   filename[80];
 char   ocflag;
 struct Global_Settings Globals;
 struct Port            MyPort;
 struct Displays        MyDisplay;

 sout    = Output();
 DLGBase = OpenLibrary(DLGNAME,DLGVERSION);
 if (!DLGBase)               CleanUp("Unable to open dlg.library");
 if (!(SA = getlang(NULL)))  CleanUp("Can't read language file");

 AFPrintf(NULL, sout, "\n");

 ocflag = 0;
 MyDisplay.Screen.width     = 640;
 MyDisplay.Screen.height    = 200;
 MyDisplay.Screen.depth     =   3;
 MyDisplay.Screen.hires     =   1;
 MyDisplay.Screen.interlace =   0;
 MyDisplay.Screen.flags     =   0;

 movmem(colortable,CT,16);

 strcpy(MyDisplay.Screen.fontname,"topaz");
 MyDisplay.Screen.fontsize = 8;

 while(--argc>0)
      {s = *++argv;

       if (*s++ == '-')
          {while(*s)
                {switch(*s++)
                       {case 'p':
                        case 'P':  if (!--argc)  break;
                                   strncpy(devname,*++argv,3);
                                   devname[3]='\0';
                                   Upper(devname);

                                   sprintf(filename,"DlgConfig:Port/%s.port",devname);
                                   if (GetFirstStruct(filename,(char *)&MyPort,sizeof(MyPort))!=-1)
                                      {sprintf(filename,"DlgConfig:Port/%s",MyPort.GlobalFile);
                                       if (GetFirstStruct(filename,(char *)&Globals,sizeof(Globals))!=-1)
                                          {sprintf(filename,"DlgConfig:Port/%s",MyPort.DisplayFile);
                                           GetFirstStruct(filename,(char *)&MyDisplay,sizeof(MyDisplay));
                                          }
                                 }
                                   break;

                        case 'o':
                        case 'O':  if (ocflag)  Usage(SA[3156]);
                                   ocflag = 1;
                                   scr    = TPOPSCREEN;
                                   break;

                        case 'c':
                        case 'C':  if (ocflag)  Usage(SA[3156]);
                                   ocflag = 1;
                                   scr    = TCLOSESCREEN;
                                   break;

                        case 'w':
                        case 'W':  if (!--argc)  break;
                                   MyDisplay.Screen.width=atoi(*++argv);
                                   break;

                        case 'h':
                        case 'H':  if (!--argc)  break;
                                   MyDisplay.Screen.height=atoi(*++argv);
                                   break;

                        case 'd':
                        case 'D':  if (!--argc)  break;
                                   MyDisplay.Screen.depth=atoi(*++argv);
                                   if ((MyDisplay.Screen.depth<1)||(MyDisplay.Screen.depth>3))
                                        Usage("Depth must be between 1 and 3");
                                   break;

                        case 'm':
                        case 'M':  if (!--argc)  break;
                                   sscanf(*++argv,"%x%x%x%x%x%x%x%x",CT,CT+1,CT+2,CT+3,CT+4,CT+5,CT+6,CT+7);
                                   break;

                        case 'r':  MyDisplay.Screen.hires=0;
                                   break;

                        case 'R':  MyDisplay.Screen.hires=1;
                                   break;

                        case 'i':  MyDisplay.Screen.interlace=0;
                                   break;

                        case 'I':  MyDisplay.Screen.interlace=1;
                                   break;

                        case 'b':
                        case 'B':  MyDisplay.Screen.flags=DISP_BKGRND;
                                   break;

                        case 'f':
                        case 'F':  if (!--argc)  break;
                                   strcpy(MyDisplay.Screen.fontname,*++argv);
                                   if (strcmp(MyDisplay.Screen.fontname+(strlen(MyDisplay.Screen.fontname)-5),".font"))
                                       strcat(MyDisplay.Screen.fontname,".font");
                                   break;

                        case 's':
                        case 'S':  if (!--argc)  break;
                                   MyDisplay.Screen.fontsize=atoi(*++argv);
                                   break;
                       }
                }
          }
      }
 if (!devname[0])  Usage(SA[3157]);
 if (!ocflag)      Usage(SA[3156]);

  retval = TScreen(scr,&(MyDisplay.Screen),devname);
  if (retval==ACTIVERR)
      CleanUp(SA[3158]);
    else
      if (retval==WINOPENERR)
          CleanUp(SA[3159]);
        else
          if (retval==SCROPENERR)
              CleanUp(SA[3160]);
            else
              if (retval==SCRCLOSEDERR)
                  CleanUp(SA[3161]);
                else
                  if (retval==GENERALERR)
                      CleanUp(SA[3162]);
                    else
                      if ((scr==TPOPSCREEN) && (retval & T_SCREEN))
                           AFPrintf(NULL, sout, SA[3163]);
                         else
                           if ((scr==TCLOSESCREEN) && (retval & ~T_SCREEN))
                                AFPrintf(NULL, sout, SA[3164]);

 AFPrintf(NULL, sout, "\n");
 CleanUp(NULL);
}


void Usage(char *string)

{
 AFPrintf(NULL, sout, SA[3165],string);
 AFPrintf(NULL, sout, SA[3166]);
 AFPrintf(NULL, sout, SA[3167]);
 AFPrintf(NULL, sout, SA[3168]);
 AFPrintf(NULL, sout, SA[3169]);
 AFPrintf(NULL, sout, SA[3170]);
 AFPrintf(NULL, sout, SA[3171]);
 AFPrintf(NULL, sout, SA[3172]);
 AFPrintf(NULL, sout, SA[3173]);
 AFPrintf(NULL, sout, SA[3174]);
 AFPrintf(NULL, sout, SA[3175]);
 AFPrintf(NULL, sout, SA[3176]);
 AFPrintf(NULL, sout, SA[3177]);
 AFPrintf(NULL, sout, SA[3178]);
 AFPrintf(NULL, sout, SA[3179]);
 AFPrintf(NULL, sout, SA[3180]);
 AFPrintf(NULL, sout, SA[3181]);
 AFPrintf(NULL, sout, SA[3182]);
 AFPrintf(NULL, sout, SA[3183]);

 CleanUp(NULL);
}


void CleanUp(char *s)

{if (DLGBase)  CloseLibrary(DLGBase);

 if (s)
    {Write(sout, "\n Error: ", 9);
     Write(sout,  s,    strlen(s));
     Write(sout, "\n\n",       2);
    }

 exit(s?5:0);
}
