#include "TPT.h"

///   OpenWinStuff
BOOL OpenWinStuff(SHORT x, SHORT y, SHORT w, SHORT h, ULONG flags,
						UBYTE * title, struct Screen * screen, SHORT minw,
						SHORT minh, SHORT maxw, SHORT maxh, USHORT type,
						UBYTE * fontname, UBYTE fontsize)

{
	struct NewWindow    nw;

	consoleWritePort = CreateMsgPort();

	if (consoleWritePort == NULL)
	{
		CloseWinStuff();
#ifdef DO_DEBUG
		TDebug(1,"OpenWinStuff: Failed to open console write port");
#endif
		return (FALSE);
	}

	consoleWritePort->mp_Node.ln_Name = conwrname;
	AddPort(consoleWritePort);

	consoleWriteMsg = CreateStdIO(consoleWritePort);

	if (consoleWriteMsg == NULL)
	{
		CloseWinStuff();
#ifdef DO_DEBUG
		TDebug(2,"OpenWinStuff: Failed to open console write message port");
#endif
		return (FALSE);
	}

	consoleReadPort = CreateMsgPort();

	if (consoleReadPort == NULL)
	{
		CloseWinStuff();
#ifdef DO_DEBUG
		TDebug(3,"OpenWinStuff: Failed to open console read port");
#endif
		return (FALSE);
	}

	consoleReadPort->mp_Node.ln_Name = conrdname;
	AddPort(consoleReadPort);

	consoleReadMsg = CreateStdIO(consoleReadPort);

	if (consoleReadMsg == NULL)
	{
		CloseWinStuff();
#ifdef DO_DEBUG
		TDebug(4,"OpenWinStuff: Failed to open console read message port");
#endif
		return (FALSE);
	}

	nw.LeftEdge = x;
	nw.TopEdge = y;
	nw.Width = w;
	nw.Height = h;
	nw.DetailPen = (UBYTE) - 1;
	nw.BlockPen = (UBYTE) - 1;
	nw.IDCMPFlags = IDCMP_MOUSEBUTTONS;
	nw.Flags = (ULONG) flags | WFLG_REPORTMOUSE | WFLG_SIMPLE_REFRESH;
	nw.FirstGadget = NULL;
	nw.CheckMark = NULL;
	nw.Title = (UBYTE *) title;
	nw.Screen = (struct Screen *) screen;
	nw.BitMap = NULL;
	nw.MinWidth = minw;
	nw.MinHeight = minh;
	nw.MaxWidth = maxw;
	nw.MaxHeight = maxh;
	nw.Type = (USHORT) type;

	TWind = (struct Window *) OpenWindow(&nw);

	if (TWind == NULL)
	{
		CloseWinStuff();
#ifdef DO_DEBUG
		TDebug(5,"OpenWinStuff: Failed to open window");
#endif
		return (FALSE);
	}

	ta.ta_Name = fontname;
	ta.ta_YSize = fontsize;
	ta.ta_Style = FS_NORMAL;
	ta.ta_Flags = FPF_ROMFONT | FPF_PROPORTIONAL | FPF_DESIGNED;

	tf = (struct TextFont *) OpenFont(&ta);
	
	if (tf)
		SetFont(TWind->RPort, tf);

	consoleWriteMsg->io_Data = (APTR) TWind;
	consoleWriteMsg->io_Length = sizeof(struct Window);

	if (OpenDevice("console.device", CONU_SNIPMAP, 
		 (struct IORequest *) consoleWriteMsg, 1))

// if (OpenDevice("console.device", NULL, (struct IORequest *)consoleWriteMsg, NULL))
	{
		CloseWinStuff();
#ifdef DO_DEBUG
		TDebug(6,"OpenWinStuff: Failed to open console.device");
#endif
		return (FALSE);
	}
	
	consoleReadMsg->io_Device = consoleWriteMsg->io_Device;
	consoleReadMsg->io_Unit = consoleWriteMsg->io_Unit;
	consolesig = CONSOLE_SIG;

	consoleWriteMsg->io_Command = CMD_WRITE;
	tptflags |= T_WINDOW;

// call new hack function to set text color locally to white

	if (TScrDepth)
	{
		hackstring[3] = (48 + ((1 << TScrDepth) - 1));
		WriteCon(hackstring, 5);
	}
// end hack

	set_con_read();
	return (TRUE);
}
//-

///   CloseWinStuff
void CloseWinStuff(void)
{
	if (!(tptflags & T_TYPEAHEAD_FULL) && consoleReadMsg)
		NiceAbort((struct IORequest *) consoleReadMsg);

	if ((tptflags & T_CWRITE_PEND) && consoleWriteMsg)
	{
		WaitIO((struct IORequest *) consoleWriteMsg);
		tptflags &= ~T_CWRITE_PEND;
	}

	if (tf)
		CloseFont(tf);

	if (consoleWriteMsg)
		CloseDevice((struct IORequest *) consoleWriteMsg);

	if (consoleReadMsg)
		DeleteIORequest((struct IORequest *) consoleReadMsg);

	if (consoleReadPort)
	{
		RemPort(consoleReadPort);
		DeleteMsgPort(consoleReadPort);
	}

	if (consoleWriteMsg)
		DeleteIORequest((struct IORequest *) consoleWriteMsg);
	
	if (consoleWritePort)
	{
		RemPort(consoleWritePort);
		DeleteMsgPort(consoleWritePort);
	}

	if (TWind)
		CloseWindow(TWind);
	
	tf = NULL;
	TWind = NULL;
	consoleReadMsg = NULL;
	consoleReadPort = NULL;
	consoleWriteMsg = NULL;
	consoleWritePort = NULL;

	tptflags &= ~T_WINDOW;
#ifdef DO_DEBUG
//   TDebug(1,"CloseWinStuff: Closed window");
#endif
	return;
}
//-

