#define TPT
#define DLG

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include <exec/types.h>
#include <exec/nodes.h>
#include <exec/lists.h>
#include <exec/ports.h>
#include <exec/libraries.h>
#include <exec/devices.h>
#include <exec/io.h>
#include <exec/memory.h>

#include <graphics/display.h>
#include <devices/console.h>
#include <devices/conunit.h>
#include <devices/serial.h>

#include <libraries/dos.h>
#include <libraries/dosextens.h>
#include <libraries/filehandler.h>

#include <devices/tpt.h>
#include <dialog/dlgvers.h>
#include <dialog/portconfig.h>

#include <proto/all.h>
//#include <pragmas/dlg_pragmas.h>

#define Printable(c) ((c<32 || c>126)?FALSE:TRUE)

#define MYPORT_SIG  (1L << ps.myport->mp_SigBit)
#define READSER_SIG (1L << RSPort->mp_SigBit)
#define TIMER_SIG   (1L << Timer_Port->mp_SigBit)
#define CONTROL_SIG (1L << ctrl_port->mp_SigBit)
#define CONSOLE_SIG (1L << consoleReadPort->mp_SigBit)

#define DO_DEBUG 1
//#undef DO_DEBUG

// Main.c
extern UBYTE               BadFlag;
extern ULONG               XORSERIALNUMBER;
extern ULONG               SERIALNUMBER;
extern UBYTE               crcsub;
extern UBYTE               crc;
extern UBYTE               crcofs;

//TDebug.c
extern struct MsgPort     *drport;
extern struct MsgPort     *dport;
extern UBYTE               tdevname[4];

//WriteSer.c
extern UBYTE               whichbuf;
extern UBYTE               mybuf[3][AUXBUFSIZE];
extern UBYTE               outtrans[256];
extern long                tptflags;
extern UBYTE               localflag;
extern struct IOExtSer    *WriteSER;
extern struct IOStdReq    *consoleWriteMsg;
extern SHORT               TScrDepth;
extern struct Screen      *TScrn;

//KillAux.c
extern SHORT               num_kills;

//ReadSer.c
extern struct IOExtSer    *ReadSER;
extern UBYTE               intrans[256];
extern UBYTE               in_c;
extern struct IOStdReq    *consoleReadMsg;
extern UBYTE               cin_c;
extern SHORT               in_len;
extern SHORT               num_times;
extern UBYTE               inline;
extern SHORT               aux_avail;

//CheckPending.c
extern struct timerequest *Timer;
extern struct MsgPort     *Timer_Port;

//CloseWinStuff.c
extern struct TextFont    *tf;
extern struct MsgPort     *consoleWritePort;
extern struct MsgPort     *consoleReadPort;
extern struct Window      *TWind;

//ClosePorts.c
extern struct MsgPort     *ctrl_port;

//CloseSer.c
extern BOOL                SERGOOD;
extern struct MsgPort     *RSPort;
extern struct MsgPort     *WSPort;

//OpenStuff.c
extern SHORT               time_delay;
extern long                controlsig;

//OpenSer.c
extern long                readsersig;

//OpenTimer.c
extern long                timersig;

//OpenWinStuff.c
extern UBYTE               conwrname[14];
extern UBYTE               conrdname[13];
extern struct TextAttr     ta;
extern long                consolesig;
extern char                hackstring[8];

//OpenScrStuff.c
extern UWORD               colortable[8];

//DoPacket.c
extern UBYTE               cursoron;


/* ========------------============------------========= */

extern void                DoPacket(struct TPTPort *);

extern void                InitList(struct List *);

extern struct Node        *FirstNode(struct List *);

extern struct ReaderInfo  *FindReader(struct List *, struct MsgPort *);

extern void                SendBreak(void);

extern BOOL                OpenScrStuff(UBYTE *, struct ScrStruct *);

extern void                WriteCon(UBYTE *, long);

extern BOOL                OpenWinStuff(SHORT, SHORT, SHORT, SHORT, ULONG, UBYTE * ,
                                        struct Screen *, SHORT, SHORT, SHORT,
                                        SHORT, USHORT, UBYTE *, UBYTE);

extern BOOL                OpenTimer(void);

extern BOOL                OpenSer(UBYTE *, ULONG, ULONG);

extern BOOL                OpenLibs(void);

extern BOOL                OpenStuff(UBYTE *, UBYTE, ULONG, UBYTE *);

extern void                CloseSer(void);

extern void                EmptySerBuffer(void);

extern void                CloseTimer(void);

extern void                ClosePorts(void);

extern void                CloseLibs(void);

extern void                CloseScrStuff(void);

extern void                CloseWinStuff(void);

extern void                CheckPending(struct TPTSess *);

extern BOOL                Die(struct TPTSess *);

extern void                set_con_read(void);

extern void                set_read(void);

extern void                putc_both(UBYTE);

extern void                FakeSerString(struct TPTSess *, UBYTE *, int);

extern void                ReadSer(struct TPTSess *, unsigned short);

extern void                KillAux(struct TPTSess *);

extern void                NiceAbort(struct IORequest *);

extern void                WriteSer(UBYTE *, long);

extern void                TDebug(int, char *);

extern void                returnpktplain(struct DosPacket *, struct Process *);
extern void                returnpkt(struct DosPacket *, struct Process *, ULONG, ULONG);
extern struct DosPacket   *taskwait(struct Process *);

