#include "TPT.h"

///   Die()
BOOL                Die(struct TPTSess *sess)
{
	if (tptflags & T_KILL_ENABLE)
	{
		tptflags |= T_KILLED;
		tptflags &= ~T_PAUSED;

		if(!(tptflags & T_FROZEN) && ((tptflags & T_RPEND) || 
			(tptflags & T_WAIT_FOR)))
		{
			KillAux(sess);
			CheckPending(sess);
		}

#ifdef DO_DEBUG
		TDebug(3,"Die() killed port");
#endif
		return (TRUE);
	}

	if (tptflags & T_DO_PEND)
		tptflags |= T_KILL_PEND;

#ifdef DO_DEBUG
	TDebug(3,"Die() did not kill port as requested");
#endif
	return (FALSE);
}
//-

///   KillAux
/* Send ^C to reader task */
void                KillAux(struct TPTSess *sess)
{
	if (++num_kills < 50)
	{
		if (tptflags & T_PAUSED)
		{                          /* We don't want to be paused now */
			tptflags &= ~T_PAUSED;
		}

		if (sess->creader)
		{
			Signal(sess->creader->task, SIGBREAKF_CTRL_C);
#ifdef DO_DEBUG
			TDebug(4, "KillAux: Control-C Sent");
#endif
		}

		if (tptflags & T_WAIT_FOR)
		{
			tptflags &= ~T_WAIT_FOR;
			sess->creader->rdpkt->dp_Res1 = DOS_FALSE;
			returnpktplain(sess->creader->rdpkt, sess->port->myproc);
		}
		else
		{
			ReadSer(sess, 13);
		}
	}
	else
	{
		num_kills = 0;
		FakeSerString(sess, "ENDCLI", 6);
		ReadSer(sess, 13);
#ifdef DO_DEBUG
		TDebug(4, "KillAux: ENDCLI Sent");
#endif
	}
}
//-


