#include "DLGTick.h"

#include <link/io.h>
#include <link/util.h>

BOOL DLGFile(char *TargPath, char *Target, char *Desc, char *Echo,
            ULONG DLGArea, BOOL Ticked, char *TickFile,
            BOOL Replace, BOOL FreeFlag)
{
   BOOL  Replaced = FALSE;

   BPTR  dest = NULL;

   char  AreaPath[100];
   char  DestPath[512];
   char  QFPath[512];
   char  FDPath[512];
   char  Comment[100];

   char  tmp[500];
   char  timestring[50];

   int   i;
   int   timeval;

   long *timeptr=NULL;
   long hi = -1;
   long lo = -1;

   struct File_Header *fh = NULL;
   struct QuickFile *qf;

   ULONG filesize;

   Log("-> DLGFile() -- Upload file to DLG file areas");

   Upper(Target);
   Upper(Echo);

   AFPrintf(NULL,sout,"\t\tUploading file %s to DLG file area %ld\n",Target,DLGArea);
   ASPrintf(NULL,logstring,"   Uploading file %s to DLG file area %ld",Target,DLGArea);
   Log(logstring);

/// check to see if that area physically exists
   ASPrintf(NULL,AreaPath,"FILE:%d",DLGArea);

   if(!Exists(AreaPath))
   {
      AFPrintf(NULL,sout,"DLGTick: Path [%s] doesn't exist for local file area %ld\n",AreaPath,DLGArea);
      Log(" ! DLG file area path doesn't exist. Check your .TIC cfg file and DLG configuration for misspecified LOCALAREA number or path");
      return(FALSE);
   }
//-
/// Get ultimate destination path for file
   strcpy(DestPath,AreaPath);

   i = GetPath(DestPath,DLGArea,NULL,NULL);

   if(i==0)
   {
      AFPrintf(NULL,sout,"\t\tNo alternate path specified for DLG area, using primary path\n");
   }
   
   if(i==-1)
   {
      AFPrintf(NULL,sout,"No such area [%d] for DLG files\n",DLGArea);
      ASPrintf(NULL,logstring," ! No such local area [%ld]. Check DLGMail.TIC",DLGArea);
      Log(logstring);
      return(FALSE);
   }
   
   if(i==1)
   {
      AFPrintf(NULL,sout,"\t\tUsing alternate path for file area\n");
   }
//-

   // move the actual file - if successful, create FD etc.

   strmfn(tmp,NULL,DestPath,Target,NULL);

/// Reject if source and dest are the same
   if(!Stricmp(TargPath,tmp))
   {
      AFPrintf(NULL,sout,"Source and destination for file are identical!\n");
      Log(" ! Source and destination for file are identical!");
      return(FALSE);
   }
//-
/// Reject if file is dupe
   if(Exists(tmp))
   {
      if(Replace == FALSE)
      {
         AFPrintf(NULL,sout,"%s rejected - duplicate\n",Ticked?"Tic":"Hatch");
         ASPrintf(NULL,logstring," ! %s rejected - duplicate",Ticked?"Tic":"Hatch");
         Log(logstring);

         if(Ticked)
            MoveToBad(TickFile,TargPath,Target,"DUPLICATE",Desc,Echo);

         return(FALSE);
      }
      else
      {
         AFPrintf(NULL,sout,"\t\tFile exists -- replacing.\n");
         GetComment(tmp,Comment);
         Replaced = TRUE;
      }
   }
//-
/// Copy file to ultimate destination
   i = Copy(TargPath,tmp);

   if(i != 0)
   {
      Log(" ! Error copying file!");
      AFPrintf(NULL,sout,"** Error copying file! **\n");
      return(FALSE);
   }
//-
/// Set file comment if file was replaced.
   if(Replaced == TRUE)
   {
      SetComment(tmp,Comment);
   }
//-

   FileSize(tmp,&filesize);
   DTG(timestring,TRUE);

   timeval=time(timeptr);

   timeval-=((0x2934bb36-0x1a297934)+(60*60*24));

   // Enter file area so that nothing can lock us out
   EnterArea(DLGArea,FILELOCK);

/// Get and set file pointers
   if(!Replaced)
   {
      GetHiLowFPointers(DLGArea,NULL,&lo,&hi,"DLGTick");

      if(lo<1) lo=1;
      if(hi<lo) hi=0;
      hi++;

      PutHiLowFPointers(DLGArea,NULL,lo,hi,"DLGTick");
   }
//-

   BorrowArea(DLGArea,"DLGTick","Uploading files",0,FILELOCK);

/// Set up file header
   fh = calloc(1,sizeof(struct File_Header));
   
   if(!fh)
   {
      Log(" ! Memory allocation error (file header)!");
      AFPrintf(NULL,sout,"Error allocating memory for file header!!\n");
      return(FALSE);
   }

   strcpy(fh->From,TicArea[AIndex].Uploader);
   strcpy(fh->Filename,Target);
   strcpy(fh->Date,timestring);
   fh->Size=filesize;
   fh->Attribute = FreeFlag;
//-
/// Create file header (*.fd)
   if(Replaced == TRUE)
   {
      strcpy(FDPath,Comment);
   }
   else
   {
      ASPrintf(NULL,FDPath,"File:%ld/%ld.FD",DLGArea,hi);
   }

   dest=Open(FDPath,MODE_NEWFILE);

   if(!dest)
   {
      Log(" ! Error creating file header!");
      return(FALSE);
   }

   Write(dest,fh,sizeof(struct File_Header));
   Flush(dest);
   AFPrintf(NULL,dest,"%s\r",Desc);

   if(TicArea[AIndex].ShowArea == TRUE)
   {
      AFPrintf(NULL,dest,"\rFile echo distribution file in area [%s]\r\r",Echo);
   }

   Close(dest);
   free(fh);

   if(!Replaced) SetComment(tmp,FDPath);
//-
/// Add short desc to file.dat
   ASPrintf(NULL,QFPath,"File:%ld/file.dat",DLGArea);

   qf=calloc(1,sizeof(struct QuickFile));

   if(qf)
   {
      strcpy(qf->filename,Target);

      if(Replaced)
         GetStruct(QFPath,(char *)qf,sizeof(struct QuickFile),36);

      qf->date=timeval;

      if(!Replaced)
         qf->number=hi;

      qf->size=filesize;
      stccpy(qf->desc,Desc,59);

      i = AddStruct(QFPath,(char *)qf,sizeof(struct QuickFile),36);

      free(qf);
   }
//-

   FreeArea(DLGArea,"DLGTick",FILELOCK);

   if(i == -1)
   {
      Log(" ! File.dat entry not written -- freshen file area");
   }

   LeaveArea(DLGArea,FILELOCK);

   return(TRUE);
}


