#include "DLGtick.h"
#include "ivn.h"

#include <link/io.h>

int   UseHatch(char *, char *, char *, char *);


/// Hatch()
Hatch(int argc, char **argv)
{
   int i, rc=0;

   char Object[100] = "";
   char ObjectPath[100] = "";
   char Echo[100] = "";
   char Desc[500] ="";
   char tmp[1000];
   char jgt[20];

   ULONG CRC;


   /* start parsing hatch arguments at 2 */

   if(CheckDLGMAILSTOP())
      return(FALSE);

   Log("-> Hatch()");

   DeleteFile("MASTER");   /* just in case */

/// Parse command line arguments
   if(!Stricmp(argv[2],"USE"))
   {
      if(argc!=4)
      {
         AFPrintf(NULL,sout,"DLGTick: No USE file specified\n");
         Log(" ! No USE file specified!");
         return(FALSE);
      }

      if(!UseHatch(argv[3],ObjectPath,Echo,Desc)) return(FALSE);

   }
   else
   {
      /* assume normal hatching here */

      for(i=2;i<argc;i++)
      {
         if(!Stricmp(argv[i],"FILE"))
         {
            i++;
            if(i<argc) strcpy(ObjectPath,argv[i]);
            Upper(ObjectPath);
         }
         if(!Stricmp(argv[i],"AREA"))
         {
            i++;
            if(i<argc) strcpy(Echo,argv[i]);
            Upper(Echo);
         }
         if(!Stricmp(argv[i],"DESC"))
         {
            i++;
            if(i<argc) strncpy(Desc,argv[i],500);
            Desc[499]=0;
         }
      }
   }
//-

/// Get echo info
   if(strlen(Echo) == 0)
   {
      AFPrintf(NULL,sout,"No area specified to hatch into\n");
      return(FALSE);
   }

   AIndex = GetEcho(Echo);

   if(AIndex == -1)
   {
      AFPrintf(NULL,sout,"Echo %s does not exist!\n",Echo);
      ASPrintf(NULL,logstring," ! Echo [ %s ] does not exist in TIC file!",Echo);
      Log(logstring);
      return(FALSE);
   }
//-

/// Bogus if no filename
   if(strlen(ObjectPath) == 0)
   {
      AFPrintf(NULL,sout,"No filename supplied!\n");
      Log(" ! No filename specified!");
      return(FALSE);
   }

   if(!Exists(ObjectPath))
   {
      AFPrintf(NULL,sout,"File %s not found!\n",ObjectPath);
      ASPrintf(NULL,logstring," ! File [ %s ] not found!",ObjectPath);
      Log(logstring);
      return(FALSE);
   }
//-

   strcpy(Object,FilePart(ObjectPath));

/// Fill in DESC if not supplied
   if(strlen(Desc) == 0)
   {
      Log(" . Description not supplied, making our own");
      strcpy(Desc,"No description provided for this file");
   }
//-

   AFPrintf(NULL,sout,"\tFILE [ %s ]\n",Object);
   AFPrintf(NULL,sout,"\tPATH [ %s ]\n",ObjectPath);
   AFPrintf(NULL,sout,"\tAREA [ %s ]\n",Echo);
   AFPrintf(NULL,sout,"\tDESC [ %s ]\n",Desc);

/// Get CRC
   rc = FileCRC(ObjectPath,&CRC);

   if(!rc)
   {
      AFPrintf(NULL,sout,"CRC check failed!!\n");
      ASPrintf(NULL,logstring," ! CRC check for [ %s ] failed!",ObjectPath);
      Log(logstring);
      return(FALSE);
   }
//-

   AFPrintf(NULL,sout,"\tBuilding MASTER .tic file\n");
   ASPrintf(NULL,tmp,"AREA %s",Echo);
   AppendToTIC(MASTER,tmp);

   ASPrintf(NULL,tmp,"ORIGIN %d:%d/%d",_MyZone,_MyNet,_MyNode);
   AppendToTIC(MASTER,tmp);

   ASPrintf(NULL,tmp,"FROM %d:%d/%d",_MyZone,_MyNet,_MyNode);
   AppendToTIC(MASTER,tmp);

   ASPrintf(NULL,tmp,"FILE %s",Object);
   AppendToTIC(MASTER,tmp);

   ASPrintf(NULL,tmp,"DESC %s",Desc);
   AppendToTIC(MASTER,tmp);

   // Need to get rid of this, but first we need to get the a to x conversion

   // Changed 1-8-97 -- got rid of LToX and now generate a CRC that does not
   // have leading zeros.

   stcl_h(jgt,CRC);
   Upper(jgt);

   ASPrintf(NULL,tmp,"CRC %s",jgt);
   AppendToTIC(MASTER,tmp);

   ASPrintf(NULL,tmp,"CREATED BY %s",ID_STRING);
   AppendToTIC(MASTER,tmp);

   ASPrintf(NULL,tmp,"PATH %d:%d/%d",_MyZone,_MyNet,_MyNode);
   AppendToTIC(MASTER,tmp);

   ASPrintf(NULL,tmp,"SEENBY %d:%d/%d",_MyZone,_MyNet,_MyNode);
   AppendToTIC(MASTER,tmp);

   if(!SendLoop(Object,ObjectPath,Echo,Desc,FALSE,NULL,NULL))
   {
      Log(" ! SendLoop reported error code");
      AFPrintf(NULL,sout,"Hatch processing failed!");
      return(FALSE);
   }

   Log("<- End Hatch()");
   return(TRUE);
}
//-

/// UseHatch
UseHatch(char *directive,char *path,char *area,char *desc)
{
   BPTR fh;
   char tmp[500];

   Log("-> UseHatch()");

   strcpy(path,"");
   strcpy(area,"");
   strcpy(desc,"");

   fh = Open(directive,MODE_OLDFILE);

   if(fh)
   {
      /* got the file open, now what? Need to find keywords
         FILE
         AREA
         DESC
      */

///   Loop through file and get info
      while(FGets(fh,tmp,499))
      {
         char *par[20];
         char *dup;
         int c;

         Chk_Abort();
         strcpy(tmp, stpblk(tmp));
         if (strlen(tmp) == 0)  continue;         // Skip empty lines
         if (!Strnicmp(tmp, ";", 1)) continue;    // Skip comments
         dup = strdup(tmp);
         c = ArgParse(tmp, par, 19);

         if(!Stricmp(par[0],"FILE"))
            strcpy(path,par[1]);

         if(!Stricmp(par[0],"AREA"))
            strcpy(area,par[1]);

///      DESC
         if(!Stricmp(par[0], "DESC"))
         {
            BOOL indesc = FALSE;
            char *d;
            int k;
            int j = 0;

            if(c < 2)
            {
               Close(fh);
               return(FALSE);
            }

            d = strdup(dup);

            for(k=4;k<strlen(dup);k++)
            {
               if(indesc)
               {
                  if((dup[k] == '\n')  || (dup[k] == ';'))
                  {
                     d[j] = '\0';
                     break;
                  }

                  d[j] = dup[k];
                  j++;
               }
               else
               {
                  if( isspace(dup[k]))
                  {
                     continue;
                  }
                  else
                  {
                     indesc = TRUE;
                     d[j] = dup[k];
                     j++;
                  }
               }
            }

            stccpy(desc,d,70);
            continue;
         }
//-
      }
//-

      if(fh) Close(fh);
   }
   else
   {
      return(FALSE);
   }

   Log("<- End UseHatch()");
   return(TRUE);
}
//-
