
/* parsing structure for the global config file */

#ifndef GLOBALCONFIG_H
#include <dlg/globalconfig.h>
#endif

#define GCP_NUMERIC  0
#define GCP_STRING   1

#define GCP_DEFAULT  0
#define GCP_MANDATORY   1
#define GCP_INTERNAL 2
#define GCP_OVERRIDE 3

#define GCP_NOTSET   0
#define GCP_SET      1

/*handler defines*/

#define HND_DEFAULT 0
#define HND_CALLTYPES 1
#define HND_DEBUG 2
#define HND_NOLOG 3
#define HND_STEALTH 4

#define HND_ADDRESS  30
#define HND_POINTNET 31
#define HND_AKA      32
#define HND_ORIGIN   33
#define HND_OPERATOR 34
#define HND_TEAR  35


struct GCParse
{
   int   gcp_offset;
   char *gcp_keyword;         // the keyword for the .cfg file
   int   gcp_handler;         // see above for handler flags (used to process
                              // configuration exceptions
   int   gcp_flag_string;     // flag 1 = string, 0 = numeric
   int   gcp_flag_mandatory;  // flag 1 = mandatory, 0 = use default
   int   gcp_default_numeric;
   char *gcp_default_string;
   int   gcp_set;
   char *gcp_instructions;
};


struct GCParse gcp[]=
{
   {
      (&((struct GConfig *)NULL)->SCREENNAME),
      "PUBSCN_NAME",
      HND_DEFAULT,
      GCP_STRING,
      GCP_DEFAULT,
      0,
      "",
      GCP_NOTSET,
      "Under 2.04, if you specify this name, will open a public screen by this name or use one already open. Omit this entry to use WorkBench."
   },

   {
      (&((struct GConfig *)NULL)->PUBSCNLACE),
      "PUBSCN_LACE",
      HND_DEFAULT,
      GCP_NUMERIC,
      GCP_DEFAULT,
      1,
      NULL,
      GCP_NOTSET,
      "Under 2.04, interlace setting for the public screen (if used). 1=ON."
   },

   {
      (&((struct GConfig *)NULL)->PUBSCNOSCAN),
      "PUBSCN_OSCAN",
      HND_DEFAULT,
      GCP_NUMERIC,
      GCP_DEFAULT,
      0,
      NULL,
      GCP_NOTSET,
      "Under 2.04, whether or not to use default overscan for the public screen (if used). 1=ON."
   },

   {
      (&((struct GConfig *)NULL)->PUBSCNBEHIND),
      "PUBSCN_BEHIND",
      HND_DEFAULT,
      GCP_NUMERIC,
      GCP_DEFAULT,
      0,
      NULL,
      GCP_NOTSET,
      "Under 2.04, open public screen behind all other screens. 1=BEHIND."
   },

   {
      (&((struct GConfig *)NULL)->WIN_X),
      "STATUS_X",
      HND_DEFAULT,
      GCP_NUMERIC,
      GCP_DEFAULT,
      0,
      NULL,
      GCP_NOTSET,
      "The X screen coordinate of where the DLGMail status window will open."
   },

   { (&((struct GConfig *)NULL)->WIN_Y),     "STATUS_Y", HND_DEFAULT,GCP_NUMERIC,GCP_DEFAULT, 15,NULL,GCP_NOTSET,"The Y screen coordinate of where the DLGMail status window will open."},
{ (&((struct GConfig *)NULL)->WIN_WIDTH), "STATUS_WIDTH",   HND_DEFAULT,GCP_NUMERIC,GCP_DEFAULT,640,NULL,GCP_NOTSET,"The width of the status window. Set to 0 for full screen width if STATUS_X is also 0."},

{ (&((struct GConfig *)NULL)->PROCESSWINDOW),   "PROCESSWINDOW",HND_DEFAULT,GCP_NUMERIC,GCP_DEFAULT,   1,NULL,GCP_NOTSET,"Enables the DLGMail mail processing window to be opened. 1=YES."},
{ (&((struct GConfig *)NULL)->PROCESS_X), "PROCESS_X",   HND_DEFAULT,GCP_NUMERIC,GCP_DEFAULT,  0,NULL,GCP_NOTSET,"The X screen coordinate of where the processing monitor window will open."},
{ (&((struct GConfig *)NULL)->PROCESS_Y), "PROCESS_Y",   HND_DEFAULT,GCP_NUMERIC,GCP_DEFAULT,100,NULL,GCP_NOTSET,"The Y screen coordinate of where the processing monitor window will open."},
{ (&((struct GConfig *)NULL)->PROCESS_WIDTH),   "PROCESS_WIDTH",HND_DEFAULT,GCP_NUMERIC,GCP_DEFAULT,640,NULL,GCP_NOTSET,"The width of the process monitor window. Set to 0 for full screen width if PROCESS_X is also 0."},
{ (&((struct GConfig *)NULL)->PROCESS_HEIGHT),  "PROCESS_HEIGHT",HND_DEFAULT,GCP_NUMERIC,GCP_DEFAULT,100,NULL,GCP_NOTSET,"The height of the process monitor window."},

{ (&((struct GConfig *)NULL)->ADDRESS[0]),   "ADDRESS",  HND_ADDRESS,   GCP_STRING,GCP_MANDATORY,0,   "",      GCP_NOTSET,"Your main system 4D address, such as 1:114/52.0"},
{ (&((struct GConfig *)NULL)->OPERATOR),  "OPERATOR", HND_OPERATOR,  GCP_STRING,GCP_MANDATORY,0,   "JOHN DOE", GCP_NOTSET,"The primary system operator's name as used on the BBS."},
{ (&((struct GConfig *)NULL)->CALLTYPES), "CALLTYPES",   HND_CALLTYPES,GCP_STRING,GCP_MANDATORY,0, "NNDNNNNNCCCCCCCCCCCCCCCN",GCP_NOTSET,
"Calltypes for automatic outdial attempts. 24 characters, 1 per hour. C=CRASH, N=NORMAL, D=DIRECT, Z=DIRECT ONLY, -=SKIP HOUR. You MUST define this string for your zone's Zone Mail Hour."},
{ NULL,                 "POINTNET", HND_POINTNET,  GCP_STRING,GCP_DEFAULT,0,  "",      GCP_NOTSET,"If feeding points using the 2D kludge, your system's pointnet address in 4D, such as 1:5252/0.0"},
{ NULL,                 "AKA",      HND_AKA, GCP_STRING,GCP_DEFAULT,0,  "",      GCP_NOTSET,"Other 4D addresses your system may be known by (up to 32)."},
{ (&((struct GConfig *)NULL)->ORIGIN),    "ORIGIN",   HND_ORIGIN, GCP_STRING,GCP_INTERNAL,0, "DLGMail Default Origin String",GCP_NOTSET,"The default origin string put into echomail which may be missing one."},

{ (&((struct GConfig *)NULL)->TDPORT),    "TDPORT",   HND_DEFAULT,GCP_STRING,GCP_DEFAULT,0,     "TrapDoor", GCP_NOTSET,"TrapDoor's ARexx port name as set in TrapDoor.CFG file - case sensitive!."},
{ (&((struct GConfig *)NULL)->TDLOCKNAME),   "TDLOCKNAME",  HND_DEFAULT,GCP_STRING,GCP_DEFAULT,0,     "trapdoor", GCP_NOTSET,"DLG's resource manager lock name for the MAIN TrapDoor port - case sensitive!"},
{ (&((struct GConfig *)NULL)->TDCFGFILE), "TDCFGFILE",   HND_DEFAULT,GCP_STRING,GCP_DEFAULT,0,     "MAIL:TrapDoor.CFG",GCP_NOTSET,"TrapDoor's path and config file for the MAIN TrapDoor port"},
{ (&((struct GConfig *)NULL)->BBSPORT),      "BBSPORT",  HND_DEFAULT,GCP_STRING,GCP_DEFAULT,0,     "TR0",      GCP_NOTSET,"DLG BBS Port (or main port) which you have set to use TrapDoor."},

{ (&((struct GConfig *)NULL)->NETMAILDIR),   "NETMAILDIR",     HND_DEFAULT,GCP_NUMERIC,GCP_MANDATORY,-1,NULL,GCP_NOTSET,"Designates the DLG message area used for netmail. MANDATORY"},
{ (&((struct GConfig *)NULL)->BADMSGSDIR),   "BADMSGSDIR",     HND_DEFAULT,GCP_NUMERIC,GCP_MANDATORY,-1,NULL,GCP_NOTSET,"Designates the DLG message area used for bad messages. MANDATORY"},
{ (&((struct GConfig *)NULL)->ZTASKPRI),  "TASKPRI",     HND_DEFAULT,GCP_NUMERIC,GCP_DEFAULT,-50,NULL,GCP_NOTSET,"The task priority your DLGMail system will run at - set this very low."},
{ (&((struct GConfig *)NULL)->STACKSIZE), "STACKSIZE",      HND_DEFAULT,GCP_NUMERIC,GCP_DEFAULT,12000,NULL,GCP_NOTSET,"Sets the stacksize used by all child processes and executables. Do not set lower than 12,000."},
{ (&((struct GConfig *)NULL)->AUTOCALL),  "AUTOCALL",    HND_DEFAULT,GCP_NUMERIC,GCP_DEFAULT,  600,NULL,GCP_NOTSET,"Sets the number of seconds between automatic outdial attempts. Range 100-1000."},
{ (&((struct GConfig *)NULL)->AUTOCALLZONE), "AUTOCALLZONE",      HND_DEFAULT,GCP_NUMERIC,GCP_DEFAULT,    0,NULL,GCP_NOTSET,"Sets the autocall zone. If left at 0, will autocall all zones."},

{ (&((struct GConfig *)NULL)->TDSPAWN),      "TDSPAWN",     HND_DEFAULT,GCP_NUMERIC,GCP_DEFAULT,   1,NULL,GCP_NOTSET,"Notifies DLGMail that you are spawning the BBS from TrapDoor. 1=SPAWN, 0=EXIT."},
{ (&((struct GConfig *)NULL)->POINTENABLE),  "POINTENABLE",    HND_DEFAULT,GCP_NUMERIC,GCP_DEFAULT,   0,NULL,GCP_NOTSET,"Enables feeding mail to points. 1=YES."},
{ (&((struct GConfig *)NULL)->NOTIFYACTIVEONLY),"NOTIFYACTIVEONLY",  HND_DEFAULT,GCP_NUMERIC,GCP_DEFAULT,   0,NULL,GCP_NOTSET,"Limits user notification to areas where they are active. 1=LIMIT, 0=NOTIFY ALL MAIL."},
{ (&((struct GConfig *)NULL)->LOG),    "VERBOSITY",      HND_DEFAULT,GCP_NUMERIC,GCP_DEFAULT,   1,NULL,GCP_NOTSET,"Verbosity of logging and printing to the screen. Range 0 to 5."},
{ (&((struct GConfig *)NULL)->QUICKLOG),  "QUICKLOG",    HND_DEFAULT,GCP_NUMERIC,GCP_DEFAULT,   0,NULL,GCP_NOTSET,"Enables buffered log writes from DLGImp and DLGExp. 1=ON."},
{ (&((struct GConfig *)NULL)->PKTBUFFERLENGTH), "PKTBUFFERLENGTH",   HND_DEFAULT,GCP_NUMERIC,GCP_DEFAULT,10000,NULL,GCP_NOTSET,"Sets the default smallest packet buffer size to use. Range 10000 - 100000."},
{ (&((struct GConfig *)NULL)->LINKREPLIES),  "LINKREPLIES",    HND_DEFAULT,GCP_NUMERIC,GCP_DEFAULT,   1,NULL,GCP_NOTSET,"Enables linking of echomail message subjects. 1=ON."},
{ (&((struct GConfig *)NULL)->PKTROUTE),  "PKTROUTE",    HND_DEFAULT,GCP_NUMERIC,GCP_DEFAULT,   2,NULL,GCP_NOTSET,"Determines disposition of packets not addressed to your system. 0=KILL, 1=ROUTE, 2=IGNORE PKT ADDRESS AND TOSS."},
{ (&((struct GConfig *)NULL)->NETMAILROUTE), "NETMAILROUTE",      HND_DEFAULT,GCP_NUMERIC,GCP_DEFAULT,   0,NULL,GCP_NOTSET,"Enables the routing of netmail through your system and on to other systems. 1=ON."},
{ (&((struct GConfig *)NULL)->SAVEDAMAGED),  "SAVEDAMAGED",    HND_DEFAULT,GCP_NUMERIC,GCP_DEFAULT,   1,NULL,GCP_NOTSET,"Enables saving damaged packets for later analysis. 1=ON."},
{ (&((struct GConfig *)NULL)->FORCEINTL), "FORCEINTL",      HND_DEFAULT,GCP_NUMERIC,GCP_DEFAULT,   0,NULL,GCP_NOTSET,"Forces the INTL kludge into all outbound netmail, recommended if you operate within multiple domains. 1=FORCE."},

{ (&((struct GConfig *)NULL)->SECUREIMP), "SECUREIMP",      HND_DEFAULT,GCP_NUMERIC,GCP_DEFAULT,   1,NULL,GCP_NOTSET,"Enables security checking on inbound echomail. If enabled, origination address must appear in distribution list. 1=ON."},
{ (&((struct GConfig *)NULL)->NOCALLBUNDLE), "NOCALLBUNDLE",      HND_DEFAULT,GCP_NUMERIC,GCP_DEFAULT,   0,NULL,GCP_NOTSET,"Disables calling during times when DLGBundle is bundling packets. 1=DISABLE CALLING."},
{ (&((struct GConfig *)NULL)->NOCALLPROCESS),   "NOCALLPROCESS",  HND_DEFAULT,GCP_NUMERIC,GCP_DEFAULT,   0,NULL,GCP_NOTSET,"Disables calling during times when any mail processing is going on. 1=DISABLE CALLING."},

{ (&((struct GConfig *)NULL)->LOGLINES),  "LOGLINES",    HND_DEFAULT,GCP_NUMERIC,GCP_DEFAULT,  500,NULL,GCP_NOTSET,"Sets the length limit for all LOGS:*.LOG files when maintenance is done."},

{ (&((struct GConfig *)NULL)->ENABLE_AREAFIX),  "AREAFIX",     HND_DEFAULT,GCP_NUMERIC,GCP_DEFAULT,   0,NULL,GCP_NOTSET,"Enables DLGAreafix to be called automatically when messages to it are detected. 1=ON."},
{ (&((struct GConfig *)NULL)->ENABLE_TICK),  "TICK",
HND_DEFAULT,GCP_NUMERIC,GCP_DEFAULT,   0,NULL,GCP_NOTSET,"Enables DLGTick (or other tick program) when .TIC files are received. 0=IGNORE *.TIC FILES  1=PROCESS *.TIC FILES"},
{ (&((struct GConfig *)NULL)->ENABLE_HUB),   "HUB",         HND_DEFAULT,GCP_NUMERIC,GCP_DEFAULT,   0,NULL,GCP_NOTSET,"Enables DLGHub to be called automatically in the process cycle. 1=ON."},

{ (&((struct GConfig *)NULL)->CHECKDUPES),   "CHECKDUPES",     HND_DEFAULT,GCP_NUMERIC,GCP_OVERRIDE,  1,NULL,GCP_NOTSET,"Enables dupe checking. Internally set ON, not meant to be turned off."},
{ (&((struct GConfig *)NULL)->STRIPAKA1), "STRIPPOINTNET",  HND_DEFAULT,GCP_NUMERIC,GCP_INTERNAL,  0,NULL,GCP_NOTSET,"This is set internally if you have specified the 2D pointnet kludge."},
{ (&((struct GConfig *)NULL)->LOGUSERMESSAGE),  "LOGUSERMESSAGE", HND_DEFAULT,GCP_NUMERIC,GCP_OVERRIDE,  1,NULL,GCP_NOTSET,"Enables user notification of received mail. Not meant to be overridden."},
{ (&((struct GConfig *)NULL)->BORROW),    "BORROW",      HND_DEFAULT,GCP_NUMERIC,GCP_OVERRIDE,  1,NULL,GCP_NOTSET,"Enables area arbitration by TPTRM. Not meant to be overridden."},
{ (&((struct GConfig *)NULL)->NET2USERDIR),  "NET2USERDIR",    HND_DEFAULT,GCP_NUMERIC,GCP_OVERRIDE,  1,NULL,GCP_NOTSET,"Causes netmail to be redirected to user private directories. Not meant to be overridden."},
{ (&((struct GConfig *)NULL)->ACTIVITYLOG),  "ACTIVITYLOG",    HND_DEFAULT,GCP_NUMERIC,GCP_DEFAULT,   0,NULL,GCP_NOTSET,"Creates ACTIVITY.DAT files for each echo area for DLGTrack."},

{ (&((struct GConfig *)NULL)->PCFRIENDLY),   "PCFRIENDLY",     HND_DEFAULT,GCP_NUMERIC,GCP_DEFAULT,   0,NULL,GCP_NOTSET,"Planet Connect friendly mode."},

{ (&((struct GConfig *)NULL)->PCADDRESS), "PCADDRESS",      HND_DEFAULT,GCP_STRING,GCP_DEFAULT, 0,"1:3615/50.0",GCP_NOTSET,"Planet Connect (or similar) address that echomail comes from"},

{ (&((struct GConfig *)NULL)->MyDEBUG),      "DB_ALL",   HND_DEFAULT,GCP_NUMERIC,GCP_DEFAULT,    0,NULL,GCP_NOTSET,"Sets the global debug value for all DLG/DLG executables unless overridden."},
{ (&((struct GConfig *)NULL)->ZPROC_DB),  "DB_DLGMAIL",  HND_DEBUG,GCP_NUMERIC,GCP_INTERNAL, -1,NULL,GCP_NOTSET,"Overrides DB_ALL setting."},
{ (&((struct GConfig *)NULL)->ZIMP_DB),      "DB_IMP",   HND_DEBUG,GCP_NUMERIC,GCP_INTERNAL, -1,NULL,GCP_NOTSET,"Overrides DB_ALL setting."},
{ (&((struct GConfig *)NULL)->ZEXP_DB),      "DB_EXP",   HND_DEBUG,GCP_NUMERIC,GCP_INTERNAL, -1,NULL,GCP_NOTSET,"Overrides DB_ALL setting."},
{ (&((struct GConfig *)NULL)->ZNET_DB),      "DB_NET",   HND_DEBUG,GCP_NUMERIC,GCP_INTERNAL, -1,NULL,GCP_NOTSET,"Overrides DB_ALL setting."},
{ (&((struct GConfig *)NULL)->ZBUNDLE_DB),   "DB_BUNDLE",   HND_DEBUG,GCP_NUMERIC,GCP_INTERNAL, -1,NULL,GCP_NOTSET,"Overrides DB_ALL setting."},
{ (&((struct GConfig *)NULL)->DLGTICK_DB),   "DB_TICK",  HND_DEBUG,GCP_NUMERIC,GCP_INTERNAL, -1,NULL,GCP_NOTSET,"Overrides DB_ALL setting."},
{ (&((struct GConfig *)NULL)->DLGAREAFIX_DB),   "DB_AREAFIX",  HND_DEBUG,GCP_NUMERIC,GCP_INTERNAL, -1,NULL,GCP_NOTSET,"Overrides DB_ALL setting."},
{ (&((struct GConfig *)NULL)->DLGHUB_DB), "DB_HUB",   HND_DEBUG,GCP_NUMERIC,GCP_INTERNAL, -1,NULL,GCP_NOTSET,"Overrides DB_ALL setting."},

{ (&((struct GConfig *)NULL)->NOLOG_ALL), "LOG_ALL",  HND_DEFAULT,GCP_NUMERIC,GCP_DEFAULT,    1,NULL,GCP_NOTSET,"Enables/disables logkeeping for all executables. 1=LOG, 0=NO LOG."},
{ (&((struct GConfig *)NULL)->NOLOG_DLGMAIL),   "LOG_DLGMAIL",HND_NOLOG,GCP_NUMERIC,GCP_INTERNAL,  -1,NULL,GCP_NOTSET,"Overrides LOG_ALL setting."},
{ (&((struct GConfig *)NULL)->NOLOG_IMP), "LOG_IMP",  HND_NOLOG,GCP_NUMERIC,GCP_INTERNAL, -1,NULL,GCP_NOTSET,"Overrides LOG_ALL setting."},
{ (&((struct GConfig *)NULL)->NOLOG_EXP), "LOG_EXP",  HND_NOLOG,GCP_NUMERIC,GCP_INTERNAL, -1,NULL,GCP_NOTSET,"Overrides LOG_ALL setting."},
{ (&((struct GConfig *)NULL)->NOLOG_NET), "LOG_NET",  HND_NOLOG,GCP_NUMERIC,GCP_INTERNAL, -1,NULL,GCP_NOTSET,"Overrides LOG_ALL setting."},
{ (&((struct GConfig *)NULL)->NOLOG_BUNDLE), "LOG_BUNDLE",  HND_NOLOG,GCP_NUMERIC,GCP_INTERNAL, -1,NULL,GCP_NOTSET,"Overrides LOG_ALL setting."},
{ (&((struct GConfig *)NULL)->NOLOG_TICK),   "LOG_TICK", HND_NOLOG,GCP_NUMERIC,GCP_INTERNAL, -1,NULL,GCP_NOTSET,"Overrides LOG_ALL setting."},
{ (&((struct GConfig *)NULL)->NOLOG_AREAFIX),   "LOG_AREAFIX",HND_NOLOG,GCP_NUMERIC,GCP_INTERNAL,  -1,NULL,GCP_NOTSET,"Overrides LOG_ALL setting."},
{ (&((struct GConfig *)NULL)->NOLOG_HUB), "LOG_HUB",  HND_NOLOG,GCP_NUMERIC,GCP_INTERNAL, -1,NULL,GCP_NOTSET,"Overrides LOG_ALL setting."},

{ (&((struct GConfig *)NULL)->STEALTH_DLGMAIL), "SHOW_DLGMAIL",   HND_STEALTH,GCP_NUMERIC,GCP_INTERNAL,  -1,NULL,GCP_NOTSET,"Overrides PROCESSWINDOW setting for this executable. 0=TURN OFF DISPLAY."},
{ (&((struct GConfig *)NULL)->STEALTH_IMP),  "SHOW_IMP", HND_STEALTH,GCP_NUMERIC,GCP_INTERNAL,  -1,NULL,GCP_NOTSET,"Overrides PROCESSWINDOW setting for this executable. 0=TURN OFF DISPLAY."},
{ (&((struct GConfig *)NULL)->STEALTH_EXP),  "SHOW_EXP", HND_STEALTH,GCP_NUMERIC,GCP_INTERNAL,  -1,NULL,GCP_NOTSET,"Overrides PROCESSWINDOW setting for this executable. 0=TURN OFF DISPLAY."},
{ (&((struct GConfig *)NULL)->STEALTH_NET),  "SHOW_NET", HND_STEALTH,GCP_NUMERIC,GCP_INTERNAL,  -1,NULL,GCP_NOTSET,"Overrides PROCESSWINDOW setting for this executable. 0=TURN OFF DISPLAY."},
{ (&((struct GConfig *)NULL)->STEALTH_BUNDLE),  "SHOW_BUNDLE", HND_STEALTH,GCP_NUMERIC,GCP_INTERNAL,  -1,NULL,GCP_NOTSET,"Overrides PROCESSWINDOW setting for this executable. 0=TURN OFF DISPLAY."},
{ (&((struct GConfig *)NULL)->STEALTH_TICK), "SHOW_TICK",   HND_STEALTH,GCP_NUMERIC,GCP_INTERNAL,  -1,NULL,GCP_NOTSET,"Overrides PROCESSWINDOW setting for this executable. 0=TURN OFF DISPLAY."},
{ (&((struct GConfig *)NULL)->STEALTH_AREAFIX), "SHOW_AREAFIX",   HND_STEALTH,GCP_NUMERIC,GCP_INTERNAL,  -1,NULL,GCP_NOTSET,"Overrides PROCESSWINDOW setting for this executable. 0=TURN OFF DISPLAY."},
{ (&((struct GConfig *)NULL)->STEALTH_HUB),  "SHOW_HUB", HND_STEALTH,GCP_NUMERIC,GCP_INTERNAL,  -1,NULL,GCP_NOTSET,"Overrides PROCESSWINDOW setting for this executable. 0=TURN OFF DISPLAY."},

{ (&((struct GConfig *)NULL)->TEAR),      "TEAR",     HND_TEAR,GCP_STRING,GCP_OVERRIDE,0, "--- DLGMail", GCP_NOTSET,"Internally set default tearline. Not meant to be overridden."},


{ (&((struct GConfig *)NULL)->ARCHIVER[zgc_ARC][zgc_ADD]),  "ARCADD",   HND_DEFAULT,GCP_STRING,GCP_DEFAULT,0,"c:ARC M OUTBOUND:%s OUTBOUND:%s",GCP_NOTSET,"String used to create ARC mail bundles."},
{ (&((struct GConfig *)NULL)->ARCHIVER[zgc_ARC][zgc_EXTRACT]), "ARCEXTRACT",  HND_DEFAULT,GCP_STRING,GCP_DEFAULT,0,"c:PKXARC -r %s",GCP_NOTSET,"String used to extract ARC mail bundles."},
{ (&((struct GConfig *)NULL)->ARCHIVER[zgc_ZOO][zgc_ADD]),  "ZOOADD",   HND_DEFAULT,GCP_STRING,GCP_DEFAULT,0,"c:ZOO aq:M OUTBOUND:%s OUTBOUND:%s",GCP_NOTSET,"String used to create ZOO mail bundles."},
{ (&((struct GConfig *)NULL)->ARCHIVER[zgc_ZOO][zgc_EXTRACT]), "ZOOEXTRACT",  HND_DEFAULT,GCP_STRING,GCP_DEFAULT,0,"c:ZOO xSO %s",GCP_NOTSET,"String used to extract ZOO mail bundles."},
{ (&((struct GConfig *)NULL)->ARCHIVER[zgc_ZIP][zgc_ADD]),  "ZIPADD",   HND_DEFAULT,GCP_STRING,GCP_DEFAULT,0,"c:ZIP -k -s -q OUTBOUND:%s OUTBOUND:%s",GCP_NOTSET,"String used to create ZIP mail bundles."},
{ (&((struct GConfig *)NULL)->ARCHIVER[zgc_ZIP][zgc_EXTRACT]), "ZIPEXTRACT",  HND_DEFAULT,GCP_STRING,GCP_DEFAULT,0,"c:UNZIP %s",GCP_NOTSET,"String used to extract ZIP mail bundles."},
{ (&((struct GConfig *)NULL)->ARCHIVER[zgc_ARJ][zgc_ADD]),  "ARJADD",   HND_DEFAULT,GCP_STRING,GCP_DEFAULT,0,"",GCP_NOTSET,"String used to create ARJ mail bundles. THIS ARCHIVER DOES NOT EXIST AS OF COMPILE TIME"},
{ (&((struct GConfig *)NULL)->ARCHIVER[zgc_ARJ][zgc_EXTRACT]), "ARJEXTRACT",  HND_DEFAULT,GCP_STRING,GCP_DEFAULT,0,"c:UNARJ e -y %s",GCP_NOTSET,"String used to extract ARJ mail bundles."},
{ (&((struct GConfig *)NULL)->ARCHIVER[zgc_LZH][zgc_ADD]),  "LZHADD",   HND_DEFAULT,GCP_STRING,GCP_DEFAULT,0,"c:lha -0 -N m OUTBOUND:%s OUTBOUND:%s",GCP_NOTSET,"String used to create LZH mail bundles."},
{ (&((struct GConfig *)NULL)->ARCHIVER[zgc_LZH][zgc_EXTRACT]), "LZHEXTRACT",  HND_DEFAULT,GCP_STRING,GCP_DEFAULT,0,"c:lha -m x %s",GCP_NOTSET,"String used to extract LZH mail bundles."},
{ (&((struct GConfig *)NULL)->ARCHIVER[zgc_LHA][zgc_ADD]),  "LHAADD",   HND_DEFAULT,GCP_STRING,GCP_DEFAULT,0,"c:lha -2 -N m OUTBOUND:%s OUTBOUND:%s",GCP_NOTSET,"String used to create LHA mail bundles."},
{ (&((struct GConfig *)NULL)->ARCHIVER[zgc_LHA][zgc_EXTRACT]), "LHAEXTRACT",  HND_DEFAULT,GCP_STRING,GCP_DEFAULT,0,"c:lha -m x %s",GCP_NOTSET,"String used to extract LHA mail bundles."},



{ 0, "",0,0,0,0,NULL,0}
};

