#include <exec/types.h>
#include <stdio.h>
#include <libraries/dos.h>
#include <string.h>
#include <proto/exec.h>
#include "zexport.h"
#include "zmeglobals.h"
#include "/zflavor/flavorproto.h"
#include "ivn.h"

#include <link/io.h>

#define NEWROSSAREAS 1 // to use the new areas code
#define ZMAIL_NAME_FORMAT  1

BOOL WEEXPORTED=FALSE;
struct areas *a;
char logstring[3000];
int BORROWED_AREA=0;
BOOL EXPORTLIMITFLAG=1;
BPTR ZMAILEXPfile=NULL;
struct GConfig *GCFG;

int EXPORTMODE;

long __stack=50000L;
char *_procname="DLGMail Exporter";
long __priority=-11;


extern struct Library *DLGBase = NULL;
extern BPTR sout = NULL;

/// AddressToZone
int AddressToZone(char *input)
{
   char zone[10], net[10], node[10], point[10];
   
   strsfn(input,zone,net,node,point);

   return(atoi(zone));
}
//-

/// AddressToNet
int AddressToNet(char *input) 
{
   char zone[10], net[10], node[10], point[10];
   
   strsfn(input,zone,net,node,point);

   return(atoi(net));
}
//-

/// AddressToNode
int AddressToNode(char *input)
{
   char zone[10], net[10], node[10], point[10];
   
   strsfn(input,zone,net,node,point);

   return(atoi(node));
}
//-

/// AddressToPoint
int AddressToPoint(char *input)
{
   char zone[10], net[10], node[10], point[10];
   
   strsfn(input,zone,net,node,point);

   return(atoi(point));
}
//-

/// QuietExit
void QuietExit()
{
   if(PKTHEADSTRUCT) free(PKTHEADSTRUCT);

   if(ZMAILEXPfile)
   {
      Close(ZMAILEXPfile); ZMAILEXPfile=NULL;

      DeleteFile("FIDO:DLGMail.EXP");
   }

   Log("<- DLGExp Exit\n");

   exit(0);
}
//-

/// MyBorrowArea
int MyBorrowArea(long number)
{
   int j;

   if(_BORROW==NULL || MSGAREAPASSTHRU) return(0);

   j=BorrowArea((short)number,"DLGExp","Exporting",64,MSGLOCK);
   return(j);
}
//-

/// UnBorrowArea
int UnBorrowArea(long number)
{
   int j;

   if(_BORROW==NULL || MSGAREAPASSTHRU) return(0);

   j=FreeArea((short)number,"DLGExp",(short)MSGLOCK);
   return(j);
}
//-

char DLGSerial[8];

/// Main
int main(int argc, char **argv)
{
   int rc;
   BPTR fp;
   char buf[20];

   sout = Output();

   DLGBase = OpenLibrary("dlg.library",2L);
   
   if(DLGBase==NULL)
   {
      FPuts(sout,"No DLG.library - Exiting\n");
      exit(20);
   }

   if(argc<2) exit(20);

   if(!Stricmp(argv[1],"BACKGROUND"))
      EXPORTMODE=1;

   GCFG=NULL;

   if(fp=Open("ENV:GCFG",MODE_OLDFILE))
   {
      FGets(fp,buf,16);
      Close(fp);
   }

   GCFG=(struct GConfig *)atoi(buf);

   if(GCFG==NULL)
   {
      AFPrintf(NULL,sout,"No GCFG - Exiting\n");
      exit(20);
   }

   if((GCFG->MARKER1 != 5551212) || (GCFG->MARKER2 != 5551212))
   {
      AFPrintf(NULL,sout,"GCFG Marker Failure\n");
      exit(20);
   }

   PKTHEADSTRUCT=(void *)calloc(PKTHEADLENGTH,1);

   if(!PKTHEADSTRUCT)
   {
      AFPrintf(NULL,sout,"No mem for packet head struct\n");
      exit(20);
   }

// new March 1995

   // the serial number is read but nothing is done with it. the serial
   // number is read at DLGmail startup and that is used...

   fp=Open("DLGConfig:misc/dlgserial",MODE_OLDFILE);

   if(fp)
   {
      FGets(fp,DLGSerial,6);
      Close(fp);
      DLGSerial[6]=0;
   }

// end new

   _RETURNCODE=0;

// SetZTaskPri();

   AFPrintf(NULL,sout,"%s\n\n",ID_STRING);
   ASPrintf(NULL,logstring,"-> %s",ID_STRING);
   Log(logstring);

   a=_ROSSAREAS;

   Log("-> Areas confirmed");

   EXPORTLIMITFLAG=TRUE;
   
   if(EXPORTMODE==0) // old way
   {
      ZMAILEXPfile=Open("FIDO:DLGMail.EXP",MODE_OLDFILE);

      if(!ZMAILEXPfile)
      {
         if(MyDEBUG) AFPrintf(NULL,sout,"No FIDO:DLGMail.EXP to export from\n");
         EXPORTLIMITFLAG=FALSE;
      }
      else
      {
         if(_VERBOSITY)
            Log(" . Exporting using FIDO:DLGMail.EXP limit file");
      }

      rc=AreaLoop();

      Close(ZMAILEXPfile); ZMAILEXPfile = NULL;
   }
   else
   {
      Log("!! Error: we should not be using EXPORTMODE != 0!!!");
   }


   if(rc==0)
   {
      if(MyDEBUG) AFPrintf(NULL,sout,"Creating legitimate packets\n");
      rc=FileToPKT(0);
      if(MyDEBUG) AFPrintf(NULL,sout,"FileToPKT returned %d\n",rc);
   }

   exportreport();

   QuietExit();

   return(0);
}
//-

/// LogImported
/***** WARNING --- CHANGE IN THIS ROUTINE---------------------------------------vvvvvvv */

int LogImported(int imported,int exported,int totnodes,char *path,char *tagname,int classno)
{
   BPTR fh;
   struct EchoLog *el;
   int i,magic;
   char file[50];
   UBYTE clock[10],date,month;
   UWORD year;

   getclk(clock);

   year =clock[1]+1980;
   month=clock[2];
   date =clock[3];

   magic=month*32+date;
   
   ASPrintf(NULL,file,"%s%s",path,ECHOLOGNAME);

   el=(void *)calloc(sizeof(struct EchoLog),1);

   if(el)
   {
      fh=Open(file,MODE_OLDFILE);

      if(fh)
      {
         i=Read(fh,el,sizeof(struct EchoLog));
      }
      
/* new */

      if(el->el_daily[magic].d_recorddate.od_year != year)
      {
         el->el_daily[magic].d_imported=0;
         el->el_daily[magic].d_exported=0;
         el->el_daily[magic].d_totexported=0;
         el->el_daily[magic].d_totnodes=0;
      }
      
/* end new */     

      el->el_daily[magic].d_recorddate.od_year=year;
      el->el_daily[magic].d_recorddate.od_month=month;
      el->el_daily[magic].d_recorddate.od_date=date;

      el->el_daily[magic].d_imported+=imported;
      el->el_daily[magic].d_exported+=exported;
      el->el_daily[magic].d_totexported+=(exported*totnodes);
      el->el_class=(UWORD)classno;

      if(el->el_daily[magic].d_totnodes<totnodes)
         el->el_daily[magic].d_totnodes=totnodes;

      if(imported)
      {
         el->el_lastimported.od_year=year;
         el->el_lastimported.od_month=month;
         el->el_lastimported.od_date=date;
      }

      if(exported)
      {
         el->el_lastexported.od_year=year;
         el->el_lastexported.od_month=month;
         el->el_lastexported.od_date=date;
      }

      if(!fh)
      {
         /* fill in structures for first time */

         strcpy(el->el_tagname,tagname);

         el->el_created.od_year=year;
         el->el_created.od_month=month;
         el->el_created.od_date=date;


         fh=Open(file,MODE_NEWFILE);
      }

      if(fh)
      {
         /*safe to write*/
         Seek(fh,0,OFFSET_BEGINNING);
         i=Write(fh,el,sizeof(struct EchoLog));
         Close(fh);
      }
   }

   return(0);
}
//-
